<?php
 /**
   * The template for Blog.
   * Template Name: Blog
   *
   * @package   igor WordPress Theme
   * @copyright  Copyright (C) 2016, OrdaSoft
   * @license      http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * igor is distributed under the terms of the GNU GPL
*/
$sidebar_left = false;
if (is_active_sidebar( 'sidebar_left' ) ) {
    $sidebar_left = true;
}

igor_header();
?>
<div id="main" class="site-main">
    <div id="blog-sidebar" class="site-content">
        <?php the_title( '<h2 class="page-title">', '</h2>' ); ?>

        <div class="row">

            <?php if (is_active_sidebar( 'sidebar_left' ) ) : ?>
            <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                <article id="sidebar-left" class="sidebar">
                <?php  dynamic_sidebar('sidebar_left'); ?>
                </article>
            </div>
            <?php endif; ?>


            <?php if($sidebar_left) :
                echo ('<div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">');
                echo ('<div class="blog">');
            else :
                echo ('<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">');
                echo ('<div class="blog container">');
            endif; ?>
                <?php
                    $published_posts = wp_count_posts()->publish;
                    //$posts_per_page = 6;
                    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                    $args=array(
                        'paged'=>$paged,
                        'posts_per_page'=>$posts_per_page,
                    );
                    $igor_query = null;
                    $igor_query = new WP_Query($args);
                        if( $igor_query->have_posts() ) {
                        $position = 0;
                            while( $igor_query->have_posts() ){ $igor_query->the_post();
                            if ( $position % 1==0 ) {
                            $image_id = get_post_thumbnail_id();
                            $image_url = wp_get_attachment_image_src($image_id,800,800);
                            $image_url = $image_url[0];
                             $position++;
                            if ($position != 0 and $position % 1==0) { ?>
                            <section class="loop-item <?php if ($position != 0 and $position%2==0) :
                                                                        echo 'two-post';
                                                                        elseif($position != 0 and $position%3==0) :
                                                                        echo 'tree-post';
                                                                        else :
                                                                        echo 'one-post';
                                                                        endif;?>" style="background: url(<?php echo "$image_url"; ?>)">
                            <?php } ?>

                                <?php get_template_part( 'template-parts/content', get_post_format() ); ?>

                            </section>
                            <?php } ?>
                        <?php } ?>

                    <?php  wp_reset_postdata();
                        } else {
                            get_template_part( 'template-parts/content', 'none' );
                        } ?>

                    </div>
                </div>

        </div><!--row end-->

        <div class="pagination">
            <?php  
            igor_pagenavi($published_posts,$posts_per_page); ?>
        </div>

    </div>
</div><!-- #main -->
<?php get_footer(); ?>