<?php
/**
   * The template for Header.
   *
   *
   * @package   igor WordPress Theme
   * @copyright Copyright (C) 2016, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * igor is distributed under the terms of the GNU GPL
*/
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div id="page-preloader">
    <div class="sk-folding-cube">
      <div class="sk-cube1 sk-cube"></div>
      <div class="sk-cube2 sk-cube"></div>
      <div class="sk-cube4 sk-cube"></div>
      <div class="sk-cube3 sk-cube"></div>
    </div>
</div>
    <div id="site" class="hfeed site">
        <header id="header" class="header">
            <div class="top-section-fixed"></div>
            <div class="right-section-fixed"></div>
            <div class="bottom-section-fixed"></div>
            <div class="left-section-fixed"></div>

            <div class="row for-menu-fixed">
                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 logo-img">
                <?php
                 igor_the_custom_logo();
                    if ( is_front_page() && is_home() ) : ?>
                        <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo(  'name' ); ?></a></h1>
                    <?php else : ?>
                        <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                    <?php endif;

                    $description = get_bloginfo( 'description', 'display' );
                    if ( $description || is_customize_preview() ) : ?>
                        <p class="site-description"><?php echo $description; ?></p>
                <?php endif; ?>
                </div>
                <div class="col-lg-10 col-md-10 col-sm-12 col-xs-12">
                    <div class="theme menu-container">

                        <div id="navbar" class="navbar">
                            <nav id="primary-navigation" class="site-navigation primary-navigation" role="navigation">
                            <button class="menu-toggle"><i class="fa fa-navicon" aria-hidden="true"></i></button>
                                <a class="screen-reader-text skip-link" href="#content"><?php _e( 'Skip to content', 'igor' ); ?></a>
                                <?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'nav-menu' ) ); ?>
                            </nav><!-- #site-navigation -->
                        </div><!-- #navbar -->
                    </div>
                </div>
            </div>
            <div class="social-left-fixed">
                <?php get_template_part( 'template-parts/social' ); ?>
            </div>

            <div class="go-top-fixed">
                <a class="top-up" href="#">
                    <i class="fa fa-angle-double-down" aria-hidden="true"></i>
                </a>
            </div>

        </header><!-- header -->