<?php
/**
   * The template for Header.
   *
   *
   * @package   igor WordPress Theme
   * @copyright Copyright (C) 2016, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * igor is distributed under the terms of the GNU GPL
*/
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<!--<![endif]-->

<head>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

    <div id="page-preloader">
        <div class="sk-folding-cube">
          <div class="sk-cube1 sk-cube"></div>
          <div class="sk-cube2 sk-cube"></div>
          <div class="sk-cube4 sk-cube"></div>
          <div class="sk-cube3 sk-cube"></div>
        </div>
    </div>

    <div id="site" class="hfeed site">
        <header id="header" class="header">
            <div class="top-section"></div>
            <div class="right-section"></div>
            <div class="bottom-section"></div>
            <div class="left-section"></div>

            <div class="row for-menu">
                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 logo-img">
                <?php
                 igor_the_custom_logo();
                    if ( is_front_page() && is_home() ) : ?>
                    <h1 class="site-title">
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo(  'name' ); ?></a>
                    </h1>
                    <?php else : ?>
                    <h1 class="site-title">
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
                    </h1>
                    <?php endif;
                    $description = get_bloginfo( 'description', 'display' );
                    if ( $description || is_customize_preview() ) : ?>
                    <p class="site-description"><?php echo $description; ?></p>
                    <?php endif; ?>
                </div>
                <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                    <div class="theme menu-container">
                        <div id="navbar" class="navbar">
                            <nav id="primary-navigation" class="site-navigation primary-navigation" role="navigation">
                                <button class="menu-toggle"><i class="fa fa-navicon" aria-hidden="true"></i></button>
                                <a class="screen-reader-text skip-link" href="#content"><?php _e( 'Skip to content', 'igor' ); ?></a>
                                <?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'nav-menu' ) ); ?>
                            </nav><!-- #site-navigation -->
                        </div><!-- #navbar -->
                    </div>
                </div>
            </div>

            <div class="social-left">
                <?php get_template_part( 'template-parts/social' ); ?>
            </div>

            <?php if ( get_header_image() ) : ?>
            <div class="header-top" style="background-image:url(<?php header_image(); ?>);">
                <div class="overlay-header"></div>
            <?php else : ?>
            <div class="header-top" style="background-image:url(<?php echo get_template_directory_uri(); ?>/images/header.jpg);">
                <div class="overlay-header"></div>
            <?php endif; ?>
            </div>

            <div class="header-content">
                <h1 class="header-title">
                    <span class="top-text"><?php echo esc_html(get_theme_mod( 'igor_header_title_top' ,'Your')); ?></span><br/>
                    <span class="color-text"><?php echo esc_html(get_theme_mod( 'igor_header_title_center','Life' )); ?></span><br/>
                    <span class="bottom-text"><?php echo esc_html(get_theme_mod( 'igor_header_title_bottom','in Focus' )); ?></span>
                </h1>
                <div class="button-group">
                    <a class="button-about" href="#home-content">What are <span class="text-red">we</span> doing?</a>
                </div>
            </div>

            <div class="go-bottom">
                <a class="top-up" >
                    <i class="fa fa-angle-double-down" aria-hidden="true"></i>
                </a>
            </div>

        </header><!-- header -->