<?php
/**
   * The template for Content None.
   *
   *
   * @package   igor WordPress Theme
   * @copyright Copyright (C) 2016, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * igor is distributed under the terms of the GNU GPL
   */
?>
<header class="page-header">
    <h1 class="page-title"><?php _e( 'Nothing Found', 'igor' ); ?></h1>
</header>

<div class="page-content">
    <?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

    <p><?php printf( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'igor' ), admin_url( 'post-new.php' ) ); ?></p>

    <?php elseif ( is_search() ) : ?>

    <p><?php _e( 'Sorry, but nothing matched your search terms. Please try again with different keywords.', 'igor' ); ?></p>
    <?php get_search_form(); ?>

    <?php else : ?>

    <p><?php _e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'igor' ); ?></p>
    <?php get_search_form(); ?>

    <?php endif; ?>
</div><!-- .page-content -->
