<?php
/**
   * The template for Author.
   *
   *
   * @package    igor WordPress Theme
   * @copyright  Copyright (C) 2016, OrdaSoft
   * @license      http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * igor is distributed under the terms of the GNU GPL
*/
 $sidebar_left = false;
if (is_active_sidebar( 'sidebar_left' ) ) {
    $sidebar_left = true;
}

igor_header();
?>
<div id="main" class="site-main">
    <div id="author" class="site-content">

        <div class="row">
        <?php if (is_active_sidebar( 'sidebar_left' ) ) : ?>
            <div class="widgets col-lg-4 col-md-4 col-sm-4 col-xs-12">
                <article id="sidebar-left" class="sidebar">
                <?php  dynamic_sidebar('sidebar_left'); ?>
                </article>
            </div>
        <?php endif; ?>

        <?php if($sidebar_left) :
            echo ('<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">');
            echo ('<div class="author">');
        else :
            echo ('<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">');
            echo ('<div class="author container">');
        endif; ?>
            <h2 class="page-title">
            <?php printf( __( 'All posts by %s', 'igor' ), '<span class="vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" title="' . esc_attr( get_the_author() ) . '" rel="me">' . get_the_author() . '</a></span>' ); ?>
            </h2>

            <?php if ( get_the_author_meta( 'description' ) ) :
                get_template_part( 'author-bio' );
            endif; ?>

                <?php $position = 0; ?>
                <?php if ( have_posts() ) : ?>
                    <?php while ( have_posts() ) : the_post();
                         if ( $position % 1==0 ) { ?>
                        <div class="row">
                        <?php } ?>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 loop-item">
                            <?php get_template_part( 'template-parts/content', get_post_format() ); ?>
                            </div>
                        <?php $position++;
                            if ($position != 0 and $position % 1==0) { ?>
                        </div>
                        <?php } ?>

                   <?php endwhile; ?>

                <?php  the_posts_pagination();

                 else :

                    get_template_part( 'template-parts/content', 'none' );

                 endif; ?>
                </div>
            </div>

        </div>

    </div>
</div><!-- #main -->
<?php get_footer(); ?>