<?php
 /**
   * The template for Home page.
   * Template Name: Home
   *
   * @package   igor WordPress Theme
   * @copyright Copyright (C) 2016, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * igor is distributed under the terms of the GNU GPL
   */
$sidebar_left = false;
if (is_active_sidebar( 'sidebar_left' ) ) {
    $sidebar_left = true;
}

$sidebar_right = false;
if (is_active_sidebar( 'sidebar_right' ) ) {
    $sidebar_right = true;
}

$content_top = false;
if (is_active_sidebar( 'content_top' ) ) {
    $content_top = true;
}

igor_header_home()
?>

<div id="main" class="site-main">

        <!--  Widget top content -->

        <div class="row">
            <?php if (is_active_sidebar( 'content_top' ) ) : ?>
            <div class="col-lg-12">
                <article id="content-top">
                    <?php  dynamic_sidebar('content_top'); ?>
                </article>
            </div>
            <?php endif; ?>
        </div>

       <!--  Home page content -->

       <div id="home-content" class="home-content" style="<?php echo esc_attr(get_theme_mod( 'igor_content_show' )); ?>">
            <div class="gradient-block"></div>
            <div class="content-block">
          <?php  $home_query = new WP_Query( 'pagename=home' );
            while ( $home_query->have_posts() ) : $home_query->the_post(); ?>
                <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <?php the_content(); ?>
                </div>
                <?php endwhile;
                 wp_reset_postdata(); ?>
            </div>
        </div>

        <!--  Last post on home page -->

        <div class="blog-content">
            <?php get_template_part( 'template-parts/loop' ); ?>
        </div>

        <!--  services -->

        <div id="services" class="services">
        <div class="services-overlay"></div>
        <div class="services-overlay1"></div>
            <div class="services-content-top">
                <h2 class="services-title"><span class="text-red"><?php _e('We', 'igor'); ?></span> <?php _e('offer services', 'igor'); ?></h2>
                <p class="services-desc">All <span class="text-red">our services</span> are helping to build business.<br/>
                Excepteur sint occaecat <span class="text-red">cupidatat non proident</span>, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
            </div>

            <?php get_template_part( 'template-parts/services' ); ?>
        </div>

        <!--  shop -->

        <div id="shop-section" class="" style="<?php echo esc_attr(get_theme_mod( 'igor_shop_show', 'display:none' )); ?>;">
            <div class="gradient-block"></div>
            <h2 class="shop-title">
                <?php if (get_theme_mod( 'igor_home_shop_title' )) :
                    echo esc_attr(get_theme_mod( 'igor_home_shop_title' ));
                else :
                    echo __('Last Products', 'igor');
                endif; ?>
            </h2>
            <div class="store">
                <div class="row">
                <?php get_template_part( 'template-parts/products' ); ?>
                </div>
            </div>
        </div>

        <div id="our-works">
                <div class="works-img">
                <?php get_template_part( 'template-parts/gallery' ); ?>
                </div>
                <div class="works-content">
                    <div class="works-overlay"></div>
                    <a href="?page_id=89" class="works_title"><h2 class="works-title">Our <span class="text-red">works</span></h2></a>
          <p class="works-desc">It is only a small part of all <a href="?page_id=89" class="works_sub_title"><span class="text-red">our works</span></a>. In order to view more, go to our website at the link above or <span class="text-red">contact us</span>.</p>
                    <div class="button-group">
                        <a class="our-site button" href="<?php echo get_page_link( 148 ); ?>">About us</a>
                        <a class="contact-us button" href="#pre-footer">Contact us</a>
                    </div>
                </div>
        </div>


        <div id="any-section" style="<?php echo esc_attr(get_theme_mod( 'igor_any_section_show', 'display:none' )); ?>;">
                    <h2 class="any-title"><?php echo esc_attr(get_theme_mod( 'igor_any_section_title', '' )); ?></h2>
                    <p class="any-desc">ANY SECTION SPECIAL designed to display any shortcodes plugins</p>
        <?php echo do_shortcode(get_theme_mod( 'igor_any_shortcode')); ?>
        </div>

        <div id="pre-footer" class="pre-footer">
            <div class="pre-footer-overlay"></div>
            <div class="pre-footer-gradient"></div>
        <?php
        $content_bottom = false;
        if (is_active_sidebar( 'content_bottom' ) ) {
        $content_bottom = true;
        }
        $content_bottom_left = false;
        if (is_active_sidebar( 'content_bottom_left' ) ) {
        $content_bottom_left = true;
        }
        $content_bottom_right = false;
        if (is_active_sidebar( 'content_bottom_right' ) ) {
            $content_bottom_right = true;
        } ?>
        <div class="row">
     <?php if ( $content_bottom ) : ?>
            <div class="<?php if ( $content_bottom && $content_bottom_left && $content_bottom_right ) :
                    echo ('col-lg-4 col-md-4 col-sm4 col-xs-12 widgets');
                    elseif ( $content_bottom && $content_bottom_left || $content_bottom && $content_bottom_right ) :
                    echo ('col-lg-6 col-md-6 col-sm-6 col-xs-12 widgets');
                    else :
                    echo ('col-lg-12 col-md-12 col-sm-12 col-xs-12 widgets');
                    endif; ?>">
                <?php dynamic_sidebar('content_bottom'); ?>
            </div>
            <?php endif; ?>
            <?php if ( $content_bottom_left ) : ?>
            <div class="<?php if ( $content_bottom && $content_bottom_left && $content_bottom_right ) :
                    echo ('col-lg-4 col-md-4 col-sm4 col-xs-12 widgets');
                    elseif ( $content_bottom && $content_bottom_left || $content_bottom_left && $content_bottom_right ) :
                    echo ('col-lg-6 col-md-6 col-sm-6 col-xs-12 widgets');
                    else :
                    echo ('col-lg-12 col-md-12 col-sm-12 col-xs-12 widgets');
                    endif; ?>">
                <?php  dynamic_sidebar( 'content_bottom_left' ); ?>
            </div>
            <?php endif; ?>
            <?php if ( $content_bottom_right ) : ?>
            <div class="<?php if ( $content_bottom && $content_bottom_left && $content_bottom_right ) :
                    echo ('col-lg-4 col-md-4 col-sm4 col-xs-12 widgets');
                    elseif ( $content_bottom && $content_bottom_right || $content_bottom_left && $content_bottom_right ) :
                    echo ('col-lg-6 col-md-6 col-sm-6 col-xs-12 widgets');
                    else :
                    echo ('col-lg-12 col-md-12 col-sm-12 col-xs-12 widgets');
                    endif; ?>">
                <?php  dynamic_sidebar( 'content_bottom_right' );  ?>
            </div>
            <?php endif; ?>
        </div>
    </div>

</div>
<?php get_footer(); ?>