<?php
/**
 * Additional custom styling of the templates
 *
 * @package WordPress
 * @subpackage riddle
 * @since 1.0
 */
function riddle_customize_css() {
    ?>
    <style>
    	body {
            color:<?php echo esc_attr(get_theme_mod( 'riddle_font_color', '#333' )); ?>;
            font-family:<?php echo esc_attr(get_theme_mod( 'riddle_body_font', 'Nunito Sans, sans-serif' )); ?>;
            font-size:<?php echo esc_attr(get_theme_mod( 'riddle_font_size', '14' )); ?>px;
        }
        #site-navigation .menu li a {
            font-size:<?php echo esc_attr(get_theme_mod( 'riddle_menu_font_size', '14' )); ?>px;
            color:<?php echo esc_attr(get_theme_mod( 'riddle_menu_color', '#333' )); ?>;
            text-decoration:<?php echo esc_attr(get_theme_mod( 'riddle_menu_underline', 'none;' )); ?>;
            font-family:<?php echo esc_attr(get_theme_mod( 'riddle_menu_font', 'Nunito Sans, sans-serif' )); ?>;
        }

        #site-navigation .menu li a:hover {
            text-decoration:<?php echo esc_attr(get_theme_mod( 'riddle_menu_underline_hover', 'none;' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'riddle_menu_hover_color', '#888' )); ?>;
        }
		#site-navigation .sub-menu li a {
            color:<?php echo esc_attr(get_theme_mod( 'riddle_submenu_color', '#333' )); ?>;
        }
		#site-navigation .sub-menu li a:hover {
            color:<?php echo esc_attr(get_theme_mod( 'riddle_submenu_hover_color', '#888' )); ?> !important;
        }
        #copyright a,
        #copyright p {
            font-family:<?php echo esc_attr(get_theme_mod( 'riddle_copyright_font', 'Nunito Sans, sans-serif' )); ?>;
            font-size:<?php echo esc_attr(get_theme_mod( 'riddle_copyright_font_size', '' )); ?>px;
            color:<?php echo esc_attr(get_theme_mod( 'riddle_copyright_color', '' )); ?>;
            text-decoration:<?php echo esc_attr(get_theme_mod( 'riddle_copyright_underline', '' )); ?>;
        }
        #copyright a:hover{
            color:<?php echo esc_attr(get_theme_mod( 'riddle_copyright_hover_color', '' )); ?>;
            text-decoration:<?php echo esc_attr(get_theme_mod( 'riddle_copyright_underline_hover' )); ?>;
        }
        .social-icons p,
        .social-icons a{
            font-size:<?php echo esc_attr(get_theme_mod( 'riddle_soc_size', '' )); ?>px;
            color:<?php echo esc_attr(get_theme_mod( 'riddle_soc_color', '' )); ?>;
        }
        #social a:hover{
            color:<?php echo esc_attr(get_theme_mod( 'riddle_soc_color_hover', '' )); ?>;
        }
        body h1 {
            font-family:<?php echo esc_attr(get_theme_mod( 'riddle_h1_font', 'Nunito Sans, sans-serif' )); ?>;
            color:<?php echo get_theme_mod( 'riddle_h1_color', '#333' ); ?>;
        }
        body h2 {
            font-family:<?php echo esc_attr(get_theme_mod( 'riddle_h2_font', 'Nunito Sans, sans-serif' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'riddle_h2_color', '#333' )); ?>;
        }
        body h3 {' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'riddle_h3_color', '#333' )); ?>;
            font-family:<?php echo esc_attr(get_theme_mod( 'riddle_h3_font', 'Nunito Sans, sans-serif' )); ?>;
        }
        body h4 {
            font-family:<?php echo esc_attr(get_theme_mod( 'riddle_h4_font', 'Nunito Sans, sans-serif' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'riddle_h4_color', '#333' )); ?>;
        }
        body h5 {
            font-family:<?php echo esc_attr(get_theme_mod( 'riddle_h5_font', 'Nunito Sans, sans-serif' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'riddle_h5_color', '#333' )); ?>;
        }
        body h6 {
            font-family:<?php echo esc_attr(get_theme_mod( 'riddle_h6_font', 'Nunito Sans, sans-serif' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'riddle_h6_color', '#333' )); ?>;
        }
        .site-footer {
            background: <?php echo esc_attr(get_theme_mod( 'riddle_footer_background', '#333' )); ?>;
        }
    </style>
<?php
}
add_action( 'wp_head', 'riddle_customize_css');