<?php
/**
 * Displays main navigation
 *
 * @package WordPress
 * @subpackage riddle
 * @since 1.0
 * @version 1.0
 */

?>
<nav id="site-navigation" class="main-navigation" role="navigation" aria-label="<?php _e( 'Main Menu', 'riddle' ); ?>">
	<button class="menu-toggle" aria-controls="main-menu" aria-expanded="false"><?php echo riddle_get_svg( array( 'icon' => 'bars' ) ); echo riddle_get_svg( array( 'icon' => 'close' ) ); _e( 'Menu', 'riddle' ); ?></button>
	<?php wp_nav_menu( array(
		'theme_location' => 'main',
		'menu_id'        => 'main-menu',
	) ); ?>

	<?php if ( ( riddle_is_frontpage() || ( is_home() && is_front_page() ) ) && has_custom_header() ) : ?>
		<!-- <a href="#content" class="menu-scroll-down"><?php echo riddle_get_svg( array( 'icon' => 'arrow-right' ) ); ?><span class="screen-reader-text"><?php _e( 'Scroll down to content', 'riddle' ); ?></span></a> -->
	<?php endif; ?>
</nav><!-- #site-navigation -->
