<?php
defined('_JEXEC') or die('Restricted access');
/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

class AdminViewImportExport
{

	static function import(&$step = 1,&$data = array()) {

		$html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Import' />" . JText::_('COM_OS_CCK_IMPORT') . "</div>";
	    $app = JFactory::getApplication();
	    $app->JComponentTitle = $html;

		if($step == 1){

		?>
		<h3> Import </h3><hr/>
		<form method="POST" action="index.php?option=com_os_cck&task=import&step=2" class="form-horizontal" enctype="multipart/form-data">
			<div class="control-group">
				<label class="control-label" for="importData">Zip File for import</label>
				<div class="controls">
					<input id="importData" type="file" name="importData" />
				</div>
			</div>
			<div class="control-group">
				<div class="controls">
					<button type="submit" class="btn">Upload</button>
				</div>
			</div>
		</form>
		<?php 
		}elseif($step == 3){

			if(isset($data['error'])) 
				{
					echo JFactory::getApplication()->enqueueMessage($data['error'], 'Error');
				}else{
					echo JFactory::getApplication()->enqueueMessage('Archive loaded successfully', 'Message');
				}
			?>

			&nbsp&nbsp<button type="button" class="btn btn-small btn-success" onclick="location.href = '<?php echo JUri::root();?>administrator/index.php?option=com_os_cck&task=import';" >Back</button>
			<?php
			
		}
	}
	static function import1(&$step = 1,&$data = array()) {
            global $doc, $input;
            ?>
            <script>
                    var JUri = '<?php echo JUri::root(); ?>';
            </script>
            <?php
            $doc->addScript(JUri::root() . "components/com_os_cck/assets/js/os-import.js");
            $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Import' />" . JText::_('COM_OS_CCK_IMPORT') . "</div>";
	    $app = JFactory::getApplication();
	    $app->JComponentTitle = $html;
            $json_enteties = json_encode($data['entities_list']);

            $url = $input->get('url', "https://ordasoft.com/joomla-templates/joomla-cck-website-builder?tmpl=component", 'STRING');

            if($input->get('active', '') != ''){
                    $active = true;
            }else{
                    $active = false;
            }
            $domain = file_get_contents($url);

            $file_path = JPATH_SITE . '/administrator/components/com_os_cck/exports/iframe_page.html';
            file_put_contents($file_path, $domain);

            $library_url = $input->get('library_url', "https://ordasoft.com/joomla-cck-library?tmpl=component", 'STRING');

            $domain = file_get_contents($library_url);

            $file_path = JPATH_SITE . '/administrator/components/com_os_cck/exports/iframe_library_page.html';
            file_put_contents($file_path, $domain);
                

		if($step === 1){
			?>

			<?php
			if($active){
				$options = Array('active'    => 'panel_3_id');
			}else{
				$options = Array('active'    => 'panel_1_id');
			}
			echo JHtml::_('bootstrap.startTabSet', 'import-tab', $options);
		    echo JHtml::_('bootstrap.addTab', 'import-tab', 'panel_1_id', JText::_('COM_OS_CCK_IMPORT_TAB_LIBRARY'));
			?>
			<link rel="stylesheet" type="text/css" href="<?php echo JUri::root(); ?>components/com_os_cck/assets/css/os-about.css">
			<div class="import-body">
				<iframe src="<?php echo JUri::root(); ?>administrator/components/com_os_cck/exports/iframe_library_page.html" id="importLibFarame" border="0"></iframe>
			</div>
			<div id="ordasoft-notification">
				<p></p>
			</div>
			<div id="login-modal" class="ordasoft-modal-sm modal hide" aria-hidden="true" style="display: none;">
				<div class="modal-dialog">
					<div class="modal-content">
						<img class="img-preloader notification-in" src="<?php echo JURI::base(); ?>/components/com_os_cck/images/reload.svg" ></img>
						<div class="modal-body">
					
						</div>
					</div>
				</div>
			</div>
			<?php
			echo JHtml::_('bootstrap.endTab');
			echo JHtml::_('bootstrap.addTab', 'import-tab', 'panel_3_id', JText::_('COM_OS_CCK_IMPORT_TAB_TEMPLATE'));
			?>
			<link rel="stylesheet" type="text/css" href="<?php echo JUri::root(); ?>components/com_os_cck/assets/css/os-about.css">
			<div class="import-body">
				<iframe src="<?php echo JUri::root(); ?>administrator/components/com_os_cck/exports/iframe_page.html" id="importFarame" border="0"></iframe>
			</div>
			<div id="ordasoft-notification">
				<p></p>
			</div>
			<div id="login-modal" class="ordasoft-modal-sm modal hide" aria-hidden="true" style="display: none;">
				<div class="modal-dialog">
					<div class="modal-content">
						<img class="img-preloader notification-in" src="<?php echo JURI::base(); ?>/components/com_os_cck/images/reload.svg" ></img>
						<div class="modal-body">
					
						</div>
					</div>
				</div>
			</div>
			<?php
			echo JHtml::_('bootstrap.endTab');
  			echo JHtml::_('bootstrap.addTab', 'import-tab', 'panel_2_id', JText::_('COM_OS_CCK_IMPORT_TAB_CUSTOM'));
		?>
                
		<?php 
		echo JHtml::_('bootstrap.endTab');
		echo JHtml::_('bootstrap.endTabSet');
		}elseif($step == 3){
            if(isset($data['error']))
				{
					echo JFactory::getApplication()->enqueueMessage($data['error'], 'Error');
				}else{
					echo JFactory::getApplication()->enqueueMessage('Archive loaded successfully', 'Message');
				}
			?>
<!-- http://localhost/~vlados/joomla42/administrator/index.php?option=com_os_cck&task=import -->
			&nbsp&nbsp<button type="button" class="btn btn-small btn-primary" onclick="history.go(-1);" >Back</button>
			<?php
			
		}
	}
        
	static function showExportResult($InformationArray, $option) {
//            global $doc, $mosConfig_live_site,$app;

		$html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Import' />" . JText::_('COM_OS_CCK_IMPORT') . "</div>";
		$app = JFactory::getApplication();
		$app->JComponentTitle = $html;
		
		?>
		<form action="index.php" method="post" name="adminForm" id="adminForm">
			<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
			<table border="0" class="adminheading" cellpadding="0" cellspacing="0" width="100%">
				<tr valign="middle">
					<th class="config">Export Result</th>
					<td align="right"></td>
				</tr>
			</table>
			You can download the requested Export under the following URL (right-click to save):  <br />
			<a href="<?php echo $InformationArray['urlBase'] . $InformationArray['out_file']; ?>"
				target="blank"><?php echo $InformationArray['urlBase'] . $InformationArray['out_file']; ?></a>
			<br />
		Please note that the files will still be saved on the server and you have to clean them yourself.  <br />
			<input type="hidden" name="option" value="<?php echo $option; ?>" />
			<input type="hidden" name="task" value="cancel" />
		</form>
		<?php
	}

	static function importStepTwo($entity_arr, $tmp_file_path, $existing_entities, $zip_file_name) {
//            global $doc, $mosConfig_live_site,$app;

		$html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Import' />" . JText::_('COM_OS_CCK_IMPORT') . "</div>";
		$app = JFactory::getApplication();
		$app->JComponentTitle = $html;
		?>
		<form method="post" name="adminForm" id="adminForm" action="index.php?option=com_os_cck&task=import&step=3">
			<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
			<div>Select the operation you want to perform on the detected entities.</div>
			<?php foreach($entity_arr as $eid => $entity_name){ ?>
				<div class="entity-export">
					<div>Entity: "<?php echo $entity_name; ?>"</div>
					<div>
						<select name="entity_export_type[<?php echo $eid; ?>]" eid="<?php echo $eid; ?>" class="entity_export_type">
							<option value="new" selected="selected">Create new Entity</option>
							<option value="merge">Merge with an existing entity</option>
							<option value="skip">Skip</option>
						</select>
					</div>
					<div class="entity_merge" style="display:none" eid="<?php echo $eid; ?>">
						<div><select name="entity_merge[<?php echo $eid; ?>]" >
							<?php foreach($existing_entities as $key => $name){ ?>
								<option value=<?php echo $key; ?>><?php echo $name; ?></option>
							<?php } ?>
						</select>
						</div>
						
						<div>
							<span class="show_advanced_options showed">Show advanced options</span>
							<div class="adv_opt" style="display: none;">
								<div>
									<div>
										Matching Layout Options
									</div>
									<div>
										<select name="layout_opt[<?php echo $eid; ?>]" class="layout_opt">
											<option value="new">Create new layouts</option>
											<option value="merge">Merge</option>
										</select>
									</div>
									<div class="import_layout_info_text">
										All layouts will be created regardless of matches
									</div>
								</div>
								<div>
									<div>
										Matching Fields options
									</div>
									<div>
										<select name="field_opt[<?php echo $eid; ?>]" class="field_opt">
											<option value="new">Create new fields</option>
											<option value="merge">Merge</option>
										</select>
									</div>
									<div class="import_field_info_text">
										All fields will be created regardless of matches
									</div>
								</div>
							</div>
						</div>	
						
							
					</div>
				</div>
			<?php } ?>
			<input type="submit" class="btn btn-success" value="Import"/>
			<input type="hidden" name="tmp_file_path" value="<?php echo $tmp_file_path; ?>"/>
			<input type="hidden" name="zip_file_name" value="<?php echo $zip_file_name; ?>"/>
			
		</form>
		<script>
			window.addEventListener('load', function() { 
				
				function hideShowExtEntity(elem){
					var eid = jQuerOs(elem).attr('eid')
					var val = jQuerOs(elem).val();
					
					if(val == 'new' || val == 'skip'){
						jQuerOs('.entity_merge[eid="'+eid+'"]').hide()
					}else{
						jQuerOs('.entity_merge[eid="'+eid+'"]').show()
						
					}
				}
				
				
				
				jQuerOs('.entity_export_type').on('change', function(){
					
					hideShowExtEntity(this)
				})

				jQuerOs('.show_advanced_options').on('click', function(){
					if(jQuerOs(this).hasClass('showed')){
						jQuerOs(this).removeClass('showed')
						jQuerOs(this).addClass('hided')
						jQuerOs(this).parent().find('.adv_opt').show()
						jQuerOs(this).text('Hide advanced options')
					}else{
						jQuerOs(this).addClass('showed')
						jQuerOs(this).removeClass('hided')
						jQuerOs(this).parent().find('.adv_opt').hide()
						jQuerOs(this).text('Show advanced options')
					}
				})

				jQuerOs('.layout_opt').on('change', function(){
					var val = jQuerOs(this).val()
					// console.log('11111111111', jQuerOs(this).parent())
					if(val == 'new'){
						jQuerOs(this).parents('.adv_opt').find('.import_layout_info_text').text('All layouts will be created regardless of matches')
					}else{
						jQuerOs(this).parents('.adv_opt').find('.import_layout_info_text').text('Layouts that match the existing type and name will not be created. All instances, requests, and reviews that are linked to these layouts will be linked to the existing layouts')
					}
				})

				jQuerOs('.field_opt').on('change', function(){
					var val = jQuerOs(this).val()
					// console.log('11111111111', jQuerOs(this).parent())
					if(val == 'new'){
						jQuerOs(this).parents('.adv_opt').find('.import_field_info_text').text('All fields will be created regardless of matches')
					}else{
						jQuerOs(this).parents('.adv_opt').find('.import_field_info_text').text('Fields that match existing ones by type and name will not be created.')
					}
				})
				
				
			})
		</script>
		<?php
	}
	

}
