<?php
defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

class AdminOrders{

    static function showOrders(){
        global $db, $user, $option, $doc, $jConf, $app, $input;
        if(!JFactory::getUser()->authorise('access_to_orders', 'com_os_cck')){
            $app->enqueueMessage("Access denied", 'error');
            return;
        }
        $search = '';
        $order = 'ORDER BY o.notreaded desc,o.id  DESC';
        
        $entity_id = $app->getUserStateFromRequest("entity_id{$option}", 'entity_id', '');
        $entities = array();
        $entities[] = array('value' => '', 'text' => JText::_('COM_OS_CCK_OPTION_ALL_ENTITIES'));

        $query = "SELECT eid AS value, name AS text FROM #__os_cck_entity ORDER BY name ";

        $db->setQuery($query);
        $ent = $db->loadObjectList("value");


        $entities = (count($ent) > 1) ? array_merge($entities, (array)$ent) : $entities;
        $entety_result = false;
        foreach($entities as $temp_ent){
            if(is_object($temp_ent) && property_exists($temp_ent, 'value') && $temp_ent->value == $entity_id) $entety_result = true;
        }
        if(!$entety_result) $entity_id = ''; 
        $entity_list = JHTML::_('select.genericlist',$entities, 'entity_id', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text', $entity_id);
        
        $where = '';
        if(isset($_REQUEST['search']) || ($entity_id != '' && isset($ent[$entity_id]))){
            
            if(isset($_REQUEST['search'])) {
                $search = $_REQUEST['search'];
                $where = "WHERE o.user_email LIKE '%{$search}%' OR o.user_name LIKE '%{$search}%' OR o.id LIKE '%{$search}%'";
            }
            if ($entity_id != '' && isset($ent[$entity_id])) {
                if(stripos($where, 'WHERE')){
                    $where .= " AND eii.fk_eid ='{$entity_id}'";
                } else {
                    $where = "WHERE eii.fk_eid ='{$entity_id}'";
                }
            }
        }
        //var_dump($where); exit;
        $orderby = $input->get('order', 'ASC', '');
        if(isset($_GET['orderby']) && $_GET['orderby'] == 'user') {
            $order = 'ORDER BY o.user_name ' . $orderby;
        }elseif(isset($_GET['orderby']) && $_GET['orderby'] == 'email') {
            $order = 'ORDER BY o.user_email ' . $orderby;
        }elseif(isset($_GET['orderby']) && $_GET['orderby'] == 'status') {
            $order = "ORDER BY o.status " . $orderby;
        }elseif(isset($_GET['orderby']) && $_GET['orderby'] == 'order_date') {
            $order = "ORDER BY o.order_date " . $orderby;
        }elseif(isset($_GET['orderby']) && $_GET['orderby'] == 'id') {
            $order = "ORDER BY o.id " . $orderby;
        }elseif(isset($_GET['orderby']) && $_GET['orderby'] == 'title') {
            $order = "ORDER BY o.instance_title " . $orderby;
        }

        $limit = $app->getUserStateFromRequest("viewlistlimit", 'limit', $jConf->get("list_limit",10));
        $limitstart = $app->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);

        if(isset($_REQUEST['order_details'])){
            $order = "ORDER BY o.order_date  DESC";
            if(isset($_GET['orderby']) && $_GET['orderby'] == 'order_date') {
                $order = "ORDER BY o.order_date  ASC";
            }
            if($where)
                $where = "WHERE o.user_email LIKE '%{$search}%' OR o.user_name LIKE '%{$search}%' 
                            AND fk_order_id = ".$_REQUEST['order_id']."";
            else
                $where = "WHERE fk_order_id = ".$_REQUEST['order_id']."";
            $sql = "SELECT count(*)  ".
                    " FROM #__os_cck_orders_details AS o ".
                    " LEFT JOIN #__users AS u ".
                    " ON o.fk_user_id = u.id ".
                    " LEFT JOIN #__os_cck_entity_instance AS eii ".
                    " ON o.fk_instance_id = eii.eiid ".
                    " LEFT JOIN #__os_cck_orders AS ccko ".
                    " ON ccko.id = o.fk_order_id ".
                    $where." ".$order ;
            $db->setQuery($sql);
            $total = $db->loadResult();
            $limit = intval($limit);
            $pageNav = new JPagination($total, $limitstart, $limit);
            $sql = "SELECT u.username, ".
                           "o.*, ".
                           "ccko.fk_request_id,ccko.order_price as i_price, ccko.order_currency as i_unit".
                   " FROM #__os_cck_orders_details AS o ".
                   " LEFT JOIN #__users AS u ".
                   " ON o.fk_user_id = u.id ".
                   " LEFT JOIN #__os_cck_entity_instance AS eii ".
                   " ON o.fk_instance_id = eii.eiid ".
                   " LEFT JOIN #__os_cck_orders AS ccko ".
                   " ON ccko.id = o.fk_order_id ".
                    $where." ".$order. " LIMIT " . $pageNav->limitstart." , ". $pageNav->limit;
            $db->setQuery($sql);
            $orders = $db->loadobjectList();

            $query = "UPDATE #__os_cck_orders SET notreaded=0 WHERE id=".$_REQUEST['order_id'];
            $db->setQuery($query);
            $db->execute();

            AdminViewOrders::orders_details($orders, $search, $pageNav, $entity_list);
        }else{
            $sql = "SELECT count(*)  ".
                    " FROM #__os_cck_orders AS o ".
                    " LEFT JOIN #__users AS u ".
                    " ON o.fk_user_id = u.id ".
                    " LEFT JOIN #__os_cck_entity_instance AS eii ".
                   " ON o.fk_instance_id = eii.eiid ". $where ." ".$order;
            $db->setQuery($sql);
            $total = $db->loadResult();
            $limit = intval($limit);
            $pageNav = new JPagination($total, $limitstart, $limit);
            $sql = "SELECT u.id as userId, u.username, ".
               "o.*".
               " FROM #__os_cck_orders AS o ".
               " LEFT JOIN #__users AS u ".
               " ON o.fk_user_id = u.id ".
               " LEFT JOIN #__os_cck_entity_instance AS eii ".
               " ON o.fk_instance_id = eii.eiid ". $where.
                $order. " LIMIT " . $pageNav->limitstart." , ". $pageNav->limit;
            $db->setQuery($sql);
            $orders = $db->loadobjectList();
            
            $order_entity_array = array();
            $order_prices = array();
            foreach($orders as $order){
                $query = "SELECT fk_eiid, сart_item FROM #__os_cck_orders_price WHERE fk_order_id = ".$order->id." GROUP BY сart_item";
                $db->setQuery($query);
                $eiids = $db->loadAssocList('сart_item', 'fk_eiid');
                
                $order_entity_array[$order->id] = $eiids;
                
                $query = "SELECT op.*, o.fk_request_id FROM #__os_cck_orders_price as op "
                        . "LEFT JOIN #__os_cck_orders as o ON o.id=op.fk_order_id "
                        . " WHERE op.fk_order_id = ".$order->id." ";
                $db->setQuery($query);
                $order_price = $db->loadObjectList();
                
                $order_prices[$order->id] = $order_price;
                
            }
//            var_dump($order_prices);
            AdminViewOrders::orders($orders, $search, $pageNav, $entity_list, $order_entity_array, $order_prices);
        }
    }

    static function updateOrderStatus() {
        global $db, $option,$app, $os_cck_state;
        if(!cck_checkReferer()){
            $app->enqueueMessage(JText::_("COM_OS_CCK_ERROR_REFERER_SECURITY"), 'warning');
            return;
        }
        $input = JFactory::getApplication()->input;
        $orderId = $input->get('orderId', 0, 'INT');
        $status = $input->get('status', 'Completed', 'STRING');
        $comment = $input->get('comment', '', 'STRING');
        $option = $input->get('option', 'com_os_cck', 'STRING');
        
        $query = "SELECT * FROM #__os_cck_orders WHERE id = ".$orderId."";
        $db->setQuery($query);
        $old_order = $db->loadObjectList();
        $old_status = $old_order[0]->status;
//        var_dump($old_order); exit;
        if($status == 'Completed'){
            $sql = "UPDATE #__os_cck_orders SET status = '".$status."', order_date = '".get_curent_site_time()."', number_of_downloads=0 WHERE id = ".$orderId."";
            
            if($old_order[0]->instance_type == 'Rent'){
                $request = new os_cckEntityInstance($db);
                $request->load($old_order[0]->fk_request_id);
                if($request->eiid){
                    AdminRent_request::accept_rent_requests('com_os_cck', array($old_order[0]->fk_request_id), 0);
                }
//                $request_id = $old_order[0]->fk_request_id;
//                
////                var_dump($request); exit;
//                $request->accept();
            }elseif($old_order[0]->instance_type == 'Buy'){
                $request = new os_cckEntityInstance($db);
                $request->load($old_order[0]->fk_request_id);
                if($request->eiid){
                    AdminBuy_request::accept_buying_requests('com_os_cck', array($old_order[0]->fk_request_id), 0);
                }
            }
            
        }else{
            $sql = "UPDATE #__os_cck_orders SET status = '".$status."', order_date = NOW() WHERE id = ".$orderId."";
        }
        if(!isset($os_cck_state->data) ){
            echo '<script>alert("'. JText::_("COM_OS_CCK_YOUR_LICENSE_NEED_ACTIVE").'"); history.back(); </script>';
            return ;
        }
        //var_dump($sql); exit;
        $db->setQuery($sql);
        $db->execute();
        $sql = "SELECT * FROM #__os_cck_orders WHERE id = ".$orderId."";
        $db->setQuery($sql);
        $order = $db->loadobjectList();
        $order = $order['0'];
        $order->txn_type = 'Order status changed (set:'.$status.') by the administrator';
//        var_dump($order->quantity);
        $user = JFactory::getUser();
        $comment = "Comment administrator " . $user->username . ": " . $comment;
        $sql = "INSERT INTO #__os_cck_orders_details( fk_order_id, fk_user_id, fk_instance_id,
                                                              instance_title, user_email, user_name, status,
                                                              order_date,txn_type, txn_id, payer_id, payer_status,
                                                              payment_details, quantity, comment, row_data)
                        VALUES ('".$order->id."','".$order->fk_user_id."','". $order->fk_instance_id ."',
                                '".$order->instance_title."','".$order->user_email."','".$order->user_name."','".$order->status."',
                                '".get_curent_site_time()."','".$order->txn_type."','".$order->txn_id."',  '".$order->payer_id."',
                                '".$order->payer_status."', ".$db->Quote($raw_data).", ".$db->Quote(($order->quantity) ? $order->quantity: 1).", ".$db->Quote($comment).", '')";
        $db->setQuery($sql);
//        print_r($sql); exit;
        $db->execute();
        
        $sql = "SELECT * FROM #__os_cck_orders_price WHERE fk_order_id=".$order->id;
        $db->setQuery($sql);
        $order_prices = $db->loadObjectList();
        
        foreach($order_prices as $order_price){
            if($order_price->quantity > 0){
                $sql = "SELECT quantity FROM #__os_cck_content_instances_price WHERE price_id=" . $order_price->fk_price_id;
                $db->setQuery($sql);
                $old_quantity = $db->loadResult();
                if($old_quantity > -1) {
                    if ($status == 'Completed') {
                        $quantity = $old_quantity - $order_price->quantity;
                    } elseif ($old_status != 'Completed') {
                        $quantity = $old_quantity;
                    } else {
                        $quantity = $old_quantity + $order_price->quantity;
                    }

                    $sql = "UPDATE #__os_cck_content_instances_price SET quantity = '$quantity' WHERE price_id=" . $order_price->fk_price_id;
                    $db->setQuery($sql);
                    $db->execute();
                }
            }
        }
        
        
        $app->redirect("index.php?option=$option&task=orders");
    }


    static function deleteOrder($cb, $option)
    {

        global $db, $app;
        if(!cck_checkReferer()){
            $app->enqueueMessage(JText::_("COM_OS_CCK_ERROR_REFERER_SECURITY"), 'warning');
            return;
        }
        foreach($cb as $key=>$orderId){
            $sql = "DELETE FROM #__os_cck_orders WHERE id = ".$orderId." ";
            $db->setQuery($sql);
            $db->execute();

            $sql = "DELETE FROM #__os_cck_orders_details WHERE fk_order_id = ".$orderId." ";
            $db->setQuery($sql);
            $db->execute();

            $sql = "DELETE FROM #__os_cck_orders_price WHERE fk_order_id = ".$orderId." ";
            $db->setQuery($sql);
            $db->execute();
        }

        $app->redirect("index.php?option=$option&task=orders");

    }
    
    static function changeOrderStatus(){
        if(!cck_checkReferer()){
            $app->enqueueMessage(JText::_("COM_OS_CCK_ERROR_REFERER_SECURITY"), 'warning');
            return;
        }
        $input = JFactory::getApplication()->input;
        
        $orderId = $input->get('cb', 0 , 'INT');
        $orderId = $orderId[0];
        $status = $input->get('order_status', array(), 'ARRAY');
        $status = $status[$orderId];
        
        
       AdminViewOrders::changeOrderStatus($orderId, $status);
        
    }

    

}