<?php
defined('_JEXEC') or die('Restricted access');


/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/
$fName = $field->db_field_name;

$description_show = (isset($lParams['description_'.$fName])) ? 'checked="true"' : '';
$field_prefix = (isset($lParams[$fName.'_prefix'])) ? $lParams[$fName.'_prefix'] : '';
$field_suffix = (isset($lParams[$fName.'_suffix'])) ? $lParams[$fName.'_suffix'] : '';
$fld_alias = (isset($lParams[$fName.'_alias'])) ? $lParams[$fName.'_alias'] : $field->field_name;
$field_tooltip = (isset($lParams[$fName.'_tooltip'])) ? $lParams[$fName.'_tooltip'] : '';
$access_selected = (isset($lParams['access_'.$fName])) ? $lParams['access_'.$fName] : '1';
// $field_title_field = (isset($lParams[$fName.'_title_field'])) ? $lParams[$fName.'_title_field'] : 0;
$field_placeholder = (isset($lParams[$fName.'_placeholder'])) ? $lParams[$fName.'_placeholder'] : '';
$field_php_show = (isset($lParams[$fName.'_php_show'])) ? $lParams[$fName.'_php_show'] : '';
$field_check_expression = (isset($lParams[$fName.'_check_expression'])) ? $lParams[$fName.'_check_expression'] : '';
$field_error_text = (isset($lParams[$fName.'_error_text'])) ? $lParams[$fName.'_error_text'] : '';

$field_check_expression_arr = array();
$field_check_expression_arr['email'] = "/^\+?(\d{1,3})?[- .]?\(?(?:\d{2,3})\)?[- .]?\d\d\d[- .]?\d\d\d\d$/";
$field_check_expression_arr['zip-code'] = "/^\d{5}(?:[-\s]\d{4})?$/";
$field_check_expression_arr['Credit card'] = "/^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\d{3})\d{11})$/";
$field_check_expression_arr['Phone number'] = "/^\+?(\d{1,3})?[- .]?\(?(?:\d{2,3})\)?[- .]?\d\d\d[- .]?\d\d\d\d$/";
$field_check_expression_arr['IPv4'] = "/\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\b/";
$field_check_expression_arr['IPv6'] = "(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))";
$field_check_expression_arr['ISBN'] = "/\b(?:ISBN(?:: ?| ))?((?:97[89])?\d{9}[\dx])\b/i";
$field_check_expression_arr['custom'] = "custom";

$field_check_expression_opt = array();
$field_check_expression_opt[] = JHTML::_('select.option','', 'None');
foreach ($field_check_expression_arr as $key => $expr){
    $field_check_expression_opt[] = JHTML::_('select.option',$expr, $key);
}

$fld_require = (isset($lParams[$fName.'_required'])) ? 'checked="true"' : '';

//publish checked default
$fld_published = (isset($lParams[$fName.'_published']) 
                    && $lParams[$fName.'_published'] == 'on') ? 'checked="true"' : '';
$fld_published = (!isset($lParams[$fName.'_published'])) ? 'checked="true"' : $fld_published;
//show name checked default
$fld_name_show = (isset($lParams['showName_'.$fName]) 
                    && $lParams['showName_'.$fName] == 'on') ? 'checked="true"' : '';
$fld_name_show = (!isset($lParams['showName_'.$fName])) ? 'checked="true"' : $fld_name_show;
$cut_tags = (isset($lParams[$fName.'_cut_tags'])) ? $lParams[$fName.'_cut_tags'] : 0;

$icon_alias_prefix = (isset($lParams[$fName.'_add_icon_alias_prefix'])) ? $lParams[$fName.'_add_icon_alias_prefix'] : '';
$icon_alias_suffix = (isset($lParams[$fName.'_add_icon_alias_suffix'])) ? $lParams[$fName.'_add_icon_alias_suffix'] : '';
$icon_prefix_prefix = (isset($lParams[$fName.'_add_icon_prefix_prefix'])) ? $lParams[$fName.'_add_icon_prefix_prefix'] : '';
$icon_prefix_suffix = (isset($lParams[$fName.'_add_icon_prefix_suffix'])) ? $lParams[$fName.'_add_icon_prefix_suffix'] : '';
$icon_suffix_prefix = (isset($lParams[$fName.'_add_icon_suffix_prefix'])) ? $lParams[$fName.'_add_icon_suffix_prefix'] : '';
$icon_suffix_suffix = (isset($lParams[$fName.'_add_icon_suffix_suffix'])) ? $lParams[$fName.'_add_icon_suffix_suffix'] : '';


?>
<div id="options-field-<?php echo $fName?>">
    <div>
        <input type="hidden" data-field-name="<?php echo $fName?>" name="fi_<?php echo $fName?>_published"
        <?php echo $fld_published?> value="0">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SHOW_FIELD_PUBLISHED")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_<?php echo $fName?>_published" <?php echo $fld_published?>>
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SHOW_FIELD_REQUIRED")?></label>
        <input class="require-checkbox" type="checkbox" data-field-name="<?php echo $fName?>" name="fi_<?php echo $fName?>_required" <?php echo $fld_require?>>
    </div>
    <div>
        <input type="hidden" data-field-name="<?php echo $fName?>" name="fi_showName_<?php echo $fName?>" 
        <?php echo $fld_name_show?> value="0">        
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SHOW_FIELD_NAME")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_showName_<?php echo $fName?>" <?php echo $fld_name_show?>>
    </div>
    <div class="label_alias_wrap">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_ALIAS")?></label>
        <div class="fa <?php echo $icon_alias_prefix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_alias_prefix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_alias_prefix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_alias_prefix" value="<?php echo $icon_alias_prefix; ?>">
        <input type="text" size="4" style="float: right;" name="fi_<?php echo $fName?>_alias"  value="<?php echo $fld_alias?>" >
        <div class="fa <?php echo $icon_alias_suffix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_alias_suffix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_alias_suffix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_alias_suffix" value="<?php echo $icon_alias_suffix; ?>">
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SHOW_DESCRIPTION")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_description_<?php echo $fName?>" <?php echo $description_show?>>
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_TOOLTIP")?></label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_tooltip"  value="<?php echo $field_tooltip?>" >
    </div>
    <div class="prefix_wrap">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_PREFIX")?></label>
        <div class="fa <?php echo $icon_prefix_prefix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_prefix_prefix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_prefix_prefix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_prefix_prefix" value="<?php echo $icon_prefix_prefix; ?>">
        <input type="text" size="4" name="fi_<?php echo $fName?>_prefix"  value="<?php echo $field_prefix?>" >
        <div class="fa <?php echo $icon_prefix_suffix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_prefix_suffix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_prefix_suffix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_prefix_suffix" value="<?php echo $icon_prefix_suffix; ?>">
    </div>
    <div class="suffix_wrap">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SUFFIX")?></label>
        <div class="fa <?php echo $icon_suffix_prefix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_suffix_prefix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_suffix_prefix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_suffix_prefix" value="<?php echo $icon_suffix_prefix; ?>">
        <input type="text" size="4" name="fi_<?php echo $fName?>_suffix"  value="<?php echo $field_suffix?>" >
        <div class="fa <?php echo $icon_suffix_suffix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_suffix_suffix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_suffix_suffix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_suffix_suffix" value="<?php echo $icon_suffix_suffix; ?>">
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SHOW_PLACEHOLDER")?></label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_placeholder"  value="<?php echo $field_placeholder?>" >
    </div>
<!--     <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_FIELD_TITLE")?> 
             <i title="<?php echo JText::_("COM_OS_CCK_TITLE_FIELD_TOOLTIP")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i>
        </label>
        <input type="radio" name="fi_<?php echo $fName?>_title_field"  <?php echo $field_title_field?'checked':''?> value="1">Yes
        <input type="radio" name="fi_<?php echo $fName?>_title_field"  <?php echo $field_title_field?'':'checked'?> value="0">No
    </div> -->
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_CHECK_EXPRESSION")?> <i title="<?php echo JText::_("COM_OS_CCK_EXPRESSON_FIELD_TOOLTIP")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i></label>
        <div class="email-expression-wrapper">
<!--            <span class="email-expression" style="color:#34404C;font-weight: bold;margin-left: 2px;cursor: pointer;" data-value='/^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/'-->
<!--                    onclick="jQuerOs(this).parent().find('.email-expression-input').val(jQuerOs(this).attr('data-value'))">-->
<!--                    Email-->
<!--                    </span>-->
            <?php echo JHTML::_('select.genericlist',$field_check_expression_opt, "fi_".$fName."_check_expression",
                'class="inputbox" ', 'value', 'text',  htmlspecialchars($field_check_expression));?>
<!--            <input class="email-expression-input" type="text" size="4" name="fi_--><?php //echo $fName?><!--_check_expression"  value="--><?php //echo htmlspecialchars($field_check_expression)?><!--" >-->
        </div>
    </div>
    <div class="<?php echo $fName?>_check_expression_show_hide_custom" <?php echo ($field_check_expression != 'custom') ? 'style="display:none;"' : ''; ?>>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_CHECK_EXPRESSION_CUSTOM")?>
            <i title="<?php echo JText::_("COM_OS_CCK_EXPRESSON_ERROR_FIELD_TOOLTIP")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i>
        </label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_check_expression_custom"  value="<?php echo $field_error_text?>" >
    </div>
    <div class="<?php echo $fName?>_check_expression_show_hide_text" <?php echo ($field_check_expression == '') ? 'style="display:none;"' : ''; ?>>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_ERROR_TEXT")?>
            <i title="<?php echo JText::_("COM_OS_CCK_EXPRESSON_ERROR_FIELD_TOOLTIP")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i>
        </label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_error_text"  value="<?php echo $field_error_text?>" >
    </div>


    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_HTML_TAGS_TITLE")?></label>
        <input type="radio" name="fi_<?php echo $fName?>_cut_tags"  <?php echo $cut_tags?'checked':''?> value="1">Yes
        <input type="radio" name="fi_<?php echo $fName?>_cut_tags"  <?php echo $cut_tags?'':'checked'?> value="0">No
    </div>
    <div class="php_show">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_PHP_SHOW")?> <i title="<?php echo JText::_("COM_OS_CCK_LABEL_PHP_SHOW_DESC")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i></label>
        <input id="add-field-mask-php-show" class="new-mask" type="button" aria-invalid="false" value="+field">
        <span class="editor-button">Editor</span>
        <textarea class="php-show-editor" rows="5" cols="30" name="fi_<?php echo $fName?>_php_show"><?php echo $field_php_show?></textarea>
    </div>
    <?php if(isset($cck_entity_configuration[$field->fk_eid]['check_access_fields']) && $cck_entity_configuration[$field->fk_eid]['check_access_fields'] == '1'){
        $attr = array (
            'list.attr' => ' multiple="true" ',
            'id' => 'fi_access_'.$fName,
            'list.select' => $access_selected,
            'group.items' => null,
            'option.key.toHtml' => false,
            'option.text.toHtml' => false
        );
        ?>
    <div>
        <label class="access-label"><?php echo JText::_("COM_OS_CCK_LABEL_FIELD_ACCESS")?></label>
        <?php //echo JHTML::_('select.genericlist', $gtree, 'fi_access_'.$fName.'[]', 'multiple="true"','value', 'text',$access_selected);
        echo JHTML::_('select.groupedlist',$gtree,'fi_access_'.$fName.'[]', $attr);?>
    </div>
    <?php } ?>
</div>
<script>
    function check_expression_show_hide<?php echo $fName; ?>(){
        jQuerOs('#fi_<?php echo $fName; ?>_check_expression').on('change', function(){
            var val = jQuerOs(this).val();
            if(val != ''){
                jQuerOs('.<?php echo $fName?>_check_expression_show_hide_text').show()
            }else{
                jQuerOs('.<?php echo $fName?>_check_expression_show_hide_text').hide()
            }

            if(val == 'custom'){
                jQuerOs('.<?php echo $fName?>_check_expression_show_hide_custom').show()
            }else{
                jQuerOs('.<?php echo $fName?>_check_expression_show_hide_custom').hide()
            }
        })
    }
    check_expression_show_hide<?php echo $fName; ?>()
</script>