<?php
/**
* @package OS Gallery
* @copyright 2020 OrdaSoft
* @author 2020 Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @license GNU General Public license version 2 or later;
* @description Ordasoft Image Gallery
*/


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

class osGalleryHelperAdmin{

    static $tag  = "free";
    static $state = 0 ;

    public static function updateOSGallery()
    {
        $config = JFactory::getConfig();
        $path = $config->get('tmp_path').'/pkg_osgallery.zip';
        $data = file_get_contents('php://input');
        $obj = json_decode($data);
        $method = $obj->method;
        $data = $method($obj->package);
        $file = fopen($path, "w+");
        fputs($file, $data);
        fclose($file);
        if (JVERSION >= '4.0.0') {
            $archive = new Joomla\Archive\Zip();
            $archive->extract($path, $config->get('tmp_path').'/pkg_osgallery');
        } else {
            JArchive::extract($path, $config->get('tmp_path').'/pkg_osgallery');
        }
//        JArchive::extract($path, $config->get('tmp_path').'/pkg_osgallery');
        $installer = JInstaller::getInstance();
        $result = $installer->update($config->get('tmp_path').'/pkg_osgallery');
        JFile::delete($path);
        JFolder::delete($config->get('tmp_path').'/pkg_osgallery');
        exit;
    }        



    public static function checkGalleryState()
    {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true)
            ->select('`key`')
            ->from('#__os_gallery_api')
            ->where('service = '.$db->quote('os_gallery'));
        $db->setQuery($query);
        $os_gallery = $db->loadResult();
        if (empty($os_gallery)) {
            $obj = new stdClass();
            $obj->key = $os_gallery = '{}';
            $obj->service = 'os_gallery';
            $db->insertObject('#__os_gallery_api', $obj);
            $obj = new stdClass();
            $obj->key = $os_gallery = '{}';
            $obj->service = 'os_gallery_activation';
            $db->insertObject('#__os_gallery_api', $obj);
        } else {
            $state = json_decode($os_gallery);
            
            if(isset($state->data) && $state->data != "" ) osGalleryHelperAdmin::$state = 1;
            else  osGalleryHelperAdmin::$state = 0;
        }
        return $os_gallery;
    }

    public static function setAppLicense($data)
    {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__os_gallery_api')
            ->where('service = '.$db->quote('os_gallery'));
        $db->setQuery($query);
        $os_gallery = $db->loadObject();
        $os_gallery->key = json_decode($os_gallery->key);
        $os_gallery->key->data = $data;
        $os_gallery->key = json_encode($os_gallery->key);
        $db->updateObject('#__os_gallery_api', $os_gallery, 'id');
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__os_gallery_api')
            ->where('service = '.$db->quote('os_gallery_activation'));
        $db->setQuery($query);
        $os_gallery = $db->loadObject();
        if($data == ''){
            $os_gallery->key = '{}';
        }else{
            $os_gallery->key = '{"data":"active"}';
        }
        $db->updateObject('#__os_gallery_api', $os_gallery, 'id');
        if($data == ''){
            echo json_encode(array('msg'=>JText::_('COM_OSGALLERY_SUCCESSFULY_DEACTIVATED') ));
        }else{
            echo json_encode(array('msg'=>JText::_('COM_OSGALLERY_SUCCESSFULY_ACTIVATED') ));
        }
        exit;        
    }

    public static function checkActivation()
    {
        $state = new stdClass();
        $state->data = 'free';
        return $state;

        $db = JFactory::getDbo();
        $query = $db->getQuery(true)
            ->select('`key`')
            ->from('#__os_gallery_api')
            ->where('service = '.$db->quote('os_gallery_activation'));
        $db->setQuery($query);
        $package = $db->loadResult();
        if($package){
            $state = json_decode($package);
        }else{
            $state = false;
        }

        return $state;
    }


    static function checkVersionProFree(){

        $activationNeed = false;
        $xml = @simplexml_load_file(JPATH_BASE . "/components/com_osgallery/osgallery.xml");
        if($xml){
            $galV = (string)$xml->tag;
            unset($xml);
            osGalleryHelperAdmin::$tag = $galV ;

            return $galV;
        }
        return "free" ;
    }

    static function checkVersionNumber(){

        $activationNeed = false;
        $xml = @simplexml_load_file(JPATH_BASE . "/components/com_osgallery/osgallery.xml");
        if($xml){
            $galV = (string)$xml->version;
            unset($xml);

            return $galV;
        }
        return "" ;
    }

    static function checkVersionDate(){

        $activationNeed = false;
        $xml = @simplexml_load_file(JPATH_BASE . "/components/com_osgallery/osgallery.xml");
        if($xml){
            $date = (string)$xml->creationDate;
            unset($xml);

            return $date;
        }
        return "" ;
    }    

    static function checkActivationNeed(){

        $activationNeed = false;
        $galV = osGalleryHelperAdmin::checkVersionProFree() ;

        if($galV == "pro") {
            osGalleryHelperAdmin::checkGalleryState();

            if(osGalleryHelperAdmin::$state == 0) $activationNeed = true ;
        }


        return $activationNeed ;
    }

    static function setOSGalleryAppLicenseActivation(){
        $db = JFactory::getDbo();
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__os_gallery_api')
            ->where('service = '.$db->quote('os_gallery_activation'));
        $db->setQuery($query);
        $package = $db->loadObject();
        $package->key = '{}';
        $db->updateObject('#__os_gallery_api', $package, 'id');

        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__os_gallery_api')
            ->where('service = '.$db->quote('os_gallery'));
        $db->setQuery($query);
        $package = $db->loadObject();
        $package->key = '{}';
        $db->updateObject('#__os_gallery_api', $package, 'id');  
                
    }






    static function displayDefault(){
        $document = JFactory::getDocument();
        $document->addScript(JURI::base() . "components/com_osgallery/assets/js/bootstrapGall.js");
        $db = JFactory::getDbo();
        $user = JFactory::getUser();
        $document->addStyleSheet(JURI::root() . "administrator/components/com_osgallery/assets/css/os-about.css");

        $query = "SELECT * FROM #__os_gallery ORDER BY id DESC";
        $db->setQuery($query);
        $galleries = $db->loadObjectList();

        if (version_compare(JVERSION, "4.0.0", "ge")) {
            $bs_delimiter = '-bs';
        } else {
            $bs_delimiter = '';
        }
        
        $title = '<span class="title-block os-gallery-title-text">'.JText::_("COM_OSGALLERY_LIST_VIEW_TITLE").'</span>';
        JToolBarHelper::title($title, 'osgallery-title-image');

        if ($user->authorise('core.create', 'com_osgallery')) {
            JToolBarHelper::addNew('new_gallery');
        }
        if (JFactory::getUser()->authorise('core.duplicate', 'com_osgallery')) {
            JToolBarHelper::custom('clone_gallery', 'copy.png', 'copy_f2.png', 'JTOOLBAR_DUPLICATE', true);
        }
        if ($user->authorise('core.edit.state', 'com_osgallery')) {
            JToolbarHelper::publish('publish', 'JTOOLBAR_PUBLISH', true);
            JToolbarHelper::unpublish('unpublish', 'JTOOLBAR_UNPUBLISH', true);
        }
        if ($user->authorise('core.delete', 'com_osgallery')) {
            JToolBarHelper::deleteList('', 'delete_gallery');
        }

        

        //get gallery update version
        $avaibleUpdate = false;
        $xml = @simplexml_load_file(JPATH_BASE . "/components/com_osgallery/osgallery_update_free.xml");
        if($xml && function_exists('curl_init')){
            $galV = (string)$xml->version;
            $creationDate = (string)$xml->creationDate;
            unset($xml);

            //check update
            if(osGalleryHelperAdmin::$tag == "pro"){
            $url="http://ordasoft.com/xml_update/osgallery.xml";
            }else{
                $url="http://ordasoft.com/xml_update/osgallery_update.xml";
            }
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT ,0); 
            curl_setopt($ch, CURLOPT_TIMEOUT, 1);

            $data = curl_exec($ch);
            
            $data = curl_exec($ch);
            $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            if( !curl_errno($ch) && $code == 200 ){
    
                $xml = simplexml_load_string($data);
                $updateArticleUrl = '#';
                $galVArr = explode(".", $galV);
                
                if($xml && (isset($xml->version) || isset($xml->update->version))){
                    if(isset($xml->version)){
                        $ordasoftGalV = (string)$xml->version;
                    }else{
                        $ordasoftGalV = (string)$xml->update->version;
                    }
                    
                    $ordasoftGalVArr = explode(".", $ordasoftGalV);
                    $ordasoftCreationDate = (string)$xml->creationDate;
                    $updateArticleUrl = (string)$xml->updateArticleUrl;
                    unset($xml);
                    foreach ($galVArr as $k => $galSubV) {
                        if(isset($ordasoftGalVArr[$k])){
                            if((int)$ordasoftGalVArr[$k] < (int)$galSubV){
                                break;
                            }
                            if((int)$ordasoftGalVArr[$k] > (int)$galSubV){
                                $avaibleUpdate = true;
                                break;
                            }
                        }
                    }
                }
                //need uncomment for free version:
                if(!self::checkEnableUpdate()) $avaibleUpdate = false; 

            }
            curl_close($ch);

        }else{
            $galV = (string)$xml->version;
            $creationDate = (string)$xml->creationDate;
        }

        $update = 'unavaible';
        if( $avaibleUpdate || osGalleryHelperAdmin::checkActivationNeed() ) $update = 'avaible';
        JToolBarHelper::custom('about_gallery', 'gallery-update-'.$update, '', 'COM_OSGALLERY_TAB_ABOUT', false);

        if ($user->authorise('core.admin', 'com_osgallery') || $user->authorise('core.options', 'com_osgallery')) {
            JToolBarHelper::preferences('com_osgallery');
        }


        require self::findView('galleryList');
    }

    static function displayGallery($galId){
        global $os_gallery_configuration, $gl_state;
        $document = JFactory::getDocument();
        $document->addScript(JURI::base() . "components/com_osgallery/assets/js/bootstrapGall.js");
        if (version_compare(JVERSION, "4.0.0-alpha10", "lt")) {

          } else {
            $input = JFactory::getApplication()->input;
            $input->set('hidemainmenu', true);
          }
        if(!isset($gl_state->data) ){
            echo '<script>alert("' . JText::_('COM_OSGALLERY_YOU_NEED_ACTIVATE_LICENSE') .'");</script>';
        }
        if (version_compare(JVERSION, "4.0.0", "ge")) {
            $bs_delimiter = '-bs';
            JHtml::_('bootstrap.tab');
        } else {
            $bs_delimiter = '';
        }
        $langs = JFactory::getLanguage();
        $tag_lang = $langs->getTag();
        $default_lang_tag = $langs->getDefault();
        $multilang = $os_gallery_configuration->get('multilang', '0');
        
        if (version_compare(JVERSION, "3.7.0", "ge")) {
            $install_lang = JLanguageHelper::getKnownLanguages();
        }else{
            $install_lang = JLanguage::getKnownLanguages();
        }
        

        $document = JFactory::getDocument();
        $db = JFactory::getDbo();
        $app = JFactory::getApplication();
        $params = new JRegistry;
        $images = array();
        
        $document->addStyleSheet(JURI::base() . "components/com_osgallery/assets/css/fine-uploader-new.css");
        $document->addStyleSheet(JURI::base() . "components/com_osgallery/assets/css/jquery-ui.min.css");
        $document->addStyleSheet(JURI::base() . "components/com_osgallery/assets/css/jquery.slider.minicolors.css");
        $document->addStyleSheet(JURI::base() . "components/com_osgallery/assets/css/select2.min.css");
        
        
            
        

        //include needed script
        JHtml::_('jquery.framework');
        
        $document->addScript(JURI::base() . "components/com_osgallery/assets/js/fine-uploader.js");
        $document->addScript(JURI::base() . "components/com_osgallery/assets/js/jquerOs-ui.min.js");
        $document->addScript(JURI::base() . "components/com_osgallery/assets/js/jquerOs.minicolors.js");
        $document->addScript(JURI::base() . "components/com_osgallery/assets/js/jquerOs.json.js");
        $document->addScript(JURI::base() . "components/com_osgallery/assets/js/select2.min.js");
        // $document->addScript(JURI::base() . "components/com_osgallery/assets/js/jquery.json.js");

        if($galId){
            $query = "SELECT title FROM #__os_gallery WHERE id=$galId";
            $db->setQuery($query);
            $galeryTitle = $db->loadResult();

            //get categories
            $query = "SELECT * FROM #__os_gallery_categories".
                    "\n WHERE fk_gal_id=$galId".
                    "\n ORDER BY ordering ASC";
            $db->setQuery($query);
            $categories =$db->loadObjectList();
            
            //end

            //get nextCat
            $query = "SELECT max(id) FROM #__os_gallery_categories";
            $db->setQuery($query);
            $activeIndex = $db->loadResult();
            
            //get category params
            $query = "SELECT DISTINCT id,params FROM #__os_gallery_categories".
                "\n WHERE fk_gal_id=".$galId;
            $db->setQuery($query);
            $catParamsArray = $db->loadObjectList('id');
            
            $langParamsArray = array();
            foreach ($install_lang as $tag => $lang){
                foreach($categories as $cat){
                    
                    $query = "SELECT type, value, item_id FROM #__os_gallery_lang WHERE fk_gall_id=$galId AND language='$tag' AND item_id=$cat->id AND (type='categoryAlias' OR type='categoryDescription')";
                    $db->setQuery($query);
                    //$img_lang = $db->loadObjectList();
                    $langParamsArray[$tag][$cat->id] = $db->loadObjectList('type');
                }

            }
            
            foreach($catParamsArray as $catId => $catParamsString){
                $catParams = json_decode(rawurldecode($catParamsString->params));
                $catParams =  (array) $catParams;
                if($os_gallery_configuration->get('multilang', '0') == '1'){
                    
                    foreach ($install_lang as $tag => $lang){
                        if(isset($langParamsArray[$tag][$catId]['categoryAlias'])){
                            $imgParams['categoryAlias_'.$tag] = $langParamsArray[$tag][$catId]['categoryAlias']->value;
                        }elseif(!array_key_exists('categoryAlias_'.$tag, $catParams) && (array_key_exists('categoryAlias', $catParams) || (array_key_exists('categoryAlias', $catParams) && $catParams['categoryAlias'] == ''))){
                            $catParams['categoryAlias_'.$tag] = $catParams['categoryAlias'];
                        }else{
                            $catParams['categoryAlias_'.$tag] = '';
                        }
                        
                        if(isset($langParamsArray[$tag][$catId]['categoryDescription'])){
                            $imgParams['categoryDescription_'.$tag] = $langParamsArray[$tag][$catId]['categoryDescription']->value;
                        }elseif(!array_key_exists('categoryDescription_'.$tag, $catParams) && (array_key_exists('categoryDescription', $catParams) || (array_key_exists('categoryDescription', $catParams) && $catParams['categoryDescription'] == ''))){
                            $catParams['categoryDescription_'.$tag] = $catParams['categoryDescription'];
                        }else{
                            $catParams['categoryDescription_'.$tag] = '';
                        }
                    }
                }else{
                    $default = $langs->getDefault();
                    if(isset($langParamsArray[$default][$catId]['categoryAlias']) && (!array_key_exists('categoryAlias', $catParams) || $catParams['categoryAlias'] == '')){
                        $catParams['categoryAlias'] = $langParamsArray[$default][$catId]['categoryAlias']->value;
                    }elseif(array_key_exists('categoryAlias_'.$default, $catParams) && (!array_key_exists('categoryAlias', $catParams) || $catParams['categoryAlias'] == '')){
                        $catParams['categoryAlias'] = $catParams['categoryAlias_'.$default];
                    }
                    
                    if(isset($langParamsArray[$default][$catId]['categoryDescription']) && (!array_key_exists('categoryDescription', $catParams) || $catParams['categoryDescription'] == '')){
                        $catParams['categoryDescription'] = $langParamsArray[$default][$catId]['categoryDescription']->value;
                    }elseif(array_key_exists('categoryDescription_'.$default, $catParams) && (!array_key_exists('categoryDescription', $catParams) || $catParams['categoryDescription'] == '')){
                        $catParams['categoryDescription'] = $catParams['categoryDescription_'.$default];
                    }
                    if(!array_key_exists('categoryAlias', $catParams)){
                        $catParams['categoryAlias'] = '';
                    }
                    if(!array_key_exists('categoryDescription', $catParams)){
                        $catParams['categoryDescription'] = '';
                    }
                }
                $catParams =  (object) $catParams;
                $catParamsArray[$catId]->params = rawurlencode(json_encode($catParams));
            }
                        
            //load params
            $query = "SELECT params FROM #__os_gallery WHERE id=$galId";
            $db->setQuery($query);
            $paramsString = $db->loadResult();

            $params->loadString($paramsString);
            
            $externalGallerySelect = $params->get("externalGallerySettings", 0);
            if($externalGallerySelect > 0){
                $query = "SELECT params FROM #__os_gallery WHERE id=".$externalGallerySelect;
                $db->setQuery($query);
                $paramsString = $db->loadResult();
                $params->loadString($paramsString);
            }
            
            // Order by params
            $selectOrder = "drag_and_drop";
            $orderBy = "ASC";
            $selectOrder = $params->get("order", "drag_and_drop");
            $orderBy = ($selectOrder == 'drag_and_drop') ? 'ASC' : $params->get("orderBy", "ASC");
            $and_where = '';
            if($selectOrder == 'drag_and_drop'){
                //This check was added in version 6.0 to migrate from older versions
                $query = "SELECT DISTINCT gc.ordering FROM #__os_gallery_connect as gc "
                        . "LEFT JOIN #__os_gallery_categories as cat ON gc.fk_cat_id = cat.id "
                        . " WHERE cat.fk_gal_id=$galId";
                $db->setQuery($query);
                $check_ordering = $db->loadColumn();
                
                if(count($check_ordering) > 1){
                    $selectOrder = "gc.ordering";
                }else{
                    $selectOrder = "gim.ordering";
                }
                
                
            }elseif($multilang == 1 && $selectOrder == 'title'){
                $selectOrder = "lang.value";
                $and_where = " AND lang.type='imgTitle' AND lang.language='$tag_lang' ";
            }else{
                $selectOrder = "gim.".$selectOrder;
            }
            $order = " ORDER BY " . $selectOrder . ' ' . $orderBy . ' ';
            
            //getting Images
            $query = "SELECT DISTINCT gim.* , gc.fk_cat_id, cat.name as cat_name, cat.ordering as cat_ordering FROM #__os_gallery_img as gim ".
                    "\n LEFT JOIN #__os_gallery_connect as gc ON gim.id=gc.fk_gal_img_id".
                    "\n LEFT JOIN #__os_gallery_categories as cat ON cat.id=gc.fk_cat_id ".
                    "\n LEFT JOIN #__os_gallery_lang as lang ON lang.item_id=gim.id ".
                    "\n WHERE cat.fk_gal_id=$galId " . $and_where . '  ' . $order .
                    "\n , cat.ordering ASC ";
            $db->setQuery($query);
            $result =$db->loadObjectList();
            
            // ordering categories
//            usort($result, function($a, $b) {
//                return $a->cat_ordering>$b->cat_ordering;
//            });
            
            if($result){
                foreach ($result as $image) {
                    if(!isset($images[$image->fk_cat_id])){
                       $images[$image->fk_cat_id] = array();
                    }
                    $images[$image->fk_cat_id][] = $image;
                }
                
                //get image params
                $query = "SELECT DISTINCT galImg.id,galImg.params FROM #__os_gallery_img as galImg".
                    "\n LEFT JOIN #__os_gallery_connect as galCon ON galCon.fk_gal_img_id = galImg.id".
                    "\n LEFT JOIN #__os_gallery_categories as cat ON cat.id = galCon.fk_cat_id".
                    "\n WHERE cat.fk_gal_id=".$galId;
                $db->setQuery($query);
                $imgParamsArray = $db->loadObjectList('id');
                
                $langParamsArray = array();
                foreach ($install_lang as $tag => $lang){
                    foreach($result as $img){
                        
                        $query = "SELECT type, value, item_id FROM #__os_gallery_lang WHERE fk_gall_id=$galId AND language='$tag' AND item_id=$img->id";
                        $db->setQuery($query);
                        //$img_lang = $db->loadObjectList();
                        $langParamsArray[$tag][$img->id] = $db->loadObjectList('type');
                    }
                    
                }
                
                foreach($imgParamsArray as $imgId => $imgParamsString){
                    
                    $imgParams = json_decode(rawurldecode($imgParamsString->params));
                    $imgParams =  (array) $imgParams;
                    
                    if($os_gallery_configuration->get('multilang', '0') == '1'){

                        foreach ($install_lang as $tag => $lang){
                            if(isset($langParamsArray[$tag][$imgId]['imgTitle'])){
                                $imgParams['imgTitle_'.$tag] = $langParamsArray[$tag][$imgId]['imgTitle']->value;
                            }elseif(!array_key_exists('imgTitle_'.$tag, $imgParams) && (array_key_exists('imgTitle', $imgParams) || (array_key_exists('imgTitle', $imgParams) && $imgParams['imgTitle'] == ''))){
                                $imgParams['imgTitle_'.$tag] = $imgParams['imgTitle'];
                            }else{
                                $imgParams['imgTitle_'.$tag] = '';
                            }
                            
                            if(isset($langParamsArray[$tag][$imgId]['imgShortDescription'])){
                                $imgParams['imgShortDescription_'.$tag] = $langParamsArray[$tag][$imgId]['imgShortDescription']->value;
                            }elseif(!array_key_exists('imgShortDescription_'.$tag, $imgParams) && (array_key_exists('imgShortDescription', $imgParams) || (array_key_exists('imgShortDescription', $imgParams) && $imgParams['imgShortDescription'] == ''))){
                                $imgParams['imgShortDescription_'.$tag] = $imgParams['imgShortDescription'];
                            }else{
                                $imgParams['imgShortDescription_'.$tag] = '';
                            }
                            
                            if(isset($langParamsArray[$tag][$imgId]['imgAlt'])){
                                $imgParams['imgAlt_'.$tag] = $langParamsArray[$tag][$imgId]['imgAlt']->value;
                            }elseif(!array_key_exists('imgAlt_'.$tag, $imgParams) && (array_key_exists('imgAlt', $imgParams) || (array_key_exists('imgAlt', $imgParams) && $imgParams['imgAlt'] == ''))){
                                $imgParams['imgAlt_'.$tag] = $imgParams['imgAlt'];
                            }else{
                                $imgParams['imgAlt_'.$tag] = '';
                            }
                            
                            if(isset($langParamsArray[$tag][$imgId]['imgLink'])){
                                $imgParams['imgLink_'.$tag] = $langParamsArray[$tag][$imgId]['imgLink']->value;
                            }elseif(!array_key_exists('imgLink_'.$tag, $imgParams) && (array_key_exists('imgLink', $imgParams) || (array_key_exists('imgLink', $imgParams) && $imgParams['imgLink'] == ''))){
                                $imgParams['imgLink_'.$tag] = $imgParams['imgLink'];
                            }else{
                                $imgParams['imgLink_'.$tag] = '';
                            }
                            
                            
                            $imgParams['imgHtml_'.$tag] = new stdClass();
                            
                            if(isset($langParamsArray[$tag][$imgId]['imgHtml'])){
                                $imgParams['imgHtml_'.$tag]->html = $langParamsArray[$tag][$imgId]['imgHtml']->value;
                            }elseif(!array_key_exists('imgHtml_'.$tag, $imgParams) && (array_key_exists('imgHtml', $imgParams) || (array_key_exists('imgHtml', $imgParams) && $imgParams['imgHtml'] == ''))){
                                $imgParams['imgHtml_'.$tag]->html = $imgParams['imgHtml'];
                            }else{
                                $imgParams['imgHtml_'.$tag]->html = '';
                            }
                            
                            if(isset($langParamsArray[$tag][$imgId]['videoLink'])){
                                $imgParams['videoLink_'.$tag] = $langParamsArray[$tag][$imgId]['videoLink']->value;
                            }elseif(!array_key_exists('videoLink_'.$tag, $imgParams) && (array_key_exists('videoLink', $imgParams) || (array_key_exists('videoLink', $imgParams) && $imgParams['videoLink'] == ''))){
                                $imgParams['videoLink_'.$tag] = $imgParams['videoLink'];
                            }else{
                                $imgParams['videoLink_'.$tag] = '';
                            }
                            
                        }
                    }else{
                        if(!array_key_exists('imgTitle', $imgParams)){
                            $imgParams['imgTitle'] = '';
                        }
                        if(!array_key_exists('imgShortDescription', $imgParams)){
                            $imgParams['imgShortDescription'] = '';
                        }
                        if(!array_key_exists('imgShortDescription', $imgParams)){
                            $imgParams['imgShortDescription'] = '';
                        }
                        if(!array_key_exists('imgAlt', $imgParams)){
                            $imgParams['imgAlt'] = '';
                        }
                        if(!array_key_exists('imgLink', $imgParams)){
                            $imgParams['imgLink'] = '';
                        }
                        if(!array_key_exists('videoLink', $imgParams)){
                            $imgParams['videoLink'] = '';
                        }
                        if(!array_key_exists('imgHtml', $imgParams)){
                            $imgParams['imgHtml'] = new stdClass();
                            $imgParams['imgHtml']->html = '';
                        }
                        
                        
                    }
                    if(!array_key_exists('imgTags', $imgParams)){
                        $imgParams['imgTags'] = array();
                    }
//                    
                    $imgParams =  (object) $imgParams;
                    $imgParamsArray[$imgId]->params = rawurlencode(json_encode($imgParams));
                }
                
            }
        }else{
            //crate new galery // get galerry id
            $query = "INSERT INTO #__os_gallery (params) VALUES ('{}')";
            $db->setQuery($query);
            $db->execute();
            $galId = $db->insertid();

            $query = "INSERT INTO #__os_gallery_categories(fk_gal_id,name,ordering,params) VALUES ($galId,'Category Title', '0', '{}')";
            $db->setQuery($query);
            $db->execute();

            //need for f5reload page without bugs//we go to else above if new gallery
            $app->redirect('index.php?option=com_osgallery&task=edit_gallery&galId='.$galId);
        }

        
        //load params
        $query = "SELECT params FROM #__os_gallery WHERE id=$galId";
        $db->setQuery($query);
        $paramsString = $db->loadResult();

        $params->loadString($paramsString);
        $externalGallerySelect = $params->get("externalGallerySettings", 0);
        if($externalGallerySelect > 0){
            $query = "SELECT params FROM #__os_gallery WHERE id=".$externalGallerySelect;
            $db->setQuery($query);
            $paramsString = $db->loadResult();
            $params->loadString($paramsString);
        }
        $fancy_box_background = $params->get("fancy_box_background", "rgba(0, 0, 0, 0.75)");
        $open_close_effect = $params->get("open_close_effect","none");
        $click_close = $params->get("click_close", 1);
        $helper_buttons = $params->get("helper_buttons",0);
        $helper_thumbnail = $params->get("helper_thumbnail",0);
        $loop = $params->get("loop", 1);
        $open_close_speed = $params->get("open_close_speed",500);
        $prev_next_effect = $params->get("prev_next_effect","none");
        $prev_next_speed = $params->get("prev_next_speed", 500);
        $img_title = $params->get("img_title","inside");
        $thumbnail_width = $params->get("thumbnail_width",50);
        $thumbnail_height = $params->get("thumbnail_height",50);
        $os_fancybox_arrows = $params->get("os_fancybox_arrows", 1);
        $os_fancybox_arrows_pos = $params->get("os_fancybox_arrows_pos",0);
        $close_button = $params->get("close_button",1);
        $next_click = $params->get("next_click",0);
        $mouse_wheel = $params->get("mouse_wheel",1);
        $os_fancybox_autoplay = $params->get("os_fancybox_autoplay",0);
        $autoplay_speed = $params->get("autoplay_speed",3000);
        $os_fancybox_thumbnail_position = $params->get("os_fancybox_thumbnail_position", "thumb_right");
        $infobar = $params->get("infobar", 1);

        //buttons setting
        $start_slideshow_button = $params->get("start_slideshow_button", 0);
        $full_screen_button = $params->get("full_screen_button", 0);
        $thumbnails_button = $params->get("thumbnails_button", 0);
        $share_button = $params->get("share_button", 0);
        $download_button = $params->get("download_button", 0);
        $zoom_button = $params->get("zoom_button", 0);
        $left_arrow = $params->get("left_arrow", 1);
        $right_arrow = $params->get("right_arrow", 1);
        $close_button = $params->get("close_button", 1);
        //buttons setting

        $watermark_position = $params->get("watermark_position","center");
        $watermark_opacity = $params->get("watermark_opacity",30);
        $watermark_size = $params->get("watermark_size",20);
        $watermark_file = $params->get("watermark_file","");
        $watermark_enable = $params->get("watermark_enable",0);
        $watermark_type = $params->get("watermark_type",1);
        $watermark_text = $params->get("watermark_text",'');
        $watermark_text_size = $params->get("watermark_text_size",17);
        $watermark_font = $params->get("watermark_font", 'default');
        $watermark_text_color = $params->get("watermark_text_color",'rgb(0, 0, 0)');
        $watermark_text_angle = $params->get("watermark_text_angle",0);
        $exist_watermark_text = $params->get("exist_watermark_text",'');

        $facebook_enable = $params->get("facebook_enable",0);
        $googleplus_enable = $params->get("googleplus_enable",0);
        $vkontacte_enable = $params->get("vkontacte_enable",0);
        $odnoklassniki_enable = $params->get("odnoklassniki_enable",0);
        $twitter_enable = $params->get("twitter_enable",0);
        $pinterest_enable = $params->get("pinterest_enable",0);
        $linkedin_enable = $params->get("linkedin_enable",0);

        $imageMargin = $params->get("image_margin",5);
        $numColumn = $params->get("num_column",3);
        $gallerylayout = $params->get("galleryLayout","defaultTabs");
        $albumSublayout = $params->get("albumSublayout","defaultTabs");
        $masonryLayout = $params->get("masonryLayout","");
        $imagehover = $params->get("imageHover","none");
        $minImgEnable = $params->get("minImgEnable",1);
        $minImgSize = $params->get("minImgSize",200);
        $imgWidth = $params->get("imgWidth",600);
        $imgHeight = $params->get("imgHeight",400);
        $showLoadMore = $params->get("showLoadMore",'0');
        $showLoadMoreForAllInOne = $params->get("showLoadMoreForAllInOne", "0");
        $showDownload = $params->get("showDownload",0);
        $showImgTitle = $params->get("showImgTitle",1);
        $showImgDescription = $params->get("showImgDescription",1);
        $numberImages = $params->get("number_images",5);
        $numberImagesEffect = $params->get("number_images_effect", 'zoomIn');
        $rotateImage = $params->get("rotateImage", 0);
        $tag_or_category = $params->get("tag_or_category", 1);
        $numberImagesAtOnce = $params->get("number_images_at_once",5);
        $numberImagesAtOnceEffect = $params->get("number_images_at_once_effect", 'zoomIn');
        $loadMoreButtonText = $params->get("loadMoreButtonText",JText::_("COM_OSGALLERY_SETTINGS_GENERAL_LOADMORE_BUTTON_TEXT"));
        $load_more_background = $params->get("load_more_background",'#12BBC5');
        $order = $params->get("order","");
        $orderBy = $params->get("orderBy","ASC");
        $imgTextPosition = $params->get("imgTextPosition","onImage");
        $imgTextHeight = $params->get("imgTextHeight",40);
        $imgMaxlengthTitle = $params->get("imgMaxlengthTitle", 100);
        $imgMaxlengthDesc = $params->get("imgMaxlengthDesc", 100);
        $externalGallerySelect = ($externalGallerySelect > 0) ? $externalGallerySelect : $params->get("externalGallerySettings","0");
        $imgMask = $params->get("imgMask", 'none');
        $background_color = $params->get("background_color", 'none');
        
        if($gallerylayout == 'allInOne'){
            $showLoadMore = $showLoadMoreForAllInOne;
        }
        $backButtonText = $params->get("backButtonText",JText::_("COM_OSGALLERY_SETTINGS_GENERAL_BACK_BUTTON_TEXT"));
        $title = '<span class="title-block input-block"><input id="gallery-title" type="text" placeholder="'.JText::_("COM_OSGALLERY_TITLE_LABEL").'" value="'.$galeryTitle.'" oninput="jQuery(\'#hidden-title\').val(jQuery(this).val())"></span>';
        JToolBarHelper::title($title, 'osgallery-title-image');
        if (JFactory::getUser()->authorise('core.edit.state', 'com_osgallery')) {
            JToolBarHelper::save('save_close_galery');
            JToolBarHelper::apply('save_gallery', 'JTOOLBAR_APPLY');
            JToolBarHelper::cancel('close_gallery', 'JTOOLBAR_CLOSE');
            JToolBarHelper::custom('open_gallery_settings', 'options.png', 'options.png', 'COM_OSGALLERY_TAB_GALLERY_SETTINGS', false);
        }
        
        $query = "SELECT id, title FROM #__os_gallery WHERE id <>".$galId;
        $db->setQuery($query);
        $external_galleries = $db->loadObjectList();
        $externalGalleriesList = array();
        $externalGalleriesList[] = JHTML::_('select.option','0','None');
        
        if($imagehover == 'tjava' || $imagehover == 'vadim' || $imagehover == 'vadim2'){
            $disabledRow = true;
        }else{
            $disabledRow = false;
        }
        
        
        if(!empty($external_galleries)){
            foreach ($external_galleries as $gallery){
                $externalGalleriesList[] = JHTML::_('select.option',$gallery->id,$gallery->title, 'value', 'text', $disable=true);
            }
        }
        
        $post_max_size = self::return_bytes(ini_get('post_max_size'));
        $upload_max_filesize = self::return_bytes(ini_get('upload_max_filesize'));
        
        if($post_max_size > $upload_max_filesize){
            $maxFileSize = $upload_max_filesize;
        }else{
            $maxFileSize = $post_max_size;
        }
        
        require self::findView('gallery');
    }

    static function saveGallery($close){
        
        global $gl_state, $os_gallery_configuration;

        $langs = JFactory::getLanguage();
        $default_lang_tag = $langs->getDefault();
        if (version_compare(JVERSION, "3.7.0", "ge")) {
            $install_lang = JLanguageHelper::getKnownLanguages();
        }else{
            $install_lang = JLanguage::getKnownLanguages();
        }
        
        if(!isset($gl_state->data) ){
            $response = array('success' => false, 'message' => JText::_('COM_OSGALLERY_YOU_NEED_ACTIVATE_LICENSE') );
            echo json_encode($response);
            return ;
        }


        $db = JFactory::getDbo();
        $app = JFactory::getApplication();
        $input  = $app->input;
        
        
        
        $formData = self::parse_str($input->get('formData', array(), 'ARRAY')[0]);
        $filesFormData = $input->get('filesFormData', '');
        
        foreach($formData as $key => $data){
            $input->set($key, $data);
        }

        $categoryNames = $input->get("category_names", '', 'ARRAY');
        $galId = $input->get("galId", 0, 'INT');
        $galleryTitle = strip_tags($input->get("gallery_title", '', 'STRING'));
        
        if($galId){
            //saving gallery params
            $externalGallerySettings = $input->get("externalGallerySettings","0","INT");
            if($externalGallerySettings > 0){
                $params = new JRegistry;
                $query = "SELECT params FROM #__os_gallery WHERE id=$externalGallerySettings";
                $db->setQuery($query);
                $paramsString = $db->loadResult();
                $params->loadString($paramsString);
                
                $oldParams = new JRegistry;
                $query = "SELECT params FROM #__os_gallery WHERE id=$galId";
                $db->setQuery($query);
                $oldParamsString = $db->loadResult();
                $oldParams->loadString($oldParamsString);
                
                if($params->get("watermark_enable") && $params->get("watermark_type") == 1){
                    $watermark_file = $params->get("watermark_file", "");
                    if($watermark_file != '' && !file_exists(JPATH_SITE . '/images/com_osgallery/gal-'.$galId.'/watermark/' . $watermark_file)){
                        copy(JPATH_SITE . '/images/com_osgallery/gal-'.$externalGallerySettings.'/watermark/' . $watermark_file, JPATH_SITE . '/images/com_osgallery/gal-'.$galId.'/watermark/' . $watermark_file);
                    }
                }
                
                $watermarkRedraw = self::getWatermarkRedraw($params, $oldParams);
                $watermarkRedrawText = self::getWatermarkRedrawText($params, $oldParams);
                
                $params->set("externalGallerySettings", $externalGallerySettings);
            }else{
                $params = new JRegistry;
                $query = "SELECT params FROM #__os_gallery WHERE id=$galId";
                $db->setQuery($query);
                $paramsString = $db->loadResult();
                $params->loadString($paramsString);
                $watermarkRedraw = new osGalleryHelperAdmin;
                $watermarkRedraw = self::getWatermarkRedraw($params, $input);
                $watermarkRedrawText = self::getWatermarkRedrawText($params, $input);

                $params->set("fancy_box_background", $input->get("fancy_box_background", "rgba(0, 0, 0, 0.75)", "STRING"));
                $params->set("open_close_effect", $input->get("open_close_effect","fade","STRING"));
                $params->set("click_close", $input->get("click_close", 1, "INT"));
                $params->set("helper_buttons", $input->get("helper_buttons",0,"INT"));
                $params->set("helper_thumbnail", $input->get("helper_thumbnail",1,"INT"));
                $params->set("loop", $input->get("loop",1,"INT"));
                $params->set("open_close_speed", $input->get("open_close_speed",500,"INT"));
                $params->set("prev_next_effect", $input->get("prev_next_effect","fade","STRING"));
                $params->set("prev_next_speed", $input->get("prev_next_speed",500,"INT"));
                $params->set("img_title", $input->get("img_title","","STRING"));
                $params->set("thumbnail_width", $input->get("thumbnail_width",50,"INT"));
                $params->set("thumbnail_height", $input->get("thumbnail_height",50,"INT"));
                $params->set("os_fancybox_arrows", $input->get("os_fancybox_arrows",1,"INT"));
                $params->set("os_fancybox_arrows_pos", $input->get("os_fancybox_arrows_pos",0,"INT"));
                $params->set("close_button", $input->get("close_button",1,"INT"));
                $params->set("next_click", $input->get("next_click",0,"INT"));
                $params->set("mouse_wheel", $input->get("mouse_wheel",1,"INT"));
                $params->set("os_fancybox_autoplay", $input->get("os_fancybox_autoplay",0,"INT"));
                $params->set("autoplay_speed", $input->get("autoplay_speed",3000,"INT"));
                $params->set("os_fancybox_thumbnail_position", $input->get("os_fancybox_thumbnail_position", "thumb_right", "STRING"));
                $params->set("infobar", $input->get("infobar", 1, "INT"));
                $params->set("order", $input->get("order","drag_and_drop","STRING"));
                $params->set("orderBy", $input->get("orderBy","ASC","STRING"));
                $params->set("imgTextPosition", $input->get("imgTextPosition","onImage","STRING"));
                $params->set("imgTextHeight", $input->get("imgTextHeight",40,"INT"));
                $params->set("imgMaxlengthTitle", $input->get("imgMaxlengthTitle",100,"INT"));
                $params->set("imgMaxlengthDesc", $input->get("imgMaxlengthDesc",100,"INT"));
                $params->set("externalGallerySettings", $input->get("externalGallerySettings","0","STRING"));
                $params->set("imgMask", $input->get("imgMask","none","STRING"));
                $params->set("background_color", $input->get("background_color","none","STRING"));

                //buttons
                $params->set("start_slideshow_button", $input->get("start_slideshow_button",1,"INT"));
                $params->set("full_screen_button", $input->get("full_screen_button",1,"INT"));
                $params->set("thumbnails_button", $input->get("thumbnails_button",1,"INT"));
                $params->set("share_button", $input->get("share_button",1,"INT"));
                $params->set("download_button", $input->get("download_button",1,"INT"));
                $params->set("zoom_button", $input->get("zoom_button",1,"INT"));
                $params->set("left_arrow", $input->get("left_arrow",1,"INT"));
                $params->set("right_arrow", $input->get("right_arrow",1,"INT"));
                $params->set("close_button", $input->get("close_button",1,"INT"));
                //buttons

                $params->set("imageHover", $input->get("imageHover",'dimas',"STRING"));

                $params->set("watermark_position", $input->get("watermark_position",'center',"STRING"));
                $params->set("watermark_opacity", $input->get("watermark_opacity",30,"INT"));
                $params->set("watermark_size", $input->get("watermark_size",20,"INT"));
                $params->set("watermark_enable", $input->get("watermark_enable",0,"INT"));
                $params->set("watermark_type", $input->get("watermark_type",1,"INT"));
                $params->set("watermark_text", $input->get("watermark_text",'',"STRING"));
                $params->set("watermark_text_color", $input->get("watermark_text_color",'rgb(0, 0, 0)',"STRING"));
                $params->set("watermark_text_size", $input->get("watermark_text_size",17,"INT"));
                $params->set("watermark_font", $input->get("watermark_font",'default',"STRING"));
                $params->set("watermark_text_angle", $input->get("watermark_text_angle",0,"INT"));
                $params->set("exist_watermark_text", $input->get("exist_watermark_text",'',"STRING"));
                $params->set("watermark_file", $input->get("exist_watermark_file",'',"STRING"));

                $params->set("backButtonText", $input->get("backButtonText",JText::_("COM_OSGALLERY_SETTINGS_GENERAL_BACK_BUTTON_TEXT"),"STRING"));
                $params->set("image_margin", $input->get("image_margin",5,"INT"));
                $params->set("num_column", $input->get("num_column",3,"INT"));
                $params->set("galleryLayout", $input->get("galleryLayout","defaultTabs","STRING"));
                $params->set("albumSublayout", $input->get("albumSublayout","defaultTabs","STRING"));
                $params->set("masonryLayout", $input->get("masonryLayout","","STRING"));
                $params->set("imageHover", $input->get("imageHover","julia","STRING"));
                $params->set("minImgEnable", $input->get("minImgEnable",1,"INT"));
                $params->set("minImgSize", $input->get("minImgSize",200,"INT"));
                $params->set("imgWidth", $input->get("imgWidth",600,"INT"));
                $params->set("imgHeight", $input->get("imgHeight",400,"INT"));
                $params->set("showLoadMore", $input->get("showLoadMore",'0',"STRING"));
                
                $params->set("showLoadMoreForAllInOne", $input->get("showLoadMoreForAllInOne", '0', 'STRING'));
                $params->set("showDownload", $input->get("showDownload",0,"INT"));
                $params->set("showImgTitle", 1);
                $params->set("showImgDescription", 1);
                $params->set("number_images", $input->get("number_images",5,"INT"));
                $params->set("number_images_effect", $input->get("number_images_effect", "zoomIn","STRING"));
                $params->set("rotateImage", $input->get("rotateImage", 0,"INT"));
                $params->set("tag_or_category", $input->get("tag_or_category", 0,"INT"));
                $params->set("number_images_at_once", $input->get("number_images_at_once",5,"INT"));
                $params->set("number_images_at_once_effect", $input->get("number_images_at_once_effect", "zoomIn","STRING"));
                $params->set("loadMoreButtonText", $input->get("loadMoreButtonText",JText::_("COM_OSGALLERY_SETTINGS_GENERAL_LOADMORE_BUTTON_TEXT"),"STRING"));
                $params->set("load_more_background", $input->get("load_more_background",'#12BBC5',"STRING"));

                $params->set("facebook_enable", 0);
                $params->set("googleplus_enable", 0);
                $params->set("vkontacte_enable", 0);
                $params->set("odnoklassniki_enable", 0);
                $params->set("twitter_enable", 0);
                $params->set("pinterest_enable", 0);
                $params->set("linkedin_enable", 0);
            }
            
            if($params->get("galleryLayout") == 'allInOneRow'){
                $imgOrderArrString = json_decode($input->get("imageOrderingArr", '', 'STRING'));
                foreach($imgOrderArrString as $cat){
                    if(count(explode(',', $cat)) < $params->get("num_column")){
                        $response = array('success' => false, 'message' => jText::_('COM_OSGALLERY_SETTINGS_NUM_COLLUMN_ERROR'));
                        echo json_encode($response);
                        exit;
                    }
                    

                }

            }
            $old_Params = new JRegistry;
            $query = "SELECT params FROM #__os_gallery WHERE id=$galId";
            $db->setQuery($query);
            $old_ParamsString = $db->loadResult();
            $old_Params->loadString($old_ParamsString);
            

            if($params->get("watermark_enable")){
                //img watermark
                $pathOrg = JPATH_SITE . '/images/com_osgallery/gal-'.$galId.'/original/';
                $pathWat = JPATH_SITE . '/images/com_osgallery/gal-'.$galId.'/original/watermark/';
                if($params->get("watermark_type")== 1){
                    
                    if($watermarkRedraw || $params->get('watermark_file', '') != $input->get('old_watermark_file')){
                    
                        $uploaddir = JPATH_SITE . '/images/com_osgallery/gal-'.$galId.'/original/watermark/';
                        if (!file_exists($uploaddir) || !is_dir($uploaddir)) mkdir($uploaddir, 0755, true);
                        $uploaddir = JPATH_SITE . '/images/com_osgallery/gal-'.$galId.'/watermark/';
                        if (!file_exists($uploaddir) || !is_dir($uploaddir)) mkdir($uploaddir, 0755, true);

                        
                            $files = scandir($pathOrg);

                            foreach($files as $file) {

                                if(strlen($file) > 10){
                                    self::createWaterMark($file, $galId, $params);
                                }
                            }
                        
                    }
                    $filesOriginal = scandir($pathOrg);
                    $filesWatermark = scandir($pathWat);
                    $diffFile = array_diff($filesOriginal, $filesWatermark);
                    
                    foreach($diffFile as $file) {
                        if(strlen($file) > 10){
                            self::createWaterMark($file, $galId, $params);
                        }
                    }
                }else{
                    if($watermarkRedrawText || ($input->get("watermark_text",'',"STRING") != $params->get("exist_watermark_text"))){
                        //text watermark
                        $filesOriginal = scandir($pathOrg);
                        foreach($filesOriginal as $file) {
                            if(strlen($file) > 10){
                                self::createWaterMark($file, $galId, $params);
                            }
                        }
                        $params->set("exist_watermark_text", strip_tags($input->get("watermark_text",'',"STRING")));
                    }else{
                        $filesOriginal = scandir($pathOrg);
                        $filesWatermark = scandir($pathWat);
                        $diffFile = array_diff($filesOriginal, $filesWatermark);
                        foreach($diffFile as $file) {
                            if(strlen($file) > 10){
                                self::createWaterMark($file, $galId, $params);
                            }
                        }
                    }
                }
            }

            /** Add masonry **/
            $dir = JPATH_SITE . '/images/com_osgallery/gal-'.$galId;

            if($params->get("galleryLayout") == "masonry" || ($params->get("galleryLayout") == "albumMode" && $params->get("albumSublayout") == 'masonry')) {
                if (!file_exists($dir . '/thumbnail_masonry') || !is_dir($dir)) mkdir($dir . '/thumbnail_masonry', 0755, true);
                if (!file_exists($dir . '/thumbnail_masonry/default') || !is_dir($dir)) mkdir($dir . '/thumbnail_masonry/default', 0755, true);
                if (!file_exists($dir . '/thumbnail_masonry/horizontal') || !is_dir($dir)) mkdir($dir . '/thumbnail_masonry/horizontal', 0755, true);
                if (!file_exists($dir . '/thumbnail_masonry/vertical') || !is_dir($dir)) mkdir($dir . '/thumbnail_masonry/vertical', 0755, true);  
                $old_Params = new JRegistry;
                $query = "SELECT params FROM #__os_gallery WHERE id=$galId";
                $db->setQuery($query);
                $old_ParamsString = $db->loadResult();
                $old_Params->loadString($old_ParamsString);

                self::createImageThumbnailForMasonry($params->get("masonryLayout"), $old_Params);
            }
            if($params->get("galleryLayout") == "fit_rows" || ($params->get("galleryLayout") == "albumMode" && $params->get("albumSublayout") == 'fit_rows')) {
                if (!file_exists($dir . '/thumbnail_fitrows') || !is_dir($dir)) mkdir($dir . '/thumbnail_fitrows', 0755, true);
                $old_Params = new JRegistry;
                $query = "SELECT params FROM #__os_gallery WHERE id=$galId";
                $db->setQuery($query);
                $old_ParamsString = $db->loadResult();
                $old_Params->loadString($old_ParamsString);
                self::createImageThumbnailForMasonry("fit_rows", $old_Params);
            }
            if (!file_exists($dir . '/thumbnail_165_110') || !is_dir($dir)) mkdir($dir . '/thumbnail_165_110', 0755, true);
            if (!file_exists($dir . '/original') || !is_dir($dir)) mkdir($dir . '/original', 0755, true);
            $images = scandir("{$dir}/original");
            foreach ($images as $image) {
            if (!self::checkImgExtension($image)) continue;
                $pathinfo = pathinfo($image);
                $filename = $pathinfo['filename'];
                $ext = $pathinfo['extension'];
                if(!file_exists($dir . '/thumbnail_165_110/'.$filename.'.'.$ext)){
                    self::createImageThumbnail($dir . "/original/{$filename}.{$ext}", $dir .
                         "/thumbnail_165_110/{$filename}.{$ext}", 165, 110, 1);
                }
            }

            /*****************/ 

            // if($galleryTitle){
                $query = "UPDATE #__os_gallery SET title=".$db->quote($galleryTitle).
                                                    ",params=".$db->Quote($params->toString()).
                        "\n WHERE id=$galId";
                $db->setQuery($query);
                $db->execute();
            // }
            
            if($categoryNames){
                
                foreach($categoryNames as $catName){
                    
                    $catName = explode('|+|', $catName);
                    
                    if(!empty($catName[0]) && !empty($catName[1])){
                        $catId = $catName[0];
                        $catName = strip_tags($catName[1]);
                        $query = "SELECT id FROM #__os_gallery_categories WHERE id=".$catId;
                        $db->setQuery($query);
                        $existCat = $db->loadResult();
                        if($existCat){
                            $query = "UPDATE #__os_gallery_categories SET name=".$db->Quote($catName)." WHERE id=".$catId;
                            $db->setQuery($query);
                            $db->execute();
                        }else{
                            $query = "INSERT INTO #__os_gallery_categories(id,fk_gal_id,name, ordering, params)"
                                    ."\n VALUES($catId, $galId,".$db->Quote($catName).", 0, '{}')";
                            $db->setQuery($query);
                            $db->execute();
                        }
                    }
                    
                }
            }

            //cat ordering
            $catOrderString = $input->get("catOrderIds", '', 'STRING');
            $catParamsArr = $input->get("catSettings",array(),"ARRAY");
            
            if($catOrderString){
                $orderArray = explode(',', str_replace('order-id-', '', $catOrderString));
                
                if(isset($orderArray[0])){
                    foreach ($orderArray as $order => $catId) {
                        if($os_gallery_configuration->get('multilang', '0') == '1'){
                            $catParams = json_decode(rawurldecode($catParamsArr[$catId]));
                            $catParams = (array) $catParams;
                            
                            foreach ($install_lang as $tag => $lang){
                                
                                if(array_key_exists('categoryAlias_'.$tag, $catParams)){
                                    
                                    $query = "SELECT id, value FROM #__os_gallery_lang WHERE language='$tag' AND item_id='$catId' AND type='categoryAlias'";
                                    $db->setQuery($query);
                                    $old = $db->loadObjectList();
                                    if(!empty($old)){
                                        if($old[0]->value != $catParams['categoryAlias_'.$tag]){
                                            $query = "UPDATE #__os_gallery_lang SET value=".$db->quote($catParams['categoryAlias_'.$tag])." WHERE id=".$old[0]->id;
                                            $db->setQuery($query);
                                            $db->execute();
                                        }
                                    }else{
                                        $query = "INSERT INTO #__os_gallery_lang (language, fk_gall_id, type, item_id, value) VALUE ('$tag', '$galId', 'categoryAlias', $catId, ".$db->quote($catParams['categoryAlias_'.$tag]).")";
                                        $db->setQuery($query);
                                        $db->execute();
                                    }
                                }
                                
                                if(array_key_exists('categoryDescription_'.$tag, $catParams)){
                                    
                                    $query = "SELECT id, value FROM #__os_gallery_lang WHERE language='$tag' AND item_id='$catId' AND type='categoryDescription'";
                                    $db->setQuery($query);
                                    $old = $db->loadObjectList();
                                    if(!empty($old)){
                                        if($old[0]->value != $catParams['categoryDescription_'.$tag]){
                                            $query = "UPDATE #__os_gallery_lang SET value=".$db->quote($catParams['categoryDescription_'.$tag])." WHERE id=".$old[0]->id;
                                            $db->setQuery($query);
                                            $db->execute();
                                        }
                                    }else{
                                        $query = "INSERT INTO #__os_gallery_lang (language, fk_gall_id, type, item_id, value) VALUE ('$tag', '$galId', 'categoryDescription', $catId, ".$db->quote($catParams['categoryDescription_'.$tag]).")";
                                        $db->setQuery($query);
                                        $db->execute();
                                    }
                                }
                            }
                            
                        }else{

                        }
                        $query = "UPDATE #__os_gallery_categories SET ordering=".$order.",".
                                "\n params=".$db->Quote($catParamsArr[$catId])." WHERE id=".$catId;
                        $db->setQuery($query);
                        $db->execute();
                    }
                }
            }

            //img ordering
            $imgOrderArrString = json_decode($input->get("imageOrderingArr", '', 'STRING'));

            $imgParamsArr = $input->get("imgSettings",array(),"ARRAY");

                        
            if(!empty($imgOrderArrString)){
                foreach ($imgOrderArrString as $catId => $imgIdStr) {
                    
                    if($imgIdStr){
                        $imgIds = explode(',', str_replace('img-', '', $imgIdStr));
                        
                        foreach ($imgIds as $imgOrder => $imgId) {
                            if($os_gallery_configuration->get('multilang', '0') == '1'){
                                $imgParams = json_decode(rawurldecode($imgParamsArr[$imgId]));
                                $imgParams =  (array) $imgParams;
                                
                                $old_imgParams = new JRegistry;
                                $query = "SELECT params FROM #__os_gallery_img WHERE id=$galId";
                                $db->setQuery($query);
                                $old_ParamsString = $db->loadResult();
                                $old_imgParams->loadString($old_ParamsString);
                                foreach ($install_lang as $tag => $lang){
                                
                                    if(array_key_exists('imgTitle_'.$tag, $imgParams)){
                                        
                                        if($old_imgParams->get('imgTitle_'.$tag, '') != $imgParams['imgTitle_'.$tag]){
                                            $query = "SELECT id, value FROM #__os_gallery_lang WHERE language='$tag' AND item_id='$imgId' AND type='imgTitle'";
                                            $db->setQuery($query);
                                            $old = $db->loadObjectList();
                                            if(!empty($old)){
                                                if($old[0]->value != $imgParams['imgTitle_'.$tag]){
                                                    $query = "UPDATE #__os_gallery_lang SET value=".$db->quote($imgParams['imgTitle_'.$tag])." WHERE id=".$old[0]->id;
                                                    $db->setQuery($query);
                                                    $db->execute();
                                                }
                                            }else{
                                                $query = "INSERT INTO #__os_gallery_lang (language, fk_gall_id, type, item_id, value) VALUE ('$tag', '$galId', 'imgTitle', $imgId, ".$db->quote($imgParams['imgTitle_'.$tag]).")";
                                                $db->setQuery($query);
                                                $db->execute();
                                            }
                                        }
                                    }

                                    if(array_key_exists('imgShortDescription_'.$tag, $imgParams)){
                                        if($old_imgParams->get('imgShortDescription_'.$tag, '') != $imgParams['imgShortDescription_'.$tag]){
                                            $query = "SELECT id, value FROM #__os_gallery_lang WHERE language='$tag' AND item_id='$imgId' AND type='imgShortDescription'";
                                            $db->setQuery($query);
                                            $old = $db->loadObjectList();
                                            if(!empty($old)){
                                                if($old[0]->value != $imgParams['imgShortDescription_'.$tag]){
                                                    $query = "UPDATE #__os_gallery_lang SET value=".$db->quote($imgParams['imgShortDescription_'.$tag])." WHERE id=".$old[0]->id;
                                                    $db->setQuery($query);
                                                    $db->execute();
                                                }
                                            }else{
                                                $query = "INSERT INTO #__os_gallery_lang (language, fk_gall_id, type, item_id, value) VALUE ('$tag', '$galId', 'imgShortDescription', $imgId, ".$db->quote($imgParams['imgShortDescription_'.$tag]).")";
                                                $db->setQuery($query);
                                                $db->execute();
                                            }
                                        }
                                    }

                                    if(array_key_exists('imgAlt_'.$tag, $imgParams)){
                                        if($old_imgParams->get('imgAlt_'.$tag, '') != $imgParams['imgAlt_'.$tag]){
                                            $query = "SELECT id, value FROM #__os_gallery_lang WHERE language='$tag' AND item_id='$imgId' AND type='imgAlt'";
                                            $db->setQuery($query);
                                            $old = $db->loadObjectList();
                                            if(!empty($old)){
                                                if($old[0]->value != $imgParams['imgAlt_'.$tag]){
                                                    $query = "UPDATE #__os_gallery_lang SET value=".$db->quote($imgParams['imgAlt_'.$tag])." WHERE id=".$old[0]->id;
                                                    $db->setQuery($query);
                                                    $db->execute();
                                                }
                                            }else{
                                                $query = "INSERT INTO #__os_gallery_lang (language, fk_gall_id, type, item_id, value) VALUE ('$tag', '$galId', 'imgAlt', $imgId, ".$db->quote($imgParams['imgAlt_'.$tag]).")";
                                                $db->setQuery($query);
                                                $db->execute();
                                            }
                                        }
                                    }
                                    if(array_key_exists('imgLink_'.$tag, $imgParams)){
                                        if($old_imgParams->get('imgLink_'.$tag, '') != $imgParams['imgLink_'.$tag]){
                                            $query = "SELECT id, value FROM #__os_gallery_lang WHERE language='$tag' AND item_id='$imgId' AND type='imgLink'";
                                            $db->setQuery($query);
                                            $old = $db->loadObjectList();
                                            if(!empty($old)){
                                                if($old[0]->value != $imgParams['imgLink_'.$tag]){
                                                    $query = "UPDATE #__os_gallery_lang SET value=".$db->quote($imgParams['imgLink_'.$tag])." WHERE id=".$old[0]->id;
                                                    $db->setQuery($query);
                                                    $db->execute();
                                                }
                                            }else{
                                                $query = "INSERT INTO #__os_gallery_lang (language, fk_gall_id, type, item_id, value) VALUE ('$tag', '$galId', 'imgLink', $imgId, ".$db->quote($imgParams['imgLink_'.$tag]).")";
                                                $db->setQuery($query);
                                                $db->execute();
                                            }
                                        }
                                    }
                                    if(array_key_exists('videoLink_'.$tag, $imgParams)){
                                        if($old_imgParams->get('videoLink_'.$tag, '') != $imgParams['videoLink_'.$tag]){
                                            $query = "SELECT id, value FROM #__os_gallery_lang WHERE language='$tag' AND item_id='$imgId' AND type='videoLink'";
                                            $db->setQuery($query);
                                            $old = $db->loadObjectList();
                                            if(!empty($old)){
                                                if($old[0]->value != $imgParams['videoLink_'.$tag]){
                                                    $query = "UPDATE #__os_gallery_lang SET value=".$db->quote($imgParams['videoLink_'.$tag])." WHERE id=".$old[0]->id;
                                                    $db->setQuery($query);
                                                    $db->execute();
                                                }
                                            }else{
                                                $query = "INSERT INTO #__os_gallery_lang (language, fk_gall_id, type, item_id, value) VALUE ('$tag', '$galId', 'videoLink', $imgId, ".$db->quote($imgParams['videoLink_'.$tag]).")";
                                                $db->setQuery($query);
                                                $db->execute();
                                            }
                                        }
                                    }
                                    if(array_key_exists('imgHtml_'.$tag, $imgParams)){
                                        if($old_imgParams->get('imgHtml_'.$tag, '') != $imgParams['imgHtml_'.$tag]){
                                            $query = "SELECT id, value FROM #__os_gallery_lang WHERE language='$tag' AND item_id='$imgId' AND type='imgHtml'";
                                            $db->setQuery($query);
                                            $old = $db->loadObjectList();
                                            if(!empty($old)){
                                                if($old[0]->value != $imgParams['imgHtml_'.$tag]){
                                                    
                                                    $query = "UPDATE #__os_gallery_lang SET value=".$db->quote((is_object($imgParams['imgHtml_'.$tag])) ? $imgParams['imgHtml_'.$tag]->html : $imgParams['imgHtml_'.$tag])." WHERE id=".$old[0]->id;
                                                    $db->setQuery($query);
                                                    $db->execute();
                                                }
                                            }else{
                                                $query = "INSERT INTO #__os_gallery_lang (language, fk_gall_id, type, item_id, value) VALUE ('$tag', '$galId', 'imgHtml', $imgId, ".$db->quote((is_object($imgParams['imgHtml_'.$tag])) ? $imgParams['imgHtml_'.$tag]->html : $imgParams['imgHtml_'.$tag]).")";
                                                $db->setQuery($query);
                                                $db->execute();
                                            }
                                        }
                                    }
                                
                                }
                                $imgParams =  (object) $imgParams;
                                $imgParamsArr[$imgId] = rawurlencode(json_encode($imgParams));
                                
                                $imgPublish = (property_exists($imgParams, 'img_publish')) ? $imgParams->img_publish : 'yes';
                                if($imgPublish == 'no'){
                                    $imgPublish = 0;
                                }else{
                                    $imgPublish = 1;
                                }
                                
                                if($params->get("order", "drag_and_drop") == 'drag_and_drop'){
                                    $query = "UPDATE #__os_gallery_img SET ordering=".$imgOrder.",".
                                            "\n params=".$db->quote($imgParamsArr[$imgId]).", " . "publish='" . $imgPublish . "' WHERE id=".$imgId;
                                    $query2 = "UPDATE #__os_gallery_connect SET ordering=".$imgOrder." WHERE fk_gal_img_id =".$imgId." AND fk_cat_id=".$catId;
                                }else{
                                    $query = "UPDATE #__os_gallery_img SET " .
                                            "\n params=".$db->quote($imgParamsArr[$imgId]).", " . "publish='" . $imgPublish . "' WHERE id=".$imgId;
                                    $query2 = "UPDATE #__os_gallery_connect SET ordering=".$imgOrder." WHERE fk_gal_img_id =".$imgId." AND fk_cat_id=".$catId;
                                }
                                $db->setQuery($query);
                                $db->execute();
                                $db->setQuery($query2);
                                $db->execute();
                            }else{

                                $imgParams = json_decode(rawurldecode($imgParamsArr[$imgId]));
                                $imgParams =  (array) $imgParams;

                                if($imgParams['imgHtml']->html == '[object Object]') $imgParams['imgHtml']->html = '';

                                $imgParams =  (object) $imgParams;
                                $imgParamsArr[$imgId] = rawurlencode(json_encode($imgParams));
                                
                                $imgTitle = isset(json_decode(rawurldecode($imgParamsArr[$imgId]))->imgTitle) ? json_decode(rawurldecode($imgParamsArr[$imgId]))->imgTitle : '';
                                $imgDescript = isset(json_decode(rawurldecode($imgParamsArr[$imgId]))->imgShortDescription) ? json_decode(rawurldecode($imgParamsArr[$imgId]))->imgShortDescription : '';
                                $imgPublish = isset(json_decode(rawurldecode($imgParamsArr[$imgId]))->img_publish) ? json_decode(rawurldecode($imgParamsArr[$imgId]))->img_publish : 'yes';
                                if($imgPublish == 'no'){
                                    $imgPublish = 0;
                                }else{
                                    $imgPublish = 1;
                                }
                                if($params->get("order", "drag_and_drop") == 'drag_and_drop'){
                                    $query = "UPDATE #__os_gallery_img SET ordering=".$imgOrder.",".
                                            "\n params=".$db->quote($imgParamsArr[$imgId]).", title=" . $db->quote($imgTitle) . ", " . "description=" . $db->quote($imgDescript) . ", " . "publish='" . $imgPublish . "' WHERE id=".$imgId;
                                    $query2 = "UPDATE #__os_gallery_connect SET ordering=".$imgOrder." WHERE fk_gal_img_id =".$imgId." AND fk_cat_id=".$catId;
                                }else{
                                    $query = "UPDATE #__os_gallery_img SET " .
                                            "\n params=".$db->quote($imgParamsArr[$imgId]).", title=" . $db->quote($imgTitle) . ", " . "description=" . $db->quote($imgDescript) . ", " . "publish='" . $imgPublish . "' WHERE id=".$imgId;
                                    $query2 = "UPDATE #__os_gallery_connect SET ordering=".$imgOrder." WHERE fk_gal_img_id =".$imgId." AND fk_cat_id=".$catId;
                                }
                                $db->setQuery($query);
                                $db->execute();
                                $db->setQuery($query2);
                                $db->execute();
                            }
                        }
                        
                    }
                }
            }
            
//exit;
            $deletedImgIds = $input->get("deletedImgIds", '', 'ARRAY');
            


            // add crop images
            $imgWidth = $input->get("imgWidth",600,"INT");
            $imgHeight = $input->get("imgHeight",400,"INT");

            if ( !isset($deletedImgIds[0])) {
                self::cropImages($galId, $params->get("galleryLayout"), $imgWidth, $imgHeight, $old_Params);
            }
            // end crop

            if(isset($deletedImgIds[0])){
                
                foreach ($deletedImgIds as $delImgId) {
                    $delImgId = json_decode($delImgId);
                    $delImgCatId = $delImgId->cat_id;
                    $delImgId = $delImgId->imgId;
                    
                    
                    $query = "DELETE FROM #__os_gallery_connect".
                            "\n WHERE fk_gal_img_id=$delImgId AND fk_cat_id=$delImgCatId";
                    $db->setQuery($query);
                    $db->execute();
                    
                    $query = "SELECT fk_cat_id FROM #__os_gallery_connect ".
                            "\n WHERE fk_gal_img_id=$delImgId";
                    $db->setQuery($query);
                    $other_cats_img = $db->loadObjectList();
                    if(empty($other_cats_img)){
                        $query = "SELECT gim.file_name FROM #__os_gallery_img as gim ".
                                "\n WHERE id=$delImgId";
                        $db->setQuery($query);

                        $imgForDelete = $db->loadResult();

                        if(empty($imgForDelete)) continue ;

                        $imageFolderPath = JPATH_SITE . '/images/com_osgallery/gal-'.$galId;
                        //delete original
                        if(file_exists($imageFolderPath.'/original/'.$imgForDelete)){
                           unlink($imageFolderPath.'/original/'.$imgForDelete);
                        }
                        //delete watermark image
                        if(file_exists($imageFolderPath.'/original/watermark/'.$imgForDelete)){
                           unlink($imageFolderPath.'/original/watermark/'.$imgForDelete);
                        }
                        //delete thumbnail
                        if(file_exists($imageFolderPath.'/thumbnail/'.$imgForDelete)){
                            unlink($imageFolderPath.'/thumbnail/'.$imgForDelete );
                        }
                        $img_arr = explode('.', $imgForDelete);
                        $img_ext = $img_arr[count($img_arr) -1];
                        unset($img_arr[count($img_arr) -1]);
                        $img_name = implode('.', $img_arr);
                        
                        $img_name = self::getImageThumbnailName($img_name, $imgHeight, $imgWidth).'.'.$img_ext;
                        //delete new thumbnail
                        if(file_exists($imageFolderPath.'/thumbnail/'.$img_name)){
                            unlink($imageFolderPath.'/thumbnail/'.$img_name);
                        }
                        //delete new thumbnail 165*110
                        if(file_exists($imageFolderPath.'/thumbnail_165_110/'.$imgForDelete)){
                            unlink($imageFolderPath.'/thumbnail_165_110/'.$imgForDelete);
                        }
                        // delete masonry default
                        if(file_exists($imageFolderPath.'/thumbnail_masonry/default/'.$imgForDelete)){
                           unlink($imageFolderPath.'/thumbnail_masonry/default/'.$imgForDelete);
                        }
                        // delete masonry horizontal
                        if(file_exists($imageFolderPath.'/thumbnail_masonry/horizontal/'.$imgForDelete)){
                           unlink($imageFolderPath.'/thumbnail_masonry/horizontal/'.$imgForDelete);
                        }
                        // delete masonry vertical
                        if(file_exists($imageFolderPath.'/thumbnail_masonry/vertical/'.$imgForDelete)){
                           unlink($imageFolderPath.'/thumbnail_masonry/vertical/'.$imgForDelete);
                        }
                        // delete fit_rows
                        if(file_exists($imageFolderPath.'/thumbnail_fitrows/'.$imgForDelete)){
                           unlink($imageFolderPath.'/thumbnail_fitrows/'.$imgForDelete);
                        }
                        
                        $query = "DELETE FROM #__os_gallery_connect".
                                "\n WHERE fk_gal_img_id=$delImgId";
                        $db->setQuery($query);
                        $db->execute();

                        $query = "DELETE FROM #__os_gallery_img".
                                "\n WHERE id=$delImgId";
                        $db->setQuery($query);
                        $db->execute();
                    }
                }
            }

            $deletedCatIds = $input->get("deletedCatIds", '', 'ARRAY');
            if(isset($deletedCatIds[0])){
                foreach ($deletedCatIds as $delCatId) {
                    //get images name for delete
                    $query = "SELECT gim.file_name FROM #__os_gallery_img as gim ".
                            "\n LEFT JOIN #__os_gallery_connect as gc ON gc.fk_gal_img_id=gim.id".
                            "\n WHERE gc.fk_cat_id=$delCatId";
                    $db->setQuery($query);
                    $imgForDelete = $db->loadColumn();

                    //delete inages from folder
                    foreach ($imgForDelete as $imgLink) {
                        $imageFolderPath = JPATH_SITE . '/images/com_osgallery/gal-'.$galId;
                    
                        if(empty($imgLink)) continue ;

                        //delete original
                        if(file_exists($imageFolderPath.'/original/'.$imgLink)){
                           unlink($imageFolderPath.'/original/'.$imgLink);
                        }
                        //delete watermark image
                        if(file_exists($imageFolderPath.'/original/watermark/'.$imgLink)){
                           unlink($imageFolderPath.'/original/watermark/'.$imgLink);
                        }
                        //delete thumbnail
                        if(file_exists($imageFolderPath.'/thumbnail/'.$imgLink)){
                            unlink($imageFolderPath.'/thumbnail/'.$imgLink);
                        }
                        $img_arr = explode('.', $imgLink);
                        $img_ext = $img_arr[count($img_arr) -1];
                        unset($img_arr[count($img_arr) -1]);
                        $img_name = implode('.', $img_arr);

                        $img_name = self::getImageThumbnailName($img_name, $imgHeight, $imgWidth).'.'.$img_ext;
                        //delete new thumbnail
                        if(file_exists($imageFolderPath.'/thumbnail/'.$img_name)){
                            unlink($imageFolderPath.'/thumbnail/'.$img_name);
                        }
                        //delete new thumbnail 165*110
                        if(file_exists($imageFolderPath.'/thumbnail_165_110/'.$imgLink)){
                            unlink($imageFolderPath.'/thumbnail_165_110/'.$imgLink);
                        }
                        // delete masonry default
                        if(file_exists($imageFolderPath.'/thumbnail_masonry/default/'.$imgLink)){
                           unlink($imageFolderPath.'/thumbnail_masonry/default/'.$imgLink);
                        }
                        // delete masonry horizontal
                        if(file_exists($imageFolderPath.'/thumbnail_masonry/horizontal/'.$imgLink)){
                           unlink($imageFolderPath.'/thumbnail_masonry/horizontal/'.$imgLink);
                        }
                        // delete masonry vertical
                        if(file_exists($imageFolderPath.'/thumbnail_masonry/vertical/'.$imgLink)){
                           unlink($imageFolderPath.'/thumbnail_masonry/vertical/'.$imgLink);
                        }
                        // delete fit_rows
                        if(file_exists($imageFolderPath.'/thumbnail_fitrows/'.$imgLink)){
                           unlink($imageFolderPath.'/thumbnail_fitrows/'.$imgLink);
                        }

                    }

                    //delete img from db
                    $query = "DELETE gim FROM #__os_gallery_img as gim ".
                                "\n LEFT JOIN #__os_gallery_connect as gc ON gc.fk_gal_img_id=gim.id".
                                "\n WHERE gc.fk_cat_id=$delCatId";
                    $db->setQuery($query);
                    $db->execute();

                    //delete img from connect table
                    $query = "DELETE FROM #__os_gallery_connect WHERE fk_cat_id=$delCatId";
                    $db->setQuery($query);
                    $db->execute();

                    //delete img cat from db
                    $query = "DELETE FROM #__os_gallery_categories WHERE id=$delCatId";
                    $db->setQuery($query);
                    $db->execute();
                }
            }
            if($close){
                $app->enqueueMessage('Gallery successfully saved.');
            }
            else{
                $response = array('success' => true, 'message' => 'Gallery successfully saved.', 'params' =>$params->toString());
                echo json_encode($response);
            }
        }else{
            if($close){
                $app->enqueueMessage('Empty gallery can\'t be saved.', 'error');
            }
            else{
                $response = array('success' => false, 'message' => 'Empty gallery can\'t be saved.');
                echo json_encode($response);
            }
        }

        if($close)
            $app->redirect('index.php?option=com_osgallery');
    }

    static function cloneGallery($galId, $withImage){
        global $gl_state;

        if(!isset($gl_state->data) ){
            echo '<script>alert("'.JText::_('COM_OSGALLERY_YOU_NEED_ACTIVATE_LICENSE').'"); history.back(); </script>';
            return ;
        }

        $db = JFactory::getDbo();
        $app = JFactory::getApplication();
        $input  = $app->input;

        if(isset($galId[0])){
            if($withImage){
                $query = "SELECT title, published, params FROM #__os_gallery"
                        ."\n WHERE id = $galId[0]";
                $db->setQuery($query);
                $oldGalData = $db->loadObjectList();
                $oldGalData = $oldGalData[0];

                $query = "INSERT INTO #__os_gallery(title, published, params)"
                        ."\n VALUES('".$db->escape($oldGalData->title).'(COPY)'."','".$db->escape($oldGalData->published)."','".$db->escape($oldGalData->params)."' )";
                $db->setQuery($query);
                $db->execute();
                $newGalleryId = $db->insertid();

                $query = "SELECT * FROM #__os_gallery_categories WHERE fk_gal_id=$galId[0]";
                $db->setQuery($query);
                $result = $db->loadObjectList();
                if(count($result)){
                    foreach ($result as $insertData) {
                        
                        $query = "INSERT INTO #__os_gallery_categories(name, fk_gal_id, ordering, params)"
                                ."\n VALUES('".$insertData->name."',$newGalleryId,"
                                ."\n '".$insertData->ordering."','".$insertData->params."')";
                        $db->setQuery($query);
                        $db->execute();
                        $newCatId = $db->insertid();
                        
                        $query = "SELECT * FROM #__os_gallery_lang WHERE item_id=$insertData->id AND (type='categoryAlias' OR type='categoryDescription')";
                        $db->setQuery($query);
                        $category_langs = $db->loadObjectList();
                        
                        if(!empty($category_langs)){
                            foreach($category_langs as $lang){
                                $query = "INSERT INTO #__os_gallery_lang (fk_gall_id, language, type, item_id, value)"
                                        ."\n VALUES(".$newGalleryId.",'$lang->language', '$lang->type',"
                                        ."\n $newCatId,'".$lang->value."')";
                                $db->setQuery($query);
                                $db->execute();
                            }
                        }

                        $query = "SELECT galImg.file_name, galImg.src, galImg.ordering, galImg.params, galImg.id, galImg.title, galImg.description"
                                ."\n FROM #__os_gallery_img as galImg"
                                ."\n LEFT JOIN #__os_gallery_connect as galCon ON galCon.fk_gal_img_id=galImg.id"
                                ."\n LEFT JOIN #__os_gallery_categories as cat ON cat.id=galCon.fk_cat_id"
                                ."\n WHERE cat.id = $insertData->id";
                        $db->setQuery($query);
                        $images = $db->loadObjectList();
                        if($images){
                            foreach ($images as $image) {
                                $query = "INSERT INTO #__os_gallery_img(file_name, src, ordering, params, title, description)"
                                        ."\n VALUES(".$db->Quote($image->file_name).",".$db->Quote($image->src).""
                                        ."\n ,'".$image->ordering."',".$db->Quote($image->params).",".$db->Quote($image->title).",".$db->Quote($image->description).")";
                                $db->setQuery($query);
                                $db->execute();
                                $newImgId = $db->insertid();
                                
                                $query = "SELECT * FROM #__os_gallery_lang WHERE item_id=$image->id AND type!='categoryAlias' AND type!='categoryDescription'";
                                $db->setQuery($query);
                                $img_langs = $db->loadObjectList();
                                
                                if(!empty($img_langs)){
                                    foreach ($img_langs as $lang){
                                        $query = "INSERT INTO #__os_gallery_lang (fk_gall_id, language, type, item_id, value)"
                                        ."\n VALUES('".$newGalleryId."','$lang->language', '$lang->type',"
                                        ."\n '$newImgId',".$db->quote($lang->value).")";
                                        $db->setQuery($query);
                                        $db->execute();
                                    }
                                }

                                $query = "INSERT INTO #__os_gallery_connect(fk_gal_img_id, fk_cat_id) "
                                        ."\n VALUES(".$newImgId.",".$newCatId.")";
                                $db->setQuery($query);
                                $db->execute();
                            }
                        }
                    }
                    //clone images


                    $src = JPATH_SITE . '/images/com_osgallery/gal-'.$galId[0];
                    if(opendir($src)){
                        $dst = JPATH_SITE . '/images/com_osgallery/gal-'.$newGalleryId;
                        self::recurse_copy($src,$dst);
                    }
                    $app->enqueueMessage(JText::_("COM_OSGALLERY_DUBLICATE_SUCCESSFULLY"));
                }
            }else{
                $query = "SELECT title, published, params FROM #__os_gallery"
                        ."\n WHERE id = $galId[0]";
                $db->setQuery($query);
                $oldGalData = $db->loadObjectList();
                $oldGalData = $oldGalData[0];

                $query = "INSERT INTO #__os_gallery(title, published, params)"
                        ."\n VALUES('".$db->escape($oldGalData->title).'(COPY)'."','".$db->escape($oldGalData->published)."','".$db->escape($oldGalData->params)."' )";
                $db->setQuery($query);
                $db->execute();

                $query = "INSERT INTO #__os_gallery_categories(fk_gal_id,name,params, ordering) VALUES (".$db->insertid().",'Category Title','{}', '0')";
                $db->setQuery($query);
                $db->execute();

                $app->enqueueMessage(JText::_("COM_OSGALLERY_DUBLICATE_SUCCESSFULLY"));
            }
        }else{
            $app->enqueueMessage('Please select gallery to clone.', 'error');
        }
        $app->redirect('index.php?option=com_osgallery');
    }

    static function recurse_copy($src,$dst) {
        $dir = opendir($src);
        @mkdir($dst);
        while(false !== ( $file = readdir($dir)) ) {
            if (( $file != '.' ) && ( $file != '..' )) {
                if ( is_dir($src . '/' . $file) ) {
                    self::recurse_copy($src . '/' . $file,$dst . '/' . $file);
                }
                else {
                    copy($src . '/' . $file,$dst . '/' . $file);
                }
            }
        }
        closedir($dir);
    }

    static function published($galIds,$publish){
        $db = JFactory::getDbo();
        if(count($galIds)){
            foreach ($galIds as $galId) {
                $query = "UPDATE #__os_gallery SET published=$publish WHERE id=$galId";
                $db->setQuery($query);
                $db->execute();
            }
        }
        JFactory::getApplication()->redirect('index.php?option=com_osgallery');
    }

    static function deleteGallery($delGalIds){
        $db = JFactory::getDbo();
        if(count($delGalIds)){
            foreach ($delGalIds as $galId) {
                //delete folder with gallery
                $imageFolderPath = JPATH_SITE . '/images/com_osgallery/gal-'.$galId;
                self::rrmdir($imageFolderPath);

                //delete img from db
                $query = "DELETE gim FROM #__os_gallery_img as gim ".
                            "\n LEFT JOIN #__os_gallery_connect as gc ON gc.fk_gal_img_id=gim.id".
                            "\n LEFT JOIN #__os_gallery_categories as cat ON cat.id=gc.fk_cat_id".
                            "\n WHERE cat.fk_gal_id=$galId";
                $db->setQuery($query);
                $db->execute();

                //delete img from connect table
                $query = "DELETE gc FROM #__os_gallery_connect as gc ".
                        "\n LEFT JOIN #__os_gallery_categories as cat ON cat.id=gc.fk_cat_id".
                        "\n WHERE cat.fk_gal_id=$galId";
                $db->setQuery($query);
                $db->execute();

                //delete cat
                $query = "DELETE cat FROM #__os_gallery_categories as cat ".
                            "\n WHERE cat.fk_gal_id=$galId";
                $db->setQuery($query);
                $db->execute();

                //delete gal from db
                $query = "DELETE FROM #__os_gallery WHERE id=$galId";
                $db->setQuery($query);
                $db->execute();
            }
        }
        JFactory::getApplication()->redirect('index.php?option=com_osgallery');
    }

    static function rrmdir($dir) {
        if (is_dir($dir)) {
            $objects = scandir($dir);
            foreach ($objects as $object) {
                if ($object != "." && $object != "..") {
                    if (is_dir($dir."/".$object))
                        self::rrmdir($dir."/".$object);
                    else
                        unlink($dir."/".$object);
                }
            }
        rmdir($dir);
       }
    }


    static function getImageFromFolder($dir = false){
        global $gl_state;

        if(!isset($gl_state->data) ){
            echo '<script>alert("'.JText::_('COM_OSGALLERY_YOU_NEED_ACTIVATE_LICENSE').'"); history.back(); </script>';
            return ;
        }


        $input  = JFactory::getApplication()->input;

        //if $dir not passed ,get dir from Request
        $dir = ($dir && !empty($dir)) ? $dir : $input->getString('path');
        
        //checks directory and returns images array or error
        $images = self::checkDir($dir);


        foreach ($images as $image) {
            self::uploadImages($image);
        }
          
        return true;
    }

    static function gal_readdir($dir){
        $images = [];
        if ($handle = opendir($dir)) {
            while (false !== ($entry = readdir($handle))) {
                if ($entry != "." && $entry != "..") {
                    $images[] = $dir.'/'.$entry;
                }
            }
            closedir($handle);
        }
        if(count($images) == 0) return false;
        return $images;    
    }

    static function checkDir($dir){

        $dir = JPath::clean($dir);

        if(!file_exists($dir) || !is_dir($dir)  || !self::gal_readdir($dir)){
            $response['success'] = false;
            $response['message'] = "Folder is empty or not exists, please select the folder containing the images";
            echo json_encode($response);
            exit;
        }

        $images = [];
        $items = self::gal_readdir($dir);

        if(count($items)){
            foreach ($items as $item) {
                if(is_dir($item)) continue;
                $images[] = $item;
            }
        }else{
            $response['success'] = false;
            $response['message'] = "Folder not contents images";
            echo json_encode($response);
            exit;
        }

        if(count($images)){
            return $images;        
        }else{
            $response['success'] = false;
            $response['message'] = "Folder is empty";
            echo json_encode($response);
            exit;
        }

    }

    static function getImageFromZip(){
        global $gl_state;

        if(!isset($gl_state->data) ){
            echo '<script>alert("'.JText::_('COM_OSGALLERY_YOU_NEED_ACTIVATE_LICENSE').'"); history.back(); </script>';
            return ;
        }


        $input = JFactory::getApplication()->input;
        $dir = $_FILES['uploadZip']['tmp_name'];
        $temp = JPATH_ROOT . "/tmp/tempZip_".uniqid();

        if(!is_dir($temp)) mkdir($temp, 0755);

        $zip = new ZipArchive;

        if ($zip->open($dir) === TRUE) {
            $zip->extractTo($temp);
            $zip->close();
            static::getImageFromFolder($temp);
            self::rmRec($temp);
        } else {
            $response['success'] = false;
            $response['message'] = "Zip unpack error";
            self::rmRec($temp);
            echo json_encode($response);
            exit;
        }


    }


    static function uploadImages($image = false){

        global $gl_state;

        if(!isset($gl_state->data) ){
            echo '<script>alert("'.JText::_('COM_OSGALLERY_YOU_NEED_ACTIVATE_LICENSE').'"); history.back(); </script>';
            return ;
        }
        
        // saving images
        jimport('joomla.application.module.helper');
        jimport('joomla.filesystem.folder');
        jimport('joomla.filesystem.file');
        
        $db = JFactory::getDbo();
        $input  = JFactory::getApplication()->input;
        $galId = $input->get("galId",0,"INT");
        $response = array('success' => false, 'message' => '');

        
        
        if (isset($_GET['qqfile'])) {
            $post_form = false;
            $pathinfo = pathinfo(strtolower($_GET['qqfile']));
        } elseif (isset($_FILES['qqfile'])) {
            $post_form = true;
            $pathinfo = pathinfo(strtolower($_FILES['qqfile']['name']));
        } elseif(($input->getString('task', false) == 'upload_folder' 
                  || $input->getString('task', false) == 'upload_zip') && strlen($image) > 3){
            $post_form = true;
            $pathinfo = pathinfo($image);
        } else {
            $response['message'] = 'File is empty, check your file and try again!';
            echo json_encode($response);
            return;
        }

        $filename = JApplicationHelper::stringURLSafe($pathinfo['filename']);
        $filename .= self::touchGuid();
        $ext = (isset($pathinfo['extension'])) ? $pathinfo['extension'] : exit;
        
        $max_filesize = self::toBytes(ini_get('upload_max_filesize'));
        $allowedExtensions = array('jpg', 'jpeg', 'png', 'gif', 'webp');
        $allowedExtensionsMime = array('jpg' => 'image/jpeg', 'png' => 'image/png', 'gif' => 'image/gif', 'webp' => 'image/webp');
        $dir = JPATH_SITE . '/images';
        $catId = $input->get("catId",0,"INT");
        
        
        //check maxFileSize
        if (self::getFileSize($post_form, $image) > $max_filesize) {
            $response['message'] = "File is too large";
            echo json_encode($response);
            return;
        }
        if (self::getFileSize($post_form, $image) == 0) {
            $response['message'] = "File is empty, check your file and try again";
            echo json_encode($response);
            return;
        }
        if (!in_array(strtolower($ext), $allowedExtensions)) {
            $response['message'] = "Invalid extension, allowed: ".implode(", ",$allowedExtensions);
            echo json_encode($response);
            return;
        }
//        if(!in_array($mime, $allowedExtensionsMime)){
//            $response['message'] = "Invalid file, allowed: ".implode(", ",$allowedExtensions);
//            echo json_encode($response);
//            return;
//        }

        //check and create folder
        $dir = $dir . '/com_osgallery/gal-'.$galId;
        if (!file_exists($dir) || !is_dir($dir)) mkdir($dir, 0755, true);
        if (!file_exists($dir . '/original') || !is_dir($dir)) mkdir($dir . '/original', 0755, true);
        if (!file_exists($dir . '/original/watermark') || !is_dir($dir)) mkdir($dir . '/original/watermark', 0755, true);
        if (!file_exists($dir . '/thumbnail') || !is_dir($dir)) mkdir($dir . '/thumbnail', 0755, true);
        if (!file_exists($dir . '/thumbnail_165_110') || !is_dir($dir)) mkdir($dir . '/thumbnail_165_110', 0755, true);
        if (!file_exists($dir . '/watermark') || !is_dir($dir)) mkdir($dir . '/watermark', 0755, true);

        //saving file
        if (!self::fileSave("{$dir}/original/{$filename}.{$ext}", $post_form, $image)) {
            $response['message'] = "Can't save file here: {$dir}/original/{$filename}.{$ext}";
        }else{
            //$imagesize = getimagesize("{$dir}/original/{$filename}.{$ext}", $imageinfo);

            $params = new JRegistry;
            $query = "SELECT params FROM #__os_gallery WHERE id=$galId";
            $db->setQuery($query);
            $paramsString = $db->loadResult();
            $params->loadString($paramsString);
            $imgWidth = $params->get('imgWidth', 600);
            $imgHeight = $params->get('imgHeight', 400);

            if($params->get("rotateImage", 0) == 1){
                self::rotateImage($dir . "/original/{$filename}.{$ext}");
            }
            $thmb_name = self::getImageThumbnailName($filename, $imgHeight, $imgWidth);
            self::createImageThumbnail($dir . "/original/{$filename}.{$ext}", $dir .
             "/thumbnail/{$thmb_name}.{$ext}", $imgWidth, $imgHeight, 1);
            self::createImageThumbnail($dir . "/original/{$filename}.{$ext}", $dir .
             "/thumbnail_165_110/{$filename}.{$ext}", 165, 110, 1);
             
             $dir = JPATH_SITE . '/images/com_osgallery/gal-'.$galId;

            if($params->get("galleryLayout") == "masonry" || ($params->get("galleryLayout") == "albumMode" && $params->get("albumSublayout") == 'masonry')) {
                if (!file_exists($dir . '/thumbnail_masonry') || !is_dir($dir)) mkdir($dir . '/thumbnail_masonry', 0755, true);
                if (!file_exists($dir . '/thumbnail_masonry/default') || !is_dir($dir)) mkdir($dir . '/thumbnail_masonry/default', 0755, true);
                if (!file_exists($dir . '/thumbnail_masonry/horizontal') || !is_dir($dir)) mkdir($dir . '/thumbnail_masonry/horizontal', 0755, true);
                if (!file_exists($dir . '/thumbnail_masonry/vertical') || !is_dir($dir)) mkdir($dir . '/thumbnail_masonry/vertical', 0755, true);  
                $old_Params = new JRegistry;
                $query = "SELECT params FROM #__os_gallery WHERE id=$galId";
                $db->setQuery($query);
                $old_ParamsString = $db->loadResult();
                $old_Params->loadString($old_ParamsString);

                self::createImageThumbnailForMasonry($params->get("masonryLayout"), $old_Params);
            }
            if($params->get("galleryLayout") == "fit_rows" || ($params->get("galleryLayout") == "albumMode" && $params->get("albumSublayout") == 'fit_rows')) {
                if (!file_exists($dir . '/thumbnail_fitrows') || !is_dir($dir)) mkdir($dir . '/thumbnail_fitrows', 0755, true);
                $old_Params = new JRegistry;
                $query = "SELECT params FROM #__os_gallery WHERE id=$galId";
                $db->setQuery($query);
                $old_ParamsString = $db->loadResult();
                $old_Params->loadString($old_ParamsString);
                self::createImageThumbnailForMasonry("fit_rows", $old_Params);
            }


            //save image to database
            $response['id'] = self::dbSaveImages($filename.'.'.$ext, $catId, $galId);
            $response['galId'] = $galId;
            //end
            $response['success'] = true;
            $response['file'] = $filename;
            $response['ext']= '.'.$ext;
        }
        echo json_encode($response);
        return;
        // exit;
    }

    protected static function rotateImage($imagePath){

        $pathinfo = pathinfo($imagePath);
        if(!file_exists($imagePath)) return;

        if(strtolower($pathinfo['extension']) == 'jpeg' 
           || strtolower($pathinfo['extension']) == 'jpg'){
            $exif = @exif_read_data($imagePath);

            if (!empty($exif['Orientation'])) {
                $imageResource = imagecreatefromjpeg($imagePath); // provided that the image is jpeg. Use relevant function otherwise
                switch ($exif['Orientation']) {
                    case 3:
                    $image = imagerotate($imageResource, 180, 0);
                    break;
                    case 6:
                    $image = imagerotate($imageResource, -90, 0);
                    break;
                    case 8:
                    $image = imagerotate($imageResource, 90, 0);
                    break;
                    default:
                    $image = $imageResource;
                } 

                imagejpeg($image, $imagePath);
                imagedestroy($image);
            }

            return;
        }

    }

    protected static function findView($view){
        $Path = JPATH_COMPONENT . '/views/'.$view.'/default.php';

        if (file_exists($Path)){
          return $Path;
        } else {
          echo "Bad layout path to view->".$view.", please write to admin";
          exit;
        }
    }

    protected static function touchGuid(){
        if (function_exists('com_create_guid')){
            return trim(com_create_guid(), '{}');
        }else{
//            mt_srand((double) microtime() * 10000); //optional for php 4.2.0 and up.
            $charid = strtoupper(md5(uniqid(rand(), true)));
            $hyphen = chr(45);
            $uuid = substr($charid, 0, 8) . $hyphen
                    . substr($charid, 8, 4) . $hyphen
                    . substr($charid, 12, 4) . $hyphen
                    . substr($charid, 16, 4) . $hyphen
                    . substr($charid, 20, 12);
            return $uuid;
        }
    }

    protected static function toBytes($val) {
        if (empty($val)){
            return 0;
        }

        $val = trim($val);
        preg_match('#([0-9]+)[\s]*([a-z]+)#i', $val, $matches);
        $last = '';

        if (isset($matches[2])){
            $last = $matches[2];
        }

        if (isset($matches[1])){
            $val = (int) $matches[1];
        }

        switch (strtolower($last)){
            case 'g':
            case 'gb':
                $val *= 1024;
            case 'm':
            case 'mb':
                $val *= 1024;
            case 'k':
            case 'kb':
                $val *= 1024;
        }

        return (int)$val;
    }

    protected static function getFileSize($post_form, $image = false){
        if($post_form){
            if(strlen($image) > 3) return filesize($image);
            return $_FILES['qqfile']['size'];
        }else{
            if (isset($_SERVER["CONTENT_LENGTH"])) {
                return (int) $_SERVER["CONTENT_LENGTH"];
            } else {
                throw new Exception('Getting content length is not supported.');
            }
        }
    }

    static function fileSave($dest, $post_form, $image = false){
        if($post_form){

            if(strlen($image) > 3){
                if(!copy($image, $dest)){
                    return false;
                }
                return true;
            }

            if (!move_uploaded_file($_FILES['qqfile']['tmp_name'], $dest)) {
              return false;
            }
            return true;

        }else{
            $input = fopen("php://input", "r");
            $temp = tmpfile();
            if(!$temp){
                $temp = fopen("ImageTempFile.txt","w+");
            }
            $realSize = stream_copy_to_stream($input, $temp);
            fclose($input);
            if ($realSize != self::getFileSize($post_form)) {
                return false;
            }
            $target = fopen($dest, "w");
            fseek($temp, 0, SEEK_SET);
            stream_copy_to_stream($temp, $target);
            fclose($target);
            return true;
        }
    }

    static function createWaterMark($file_name, $galId, $params, $quality = 80){
        
        //get imfo about original image
        set_time_limit(60);
        $original_src = JPATH_SITE . '/images/com_osgallery/gal-'.$galId.'/original/'.$file_name;
        $original_info = getimagesize($original_src, $original_info);
        if($original_info === FALSE){
          $img = ImageCreateFromJpeg($original_src);
          $original_width = ImageSX($img);
          $original_height = ImageSY($img);
          $original_ext = 'jpg';          
        } else {
          $original_width = $original_info[0];
          $original_height = $original_info[1];
          $original_ext = str_replace('image/', '', $original_info['mime']);          
        }



        //get create and save function
        $imageCreateFunc = self::getImageCreateFunction($original_ext);
        $imageSaveFunc = self::getImageSaveFunction($original_ext);
        $sImage = $imageCreateFunc($original_src);
        $dImage = imagecreatetruecolor($original_width, $original_height);

        // Make transparent
        if ($original_ext == 'png') {
          imagealphablending($dImage, false);
          imagesavealpha($dImage,true);
          $transparent = imagecolorallocatealpha($dImage, 255, 255, 255, 127);
          imagefilledrectangle($dImage, 0, 0, $original_width, $original_height, $transparent);
        }
  
        //get watermark
        if($params->get("watermark_type")== 1){
            $mark = JPATH_SITE . '/images/com_osgallery/gal-'.$galId.'/watermark/'.$params->get("watermark_file");
        }else{
            //create text watermark
            //get size of text
            $text = $params->get("watermark_text");
            $font = JPATH_COMPONENT_ADMINISTRATOR.'/assets/fonts/font.ttf';

            if($params->get("watermark_font",'default') == 'default'){
                $font = JPATH_COMPONENT_ADMINISTRATOR.'/assets/fonts/default.ttf';
            }elseif($params->get("watermark_font",'default') == 'lobster'){
                $font = JPATH_COMPONENT_ADMINISTRATOR.'/assets/fonts/lobster.ttf';
            }else{
                $font = JPATH_COMPONENT_ADMINISTRATOR.'/assets/fonts/default.ttf';
            }
            

            $textSizes = 200;
            $textAngle = $params->get("watermark_text_angle");
            //size,angle
            $box = imagettfbbox($textSizes, $textAngle, $font, $text);

            $min_x = min( array($box[0], $box[2], $box[4], $box[6]) ); 
            $max_x = max( array($box[0], $box[2], $box[4], $box[6]) ); 
            $min_y = min( array($box[1], $box[3], $box[5], $box[7]) ); 
            $max_y = max( array($box[1], $box[3], $box[5], $box[7]) ); 
            $width  = ( $max_x - $min_x );
            $height = ( $max_y - $min_y ); 

            if($textAngle==45){
              $width = $width*1.1 ;
              $height = $height*1.1 ;
            } else if($textAngle==0 ) {
              $width = $width*1.1 ;
              $height = $height*1.3 ;
            } else if($textAngle== 90 ) {
              $width = $width*1.3 ;
              $height = $height*1.1 ;
            }  
              

            $mark = imagecreatetruecolor($width, $height);
            imagealphablending($mark, false);
            imagesavealpha($mark,true);
            $white = imagecolorallocatealpha($mark, 255, 255, 255, 127);
            $grey = imagecolorallocate($mark, 128, 128, 128);

            if( strpos($params->get("watermark_text_color"), "rgba(") !== FALSE ) {
                $fontColor = str_replace("rgba(", '', $params->get("watermark_text_color"));
                $fontColor = str_replace(")", '', $fontColor);
                $fontColor = explode(',', $fontColor);
            } else if ( strpos($params->get("watermark_text_color"), "rgb(") !== FALSE ) {
                $fontColor = str_replace("rgb(", '', $params->get("watermark_text_color"));
                $fontColor = str_replace(")", '', $fontColor);
                $fontColor = explode(',', $fontColor);
            } else $fontColor = array(0,0,0);
            $r = isset($fontColor[0])?$fontColor[0]:0;
            $g = isset($fontColor[1])?$fontColor[1]:0;
            $b = isset($fontColor[2])?$fontColor[2]:0;
            $fontColor = imagecolorallocate($mark, $r, $g, $b);
            imagefilledrectangle($mark, 0, 0, $width, $height, $white);

            // Тень
            //size,angle
            if($textAngle ==45){
                $margin = $textSizes/2;
                $offset = $height;
            }else if($textAngle == 90){
                $margin = $textSizes;
                $offset = $height;
            }else{
                $margin = 0;
                $offset = $textSizes;
            }
            imagettftext($mark, $textSizes, $textAngle, $margin+1, $offset+1, $grey, $font, $text);
            // Текст
            //size,angle
            if($textAngle ==45){
                $margin = $textSizes/2;
                $offset = $height;
            }else if($textAngle == 90){
                $margin = $textSizes;
                $offset = $height;
            }else{
                $margin = 0;
                $offset = $textSizes;
            }
            imagettftext($mark, $textSizes, $textAngle, $margin, $offset, $fontColor, $font, $text);

            $dest = JPATH_SITE . '/images/com_osgallery/gal-'.$galId.'/watermark/text_watermark.png';
            imagepng($mark, $dest);
            imagedestroy($mark);
            //end
            

            $mark = $dest;
        }

        $watermark_info = getimagesize($mark, $watermark_info);
        
        if($watermark_info === FALSE){
          $watermark_ext = 'jpg';          
        } else {
          $watermark_ext = str_replace('image/', '', $watermark_info['mime']);
        }

        $watermarkCreateFunc = self::getImageCreateFunction($watermark_ext);
        
        $watermark = $watermarkCreateFunc($mark);
        $watermark_width = imagesx($watermark);
        $watermark_height = imagesy($watermark);

        $margin = 10;


        
        if($params->get("watermark_type") == 1){
            $sx = $original_width*$params->get("watermark_size")/100;
            $sy = $watermark_height*($sx/$watermark_width);
        }else{
            // $sx = ($watermark_width < $original_width)?$watermark_width : $original_width-$original_width*0.5;
            // $sy = ($watermark_height < $original_height)?$watermark_height : $original_height-$original_height*0.5;

            $sx = $original_width*$params->get("watermark_text_size")/100;
            $sy = $original_height*$params->get("watermark_text_size")/100;
            //$sy = $watermark_height*($sx/$watermark_width);
        }
        $xx = $original_width;
        $yy = $original_height;
        $position = $params->get("watermark_position");

        switch ($position) {
            case 'top_left':
                $x = $margin;
                $y = $margin;
                break;
            case 'top_right':
                $x = $xx - $sx - $margin;
                $y = $margin;
                break;
            case 'bottom_left':
                $x = $margin;
                $y = $yy - $sy - $margin;
                break;
            case 'bottom_right':
                $x = $xx - $sx - $margin;
                $y = $yy - $sy - $margin;
                break;
            case 'center':
                $x = $xx/2-$sx/2;
                $y = $yy/2-$sy/2;
                break;
        }

        //RESIZE watermark save transparrent
        
        if($sx > 1 && $sy > 1){
            $resize_mark = imagecreatetruecolor($sx, $sy);
            imagealphablending($resize_mark, false);
            imagesavealpha($resize_mark,true);
            $transparent = imagecolorallocatealpha($resize_mark, 255, 255, 255, 127);
            imagecopyresampled($resize_mark, $watermark, 0, 0, 0, 0, $sx, $sy, $watermark_width, $watermark_height);

            //save transparent in main image
            
            if ($original_ext == 'gif' && self::is_ani($original_src)) {

                $save_src = JPATH_SITE . '/images/com_osgallery/gal-'.$galId.'/original/watermark/'.$file_name;
                $gfe = new GifFrameExtractor\GifFrameExtractor();
                $frames = $gfe->extract($original_src);

                $retouchedFrames = array();
                foreach ($frames as $frame) {
                    // Initialization of the frame as a layer
                    $frameLayer = PHPImageWorkshop\ImageWorkshop::initFromResourceVar($frame['image']);
                    $retouchedFrames[] = self::imagecopymerge_alpha($frameLayer->getImage(), $resize_mark, $x, $y, 0, 0, $sx, $sy,$params->get("watermark_opacity"));
                }
                $gc = new GifCreator\GifCreator();
                $gc->create($retouchedFrames, $gfe->getFrameDurations(), 0);
                file_put_contents($save_src, $gc->getGif());

            }else{
                $sImage = self::imagecopymerge_alpha($sImage, $resize_mark, $x, $y, 0, 0, $sx, $sy,$params->get("watermark_opacity"));
            

                $save_src = JPATH_SITE . '/images/com_osgallery/gal-'.$galId.'/original/watermark/'.$file_name;
                if ($original_ext == 'png') {
                  $imageSaveFunc($sImage, $save_src, 9);
                }
                else if ($original_ext == 'gif') {
                  $imageSaveFunc($sImage, $save_src, $quality);
                }
                else {
                  $imageSaveFunc($sImage, $save_src, $quality);
                }
            }
        }
    }

    static function imagecopymerge_alpha($dst_im, $src_im, $dst_x, $dst_y, $src_x, $src_y, $src_w, $src_h, $pct){
        // creating a cut resource
        $cut = imagecreatetruecolor($src_w, $src_h);

        // copying relevant section from background to the cut resource
        imagecopy($cut, $dst_im, 0, 0, $dst_x, $dst_y, $src_w, $src_h);

        // copying relevant section from watermark to the cut resource
        imagecopy($cut, $src_im, 0, 0, $src_x, $src_y, $src_w, $src_h);

        imagealphablending($dst_im, false);
        imagesavealpha($dst_im,true);
        // insert cut resource to destination image
        imagecopymerge($dst_im, $cut, $dst_x, $dst_y, 0, 0, $src_w, $src_h, $pct);
        return $dst_im;
    }

    static function cropImages( $galId, $layout, $destWidht, $destHeight, $oldParams ) {

        $db = JFactory::getDbo();
        $imageFolderPath = JPATH_SITE . '/images/com_osgallery/gal-'.$galId;

        $query = "SELECT gim.id, gim.file_name, cat.id as catId  FROM #__os_gallery_img as gim ".
                "\n LEFT JOIN #__os_gallery_connect as gc ON gim.id=gc.fk_gal_img_id".
                "\n LEFT JOIN #__os_gallery_categories as cat ON cat.id=gc.fk_cat_id ".
                "\n WHERE cat.fk_gal_id=$galId".
                "\n ORDER BY cat.ordering ASC";
        $db->setQuery($query);
        $images =$db->loadObjectList();

        foreach ($images as $value) {
            $img_arr = explode('.', $value->file_name);
            $img_ext = $img_arr[count($img_arr) -1];
            unset($img_arr[count($img_arr) -1]);
            $img_name = implode('.', $img_arr);
            $oldImgWidth = $oldParams->get("imgWidth",600,"INT");
            $oldImgHeight = $oldParams->get("imgHeight",400,"INT");
            $old_img_name = self::getImageThumbnailName($img_name, $oldImgHeight, $oldImgWidth);
            $img_name = self::getImageThumbnailName($img_name, $destHeight, $destWidht);
            
            if(file_exists($imageFolderPath.'/thumbnail/'.$old_img_name.'.'.$img_ext)){
                $info = getimagesize($imageFolderPath.'/thumbnail/'.$old_img_name.'.'.$img_ext, $imageinfo);
            }else{
                $info = FALSE;
            }
            if($info === FALSE){
              $imageCreateFunc = self::getImageCreateFunction($img_ext);
              $imageSaveFunc = self::getImageSaveFunction($ext);

              $img = $imageCreateFunc($imageFolderPath.'/thumbnail/'.$value->file_name);
              if(is_object($img)){
                  $original_width = ImageSX($img);
                  $original_height = ImageSY($img);
                  if (($original_width == $destWidht) && ($original_height == $destHeight) ) {
                      continue; 
                  } 
              }
            } else {
              if (($info[0] == $destWidht) && ($info[1] == $destHeight) ) {
                  continue; 
              } 
            }

            
            
            
            if(file_exists($imageFolderPath.'/thumbnail/'.$value->file_name)){
                unlink($imageFolderPath.'/thumbnail/'.$value->file_name);
            }
            if(file_exists($imageFolderPath.'/thumbnail/'.$old_img_name.'.'.$img_ext)){
                unlink($imageFolderPath.'/thumbnail/'.$old_img_name.'.'.$img_ext);
            }

            //VlaDOS
            //Pointless work with the database. 23.09.2020
            
//            $query = "DELETE FROM #__os_gallery_connect".
//                    "\n WHERE fk_gal_img_id=$value->id";
//            $db->setQuery($query);
//            $db->execute();
//
//            $query = "SELECT params FROM #__os_gallery_img".
//                    "\n WHERE id=$value->id";
//            $db->setQuery($query);
//            $params = $db->loadResult();
//
//            $query = "DELETE FROM #__os_gallery_img".
//                    "\n WHERE id=$value->id";
//            $db->setQuery($query);
//            $db->execute();

            self::createImageThumbnail($imageFolderPath . "/original/{$value->file_name}", $imageFolderPath .
             "/thumbnail/$img_name.$img_ext", $destWidht, $destHeight, 1);
            
//            self::dbSaveImages($value->file_name, $value->catId, $galId, $params);            

        }
    }

    static function createImageThumbnailForMasonry($layoutMasonry, $old_Params)
    {
        jimport('joomla.application.module.helper');
        jimport('joomla.filesystem.folder');
        jimport('joomla.filesystem.file');
        $db = JFactory::getDbo();
        $input  = JFactory::getApplication()->input;
        $catId = $input->get("catId",0);
        $galId = $input->get("galId",0);
        $spaceBetween = $input->get("image_margin",0);
        $numColumns = $input->get("num_column", 3);
        $old_spaceBetween = $old_Params->get("image_margin",0);
        $old_numColumns = $old_Params->get("num_column", 3);
        
        $dir = JPATH_SITE . '/images/com_osgallery/gal-'.$galId ;
        $images = scandir("{$dir}/original");
        foreach ($images as $image) {
            if (!self::checkImgExtension($image)) continue;
            $pathinfo = pathinfo($image);
            $filename = $pathinfo['filename'];
            $ext = $pathinfo['extension'];
            $max_filesize = self::toBytes(ini_get('upload_max_filesize'));
            
            $destWidht = 600; 
            $destHeight = 400;

            $info = getimagesize("{$dir}/original/{$filename}.{$ext}", $imageinfo);
            if($info === FALSE){
              $img = ImageCreateFromJpeg("{$dir}/original/{$filename}.{$ext}");
              $width = ImageSX($img);
              $height = ImageSY($img);
            } else {
              $width = $info[0];
              $height = $info[1];
            }

            
            if ($layoutMasonry == "default") {
                $destHeight = round(($height * $destWidht) / $width, 0, PHP_ROUND_HALF_UP);
                $thumbnail = "thumbnail_masonry/{$layoutMasonry}";
            }

            if ($layoutMasonry == "horizontal") {
                if ($height >= $width) {
                    $destHeight = $destWidht + ($spaceBetween * 2)*$numColumns ;
                }
                else {
                    $destWidht = $destHeight * 2 - $spaceBetween *($numColumns-1) ;
                }
                $thumbnail = "thumbnail_masonry/{$layoutMasonry}";         
            }

            if ($layoutMasonry == "vertical") {
                if ($height <= $width) $destHeight = $destWidht  ;
                else {
                    $destHeight = $destWidht * 2 - $spaceBetween;
                    $destWidht -= ($spaceBetween * 2);
                }
                $thumbnail = "thumbnail_masonry/{$layoutMasonry}";
            }

            if ($layoutMasonry == "fit_rows") {
                $destWidht = 1; 
                $destHeight = 400;
                if ($height <= $width) $destWidht = $destHeight* 2;
                else $destWidht = $destHeight ;
                $thumbnail = "thumbnail_fitrows";
            } 
            
            if($numColumns != $old_numColumns || $spaceBetween != $old_spaceBetween || !file_exists($dir .
                 "/{$thumbnail}/{$filename}.{$ext}")){

                self::createImageThumbnail($dir . "/original/{$filename}.{$ext}", $dir .
                     "/{$thumbnail}/{$filename}.{$ext}", $destWidht, $destHeight, 1, 80);
            }                
        }
    }

    static function checkImgExtension($image) {
            $allowedExtensions = array('jpg', 'jpeg', 'png', 'gif', 'webp');
            foreach ($allowedExtensions as $ext) {
                if (stripos($image, $ext)) return true;
            }
            return false;
    } 

    static function createImageThumbnail($src, $dest, $destWidht, $destHeight ,$crop = true, $quality = 80){
        // Setting the resize parameters
        $info = getimagesize($src, $imageinfo);
        
        if($info === FALSE){
          $img = ImageCreateFromJpeg($src);
          $width = ImageSX($img);
          $height = ImageSY($img);
          $file_type = '.jpg';
        } else {
          $width = $info[0];
          $height = $info[1];
          $file_type = '.'.str_replace('image/', '', $info['mime']);
        }
        
        if (file_exists($dest)) {
            return;
        } else {
            
            if ($width < $height) {
                if ($height > $destHeight) {
                    $k = $height / $destHeight;
                } else if ($width > $destWidht) {
                    $k = $width / $destWidht;
                }
                else
                    $k = 1;
            } else {
                if ($width > $destWidht) {
                    $k = $width / $destWidht;
                } else if ($height > $destHeight) {
                    $k = $height / $destHeight;
                }
                else
                    $k = 1;
            }
            $w_ = $width / $k;
            $h_ = $height / $k;
        } 

        if($crop == 1){
            $CreateNewImage = self::createImage($src, $dest, $destWidht, $destHeight ,$crop, $quality);
            return;
        }
        // Creating the Canvas
        $tn = imagecreatetruecolor($w_, $h_);
            switch (strtolower($file_type)) {
            case '.png':
                $source = imagecreatefrompng($src);
                $file = imagecopyresampled($tn, $source, 0, 0, 0, 0, $w_, $h_, $width, $height);
                imagepng($tn, $dest);
                break;
            case '.jpg':
                $source = imagecreatefromjpeg($src);
                $file = imagecopyresampled($tn, $source, 0, 0, 0, 0, $w_, $h_, $width, $height);
                imagejpeg($tn, $dest);
                break;
            case '.jpeg':
                $source = imagecreatefromjpeg($src);
                $file = imagecopyresampled($tn, $source, 0, 0, 0, 0, $w_, $h_, $width, $height);
                imagejpeg($tn, $dest);

                break;
            case '.gif':
                $source = imagecreatefromgif($src);
                $file = imagecopyresampled($tn, $source, 0, 0, 0, 0, $w_, $h_, $width, $height);
                imagegif($tn, $dest);

                break;
            case '.webp':
                $source = imagecreatefromwebp($src);
                $file = imagecopyresampled($tn, $source, 0, 0, 0, 0, $w_, $h_, $width, $height);
                imagewebp($tn, $dest);
                break;
            default:
                echo 'not support';
                return;
        }
    }


    static function createImage($src, $dest, $destWidht, $destHeight ,$crop = true, $quality = 80){
        $info = getimagesize($src, $imageinfo);
        if($info === FALSE){
          $img = ImageCreateFromJpeg($src);
          $sWidth = ImageSX($img);
          $sHeight = ImageSY($img);
        } else {
          $sWidth = $info[0];
          $sHeight = $info[1];
        }
        if ($sHeight / $sWidth > $destHeight / $destWidht) {
            $width = $sWidth;
            $height = round(($destHeight * $sWidth) / $destWidht);
            $sx = 0;
            $sy = round(($sHeight - $height) / 3);
        }
        else {
            $height = $sHeight;
            $width = round(($sHeight * $destWidht) / $destHeight);
            $sx = round(($sWidth - $width) / 2);
            $sy = 0;
        }

        if (!$crop) {
            $sx = 0;
            $sy = 0;
            $width = $sWidth;
            $height = $sHeight;
        }

        $ext = str_replace('image/', '', $info['mime']);
        $imageCreateFunc = self::getImageCreateFunction($ext);
        $imageSaveFunc = self::getImageSaveFunction($ext);

        $sImage = $imageCreateFunc($src);
        $dImage = imagecreatetruecolor($destWidht, $destHeight);

        // Make transparent
        if ($ext == 'png') {
            imagealphablending($dImage, false);
            imagesavealpha($dImage,true);
            $transparent = imagecolorallocatealpha($dImage, 255, 255, 255, 127);
            imagefilledrectangle($dImage, 0, 0, $destWidht, $destHeight, $transparent);
        }
        imagecopyresampled($dImage, $sImage, 0, 0, $sx, $sy, $destWidht, $destHeight, $width, $height);

        if ($ext == 'png') {
            $imageSaveFunc($dImage, $dest, 9);
        }
        else if ($ext == 'gif') {

            if (self::is_ani($src)) {
                $gfe = new GifFrameExtractor\GifFrameExtractor();
                $frames = $gfe->extract($src);
                $retouchedFrames = array();
                foreach ($frames as $frame) {
                    
                    // Initialization of the frame as a layer
                    $frameLayer = PHPImageWorkshop\ImageWorkshop::initFromResourceVar($frame['image']);
                    $layer_width = $frameLayer->getWidth();
                    $layer_height = $frameLayer->getHeight();

                    $width_ratio = $destWidht / $layer_width;
                    $height_ratio = $destHeight / $layer_height;

                    if($layer_width < $layer_height){
                        if($width_ratio < $height_ratio){
                            $frameLayer->resizeByLargestSideInPixel($destHeight, true);
                        }else{
                            $frameLayer->resizeByNarrowSideInPixel($destWidht, true);
                        }
                    }else{
                        if($width_ratio < $height_ratio){
                            $frameLayer->resizeByNarrowSideInPixel($destHeight, true);
                        }else{

                            $frameLayer->resizeByLargestSideInPixel($destWidht, true);

                        }
                    }
                    $frameLayer->cropToAspectRatioInPixel($destWidht, $destHeight, $sx, $sy); // Crop
                    
                    
                    $retouchedFrames[] = $frameLayer->getResult();
                }
                $gc = new GifCreator\GifCreator();
                $gc->create($retouchedFrames, $gfe->getFrameDurations(), 0);
                file_put_contents($dest, $gc->getGif());

            }else{
                $imageSaveFunc($dImage, $dest);
            }
//            self::gifResize($src,$dest,"50") ;            
        }
        else {
            $imageSaveFunc($dImage, $dest, $quality);
        }
    }

    static function getImageCreateFunction($type){
        switch ($type) {
            case 'jpeg':
            case 'jpg':
                $imageCreateFunc = 'imagecreatefromjpeg';
                break;

            case 'png':
                $imageCreateFunc = 'imagecreatefrompng';
                break;

            case 'bmp':
                $imageCreateFunc = 'imagecreatefrombmp';
                break;

            case 'gif':
                $imageCreateFunc = 'imagecreatefromgif';
                break;

            case 'vnd.wap.wbmp':
                $imageCreateFunc = 'imagecreatefromwbmp';
                break;

            case 'xbm':
                $imageCreateFunc = 'imagecreatefromxbm';
                break;
            
            case 'webp':
                $imageCreateFunc = 'imagecreatefromwebp';
                break;

            default:
                $imageCreateFunc = 'imagecreatefromjpeg';
                break;
        }
        return $imageCreateFunc;
    }

    static function getImageSaveFunction($type) {
        switch ($type) {
            case 'jpeg':
                $imageSaveFunc = 'imagejpeg';
                break;

            case 'png':
                $imageSaveFunc = 'imagepng';
                break;

            case 'bmp':
                $imageSaveFunc = 'imagebmp';
                break;

            case 'gif':
                $imageSaveFunc = 'imagegif';
                break;

            case 'vnd.wap.wbmp':
                $imageSaveFunc = 'imagewbmp';
                break;

            case 'xbm':
                $imageSaveFunc = 'imagexbm';
                break;
            
            case 'webp':
                $imageSaveFunc = 'imagewebp';
                break;

            default:
                $imageSaveFunc = 'imagejpeg';
                break;
        }
        return $imageSaveFunc;
    }

    static function dbSaveImages($filename, $catId, $galId, $params = ''){
        $db = JFactory::getDbo();

        $query = "INSERT IGNORE INTO #__os_gallery_categories(id,fk_gal_id) ".
            "\n VALUES (".$catId.",".$galId.")";
        $db->setQuery($query);
        $db->execute();

        $query = "INSERT INTO #__os_gallery_img(file_name,params, ordering) ".
                "\n VALUES (".$db->Quote($filename).",".$db->Quote($params).", '0')";
        $db->setQuery($query);
        $db->execute();

        $insertId = $db->insertid();

        $query = "INSERT INTO #__os_gallery_connect(fk_cat_id, fk_gal_img_id) ".
                "\n VALUES (".$catId.",".$insertId.")";
        $db->setQuery($query);
        $db->execute();

        return $insertId;
    }

    static function checkEnableUpdate()
    {
        $db = JFactory::getDbo();
        
        $query = $db->getQuery(true);
        
        $query
            ->select($db->quoteName(array('enabled')))
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('name') . ' LIKE \'plg_quickicon_joomlaupdate\'');

        $db->setQuery($query);
        $test = $db->loadResult();
        return $test;
    } 
    
    static function rmRec($path) {
      if (is_file($path)) return unlink($path);
      if (is_dir($path)) {
        foreach(scandir($path) as $p) if (($p!='.') && ($p!='..'))
          self::rmRec($path.DIRECTORY_SEPARATOR.$p);
        return rmdir($path); 
        }
      return false;
      }
      
    static function getWatermarkRedraw($params, $input){
        $watermarkRedraw = false;
        if($params->get("watermark_opacity",30) != $input->get("watermark_opacity",30,"INT")
            || $params->get("watermark_size",20) != $input->get("watermark_size",20,"INT")
            || $params->get("watermark_position","center") != $input->get("watermark_position",'center',"STRING")
            ||$params->get("watermark_position","center") != $input->get("watermark_position_selected",'center',"STRING")
            ||$params->get("watermark_font","default") != $input->get("watermark_font_selected",'default',"STRING")
            || $params->get("watermark_type",1) != $input->get("watermark_type",1,"INT")){
            $watermarkRedraw = true;
        }
        
        return $watermarkRedraw;
    }
    
    static function getWatermarkRedrawText($params, $input){

        $watermarkRedrawText = false;
        if($params->get("watermark_text_color",'rgb(0, 0, 0)') != $input->get("watermark_text_color",'rgb(0, 0, 0)',"STRING")
            || $params->get("watermark_text_size",17) != $input->get("watermark_text_size",17,"INT")
            || $params->get("watermark_font",'default') != $input->get("watermark_font",'default',"STRING")
            || $params->get("watermark_text_angle",0) != $input->get("watermark_text_angle",0,"INT")
            || $params->get("watermark_position","center") != $input->get("watermark_position",'center',"STRING")
            || $params->get("watermark_position","center") != $input->get("watermark_position_selected",'center',"STRING")
            || $params->get("watermark_font","default") != $input->get("watermark_font_selected",'default',"STRING")
            || $params->get("watermark_type",1) != $input->get("watermark_type",1,"INT")){
            $watermarkRedrawText = true;
        }
        return $watermarkRedrawText;
    }
    
    static function parse_str($string) {
	    $parts = explode("&", $string);
	    $result = array();
            $catSettings = array();
            $imgSettings = array();
	    foreach ($parts as $part) {
                if(stripos($part, 'catSettings') !== false){
                    $catSettings_temp = array();
                    parse_str($part, $catSettings_temp);
                    foreach ($catSettings_temp['catSettings'] as $key=>$catSet){
                        $catSettings[$key] = $catSet;
                    }
                    continue;
                    
                }
                
                if(stripos($part, 'imgSettings') !== false){
                    
                    $imgSettings_temp = array();
                    parse_str($part, $imgSettings_temp);
                    
                    foreach ($imgSettings_temp['imgSettings'] as $key=>$imgSet){
                        $imgSettings[$key] = $imgSet;
                    }
                    continue;
                    
                }
                
                
	    	$parsed = array();
	    	parse_str($part, $parsed);
	    	$result = array_merge_recursive($result, $parsed);
	    }
            
            $result['catSettings'] = $catSettings;
            $result['imgSettings'] = $imgSettings;
            
	    return $result;
	}

    static function saveWatermark($galId){
        global $gl_state;

        if(!isset($gl_state->data) ){
            echo '<script>alert("'.JText::_('COM_OSGALLERY_YOU_NEED_ACTIVATE_LICENSE').'"); history.back(); </script>';
            return ;
        }


        $uploaddir = JPATH_SITE . '/images/com_osgallery/gal-'.$galId.'/watermark/';
        
        if (!file_exists($uploaddir) || !is_dir($uploaddir)) mkdir($uploaddir, 0755, true);

        copy($_FILES['watermark_file']['tmp_name'], $uploaddir.$_FILES['watermark_file']['name']);
        
    }
    
    static function getDefaultImageSettings(){
        global $os_gallery_configuration;
        if (version_compare(JVERSION, "3.7.0", "ge")) {
            $install_lang = JLanguageHelper::getKnownLanguages();
        }else{
            $install_lang = JLanguage::getKnownLanguages();
        }
        $imgParams = array();
        if($os_gallery_configuration->get('multilang', '0') == '1'){

            foreach ($install_lang as $tag => $lang){
                $imgParams['imgTitle_'.$tag] = '';
                $imgParams['imgShortDescription_'.$tag] = '';
                $imgParams['imgAlt_'.$tag] = '';
                $imgParams['imgLink_'.$tag] = '';
                $imgParams['imgHtml_'.$tag] = new stdClass();
                $imgParams['imgHtml_'.$tag]->html = '';
                $imgParams['videoLink_'.$tag] = '';
            }
        }else{
            $imgParams['imgTitle'] = '';
            $imgParams['imgShortDescription'] = '';
            $imgParams['imgShortDescription'] = '';
            $imgParams['imgAlt'] = '';
            $imgParams['imgLink'] = '';
            $imgParams['videoLink'] = '';
            $imgParams['imgHtml'] = new stdClass();
            $imgParams['imgHtml']->html = '';
            
            $imgParams =  (object) $imgParams;
            return rawurlencode(json_encode($imgParams));
        }
    }
    
    static function is_ani($filename) {
        if(!($fh = @fopen($filename, 'rb')))
            return false;
        $count = 0;
        //an animated gif contains multiple "frames", with each frame having a
        //header made up of:
        // * a static 4-byte sequence (\x00\x21\xF9\x04)
        // * 4 variable bytes
        // * a static 2-byte sequence (\x00\x2C)

        // We read through the file til we reach the end of the file, or we've found
        // at least 2 frame headers
        while(!feof($fh) && $count < 2) {
            $chunk = fread($fh, 1024 * 100); //read 100kb at a time
            $count += preg_match_all('#\x00\x21\xF9\x04.{4}\x00[\x2C\x21]#s', $chunk, $matches);
        }

        fclose($fh);
        return $count > 1;
    }
    
    static function getImageThumbnailName($name, $height, $width){
        return $name . '_' . $width . '_' . $height;
    }
    
    static function updateImgCategory(){
        $db = JFactory::getDbo();
        $input = JFactory::getApplication()->input;
        
        $addCatId = $input->get('addCatId', 0);
        $removeCatId = $input->get('removeCatId', '');
        $imgId = $input->get('imgId', 0);
        
        if($addCatId > 0 && $imgId > 0){
            $query = "INSERT INTO #__os_gallery_connect(fk_cat_id, fk_gal_img_id) ".
                "\n VALUES (".$addCatId.",".$imgId.")";
            $db->setQuery($query);
            $db->execute();
        }
        
        if($removeCatId > 0 && $imgId > 0){
            $query = "DELETE FROM #__os_gallery_connect".
                     "\n WHERE fk_gal_img_id=$imgId AND fk_cat_id=$removeCatId";
        }
        
        echo json_encode(array('success' => true));
    }
    
    static function return_bytes ($size_str){
        switch (substr ($size_str, -1))
        {
            case 'M': case 'm': return (int)$size_str * 1048576;
            case 'K': case 'k': return (int)$size_str * 1024;
            case 'G': case 'g': return (int)$size_str * 1073741824;
            default: return $size_str;
        }
    }
}
