<?php

defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

class os_cckEntityInstance extends JTable
{
  /** @var array with all fields */
  //first table fileds 
  var $eiid = null;
  var $fk_lid = null;
  var $fk_eid = null;
  var $title = null;
  var $asset_id = null;
  var $fk_userid = null;
  var $published = null;
  var $approved = null;
  var $created = null;
  var $changed = null;
  var $checked_out = null;
  var $checked_out_time = null;
  var $teid = null;
  var $hits = null;
  var $instance_price = 0;
  var $instance_currency = null;
  var $notreaded = null;
  var $featured_clicks = null;
  var $featured_shows = null;
  var $access = null;
  var $meta_title = '';
  var $meta_description = '';
  var $meta_keywords = '';
  var $meta_robots = '';
  var $language = '';
  var $layout_type = '';
  var $associate_instances = '';
  
  

  /**
   * @param database - A database connector object
   */
  function __construct(&$db)
  {
      parent::__construct('#__os_cck_entity_instance', 'eiid', $db);
  }
  
  function checkMimeTypeFromFiles($ext) {
    $this->_db->setQuery("SELECT mime_ext FROM #__os_cck_mime_types WHERE mime_type=".$this->_db->quote($ext));
    $type = $this->_db->loadColumn();
    if(!$type)
      $type = 'unknown';
    return $type;
  }

  function check($admin = false){

    $db =  JFactory::getDBO();
    $layout_params = $this->_layout_params;
    
    foreach ($this->_field_list as $field) {
      

        //captcha_field
      if(!$this->eiid > 0){
          if($admin === false && $field->field_type == 'captcha_field'){


              if(os_cck_site_controller::SecondcheckCaptcha() === false){
                echo "<script> alert('".JText::_('COM_OS_CCK_INFOTEXT_JS_WRONG_CAPTCHA')."'); 
                      window.history.go(-1); </script>\n";
                exit;
              }


          }
      }
      
      //image-field
      if($field->field_type == 'imagefield'  && $_FILES['fi_'.$field->db_field_name]['error'] == ""){
        
        $imagesize = getimagesize($_FILES['fi_'.$field->db_field_name]['tmp_name']);
        $width = $imagesize[0];
        $height = $imagesize[1];
        $max_upload_size = (int)$layout_params[$field->db_field_name . "_max_upload_size"];//mb

        $allow_ext = trim($layout_params[$field->db_field_name . "_allow_ext"]);
        if(strlen($allow_ext)<1){
          $allow_ext = "jpg,jpeg,png,gif";
        }
        $allow_ext = str_ireplace(' ', '', $allow_ext);
        $allow_ext_array = explode(',', $allow_ext);
        
        $max_width = (int)$layout_params[$field->db_field_name . "_max_width"];
        $max_height = (int)$layout_params[$field->db_field_name . "_max_height"];

        $ext = $this->checkMimeTypeFromFiles($_FILES['fi_'.$field->db_field_name]['type']);

        if($ext == 'unknown'){
          $ext = pathinfo($_FILES['fi_'.$field->db_field_name]['name'], PATHINFO_EXTENSION);
          if(isset($allow_ext_array) && is_array($allow_ext_array) && array_search($ext, $allow_ext_array) === false){
            echo "<script> alert('".JText::_('COM_OS_CCK_EXT_NOT_SUPPORTED')." ".$allow_ext."'); 
                  window.history.go(-1); </script>\n";
            exit;
          }
        }else{
            if(isset($allow_ext_array) && is_array($allow_ext_array)){
                $temp_array = array_intersect($ext, $allow_ext_array) ;
            }else{
                $temp_array = array();
            }
          if(isset($allow_ext_array) && is_array($allow_ext_array) && empty($temp_array) ){
            echo "<script> alert('".JText::_('COM_OS_CCK_EXT_NOT_SUPPORTED')." ".$allow_ext."'); 
                  window.history.go(-1); </script>\n";
            exit;
          }
        }

        //max upload size
        if($max_upload_size != 0 && $_FILES['fi_'.$field->db_field_name]['size'] > ($max_upload_size*1000000)){
           echo "<script> alert('". $_FILES['fi_'.$field->db_field_name]['name'] ." ".JText::_('COM_OS_CCK_IMAGE_FILE_TOO_LARGE')." " . $max_upload_size . "mb'); 
             window.history.go(-1); </script>\n";
           exit;
        }

        //max width & max height
        if($max_width != 0 && $width>$max_width){
          echo "<script> alert('".JText::_('COM_OS_CCK_MAX_WIDTH_FOR_IMAGE')." ". $max_width ."px'); 
                window.history.go(-1); </script>\n";
          exit;
        }elseif($max_height != 0 && $height>$max_height){
          echo "<script> alert('".JText::_('COM_OS_CCK_MAX_HEIGHT_FOR_IMAGE')." ". $max_height ."px'); 
                window.history.go(-1); </script>\n";
          exit;
        }

      }
     
      //file-field
      if($field->field_type == 'filefield' && $_FILES['fi_'.$field->db_field_name]['error'] == ""){
 
        $max_upload_size = (int)$layout_params[$field->db_field_name . "_max_upload_size"];//mb
        $allow_ext = trim($layout_params[$field->db_field_name . "_allow_ext"]);
        $allow_ext = str_ireplace(' ', '', $allow_ext);
        if($allow_ext != ""){
          $allow_ext_array = explode(',', $allow_ext);
        }

        $ext = $this->checkMimeTypeFromFiles($_FILES['fi_'.$field->db_field_name]['type']);

        if($ext == 'unknown'){
          $ext = pathinfo($_FILES['fi_'.$field->db_field_name]['name'], PATHINFO_EXTENSION);
          if(isset($allow_ext_array) && is_array($allow_ext_array) && array_search($ext, $allow_ext_array) === false){
            echo "<script> alert('".JText::_('COM_OS_CCK_EXT_NOT_SUPPORTED')." ".$allow_ext."'); 
                  window.history.go(-1); </script>\n";
            exit;
          }
        }else{
          if(isset($allow_ext_array) && is_array($allow_ext_array)){
            $temp_array = array_intersect($ext, $allow_ext_array) ;
          }else{
              $temp_array = array();
          }
          if(isset($allow_ext_array) && is_array($allow_ext_array) && empty($temp_array) ){
            echo "<script> alert('".JText::_('COM_OS_CCK_EXT_NOT_SUPPORTED')." ".$allow_ext."'); 
                  window.history.go(-1); </script>\n";
            exit;
          }
        }

        if($max_upload_size != 0 && $_FILES['fi_'.$field->db_field_name]['size'] > ($max_upload_size*1000000)){
           echo "<script> alert('". $_FILES['fi_'.$field->db_field_name]['name'] ." ".JText::_('COM_OS_CCK_FILE_TOO_LARGE')." " . $max_upload_size . "mb'); 
             window.history.go(-1); </script>\n";
           exit;
        }

      }

      //audiofield
      if($field->field_type == 'audiofield'){
        
        for($i=1;isset($_FILES['new_upload_audio'.$i]);$i++){

          $max_upload_size = (int)$layout_params[$field->db_field_name . "_max_upload_size"];//mb
          $allow_ext = trim($layout_params[$field->db_field_name . "_allow_ext"]);
          $allow_ext = str_ireplace(' ', '', $allow_ext);
          if($allow_ext != ""){
            $allow_ext_array = explode(',', $allow_ext);
          }

          $ext = $this->checkMimeTypeFromFiles($_FILES['new_upload_audio'.$i]['type']);

          if($ext == 'unknown'){
            $ext = pathinfo($_FILES['new_upload_audio'.$i]['name'], PATHINFO_EXTENSION);
            if(isset($allow_ext_array) && is_array($allow_ext_array) && array_search($ext, $allow_ext_array) === false){
              echo "<script> alert('".JText::_('COM_OS_CCK_EXT_NOT_SUPPORTED')." ".$allow_ext."'); 
                    window.history.go(-1); </script>\n";
              exit;
            }
          }else{
              if(isset($allow_ext_array) && is_array($allow_ext_array)){
                  $temp_array = array_intersect($ext, $allow_ext_array) ;
              }else{
                  $temp_array = array();
              }
            if(isset($allow_ext_array) && is_array($allow_ext_array) && empty($temp_array) ){
              echo "<script> alert('".JText::_('COM_OS_CCK_EXT_NOT_SUPPORTED')." ".$allow_ext."'); 
                    window.history.go(-1); </script>\n";
              exit;
            }
          }

          if($max_upload_size != 0 && $_FILES['new_upload_audio'.$i]['size'] > ($max_upload_size*1000000)){
             echo "<script> alert('". $_FILES['new_upload_audio'.$i]['name'] ." ".JText::_('COM_OS_CCK_AUDIO_FILE_TOO_LARGE')." " . $max_upload_size . "mb'); 
               window.history.go(-1); </script>\n";
             exit;
          }
        }

      }

      //videofield
      if($field->field_type == 'videofield' ){
      
        for($i=1;isset($_FILES['new_upload_video'.$i]);$i++){

          $max_upload_size = (int)$layout_params[$field->db_field_name . "_max_upload_size"];//mb
          $allow_ext = trim($layout_params[$field->db_field_name . "_allow_ext"]);
          
          $allow_ext = str_ireplace(' ', '', $allow_ext);
          
          if($allow_ext != ""){ 
            $allow_ext_array = explode(',', $allow_ext);
          }else{
              $allow_ext_array = '';
          }

          $ext = $this->checkMimeTypeFromFiles($_FILES['new_upload_video'.$i]['type']);
          
          if($ext == 'unknown'){
            $ext = pathinfo($_FILES['new_upload_video'.$i]['name'], PATHINFO_EXTENSION);
            if(isset($allow_ext_array) && is_array($allow_ext_array) && array_search($ext, $allow_ext_array) === false){
              echo "<script> alert('".JText::_('COM_OS_CCK_EXT_NOT_SUPPORTED')." ".$allow_ext."'); 
                    window.history.go(-1); </script>\n";
              //exit;
            }
          }else{
            if(isset($allow_ext_array) && is_array($allow_ext_array)){
                $temp_array = array_intersect($ext, $allow_ext_array) ;
            }else{
                $temp_array = array();
            }
            
            if(isset($allow_ext_array) && is_array($allow_ext_array) && empty($temp_array) ){
              echo "<script> alert('".JText::_('COM_OS_CCK_EXT_NOT_SUPPORTED')." ".$allow_ext."'); 
                    window.history.go(-1); </script>\n";
              exit;
            }
          }

          if($max_upload_size != 0 && $_FILES['new_upload_video'.$i]['size'] > ($max_upload_size*1000000)){
             echo "<script> alert('". $_FILES['new_upload_video'.$i]['name'] ." ".JText::_('COM_OS_CCK_VIDEO_FILE_TOO_LARGE')." " . $max_upload_size . "mb'); 
               window.history.go(-1); </script>\n";
             exit;
          }

        }

      }
      
    }

    // Forbidden string in extension (e.g. php matched .php, .xxx.php, .php.xxx and so on)
      // 'forbidden_extensions'       => array(
      //   'php', 'phps', 'pht', 'phtml', 'php3', 'php4', 'php5', 'php6', 'php7', 'inc', 'pl', 'cgi', 'fcgi', 'java', 'jar', 'py',

   
  }

  function quoteName($name){
    $return = $this->_db->quoteName($name);
    return $return;
  }

  function load($id = null, $bool = true){
    // var_dump(parent::load());
    // var_dump($this);
    if(!parent::load($id)){
    // parent::load($id);
    // var_dump($aaaa);
      echo $this->getError();
      // var_dump($this->getError()); exit;
    }
//    var_dump($this);
    if($this->fk_eid && $this->eiid){
        $query = "SELECT * FROM #__os_cck_content_entity_$this->fk_eid WHERE fk_eiid=$this->eiid";
        //var_dump($query); exit;
        $this->_db->setQuery($query);
        $fields_val = $this->_db->loadAssoc();
        $this->_field_value_list = $fields_val;
    }
//    var_dump($this);
//    var_dump($fields_val);
  }

  public function getReviews($eiid = 0){
    $query = "SELECT ei2.*,u.*,l.params FROM #__os_cck_entity_instance as ei"
              ."\n LEFT JOIN #__os_cck_child_parent_connect as pc ON pc.fid_parent = ei.eiid"
              ."\n LEFT JOIN #__os_cck_entity_instance as ei2 ON pc.fid_child = ei2.eiid"
              ."\n LEFT JOIN #__os_cck_layout as l ON l.lid = ei2.fk_lid"
              ."\n LEFT JOIN #__users as u ON u.id = ei2.fk_userid"
              ."\n WHERE fid_parent=$this->eiid AND l.type='review_instance' AND ei2.published = 1 AND ei2.approved = 1 ORDER BY ei2.eiid DESC";
    $this->_db->setQuery($query);
    return $this->_db->loadObjectList();
  }

  /**
   * Binds a named array/hash to this object
   *
   * Can be overloaded/supplemented by the child class
   *
   * @access  public
   * @param $from mixed An associative array or object
   * @param $ignore mixed An array or space separated list of fields not to bind
   * @return  boolean
   */
  function bind($from, $ignore = array()){
    $fromArray = is_array($from);
    $fromObject = is_object($from);
    if (!$fromArray && !$fromObject) {
      $this->setError(get_class($this) . '::bind failed. Invalid from argument');
      return false;
    }
    if (!is_array($ignore)) {
      $ignore = explode(' ', $ignore);
    }
    foreach ($this->getProperties() as $k => $v) {
      // internal attributes of an object are ignored
      if (!in_array($k, $ignore)) {
        if ($fromArray && isset($from[$k])) {
            $this->$k = $from[$k];
        } else if ($fromObject && isset($from->$k)) {
            $this->$k = $from->$k;
        }
      }
    }
    return true;
  }
  
  function require_check(){
    $db =  JFactory::getDBO();
    foreach ($this->_field_list as $field) {
      if($field->field_type == 'captcha_field' || $field->field_type == 'galleryfield')continue;
      if(!isset($this->_layout_params[$field->db_field_name.'_required']) || $this->_layout_params[$field->db_field_name.'_required'] != 'on' ) continue;
      if($this->_layout_params[$field->db_field_name.'_published'] != 'on') continue;
      if($field->published == 0) continue;
      $field->value = '';
      
      foreach ($this->fields_data as $key => $var) {
        if($field->field_type == 'pricefield_number' && stripos($key, $field->db_field_name . '_') !== false){
          $field->value = $var;
        }
        
        if ($field->db_field_name == $key)
          $field->value = $var;
      }
      if($field->field_type=='filefield' || $field->field_type=='imagefield'){
        $file = new os_cckFile($db);
        $old_data = $this->getFieldValue($field);
        if(empty($old_data) && (!$old_data['0']->fid && $_FILES['fi_'.$field->db_field_name]['error'] == 4)){
          return false;
        }
      }
      if($field->field_type=='videofield'){
        $old_data = $this->getFieldValue($field);
        
        if(empty($old_data[0]) && ($_FILES['fi_'.$field->db_field_name]['error'] == 4)){
            
          return false;
        }
      }
      if($field->field_type=='audio'){
        $old_data = $this->getFieldValue($field);
        if(empty($old_data['audio']) || ($_FILES['fi_'.$field->db_field_name]['error'] == 4)){
          return false;
        }
      }
      if($field->field_type == 'locationfield') {
        $adress = protectInjectionWithoutQuote('fi_'.$field->db_field_name . "_map_address");
        $vlat = protectInjectionWithoutQuote('fi_'.$field->db_field_name   . "_map_latitude");
        $vlong = protectInjectionWithoutQuote('fi_'.$field->db_field_name  . "_map_longitude");
        $zoom = protectInjectionWithoutQuote('fi_'.$field->db_field_name   . "_map_zoom");
        if(empty($adress)
          || empty($vlat)
          || empty($vlong)
          || empty($zoom)){
          return false;
      }
      }
      if ($field->field_type == 'text_url') {
        if(strlen($field->value) < 8){
          return false;
        }
      }
      if ($field->field_type == 'text_select_list') {
        if(empty($field->value) || $field->value === 0){
          return false;
        }
      }
      if ($field->field_type == 'categoryfield') {
        $categories = protectInjectionWithoutQuote("categories","");
        if(!isset($categories[0]) && empty($categories[0])){
          return false;
        }
      }
      
      if($field->field_type!='filefield'
        && $field->field_type!='text_single_checkbox_onoff'
        && $field->field_type!='text_radio_buttons'
        && $field->field_type!='locationfield'
        && $field->field_type!='text_select_list'
        && $field->field_type!='imagefield'
        && $field->field_type!='text_url'
        && $field->field_type!='videofield'
        && $field->field_type!='audiofield'
        && $field->field_type!='categoryfield'
        && !$field->value){
          
          return false;
      }
    }
    return true;
  }
  
  /**
   * Inserts a new row if id is zero or updates an existing row in the database table
   *
   * Can be overloaded/supplemented by the child class
   *
   * @access public
   * @param boolean If false, null object variables are not updated
   * @return null|string null if successful otherwise returns and error message
   */
  function store($updateNulls = false){
    global $app, $global_settings, $input;
    
    parent::store();
    $query = "SHOW TABLES LIKE '".$this->_db->getprefix()."os_cck_content_entity_".$this->fk_eid."' ";
    $this->_db->setquery($query);
    $table_exists = $this->_db->loadresult();
    if (isset($this->_price_fields)){
        foreach ($this->_price_fields as $price_field){
            $query = "SELECT * FROM #__os_cck_content_instances_price WHERE fk_fid='$price_field->fid' AND fk_eiid='$this->eiid' AND ordering='$price_field->ordering'";
            $this->_db->setQuery($query);
            $result = $this->_db->loadResult();
            if($price_field->quantity == null){
                $price_field->quantity = 0;
            }
            if($price_field->price_value == ''){
                $price_field->price_value = 0;
            }
            if(!$result){

                $query = "INSERT INTO #__os_cck_content_instances_price (fk_eid, fk_eiid, fk_fid, price_name, price_value, quantity, ordering) "
                    . "VALUE ('$this->fk_eid', '$this->eiid', '$price_field->fid', '$price_field->price_name', '$price_field->price_value', '$price_field->quantity', '$price_field->ordering')";
            }else{
                
                $query = "UPDATE #__os_cck_content_instances_price SET "
                        . " fk_eid = '$this->fk_eid', "
                        . " fk_eiid = '$this->eiid', "
                        . " fk_fid = '$price_field->fid', "
                        . " price_name = '$price_field->price_name', "
                        . " price_value = '$price_field->price_value', "
                        . " quantity = '$price_field->quantity', "
                        . " ordering = '$price_field->ordering' "
                        . " WHERE fk_fid='$price_field->fid' AND fk_eiid='$this->eiid'  AND ordering='$price_field->ordering'";
                //var_dump($query);
            }
//            print_r ($query); exit;
//            var_dump($price_field->price_value); exit;
            $this->_db->setQuery($query);
            $this->_db->execute();
        }
    }
    

//    
    if (isset($this->_child_entity_fields)){
        foreach($this->_child_entity_fields as $key => $child_entity_fields){
//            var_dump($key);
//            var_dump($child_entity_fields);
            foreach($child_entity_fields as $child_entity_field){
                //var_dump($child_entity_field);
                $query = "SELECT COUNT(*) FROM #__os_cck_child_parent_connect WHERE fid_parent='$this->eiid' AND media_type='$key'";
                $this->_db->setQuery($query);
                $count = $this->_db->loadResult();
                //var_dump($count);
                if($child_entity_field > 0){
                    
                    if($count == 1){
                        $query = "UPDATE #__os_cck_child_parent_connect SET "
                                . " fid_parent = '$this->eiid', "
                                . " fid_child = '$child_entity_field', "
                                . " media_type = '$key' "
                                . " WHERE fid_parent='$this->eiid' AND media_type='$key'";
                    }else{

                        $query = "INSERT INTO #__os_cck_child_parent_connect (fid_parent, fid_child, media_type)"
                                . "VALUE('$this->eiid', '$child_entity_field', '$key')"; 
                    }
                    $this->_db->setQuery($query);
                    $this->_db->execute();
                }else{
                    if($count == 1){
                        $query = "DELETE FROM #__os_cck_child_parent_connect WHERE fid_parent='$this->eiid' AND media_type='$key'";
                        $this->_db->setQuery($query);
                        $this->_db->execute();
                    }
                }
            }
        }
    }
    
    //exit;
    if ($table_exists) {
      $query = " SELECT * FROM #__os_cck_content_entity_" . $this->fk_eid . " WHERE fk_eiid='" . $this->eiid . "' ";
      $this->_db->setQuery($query);
      $result = $this->_db->loadResult();
      if (!$result) {
          
        $query = " INSERT INTO #__os_cck_content_entity_" . $this->fk_eid . " SET fk_eiid='" . $this->eiid . "' ";
        $this->_db->setQuery($query);
        $this->_db->execute();
      }
    }

    if(isset($this->_field_list)){
      foreach ($this->_field_list as $field) {
  	    if($field->published == 0) continue;
          $field->value = '';
        foreach ($this->fields_data as $key => $var) {
          if ($field->db_field_name == $key)
            $field->value = $var;
        }
        
        if($field->field_type == 'categoryfield'){
          $query = " DELETE FROM  #__os_cck_categories_connect WHERE fk_eiid='" . $this->eiid . "' ";
          $this->_db->setQuery($query);
          
          try {
              $this->_db->execute();
          } catch (RuntimeException $e) {
              echo $e->getMessage();
          }
          //echo $this->_db->getErrorMsg();
          if (count($this->categories) > 0) {
            $insert = array();
            foreach ($this->categories as $temp) {
              $insert[] = " ( " . $this->eiid . ", " . $temp . " ) ";
            }
            $query = " INSERT INTO #__os_cck_categories_connect (fk_eiid, fk_cid) VALUES " . implode(", ", $insert);
            $this->_db->setQuery($query);
            $this->_db->execute();
          }
        }
        
        if ($field->field_type == 'text_url') {
          if(strlen($field->value) < 8)$field->value = '';
        }
        if($field->field_type == 'decimal_textfield'){
          if(empty($field->value) && $field->value != '0'){
            $query = " UPDATE #__os_cck_content_entity_" . $this->fk_eid . 
              " SET " . $this->_db->quoteName($field->db_field_name) . "= NULL WHERE fk_eiid='" . $this->eiid . "' ";
            $this->_db->setQuery($query);
            $this->_db->execute();
            continue;                       
          }
          if(isset($this->instance_currency) && !empty($this->instance_currency) && $this->instance_currency != ''){
              $query = " UPDATE #__os_cck_entity_instance" . 
              " SET instance_currency= '" . $this->instance_currency . "'  WHERE eiid='" . $this->eiid . "' ";
      //var_dump($query); exit;
            $this->_db->setQuery($query);
            $this->_db->execute();
          }
         
        }
        
        if ($field->field_type == 'datetime_popup') {
            
          if(isset($global_settings['default_field_value']) && $global_settings['default_field_value'] == 'CHANGE'){
            $date = new DateTime();
            $field->value = $date->format('Y-m-d H:i:s');
          }
          if(isset($global_settings['default_field_value']) && $global_settings['default_field_value'] == 'CREATE'){
            $query = " SELECT created FROM #__os_cck_entity_instance WHERE eiid='" . $this->eiid . "' ";
            $this->_db->setQuery($query);
            $field->value = $this->_db->loadResult();
          }
          
          if(trim($field->value) == '' || trim($field->value) == '00:00:00'){
              $field->value = '0000-00-00 00:00:00';
          }else{
//              var_dump($field->value); exit;
              $field->value = date('Y-m-d H:i:s',strtotime($field->value));  
          }
          
          
        }
        
        if ($field->field_type == 'filefield' || $field->field_type == 'imagefield') { 
            
            
          if ($field != $this->_insertFiles($field)){
            
              
              continue;
          }
        }
        
        if ($field->field_type == 'locationfield') {
          $adress = $this->_db->Quote($app->input->get('fi_'.$field->db_field_name . "_map_address",null,"STRING"));
          $country = $this->_db->Quote($app->input->get('fi_'.$field->db_field_name . "_map_country",null,"STRING"));
          $city = $this->_db->Quote($app->input->get('fi_'.$field->db_field_name . "_map_city",null,"STRING"));
          $region = $this->_db->Quote($app->input->get('fi_'.$field->db_field_name . "_map_region]",null,"STRING"));
          $zip = $this->_db->Quote($app->input->get('fi_'.$field->db_field_name . "_map_zip_code",null,"STRING"));
          $latitude = $this->_db->Quote($app->input->get('fi_'.$field->db_field_name . "_map_latitude",0,"STRING"));
          $longitude = $this->_db->Quote($app->input->get('fi_'.$field->db_field_name . "_map_longitude",0,"STRING"));
          $zoom = $this->_db->Quote($app->input->get('fi_'.$field->db_field_name . "_map_zoom",0,"STRING"));
          
          $query = " UPDATE #__os_cck_content_entity_" . $this->fk_eid . " SET " .
              $this->_db->quoteName($field->db_field_name."_vlat")." = ".$latitude.",".
              $this->_db->quoteName($field->db_field_name."_vlong")."=".$longitude.",".
              $this->_db->quoteName($field->db_field_name."_zoom")."=".$zoom.",".
              $this->_db->quoteName($field->db_field_name."_country")."=".$country.",".
              $this->_db->quoteName($field->db_field_name."_city")."=".$city.",".
              $this->_db->quoteName($field->db_field_name."_region")."=".$region.",".
              $this->_db->quoteName($field->db_field_name."_zipcode")."=".$zip.",".              
              $this->_db->quoteName($field->db_field_name."_address")."=".$adress."  ".
                " WHERE fk_eiid='" . $this->eiid . "' ";
          $this->_db->setQuery($query);
          $this->_db->execute();
        } else if($field->field_type == 'videofield'){ 
      ////////////////////////////STORE video/track functions START\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
          for ($j = 1;isset($_FILES['new_upload_track' . $j]) 
            || array_key_exists('new_upload_track_url' . $j, $_POST);$j++) { 
              $track_name = '';
              if (isset($_FILES['new_upload_track' . $j]) && $_FILES['new_upload_track' . $j]['name'] != "") {
                //storing e-Document
                //$track = protectInjectionWithoutQuote('new_upload_track' . $j, '', 'files');
                  $track = $input->files->get('new_upload_track' . $i, '');
                $code = $this->guid();
                $track_name = $code . '_' . $this->filter($track['name']);
                if (intval($track['error']) > 0 && intval($track['error']) < 4) {
                  echo "<script> alert('" . COM_OS_CCK_LABEL_TRACK_UPLOAD_ERROR . " - " .
                                       $track_name . "'); window.history.go(-1); </script>\n";
                  exit();
                } else if (intval($track['error']) != 4) {
                  $track_new = JPATH_SITE .'/components/com_os_cck/files/track/'. $track_name;
                  if (!move_uploaded_file($track['tmp_name'], $track_new)) {
                    echo "<script> alert('" . COM_OS_CCK_LABEL_TRACK_UPLOAD_ERROR . " - " .
                                         $track_name . "'); window.history.go(-1); </script>\n";
                    exit();
                  }
                }
              }
              if (array_key_exists('new_upload_track_kind' . $j, $_POST) 
                && $_POST['new_upload_track_kind' . $j] != "") {
                  //$uploadTrackKind = protectInjectionWithoutQuote('new_upload_track_kind' . $j, '', 'post');
                  $uploadTrackKind = $input->get('new_upload_track_kind' . $j, '');
                  $uploadTrackKind = strip_tags(trim($uploadTrackKind));
              }
              if (array_key_exists('new_upload_track_scrlang' . $j, $_POST) 
                && $_POST['new_upload_track_scrlang' . $j] != "") {
                  //$uploadTrackScrlang = protectInjectionWithoutQuote('new_upload_track_scrlang' . $j, '', 'post');
                  $uploadTrackScrlang = $input->get('new_upload_track_scrlang' . $j, '');
                  $uploadTrackScrlang = strip_tags(trim($uploadTrackScrlang));
              }
              if (array_key_exists('new_upload_track_label' . $j, $_POST) 
                && $_POST['new_upload_track_label' . $j] != "") {
                  //$uploadTrackLabel = protectInjectionWithoutQuote('new_upload_track_label' . $j, '', 'post');
                  $uploadTrackLabel = $input->get('new_upload_track_label' . $j, '');
                  $uploadTrackLabel = strip_tags(trim($uploadTrackLabel));
              }
              if (array_key_exists('new_upload_track_url' . $j, $_POST) && $_POST['new_upload_track_url' . $j] != "") {
                //$uploadTrackURL = protectInjectionWithoutQuote('new_upload_track_url' . $j, '', 'post');
                $uploadTrackURL = $input->get('new_upload_track_url' . $j, '');
                $uploadTrackURL = strip_tags(trim($uploadTrackURL));
                if (empty($track_name) && !empty($uploadTrackURL))
                  $this->saveTracks($this->eiid, $uploadTrackURL, $uploadTrackKind, $uploadTrackScrlang, $uploadTrackLabel);          
              }
              if (!empty($track_name)) 
                $this->saveTracks($this->eiid, $track_name, $uploadTrackKind, $uploadTrackScrlang, $uploadTrackLabel);
          }
          
          for ($j = 1;isset($_FILES[$field->fid . '_new_upload_video' . $j]) 
            || array_key_exists($field->fid . '_new_upload_video_url' . $j, $_POST) 
            || array_key_exists($field->fid . '_new_upload_video_youtube_code' . $j, $_POST);$j++) { 
              
              $video_name = '';
              if (isset($_FILES[$field->fid . '_new_upload_video' . $j]) && $_FILES[$field->fid . '_new_upload_video' . $j]['name'] != "") {
                //storing e-Document
                //$video = protectInjectionWithoutQuote($field->fid . '_new_upload_video' . $j, '', 'files');
                $video = $input->files->get($field->fid . '_new_upload_video' . $j, '');
                $ext = pathinfo($video['name'], PATHINFO_EXTENSION);
                $type = $this->checkMimeType($ext);
                $code = $this->guid();
                $video_name = $code . '_' . $this->filter($video['name']);
                if (intval($video['error']) > 0 && intval($video['error']) < 4) {
                  echo "<script> alert('" . COM_OS_CCK_LABEL_VIDEO_UPLOAD_ERROR . " - " .
                                         $video_name . "'); window.history.go(-1); </script>\n";
                  exit();
                } else if (intval($video['error']) != 4) {
                  $video_new = JPATH_SITE . '/components/com_os_cck/files/video/'  . $video_name;
                  if (!move_uploaded_file($video['tmp_name'], $video_new)) {
                    echo "<script> alert('" . COM_OS_CCK_LABEL_VIDEO_UPLOAD_ERROR . " - " .
                                         $video_name . "'); window.history.go(-1); </script>\n";
                    exit();
                  }
                  $this->saveVideos($video_name, $this->eiid, $type, $field->fid);
                }
              }
              if (array_key_exists($field->fid . '_new_upload_video_url' . $j, $_POST) && $_POST[$field->fid . '_new_upload_video_url' . $j] != "") {
                  
                //$uploadVideoURL = protectInjectionWithoutQuote($field->fid . '_new_upload_video_url' . $j, '', 'post');
                $uploadVideoURL = $input->get($field->fid . '_new_upload_video_url' . $j, '', 'STRING');
                
                $uploadVideoURL = strip_tags(trim($uploadVideoURL));
                
                $end = explode(".", $uploadVideoURL);
                
                $ext = end($end);
                
                $type = $this->checkMimeType($ext);
                
                if(empty($video_name) && !empty($uploadVideoURL)){
                    $this->saveVideos($uploadVideoURL, $this->eiid, $type, $field->fid);
                
                } 
              }
              if (array_key_exists($field->fid . '_new_upload_video_youtube_code' . $j, $_POST) 
                && $_POST[$field->fid . '_new_upload_video_youtube_code' . $j] != "") {
                  //$uploadVideoYoutubeCode = protectInjectionWithoutQuote($field->fid . '_new_upload_video_youtube_code' . $j, '', 'post');
                  $uploadVideoYoutubeCode = $input->get($field->fid . '_new_upload_video_youtube_code' . $j, '');
                  $uploadVideoYoutubeCode = strip_tags(trim($uploadVideoYoutubeCode));
                  $this->saveYouTubeCode($uploadVideoYoutubeCode, $this->eiid, $field->fid);
              }
          }
      ////////////////////////////STORE video/track functions END\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
      ////////////////////////////DELETE video/track functions END\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
          $this->deleteTracks($this->eiid);
          $this->deleteVideos($this->eiid);
      ////////////////////////////DELETE video/track functions END\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
        }else if($field->field_type == 'audiofield'){
////////////////////////////STORE audio functions START\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
          for ($j = 1;isset($_FILES['new_upload_audio' . $j]) 
                || array_key_exists('new_upload_audio_url' . $j, $_POST);$j++) {
            if (isset($_FILES['new_upload_audio' . $j]) && $_FILES['new_upload_audio' . $j]['name'] != "") {
              //storing e-Document
              $audio = $input->files->get('new_upload_audio' . $j, '');
              $ext = pathinfo($audio['name'], PATHINFO_EXTENSION);
              $type = $this->checkMimeType($ext);
              $code = $this->guid();
              $audio_name = $code . '_' . $this->filter($audio['name']);
              //mime_content_type($file_name);
              //if( !isset($_FILES['new_upload_file'.$i]) ) continue;
              if (intval($audio['error']) > 0 && intval($audio['error']) < 4) {
                  echo "<script> alert('" . JText::_('COM_OS_CCK_LABEL_AUDIO_UPLOAD_ERROR') . " - " . 
                    $audio_name . "'); window.history.go(-1); </script>\n";
                  exit();
              } else if (intval($audio['error']) != 4) {
                  $audio_new = JPATH_SITE . '/components/com_os_cck/files/audio/' . $audio_name;
                  if (!move_uploaded_file($audio['tmp_name'], $audio_new)) {
                      echo "<script> alert('" . JText::_('COM_OS_CCK_LABEL_AUDIO_UPLOAD_ERROR') . " - " . 
                        $audio_name . "'); window.history.go(-1); </script>\n";
                      exit();
                  }
                  $this->saveAudios($audio_name, $this->eiid, $type);
              }
            }
            if (array_key_exists('new_upload_audio_url' . $j, $_POST) && $_POST['new_upload_audio_url' . $j] != "") {
              if (isset($_FILES['new_upload_audio' . $j]) && $_FILES['new_upload_audio' . $j]['name'] == "") {
                  //$uploadAudioURL = protectInjectionWithoutQuote('new_upload_audio_url' . $j, '', 'post');
                  $uploadAudioURL = $input->get('new_upload_audio_url' . $j, '');
                  $uploadAudioURL = strip_tags(trim($uploadAudioURL));
                  $end = explode(".", $uploadAudioURL);
                  $ext = end($end);
                  $type = $this->checkMimeType($ext);
                  $this->saveAudios($uploadAudioURL, $this->eiid, $type);
              }
            }
          }
////////////////////////////STORE audio functions STOP\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
////////////////////////////DELETE AUDIO functions END\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
          $this->deleteAudios($this->eiid);
////////////////////////////DELETE AUDIO functions END\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
        }else if ($field->field_type == "imagefield"
                  || $field->field_type == "filefield"
                ) {  
            $old_data = $this->getFieldValue($field);
            if($field->field_type == "imagefield" && $field->fid == ''){
                $field->fid = '0';
            }
          $query = " UPDATE #__os_cck_content_entity_" . $this->fk_eid . " SET " .
              $field->db_field_name . "_fid  ='" . $field->fid . "' , " .
              $field->db_field_name . "_list ='0' , " .
              $field->db_field_name . "_data  ='" . $field->value . "'  " .
              " WHERE fk_eiid='" . $this->eiid . "' ";
          
          $this->_db->setQuery($query);
          $this->_db->execute();
         
        }elseif ($field->field_type == "galleryfield") {
            $old_data = $this->getFieldValue($field);
          if($old_data['0']->data != $field->value){
              $this->deleteGalleryImage($field);
          }
          
          $query = " UPDATE #__os_cck_content_entity_" . $this->fk_eid . " SET " .
              $field->db_field_name . "_fid  ='" . $field->fid . "' , " .
              $field->db_field_name . "_list ='0' , " .
              $field->db_field_name . "_data  ='" . $field->value . "'  " .
              " WHERE fk_eiid='" . $this->eiid . "' ";
          //var_dump($query); exit;
          $this->_db->setQuery($query);
          $this->_db->execute();
                
        }elseif ($field->field_type == "text_select_list"){
            
//            if(is_array($field->value) && $field->value[0] == '0'){
//                unset($field->value[0]);
//            }
            
            $select_value = json_encode($field->value);
            
            $query = " UPDATE #__os_cck_content_entity_" . $this->fk_eid . 
            " SET " . $this->_db->quoteName($field->db_field_name) . "=" . $this->_db->Quote($select_value) . 
            " WHERE fk_eiid='" . $this->eiid . "' ";
          $this->_db->setQuery($query);
          $this->_db->execute();
            //var_dump($select_value); exit;
        }elseif ($field->field_type == "text_radio_buttons"){
            if($field->value != '') {
                if ($field->value == 0) {
                    $field->value = '-1';
                }
                $query = " UPDATE #__os_cck_content_entity_" . $this->fk_eid .
                    " SET " . $this->_db->quoteName($field->db_field_name) . "=" . $this->_db->Quote($field->value) .
                    " WHERE fk_eiid='" . $this->eiid . "' ";
                $this->_db->setQuery($query);
                $this->_db->execute();
            }
        }elseif(stripos($field->field_type, 'pricefield') !== FALSE){
            
        }
//        }elseif($field->field_type == "text_single_checkbox_onoff"){
//            var_dump($field); exit;
//        }
        else{ 
            if($field->field_type == "text_single_checkbox_onoff" && $field->value == ''){
                 $field->value = 0;
             }
            //if($field->value != ''){ //cannot enter null value while editing instance
              $query = " UPDATE #__os_cck_content_entity_" . $this->fk_eid . 
                " SET " . $this->_db->quoteName($field->db_field_name) . "=" . $this->_db->Quote($field->value) . 
                " WHERE fk_eiid='" . $this->eiid . "' ";

              $this->_db->setQuery($query);
              $this->_db->execute();
            //}
        }
      }
     
      
    }
    
    //end foreach _list_field
  }
  
  function deleteGalleryImage($field){
      $old_data = $this->getFieldValue($field);
      $img_path = JPATH_SITE . '/images/com_os_cck' . $old_data[0]->fid . '/original/';
      $tmb_path = JPATH_SITE . '/images/com_os_cck' . $old_data[0]->fid . '/thumbnail/';
      
      $new_value = json_decode($field->value);
      // var_dump($old_data); exit;
      if($old_data['0']->data){
        $old_value = json_decode($old_data['0']->data);
      }else{
        $old_value = array();
      }
      
      $new_files = array();
      if($new_value){
          foreach ($new_value as $value){
              $new_files[] = $value->file;
          }
      }
      $old_files = array();
      foreach ($old_value as $value){
          $old_files[] = $value->file;
      }
      
      $images = array();
      foreach ($old_files as $value){
          if(!in_array($value, $new_files)){
              $images[] = $img_path . $value;
              $images[] = $tmb_path . $value;
          }
      }
      
      foreach ($images as $file){
          if(file_exists($file)){
              unlink($file);
          }
      }
     
  }
  function _insertFiles($field){
      global $os_cck_configuration;
      $db =  JFactory::getDBO();
      $file = new os_cckFile($db);
      @ $uploadPath = ($field->field_type == 'imagefield') ?
          JPATH_SITE . '/components/com_os_cck/files/images/' .
                      $field->db_field_name . "_" . time() . "_" .
                      $_FILES["fi_" . $field->db_field_name]['name'] :
          JPATH_SITE . '/components/com_os_cck/'.$os_cck_configuration->get('filehosting_folder', 'files').'/' . $field->db_field_name . "_" .
                      time() . "_" . $_FILES["fi_" . $field->db_field_name]['name'];
              
      $old_data = $this->getFieldValue($field);
      
      $file = $this->_saveFile($field, $uploadPath, '', $old_data[0]);
      
      if($file){
          $field->fid = $file->fid;
      }else{
          if($old_data[0]->fid){
              $field->fid = $old_data[0]->fid;
          }
      }
      //$field->fid = ($file) ? $file->fid : $old_data[0]->fid;
      
      $field->value = ($file) ? $file->filepath : $old_data[0]->data;
      return $field;
  }

  function _saveFile($field, $uploadPath, $multiple_num, $old_data){
      //prepare for multiple or not multiple
      $fieldName = $field->db_field_name;
      $db =  JFactory::getDBO();
      $file = new os_cckFile($db);
      
      if (isset($_REQUEST["delete_fi_" . $fieldName]) || isset($_REQUEST["delete_fi_" . $fieldName . "_" . $multiple_num])) {
          $file_del = ($multiple_num === '') ?
              protectInjectionWithoutQuote("delete_fi_" . $fieldName) : protectInjectionWithoutQuote("delete_fi_" . $fieldName . "_" . $multiple_num);
          //var_dump($_REQUEST["delete_fi_" . $fieldName]);
          if (isset($file_del) && $file_del != '') {
            
              $file->load($old_data->fid);
              
              $file->delete();
              $file->fid = '';
              $file->filepath = '';
              $file->filename = '';
              return $file;
          }
      }
      
      $fieldName = "fi_" . $fieldName;
      if(($field->field_type == 'imagefield' || $field->field_type == 'filefield')
         && (isset($field->required) && $field->required && !empty($_FILES[$fieldName]['name'] ) && $old_data->fid)){ 
          $file->load($old_data->fid);
          $file->delete();
          $file->fid = '';
          $file->filepath = '';
          $file->filename = '';
      }
      
      if (!(isset($_FILES[$fieldName]) || isset($_FILES[$fieldName . "_" . $multiple_num]['name'])))
          return false;
      
      $array['error'] = ($multiple_num === '') ? $_FILES[$fieldName]['error'] : $_FILES[$fieldName . "_" . $multiple_num]['error'];
      $array['name'] = ($multiple_num === '') ? $_FILES[$fieldName]['name'] : $_FILES[$fieldName . "_" . $multiple_num]['name'];
      $array['tmp_name'] = ($multiple_num === '') ? $_FILES[$fieldName]['tmp_name'] : $_FILES[$fieldName . "_" . $multiple_num]['tmp_name'];
      $array['type'] = ($multiple_num === '') ? $_FILES[$fieldName]['type'] : $_FILES[$fieldName . "_" . $multiple_num]['type'];
      $array['size'] = ($multiple_num === '') ? $_FILES[$fieldName]['size'] : $_FILES[$fieldName . "_" . $multiple_num]['size'];
      
      if ($array['name'] == '')
          return false;
      
      if ($array['error'] > 0) {
          switch ($array['error']) {
              case 1:
                  echo JText::_('COM_OS_CCK_LABEL_FILE_TO_LARGE_PHP');
                  return false;
              case 2:
                  echo JText::_('COM_OS_CCK_LABEL_FILE_TO_LARGE_HTML');
                  return false;
              case 3:
                  echo JText::_('COM_OS_CCK_LABEL_ERROR_PARTIAL_UPLOAD');
                  return false;
              case 4:
                  echo JText::_('COM_OS_CCK_LABEL_ERROR_NO_FILE');
                  return false;
          }
      }
      
      if (!JFile::upload($array['tmp_name'], $uploadPath)) {
          echo JText::_('COM_OS_CCK_LABEL_ERROR_MOVING_FILE');
          echo "<pre>";
          var_dump($fieldName);
          print_r($_FILES);
          print_r("----" . $uploadPath);
          print_r($array);
          echo "</pre>";
          return false;
      }

      $file->filename = $array['name'];
      $file->filepath = str_replace(JPATH_SITE, '', $uploadPath);
      $file->filemime = $array['type'];
      $file->filesize = $array['size'];
      $file->status = 1;
      $file->timestamp = time();
      $file->store();
      return $file;
  }


  function getField($fid){
    
    $query = "SELECT * FROM #__os_cck_entity_field WHERE fid = '".$fid."'";
    $this->_db->setQuery($query);
    return $this->_db->loadObject();
    
  }

  function getSelectFieldValue($fid){
    if(!$this->eiid) return '';

      $query = " SELECT " . $this->_db->quoteName('text_select_list_'.(int)$fid) . 
        " AS data FROM #__os_cck_content_entity_" . $this->fk_eid . " WHERE fk_eiid='" . $this->eiid . "' ";
      $this->_db->setQuery($query);
      $result = $this->_db->loadResult();
    
    return $result;
  }


  function getFieldValue($field, $entity_type = 'os_cck_entity', $user_profile_form = '', $user = '', $child_id = false, $parent_instance = false, $related_fields = false){
      global $entityFieldLists;

        
      if($entity_type == 'os_cck_entity'){
            if(!$this->eiid)return '';
            if ($field->field_type == 'videofield') {
              $query = " SELECT * FROM #__os_cck_video_source WHERE fk_eiid='" . $this->eiid . "' AND fk_fid='$field->fid'";
              $this->_db->setQuery($query);
              $result[0] = $this->_db->loadObjectList();
              $query = " SELECT * FROM #__os_cck_track_source WHERE fk_eiid='" . $this->eiid . "' ";
              $this->_db->setQuery($query);
              $result[1] = $this->_db->loadObjectList();
            }elseif ($field->field_type == 'audiofield') {
              $query = " SELECT * FROM #__os_cck_audio_source WHERE fk_eiid='" . $this->eiid . "' ";
              $this->_db->setQuery($query);
              $result = $this->_db->loadObjectList();
            }elseif ($field->field_type == 'categoryfield') {
              $query = "SELECT cc.title AS title ,cc.cid as catid, cc.image as image" .
                  "\n FROM #__os_cck_entity_instance AS jei " .
                  "\n LEFT JOIN #__os_cck_categories_connect AS c ON jei.eiid=c.fk_eiid " .
                  "\n LEFT JOIN #__os_cck_categories AS cc ON cc.cid = c.fk_cid " .
                  "\n WHERE jei.eiid=$this->eiid";
              $this->_db->setQuery($query);
              $result = $this->_db->loadObjectList();
            }elseif ($field->field_type == 'imagefield' || $field->field_type == 'filefield') {
                
                if(isset($this->_field_value_list[$field->db_field_name.'_data'])){
                    $result = array();
                    $temp_result = new stdClass();
                    $temp_result->data = $this->_field_value_list[$field->db_field_name.'_data'];
                    $temp_result->fid = $this->_field_value_list[$field->db_field_name.'_fid'];
                    $result[] = $temp_result;
                }else{
//                    var_dump($field); exit;
                    $query = " SELECT " . $field->db_field_name . "_data AS data, " . 
                    $field->db_field_name . "_fid AS fid FROM #__os_cck_content_entity_" . $this->fk_eid . 
                    " WHERE fk_eiid='" . $this->eiid . "' ";
                    $this->_db->setQuery($query);
                    $result = $this->_db->loadObjectList();
                    
                }
            }elseif ($field->field_type == 'locationfield'){
                if(isset($this->_field_value_list[$field->db_field_name.'_address'])){
                    $result = array();
                    $temp_result = new stdClass();
                    $temp_result->address = $this->_field_value_list[$field->db_field_name.'_address'];
                    $temp_result->vlat = $this->_field_value_list[$field->db_field_name.'_vlat'];
                    $temp_result->vlong = $this->_field_value_list[$field->db_field_name.'_vlong'];
                    $temp_result->zoom = $this->_field_value_list[$field->db_field_name.'_zoom'];
                    $temp_result->country = $this->_field_value_list[$field->db_field_name.'_country'];
                    $temp_result->region = $this->_field_value_list[$field->db_field_name.'_region'];
                    $temp_result->city = $this->_field_value_list[$field->db_field_name.'_city'];
                    $temp_result->zipcode = $this->_field_value_list[$field->db_field_name.'_zipcode'];
                    $result[] = $temp_result;
                }else{
                      $query = " SELECT ".$field->db_field_name . "_address AS address, ".
                          $field->db_field_name . "_vlat AS vlat, ".
                          $field->db_field_name . "_vlong AS vlong, ".
                          $field->db_field_name . "_zoom AS zoom, ".
                          $field->db_field_name . "_country AS country, ".
                          $field->db_field_name . "_region AS region, ".
                          $field->db_field_name . "_city AS city, ".
                          $field->db_field_name . "_zipcode AS zipcode".
                          " FROM #__os_cck_content_entity_" . $this->fk_eid . 
                          " WHERE fk_eiid='" . $this->eiid . "' ";
                      $this->_db->setQuery($query);
                      $result = $this->_db->loadObjectList();
                }
            }elseif ($field->field_type == 'galleryfield'){
                if(isset($this->_field_value_list[$field->db_field_name.'_data'])){
                    $result = array();
                    $temp_result = new stdClass();
                    $temp_result->data = $this->_field_value_list[$field->db_field_name.'_data'];
                    $temp_result->fid = $this->_field_value_list[$field->db_field_name.'_fid'];
                    $result[] = $temp_result;
                }else{
                      $query = " SELECT " . $field->db_field_name . "_data AS data, " . 
                        $field->db_field_name . "_fid AS fid FROM #__os_cck_content_entity_" . $this->fk_eid . 
                        " WHERE fk_eiid='" . $this->eiid . "' ";
                      $this->_db->setQuery($query);
                      $result = $this->_db->loadObjectList();
                }
            }elseif($field->field_type == 'pricefield_number' || $field->field_type == 'pricefield_select_list'
                    || $field->field_type == 'pricefield_radio_buttons'){
                $query = "SELECT * FROM #__os_cck_content_instances_price WHERE fk_fid='$field->fid' AND fk_eiid='$this->eiid' ORDER BY price_id ASC";
                $this->_db->setQuery($query);
                $result = $this->_db->loadObjectList();

            }else{
              if(isset($this->_field_value_list[$field->db_field_name])){
                  $result = array();
                  $temp_result = new stdClass();
                  $temp_result->data = $this->_field_value_list[$field->db_field_name];
                  $result[] = $temp_result;
              }else{
                  $query = " SELECT " . $this->_db->quoteName($field->db_field_name) . 
                    " AS data FROM #__os_cck_content_entity_" . $this->fk_eid . " WHERE fk_eiid='" . $this->eiid . "' ";
            //var_dump($field); exit;
                  $this->_db->setQuery($query);
                  $result = $this->_db->loadObjectList();
              }
            }
      }
      
    return $result;
  }

    function getFieldValueCalImport($field_name, $location = false){

    if($field_name == '-1' || !$this->eiid){
      $emptyObject = new stdClass();
      $emptyObject->data = '';
      return $emptyObject;
    }
    if ($location){
      $query = " SELECT ".$field_name . "_address AS address, ".
          $field_name . "_vlat AS vlat, ".
          $field_name . "_vlong AS vlong, ".
          $field_name . "_zoom AS zoom, ".
          $field_name . "_country AS country, ".
          $field_name . "_region AS region, ".
          $field_name . "_city AS city, ".
          $field_name . "_zipcode AS zipcode".
          " FROM #__os_cck_content_entity_" . $this->fk_eid . 
          " WHERE fk_eiid='" . $this->eiid . "' ";
      $this->_db->setQuery($query);
      $result = $this->_db->loadObject();
    }else{
      $query = " SELECT " . $this->_db->quoteName($field_name) . 
        " AS data FROM #__os_cck_content_entity_" . $this->fk_eid . " WHERE fk_eiid='" . $this->eiid . "' ";
      $this->_db->setQuery($query);
      $result = $this->_db->loadObject();
    }

    return $result;
  }

  function delete($oid = null){
      global $entityFieldLists;
      $k = $this->_tbl_key;
      if ($oid) {
        $this->$k = $oid;
      }
      // var_dump($this);
      $query = " DELETE FROM  #__os_cck_categories_connect WHERE fk_eiid='" . $this->eiid . "' ";
      $this->_db->setQuery($query);
      try {
          $this->_db->execute();
      } catch (RuntimeException $e) {
          echo $e->getMessage();
      }
//      $this->_db->execute();
//      echo $this->_db->getErrorMsg();
      foreach ($entityFieldLists[$this->fk_eid] as $field) {
        if ($field->field_type == 'filefield' || $field->field_type == 'imagefield'
            || $field->field_type == 'videofield' || $field->field_type == 'audiofield' 
            || $field->field_type == 'galleryfield') {
          $file = new os_cckFile($this->_db);
          $value = $this->getFieldValue($field);
          //var_dump($value);
          if($field->field_type == 'videofield'){
            foreach ($value as $video) {
                foreach ($video as $vid){
                
                  if(file_exists(JPATH_SITE . '/' . $vid->src))
                    unlink(JPATH_SITE . '/' . $vid->src);
                }
            }

          }
          if($field->field_type == 'audiofield'){
            foreach ($value as $audio) { 
              if(file_exists(JPATH_SITE . '/' . $audio->src))
                unlink(JPATH_SITE . '/' . $audio->src); 
            }
          }
          if($field->field_type == 'galleryfield'){
              $field->value = '';
              $this->deleteGalleryImage($field);
              
          }
          if($field->field_type == 'imagefield' || $field->field_type == 'filefield'){
            $query = "SELECT " . $field->db_field_name . "_fid FROM #__os_cck_content_entity_".$field->fk_eid." WHERE fk_eiid=".$this->eiid;
            $this->_db->setQuery($query);
            $image_fid = $this->_db->loadResult();

            $query = "DELETE FROM #__os_cck_files WHERE fid='{$image_fid}'";
            $this->_db->setQuery($query);
            try {
                $this->_db->execute();
            } catch (RuntimeException $e) {
                echo $e->getMessage();
            }
            // var_dump($image_fid);exit;
          }
          if($value[0]->fid != 0 ){
            $file->load($value[0]->fid);
            if($file->fid == null){
              $file->delete(null, $value[0]->fid);
            }else{
              $file->delete();  
            }
            
            
          }


        }
      }

//       print_r($this->eiid);
//       exit;

      $query = "DELETE FROM #__os_cck_content_entity_{$this->fk_eid} WHERE fk_eiid='{$this->eiid}'";
      $this->_db->setQuery($query);
      try {
          $this->_db->execute();
      } catch (RuntimeException $e) {
          echo $e->getMessage();
      }


      $query = "DELETE FROM #__os_cck_entity_instance WHERE eiid={$this->eiid}";
      $this->_db->setQuery($query);
      try {
          $this->_db->execute();
      } catch (RuntimeException $e) {
          echo $e->getMessage();
      }


      $query = "DELETE FROM #__os_cck_video_source WHERE  fk_eiid={$this->eiid}";
      $this->_db->setQuery($query);
      try {
          $this->_db->execute();
      } catch (RuntimeException $e) {
          echo $e->getMessage();
      }


      $query = "DELETE FROM #__os_cck_track_source WHERE  fk_eiid={$this->eiid}";
      $this->_db->setQuery($query);
      try {
          $this->_db->execute();
      } catch (RuntimeException $e) {
          echo $e->getMessage();
      }


      $query = "DELETE FROM #__os_cck_audio_source WHERE  fk_eiid={$this->eiid}";
      $this->_db->setQuery($query);
      try {
          $this->_db->execute();
      } catch (RuntimeException $e) {
          echo $e->getMessage();
      }

      
      //bch
      $query = "DELETE FROM #__os_cck_child_parent_connect WHERE fid_child = {$this->eiid}";
      $this->_db->setQuery($query);
      try {
          $this->_db->execute();
      } catch (RuntimeException $e) {
          echo $e->getMessage();
      }

      $query = "DELETE FROM #__os_cck_content_instances_price WHERE  fk_eiid={$this->eiid}";
      $this->_db->setQuery($query);
      try {
          $this->_db->execute();
      } catch (RuntimeException $e) {
          echo $e->getMessage();
      }


      return true;
  }

  function _is_filed_exist($field_name)
  {
      foreach ($this->getProperties() as $name => $value) {
          if ($name == $field_name) {
              return true;
          }
      }
      return false;
  }

  function _getFieldType($fieldName)
  {

      $query = 'SELECT f.field_type FROM #__os_cck_content_entity_field_instance as fi,  #__os_cck_content_entity_field as f ' .
          ' where fi.field_name = f.field_name and fi.entity_name = "' . $this->fk_eid . '" ' .
          ' and f.fieldName = "' . $fieldName . '"';
      $this->_db->setQuery($query);
      $tmp = (version_compare(JVERSION, "3.0.0", "lt")) ? $this->_db->loadResultArray() : $this->_db->loadColumn();
      if (count($tmp) == 0) {
          
          $app->enqueueMessage('Bad set field type in _build_table_filed_type - field type unknow.', 'warning');
          return false;
      }

      return $tmp->field_type;
  }

  function getFieldDetails($fieldName){
      //check exist fields with this name
      if (!$this->_is_filed_exist($fieldName)) {
          
          $app->enqueueMessage('The fields' . $fieldName . ' not exist for this entity.', 'warning');
          return false;
      }

      $query = "select * FROM #__os_cck_content_entity_field_instance " .
          " where  fieldName = '" . $fieldName . "' and entity_name = '" . $this->entity_name . "' ";
      $this->_db->setQuery($query);
      $os_cck_content_entity_field_instance = (version_compare(JVERSION, "3.0.0", "lt")) ? $this->_db->loadResultArray() : $this->_db->loadColumn();
      if (count($os_cck_content_entity_field_instance) == 0) {
          
          $app->enqueueMessage('The fields' . $fieldName . ' not defined for this entity .', 'warning');
          return false;
      }

      $query = 'SELECT f.* FROM #__os_cck_content_entity_field_instance as fi,  #__os_cck_content_entity_field as f ' .
          ' where fi.field_name = f.field_name and fi.entity_name = "' . $this->fk_eid . '" ' .
          ' and f.fieldName = "' . $fieldName . '"';
      $this->_db->setQuery($query);
      $os_cck_content_entity_field = (version_compare(JVERSION, "3.0.0", "lt")) ? $this->_db->loadResultArray() : $this->_db->loadColumn();
      if (count($os_cck_content_entity_field) == 0) {
          
          $app->enqueueMessage('The fields' . $fieldName . ' not defined for this entity .', 'warning');
          return false;
      }

      $os_cck_content_entity_field["global_settings"] = unserialize($os_cck_content_entity_field["global_settings"]);
      $os_cck_content_entity_field["db_columns"] = unserialize($os_cck_content_entity_field["db_columns"]);
      $os_cck_content_entity_field_instance["widget_settings"] =
          unserialize($os_cck_content_entity_field_instance["widget_settings"]);
      $os_cck_content_entity_field_instance["display_settings"] =
          unserialize($os_cck_content_entity_field_instance["display_settings"]);

      $tmp['os_cck_content_entity_field_instance'] = $os_cck_content_entity_field_instance;
      $tmp['os_cck_content_entity_field'] = $os_cck_content_entity_field;

      return $tmp;
  }

  function getAllLends($exclusion=""){

  	$this->_db->setQuery("SELECT id FROM #__os_cck_rent \n".
  						"WHERE fk_eiid='$this->eiid' " . $exclusion . " ORDER BY id");
  	if(version_compare(JVERSION, '3.0', 'lt')) {
  	  $tmp = $this->_db->loadResultArray();
  	} else {
  	  $tmp = $this->_db->loadColumn();
  	}

  	$retVal = array();
  	for($i = 0, $j = count($tmp); $i < $j; $i++ ){
  		$help = new mosCCK_rent($this->_db);
  		$help->load(intval($tmp[$i]));
  		$retVal[$i] = $help;
  	}
  	return $retVal;
  }

  function saveTracks($eiid, $src, $uploadTrackKind, $uploadTrackScrlang, $uploadTrackLabel) {    
    $location = '/components/com_os_cck/files/track/'.$src;
    if ($src != "" && !strstr($src, "http")) {
      $query = "INSERT INTO #__os_cck_track_source (fk_eiid,src,kind,scrlang,label)".
                "\n VALUE ($eiid,
                          '" . $location . "',
                          '" . $uploadTrackKind . "',
                          '" . $uploadTrackScrlang . "',
                          '" . $uploadTrackLabel . "')";
    }else{
      $query ="INSERT INTO #__os_cck_track_source (fk_eiid,src,kind,scrlang,label)".
              "\n VALUE ($eiid,
                        '" . $src."',
                        '" . $uploadTrackKind . "',
                        '" . $uploadTrackScrlang . "',
                        '" . $uploadTrackLabel . "')";
    }
    $this->_db->setQuery($query);
    $this->_db->execute();
  }


  function saveAudios($src, $eiid, $type) {


    $location = 'components/com_os_cck/files/audio/'.$src;

    if ($src != "" && strstr($src, "http")) {

      $query = "INSERT INTO #__os_cck_audio_source(fk_eiid,src,type) 
                VALUE($eiid,
                  " . $this->_db->quote($src) . ",
                  '" . $type . "')";
    }else{

      $db = JFactory::getDBO();
      $query ="INSERT INTO #__os_cck_audio_source(fk_eiid,src,type) 
                     VALUE($eiid,
                        " . $this->_db->quote($location) . ",
                        '" . $type . "')";
    }

    $this->_db->setQuery($query);
    $this->_db->execute();
  }



  function saveVideos($src, $eiid, $type, $fid) {
      
  $location = 'components/com_os_cck/files/video/'.$src;
  
  if ($src != "" && strstr($src, "http")) {
    $query = "INSERT INTO #__os_cck_video_source( fk_eiid, src, type, fk_fid)".
                                                "\n VALUE($eiid," . $this->_db->quote($src) . ", '" . $type . "', '" . $fid . "')";
  }else{
    $query = "INSERT INTO #__os_cck_video_source( fk_eiid,src,type, fk_fid)".
              "\n VALUE($eiid,
                      '".$location."',
                      '".$type."', '".$fid."')";
  }
  
  $this->_db->setQuery($query);
  
  $this->_db->execute();
  
  }



  function saveYouTubeCode($youtube_code, $eiid, $fid) {
    $this->_db->setQuery("SELECT id FROM #__os_cck_video_source 
                          WHERE youtube != '' 
                          AND fk_eiid = $eiid AND fk_fid = $fid");
    $this->_db->execute();
    $youtubeId = $this->_db->LoadResult();
  if ($youtube_code != '' && !empty($youtubeId)) {
    $query = "UPDATE #__os_cck_video_source".
              "\n SET youtube = '" . $youtube_code . "', ".
              "\n fk_fid = $fid".
              "\n WHERE id = $youtubeId";
  } else {
    $query = "INSERT INTO #__os_cck_video_source (fk_eiid,youtube,fk_fid)". 
              "\n VALUE($eiid,'" . $youtube_code . "', '" . $fid . "')";
  }
  $this->_db->setQuery($query);
  $this->_db->execute();
  }


  function checkMimeType($ext) {
    $this->_db->setQuery("SELECT mime_type FROM #__os_cck_mime_types WHERE mime_ext=".$this->_db->quote($ext));
    $type = $this->_db->loadResult();
    if(!$type)
      $type = 'unknown';
    return $type;
  }


  function filter($value) {
    $value = str_replace(array("/", "|", "\\", "?", ":", ";", "*", "#", "%", "$", "+", "=", ";", " "), "_", $value);
    return $value;
  }


  function guid() {
    if (function_exists('com_create_guid')) {
      return com_create_guid();
    } else {
      mt_srand((double)microtime() * 10000); //optional for php 4.2.0 and up.
      $charid = strtoupper(md5(uniqid(rand(), true)));
      $hyphen = chr(45); // "-"
      $uuid = //chr(123)// "{"
      substr($charid, 0, 8) . $hyphen . substr($charid, 8, 4) . $hyphen . substr($charid, 12, 4) . $hyphen . substr($charid, 16, 4) . $hyphen . substr($charid, 20, 12);
      //.chr(125);// "}"
      return $uuid;
    }
  }  


  function deleteTracks($eiid) {
    $this->_db->setQuery("SELECT id FROM #__os_cck_track_source where fk_eiid = $eiid;");
    $tdiles_id = $this->_db->loadColumn();
    $deleteTr_id = array();
    foreach($tdiles_id as $key => $value) {
      if (isset($_POST['track_option_del' . $value])) {
//        array_push($deleteTr_id, protectInjectionWithoutQuote('track_option_del' . $value, '', 'post'));
          array_push($deleteTr_id, $input->get('track_option_del' . $value, ''));
      }
    }
    if ($deleteTr_id) {
      $del_tid = implode(',', $deleteTr_id);
      $sql = "SELECT src FROM #__os_cck_track_source WHERE id IN (" .$del_tid . ")";
      $this->_db->setQuery($sql);
      $tracks = $this->_db->loadColumn();
      if ($tracks) {
        foreach($tracks as $name) {
          if (substr($name, 0, 4) != "http") unlink(JPATH_SITE . $name);
        }
      }
      $sql = "DELETE FROM #__os_cck_track_source WHERE (id IN (" . $del_tid . ")) 
              AND (fk_eiid = $eiid)";
      $this->_db->setQuery($sql);
      $this->_db->execute();
    }
  }

  function deleteAudios($eiid, $removeaudio = 0) {
    $this->_db->setQuery("SELECT id FROM #__os_cck_audio_source where fk_eiid = $eiid;");
    $adiles_id = $this->_db->loadColumn();
    $deleteAud_id = array();
    if ($removeaudio) {
      $deleteAud_id = $adiles_id;
    } else {
      foreach($adiles_id as $key => $value) {
        if (isset($_POST['audio_option_del' . $value])) {
          //array_push($deleteAud_id, protectInjectionWithoutQuote('audio_option_del' . $value, '', 'post'));
            array_push($deleteAud_id, $input->get('audio_option_del' . $value, ''));
        }
      }
    }
    if (isset($deleteAud_id['0']) && $deleteAud_id['0']) {
      $del_id = "";
      $sql = "SELECT src FROM #__os_cck_audio_source WHERE id IN (";
      foreach($deleteAud_id as $aid_id) $del_id.= $aid_id . ",";
      $sql.= $del_id . "0)";
      $this->_db->setQuery($sql);
      $audios = $this->_db->loadColumn();
      if ($audios) {
        foreach($audios as $name) {
          if (substr($name, 0, 4) != "http") unlink(JPATH_SITE . '/' . $name);
        }
      }
      $sql = "DELETE FROM #__os_cck_audio_source WHERE (id IN (" . $del_id . "0)) and (fk_eiid=$eiid)";
      $this->_db->setQuery($sql);
      $this->_db->execute();
    }
  }

    function deleteVideos($eiid) {
        global $input;
        $this->_db->setQuery("SELECT id, fk_fid FROM #__os_cck_video_source where fk_eiid = $eiid;");
        $vdiles_id = $this->_db->loadObjectList();
        $deleteVid_id = array();

        foreach($vdiles_id as $key => $value) {
            if (isset($_POST[$value->fk_fid.'_video_option_del' . $value->id])) {
                //array_push($deleteVid_id, protectInjectionWithoutQuote('video_option_del' . $value, '', 'post'));
                array_push($deleteVid_id, $input->get($value->fk_fid.'_video_option_del' . $value->id, ''));
            }
        }

        if ($deleteVid_id) {
            $del_id = implode(',', $deleteVid_id);
            $sql = "SELECT src FROM #__os_cck_video_source WHERE id IN (". $del_id . ")";
            $this->_db->setQuery($sql);
            $videos = $this->_db->loadColumn();
            if ($videos) {
                foreach($videos as $name) {

                    if (substr($name, 0, 4) != "http" && file_exists(JPATH_SITE . '/' . $name))
                        unlink(JPATH_SITE . '/' . $name);
                }
            }
            $sql = "DELETE FROM #__os_cck_video_source 
              WHERE (id IN (" . $del_id . ")) 
              AND (fk_eiid=$eiid)";
            $this->_db->setQuery($sql);
            $this->_db->execute();
        }
        $this->_db->setQuery("SELECT id FROM #__os_cck_video_source where fk_eiid = $eiid AND youtube IS NOT NULL;");
        $youtubeid = $this->_db->loadResult();
        if (!empty($youtubeid)) {
            if (isset($_POST['youtube_option_del' . $youtubeid])) {
                $y_t_id = intval(mosGetParam($_REQUEST, 'youtube_option_del' . $youtubeid, ''));
                $sql = "DELETE FROM #__os_cck_video_source 
                WHERE id = $y_t_id 
                AND fk_eiid=$eiid";
                $this->_db->setQuery($sql);
                $this->_db->execute();
            }
        }
    }

  function accept(){
    global $my, $os_cck_configuration, $entityFieldLists, $app;
    if ($this->eiid == null) {
      return "Method called on a non instant object";
    }
    


    $child_instance = new os_cckEntityInstance($this->_db);
    $child_instance->load($this->child_id);
//    var_dump($child_instance); exit;
    unset($child_instance->child_id);
    $fields_list = $entityFieldLists[$child_instance->fk_eid];
    
    $assoc_instance = unserialize($this->associate_instances);

    if(empty($assoc_instance)){
        $assoc_instance[] = $this->eiid; 
    }
    
    foreach($assoc_instance as $eiid){
        $rent = new mosCCK_rent($this->_db);
        $rent->fk_userid = $this->fk_userid;
        $query = "SELECT name, email FROM #__users WHERE id=$this->fk_userid";
        $this->_db->setQuery($query);
        $user = $this->_db->loadObjectList();
        if($user){
          $rent->user_name = $user[0]->name;
          $rent->user_email = $user[0]->email;
        }
        $rent->request_id = $this->child_id;
        $layout = new os_cckLayout($this->_db);
        $layout->load($child_instance->fk_lid);
        $fields_from_params = unserialize($layout->params);

        foreach ($fields_list as $value) {
          if($value->field_type == 'datetime_popup'){
              if($fields_from_params['fields'][$value->db_field_name."_field_type"] == "rent_from"){
                  $rent_from = $child_instance->getFieldValue($value);
              }

              if($fields_from_params['fields'][$value->db_field_name."_field_type"] == "rent_to"){
                  $rent_to = $child_instance->getFieldValue($value);
              }
          }
        }

        $rent->rent_from = $rent_from[0]->data; // date("Y-m-d H:i:s");
        $rent->rent_until = $rent_to[0]->data;
        //lend check start
        $rent->fk_eiid = $eiid;
        $rent->checked_out_time = date('Y-m-d H:m:s');
        $query = "SELECT * FROM #__os_cck_rent WHERE fk_eiid = " . $eiid .
            " AND rent_return IS NULL ";
        $this->_db->setQuery($query);
        $lendTerm = $this->_db->loadObjectList();

        $lend_from = $rent->rent_from;
        $lend_until = $rent->rent_until;

        if (isset($lendTerm[0])) {
          for ($e = 0, $m = count($lendTerm); $e < $m; $e++) {
              $returnMessage = checkRentCCK($lendTerm[$e]->rent_from, $lendTerm[$e]->rent_until, $lend_from, $lend_until);
            //rent check
              if(!$app->isClient('site') && $returnMessage !== NULL){
                return $returnMessage;
              }
              if($returnMessage !== NULL){
                  echo "<script> alert('" . $returnMessage . " '); window.history.go(-1); </script>\n";
                exit ();
              }
          }
        }
        
        //if end(end lend check)
        if (!$rent->store()) {
            
          return $rent->getError();
        }
        
        
    }

    if (!$child_instance->publish($child_instance->eiid, 0)) {
      return $child_instance->getError();
    }

    return null;
  }

  function decline(){
    if ($this->eiid == null) {
      return "Method called on a non instant object";
    }
      $query = "SELECT * FROM #__os_cck_orders WHERE fk_request_id = ".$this->eiid."";
      $this->_db->setQuery($query);
      $order = $this->_db->loadObjectList();
      
      if(!empty($order)){
          foreach ($order as $o){
              
              $query = "DELETE FROM #__os_cck_orders_details WHERE fk_order_id=$o->id";
              $this->_db->setQuery($query);
              $this->_db->execute();

              $query = "DELETE FROM #__os_cck_orders WHERE id=$o->id";
              $this->_db->setQuery($query);
              $this->_db->execute();
              
              $query = "DELETE FROM #__os_cck_orders_price WHERE fk_order_id=$o->id";
              $this->_db->setQuery($query);
              $this->_db->execute();

          }
      }
    if (!$this->delete()) {
      return $this->getError();
    }
    return null;
  }
  
  function getInstanciesListLang($lang){
      $query = "SELECT eiid, title FROM #__os_cck_entity_instance WHERE language='$lang' AND fk_eid='$this->fk_eid'";
      $this->_db->setQuery($query);
      $result = $this->_db->loadObjectList();
      return $result;
  }
  
  

}


