<?php
defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2016 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

class mosOS_CCK extends JTable
{

    //keys
    /** @var int Primary key */
    var $id = null;
    /** @var int */
    var $itemid = null;
    /** @var int */
    var $sid = null;
    /** @var int */
    var $fk_rentid = null;

    //Required fields
    /** @var varchar(250) */
    var $description = null;
    /** @var varchar(14) */
    var $price = null;
    /** @var varchar(250) */
    var $SKU = null;
    /** @var varchar(200) */
    var $quantity = null;

    /** @var boolean */
    var $checked_out = null;
    /** @var time */
    var $checked_out_time = null;

    /** @var datetime */
    var $date = null;
    /** @var int */
    var $published = null;
    /** @var int */
    var $hits = null;
    /** @var varchar(200) */
    var $edok_link = null;
    /** @var int */
    var $ordering = null;
    /** @var varchar(250) */
    var $title = null;
    /** @var varchar(250) */
    var $image = null;
    /** @var int */
    var $letout_current = null;
    /** @var tinyint */
    var $letout_flag = null;

    /**
     * @param database - A database connector object
     */
    function __construct(&$db)
    {
        $this->mosDBTable('#__os_cck_items', 'id', $db);
    }

    function quoteName($name)
    {
        if (version_compare(JVERSION, "3.0.0", "lt")) {
            $return = $this->_db->NameQuote($name);
        } else {
            $return = $this->_db->quoteName($name);
        }
        return $return;
    }

    // overloaded check function
    function check()
    {

        global $os_cck_configuration;

        // check for existing itemid
        $this->_db->setQuery("SELECT id FROM #__os_cck_items "
        . "\nWHERE itemid='$this->itemid'");
        $xid = intval($this->_db->loadResult());
        if ($xid && $xid != intval($this->id)) {
            $this->_error = JText::_("COM_OS_CCK_ADMIN_INFOTEXT_JS_EDIT_ITEMID");
            return false;
        }
        return true;
    }

    function check_sku()
    {
        //checking for existing sku
        $this->_db->setQuery("SELECT itemid FROM #__os_cck_items WHERE SKU='$this->SKU'");
        $xsku = intval($this->_db->loadResult());
        if ($xsku && $xsku != intval($this->itemid)) {
            $this->_error = JText::_("COM_OS_CCK_ADMIN_INFOTEXT_JS_EDIT_SKU_EXIST");
            return false;
        }
        return true;
    }

    function getReviews()
    {
        $this->_db->setQuery("SELECT id FROM #__os_cck_review \n" .
        "WHERE fk_itemid='$this->id' ORDER BY id");
        $tmp = (version_compare(JVERSION, "3.0.0", "lt")) ? $this->_db->loadResultArray() : $this->_db->loadColumn();
        $retVal = array();
        for ($i = 0, $j = count($tmp); $i < $j; $i++) {
            $help = new mosOS_CCK_review($this->_db);
            $help->load(intval($tmp[$i]));
            $retVal[$i] = $help;
        }
        return $retVal;
    }

    function getRent()
    {
        $rent = null;
        if ($this->fk_rentid != null && $this->fk_rentid != 0) {
            $rent = new mosOS_CCK_rent($this->_db);
            // load the row from the db table
            $rent->load(intval($this->fk_rentid));
        }
        return $rent;
    }

    function getAllRents($exclusion = "")
    {
        $this->_db->setQuery("SELECT id FROM #__os_cck_rent \n" .
        "WHERE fk_itemid='$this->itemid' " . $exclusion . " ORDER BY fk_itemid");
        $tmp = (version_compare(JVERSION, "3.0.0", "lt")) ? $this->_db->loadResultArray() : $this->_db->loadColumn();
        $retVal = array();
        for ($i = 0, $j = count($tmp); $i < $j; $i++) {
            $help = new mosOS_CCK_rent($this->_db);
            $help->load(intval($tmp[$i]));
            $retVal[$i] = $help;
        }
        return $retVal;
    }

    function getAllRentRequests($exclusion = "")
    {
        $this->_db->setQuery("SELECT id FROM #__os_cck_rent_request \n" .
        "WHERE fk_itemid='$this->id'" . $exclusion . " ORDER BY id");
        $tmp = (version_compare(JVERSION, "3.0.0", "lt")) ? $this->_db->loadResultArray() : $this->_db->loadColumn();
        $retVal = array();
        for ($i = 0, $j = count($tmp); $i < $j; $i++) {
            $help = new mosOS_CCK_rent_request($this->_db);
            $help->load(intval($tmp[$i]));
            $retVal[$i] = $help;
        }
        return $retVal;
    }

    function getAllBuyingRequests($exclusion = "")
    {
        $this->_db->setQuery("SELECT id FROM #__os_cck_buying_request \n" .
        "WHERE fk_itemid='$this->id'" . $exclusion . " ORDER BY id");
        $tmp = (version_compare(JVERSION, "3.0.0", "lt")) ? $this->_db->loadResultArray() : $this->_db->loadColumn();
        $retVal = array();
        for ($i = 0, $j = count($tmp); $i < $j; $i++) {
            $help = new mosOS_CCK_buying_request($this->_db);
            $help->load(intval($tmp[$i]));
            $retVal[$i] = $help;
        }
        return $retVal;
    }

    function getAllImages($exclusion = "")
    {
        $retVal = array();

        return $retVal;
    }
    

}

?>
