<?php
defined('_JEXEC') or die('Restricted access');
/**
* @package OS CCK
* @copyright 2025 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

class AdminViewBuy_request{
  static function showBuyRequestInstances($option, & $rows_item, & $clist,
                                & $publist, & $search, & $pageNav, & $sort_arr, $show_fields,$entity_list,$request_instansies_array, $request_prices)
  {
      global $doc, $user, $app, $session,$db, $entityFieldLists;
      $db = new os_cckDb();
      $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . cck_lang_text('COM_OS_CCK_ADMIN_LABLE_ORDER') . "</div>";
      $app = JFactory::getApplication();
      $app->JComponentTitle = $html;
      $onclick = "Joomla.checkAll(this);";


      $table = new os_cckViewTable('adminForm', 'adminForm', '', 'index.php?option=com_os_cck&task=show_buy_request_instances', 'show_buy_request_instances');

      $table->create_button('Accept request', 'accept_buying_requests', JURI::root() . 'components/com_os_cck/images/btn_d.png', 'fa-check');
      $table->create_button('Decline request', 'decline_buying_requests', JURI::root() . 'components/com_os_cck/images/published.png', 'fa-close');
      $table->create_button('Delete', 'delite_buying_requests', JURI::root() . 'components/com_os_cck/images/btn_d.png', 'fa-close');
      $table->create_button('Mark as viewed', 'is_readed', JURI::root() . 'components/com_os_cck/images/published.png', 'fa-check');
      
      $table->create_filters('<div class="search_block"><input type="text" placeholder="'.cck_lang_text('COM_OS_CCK_SHOW_SEARCH').'" name="search" value="'.$search.'" class="inputbox" onChange="document.adminForm.submit();"/><button type="submit" class="cck_search_button" title="" data-original-title="Search"><span class="icon-search"></span></button></div>');
      $table->create_filters('<div>'.$clist.'</div>');
      $table->create_filters('<div>'.$entity_list.'</div>');
      $table->create_filters('<div>'.$publist.'</div>');
      
      
      $table->title_class = 'admin-request-title';
      $table->first_row_custom_class = 'admin-request-standart-fields';
      $table->limitbox = '<div class="btn-group pull-right hidden-phone">
      <label for="limit" class="element-invisible">'. cck_lang_text('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC') .'</label>'. $pageNav->getLimitBox() .'</div>';


      $table->create_first_row_collumn(JHtml::_('grid.checkall'), '', 'admin-order-title-checkbox');  
      $table->create_first_row_collumn(HTML_os_cck::sort_head(cck_lang_text('COM_OS_CCK_LABEL_INSTANCE_ID'), 'inst_id', $sort_arr,protectInjectionWithoutQuote('task')), '', 'admin-order-title-id');   
      foreach($show_fields as $value){
        foreach($value as $field){
          
          $table->create_first_row_collumn(HTML_os_cck::sort_head($field->field_name, $field->db_field_name, $sort_arr,protectInjectionWithoutQuote('task')), '', 'admin-order-title-email');   
                    
        }
      }
      $table->create_first_row_collumn(HTML_os_cck::sort_head(cck_lang_text('COM_OS_CCK_BUY_DATE'), 'created', $sort_arr,protectInjectionWithoutQuote('task')), '', 'admin-order-title-email');   
      $table->create_first_row_collumn(HTML_os_cck::sort_head(cck_lang_text('COM_OS_CCK_REQUEST_ENTITY'), 'entity', $sort_arr,protectInjectionWithoutQuote('task')), '', 'admin-order-title-date');

      $table->create_second_row_collumn('Title');

      for($i = 0; $i < count($rows_item); $i++) { 
        // var_dump($rows_item[$i]);
        $parentInstance = new os_cckEntityInstance($db->_db);
        $parentInstance->load($rows_item[$i]->fid_parent);
        
        $show_in_orders_fields = array();
                
        if(isset($entityFieldLists[$parentInstance->fk_eid])){
          $fields = $entityFieldLists[$parentInstance->fk_eid];
        }else{
          $fields = array();
        }
        foreach($fields as $field){
            $params = new JRegistry;
            $params->loadString($field->params);
            if($params->get('show_in_requests', '') == 'yes'){
                $show_in_orders_fields[] = $field;
            }
        }

        $table->create_second_row_collumn('Title');
        $table->create_second_row_collumn('Price');
        
        foreach($show_in_orders_fields as $order_fields){
            $table->create_second_row_collumn($order_fields->field_name);
        }
      }
      // var_dump($rows_item);
      for($i = 0; $i < count($rows_item); $i++) { 
        $request_instancies = $request_instansies_array[$rows_item[$i]->eiid];
        // var_dump($request_instancies);
        $request_data = array();
        $data_second_row = array();
        
        $row = $rows_item[$i];

        if ($row->checked_out && $row->checked_out != $user->id) {
          $request_data[] = '';
        
        } else {
          $request_data[] =  JHTML::_('grid.id',$i, $rows_item[$i]->eiid, ($rows_item[$i]->checked_out && $rows_item[$i]->checked_out != $user->id), 'eiid');
        }
        $request_data[] = '<a href="#show_request_item" onClick="return cckSendForm(\'cb'.$i.'\',\'edit_buy_request_instance\', \'\')">'.$row->eiid.'</a>';

        foreach($show_fields as $key => $value){
          foreach($value as $field){
            $html = '';
            if($rows_item[$i]->fk_eid != $key){
              $request_data[] = '<div class="admin-order-standart-fields-email"></div>';
              continue;
            }
            if($field->field_type == 'categoryfield'){
              $request_data[] = "<div class='admin-order-standart-fields-email'>$rows_item[$i]->category</div>";
              continue;
            }
            ?>
            
              <?php
              $entityInstance = new os_cckEntityInstance($db->_db);
              $entityInstance->load($rows_item[$i]->eiid);
              $value = $entityInstance->getFieldValue($field);
              

              $html .= '<div><span class="col_box" style="display:block;'.($field->field_type=='imagefield'  && isset($field->options['width']) && isset($field->options['height']))? 'width:'.$field->options['width'].'px; height:'.$field->options['height'].'px;':''.'">';
                  
              ob_start();
                require getSiteShowFiledViewPath('com_os_cck', $field->field_type);
                $html .= ob_get_contents();
              ob_end_clean();
              $html .= '</span></div>';
              $request_data[] = $html;
                     
          }
        }
        $request_data[] = $rows_item[$i]->created;
        $request_data[] = $rows_item[$i]->entity;

        $class = 'row' . ($i % 2) . ' ';
        if($rows_item[$i]->notreaded === 1){
            $class .= ' admin-order-not-readed';
        }
        
        $table->create_first_row_data($request_data, $class);

        foreach($request_instancies as $inst_id => $request_instance){
          $data_second_row[$inst_id] = array();
          $parentInstance = new os_cckEntityInstance($db->_db);
          $parentInstance->load($request_instance);
          
          $show_in_orders_fields = array();
                  
          if(isset($entityFieldLists[$parentInstance->fk_eid])){
            $fields = $entityFieldLists[$parentInstance->fk_eid];
          }else{
            $fields = array();
          }
          foreach($fields as $field){
              $params = new JRegistry;
              $params->loadString($field->params);
              if($params->get('show_in_requests', '') == 'yes'){
                  $show_in_orders_fields[] = $field;
              }
          }

          
          $data_second_row[$inst_id][] = $parentInstance->title;

          $calculated_price = 0;
          $quantity = 1;
          $not_calc_price = '';
          $coupon = false;
            //  var_dump($order_prices);
          foreach ($request_prices[$rows_item[$i]->eiid] as $key => $single_field){
//                            var_dump($single_field);
              if($single_field->price_ordering == -1){
                  $field = new os_cckEntityField($db->_db);
                  $field->load($single_field->fk_fid);

                  unset($request_prices[$rows_item[$i]->eiid][$key]);
              }
          }
          
          
          foreach ($request_prices[$rows_item[$i]->eiid] as $single_field){
              // if($single_field->сart_item == $cart_item){
                  $field = new os_cckEntityField($db->_db);
                  $field->load($single_field->fk_fid); 

                  if($single_field->price_type == 'base_price'){
                        if($single_field->quantity == 0) $single_field->quantity =1;
                        if($single_field->quantity>1) {$quantity = $single_field->quantity;}
                        $calculated_price = $calculated_price + ($single_field->price_value * $single_field->quantity);
                  }elseif($single_field->price_type == 'val+' && $single_field->price_value != '0.00'){
                        $calculated_price = $calculated_price + ($single_field->price_value * $quantity);
                    }else if($single_field->price_type == 'val-' && $single_field->price_value != '0.00'){
                        $calculated_price = $calculated_price - ($single_field->price_value * $quantity);
                    }else if($single_field->price_type == 'percent+' && $single_field->price_value != '0.00'){
                        $calculated_price = $calculated_price + (round($calculated_price/100 * $single_field->price_value, 2));
                    }else if($single_field->price_type == 'percent-' && $single_field->price_value != '0.00'){
                        $calculated_price = $calculated_price - (round($calculated_price/100 * $single_field->price_value, 2));
                    }
              // }

              //var_dump($single_field);
          }
          
          $calculated_price = calculatedCurrency($parentInstance, $calculated_price)[0];

          $data_second_row[$inst_id][] = $calculated_price;
          // var_dump($show_in_orders_fields);
          foreach ($show_in_orders_fields as $field){
            // var_dump($field);
              $value = $parentInstance->getFieldValue($field);
              if(isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data') && $value[0]->data == ''){
                  continue;
              }elseif($field->field_type == 'datetime_popup' && isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data') && $value[0]->data == '0000-00-00 00:00:00'){
                  continue;
              }
              $print_value = '';
              if($field->field_type == 'text_select_list'){
                  $value = (isset($value[0]->data))?$value[0]->data : '';
                  $value = json_decode($value);
                  $params = new JRegistry;
                  $params->loadString($field->params);
                  $allowed_values = $params->get("allowed_value");
                  $allowed_values = explode('\sprt', $allowed_values);
                  $tmp_val = array();

                  if(is_array($value)){

                      foreach($value as $val){

                          if(isset($allowed_values[$val])){
                              $tmp_val[] = cck_lang_text($allowed_values[$val]);
                          }
                      }
                  }

                  $print_value = implode(', ', $tmp_val);
                  
  //                                $temp_val = json_decode($value[0]->data);
  //                                if(is_array($temp_val)){
  //                                    $temp_val = implode(', ', $temp_val);
  //                                    $print_value = $temp_val;
  //                                }
  //                                var_dump(json_decode($value[0]->data));
              }elseif(stripos($field->field_type, 'pricepfield') !== false){
                  
                  continue;
              }elseif(isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data')){
                  $print_value = $value[0]->data;
              }

              
              $data_second_row[$inst_id][] = $print_value;
              // var_dump(array($data_second_row));
              
  //         
            }                   
        }
        // var_dump($data_second_row);
        $table->create_second_row_data($data_second_row);
        

         }

         $table->paginator = $pageNav->getListFooter();

        // $buttons = new adminHeaderButton();
        
        echo $table->viewTable();

  }

  static function editBuyRequestInstance($option, & $entityInstance, & $str_list, $price_fields, $parent_price_fields, $recursive){
    global $os_cck_configuration,$user, $app, $session, $db;
    $db = new os_cckDb();
    $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . cck_lang_text('COM_OS_CCK_ADMIN_LABLE_ORDER') . "</div>";
    $app = JFactory::getApplication();
    $app->JComponentTitle = $html;
    $doc = JFactory::getDocument();
    $doc->addStyleSheet(JURI::root()."components/com_os_cck/assets/css/jquerOs-ui.min.css");
    $doc->addStyleSheet(JURI::root()."components/com_os_cck/assets/css/admin_style.css");
    
    $doc->addScript(JUri::root().'components/com_os_cck/assets/js/jquery.raty.js');
    
    $doc->addScript(JURI::root()."components/com_os_cck/assets/js/jquerOs-ui.min.js");
    
    $doc->addStyleSheet( JUri::root().'/components/com_os_cck/assets/lightbox/css/lightbox.css');
    $doc->addScriptDeclaration('jQuerOs=jQuerOs.noConflict();');
    $doc->addScript(JURI::root() . '/components/com_os_cck/assets/lightbox/js/lightbox-2.6.min.js');
//    $key = 'key='.$os_cck_configuration->get("google_map_key",'');
//    $doc->addScript('//maps.googlea pis.com/maps/api/js?'.$key);
    if($recursive == 1){
        $table = new os_cckViewTable('adminForm', 'adminForm', 'add_entity_form wrapper_add_entity', 'index.php', '');
        $table->create_button(cck_lang_text('COM_OS_CCK_TOOLBAR_ADMIN_ACCEPT'), 'accept_buying_requests', '', 'fa-check', '', false);
        $table->create_button(cck_lang_text('COM_OS_CCK_TOOLBAR_ADMIN_DECLINE'), 'decline_buying_requests', '', 'fa-close', '', false);
        $table->create_button('Back', 'cancel_buying_request', '', 'fa-chevron-left', '', false);
        $table_html = '';

        ob_start();
    }
    if(empty($str_list['parent_instance'])){
      $div_id = 'parent_instance';
    }else{
      $div_id = 'child_instance';
      foreach ($price_fields as $price_field){
          
          $instance = new os_cckEntityInstance($db->_db);
          $instance->load($price_field[0]->fk_eiid);
          if($instance->meta_title == ''){
              
              $layout = new os_cckLayout($db->_db);
              $lid = $layout->getDefaultLayout($instance->fk_eid, 'instance');

              $sql = "SELECT params FROM #__os_cck_layout
                           \nWHERE lid =".intval($lid);

              $db->setQuery($sql);
              $params = $db->loadResult();
              $params = unserialize($params);

              //get all fields
              $sql =  "SHOW columns FROM #__os_cck_content_entity_" . $instance->fk_eid;
              //var_dump($sql); exit;
              $db->setQuery($sql);
              $cols = $db->loadColumn();

//              foreach ($params['fields'] as $key => $field){
//                  var_dump($key);
//                  var_dump($field);
//              }
              //search Title field if exists
              for($k=0;$k<count($cols);$k++){
                if(isset($params['fields'][$cols[$k].'_title_field']) && $params['fields'][$cols[$k].'_title_field'] == 1){
                    $title_field = $cols[$k];
                }
              }
              
              if(!empty($title_field)){

                $sql = "SELECT fk_eiid AS id, ".$title_field." AS title_field FROM #__os_cck_content_entity_".$instance->fk_eid."

                         \nWHERE fk_eiid=".intval($instance->eiid);
                $db->setQuery($sql);
                $row = $db->loadObject();

                if(isset($row) && $row) {
                  $instance->meta_title = $row->title_field;
                }
              }
              $instance->meta_title = getInstanceTitle($instance);

          }
          
          echo '<div class="single_product"><div class="product_title">'.$instance->meta_title.'</div>';
          $price_detail_html = '<div class="price_detail">';
          $calculated_price = 0;
          $quantity = 1;
          $not_calc_price = '';
          $coupon = false;
          foreach ($price_field as $key => $single_field){
              if($single_field->price_ordering == -1){
                  $field = new os_cckEntityField($db->_db);
                  $field->load($single_field->fk_fid);

                  if($single_field->price_name == $single_field->price_value) {
                      $price_name = $field->field_name;
                  }else{
                      $price_name = $field->field_name . ': ' . $single_field->price_name;
                  }
                  $calculated_currency = calculatedCurrency($instance, $single_field->price_value);
                  $not_calc_price .= '<div class="not_calculated_price">' . $price_name . ' ' . $calculated_currency[0] . '</div>';
                  unset($price_field[$key]);
              }elseif($single_field->price_type == 'coupon'){
                $coupon = $single_field;
              }
          }
          if($coupon){
                $coup_id = $coupon->fk_price_id;
                $coupon = new os_cckCoupons($db->_db);
                $coupon->load($coup_id);
            }
          if($not_calc_price != ''){
              echo '<div class="not_calculated_field_label">Not Calculated Fields</div>';
              echo '<div class="not_calculated_fields">' . $not_calc_price . '</div>';
//                    var_dump($not_calc_price);
              echo '<div class="calculated_field_label">Calculated Fields</div>';
          }

          foreach ($price_field as $single_field){
              $field = new os_cckEntityField($db->_db);
              $field->load($single_field->fk_fid); 
              if($single_field->price_value == $single_field->price_name){
                  $name = '';
              }else{
                  $name = $single_field->price_name;
              }
              if($single_field->price_type == 'base_price'){
                    if($single_field->quantity == 0) $single_field->quantity =1;
                    $calculated_currency = calculatedCurrency($instance, ($single_field->price_value * $single_field->quantity));
                    $not_quantity_calculated_currency = calculatedCurrency($instance, $single_field->price_value);
                    $tmp_price_quant = ($single_field->quantity>1) ? '(' . $not_quantity_calculated_currency[1] . ' x ' . $single_field->quantity . ')' : '';
                    if($single_field->quantity>1) {$quantity = $single_field->quantity;}
                    $price_detail_html .= '<div class="bace_price">' . $field->field_name .  ' ' . $name. ' '  . $calculated_currency[0] . ' ' . $tmp_price_quant . '</div>';
                    $calculated_price = $calculated_price + ($single_field->price_value * $single_field->quantity);
              }elseif($single_field->price_type == 'val+' && $single_field->price_value != '0.00'){
                    $calculated_currency = calculatedCurrency($instance, ($single_field->price_value * $quantity));
                    $not_quantity_calculated_currency = calculatedCurrency($instance, $single_field->price_value);
                    $price_name = $field->field_name . ': ' . $single_field->price_name;
                    $tmp_price_quant = ($quantity>1) ? '(' . $not_quantity_calculated_currency[1] . ' x ' . $quantity . ')' : '';
                    $price_detail_html .= '<div class="val+">'.$price_name.' ' . $name.' +' . $calculated_currency[0] . ' ' . $tmp_price_quant . '</div>';
                    $calculated_price = $calculated_price + ($single_field->price_value * $quantity);
                }else if($single_field->price_type == 'val-' && $single_field->price_value != '0.00'){
                    $calculated_currency = calculatedCurrency($instance, ($single_field->price_value * $quantity));
                    $price_name = $field->field_name . ': ' . $single_field->price_name;
                    $not_quantity_calculated_currency = calculatedCurrency($entityInstance, $field->value);
                    $tmp_price_quant = ($quantity>1) ? '(' . $not_quantity_calculated_currency[1] . ' x ' . $quantity . ')' : '';
                    $price_detail_html .= '<div class="val-">'.$price_name.' ' . $name.' -' . $calculated_currency[0] . ' ' . $tmp_price_quant . ' </div>';
                    $calculated_price = $calculated_price - ($single_field->price_value * $quantity);
                }else if($single_field->price_type == 'percent+' && $single_field->price_value != '0.00'){
                    $calculated_currency = calculatedCurrency($instance, ($single_field->price_value * $quantity));
                    $calculate_value = calculatedCurrency($instance, round($calculated_price/100 * $single_field->price_value, 2));
                    $price_name = $field->field_name . ': ' . $single_field->price_name;
                    $price_detail_html .= '<div class="percent+">' . $price_name . ' +' . $calculate_value[0] . ' ('. $single_field->price_value . ' %) </div>';
                    $calculated_price = $calculated_price + (round($calculated_price/100 * $single_field->price_value, 2));
                }else if($single_field->price_type == 'percent-' && $single_field->price_value != '0.00'){
                    $price_name = $field->field_name . ': ' . $single_field->price_name;
                    $calculated_currency = calculatedCurrency($instance, ($single_field->price_value * $quantity));
                    $calculate_value = calculatedCurrency($instance, round($calculated_price/100 * $single_field->price_value, 2));
                    $price_detail_html .= '<div class="percent-">' . $price_name . ' -' . $calculate_value[0] . ' ('. $single_field->price_value . ' %)</div>';
                    $calculated_price = $calculated_price - (round($calculated_price/100 * $single_field->price_value, 2));
                }
              
              
              //var_dump($single_field);
          }
          echo $price_detail_html . '</div>';
          echo '<div>Total cost of goods: ' . calculatedCurrency($instance, $calculated_price)[0] . '</div></div><br>';
          if($coupon){
                echo '<div>Coupon: ' . $coupon->name . ' ';
                if($coupon->type == 'percent'){
                    echo '-'.$coupon->value.'%</div>';
                }else{
                    echo '-'.calculatedCurrency($instance, $coupon->value)[0].'</div>';
                }
            }
      }
      echo '<span class="buy-total-price">';
      echo 'Total Price: '.$entityInstance->instance_price.' '.$entityInstance->instance_currency;
      echo '</span>';
    }?>
    <div id="<?php echo $div_id; ?>">
      <?php
      $layout_params = $str_list['layout_params'];
      $layout = $str_list['layout'];
      $bootstrap_version = $session->get( 'bootstrap','2');
      $layout->layout_html = $layout->getLayoutHtml($bootstrap_version);
      $layout_html = urldecode($layout->layout_html);
      $field_from_params = $layout_params["fields"];
      $fields_list = $str_list['extra_fields_list'];

      //add child selects to layout
      $addChildSelectToLayout = addChildSelectToLayout($fields_list, $entityInstance, $layout_params, $layout_html, $layout);
      $layout_html = $addChildSelectToLayout['layout_html'];
      $layout_params = $addChildSelectToLayout['layout_params'];
      $parent = $addChildSelectToLayout['select_parent'];
      $layout->params = serialize($layout_params);
      //add child selects to layout
      $hover_animated = array();
      $moduleId = 0;
      $Itemid = 0;
      $layout_params['custom_fields'] = unserialize($layout->custom_fields);
      
      $child_entities = (isset($layout_params['child_entities'])) ? $layout_params['child_entities'] : '';
      $layout_html = $layout->getLayoutViews($entityInstance, $fields_list, $layout_html, $layout_params, $hover_animated, $option, $child_entities, $moduleId, $Itemid, 10);
    


      $layout_html = str_replace("{|l-".$layout->lid."|}", '', $layout_html);
      $layout_html = str_replace("{|f-cck_send_button|}", '', $layout_html);
      $layout_html = str_replace("{|f-total_price|}", $entityInstance->instance_price.' '.$entityInstance->instance_currency, $layout_html);
      if(strpos($layout_html,"{|f-coupon|}")){
          if(property_exists($entityInstance, '_coupons') && !empty($entityInstance->_coupons)){
              ob_start();
              echo '<div>'.$entityInstance->_coupons->name.'</div>';
              if($entityInstance->_coupons->type == 'percent'){
                  echo '<div>-'.$entityInstance->_coupons->value.'%</div>';
              }else{
                  echo '<div>-'.calculatedCurrency($entityInstance, $entityInstance->_coupons->value).'%</div>';
              }
              $layout_html = str_replace("{|f-coupon|}", ob_get_contents(), $layout_html);
              ob_end_clean();
          }else{
            $layout_html = str_replace("{|f-coupon|}", '', $layout_html);
          }
      }
      echo $layout_html;
      ?>
    </div>

    <?php
    ?><hr><?php
    if(!empty($str_list['parent_instance'])){
        if(is_array($str_list['parent_instance'])){
            foreach($str_list['parent_instance'] as $key => $parente_instance){
                AdminBuy_request::editBuyRequestInstance($option, $parente_instance[0]->fk_eiid, $price_fields[$key], 2);
            }
        }else{
            AdminBuy_request::editBuyRequestInstance($option, $str_list['parent_instance'], '', 2);
        }
    }
    
    if($recursive == 1){
        
        $table_html = ob_get_contents();
        ob_clean();
        $table->set_custom_html($table_html);
        echo $table->viewTable();
    }
    ?>
    <script type="text/javascript">
  jQuerOs("*[class*='hide-field-name-'] , .delete-field, .delete-row, .delete-layout").remove();
  
  jQuerOs("div[class *='cck-row-'], div[id *='cck_col-']").each(function(index, el) {
    jQuerOs(el).attr("style",jQuerOs(el).data("block-styling"));
  });

// jQuerOs("span.cck-help-string").remove()

jQuerOs(function () {
  jQuerOs('[data-toggle="tooltip"]').tooltip()
})

</script><?php
  }

}
