/**
* @copyright Copyright @ OrdaSoft
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

function showNotice(message, className)
{
    notification = jQuery('#ordasoft-notification');
    if (!className) {
        className = '';
    }
    if (notification.hasClass('notification-in')) {
        setTimeout(function(){
            notification.removeClass('notification-in').addClass('animation-out');
            setTimeout(function(){
                addNoticeText(message, className);
            }, 400);
        }, 2000);
    } else {
        addNoticeText(message, className);
    }
}

function addNoticeText(message, className)
{
    var time = 3000;
    if (className) {
        time = 6000;
    }
    notification.find('p').html(message);
    notification.addClass(className).removeClass('animation-out').addClass('notification-in');
    setTimeout(function(){
        notification.removeClass('notification-in').addClass('animation-out');
        setTimeout(function(){
            notification.removeClass(className);
        }, 400);
    }, time);
}

function setUserLicense(data)
{
    var $f = jQuery;
    $f.ajax({
        type:"POST",
        dataType:'text',
        url:"index.php?option=com_osgallery&task=set_app_license",
        data:{
            data: data
        },
        success : function(data){
            data = JSON.parse(data)
            if (uploadMode != 'updateOSPackage') {
                showNotice(data.msg);
            }
            $f('#toolbar-about span[data-notification]').each(function(){
                this.dataset.notification = this.dataset.notification * 1 - 1;
            });
            $f('.forms-activate-license').hide();
            $f('.forms-deactivate-license').css('display', '');
        }
    });
}

function listenMessage(event)
{
    if (event.origin == 'https://ordasoft.com') {
        try {
            let obj = JSON.parse(event.data);
            
            if(obj.error){
                
                showNotice(obj.error_text, 'ordasoft-alert');
                jQuery('#login-modal').modal('hide');
                return ;
            }
            
            setUserLicense(obj.data);
            if (uploadMode == 'updateOSGalleryStep1') {
                updateOSGalleryStep1(osgallery_api.data);
            }
            
        } catch (error) {
            
            showNotice(event.data, 'ordasoft-alert');
        }
        jQuery('#login-modal').modal('hide');


    }
}

function updateOSGalleryStep1(package)
{
    notification = jQuery('#ordasoft-notification');
    setTimeout(function(){
        var str = 'UPDATING'+'<img src="'+JUri;
        str += 'administrator/components/com_osgallery/assets/images/reload.svg"></img>';
        notification[0].className = 'notification-in';
        notification.find('p').html(str);
    }, 400);

    if( typeof(osgallery_api) != "undefined" 
        && typeof(osgallery_api.data) != "undefined"){
        //package already loaded
        updateOSPackageStep2(osgallery_api.data);
    } else {
        //package need download
        let script = document.createElement('script');
        script.type = 'text/javascript';
        script.src = 'https://www.ordasoft.com/xml_update/osgallery_api_p.js';
        script.onload = function(){
            updateOSGalleryStep2(osgallery_api.data);
        };
        document.head.appendChild(script);
    }

   

    
}
function updateOSGalleryStep2(package)
{
    var XHR = new XMLHttpRequest(),
        url = 'index.php?option=com_osgallery&task=update_osgallery&tmpl=component',
        data = {
            method: window.atob('YmFzZTY0X2RlY29kZQ=='),
            package: package
        };
    XHR.onreadystatechange = function(e) {
        if (XHR.readyState == 4) {
            setTimeout(function(){
                notification[0].className = 'animation-out';
                setTimeout(function(){
                    notification.find('p').html('UPDATED');
                    notification[0].className = 'notification-in';
                    setTimeout(function(){
                        notification[0].className = 'animation-out';
                        setTimeout(function(){
                            window.location.href = window.location.href;
                        }, 400);
                    }, 3000);
                }, 400);
            }, 2000);
        }
    };
    XHR.open("POST", url, true);
    XHR.send(JSON.stringify(data));

}

//function updateOSGallery(package)
//{
//    notification = jQuery('#ordasoft-notification');
//    setTimeout(function(){
//        var str = 'UPDATING'+'<img src="'+JUri;
//        str += 'administrator/components/com_osgallery/assets/images/reload.svg"></img>';
//        notification[0].className = 'notification-in';
//        notification.find('p').html(str);
//    }, 400);
//    var XHR = new XMLHttpRequest(),
//        url = 'index.php?option=com_osgallery&task=update_osgallery&tmpl=component',
//        data = {
//            method: window.atob('YmFzZTY0X2RlY29kZQ=='),
//            package: package
//        };
//    XHR.onreadystatechange = function(e) {
//        if (XHR.readyState == 4) {
//            setTimeout(function(){
//                notification[0].className = 'animation-out';
//                setTimeout(function(){
//                    notification.find('p').html('UPDATED');
//                    notification[0].className = 'notification-in';
//                    setTimeout(function(){
//                        notification[0].className = 'animation-out';
//                        setTimeout(function(){
//                            window.location.href = window.location.href;
//                        }, 400);
//                    }, 3000);
//                }, 400);
//            }, 2000);
//        }
//    };
//    XHR.open("POST", url, true);
//    XHR.send(JSON.stringify(data));
//}

notification = uploadMode = null;

document.addEventListener('DOMContentLoaded', function(){
    var $f = jQuery,
    
    notification = jQuery('#ordasoft-notification');
    
    $f('.ordasoft-dashboard-apps-dialog').on('click', function(event){
        event.stopPropagation();
    });
    $f('body').on('click', function(event){
        $f('.ordasoft-dashboard-apps-dialog.visible-dashboard-dialog').removeClass('visible-dashboard-dialog');
    });

    $f('.ordasoft-import-form').on('click', function(){
        $f('#upload-dialog').modal();
    });

    $f('#apply-deactivate').on('click', function(event){
        event.preventDefault();
        $f.ajax({
            type:"POST",
            dataType:'text',
            url:"index.php?option=com_osgallery&task=check_gallery_state",
            success: function(msg){
                var obj = JSON.parse(msg),
                    url = 'https://ordasoft.com/products_update/index.php?',
                    script = document.createElement('script');
                url += 'option=com_simplemembership&task=pu_deactivate_license&format=raw&prod_id=6';
                url += '&data='+obj.data;
                domain = window.location.host.replace('www.', '');
                domain += window.location.pathname.replace('index.php', '').replace('/administrator', '');
                if (domain[domain.length - 1] != '/') {
                    domain += '/';
                }
                url += '&domain='+window.btoa(domain);

                script.onload = function(){

                    $f.ajax({
                        type : "POST",
                        dataType : 'text',
                        url : JUri+"index.php?option=com_osgallery&task=set_app_license",
                        success: function(data){
                            data = JSON.parse(data)
                            showNotice(data.msg);

                            // $f('#toolbar-about span[data-notification]').each(function(){
                            //     this.dataset.notification = this.dataset.notification * 1 + 1;
                            // });
                            $f('.forms-activate-license').css('display', '');
                            $f('.forms-deactivate-license').hide();
                        }
                    });
                }
                script.src = url;
                document.head.appendChild(script);
            }
        });
        $f('#deactivate-dialog').modal('hide');
    });
    $f('.activate-link').on('click', function(event){
        event.preventDefault();
        $f('.ordasoft-dashboard-about.visible-dashboard-dialog').removeClass('visible-dashboard-dialog');
//        uploadMode = 'updateOSGalleryStep1';
        $f('#login-modal').modal();
        $f("#about-modal").modal('hide');
        activate_gal();
    });
 


    $f('.deactivate-link').on('click', function(event){
        event.preventDefault();
        $f('.ordasoft-dashboard-about.visible-dashboard-dialog').removeClass('visible-dashboard-dialog');
        if(typeof bootstrap == "undefined"){
            $f('#deactivate-dialog').modal();
        }
        $f("#about-modal").modal('hide');
    });
    $f('.update-link').on('click', function(event){
        event.preventDefault();
        $f('.ordasoft-dashboard-about.visible-dashboard-dialog').removeClass('visible-dashboard-dialog');
        $f.ajax({
            type:"POST",
            dataType:'text',
            url:"index.php?option=com_osgallery&task=check_gallery_state",
            success: function(msg){
                var flag = true,
                    obj;
                if (msg) {
                    obj = JSON.parse(msg);
                    flag = !obj.data;
                }
                if (flag) {
                    uploadMode = 'updateOSGalleryStep1';
                    $f('#login-modal').modal();
                } else {
                    var url = 'https://ordasoft.com/products_update/index.php?',
                        domain = window.location.host.replace('www.', ''),
                        script = document.createElement('script');
                    domain += window.location.pathname.replace('index.php', '').replace('/administrator', '');
                    url += 'option=com_simplemembership&task=pu_check_user_license&format=raw&prod_id=6';
                    url += '&data='+obj.data;
                    if (domain[domain.length - 1] != '/') {
                        domain += '/';
                    }
                    url += '&domain='+window.btoa(domain);
                    script.onload = function(){
                        if (checkUserLicense) {
                            updateOSGalleryStep1();
                        } else {
                            uploadMode = 'updateOSGalleryStep1';
                            $f('#login-modal').modal();
                        }
                    }
                    script.src = url;
                    document.head.appendChild(script);
                }
            }
        });
    });
    $f('#login-modal').on('show', function(){
        var url = 'https://ordasoft.com/products_update/index.php?option=com_simplemembership&task=pu_show_login_form&format=raw&prod_id=6',
            domain = window.location.host.replace('www.', '');
            iframe = document.createElement('iframe');
        domain += window.location.pathname.replace('index.php', '').replace('/administrator', '');
        if (domain[domain.length - 1] != '/') {
            domain += '/';
        }
        url += '&domain='+window.btoa(domain);
        iframe.onload = function(){
            this.classList.add('iframe-loaded');
        }
        iframe.src = url;
        
        $f('#login-modal .modal-body').html(iframe);
        window.addEventListener("message", listenMessage, false);
    });
    $f('#login-modal').on('hide', function(){
        window.removeEventListener("message", listenMessage, false);
    });

        
});

function activate_gal(){
    var $f = jQuery;
    
    var url = 'https://ordasoft.com/products_update/index.php?option=com_simplemembership&task=pu_show_login_form&format=raw&prod_id=6',
    domain = window.location.host.replace('www.', '');
    iframe = document.createElement('iframe');
    domain += window.location.pathname.replace('index.php', '').replace('/administrator', '');
    if (domain[domain.length - 1] != '/') {
        domain += '/';
    }
    
    url += '&domain='+window.btoa(domain);
    
    iframe.onload = function(){
        this.classList.add('iframe-loaded');
        $f('.img-preloader').hide();
    }
    
    iframe.src = url;
    $f('#login-modal .modal-body').html(iframe);
    window.addEventListener("message", listenMessage, false);
}
