<?php
/**
* @package OS Gallery
* @copyright 2020 OrdaSoft
* @author 2020 Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @license GNU General Public license version 2 or later;
* @description Ordasoft Image Gallery
*/

// No direct access to this file
defined('_JEXEC') or die('Restricted Access');

?>

<form action="index.php?option=com_osgallery" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
    <ul class="main-gallery-header nav nav-tabs main-nav-tabs" style="display:none;">
        <li><a href="#gallery-main-tab"><?php echo JText::_("COM_OSGALLERY_BUTTON_MAIN")?></a></li>
        <li><a href="#gallery-settings-tab"><?php echo JText::_("COM_OSGALLERY_SETTINGS_BUTTON_MAIN")?></a></li>
    </ul>
    <div class="gallery-main-content-tab tab-content">
        <div id="gallery-main-tab" class="tab-pane fade">
            <div class="span12 os-gallery-wrapp">
            

            <ul class="nav nav-tabs upload-tabs" role="tablist">
                <li role="presentation" class="active"><a href="#file-area" aria-controls="file-area" role="tab" data<?php echo $bs_delimiter; ?>-toggle="tab"><?php echo JText::_("COM_OSGALLERY_TAB_FILE")?></a></li>
                <li role="presentation"><a href="#folder-area" aria-controls="folder-area" role="tab" data<?php echo $bs_delimiter; ?>-toggle="tab" class="osg-pro-avaible"><?php echo JText::_("COM_OSGALLERY_TAB_UPLOAD_FOLDER")?></a></li>
                <li role="presentation"><a href="#zip-area" aria-controls="zip-area" role="tab" data<?php echo $bs_delimiter; ?>-toggle="tab" class="osg-pro-avaible"><?php echo JText::_("COM_OSGALLERY_TAB_UPLOAD_ZIP")?></a></li>
            </ul>


            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="file-area">
                    <div class="upload-loader" style="display: none"></div>
                    <div class="upload-file-wrap">
                    <noscript>
                        <p>JavaScript disabled :(</p>
                    </noscript>
                    <script type="text/template" id="qq-template">
                        <div class="qq-uploader-selector qq-uploader" qq-drop-area-text="<?php echo JText::_("COM_OSGALLERY_DROP_FILE")?>">
                            <div class="qq-total-progress-bar-container-selector qq-total-progress-bar-container">
                                <div role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" class="qq-total-progress-bar-selector qq-progress-bar qq-total-progress-bar"></div>
                            </div>
                            <div class="qq-upload-drop-area-selector qq-upload-drop-area" qq-hide-dropzone>
                                <span class="qq-upload-drop-area-text-selector"></span>
                            </div>
                            <div class="qq-upload-button-selector qq-upload-button">
                                <div><?php echo JText::_("COM_OSGALLERY_UPLOAD_A_FILE")?></div>
                            </div>
                                <span class="qq-drop-processing-selector qq-drop-processing">
                                    <span><?php echo JText::_("COM_OSGALLERY_PROCESSING_DROP_FILE")?></span>
                                    <span class="qq-drop-processing-spinner-selector qq-drop-processing-spinner"></span>
                                </span>
                            <ul class="qq-upload-list-selector qq-upload-list" aria-live="polite" aria-relevant="additions removals">
                                <li>
                                    <div class="qq-progress-bar-container-selector">
                                        <div role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" class="qq-progress-bar-selector qq-progress-bar"></div>
                                    </div>
                                    <span class="qq-upload-spinner-selector qq-upload-spinner"></span>
                                    <span class="qq-upload-file-selector qq-upload-file"></span>
                                    <span class="qq-edit-filename-icon-selector qq-edit-filename-icon" aria-label="<?php echo JText::_("COM_OSGALLERY_QQ_EDIT_FILENAME_ICON")?>"></span>
                                    <input class="qq-edit-filename-selector qq-edit-filename" tabindex="0" type="text">
                                    <span class="qq-upload-size-selector qq-upload-size"></span>
                                    <button type="button" class="qq-btn qq-upload-cancel-selector qq-upload-cancel"><?php echo JText::_("COM_OSGALLERY_QQ_BTN_UPLOAD_CANCEL")?></button>
                                    <button type="button" class="qq-btn qq-upload-retry-selector qq-upload-retry"><?php echo JText::_("COM_OSGALLERY_QQ_BTN_UPLOAD_RETRY")?></button>
                                    <button type="button" class="qq-btn qq-upload-delete-selector qq-upload-delete"><?php echo JText::_("COM_OSGALLERY_QQ_BTN_UPLOAD_DELETE")?></button>
                                    <span role="status" class="qq-upload-status-text-selector qq-upload-status-text"></span>
                                </li>
                            </ul>

                            <dialog class="qq-alert-dialog-selector">
                                <div class="qq-dialog-message-selector"></div>
                                <div class="qq-dialog-buttons">
                                    <button type="button" class="qq-cancel-button-selector"><?php echo JText::_("COM_OSGALLERY_QQ_BTN_DIALOG_CLOSE")?></button>
                                </div>
                            </dialog>

                            <dialog class="qq-confirm-dialog-selector">
                                <div class="qq-dialog-message-selector"></div>
                                <div class="qq-dialog-buttons">
                                    <button type="button" class="qq-cancel-button-selector"><?php echo JText::_("COM_OSGALLERY_QQ_BTN_DIALOG_NO")?></button>
                                    <button type="button" class="qq-ok-button-selector"><?php echo JText::_("COM_OSGALLERY_QQ_BTN_DIALOG_YES")?></button>
                                </div>
                            </dialog>

                            <dialog class="qq-prompt-dialog-selector">
                                <div class="qq-dialog-message-selector"></div>
                                <input type="text">
                                <div class="qq-dialog-buttons">
                                    <button type="button" class="qq-cancel-button-selector"><?php echo JText::_("COM_OSGALLERY_QQ_BTN_DIALOG_CANCEL")?></button>
                                    <button type="button" class="qq-ok-button-selector"><?php echo JText::_("COM_OSGALLERY_QQ_BTN_DIALOG_OK")?></button>
                                </div>
                            </dialog>
                        </div>
                    </script>
                    <?php if(!extension_loaded('imagick') && !(function_exists('imagefontwidth'))){ ?>
                    <div>
                        <div class="alert alert-error">
                            <h4 class="alert-heading">Warning</h4>
                            <div class="alert-message"><?php echo JText::_("COM_OSGALLERY_WARNING_LIBRARIES_INSTALL"); ?></div>
                        </div>
                    </div>
                    <?php } ?>
                    <div id="fine-uploader" <?php if(!extension_loaded('imagick') && !(function_exists('imagefontwidth'))){ ?>style="display:none"<?php } ?>></div>
                    </div>
                </div>

                <div role="tabpanel" class="tab-pane" id="folder-area">
                    <div class="upload-loader" style="display: none"></div>
                    <div class="form-group upload-folder-wrap">
                        <label for="UploadFile"><?php echo JText::_("COM_OSGALLERY_TAB_UPLOAD_FOLDER")?></label>
                        <input type="text" name="uploadFolder" id="upload-folder" value="<?php echo $app->get('tmp_path');?>" placeholder="" disabled="disabled">
                        <button class="btn btn-default upload-folder-btn osg-pro-avaible" disabled="disabled">Upload</button>
                    </div>
                </div>
    
                <div role="tabpanel" class="tab-pane" id="zip-area">
                    <div class="upload-loader" style="display: none"></div>
                    <div class="form-group upload-zip-wrap">
                        <label for="UploadFile"><?php echo JText::_("COM_OSGALLERY_TAB_UPLOAD_ZIP")?></label>
                        <input type="file" name="uploadZip" id="upload-zip" value="" placeholder="" disabled="disabled">
                        <button class="btn btn-default upload-zip-btn osg-pro-avaible" disabled="disabled">Upload</button>
                    </div>
                </div>

            </div>

                <ul id="osgalery-cat-tabs" class="nav cat-nav-tabs nav-tabs">
                    <?php
                    foreach($categories as $cat){ ?>
                        <li id="order-id-<?php echo $cat->id?>">
                            <a href="#cat-<?php echo $cat->id?>" data-cat-id="<?php echo $cat->id?>"><?php echo $cat->name?></a>
                            <input type="hidden" name="category_names[]" value="<?php echo $cat->id?>|+|<?php echo $cat->name?>" placeholder="">
                            <span class="edit-category-name"><i class="material-icons">mode_edit</i><?php echo JText::_("COM_OSGALLERY_EDIT_CATEGORY_NAME")?></span>
                            <span class="delete-category"><i class="material-icons">delete</i></span>
                        </li>
                    <?php
                    } ?>
                    <span class="add-new-cat"><i class="material-icons">note_add</i> <?php echo JText::_("COM_OSGALLERY_ADD_NEW_CAT")?></span>
                </ul>

                <div id="os-cat-tab-images" class="tab-content">
                    <?php
                    foreach($categories as $cat){
                        ?>
                        <div id="cat-<?php echo $cat->id?>" class="tab-pane fade">
                            <?php
                                                    
                            if(isset($images[$cat->id])){
                                foreach($images[$cat->id] as $image){
                                    $path = JPATH_SITE . '/images/com_osgallery/gal-'.$galId.'/thumbnail_165_110/'.$image->file_name;
                                    $img_name = $image->file_name;
                                    if(!file_exists($path)){
                                        $thumbnail_admin_folder = 'thumbnail';
                                        if(!file_exists(JPATH_SITE . '/images/com_osgallery/gal-'.$galId.'/thumbnail/'.$image->file_name)){
                                            $img_arr = explode('.', $image->file_name);
                                            $img_ext = $img_arr[count($img_arr) -1];
                                            unset($img_arr[count($img_arr) -1]);
                                            $img_name = implode('.', $img_arr);
                                            $img_name = self::getImageThumbnailName($img_name, $params->get("imgHeight",400,"INT"), $params->get("imgWidth",600,"INT")) . '.' . $img_ext;
                                        }
                                    }else{
                                        $thumbnail_admin_folder = 'thumbnail_165_110';
                                    }
                                    
                                    echo '<div id="img-'.$image->id.'" class="img-block" data-image-id="'.$image->id.'">'.
                                            '<span class="delete-image"><i class="material-icons">close</i></span>'.
                                            '<img data-src="'.JURI::root().'images/com_osgallery/gal-'.$galId.'/'.$thumbnail_admin_folder.'/'.$img_name.'" alt="'.$image->file_name.'">'.
                                            '<input id="img-settings-'.$image->id.'-'.$cat->id.'" type="hidden" name="imgSettings['.$image->id.']" value="'.htmlspecialchars($imgParamsArray[$image->id]->params).'">'. // $imgParamsArray[$image->id]->params.
                                            '<div class="img_block_bg">
                                            <div class="block_bg_setting"></div>
                                            </div>' .
                                        '</div>';

                                }
                            }?>

                            <input class="cat-img-ordering" type="hidden" name="imageOrdering[<?php echo $cat->id?>]" value="">
                            <input id="cat-settings-<?php echo $cat->id;?>" type="hidden" name="catSettings[<?php echo $cat->id; ?>]" value="<?php echo $catParamsArray[$cat->id]->params;?>">
                        </div>
                    <?php
                    } ?>
                </div>
            </div>
            <!-- Options for category and each image -->
            <div class="span4">

            </div>

            <!-- Модаль -->  
            <div class="modal fade" id="modalImageSettings" tabindex="-1" role="dialog" aria-labelledby="modalImageSettingsLabel" style="display: none">
              <div class="modal-dialog" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <h4 class="modal-title" id="modalImageSettingsLabel"><?php echo JText::_("COM_OSGALLERY_MODAL_TITLE")?></h4>
                    <button type="button" class="close" data<?php echo $bs_delimiter; ?>-dismiss="modal" aria-label="<?php echo JText::_("COM_OSGALLERY_BTN_MODAL_CLOSE")?>"><span aria-hidden="true">&times;</span></button>
                  </div>
                  <div class="modal-body">
                    <!-- category-options-block body -->
                    <div class="category-options-block">
                        <ul class="options-header nav nav-tabs main-nav-tabs">
                            <li><a href="#img-options-block"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_TAB")?></a></li>
                            <li><a href="#cat-options-block"><?php echo JText::_("COM_OSGALLERY_CATEGORY_OPTION_TAB")?></a></li>
                        </ul>
                        <!-- IMAGE SETTINGS BLOCK -->
                        <div class="category-options-content tab-content">
                            <div id="img-options-block" class="tab-pane fade">
                                <div class="arraow-prev" title="<?php echo JText::_("COM_OSGALLERY_ARRAOW_PREV_IMAGE")?>">
                                    <svg class="arrow-left-5" viewBox="0 0 154 109">
                                            <symbol id="Arrow" viewBox="-73.9 -55.3 135.9 85.4">
                                                    <g>
                                                            <polygon points="-73.9,29.1 -6,-9.2 61.9,30.1 61.9,14.2 -6,-25.1 -73.9,14.2 "></polygon>
                                                    </g>
                                                    <g>
                                                            <polygon points="-73.9,-1 -6,-39.3 61.9,0 61.9,-16 -6,-55.3 -73.9,-16 "></polygon>
                                                    </g>
                                            </symbol>
                                            <use xlink:href="#Arrow" width="135.9" height="85.4" id="XMLID_1_" x="-73.9" y="-55.3" transform="matrix(1.007 0 0 -1.007 83.0005 42)"></use>
                                    </svg>
                                </div>
                                <div class="arraow-next" title="<?php echo JText::_("COM_OSGALLERY_ARRAOW_NEXT_IMAGE")?>">
                                    <svg class="arrow-right-5" viewBox="0 0 154 109">
                                            <symbol id="Arrow" viewBox="-73.9 -55.3 135.9 85.4">
                                                    <g>
                                                            <polygon points="-73.9,29.1 -6,-9.2 61.9,30.1 61.9,14.2 -6,-25.1 -73.9,14.2 "></polygon>
                                                    </g>
                                                    <g>
                                                            <polygon points="-73.9,-1 -6,-39.3 61.9,0 61.9,-16 -6,-55.3 -73.9,-16 "></polygon>
                                                    </g>
                                            </symbol>
                                            <use xlink:href="#Arrow" width="135.9" height="85.4" id="XMLID_1_" x="-73.9" y="-55.3" transform="matrix(1.007 0 0 -1.007 83.0005 42)"></use>
                                    </svg>
                                </div>
                                <div class="img-preview"></div>
                                <input type="hidden" id="img_id" value="">
                                <div>
                                    <span class="cat-col-1" title="<?php echo JText::_("COM_OSGALLERY_IMAGE_SHORT_CODE_DESC"); ?>"><?php echo JText::_("COM_OSGALLERY_IMAGE_SHORT_CODE_LABEL")?></span>
                                    <span class="cat-col-2">
                                        <span class="img-short-code"></span>
                                    </span>
                                </div>
                                <?php if($os_gallery_configuration->get('multilang', '0') == '1'){
                                    foreach($install_lang as $tag => $lang){
                                        ?>
                                        <div>
                                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_TITLE_LABEL")?> <?php echo $tag; ?></span>
                                            <span class="cat-col-2">
                                                <input id="img-title_<?php echo $tag; ?>" type="text" name="imgTitle_<?php echo $tag; ?>" value="">
                                            </span>
                                        </div>
                                    <?php } ?>
                                    <input id="img-title" type="hidden" name="imgTitle" value="">
                                    <?php
                                    foreach($install_lang as $tag => $lang){
                                        ?>
                                        <div>
                                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_SHORT_DESCRIPTION_LABEL")?> <?php echo $tag; ?></span>
                                            <span class="cat-col-2">
                                                <input id="img-short-description_<?php echo $tag; ?>" type="text" name="imgShortDescription_<?php echo $tag; ?>" value="">
                                            </span>
                                        </div>
                                    <?php } ?>
                                    <input id="img-short-description" type="hidden" name="imgShortDescription" value="">
                                    <?php foreach($install_lang as $tag => $lang){
                                        ?>
                                        <div>
                                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_ALT_LABEL")?> <?php echo $tag; ?></span>
                                            <span class="cat-col-2">
                                                <input id="img-alt_<?php echo $tag; ?>" type="text" name="imgAlt_<?php echo $tag; ?>" value="">
                                            </span>
                                        </div>
                                    <?php } ?>
                                    <div>
                                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_IMG_CATEGORIES_LABEL")?></span>
                                        <span class="cat-col-2">
                                            <select id="imgCats" name="imgCats[]" multiple="multiple">
                                                <?php foreach($categories as $cat_opt){ ?>
                                                    <option value="<?php echo $cat_opt->id; ?>"><?php echo $cat_opt->name; ?></option>
                                                <?php } ?>
                                            </select>
                                        </span>
                                    </div>
                                    <input id="img-alt" type="hidden" name="imgAlt" value="">
                                    <?php foreach($install_lang as $tag => $lang){
                                        ?>
                                        <div>
                                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_LINK_LABEL")?> <?php echo $tag; ?></span>
                                            <span class="cat-col-2">
                                                <input id="img-link_<?php echo $tag; ?>" type="text" name="imgLink_<?php echo $tag; ?>" value="">
                                            </span>
                                    </div>
                                    <?php } ?>
                                    <input id="img-link" type="hidden" name="imgLink" value="">
                                <?php }else{?>
                                    <div>
                                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_TITLE_LABEL")?></span>
                                        <span class="cat-col-2">
                                            <input id="img-title" type="text" name="imgTitle" value="">
                                        </span>
                                    </div>

                                    <div>
                                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_SHORT_DESCRIPTION_LABEL")?></span>
                                        <span class="cat-col-2">
                                            <input id="img-short-description" type="text" name="imgShortDescription" value="">
                                        </span>
                                    </div>
                                    <div>
                                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_IMG_CATEGORIES_LABEL")?></span>
                                        <span class="cat-col-2">
                                            <select id="imgCats" name="imgCats[]" multiple="multiple">
                                                <?php foreach($categories as $cat_opt){ ?>
                                                    <option value="<?php echo $cat_opt->id; ?>"><?php echo $cat_opt->name; ?></option>
                                                <?php } ?>
                                            </select>
                                        </span>
                                    </div>

                                    <div>
                                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_ALT_LABEL")?></span>
                                        <span class="cat-col-2">
                                            <input id="img-alt" type="text" name="imgAlt" value="">
                                        </span>
                                    </div>
                                
                                    <div>
                                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_LINK_LABEL")?></span>
                                        <span class="cat-col-2">
                                            <input id="img-link" type="text" name="imgLink" value="">
                                        </span>
                                    </div>
                                <?php } ?>
                                

                                <div>
                                    <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_LINK_TARGET_LABEL")?></span>
                                    <span class="cat-col-2">
                                        <select id="img-link-open" name="linkOpen">
                                            <option value="_blank"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_LINK_TARGET_SELECT1")?></option>
                                            <option value="_self"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_LINK_TARGET_SELECT2")?></option>
                                        </select>
                                    </span>
                                </div>
                                
                                <div class="img-publish">
                                    <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_PUBLISH")?></span>
                                    <span class="cat-col-2">
                                        <div id="img_publish" class="osgallery-checkboxes-block">
                                            <input id="img_publish-yes" type="radio" name="img_publish" value="1" checked/>
                                            <input id="img_publish-no" type="radio" name="img_publish" value="0" />
                                            <label for="img_publish-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                            <label for="img_publish-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                                        </div>
                                    </span>
                                </div>

                                <h4>-- <?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_HTML_SETTINGS");?> --</h4>
                                
                                <?php if($os_gallery_configuration->get('multilang', '0') == '1'){  
                                    foreach($install_lang as $tag => $lang){ ?>     
                                        <div class="type_html_code osg-pro-avaible-string">
                                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_HTML_LABEL")?> <?php echo $tag; ?></span>
                                            <span class="cat-col-2">
                                                <textarea id="img-html_<?php echo $tag; ?>" name="imgHtml_<?php echo $tag; ?>" type="text" value="" rows="3" cols="10" disabled="disabled"></textarea>
                                            </span>
                                        </div>
                                    <?php } ?>
                                        <input id="img-html" name="imgHtml" type="hidden" value="">
                                    <?php
                                    } else { ?>
                                    <div class="type_html_code osg-pro-avaible-string">
                                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_HTML_LABEL")?></span>
                                        <span class="cat-col-2">
                                            <textarea id="img-html" name="imgHtml" type="text" value="" rows="3" cols="10" disabled="disabled"></textarea>
                                        </span>
                                    </div>
                                <?php } ?>

                                <div class="img-html-show">
                                    <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_SHOW_IMAGE_HTML")?></span>
                                    <span class="cat-col-2">
                                        <div id="general-img-html" class="osgallery-checkboxes-block">
                                            <input id="general-img-html-yes" type="radio" name="showImgHtml" value="1" checked/>
                                            <input id="general-img-html-no" type="radio" name="showImgHtml" value="0" />
                                            <label for="general-img-html-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                            <label for="general-img-html-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                                        </div>
                                    </span>
                                </div>
                                <span class="clearfix" ></span>
                                <div class="html-position">
                                    <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_HTML_POSITION")?></span>
                                    <span class="cat-col-2">
                                        <select id="html-position-img" name="htmlPosition">
                                            <option value="top"><?php echo JText::_("Top")?></option>
                                            <option value="bottom" disabled="disabled"><?php echo JText::_("Bottom")?></option>
                                        </select>
                                    </span>
                                </div>
                                <span class="clearfix" ></span>
                                <div class="img-html-width osg-pro-avaible-string">
                                    <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_HTML_WIDTH_AS_IMAGE")?></span>
                                    <span class="cat-col-2">
                                        <div id="html-width-as-img" class="osgallery-checkboxes-block">
                                            <input id="html-width-as-img-yes" type="radio" name="htmlWidthAsImg" value="1" checked/>
                                            <input id="html-width-as-img-no" type="radio" name="htmlWidthAsImg" value="0" />
                                            <label for="html-width-as-img-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                            <label for="html-width-as-img-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                                        </div>
                                    </span>
                                </div>
                                <span class="clearfix" ></span>

                                <!-- <span class="clearfix" ></span> -->
                                <h4>-- <?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_VIDEO_SETTINGS");?> --</h4>
                                <?php if($os_gallery_configuration->get('multilang', '0') == '1'){  
                                    foreach($install_lang as $tag => $lang){ ?>
                                        <div>
                                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_VIDEO_LINK")?> <?php echo $tag; ?></span>
                                            <span class="cat-col-2">
                                                <input id="video-link_<?php echo $tag; ?>" type="text" name="videoLink_<?php echo $tag; ?>" value="">
                                            </span>
                                        </div>
                                    <?php } ?>
                                <input id="video-link" type="hidden" name="videoLink" value="">
                                <?php
                                } else { ?>
                                    <div>
                                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_VIDEO_LINK")?></span>
                                        <span class="cat-col-2">
                                            <input id="video-link" type="text" name="videoLink" value="">
                                        </span>
                                    </div>
                                <?php } ?>
                                
                            </div>
                            <!-- CATEGORY SETTINGS BLOCK -->
                            <div id="cat-options-block" class="tab-pane fade">
                                <div>
                                    <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_CATEGORY_SHORT_CODE_LABEL")?></span>
                                    <span class="cat-col-2">
                                        <span class="cat-short-code"></span>
                                    </span>
                                </div>
                                <?php if($os_gallery_configuration->get('multilang', '0') == '1'){
                                    foreach($install_lang as $tag => $lang){
                                        ?>
                                        <div>
                                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_CATEGORY_OPTION_ALIAS_LABEL")?> <?php echo $tag; ?></span>
                                            <span class="cat-col-2">
                                                <input id="cat-alias_<?php echo $tag; ?>" type="text" name="categoryAlias_<?php echo $tag; ?>" value="">
                                            </span>
                                        </div>
                                    <?php } ?>
                                        <input id="cat-alias" type="hidden" name="categoryAlias" value="">
                                    <?php
                                    foreach($install_lang as $tag => $lang){
                                        ?>
                                        <div>
                                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_CATEGORY_OPTION_DESCRIPTION_LABEL")?> <?php echo $tag; ?></span>
                                            <span class="cat-col-2">
                                                <input id="cat-desc_<?php echo $tag; ?>" type="text" name="categoryDescription_<?php echo $tag; ?>" value="">
                                            </span>
                                        </div>
                                    <?php } ?>
                                        <input id="cat-desc" type="hidden" name="categoryDescription" value="">
                                <?php
                                }else{ ?>
                                    <div>
                                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_CATEGORY_OPTION_ALIAS_LABEL")?></span>
                                        <span class="cat-col-2">
                                            <input id="cat-alias" type="text" name="categoryAlias" value="">
                                        </span>
                                    </div>

                                    <div>
                                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_CATEGORY_OPTION_DESCRIPTION_LABEL")?></span>
                                        <span class="cat-col-2">
                                            <input id="cat-desc" type="text" name="categoryDescription" value="">
                                        </span>
                                    </div>
                                <?php } ?>
                                <div class="cat-show-title">
                                    <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_CATEGORY_OPTION_SHOW_TITLE_LABEL")?></span>
                                    <span class="cat-col-2">
                                        <div class="osgallery-checkboxes-block">
                                            <input id="cat-show-title-yes" type="radio" name="check" value="1" checked/>
                                            <input id="cat-show-title-no" type="radio" name="check" value="0" />
                                            <label for="cat-show-title-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                            <label for="cat-show-title-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                                        
                                        </div>
                                    </span>
                                </div>

                                <!--<div>
                                    <span class="cat-col-1"><?php //echo JText::_("COM_OSGALLERY_CATEGORY_OPTION_SHOW_TITLE_CAPTION_LABEL")?></span>
                                    <span class="cat-col-2">
                                        <div class="os-check-box">
                                          <input type="checkbox" value="None" id="cat-show-cat-title-caption" name="check" checked="checked" />
                                          <label for="cat-show-cat-title-caption"></label>
                                        </div>
                                    </span>
                                </div>-->
                                <div class="cat-position-title-block" <?php echo ($gallerylayout != "allInOne" && $gallerylayout != "albumMode")?'style="display:none;"':'';?>>
                                    <div>
                                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_CATEGORY_OPTION_POSITION_TITLE_LABEL")?></span>
                                        <span class="cat-col-2">
                                            <select id="cat-title-position" name="catTitlePosition">
                                                <option  value="none"><?php echo JText::_("COM_OSGALLERY_OPTION_CAT_TITLE_POSITION_NOT_DISPLAY")?></option>
                                                <option  value="onImage"><?php echo JText::_("COM_OSGALLERY_OPTION_CAT_TITLE_POSITION_ON_IMAGE")?></option>
                                                <option  value="top"><?php echo JText::_("COM_OSGALLERY_OPTION_CAT_TITLE_POSITION_TOP_ABOVE_IMAGE")?></option>
                                                <option  value="bottom"><?php echo JText::_("COM_OSGALLERY_OPTION_CAT_TITLE_POSITION_BOTTOM_UNDER_IMAGE")?></option>
                                            </select>
                                        </span>
                                    </div>
                                    <div class="cat-title-height">
                                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_IMG_TEXT_HEIGHT")?></span>
                                        <span class="cat-col-2">
                                            <input id="cat-title-height-block" type="number" name="catTitleHeightBlock" value="">
                                        </span>
                                    </div>
                                    
                                </div>

                                <div class="cat-publish">
                                    <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_CATEGORY_OPTION_PUBLISH_LABEL")?></span>
                                    <span class="cat-col-2">
                                        
<!--                                          <input type="checkbox" value="None" id="cat-unpublish" name="check" checked="checked"/>
                                          <label for="cat-unpublish"></label>-->
                                        <div class="osgallery-checkboxes-block">
                                            <input id="cat-publish-yes" type="radio" name="catPublish" value="1" checked/>
                                            <input id="cat-publish-no" type="radio" name="catPublish" value="0" />
                                            <label for="cat-publish-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                            <label for="cat-publish-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                                        </div>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /category-options-block body -->
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-default" data<?php echo $bs_delimiter; ?>-dismiss="modal">Close</button>
                  </div>
                </div>
              </div>
            </div>

        </div>

        <!-- gallery settings tab -->
        <div id="gallery-settings-tab" class="tab-pane fade">
            <ul id="osgalery-settings-tabs" class="nav settings-nav-tabs nav-tabs">
                <li>
                    <a href="#general-settings"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_TAB_LABEL")?></a>
                </li>
                <li class="osg-pro-avaible">
                    <a href="#os_fancybox-settings"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_TAB_LABEL")?></a>
                </li>
                <li class="osg-pro-avaible">
                    <a href="#watermark-settings"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATEMARK_TAB_LABEL")?></a>
                </li>                
                <li class="osg-pro-avaible">
                    <a href="#social-settings"><?php echo JText::_("COM_OSGALLERY_SOCIAL BUTTONS")?></a>
                </li>
            </ul>
            <div id="os-tab-settings" class="tab-content">
                <!-- GENERAL settings -->
                <div id="general-settings" class="tab-pane fade">
                    <div id="externalSettings">
                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_EXTERNAL_GAL_SETTING")?></span>
                        <span class="cat-col-2">
                            <?php echo JHTML::_('select.genericlist',$externalGalleriesList, 'externalGallerySettings',
                                'size="1" class="inputbox osg-pro-avaible" ', 'value', 'text', $externalGallerySelect);?>

                        </span>
                    </div>
                    <div class="main-setting">
                        <div>
                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERALLAYOUT_LABEL")?></span>
                            <span class="cat-col-2">
                                <select class="gallery-layout" name="galleryLayout">
                                    <option selected="selected" value="defaultTabs"><?php echo JText::_("COM_OSGALLERY_GALLERY_LAYOUT_DEFAULT")?></option>
                                    <option class="disabled" disabled="disabled" value="allInOne"><?php echo JText::_("COM_OSGALLERY_GALLERY_LAYOUT_ALL_IN_ONE")?></option>
                                    <option class="disabled" disabled="disabled"  value="albumMode"><?php echo JText::_("COM_OSGALLERY_GALLERY_LAYOUT_ALBUM")?></option>
                                    <option class="disabled" disabled="disabled"  value="masonry"><?php echo JText::_("COM_OSGALLERY_GALLERY_LAYOUT_MASONRY")?></option>
                                    <option class="disabled" disabled="disabled"  value="fit_rows"><?php echo JText::_("COM_OSGALLERY_GALLERY_LAYOUT_FITROWS")?></option>
                                    <option class="disabled" disabled="disabled"  value="allInOneRow" id="allInOneRow" <?php echo ($disabledRow) ? 'disabled="disabled"' : ''; ?>><?php echo JText::_("COM_OSGALLERY_GALLERY_LAYOUT_ALL_IN_ONE_ROW")?></option>
                                </select>
                            </span>
                        </div>
                        
                        

                        <div class="back-button-text-block" <?php echo ($gallerylayout != "albumMode")?'style="display:none;"':'';?>>
                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_BACK_BUTTON_LABEL")?></span>
                            <span class="cat-col-2">
                                <input type="text" name="backButtonText" value="<?php echo $backButtonText?>">
                            </span>
                        </div>

                        <div class="image_margin_wrap" <?php echo ($gallerylayout == "allInOneRow")?'style="display:none;"':'';?>>
                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_IMAGE_MARGIN_LABEL")?></span>
                            <span class="cat-col-2">
                                <input type="number" min="0" name="image_margin" value="<?php echo $imageMargin?>">
                            </span>
                        </div>

                        <div>
                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_IMAGE_NUM_COLUMNS_LABEL")?></span>
                            <span class="cat-col-2">
                                <input type="number" min="1" name="num_column" value="<?php echo $numColumn?>">
                            </span>
                        </div>

                        <div id="osgallery-checkboxes-block-general" >
                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_IMAGE_DECREASE_COLUMN")?></span>
                            <span class="cat-col-2">
                                <div class="osgallery-checkboxes-block">
                                    <input id="general-min-enable-yes" type="radio" name="minImgEnable" value="1" <?php echo $minImgEnable?'checked':''?>/>
                                    <input id="general-min-enable-no" type="radio" name="minImgEnable" value="0" <?php echo $minImgEnable?'':'checked'?>/>
                                    <label for="general-min-enable-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                    <label for="general-min-enable-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                                </div>
                            </span>
                        </div>
                        <div id="minImgSize">
                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_IMAGE_DECREASE_COLUMN_SIZE")?></span>
                            <span class="cat-col-2">
                                <input type="number" min="1" name="minImgSize" value="<?php echo $minImgSize?>">
                            </span>
                        </div>

                        <div id="imgWidth" <?php echo ($gallerylayout == "masonry" || $gallerylayout == "fit_rows")?'style="display:none;"':'';?>>
                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_CROP_IMAGE_WIDTH")?></span>
                            <span class="cat-col-2">
                                <input type="number" min="1" name="imgWidth" value="<?php echo $imgWidth?>">
                            </span>
                        </div>

                        <div id="imgHeight" <?php echo ($gallerylayout == "masonry" || $gallerylayout == "fit_rows")?'style="display:none;"':'';?>>
                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_CROP_IMAGE_HEIGHT")?></span>
                            <span class="cat-col-2">
                                <input type="number" min="1" name="imgHeight" value="<?php echo $imgHeight?>">
                            </span>
                        </div>

                        <div>
                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_IMAGEHOVER_LABEL")?></span>
                            <span class="cat-col-2">
                                <select name="imageHover">
                                    <option <?php echo ($imagehover == "none")?'selected="selected"':''?> value="none"><?php echo JText::_("COM_OSGALLERY_OPTION_NONE")?></option>
                                    <option <?php echo ($imagehover == "dimas")?'selected="selected"':''?> value="dimas">Dimas</option>
                                    <option class="disabled" disabled="" id="anet" value="anet">Anet</option>
                                    <option class="disabled" disabled="" value="sergio">Sergio</option>
                                    <option class="disabled" disabled="" id="ariana" value="ariana">Ariana</option>
                                    <option class="disabled" disabled="" value="taras">Taras</option>
                                    <option class="disabled" disabled="" value="andrea">Andrea</option>
                                    <option class="disabled" disabled="" value="zema">Zema</option>
                                    <option class="disabled" disabled="" id="pytiton" value="pytiton">Pytiton</option>
                                    <option class="disabled" disabled="" id="oleg" value="oleg">Oleg</option>
                                    <option class="disabled" disabled="" id="tjava" value="tjava">Tjava</option>
                                    <option class="disabled" disabled="" id="vadim" value="vadim">Vadim</option>
                                    <option class="disabled" disabled="" id="vlados" value="vlados">Vlados</option>
                                </select>
                            </span>
                        </div>

                        <div>
                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_NUMBER_DISPLAY_IMAGES_EFFECT")?></span>
                        <span class="cat-col-2">
                            <select name="number_images_effect" >
                                <option <?php echo ($numberImagesEffect == "none") ? 'selected="selected"' : ''?> value="none">&ensp;&ensp;None</option>
                                <optgroup label="-- Attention Seekers --">
                                  <option <?php echo ($numberImagesEffect == "bounce") ? 'selected="selected"' : ''?>  value="bounce">bounce</option>
                                  <option <?php echo ($numberImagesEffect == "flash") ? 'selected="selected"' : ''?>  value="flash">flash</option>
                                  <option class="disabled" disabled=""  value="pulse">pulse</option>
                                  <option class="disabled" disabled=""  value="rubberBand">rubberBand</option>
                                  <option class="disabled" disabled=""  value="shake">shake</option>
                                  <option class="disabled" disabled=""  value="swing">swing</option>
                                  <option class="disabled" disabled=""  value="tada">tada</option>
                                  <option class="disabled" disabled=""  value="wobble">wobble</option>
                                  <option class="disabled" disabled=""  value="jello">jello</option>
                                </optgroup>
                                <optgroup label="-- Bouncing Entrances --">
                                  <option class="disabled" disabled="" value="bounceIn">bounceIn</option>
                                </optgroup>
                                <optgroup label="-- Fading Entrances --">
                                  <option class="disabled" disabled="" value="fadeIn">fadeIn</option>
                                </optgroup>
                                <optgroup label="-- Flippers --">
                                  <option class="disabled" disabled="" value="flip">flip</option>
                                </optgroup>
                                <optgroup label="-- Lightspeed --">
                                  <option class="disabled" disabled="" value="lightSpeedIn">lightSpeedIn</option>
                                </optgroup>
                                <optgroup label="-- Rotating Entrances --">
                                  <option class="disabled" disabled="" value="rotateIn">rotateIn</option>
                                </optgroup>
                                <optgroup label="-- Sliding Entrances --">
                                  <option class="disabled" disabled="" value="slideInUp">slideInUp</option>
                                </optgroup>
                                <optgroup label="-- Zoom Entrances --">
                                  <option class="disabled" disabled="" value="zoomIn">zoomIn</option>
                                </optgroup>
                                <optgroup label="-- Specials --">
                                  <option class="disabled" disabled="" value="hinge">hinge</option>
                                  <option class="disabled" disabled="" value="jackInTheBox">jackInTheBox</option>
                                  <option class="disabled" disabled="" value="rollIn">rollIn</option>
                                  <option class="disabled" disabled="" value="rollOut">rollOut</option>
                                </optgroup>
                            </select>
                        </span>
                    </div>


                     <?php if(function_exists('exif_read_data')){ ?>
                        <div id="osgallery-rotate-checkbox" >
                           <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_ROTATE_IMAGE")?></span>
                           <span class="cat-col-2">
                               <div class="osgallery-checkboxes-block">
                                   <input id="general-rotate-enable-yes" type="radio" name="rotateImage" value="1" <?php echo $rotateImage?'checked':''?>/>
                                   <input id="general-rotate-enable-no" type="radio" name="rotateImage" value="0" <?php echo $rotateImage?'':'checked'?>/>
                                   <label for="general-rotate-enable-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                   <label for="general-rotate-enable-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                               </div>
                           </span>
                       </div>
                    <?php }else{ ?>
                        <div id="osgallery-rotate-checkbox" class="not-function">
                            <span class="cat-col-1 osg-pro-avaible"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_ROTATE_IMAGE_ERROR")?></span>
                            <span class="cat-col-2">
                                <div class="osgallery-checkboxes-block">
                                    <input id="general-rotate-enable-yes" class="osg-pro-avaible" type="radio" name="rotateImage" value="1" <?php echo $rotateImage?'checked':''?>/>
                                    <input id="general-rotate-enable-no" class="osg-pro-avaible" type="radio" name="rotateImage" value="0" <?php echo $rotateImage?'':'checked'?>/>
                                    <label for="general-rotate-enable-yes" class="osg-pro-avaible" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                    <label for="general-rotate-enable-no" class="osg-pro-avaible" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                                </div>
                            </span>
                        </div>
                    <?php } ?>

                    <div id="order">
                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_ORDER")?></span>
                        <span class="cat-col-2">
                            <select name="order">
                                <option <?php echo ($order == "drag_and_drop")?'selected="selected"':''?> value="drag_and_drop"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_ORDER_DRAG_DROP")?></option>
                                <option class="disabled" disabled="" value="file_name"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_ORDER_FILENAME")?></option>
                                <option class="disabled" disabled="" value="title"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_ORDER_TITLE")?></option>
                                <option class="disabled" disabled="" value="upload_date"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_ORDER_UPLOADTIME")?></option>
                            </select>
                        </span>
                    </div>
                    <div id="orderBy" <?php echo ($order == "drag_and_drop") ? 'style="display: none;"' : ''; ?>>
                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_ORDER_BY")?></span>
                        <span class="cat-col-2">
                            <select name="orderBy">
                                <option <?php echo ($orderBy == "ASC")?'selected="selected"':''?> value="ASC">ASC</option>
                                <option <?php echo ($orderBy == "DESC")?'selected="selected"':''?> value="DESC">DESC</option>
                            </select>
                        </span>
                    </div>

                    <div id="imgTextPosition" <?php echo ($gallerylayout == "allInOne")?'style="display:none;"':'';?>>
                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_IMG_TEXT_POSITION")?></span>
                        <span class="cat-col-2">
                            <select name="imgTextPosition">
                                <option <?php echo ($imgTextPosition == "none")?'selected="selected"':''?> value="none"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_IMG_TEXT_POSITION_NO_DISPLAY")?></option>
                                <option <?php echo ($imgTextPosition == "onImage")?'selected="selected"':''?> value="onImage"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_IMG_TEXT_POSITION_ON_IMAGE")?></option>
                                <option <?php echo ($imgTextPosition == "top")?'selected="selected"':''?> value="top" id="topImg" <?php echo ($disabledRow) ? 'disabled="disabled"' : ''; ?>><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_IMG_TEXT_POSITION_TOP_ABOVE_IMAGE")?></option>
                                <option <?php echo ($imgTextPosition == "bottom")?'selected="selected"':''?> value="bottom" id="bottomImg" <?php echo ($disabledRow) ? 'disabled="disabled"' : ''; ?>><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_IMG_TEXT_POSITION_BOTTOM_UNDER_IMAGE")?></option>
                            </select>
                        </span>
                    </div>
                    <div id="imgTextHeight" <?php echo ($gallerylayout == "allInOne" || $gallerylayout == "masonry" || $imgTextPosition == 'onImage' || $imgTextPosition == 'none')?'style="display:none;"':'';?>>
                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_IMG_TEXT_HEIGHT")?></span>
                        <span class="cat-col-2">
                            <input type="number" min="1" name="imgTextHeight" value="<?php echo $imgTextHeight?>">
                        </span>
                    </div>
                    <div id="imgMaxlengthTitle">
                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_IMG_MAX_LENGHT_TITLE")?></span>
                        <span class="cat-col-2">
                            <input type="number" min="1" name="imgMaxlengthTitle" value="<?php echo $imgMaxlengthTitle; ?>">
                        </span>
                    </div>
                    <div id="imgMaxlengthDesc">
                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_IMG_MAX_LENGHT_DESCRIPTION")?></span>
                        <span class="cat-col-2">
                            <input type="number" min="1" name="imgMaxlengthDesc" value="<?php echo $imgMaxlengthDesc; ?>">
                        </span>
                    </div>
                    <div>
                        <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_IMG_MASK")?></span>
                        <span class="cat-col-2">
                            <select name="imgMask">
                                <option <?php echo ($imgMask == "none")?'selected="selected"':''?> value="none"><?php echo JText::_("COM_OSGALLERY_OPTION_NONE")?></option>
                                <option class="disabled" disabled="" value="Bevel"><?php echo JText::_("COM_OSGALLERY_OPTION_BEVEL")?></option>
                                
                                <option class="disabled" disabled="" value="Circle"><?php echo JText::_("COM_OSGALLERY_OPTION_CIRCLE")?></option>
                                <option class="disabled" disabled="" value="Close"><?php echo JText::_("COM_OSGALLERY_OPTION_CLOSE")?></option>
                                <option class="disabled" disabled="" value="Cross"><?php echo JText::_("COM_OSGALLERY_OPTION_CROSS")?></option>
                                
                                <option class="disabled" disabled="" value="Decagon"><?php echo JText::_("COM_OSGALLERY_OPTION_DECAGON")?></option>
                                
                                <option class="disabled" disabled="" value="Ellipse"><?php echo JText::_("COM_OSGALLERY_OPTION_ELLIPE")?></option>
                                
                                <option class="disabled" disabled="" value="Frame"><?php echo JText::_("COM_OSGALLERY_OPTION_FRAME")?></option>
                                
                                <option class="disabled" disabled="" value="Heart"><?php echo JText::_("COM_OSGALLERY_OPTION_HEART")?></option>
                                <option class="disabled" disabled="" value="Heptagon"><?php echo JText::_("COM_OSGALLERY_OPTION_HEPTAGON")?></option>
                                <option class="disabled" disabled="" value="Hexagon"><?php echo JText::_("COM_OSGALLERY_OPTION_HEXAGON")?></option>
                                
                                <option class="disabled" disabled="" value="Inset"><?php echo JText::_("COM_OSGALLERY_OPTION_INSET")?></option>
                                
                                <option class="disabled" disabled="" value="Left_arrow"><?php echo JText::_("COM_OSGALLERY_OPTION_LEFT_ARROW")?></option>
                                <option class="disabled" disabled="" value="Left_Chevron"><?php echo JText::_("COM_OSGALLERY_OPTION_LEFT_CHEVRON")?></option>
                                <option class="disabled" disabled="" value="Left_Point"><?php echo JText::_("COM_OSGALLERY_OPTION_LEFT_POINT")?></option>
                                
                                <option class="disabled" disabled="" value="Message"><?php echo JText::_("COM_OSGALLERY_OPTION_MESSAGE")?></option>
                                
                                <option class="disabled" disabled="" value="Nonagon"><?php echo JText::_("COM_OSGALLERY_OPTION_NONAGON")?></option>
                                
                                <option class="disabled" disabled="" value="Octagon"><?php echo JText::_("COM_OSGALLERY_OPTION_OCTAGON")?></option>
                                
                                <option <?php echo ($imgMask == "Parallelogram")?'selected="selected"':''?> value="Parallelogram"><?php echo JText::_("COM_OSGALLERY_OPTION_PARRALLELOGRAM")?></option>
                                <option class="disabled" disabled="" value="Pentagon"><?php echo JText::_("COM_OSGALLERY_OPTION_PENTAGON")?></option>
                                
                                <option class="disabled" disabled="" value="Rabbet"><?php echo JText::_("COM_OSGALLERY_OPTION_RABBET")?></option>
                                <option <?php echo ($imgMask == "Rhombus")?'selected="selected"':''?> value="Rhombus"><?php echo JText::_("COM_OSGALLERY_OPTION_RHOMBUS")?></option>
                                <option class="disabled" disabled="" value="Right_arrow"><?php echo JText::_("COM_OSGALLERY_OPTION_RIGHT_ARROW")?></option>
                                <option class="disabled" disabled="" value="Right_Chevron"><?php echo JText::_("COM_OSGALLERY_OPTION_RIGHT_CHEVRON")?></option>
                                <option class="disabled" disabled="" value="Right_Point"><?php echo JText::_("COM_OSGALLERY_OPTION_RIGHT_POINT")?></option>
                                
                                <option class="disabled" disabled="" value="Star"><?php echo JText::_("COM_OSGALLERY_OPTION_STAR")?></option>
                                
                                <option <?php echo ($imgMask == "Trapezoid")?'selected="selected"':''?> value="Trapezoid"><?php echo JText::_("COM_OSGALLERY_OPTION_TRAPEZOID")?></option>
                                <option <?php echo ($imgMask == "Triangle")?'selected="selected"':''?> value="Triangle"><?php echo JText::_("COM_OSGALLERY_OPTION_TRIANGLE")?></option>
                            </select>
                        </span>
                    </div>
                    <div id="background_color" <?php echo ($imgMask == "none")?'style="display:none;"':'';?>>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_BACKGROUND_COLOR")?></span>
                        <span class="sett-col-2">
                            <input type="text" name="background_color" value="<?php echo $background_color?>">
                        </span>
                    </div>
<!--                    <div id="tag_or_category" <?php echo ($imgMask == "none")?'style="display:none;"':'';?>>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_TAG_OR_CATEGORY")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="general-tag_or_category-enable-yes" type="radio" name="tag_or_category" value="1" <?php echo $tag_or_category?'checked':''?>/>
                                <input id="general-tag_or_category-enable-no" type="radio" name="tag_or_category" value="0" <?php echo $tag_or_category?'':'checked'?>/>
                                <label for="general-tag_or_category-enable-yes" data-value="Category">Category</label>
                                <label for="general-tag_or_category-enable-no" data-value="Tag">Tag</label>
                            </div>
                        </span>
                    </div>-->
                    <span class="clearfix"></span>

                        <h4 class="load_more_title"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_LOAD_MORE_BLOCK");?></h4>

                    <div class="main-load-more-block">
                        <div>
                            <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_SHOW_LOAD_MORE_TYPE")?></span>
                            <span class="cat-col-2">
                                <select class="showLoadMoreOptions" name="showLoadMore" <?php echo ($gallerylayout == "allInOne" || $gallerylayout == "allInOneRow") ? 'style="display:none;"' : ''; ?>>
                                    <option selected="selected" value="0">None</option>
                                    <option class="disabled" disabled="" value="button"><?php echo JText::_("COM_OSGALLERY_SETTINGS_SHOW_LOAD_MORE_BY_BUTTON")?></option>
                                    <option class="disabled" disabled="" value="scroll"><?php echo JText::_("COM_OSGALLERY_SETTINGS_SHOW_LOAD_MORE_BY_SCROLL")?></option>

                                    <option class="disabled" disabled="" value="auto"><?php echo JText::_("COM_OSGALLERY_SETTINGS_SHOW_AUTO_LOAD_ALL_PICTURES")?></option>

                                </select>
                                
                            </span>
                        </div>

                        
                    </div>
                       <!-- end load more option -->
                    </div>
                </div>

                <div id="os_fancybox-settings" class="tab-pane fade osg-pro-avaible">
                    
                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_BACKGROUND_COLOR_SELECT_LABEL")?></span>
                        <span class="sett-col-2">
                            <select name="fancy_box_background">
                                <option <?php echo $fancy_box_background=="rgba(0, 0, 0, 0.75)"?'selected':''?> value="rgba(0, 0, 0, 0.75)"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_BACKGROUND_COLOR_SELECT_OPTION1")?></option>
                                <option <?php echo $fancy_box_background=="rgba(238,238,238,0.85)"?'selected':''?> value="rgba(238,238,238,0.85)"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_BACKGROUND_COLOR_SELECT_OPTION2")?></option>
                                <option <?php echo $fancy_box_background=="rgba(0,0,0,0)"?'selected':''?> value="rgba(0,0,0,0)"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_BACKGROUND_COLOR_SELECT_OPTION3")?></option>
                            </select>
                        </span>
                    </div>

                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_CLOSE_CLICK_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-close-yes" type="radio" name="click_close" value="1" <?php echo $click_close?'checked':''?>/>
                                <input id="os_fancybox-close-no" type="radio" name="click_close" value="0" <?php echo $click_close?'':'checked'?>/>
                                <label for="os_fancybox-close-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-close-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>

                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_OPEN_CLOSE_LABEL")?></span>
                        <span class="sett-col-2">
                            <select name="open_close_effect">
                                <option selected value="none"><?php echo JText::_("COM_OSGALLERY_OPTION_NONE")?></option>
                                
                            </select>
                        </span>
                    </div>

                    
                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_PREV_NEXT_EFFECT_LABEL")?></span>
                        <span class="sett-col-2">
                            <select name="prev_next_effect">
                                <option selected value="none"><?php echo JText::_("COM_OSGALLERY_OPTION_NONE")?></option>
                            </select>
                        </span>
                    </div>
           
                                
                    <div class="img-title-show">
                    <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_ENABLE_IMAGE_TITLE")?></span>
                        <span class="cat-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="general-min-imgtitle-yes" type="radio" name="showImgTitle" value="1" checked="true"/>
                                <input id="general-min-imgtitle-no" type="radio" name="showImgTitle" value="0" />
			        <label for="general-min-imgtitle-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="general-min-imgtitle-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>                            
                            </div>
                        </span>
                    </div>

                    <div class="img-description-show">
                    <span class="cat-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GENERAL_ENABLE_IMAGE_DESCRIPTION")?></span>
                        <span class="cat-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="general-min-imgdescription-yes" type="radio" name="showImgDescription" value="1" checked="true"/>
                                <input id="general-min-imgdescription-no" type="radio" name="showImgDescription" value="0" />
                                <label for="general-min-imgdescription-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="general-min-imgdescription-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>
            <!--         <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_IMAGE_TITLE_LABEL")?></span>
                        <span class="sett-col-2">
                            <select name="img_title">
                                <option <?php echo $img_title=="float"?'selected':''?> value="float">Float</option>
                                <option <?php echo $img_title=="inside"?'selected':''?> value="inside">Inside</option>
                                <option <?php echo $img_title=="outside"?'selected':''?> value="outside">Outside</option>
                                <option <?php echo $img_title=="over"?'selected':''?> value="over">Over</option>
                                <option <?php echo $img_title=="none"?'selected':''?> value="none">None</option>
                            </select>
                        </span>
                    </div> -->
                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_LOOP_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-loop-yes" type="radio" name="loop" value="1" />
                                <input id="os_fancybox-loop-no" type="radio" name="loop" value="0" checked="true"/>
                                <label for="os_fancybox-loop-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-loop-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>

                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_PREV_NEXT_ARROWS_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-arrows-yes" type="radio" name="os_fancybox_arrows" value="1" <?php echo $os_fancybox_arrows?'checked':''?>/>
                                <input id="os_fancybox-arrows-no" type="radio" name="os_fancybox_arrows" value="0" <?php echo $os_fancybox_arrows?'':'checked'?>/>
                                <label for="os_fancybox-arrows-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-arrows-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>

                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_NEXT_CLICK_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-next-yes" type="radio" name="next_click" value="1" <?php echo $next_click?'checked':''?>/>
                                <input id="os_fancybox-next-no" type="radio" name="next_click" value="0" <?php echo $next_click?'':'checked'?>/>
                                <label for="os_fancybox-next-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-next-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>

                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_MOUSE_WHEEL_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-mouse-yes" type="radio" name="mouse_wheel" value="1" />
                                <input id="os_fancybox-mouse-no" type="radio" name="mouse_wheel" value="0" checked="true"/>
                                <label for="os_fancybox-mouse-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-mouse-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>
                    <!-- infobar (counter) -->
                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_INFOBAR_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-infobar-yes" type="radio" name="infobar" value="1" <?php echo $infobar?'checked':''?>/>
                                <input id="os_fancybox-infobar-no" type="radio" name="infobar" value="0" <?php echo $infobar?'':'checked'?>/>
                                <label for="os_fancybox-infobar-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-infobar-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>

                    <!-- Buttons block -->

                    <div><h4>Buttons in panel</h4></div>
                    <!-- start_slideshow_button -->
                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_START_SLIDESHOW_BUTTON_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-start_slideshow_button-yes" type="radio" name="start_slideshow_button" value="1" <?php echo $start_slideshow_button?'checked':''?>/>
                                <input id="os_fancybox-start_slideshow_button-no" type="radio" name="start_slideshow_button" value="0" <?php echo $start_slideshow_button?'':'checked'?>/>
                                <label for="os_fancybox-start_slideshow_button-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-start_slideshow_button-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>
                   <!-- slideshow_autoplay_speed -->
                    <div class="autoplay-helper-block" <?php if($os_fancybox_autoplay == '0'){echo "style='display:none'";}?> >
                        <span class="sett-col-1"><?php echo '- '.JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_AUTOPLAY_SPEED_LABEL")?></span>
                        <span class="sett-col-2">
                            <input type="text" name="autoplay_speed" value="<?php echo $autoplay_speed?>"/>
                        </span>
                    </div>
                    <!-- slideshow_autoplay -->
                    <div>
                        <span class="sett-col-1"><?php echo '- '.JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_AUTOPLAY_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-autoplay-yes" type="radio" name="os_fancybox_autoplay" value="1" <?php echo $os_fancybox_autoplay?'checked':''?>/>
                                <input id="os_fancybox-autoplay-no" type="radio" name="os_fancybox_autoplay" value="0" <?php echo $os_fancybox_autoplay?'':'checked'?>/>
                                <label for="os_fancybox-autoplay-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-autoplay-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>
                    <!-- full_screen_button -->
                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_FULL_SCREEN_BUTTON_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-full_screen_button-yes" type="radio" name="full_screen_button" value="1" <?php echo $full_screen_button?'checked':''?>/>
                                <input id="os_fancybox-full_screen_button-no" type="radio" name="full_screen_button" value="0" <?php echo $full_screen_button?'':'checked'?>/>
                                <label for="os_fancybox-full_screen_button-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-full_screen_button-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>
                    <!-- thumbnails_button -->
                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_THUMBNAILS_BUTTON_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-thumbnails_button-yes" type="radio" name="thumbnails_button" value="1" <?php echo $thumbnails_button?'checked':''?>/>
                                <input id="os_fancybox-thumbnails_button-no" type="radio" name="thumbnails_button" value="0" <?php echo $thumbnails_button?'':'checked'?>/>
                                <label for="os_fancybox-thumbnails_button-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-thumbnails_button-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>
                    <!-- thumbnail_autostart -->
                    <div>
                        <span class="sett-col-1"><?php echo '- '.JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_HELPERS_THUMBNAIL_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-thumbnail-yes" type="radio" name="helper_thumbnail" value="1" />
                                <input id="os_fancybox-thumbnail-no" type="radio" name="helper_thumbnail" value="0" checked="true"/>
                                <label for="os_fancybox-thumbnail-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-thumbnail-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>
                    <!-- thumbnail position -->
                    <div>
                        <span class="sett-col-1"><?php echo '- '.JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_THUMBNAIL_POSITION_LABEL")?></span>
                        <span class="sett-col-2">
                            <select name="os_fancybox_thumbnail_position">
                                <option <?php echo $os_fancybox_thumbnail_position=="thumb_right"?'selected':''?> value="thumb_right">Right</option>
                                <option <?php echo $os_fancybox_thumbnail_position=="thumb_bottom"?'selected':''?> value="thumb_bottom">Bottom</option>
                            </select>
                        </span>
                    </div>
                    <!-- share_button -->
                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_SHARE_BUTTON_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-share_button-yes" type="radio" name="share_button" value="1" <?php echo $share_button?'checked':''?>/>
                                <input id="os_fancybox-share_button-no" type="radio" name="share_button" value="0" <?php echo $share_button?'':'checked'?>/>
                                <label for="os_fancybox-share_button-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-share_button-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>
                    <!-- download_button -->
                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_DOWNLOAD_BUTTON_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-download_button-yes" type="radio" name="download_button" value="1" <?php echo $download_button?'checked':''?>/>
                                <input id="os_fancybox-download_button-no" type="radio" name="download_button" value="0" <?php echo $download_button?'':'checked'?>/>
                                <label for="os_fancybox-download_button-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-download_button-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>
                    <!-- zoom_button -->
                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_FANCYBOX_ZOOM_BUTTON_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-zoom_button-yes" type="radio" name="zoom_button" value="1" <?php echo $zoom_button?'checked':''?>/>
                                <input id="os_fancybox-zoom_button-no" type="radio" name="zoom_button" value="0" <?php echo $zoom_button?'':'checked'?>/>
                                <label for="os_fancybox-zoom_button-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-zoom_button-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>
                    <!-- left_arrow -->
                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_LEFT_ARROW_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-left_arrow-yes" type="radio" name="left_arrow" value="1" <?php echo $left_arrow?'checked':''?>/>
                                <input id="os_fancybox-left_arrow-no" type="radio" name="left_arrow" value="0" <?php echo $left_arrow?'':'checked'?>/>
                                <label for="os_fancybox-left_arrow-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-left_arrow-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>
                    <!-- right_arrow -->
                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_RIGHT_ARROW_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-right_arrow-yes" type="radio" name="right_arrow" value="1" <?php echo $right_arrow?'checked':''?>/>
                                <input id="os_fancybox-right_arrow-no" type="radio" name="right_arrow" value="0" <?php echo $right_arrow?'':'checked'?>/>
                                <label for="os_fancybox-right_arrow-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-right_arrow-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>
                    <!-- close_button -->
                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_OS_CLOSE_BUTTON_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-close_button-yes" type="radio" name="close_button" value="1" <?php echo $close_button?'checked':''?>/>
                                <input id="os_fancybox-close_button-no" type="radio" name="close_button" value="0" <?php echo $close_button?'':'checked'?>/>
                                <label for="os_fancybox-close_button-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-close_button-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>
                    <!-- Buttons block -->
                </div>
                <!-- WATERMARK -->
                <div id="watermark-settings" class="tab-pane fade osg-pro-avaible">
                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_ENABLE_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-watermark-yes" type="radio" name="watermark_enable" value="1" <?php echo $watermark_enable?'checked':''?>/>
                                <input id="os_fancybox-watermark-no" type="radio" name="watermark_enable" value="0" <?php echo $watermark_enable?'':'checked'?>/>
                                <label for="os_fancybox-watermark-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="os_fancybox-watermark-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>

                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_TYPE_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="os_fancybox-watermark-image" type="radio" name="watermark_type" value="1" <?php echo $watermark_type?'checked':''?>/>
                                <input id="os_fancybox-watermark-text" type="radio" name="watermark_type" value="0" <?php echo $watermark_type?'':'checked'?>/>
                                <label for="os_fancybox-watermark-image" data-value="Image">Image</label>
                                <label for="os_fancybox-watermark-text" data-value="Text">Text</label>
                            </div>
                        </span>
                    </div>

                    <div id="watermark-image-block" <?php echo ($watermark_type == 0)?'style="display:none;"' : ""?> >
                        <div>
                            <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_SELECT_LABEL")?></span>
                            <span class="sett-col-2">
                                <div class="file-upload">
                                    <button class="file-upload-button" type="button">Select</button>
                                    <div class="none-upload"><?php echo $watermark_file?$watermark_file:'No file chosen.'?></div>
                                    <input id="watermark-input" type="file" name="watermark_file" value="">
                                    <input type="hidden" name="exist_watermark_file" value="<?php echo $watermark_file?>">
                                    <input type="hidden" name="old_watermark_file" value="<?php echo $watermark_file?>">
                                </div>
                            </span>
                        </div>

                        <div>
                            <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_SIZE_LABEL")?></span>
                            <span class="sett-col-2">
                                <input type="number" min="5" max="100" name="watermark_size" value="<?php echo $watermark_size?>">
                            </span>
                        </div>
                    </div>
                    <div id="watermark-text-block" <?php echo ($watermark_type == 1)?'style="display:none;"' : ""?> >
                        <div>
                            <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_TEXT_LABEL")?></span>
                            <span class="sett-col-2">
                                <input type="text" name="watermark_text" value="<?php echo $watermark_text?>" maxlength="50">
                                <input type="hidden" name="exist_watermark_text" value="<?php echo $exist_watermark_text?>">
                            </span>
                        </div>

                        <div>
                            <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_SIZE_LABEL")?></span>
                            <span class="sett-col-2">
                                <input type="number" min="5" max="50" name="watermark_text_size" value="<?php echo $watermark_text_size?>">
                            </span>
                        </div>
                        <div>
                            <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_FONT")?></span>
                            <span class="sett-col-2">
                                <select name="watermark_font">
                                    <option <?php echo $watermark_font=="default"?'selected':''?> value="default">Default</option>
                                    <option <?php echo $watermark_font=="lobster"?'selected':''?> value="lobster">Lobster</option>
                                </select>
                                <input type="hidden" name="watermark_font_selected" value="<?php echo $watermark_font?>">
                            </span>
                        </div>

                        <div>
                            <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_FONT_COLOR_LABEL")?></span>
                            <span class="sett-col-2">
                                <input type="text" name="watermark_text_color" value="<?php echo $watermark_text_color?>">
                            </span>
                        </div>

                        <div>
                            <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_ANGLE_LABEL")?></span>
                            <span class="sett-col-2">
                                <div class="osgallery-checkboxes-block">
                                <input id="watermark-angle-0" type="radio" name="watermark_text_angle" <?php echo(($watermark_text_angle == 0)?'checked="checked"':'')?> value="0">
                                <input id="watermark-angle-45" type="radio" name="watermark_text_angle" <?php echo(($watermark_text_angle == 45)?'checked="checked"':'')?> value="45">
                                <input id="watermark-angle-90" type="radio" name="watermark_text_angle" <?php echo(($watermark_text_angle == 90)?'checked="checked"':'')?> value="90">
                                <label for="watermark-angle-0" data-value="0">0</label>
                                <label for="watermark-angle-45" data-value="45">45</label>
                                <label for="watermark-angle-90" data-value="90">90</label>
                            </div>
                            </span>
                        </div>
                    </div>
                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_POSITION_LABEL")?></span>
                        <span class="sett-col-2">
                            <select name="watermark_position">
                                <option <?php echo $watermark_position=="top_right"?'selected':''?> value="top_right"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_POSITION_LABEL_TOPRIGHT")?></option>
                                <option <?php echo $watermark_position=="top_left"?'selected':''?> value="top_left"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_POSITION_LABEL_TOPLEFT")?></option>
                                <option <?php echo $watermark_position=="center"?'selected':''?> value="center"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_POSITION_LABEL_CENTER")?></option>
                                <option <?php echo $watermark_position=="bottom_right"?'selected':''?> value="bottom_right"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_POSITION_LABEL_BOTTOMRIGHT")?></option>
                                <option <?php echo $watermark_position=="bottom_left"?'selected':''?> value="bottom_left"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_POSITION_LABEL_BOTTOMLEFT")?></option>
                            </select>
                            <input type="hidden" name="watermark_position_selected" value="<?php echo $watermark_position?>">
                        </span>
                    </div>

                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_WATERMARK_OPACITY_LABEL")?></span>
                        <span class="sett-col-2">
                            <input type="number" min="0" max="100" name="watermark_opacity" value="<?php echo $watermark_opacity?>">
                        </span>
                    </div>
                </div>
                <!-- Social Buttons Settings -->
                <div id="social-settings" class="tab-pane fade osg-pro-avaible">

                    <div> 
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_FACEBOOK_ENABLE_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="social-facebook-yes" type="radio" name="facebook_enable" value="1" <?php echo $facebook_enable?'checked':''?>/>
                                <input id="social-facebook-no" type="radio" name="facebook_enable" value="0" <?php echo $facebook_enable?'':'checked'?>/>
                                <label for="social-facebook-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="social-facebook-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div> 

<!--                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_GOOGLEPLUS_ENABLE_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="social-googleplus-yes" type="radio" name="googleplus_enable" value="1" <?php echo $googleplus_enable?'checked':''?>/>
                                <input id="social-googleplus-no" type="radio" name="googleplus_enable" value="0" <?php echo $googleplus_enable?'':'checked'?>/>
                                <label for="social-googleplus-yes" data-value="Yes">Yes</label>
                                <label for="social-googleplus-no" data-value="No">No</label>
                            </div>
                        </span>
                    </div>-->

                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_VKONTACTE_ENABLE_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="social-vkontacte-yes" type="radio" name="vkontacte_enable" value="1" <?php echo $vkontacte_enable?'checked':''?>/>
                                <input id="social-vkontacte-no" type="radio" name="vkontacte_enable" value="0" <?php echo $vkontacte_enable?'':'checked'?>/>
                                <label for="social-vkontacte-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="social-vkontacte-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>

                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_ODNOKLASSNIKI_ENABLE_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="social-odnoklassniki-yes" type="radio" name="odnoklassniki_enable" value="1" <?php echo $odnoklassniki_enable?'checked':''?>/>
                                <input id="social-odnoklassniki-no" type="radio" name="odnoklassniki_enable" value="0" <?php echo $odnoklassniki_enable?'':'checked'?>/>
                                <label for="social-odnoklassniki-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="social-odnoklassniki-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>

                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_TWITTER_ENABLE_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="social-twitter-yes" type="radio" name="twitter_enable" value="1" <?php echo $twitter_enable?'checked':''?>/>
                                <input id="social-twitter-no" type="radio" name="twitter_enable" value="0" <?php echo $twitter_enable?'':'checked'?>/>
                                <label for="social-twitter-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="social-twitter-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>

                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_PINTEREST_ENABLE_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="social-pinterest-yes" type="radio" name="pinterest_enable" value="1" <?php echo $pinterest_enable?'checked':''?>/>
                                <input id="social-pinterest-no" type="radio" name="pinterest_enable" value="0" <?php echo $pinterest_enable?'':'checked'?>/>
                                <label for="social-pinterest-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="social-pinterest-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>                    

                    <div>
                        <span class="sett-col-1"><?php echo JText::_("COM_OSGALLERY_SETTINGS_LINKEDIN_ENABLE_LABEL")?></span>
                        <span class="sett-col-2">
                            <div class="osgallery-checkboxes-block">
                                <input id="social-linkedin-yes" type="radio" name="linkedin_enable" value="1" <?php echo $linkedin_enable?'checked':''?>/>
                                <input id="social-linkedin-no" type="radio" name="linkedin_enable" value="0" <?php echo $linkedin_enable?'':'checked'?>/>
                                <label for="social-linkedin-yes" data-value="Yes"><?php echo JText::_("COM_OSGALLERY_OPTION_YES")?></label>
                                <label for="social-linkedin-no" data-value="No"><?php echo JText::_("COM_OSGALLERY_OPTION_NO")?></label>
                            </div>
                        </span>
                    </div>

                </div>

            </div>
        </div>
    </div>
    <input type="hidden" name="option" value="com_osgallery"/>
    <input type="hidden" name="task" value="save_gallery"/>
    <input id="catOrderIds" type="hidden" name="catOrderIds" value=""/>
    <input id="galerryId" type="hidden" name="galId" value="<?php echo $galId?>"/>
    <input id="hidden-title" type="hidden" name="gallery_title" value="<?php echo $galeryTitle?>"/>
    <input id="imageOrderingArr" type="hidden" name="imageOrderingArr" value=""/>
    
</form>

<!--<script src="components/com_osgallery/assets/js/jquery-ui.min.js" type="text/javascript"></script>
<script src="components/com_osgallery/assets/js/jquery.slider.minicolors.js" type="text/javascript"></script>
<script src="components/com_osgallery/assets/js/jquery.json.js" type="text/javascript"></script>-->
<script language="JavaScript">
watermark_file = '';
debug = false;
    String.prototype.replaceAll = function (replaceThis, withThis) {
        if(debug){
            console.log('replaceAll', {replaceThis}, {withThis})
        }
       var re = new RegExp(replaceThis,"g"); 
       return this.replace(re, withThis);
    };

    var catId = <?php echo $activeIndex?>;
    var activeId = jQuerOs("#osgalery-cat-tabs a:first").data("cat-id");
    var galId = <?php echo $galId?>;
    jQuerOs(document).ready(function(){
//    window.addEventListener('load', function() {

        jQuerOs("button.upload-folder-btn, button.upload-zip-btn").unbind('click');
        jQuerOs("button.upload-folder-btn, button.upload-zip-btn").click(function(event){
            if(debug){
                console.log('button.upload-folder-btn, button.upload-zip-btn', 'click')
            }
            event.preventDefault();

            var checkZip = jQuerOs(this).closest('.upload-zip-wrap').find("input[name=uploadZip]").val(); 
            // #fileUpload is to a input element of the type file
            if(checkZip != undefined){  
                var file = jQuerOs(this).closest('.upload-zip-wrap').find("input[name=uploadZip]")[0].files[0]
                var zip = new FormData();
                zip.append('uploadZip', file, 'uploadZip');
            }else{
                var zip = undefined;
            }

            var folder = jQuerOs(this).closest('.upload-folder-wrap').find("input[name=uploadFolder]").val();

            var pathFolder = "";
            var pathZip = "";
            var task = "";

            if(zip != undefined){
                task = "upload_zip";
                pathZip = zip;
            }else if(folder != undefined){
                task = "upload_folder";
                pathFolder = folder;
            }
            
            jQuerOs.ajax({
                type: 'POST',
                // dataType: 'json',
                processData:false,
                contentType:false,
                url: '<?php echo JURI::current()?>?option=com_osgallery&task='+task+'&catId='+activeId+'&galId='+galId+'&path='+pathFolder+'&format=raw',
                data: pathZip,
                beforeSend: function(){
                    jQuerOs(".upload-zip-wrap, .upload-folder-wrap, .upload-file-wrap")
                        .css({display:"none"});
                    jQuerOs('div.upload-loader').css({display:"block"});
                },
                complete: function(){
                    jQuerOs(".upload-zip-wrap, .upload-folder-wrap, .upload-file-wrap")
                        .css({display:"block"});
                    jQuerOs('div.upload-loader').css({display:"none"});
                },
                success:function(responce){

                    var responce = responce.replaceAll("}{","}|||{");
                    responce = responce.replaceAll(['{','}'],'');
                    responce = responce.split('|||');
                    
                    for(var i = 0; i < responce.length; i++){

                        var data = JSON.parse(responce[i]); 
                        if(!data.success){

                        }else{

                            fileName = data.file;
                            ext = data.ext;
                            imgId = data.id;

                            image = '<div id="img-'+imgId+'" class="img-block" data-image-id="'+imgId+'">'+
                                      '<span class="delete-image"><i class="material-icons">close</i></span>'+
                                      '<img src="<?php echo JURI::root()?>images/com_osgallery/gal-'+galId+'/thumbnail_165_110/'+fileName+ext+'" alt="'+fileName+'">'+
                                      '<input id="img-settings-'+imgId+'-'+activeId+'" type="hidden" name="imgSettings['+imgId+']" value="<?php echo osGalleryHelperAdmin::getDefaultImageSettings(); ?>">'+
                                      '<div class="img_block_bg"></div>' +
                                    '</div>';
                            jQuerOs("#cat-"+activeId+" .cat-img-ordering").before(image);
//                            jQuerOs("#cat-"+activeId).append(image);
                            makeDeleteImage();
                            if(jQuerOs(".qq-upload-list li").not('.qq-upload-success').length == 0){
                                setTimeout(function(){
                                    uploader.clearStoredFiles();
                                }, 5000);
                            }
//                            makeCatSortable();
//                            imgSettingsFunctions();
                        }
                    }
                    removeListener();
                    makeCatSortable();
                    imgSettingsFunctions();
//                    prevNextImgOption()


                },
                error:function(){
                    // alert('Unknown error occurred');
                }

            });

        })
        
        showHideSetting();
        showHideCategoryTitleHeight();
        
        jQuerOs('#externalGallerySettings').on('change', function(){
            if(debug){
                console.log('#externalGallerySettings', 'change')
            }
            showHideSetting();
        })

        jQuerOs('#cat-title-position').on('change', function(){
            if(debug){
                console.log('#cat-title-position', 'change')
            }
            showHideCategoryTitleHeight();
        })

        galerryTrigger = true;

        //colorpicker
        jQuerOs("[name='watermark_text_color'], [name='load_more_background'], [name='background_color']").minicolors({
            control: "hue",
            defaultValue: "",
            format:"rgb",
            opacity: true,
            position: "top right",
            hideSpeed: 100,
            inline: false,
            theme: "bootstrap",
            change: function(value, opacity) {
              jQuerOs(this).attr("value",value);
            }
        });
        
        //global counters
//        var catId = <?php echo $activeIndex?>;
//        var activeId = jQuerOs("#osgalery-cat-tabs a:first").data("cat-id");
//        var galId = <?php echo $galId?>

        jQuerOs(".add-new-cat").click(function(event) {
            if(debug){
                console.log('.add-new-cat', 'click')
            }
            if(jQuerOs("#new-cat-name")){
                jQuerOs(".save-cat-name").trigger('click');
            }
            //native js faster
            catId++;

            //create new li
            var li = document.createElement('li');
            li.id = "order-id-"+catId;
            li.innerHTML = '<a href="#cat-'+catId+'" data-cat-id="'+catId+'">Category Title</a>'+
                            '<input type="hidden" name="category_names[]" value="'+catId+'|+|Category Title" placeholder="">'+
                            '<span class="edit-category-name"><i class="material-icons">mode_edit</i>'+
            'edit</span>'+
                            '<span class="delete-category"><i class="material-icons">delete</i></span>';
            list = document.getElementById("osgalery-cat-tabs");
            list.insertBefore(li, list.children[list.children.length-1]);

            //create new tab content
            var div = document.createElement('div');
            div.id = 'cat-'+catId;
            div.className = 'tab-pane fade';
            div.innerHTML = '<input class="cat-img-ordering" type="hidden" name="imageOrdering['+catId+']" value="">'+
                            '<input id="cat-settings-'+catId+'" type="hidden" name="catSettings['+catId+']" value="%7B%22categoryAlias%22%3A%22%22%2C%22categoryDescription%22%3A%22%22%2C%22categoryShowTitle%22%3Atrue%2C%22catTitlePosition%22%3A%22onImage%22%2C%22catTitleHeight%22%3A%220%22%2C%22categoryUnpublish%22%3Afalse%7D">';
            list = document.getElementById("os-cat-tab-images");
            list.insertBefore(div, list.children[list.children.length-1]);
            makeTabsCliked();

            //activated tab
            activeId = catId;
//            jQuerOs("#osgalery-cat-tabs a[href='#cat-"+activeId+"'").tab('show');
            if(typeof bootstrap !== "undefined"){
                jQuerOs('#osgalery-cat-tabs a').each(function(index, el){
                    if(jQuerOs(el).attr('data-cat-id') !== activeId){
                        var this_cat = jQuerOs(el).attr('data-cat-id')
                        jQuerOs(el).removeClass('active')
                        jQuerOs(el).removeClass('show')
                        jQuerOs('#cat-'+this_cat).removeClass('active')
                        jQuerOs('#cat-'+this_cat).removeClass('show')
                        jQuerOs("#osgalery-cat-tabs a[href='#cat-"+this_cat+"'").parent().removeClass('active')

                    }
                })
                if(jQuerOs("#osgalery-cat-tabs a[href='#cat-"+activeId+"'").length > 0){
                    var element = jQuerOs("#osgalery-cat-tabs a[href='#cat-"+activeId+"'")[0]
                    var b_tab = new bootstrap.Tab(element)
                    b_tab.show()
                }else{
                    var b_tab = new bootstrap.Tab(jQuerOs("#osgalery-cat-tabs a[href='#cat-"+activeId+"'"))
                    b_tab.show()
                }
            }else{
                jQuerOs("#osgalery-cat-tabs a[href='#cat-"+activeId+"'").tab('show');
            }
            
            //update settings
            catSettings = window.JSON.parse('{}');
            jQuerOs("#cat-alias").val(catSettings.categoryAlias || '');
            jQuerOs("#cat-desc").val(catSettings.categoryDescription || '');
            jQuerOs("#cat-title-position").val(catSettings.catTitlePosition || '');
            jQuerOs("#cat-title-height-block").val(catSettings.catTitleHeight || 0);
            showHideCategoryTitleHeight();
            //jQuerOs("#cat-unpublish").prop("checked",!catSettings.categoryUnpublish);
            if (catSettings.categoryUnpublish != undefined) {
                if (catSettings.categoryUnpublish == false) jQuerOs('#cat-publish-yes').attr("checked",true);
                if (catSettings.categoryUnpublish == true) jQuerOs('#cat-publish-no').attr("checked",true);
            } else {
                jQuerOs('#cat-publish-yes').attr("checked",true);
            }
            //jQuerOs("#cat-show-title").prop("checked",catSettings.categoryShowTitle);
            if (catSettings.categoryShowTitle != undefined) {
                if (catSettings.categoryShowTitle == true) jQuerOs('#cat-show-title-yes').attr("checked",true);
                if (catSettings.categoryShowTitle == false) jQuerOs('#cat-show-title-no').attr("checked",true);
            } else {
                jQuerOs('#cat-show-title-yes').attr("checked",true);
            }
            jQuerOs("#cat-show-cat-title-caption").prop("checked",catSettings.categoryShowTitleCaption);
//            jQuerOs(".category-options-block a:last").tab('show');
            if(typeof bootstrap !== "undefined"){
                if(jQuerOs(".category-options-block a:last").length > 0){
                    var element = jQuerOs(".category-options-block a:last")[0]
                    var b_tab = new bootstrap.Tab(element)
                    b_tab.show()
                }else{
                    var b_tab = new bootstrap.Tab(jQuerOs(".category-options-block a:last"))
                    b_tab.show()
                }
            }else{
                jQuerOs(".category-options-block a:last").tab('show');
            }
            //update settings
            imgSettings = window.JSON.parse('{}');
            jQuerOs("#img-title").val(imgSettings.imgTitle || '');
            jQuerOs("#video-link").val(imgSettings.videoLink || '');
            // jQuerOs("#img-alias").val(imgSettings.imgAlias || '');
            jQuerOs("#img-short-description").val(imgSettings.imgShortDescription || '');
            jQuerOs("#img-html").val(imgSettings.imgHtml || '');
            jQuerOs("#img-alt").val(imgSettings.imgAlt || '');
            jQuerOs("#img-link").val(imgSettings.imgLink || '');
            jQuerOs("#img-link-open").val(imgSettings.imgLinkOpen || '_blank');
            jQuerOs("#html-position-img").val(imgSettings.htmlPosition || 'bottom');


            if (imgSettings.imgHtmlShow) {
                if (imgSettings.imgHtmlShow == "yes") jQuerOs("#general-img-html").find('#general-img-html-yes').attr("checked",true);
                if (imgSettings.imgHtmlShow == "no") jQuerOs("#general-img-html").find('#general-img-html-no').attr("checked",true);
            } else {
                jQuerOs("#general-img-html").find('#general-img-html-yes').attr("checked",true);
            }

            if (imgSettings.htmlWidthAsImg) {
                if (imgSettings.htmlWidthAsImg == "yes") jQuerOs("#html-width-as-img").find('#html-width-as-img-yes').attr("checked",true);
                if (imgSettings.htmlWidthAsImg == "no") jQuerOs("#html-width-as-img").find('#html-width-as-img-no').attr("checked",true);
            } else {
                jQuerOs("#html-width-as-img").find('#html-width-as-img-yes').attr("checked",true);
            }

            if (imgSettings.img_publish) {
                if (imgSettings.img_publish == "yes") jQuerOs("#img_publish").find('#img_publish-yes').attr("checked",true);
                if (imgSettings.img_publish == "no") jQuerOs("#img_publish").find('#img_publish-no').attr("checked",true);
            } else {
                jQuerOs("#img_publish").find('#img_publish-yes').attr("checked",true);
            }
            jQuerOs('#imgCats').append('<option value="'+catId+'">Category Title</option>');




            //reload uploder params
            uploader.setParams({
                catId: activeId,
                galId: galId
            });
            makeCatSortable();
            catSettingsFunctions();
        });

    })
    
    function showHideSetting(){
        if(debug){
            console.log('showHideSetting')
        }
        var externalGallery = jQuerOs('#externalGallerySettings').val();
        
        if(externalGallery == 0){
            jQuerOs('.main-setting').slideDown(400);
            jQuerOs('#os_fancybox-settings, #watermark-settings, #social-settings').css('display', '');
        }else{
            jQuerOs('.main-setting, #os_fancybox-settings, #watermark-settings, #social-settings').slideUp(400);
        }
        
    }
    
    function showHideCategoryTitleHeight(){
        if(debug){
            console.log('showHideCategoryTitleHeight')
        }
        var titlePosition = jQuerOs('#cat-title-position').val()
        if(titlePosition == 'top' || titlePosition == 'bottom'){
            jQuerOs(".cat-title-height").slideDown(400);
        }else{
            jQuerOs(".cat-title-height").slideUp(400);
        }
        
    }
    
    

    //fn for find position of dom obj
    function findPosY(obj) {
        if(debug){
            console.log('findPosY', {obj})
        }
      var curtop = 0;
      if(obj.offsetParent){
        while(1){
          curtop+=obj.offsetTop;
          if(!obj.offsetParent){
            break;
          }
          obj=obj.offsetParent;
        }
      }else if (obj.y){
        curtop+=obj.y;
      }
      return curtop-100;
    }
  //end

    //on save
    jQuerOs(document).ready(function(){
//    window.addEventListener('load', function() {
        Joomla.submitbutton = function(pressbutton) {
            if(debug){
                console.log('Joomla.submitbutton', {pressbutton})
            }
            if(pressbutton =='open_gallery_settings'){
                
                if(galerryTrigger){
                    jQuerOs("#system-message-container").removeClass('gallery-main');
                    jQuerOs("#system-message-container").addClass('gallery-settings');
//                    jQuerOs(".main-gallery-header a:last").tab('show');
                    
                    if(typeof bootstrap !== "undefined"){
                        if(jQuerOs(".main-gallery-header a:last").length > 0){
                            var element = jQuerOs(".main-gallery-header a:last")[0]
                            var b_tab = new bootstrap.Tab(element)
                            b_tab.show()
                            var element_hide = jQuerOs(".main-gallery-header a:first")[0]
                            jQuerOs(element_hide).removeClass('show')
                            jQuerOs(element_hide).removeClass('active')
                            jQuerOs('#gallery-main-tab').removeClass('active')
                            jQuerOs('#gallery-main-tab').removeClass('show')
//                            jQuerOs('#gallery-main-tab').hide()
                            
//                            var h_tab = new bootstrap.Tab(element_hide)
//                            console.log('111111111111', h_tab.hide())
//                            h_tab.hide()
                        }else{
                            var b_tab = new bootstrap.Tab(".main-gallery-header a:last")
                            b_tab.show()
                        }
                    }else{
                        jQuerOs(".main-gallery-header a:last").tab('show');
                    }

//                    jQuerOs("#toolbar div:last button").html('Back to Gallery');
                    jQuerOs("#toolbar").children().last().find('button').html('Back to Gallery');
                    galerryTrigger = false;
                }else{
                    jQuerOs("#system-message-container").removeClass('gallery-settings');
                    jQuerOs("#system-message-container").addClass('gallery-main');
//                    jQuerOs(".main-gallery-header a:first").tab('show');
                    if(typeof bootstrap !== "undefined"){
                        if(jQuerOs(".main-gallery-header a:first").length > 0){
                            var element = jQuerOs(".main-gallery-header a:first")[0]
                            var b_tab = new bootstrap.Tab(element)
                            b_tab.show()
                            var element_hide = jQuerOs(".main-gallery-header a:last")[0]
                            jQuerOs(element_hide).removeClass('show')
                            jQuerOs(element_hide).removeClass('active')
                            jQuerOs('#gallery-settings-tab').removeClass('active')
                            jQuerOs('#gallery-settings-tab').removeClass('show')
//                            jQuerOs('#gallery-settings-tab').hide()
                        }else{
                            var b_tab = new bootstrap.Tab(".main-gallery-header a:first")
                            b_tab.show()
                        }
                        
                    }else{
                        jQuerOs(".main-gallery-header a:first").tab('show');
                    }

                    jQuerOs("#toolbar").children().last().find('button').html('<span class="icon-options"></span>Gallery Settings');
                    galerryTrigger = true;
                }
                return;
            }else if(pressbutton!='close_gallery'){
                jQuerOs("#catOrderIds").val(jQuerOs("#osgalery-cat-tabs").sortable( "toArray" ));
                jQuerOs("#os-cat-tab-images div.tab-pane").each(function(index, el) {
                   jQuerOs(this).find(".cat-img-ordering").val(jQuerOs(this).sortable( "toArray" ));
                });
                //check title
//                if(!jQuerOs('#gallery-title').val()){
//                    window.scrollTo(0,findPosY(jQuerOs('#gallery-title'))-100);
//                    alert('The "Gallery Name" field cannot be empty!');
//                    jQuerOs('#gallery-title').attr("placeholder", "<?php echo JText::_('Cannot be empty'); ?>");
//                    jQuerOs('#gallery-title').css("border-color","#FF0000");
//                    jQuerOs('#gallery-title').css("background","#FF0000");
//                    jQuerOs('#gallery-title').keypress(function() {
//                        jQuerOs('#gallery-title').css("border-color","gray");
//                        jQuerOs('#gallery-title').css("color","inherit");
//                    });
//                    return;
//                } else if (jQuerOs('#gallery-title').val()){
//                    jQuerOs('#gallery-title').css("background", "inherit");
//
//                }
                document.adminForm.task.value = pressbutton;
                if(pressbutton=='save_gallery' || pressbutton=='save_close_galery'){
                    if(jQuerOs("#new-cat-name")){
                        jQuerOs(".save-cat-name").trigger('click');
                    }
                    var sortingObj = {};
                    jQuerOs('.cat-img-ordering').each(function(){
                        var cat_elem = jQuerOs(this).parents('[id^=cat-]').attr('id')
                        var catId = cat_elem.substr(4)
                        sortingObj[catId] = jQuerOs(this).val()
                    })
                    sortingObj = JSON.stringify(sortingObj)
                    
                    jQuerOs('#imageOrderingArr').val(sortingObj)

                    var inputArray = jQuerOs("#adminForm").serialize();

                    if(watermark_file != ''){
                        var filesFormData = new FormData;
                        filesFormData.append("watermark_file", watermark_file[0]);
                        filesFormData.append("galId", jQuerOs('#galerryId').val())
                        jQuerOs.ajax({
                            url: '?option=com_osgallery&task=save_watermark&format=raw',
                            type: 'POST',
                            data: filesFormData,
                            async: false,
                            cache: false,
                            contentType: false,
                            processData: false,
                            success: function (data) {

                            }
                        });
                    }
                    html = '<div id="gallery-waiting-spinner"><div class="gallery-wait-spinner">'+
                            'Please wait <div class="gallery-wait-bounce1"></div>'+
                            '<div class="gallery-wait-bounce2"></div>'+
                            '<div class="gallery-wait-bounce3"></div>'+
                            '</div></div>';
                    jQuerOs("body").prepend(html);
                    jQuerOs.ajax({
                        dataType: "json",
                        url: '?option=com_osgallery&task=save_gallery&format=raw',
                        type: 'POST',
                        data: {
                            formData: inputArray,
                            //filesFormData: watermark_file[0],
                        },

                        success: function (data) {

                            jQuerOs("#gallery-waiting-spinner").remove();

                            if (data.success) {
                                params = window.JSON.parse(data.params);
                                jQuerOs("[name='exist_watermark_file']").val(params.watermark_file);
                                html = '<div class="alert alert-success">'+
                                            '<h4 class="alert-heading">Message</h4>'+
                                            '<div class="alert-message">'+data.message+'</div>'+
                                        '</div>';
                                jQuerOs("#system-message-container").html(html);
                                jQuerOs(".category-options-block").addClass("category-options-block-message");
                                setTimeout(function(){
                                    jQuerOs("#system-message-container").empty();
                                     jQuerOs(".category-options-block").removeClass("category-options-block-message");
                                }, 3000);
                                if(pressbutton=='save_close_galery'){
                                    jQuerOs("button.button-cancel").trigger('click');
                                }
                            }else{
                                if(data.error_msgs != ''){ 
                                    var width = 'style="width: 90%"';
                                }else{
                                    var width = '';
                                }
                                html = '<div class="alert alert-error" '+width+'>'+
                                            '<h4 class="alert-heading">Message</h4>'+
                                            '<div class="alert-message">'+data.message+'</div>'+
                                            '<div class="alert-message">'+data.error_msgs+'</div>'+
                                        '</div>';
                                jQuerOs("#system-message-container").html(html);
                                jQuerOs(".category-options-block").addClass("category-options-block-message");

                              console.log('oops');
                            }
                        },
                        error:function(data){
                            //VlaDOS 11.02.2023
                            //Eta obrabotka byla dobavlena dlya polnoy obrabotki thumbnails dlya serverov kotorye ne reagiruyut na set_time_limit
                            //VlaDOS 11.02.2023 END
                            if(data.status == 500){
                                jQuerOs("#gallery-waiting-spinner").remove();
                                jQuerOs("[task=save_gallery] button.btn-success").trigger('click');
                            }
                            // console.log('11111111111111111', data.status)
                        }

                    });
                }else{
                    if(jQuerOs("#new-cat-name")){
                        jQuerOs(".save-cat-name").trigger('click');
                    }
                    document.adminForm.task.value = pressbutton;
                    document.adminForm.submit();
                }
            }else{
                document.adminForm.task.value = pressbutton;
                document.adminForm.submit();
            }
        };
    })
    jQuerOs(document).ready(function(){
//    window.addEventListener('load', function() {
        //uploaderz`
        uploader = new qq.FineUploader({
        /* other required config options left out for brevity */
            element: document.getElementById("fine-uploader"),
            template: 'qq-template',
            validation: {
                allowedExtensions: ['jpg', 'jpeg', 'png', 'gif', 'webp'],
                sizeLimit: '<?php echo $maxFileSize; ?>'
            },
            request: {
                endpoint: '<?php echo JURI::current()?>?option=com_osgallery&task=upload_images&format=raw',
                params: {
                  catId: activeId,
                  galId: galId
                }
            },
            callbacks: {
                onComplete: function (id, filename, responseJSON) {
                    if (!responseJSON.success) {
                    }else{
                        //create image
                        fileName = responseJSON.file;
                        ext = responseJSON.ext;
                        imgId = responseJSON.id;
                        image = '<div id="img-'+imgId+'" class="img-block" data-image-id="'+imgId+'">'+
                                  '<span class="delete-image"><i class="material-icons">close</i></span>'+
                                  '<img src="<?php echo JURI::root()?>images/com_osgallery/gal-'+galId+'/thumbnail_165_110/'+fileName+ext+'" alt="'+fileName+'">'+
                                  '<input id="img-settings-'+imgId+'-'+activeId+'" type="hidden" name="imgSettings['+imgId+']" value="<?php echo osGalleryHelperAdmin::getDefaultImageSettings(); ?>">'+
                                  '<div class="img_block_bg"><div class="block_bg_setting"></div></div>' +
                                '</div>';
                        jQuerOs("#cat-"+activeId+" .cat-img-ordering").before(image);
                        makeDeleteImage();
                        if(jQuerOs(".qq-upload-list li").not('.qq-upload-success').length == 0){
                            setTimeout(function(){
                                uploader.clearStoredFiles();
                            }, 5000);
                        }
                        removeListener();
                        makeCatSortable();
                        imgSettingsFunctions();
//                        prevNextImgOption()
                    }
                }
            }
        });
    })
//end

    //some click function
    function makeTabsCliked(){
        if(debug){
            console.log('makeTabsCliked')
        }
        jQuerOs("#osgalery-cat-tabs a").on('click', function(){
            var cat_id = jQuerOs(this).attr('data-cat-id')
            
            jQuerOs("#osgalery-cat-tabs a").each(function(index, el){
//                console.log('3333333333333', jQuerOs(el).attr('data-cat-id') !== cat_id)
                if(jQuerOs(el).attr('data-cat-id') !== cat_id){
                    var this_cat = jQuerOs(el).attr('data-cat-id')
                    jQuerOs(el).removeClass('active')
                    jQuerOs(el).removeClass('show')
                    jQuerOs('#cat-'+this_cat).removeClass('active')
                    jQuerOs('#cat-'+this_cat).removeClass('show')
                    
                }
            })
        })
        jQuerOs(".main-nav-tabs a,.settings-nav-tabs a,.upload-tabs a").click(function(e){
            if(debug){
                console.log('.main-nav-tabs a,.settings-nav-tabs a,.upload-tabs a', 'click')
            }
            e.preventDefault();
            if(jQuerOs(this).attr('href') == '#img-options-block'){
                jQuerOs('#img-options-block').addClass('active')
                jQuerOs('#img-options-block').addClass('show')
                jQuerOs('#cat-options-block').removeClass('active')
                jQuerOs('#cat-options-block').removeClass('show')
            }else{
                jQuerOs('#cat-options-block').addClass('active')
                jQuerOs('#cat-options-block').addClass('show')
                jQuerOs('#img-options-block').removeClass('active')
                jQuerOs('#img-options-block').removeClass('show')
            }
//            jQuerOs(this).tab('show');
            var href = jQuerOs(this).attr('href')

            jQuerOs(href).parent().find('.tab-pane').removeClass('active')
            jQuerOs(href).addClass('active')
            jQuerOs(this).parents('ul').find('li').removeClass('active')
            jQuerOs(this).parent().addClass('active')
            if(typeof bootstrap !== "undefined"){
                if(jQuerOs(this).length > 0){
                    var element = jQuerOs(this)[0]
                    var b_tab = new bootstrap.Tab(element)
                    b_tab.show()
                }else{
                    var b_tab = new bootstrap.Tab(jQuerOs(this))
                    b_tab.show()
                }
            }else{
                
                var href = jQuerOs(this).attr('href')
//              
                jQuerOs(href).parent().children().removeClass('active')
                jQuerOs(href).removeClass('fade')
                jQuerOs(href).addClass('active')
                jQuerOs(href).tab('show')
            }
        });

        //fn-for edit cat name
        jQuerOs(".edit-category-name").unbind('click');
        jQuerOs(".edit-category-name").click(function(event){
            if(debug){
                console.log('.edit-category-name', 'click')
            }
            if(jQuerOs("#new-cat-name")){
                jQuerOs(".save-cat-name").trigger('click');
            }
            jQuerOs("#osgalery-cat-tabs").sortable( "disable" );
            //short selectors
            li = jQuerOs(this).parent();
            a = li.find("a");
            li.children().hide();

            //add some tools for type new name
            li.append('<input id="new-cat-name" class="edit-cat-name" type="text" '+
                    'name="save_image" placeholder="type smth..." value="'+a.text()+'">'+
                    '<span class="save-cat-name edit-cat-name">Save</span>');
            //focus on input last symbol
            jQuerOs("#new-cat-name").focus();
            temp=jQuerOs("#new-cat-name").val();
            jQuerOs("#new-cat-name").val('');
            jQuerOs("#new-cat-name").val(temp);

            //save new name
            jQuerOs(".save-cat-name").click(function(event) {
                if(debug){
                    console.log('.save-cat-name', 'click')
                }
                jQuerOs('#imgCats').find('[value='+a.data("cat-id")+']').text(jQuerOs("#new-cat-name").val())
                a.text(jQuerOs("#new-cat-name").val());
                li.find("input:not(#new-cat-name)").val(a.data("cat-id")+'|+|'+jQuerOs("#new-cat-name").val());
                jQuerOs(".edit-cat-name").remove();
                li.children().show();
                jQuerOs("#osgalery-cat-tabs").sortable( "enable" );
            });

            //esc
            jQuerOs(document).keyup(function(e) {
                if (e.keyCode == 27) { // escape key maps to keycode `27`
                    jQuerOs(".edit-cat-name").remove();
                    li.children().show();
                    jQuerOs("#osgalery-cat-tabs").sortable( "enable" );
                }
            });

            //endter
            jQuerOs(document).keypress(function(e) {
                if(e.which == 13) {
                    jQuerOs(".save-cat-name").trigger( "click" );
                }
            });
        });

        //fn-s for delete cat with photos // we will delete photos later after save // maybe add restore button
        jQuerOs(".delete-category").click(function(event) {
            if(debug){
                console.log('.save-cat-name', 'click')
            }
            if(jQuerOs("#osgalery-cat-tabs li").length == 1){
                html = '<div class="alert alert-error">'+
                            '<h4 class="alert-heading">Message</h4>'+
                            '<div class="alert-message">You must have at list 1 category!</div>'+
                        '</div>';
                jQuerOs("#system-message-container").html(html)
                setTimeout(function(){
                  jQuerOs("#system-message-container").empty();
                }, 5000);
                return;
            }
            li = jQuerOs(this).parent();
            a = li.find("a");
            catId = a.data("cat-id");
            jQuerOs("#adminForm").append('<input type="hidden" name="deletedCatIds[]" value="'+catId+'">')
            jQuerOs(li).fadeOut(500, function(){ jQuerOs(this).remove();});
            jQuerOs("#cat-"+catId).fadeOut(500, function(){ jQuerOs(this).remove();});
            //activated 1st tab// if we delete current 1-st tab
            if(activeId == catId){
                //show first
//                jQuerOs("#osgalery-cat-tabs a:first").tab('show');
                if(typeof bootstrap !== "undefined"){
                    if(jQuerOs("#osgalery-cat-tabs a:first").length > 0){
                        var element = jQuerOs("#osgalery-cat-tabs a:first")[0]
                        var b_tab = new bootstrap.Tab(element)
                        b_tab.show()
                    }else{
                        var b_tab = new bootstrap.Tab("#osgalery-cat-tabs a:first")
                        b_tab.show()
                    }
                }else{
                    jQuerOs("#osgalery-cat-tabs a:first").tab('show');
                }
                //get new activeId
                activeId = jQuerOs("#osgalery-cat-tabs a:first").data("cat-id");

                //reload uploder params
                uploader.setParams({
                    catId: activeId,
                    galId: galId
                })
            }
        });
    }

    function parceOptions(string){
        if(debug){
            console.log('parceOptions', {string})
        }
        try{
            string = decodeURIComponent(string.replace(/\+/g, ' '));
            return window.JSON.parse(string);
        }catch(err){
            return window.JSON.parse('{}');
        }
    }

    //function for make category tab and images sortable
    function makeCatSortable(){
        if(debug){
            console.log('makeCatSortable()')
        }
        jQuerOs( "#osgalery-cat-tabs" ).sortable({
            handle: 'a',
            axis: false,
            items: "> li"
        });

        jQuerOs("#os-cat-tab-images div").sortable({
            // cancel: null, // Cancel the default events on the controls
            // helper: "clone",
            // revert: true,
            tolerance: "pointer",
            // handle: 'img',
            items: ".img-block",
        });
        // jQuerOs( "#os-cat-tab-images div" ).disableSelection();
    }
   
    //cat settings functions
    function catSettingsFunctions(){
        if(debug){
            console.log('catSettingsFunctions()')
        }
        //initialise first tab settings
        var deafult_lang = '<?php echo $default_lang_tag; ?>';
        var multilang = '<?php echo $multilang; ?>';
        
        var catSettings = parceOptions(jQuerOs("#cat-settings-"+activeId).val());
        
        for(key in catSettings){
            var sett = catSettings[key];
            if(jQuerOs("[name="+key+"]").length > 0){
                jQuerOs("[name="+key+"]").val(sett);
            }
            
        }
        showHideCategoryTitleHeight();

        
        if ( catSettings.categoryShowTitle != undefined) {
            if (catSettings.categoryShowTitle == true) jQuerOs("#cat-show-title-yes").trigger('click');
            if (catSettings.categoryShowTitle == false) jQuerOs("#cat-show-title-no").trigger('click');
        } else {
            if (catSettings.categoryShowTitle == true) jQuerOs("#cat-show-title-yes").trigger('click');
            jQuerOs("#cat-show-title-yes").attr("checked",true);
        }
        //jQuerOs("#cat-show-title").prop("checked",catSettings.categoryShowTitle);
        jQuerOs("#cat-show-cat-title-caption").prop("checked",catSettings.categoryShowTitleCaption);
        
        if ( catSettings.categoryShowTitle != undefined) {
            if (catSettings.categoryShowTitle == true) jQuerOs("#cat-show-title-yes").attr("checked",true);
            if (catSettings.categoryShowTitle == false) jQuerOs("#cat-show-title-no").attr("checked",true);
        } else {
            jQuerOs("#cat-show-title-yes").attr("checked",true);
        }
        jQuerOs("#cat-unpublish").prop("checked",true);
        // jQuerOs("#cat-show-title").prop("checked",true);
        // jQuerOs("#cat-show-title-yes").attr("checked",true);
        // jQuerOs("#cat-show-title-no").removeAttr("checked");
        // jQuerOs("#cat-show-title-yes").trigger('click');
        //end

        //change cat click function
        jQuerOs(".cat-nav-tabs a").click(function(e){
            e.preventDefault();
//            jQuerOs(this).tab('show');
            if(typeof bootstrap !== "undefined"){
                if(jQuerOs(this).length > 0){
                    var element = jQuerOs(this)[0]
                    var b_tab = new bootstrap.Tab(element)
                    b_tab.show()
                }else{
                    var b_tab = new bootstrap.Tab(jQuerOs(this))
                    b_tab.show()
                }
            }else{
                jQuerOs(this).tab('show');
            }
            jQuerOs('.cat-nav-tabs li').removeClass('active')
            jQuerOs(this).parent().addClass('active')
//            jQuerOs(".category-options-block a:last").tab('show');
            if(typeof bootstrap !== "undefined"){
                if(jQuerOs(".category-options-block a:last").length > 0){
                    var element = jQuerOs(".category-options-block a:last")[0]
                    var b_tab = new bootstrap.Tab(element)
                    b_tab.show()
                }else{
                    var b_tab = new bootstrap.Tab(".category-options-block a:last")
                    b_tab.show()
                }
            }else{
                jQuerOs(".category-options-block a:last").tab('show');
            }
            activeId = jQuerOs(this).data("cat-id");
            //reload uploder params
            uploader.setParams({
                catId: activeId,
                galId: galId
            })

            //update settings
            catSettings = parceOptions(jQuerOs("#cat-settings-"+activeId).val());
            
            if(Object.keys(catSettings).length == 0 ) {
                jQuerOs("#cat-alias").val('');
                jQuerOs("#cat-desc").val('');
                jQuerOs("#cat-title-position").val('onImage');
                jQuerOs("#cat-title-height-block").val(0);
                
                //jQuerOs("#cat-unpublish").prop("checked",true);
                //jQuerOs("#cat-show-title").prop("checked",true);
                jQuerOs("#cat-show-cat-title-caption").prop("checked",true);

            }else {
                for(key in catSettings){
                    var sett = catSettings[key];
                    if(jQuerOs("[name="+key+"]").length > 0){
                        jQuerOs("[name="+key+"]").val(sett);
                    }
                    
                }

                showHideCategoryTitleHeight();

                jQuerOs("#cat-show-cat-title-caption").prop("checked",catSettings.categoryShowTitleCaption);
            }
            if ( catSettings.categoryUnpublish != undefined) {
                if (catSettings.categoryUnpublish == false) jQuerOs("#cat-publish-yes").attr("checked",true);
                if (catSettings.categoryUnpublish == true) jQuerOs("#cat-publish-no").attr("checked",true);
            } else {
                jQuerOs("#cat-publish-yes").attr("checked",true);
            }
            if ( catSettings.categoryShowTitle != undefined) {
                if (catSettings.categoryShowTitle == true) jQuerOs("#cat-show-title-yes").attr("checked",true);
                if (catSettings.categoryShowTitle == true) jQuerOs("#cat-show-title-yes").trigger('click');
                if (catSettings.categoryShowTitle == false) jQuerOs("#cat-show-title-no").attr("checked",true);
                if (catSettings.categoryShowTitle == false) jQuerOs("#cat-show-title-no").trigger('click');
            } else {
                jQuerOs("#cat-show-title-yes").attr("checked",true);
            }

        });
        //end

        //change options // maybe need improve on save. // now we save every option immediately when change value
        //jQuerOs("#cat-layout, #cat-unpublish, #cat-show-title, #cat-show-cat-title-caption,#cat-alias,#cat-desc, #cat-title-position, #cat-title-height-block").on('customCat', function (e) {
        jQuerOs('#cat-options-block input, #cat-layout, #cat-unpublish, #cat-show-title, #cat-show-cat-title-caption, #cat-title-position, #cat-title-height-block').on('customCat', function (e) {
            if(debug){
                console.log('#cat-options-block input', 'customCat')
            }
            //get params from jsonString
            catSettings = parceOptions(jQuerOs("#cat-settings-"+activeId).val());
            for(key in catSettings){
                if(key == 'categoryShowTitle' || key == 'categoryUnpublish') continue;
                
                if(jQuerOs('[name='+key+']').val() != undefined){
                    catSettings[key] = jQuerOs('[name='+key+']').val();
                }else{
                    catSettings[key] = '';
                }
            }

            var inputFields = jQuerOs('#cat-options-block input')
            
            for(var index = 0; index <  inputFields.length; index ++){
                var name = jQuerOs(inputFields[index]).attr('name')
                
                if(name != undefined && (name.indexOf('categoryAlias') > -1 || name.indexOf('categoryDescription') > -1)){
                    
                    catSettings[name] = jQuerOs(inputFields[index]).val();
                }
            }
            
            if(multilang == '1'){
            
            catSettings.categoryAlias = checkSpecialChar(jQuerOs("#cat-alias_"+deafult_lang).val());
            catSettings.categoryDescription = checkSpecialChar(jQuerOs("#cat-desc_"+deafult_lang).val());
//            catSettings.catTitlePosition = jQuerOs("#cat-title-position").val();
//            catSettings.catTitleHeight = jQuerOs("#cat-title-height-block").val();
            //catSettings.categoryUnpublish = !jQuerOs("#cat-unpublish").prop("checked");
            //catSettings.categoryShowTitle = jQuerOs("#cat-show-title").prop("checked");
            }
            catSettings.catTitlePosition = jQuerOs("#cat-title-position").val();
            catSettings.catTitleHeight = jQuerOs("#cat-title-height-block").val();
            catSettings.categoryUnpublish = !jQuerOs(".cat-publish input").prop("checked");
            catSettings.categoryShowTitle = jQuerOs(".cat-show-title input").prop("checked");
            catSettings.categoryShowTitleCaption = jQuerOs("#cat-show-cat-title-caption").prop("checked");

            //set params to Json
            jQuerOs("#cat-settings-"+activeId).val(encodeURI(window.JSON.stringify(catSettings)));
        });

        jQuerOs("#cat-layout, #cat-unpublish, #cat-show-title, #cat-show-cat-title-caption, #cat-title-position, #cat-title-height-block").change(function(event) {
            if(debug){
                console.log('#cat-layout, #cat-unpublish, #cat-show-title, #cat-show-cat-title-caption, #cat-title-position, #cat-title-height-block', 'change')
            }
            jQuerOs(this).trigger( "customCat");
        });
        jQuerOs('#cat-options-block input').on('input', function (e) {
            if(debug){
                console.log('#cat-options-block input', 'input')
            }
        //jQuerOs("#cat-alias, #cat-desc").on('input', function (e) {
            jQuerOs(this).trigger( "customCat");
        });
        //end
    }

    function checkSpecialChar(string){
        if(debug){
            console.log('checkSpecialChar()', {string})
        }
        //funkciya ubiraet simvoly harakternye dlya html i simvoly pri podstanovke kotoryh narushaetsya html struktura galerei. <, >, :
        //18.10.2021 VlaDOS
        //ubrano dvoeto4ie, dobavleny dvoynie kavy4ki
        //18.10.2021 VlaDOS end
//        return string.replace(new RegExp('\\<', 'ig'),'').replace(new RegExp('\\>', 'ig'),'').replace(new RegExp('\\:', 'ig'),'');
        return string.replace(new RegExp('\\<', 'ig'),'').replace(new RegExp('\\>', 'ig'),'').replace(new RegExp('\\"', 'ig'),'');
    }

    ///img settings function
    function imgSettingsFunctions(){
        if(debug){
            console.log('imgSettingsFunctions()')
        }
        var deafult_lang = '<?php echo $default_lang_tag; ?>';
        var multilang = '<?php echo $multilang; ?>';
        
        //change img click function
        jQuerOs("#os-cat-tab-images div[id^='img-']").click(function(e){
            if(debug){
                console.log("#os-cat-tab-images div[id^='img-']", 'click')
            }
            jQuerOs('[href*=cat-options-block]').removeClass('active')
            jQuerOs('[href*=cat-options-block]').parent().removeClass('active')
            jQuerOs('[href*=cat-options-block]').removeClass('show')
            jQuerOs('#cat-options-block.tab-pane').removeClass('active')
            jQuerOs('#cat-options-block.tab-pane').removeClass('show')
            
            jQuerOs('[href*=img-options-block]').addClass('active')
            jQuerOs('[href*=img-options-block]').parent().addClass('active')
            jQuerOs('#img-options-block.tab-pane').addClass('active')
            jQuerOs('#img-options-block.tab-pane').addClass('show')
            prevNextImgOption()
            jQuerOs("#imgCats").select2();
            
            var now = new Date();
            
            if(typeof bootstrap !== "undefined"){
                var myModal = new bootstrap.Modal(document.getElementById("modalImageSettings"), {});
                myModal.show()
            }else{
                jQuerOs('#modalImageSettings').modal();
            }
            jQuerOs("#os-cat-tab-images div[id^='img-']").removeClass('active-img-block');
            jQuerOs(this).addClass('active-img-block');
//            jQuerOs(".category-options-block a:first").tab('show');

            if(typeof bootstrap !== "undefined"){
                if(jQuerOs(".category-options-block a:first").length > 0){
                    var element = jQuerOs(".category-options-block a:first")[0]
                    var b_tab = new bootstrap.Tab(element)
                    b_tab.show()
                }else{
                    var b_tab = new bootstrap.Tab(".category-options-block a:first")
                    b_tab.show()
                }
                
            }else{
                jQuerOs(".category-options-block a:first").tab('show');
            }
            imageId = jQuerOs(this).data("image-id");
            image_this = this;
            catId = jQuerOs(this).parent().attr("id");
            catId = catId.substr(4);
            image = jQuerOs('#img-'+imageId+' img')[0];
            image_clone = jQuerOs(image).clone()
            jQuerOs('#img-options-block .img-preview').html(image_clone)
            
            if(jQuerOs('#cat-'+catId+' #img-'+imageId).prev().length == 0){
                jQuerOs('#img-options-block .arraow-prev').hide()
            }else{
                jQuerOs('#img-options-block .arraow-prev').show()
            }
            
            if(jQuerOs('#cat-'+catId+' #img-'+imageId).next().length == 0 || jQuerOs('#cat-'+catId+' #img-'+imageId).next().hasClass('cat-img-ordering')){
                jQuerOs('#img-options-block .arraow-next').hide()
            }else{
                jQuerOs('#img-options-block .arraow-next').show()
            }
//            jQuerOs(image_clone).appendTo('#img-options-block .img-preview');
                    //
            
//            jQuerOs('.img-options-block .img-preview').html(image)
            jQuerOs(".img-short-code"). html('{os-gal-'+galId+'-'+catId+'-'+imageId+'-left}');
            jQuerOs(".cat-short-code"). html('{os-gal-'+galId+'-'+catId+'}');

            jQuerOs("#modalImageSettingsLabel").text('Image ID-'+imageId);
            jQuerOs('#img_id').val(imageId)
            // get image settings based imageId
            imgSettings = parceOptions(jQuerOs("#img-settings-"+imageId+'-'+catId).val());
            
            for(key in imgSettings){
                
                var sett = imgSettings[key];
                
                if(jQuerOs("[name="+key+"]").length > 0){
                    if(key.indexOf('imgHtml_') > -1 && sett.html != undefined){
                        if(sett.html != "[object Object]"){
                            jQuerOs("[name="+key+"]").val(sett.html);
                        }else{
                            jQuerOs("[name="+key+"]").val('');
                        }
                    }else{
                        jQuerOs("[name="+key+"]").val(sett);
                    }
                }
                
            }
            
            if(imgSettings.imgCats == null || imgSettings.imgCats[0] == undefined ){
                
                var cat_id_str = jQuerOs(this).parents('.tab-pane').attr('id')
                var cat_id = cat_id_str.substring('4')
                
                jQuerOs("#imgCats").val(cat_id)
                jQuerOs("#imgCats").trigger('change')
            }else{
                jQuerOs("#imgCats").val(imgSettings.imgCats);
                jQuerOs("#imgCats").trigger('change')
            }
            var select_opt = jQuerOs.map(jQuerOs("#imgCats").find('option'), function(ele) {
               return ele.value; 
            });

            
            // set image settings
            //Title
            
           
            //Target
            jQuerOs("#img-link-open").val(imgSettings.imgLinkOpen || '_blank');
            //Html Code 
            if (typeof(imgSettings.imgHtml) === "object" && imgSettings.imgHtml.html !== undefined && imgSettings.imgHtml.html != "[object Object]"){
                jQuerOs("#img-html").val(imgSettings.imgHtml.html);
            }else{
                jQuerOs("#img-html").val('');
            }
            
            //Show main image in HTML code
            if ( imgSettings.imgHtmlShow ) {
                if (imgSettings.imgHtmlShow == "yes"){
                    jQuerOs("#general-img-html").find('#general-img-html-yes').attr("checked",true);
                    jQuerOs(".img-html-width, .html-position").slideDown(400)
                }

                if (imgSettings.imgHtmlShow == "no"){
                    jQuerOs("#general-img-html").find('#general-img-html-no').attr("checked",true);
                    jQuerOs(".img-html-width, .html-position").slideUp(400)
                }

            } else {
                jQuerOs("#general-img-html").find('#general-img-html-yes').attr("checked",true);
                jQuerOs(".img-html-width, .html-position").slideDown(400)
            }
            //Html position
            jQuerOs("#html-position-img").val(imgSettings.htmlPosition || 'bottom');
            
            // Set Html Code block width as Main Image width
            if ( imgSettings.htmlWidthAsImg ) {
                if (imgSettings.htmlWidthAsImg == "yes") jQuerOs("#html-width-as-img").find('#html-width-as-img-yes').attr("checked",true);
                if (imgSettings.htmlWidthAsImg == "no") jQuerOs("#html-width-as-img").find('#html-width-as-img-no').attr("checked",true);
            } else {
                jQuerOs("#html-width-as-img").find('#html-width-as-img-yes').attr("checked",true);
            }
            
            if (imgSettings.img_publish) {
                if (imgSettings.img_publish == "yes") jQuerOs("#img_publish").find('#img_publish-yes').attr("checked",true);
                if (imgSettings.img_publish == "no") jQuerOs("#img_publish").find('#img_publish-no').attr("checked",true);
            } else {
                jQuerOs("#img_publish").find('#img_publish-yes').attr("checked",true);
            }




            

            //change options // maybe need improve on save. // now we save every option immediately when change value
//            jQuerOs("#img-title, #img-short-description, #img-alt, #img-link,"+
//                    " #img-link-open, #img-html, #general-img-html, #html-position-img,"+
//                    " #html-width-as-img , #video-link").on('customImg', function (e) {
            jQuerOs('#img-options-block input, #img-options-block select, #img-options-block textarea').on('customImg', function (e) {
                //get params from jsonString
                if(debug){
                    console.log("#img-options-block input, #img-options-block select, #img-options-block textarea", 'customImg')
                }
                imgSettings = parceOptions(jQuerOs("#img-settings-"+imageId+'-'+catId).val());
                
                for(key in imgSettings){
                    
                    if(key == 'img_publish' || key == 'imgHtml' || key == 'htmlWidthAsImg') continue;
                    
                    if(jQuerOs('[name='+key+']').val() != undefined){
                        if(key.indexOf('imgHtml_') > -1 || key.indexOf('imgLink') > -1){
                            imgSettings[key] = jQuerOs('[name='+key+']').val();
                            
                        }else{
                            imgSettings[key] = checkSpecialChar(jQuerOs('[name='+key+']').val());
                        }
                    }else{
                        imgSettings[key] = '';
                    }
                }
                
                imgSettings.imgHtml = {};
                if(multilang == '1'){
                    imgSettings.imgTitle = jQuerOs("#img-title_"+deafult_lang).val();
                    imgSettings.videoLink = jQuerOs("#video-link_"+deafult_lang).val();
                    imgSettings.imgShortDescription = jQuerOs("#img-short-description_"+deafult_lang).val();
                    imgSettings.imgAlt = checkSpecialChar(jQuerOs("#img-alt_"+deafult_lang).val());
                    imgSettings.imgLink = jQuerOs("#img-link_"+deafult_lang).val();
                    
                    imgSettings.imgHtml.html = jQuerOs("#img-html_"+deafult_lang).val();
//                    imgSettings.imgLinkOpen = jQuerOs("#img-link-open_"+deafult_lang).val();
                }else{
                
                
                    if (jQuerOs("#img-html").val() || jQuerOs("#img-html").val() == ''){
                        imgSettings.imgHtml.html = jQuerOs("#img-html").val();
                    }else if(jQuerOs("#img-html").val() == undefined){
                        imgSettings.imgHtml.html = '';
                    }else{
                        imgSettings.imgHtml.html = jQuerOs.quoteString(jQuerOs("#img-html").val());
                    }     
                }
                
                imgSettings.imgCats = jQuerOs("#imgCats").val();
                imgSettings.htmlPosition = jQuerOs("#html-position-img").val();
                imgSettings.imgLinkOpen = jQuerOs("#img-link-open").val(); 
                if(jQuerOs('[name=showImgHtml]:checked').val() == '1'){
                    imgSettings.imgHtmlShow = 'yes';
                }else{
                    imgSettings.imgHtmlShow = 'no';
                }
                jQuerOs("[id^=img-settings-"+imageId+'-]').val(encodeURI(window.JSON.stringify(imgSettings)));
                // jQuerOs(image_this).find("[id^=img-settings-"+imageId+']').val(encodeURI(window.JSON.stringify(imgSettings)));
            });

            jQuerOs("#img-link-open, #img-options-block select").change(function(event) {
                if(debug){
                    console.log("#img-link-open, #img-options-block select", 'change')
                }
                jQuerOs(this).trigger( "customImg");
            });
//            jQuerOs('#img-options-block input, #img-options-block select, #img-options-block textarea').on('change', function (e) {
            jQuerOs('#img-options-block input, #img-options-block textarea').on('input', function (e) {
                if(debug){
                    console.log("#img-options-block input, #img-options-block textarea", 'input')
                }
            //jQuerOs("#img-title, #img-short-description, #img-alt, #img-link, #img-html, #general-img-html, #html-position-img, #html-width-as-img, #video-link").on('input', function (e) {
                jQuerOs(this).trigger("customImg");
            });
//            jQuerOs('#img-options-block .arraow-prev, #img-options-block .arraow-next').on('click', function(elem){
////                event.preventDefault();
////                jQuerOs("[data-dismiss=modal]").trigger('click')
//                if(jQuerOs(this).hasClass('arraow-prev')){
//                    jQuerOs('#img-'+imageId).prev().trigger('click')
//                }else{
//                    jQuerOs('#img-'+imageId).next().trigger('click')
//                }
////                removeListener()
//                
//            })
            //end
        });
        jQuerOs("[data-dismiss=modal], [data-bs-dismiss=modal]").off('click')
        jQuerOs("[data-dismiss=modal], [data-bs-dismiss=modal]").on('click', function(){
            if(debug){
                console.log("[data-dismiss=modal], [data-bs-dismiss=modal]", 'click')
            }
            jQuerOs('.modal-backdrop').remove()
            jQuerOs(".arraow-prev, .arraow-next").show()
            setTimeout(function(){
              jQuerOs('body.com_osgallery').removeAttr('style')
            }, 1000);
            
            removeListener();
        });
        //end
    }
    
    function removeListener(){
        if(debug){
            console.log("[removeListener()")
        }
        jQuerOs('#img-options-block input, #img-options-block textarea').off('input')
        jQuerOs("#img-link-open, #img-options-block select").off('change')
        jQuerOs('#img-options-block input, #img-options-block textarea').off('customImg')
        jQuerOs("#img-link-open, #img-options-block select").off('customImg')
        jQuerOs('#img-options-block .arraow-prev, #img-options-block .arraow-next').off('click')
//        jQuerOs('#img-options-block .arraow-prev, #img-options-block .arraow-next').off('click')
    }

    function makeDeleteImage(){
        jQuerOs(".delete-image").click(function(event) {
            if(debug){
                console.log(".delete-image", 'click')
            }
            event.stopPropagation();
            imgBlock = jQuerOs(this).parent();
            imgId = jQuerOs(imgBlock).data("image-id");
            var cat_id = activeId;
            
            var clone_img = jQuerOs('#cat-'+cat_id+' #img-'+imgId).clone()
            var clone_opt = parceOptions(jQuerOs(clone_img).find('input').val())
            if(clone_opt.imgCats == undefined){
                clone_opt.imgCats = [cat_id]
            }
            for(var i = 0; clone_opt.imgCats.length > i; i++){
                if(clone_opt.imgCats[i] == cat_id){
                    clone_opt.imgCats.splice(i, 1);
                    break;
                }
            }
            jQuerOs('[id^=img-settings-'+imgId+'-]').each(function(){
                jQuerOs(this).val(encodeURI(window.JSON.stringify(clone_opt)))
            })
            jQuerOs(imgBlock).fadeOut(200, function(){ jQuerOs(this).remove();});
            var other_img = jQuerOs('[id^=img-settings-'+imgId+'-]')
            var cat_id = activeId;
            var delete_array = {}
            delete_array.cat_id = cat_id
            delete_array.imgId = imgId
            jQuerOs("#adminForm").append('<input type="hidden" name="deletedImgIds[]" value=\''+window.JSON.stringify(delete_array)+'\'>')
            
//            if(other_img.length == 1){
//                jQuerOs("#adminForm").append('<input type="hidden" name="deletedImgIds[]" value="['+imgId+','+cat_id+']">')
//            }else{
//                
//                jQuerOs("[id^=img-settings-"+imgId+']').each(function(index, elem){
//                    if(jQuerOs(this).attr('id') != 'img-settings-'+imgId+'-'+cat_id){
//                        imgSettings = parceOptions(jQuerOs("#img-settings-"+imgId+'-'+cat_id).val());
//                        console.log('1111111111111111', imgSettings)
//                        for(var i=0; i<imgSettings.imgCats.length; i++){
//                            if(imgSettings.imgCats[i] == cat_id){
//                                imgSettings.imgCats.splice(i, 1);
//                                jQuerOs("#adminForm").append('<input type="hidden" name="deletedImgIds[]" value="['+imgId+','+cat_id+']">')
////                                delete imgSettings.imgCats[i];
//                            }
//                        }
//                        jQuerOs(this).val(encodeURI(window.JSON.stringify(imgSettings)));
//                    }
//                })
//            }
        });
    }

    function addCheckedToMainImgCheckbox () {
        if(debug){
            console.log("addCheckedToMainImgCheckbox()")
        }
        jQuerOs(".img-html-show input").click(function(e) {
            if(debug){
                console.log(".img-html-show input", 'click')
            }
            var id = jQuerOs(this).attr('id');
            var imageId = jQuerOs('.active-img-block').data("image-id");
            var imgSettings = parceOptions(jQuerOs("#img-settings-"+imageId+'-'+activeId).val());

            if (id == 'general-img-html-yes') {
                jQuerOs(this).attr('checked', 'checked');
                jQuerOs(".img-html-show").find('#general-img-html-no').attr("checked",false);
                imgSettings.imgHtmlShow = "yes";
                jQuerOs("[id^=img-settings-"+imageId+']').val(encodeURI(window.JSON.stringify(imgSettings)));

                jQuerOs(".img-html-width, .html-position").slideDown(400)
            } else {
                jQuerOs(this).attr('checked', 'checked');
                jQuerOs(".img-html-show").find('#general-img-html-yes').attr("checked",false);
                imgSettings.imgHtmlShow = "no";
                jQuerOs("[id^=img-settings-"+imageId+']').val(encodeURI(window.JSON.stringify(imgSettings)));

                jQuerOs(".img-html-width, .html-position").slideUp(400)
            }

        });
    }
    
    function addCheckedToPublishImgCheckbox () {
        if(debug){
            console.log("addCheckedToPublishImgCheckbox()")
        }
        jQuerOs(".img-publish input").click(function(e) {
            if(debug){
                console.log(".img-publish input", 'click')
            }
            var id = jQuerOs(this).attr('id');
            var imageId = jQuerOs('.active-img-block').data("image-id");
            var imgSettings = parceOptions(jQuerOs("#img-settings-"+imageId+'-'+activeId).val());

            if (id == 'img_publish-yes') {
                jQuerOs(this).attr('checked', 'checked');
                jQuerOs(".img-publish").find('#img_publish-no').attr("checked",false);
                imgSettings.img_publish = "yes";
                jQuerOs("[id^=img-settings-"+imageId+']').val(encodeURI(window.JSON.stringify(imgSettings)));

            } else {
                jQuerOs(this).attr('checked', 'checked');
                jQuerOs(".img-publish").find('#img_publish-yes').attr("checked",false);
                imgSettings.img_publish = "no";
                jQuerOs("[id^=img-settings-"+imageId+']').val(encodeURI(window.JSON.stringify(imgSettings)));
                //general-img-html-yes
            }

        });
    }
    
    function addCheckedToShowCategoryTabsCheckbox () {
        if(debug){
            console.log("addCheckedToShowCategoryTabsCheckbox()")
        }
        jQuerOs(".cat-show-title input").click(function(e) {
            if(debug){
                console.log(".cat-show-title input", 'click')
            }
            var id = jQuerOs(this).attr('id');
            var catSettings = parceOptions(jQuerOs("#cat-settings-"+activeId).val());
            
            if (id == 'cat-show-title-yes') {
                jQuerOs(this).attr('checked', 'checked');
                jQuerOs(".cat-show-title").find('#cat-show-title-no').attr("checked",false);
                catSettings.categoryShowTitle = true;
                jQuerOs("#cat-settings-"+activeId).val(encodeURI(window.JSON.stringify(catSettings)));

            } else {
                jQuerOs(this).attr('checked', 'checked');
                jQuerOs(".cat-show-title").find('#cat-show-title-yes').attr("checked",false);
                catSettings.categoryShowTitle = false;
                jQuerOs("#cat-settings-"+activeId).val(encodeURI(window.JSON.stringify(catSettings)));
                //general-img-html-yes
            }

        });
    }
    
    function addCheckedToCategoryPublishCheckbox () {
        if(debug){
            console.log("addCheckedToCategoryPublishCheckbox()")
        }
        jQuerOs(".cat-publish input").click(function(e) {
            if(debug){
                console.log(".cat-publish input", 'click')
            }
            var id = jQuerOs(this).attr('id');
            var catSettings = parceOptions(jQuerOs("#cat-settings-"+activeId).val());
            
            if (id == 'cat-publish-yes') {
                jQuerOs(this).attr('checked', 'checked');
                jQuerOs(".cat-publish").find('#cat-publish-no').attr("checked",false);
                catSettings.categoryUnpublish = false;
                jQuerOs("#cat-settings-"+activeId).val(encodeURI(window.JSON.stringify(catSettings)));

            } else {
                jQuerOs(this).attr('checked', 'checked');
                jQuerOs(".cat-publish").find('#cat-publish-yes').attr("checked",false);
                catSettings.categoryUnpublish = true;
                jQuerOs("#cat-settings-"+activeId).val(encodeURI(window.JSON.stringify(catSettings)));
                //general-img-html-yes
            }

        });
    }

    function addCheckedWidthASMainImgCheckbox () {
        if(debug){
            console.log("addCheckedWidthASMainImgCheckbox()", 'click')
        }
        jQuerOs(".img-html-width input").click(function(e) {
            if(debug){
                console.log(".img-html-width input", 'click')
            }
            var id = jQuerOs(this).attr('id');
            var imageId = jQuerOs('.active-img-block').data("image-id");
            var imgSettings = parceOptions(jQuerOs("#img-settings-"+imageId+'-'+activeId).val());

            if (id == 'html-width-as-img-yes') {
                jQuerOs(this).attr('checked', 'checked');
                jQuerOs(".img-html-width").find('#html-width-as-img-no').attr("checked",false);
                imgSettings.htmlWidthAsImg = "yes";
                jQuerOs("[id^=img-settings-"+imageId+']').val(encodeURI(window.JSON.stringify(imgSettings)));
            } else {
                jQuerOs(this).attr('checked', 'checked');
                jQuerOs(".img-html-width").find('#html-width-as-img-yes').attr("checked",false);
                imgSettings.htmlWidthAsImg = "no";
                jQuerOs("[id^=img-settings-"+imageId+']').val(encodeURI(window.JSON.stringify(imgSettings)));
            }
        });
    }    


    function tabsChangeDependences(){
        if(debug){
            console.log("tabsChangeDependences()")
        }
        //change galleryLayout
        jQuerOs(".gallery-layout[name='galleryLayout']").change(function(event) {
            if(debug){
                console.log(".gallery-layout[name='galleryLayout']", 'change')
            }
            var galleryLayout = jQuerOs(this).val();
            var imgTextPosition = jQuerOs("#imgTextPosition [name='imgTextPosition']").val();
            var albumSublayout = jQuerOs("#albumSublayout select").val();
            
            //masonry
            if(galleryLayout == 'masonry' || (galleryLayout == 'albumMode' && albumSublayout == 'masonry')){
                jQuerOs("#masonryLayout").slideDown(400);
                // jQuerOs("#osgallery-checkboxes-block-general").slideUp(400);
                // jQuerOs("#minImgSize").slideUp(400);
                jQuerOs("[name='number_images_at_once_effect']").val('none');
            }else{
                jQuerOs("#masonryLayout").slideUp(400);
                // jQuerOs("#osgallery-checkboxes-block-general").slideDown(400);
                // jQuerOs("#minImgSize").slideDown(400);
            }

            //albumMode
            if(galleryLayout == 'albumMode'){
                jQuerOs(".back-button-text-block").slideDown(400);
                jQuerOs("#albumSublayout").slideDown(400);
                // jQuerOs("select[name='showLoadMore'] option[value='auto']").attr("disabled", "disabled");
                // jQuerOs("select[name='showLoadMore']").val('0');
                jQuerOs("#load-more-button-block").slideUp(400);
                jQuerOs("#load-more-block").slideUp(400);
            }else{
                jQuerOs(".back-button-text-block").slideUp(400);
                jQuerOs("#albumSublayout").slideUp(400);
                jQuerOs("select[name='showLoadMore'] option[value='auto']").removeAttr("disabled");
            }

            //masonry & fit_rows
            if(galleryLayout != "masonry" && galleryLayout != "fit_rows"){
                jQuerOs("#imgWidth").slideDown(400);
                jQuerOs("#imgHeight").slideDown(400);
            }else{
                jQuerOs("#imgWidth").slideUp(400);
                jQuerOs("#imgHeight").slideUp(400);
            }

            //allInOne
            
            if(galleryLayout == 'allInOne' || galleryLayout == 'allInOneRow'){
                jQuerOs(".showLoadMoreOptions").slideUp(400);
                jQuerOs(".showLoadMoreOptionsForAllInOne").slideDown(400);
//                jQuerOs("select[name='showLoadMore']").attr('disabled','disabled');
                jQuerOs("#imgTextPosition").slideUp(400);
            }else{
                jQuerOs(".showLoadMoreOptions").slideDown(400);
                jQuerOs(".showLoadMoreOptionsForAllInOne").slideUp(400);
//                jQuerOs("select[name='showLoadMore']").removeAttr('disabled');
                jQuerOs("#imgTextPosition").slideDown(400);
            }

            //allInOne & albumMode
            if(galleryLayout == "allInOne" || galleryLayout == "albumMode"){
                jQuerOs(".cat-position-title-block").slideDown(400);
            }else{
                jQuerOs(".cat-position-title-block").slideUp(400);
            }
            
            //allInOne & masonry
            if(galleryLayout == "allInOne" || galleryLayout == "masonry"){
                jQuerOs("#imgTextHeight").slideUp(400);
            }else{
                if(imgTextPosition != 'onImage' && imgTextPosition != 'none' ){
                    jQuerOs("#imgTextHeight").slideDown(400);
                }
            }
            if(galleryLayout == 'allInOneRow'){
                jQuerOs(".image_margin_wrap").slideUp(400);
                jQuerOs('#tjava').attr('disabled', 'disabled')
                jQuerOs('#vadim').attr('disabled', 'disabled')
                jQuerOs('#vlados').attr('disabled', 'disabled')
            }else{
                jQuerOs(".image_margin_wrap").slideDown(400);
                jQuerOs('#tjava').removeAttr('disabled')
                jQuerOs('#vadim').removeAttr('disabled')
                jQuerOs('#vlados').removeAttr('disabled')
            }

        });
        
        jQuerOs("[name=imageHover]").on('change', function(){
            if(debug){
                console.log("[name=imageHover]", 'change')
            }
            var val = jQuerOs(this).val()
            if(val == 'tjava' || val == 'vadim' || val == 'vlados'){
                jQuerOs('#allInOneRow').attr('disabled', 'disabled')
                jQuerOs('#topImg, #bottomImg').attr('disabled', 'disabled')
            }else{
                jQuerOs('#allInOneRow').removeAttr('disabled')
                jQuerOs('#topImg, #bottomImg').removeAttr('disabled')
            }
        })
        
        jQuerOs("#albumSublayout select").on('change', function(){
            if(debug){
                console.log("#albumSublayout select", 'change')
            }
            var albumSublayout = jQuerOs(this).val();
            if(albumSublayout == 'masonry'){
                jQuerOs("#masonryLayout").slideDown(400);
                // jQuerOs("#osgallery-checkboxes-block-general").slideUp(400);
                // jQuerOs("#minImgSize").slideUp(400);
                jQuerOs("[name='number_images_at_once_effect']").val('none');
            }else{
                jQuerOs("#masonryLayout").slideUp(400);
                // jQuerOs("#osgallery-checkboxes-block-general").slideDown(400);
                // jQuerOs("#minImgSize").slideDown(400);
            }
            
        })
        //change galleryLayout
        jQuerOs("#imgTextPosition [name='imgTextPosition']").change(function(event) {
            if(debug){
                console.log("#imgTextPosition [name='imgTextPosition']", 'change')
            }
            var imgTextPosition = jQuerOs(this).val();
            var galleryLayout = jQuerOs(".gallery-layout[name='galleryLayout']").val();
            if(imgTextPosition == 'onImage' || imgTextPosition == 'none' ){
                jQuerOs("#imgTextHeight").slideUp(400);
                if(galleryLayout != 'allInOneRow'){
                    jQuerOs('#tjava').removeAttr('disabled')
                    jQuerOs('#vadim').removeAttr('disabled')
                    jQuerOs('#vlados').removeAttr('disabled')
                }
            }else{
                if(galleryLayout != 'masonry'){
                    jQuerOs("#imgTextHeight").slideDown(400);
                }
                jQuerOs('#tjava').attr('disabled', 'disabled')
                jQuerOs('#vadim').attr('disabled', 'disabled')
                jQuerOs('#vlados').attr('disabled', 'disabled')
            }
            
        });
        //change text position
        jQuerOs("select[name='order']").change(function(event) {
            if(debug){
                console.log("select[name='order']", 'change')
            }
            var order = jQuerOs(this).val();
            if(order == 'drag_and_drop'){
                jQuerOs("#orderBy").slideUp(400);
            }else{
                jQuerOs("#orderBy").slideDown(400);
            }
        })
        //change loadMoreType
        jQuerOs("select[name='showLoadMore'], select[name='showLoadMoreForAllInOne']").change(function(event) {
            if(debug){
                console.log("select[name='showLoadMore'], select[name='showLoadMoreForAllInOne']", 'change')
            }
            var loadMoreType = jQuerOs(this).val();
            var galleryLayout = jQuerOs(".gallery-layout[name='galleryLayout']").val();
            if(loadMoreType == '0'){
                jQuerOs("#load-more-button-block").slideUp(400);
                jQuerOs("#load-more-block, .loadMoreEffect").slideUp(400);
            }else{
                if(loadMoreType == 'button'){
                    if(galleryLayout == "allInOne"){
                        jQuerOs("#load-more-block").slideDown(400);
                        jQuerOs("#load-more-button-block, .loadMoreEffect").slideUp(400);
                    }else{
                        jQuerOs("#load-more-button-block, #load-more-block, .loadMoreEffect").slideDown(400);
                    }
                    
                }else{
                    jQuerOs("#load-more-button-block").slideUp(400);
                    if(galleryLayout == "allInOne"){
                        jQuerOs("#load-more-block").slideDown(400);
                        jQuerOs(".loadMoreEffect").slideUp(400);
                    }else{
                        jQuerOs("#load-more-block, .loadMoreEffect").slideDown(400);
                    }
                }
            }
        });
        //change loadMoreType


        //prev_next_effect
        jQuerOs("[name='prev_next_effect']").change(function(event) {
            if(debug){
                console.log("[name='prev_next_effect']", 'change')
            }
            var prev_next_effect = jQuerOs(this).val();                

            if(prev_next_effect != 'none'){
                jQuerOs(".os-fancybox-prev-next-speed-block").slideDown(400);
            }else{
                jQuerOs(".os-fancybox-prev-next-speed-block").slideUp(400);
            }
        });

        //open_close_effect
        jQuerOs("[name='open_close_effect']").change(function(event) {
            if(debug){
                console.log("[name='open_close_effect']", 'change')
            }
            var open_close_effect = jQuerOs(this).val();

            if(open_close_effect != 'none'){
                jQuerOs(".os-fancybox-open-close-speed-block").show("slow");
            }else{
                jQuerOs(".os-fancybox-open-close-speed-block").hide("slow");
            }
        });

        //watermark_type
        jQuerOs("input[name='watermark_type']").change(function(event) {
            if(debug){
                console.log("input[name='watermark_type']", 'change')
            }
            var watermark_type = jQuerOs(this).val();

            if(watermark_type == 1){
                jQuerOs("#watermark-image-block").slideDown(400);
                jQuerOs("#watermark-text-block").slideUp(400);
            }else{
                jQuerOs("#watermark-image-block").slideUp(400);
                jQuerOs("#watermark-text-block").slideDown(400);
            }
        });

        jQuerOs("#watermark-input").change(function(event) {
            if(debug){
                console.log("#watermark-input", 'change')
            }
            watermark_file = this.files;
            var filename = jQuerOs('#watermark-input').val().replace(/C:\\fakepath\\/i, '')
            jQuerOs(".none-upload").html(filename);
            jQuerOs("[name=exist_watermark_file]").val(filename);
        });
        
        jQuerOs("select[name='imgMask']").change(function(event) {
            if(debug){
                console.log("select[name='imgMask']", 'change')
            }
            var imgMask = jQuerOs(this).val();
            if(imgMask == 'none'){
                jQuerOs("#background_color").slideUp(400);
            }else{
                jQuerOs("#background_color").slideDown(400);
            }
        })
    }
    function prevNextImgOption(){
        if(debug){
            console.log("prevNextImgOption()", 'change')
        }
        removeListener();
        jQuerOs('#img-options-block .arraow-prev, #img-options-block .arraow-next').on('click', function(){
            if(debug){
                console.log("#img-options-block .arraow-prev, #img-options-block .arraow-next", 'click')
            }
            prevNextImgOption()
            var ImageId = jQuerOs('#img_id').val()
            jQuerOs('#img-options-block .arraow-prev').show()
            jQuerOs('#img-options-block .arraow-next').show()
            
            jQuerOs("#imgCats").select2("destroy");
            jQuerOs('.modal-backdrop').remove()
            var cat_id = jQuerOs('#osgalery-cat-tabs li.active a').attr('data-cat-id')
            
            if(jQuerOs(this).hasClass('arraow-prev')){
                jQuerOs('#cat-'+cat_id+' #img-'+ImageId).prev().trigger('click')
            }else{
                jQuerOs('#cat-'+cat_id+' #img-'+ImageId).next().trigger('click')
            }
        })
    }
    
    function array_diff (array) {
        if(debug){
            console.log("array_diff()", {array})
        }
            var arr_dif = [], i = 1, argc = arguments.length, argv = arguments, key, key_c, found=false;

            // loop through 1st array
            for ( key in array ){
                    // loop over other arrays
                    for (i = 1; i< argc; i++){
                            // find in the compare array
                            found = false;
                            for (key_c in argv[i]) {
                                    if (argv[i][key_c] == array[key]) {
                                            found = true;
                                            break;
                                    }
                            }

                            if(!found){
                                    arr_dif.push(array[key]);
                            }
                    }
            }

            return arr_dif;
    }
    function os_gall_lazy_load(){
        jQuerOs('#os-cat-tab-images img').each(function(index){
            jQuerOs(this).attr('src', jQuerOs(this).attr('data-src'))
        })
    }
    jQuerOs(document).ready(function(){
//    window.addEventListener('load', function() {
        makeTabsCliked();
        makeCatSortable();
        makeDeleteImage();
        catSettingsFunctions();
        imgSettingsFunctions();
        addCheckedToMainImgCheckbox();
        addCheckedToPublishImgCheckbox();
        addCheckedWidthASMainImgCheckbox();
        tabsChangeDependences();
        addCheckedToShowCategoryTabsCheckbox();
        addCheckedToCategoryPublishCheckbox();
        os_gall_lazy_load();
//        prevNextImgOption();
        
        if(typeof bootstrap !== "undefined"){
            var tab = jQuerOs("#osgalery-cat-tabs a:first,#osgalery-cat-tabs a:first,"+
                    ".category-options-block a:last-child,"
                    +".main-gallery-header a:first,.settings-nav-tabs a:first");
            for(var i=0; tab.length > i; i++){
                
                var b_tab = new bootstrap.Tab(tab[i])
                b_tab.show()
                jQuerOs(tab[i]).parent().addClass('active');
            }
        }else{
            jQuerOs("#osgalery-cat-tabs a:first,#osgalery-cat-tabs a:first,"+
                    ".category-options-block a:last-child,"
                    +".main-gallery-header a:first,.settings-nav-tabs a:first").tab('show');
        }
        
        //init for free
        jQuerOs('.osg-pro-avaible, .osg-pro-avaible-string').prop('disabled', 'disabled');
        jQuerOs('.osg-pro-avaible *, .osg-pro-avaible-string *').prop('disabled', 'disabled');
        //
        jQuerOs("#system-message-container").addClass('gallery-main');
        
        jQuerOs(window).scroll(function(){
            if(jQuerOs(window).scrollTop() >= 47) {
                jQuerOs(".category-options-block").addClass("category-options-block-fixed");
            } else {
                jQuerOs(".category-options-block").removeClass("category-options-block-fixed");
            }
        });
        
        jQuerOs('#imgCats').on('select2:unselecting', function(e){
            if(debug){
                console.log("#imgCats", 'select2:unselecting')
            }
            if(e.params.args.data.id == activeId){
                alert('<?php echo JText::_("COM_OSGALLERY_IMAGE_OPTION_DELETE_CURENT_CAT_ERROR"); ?>');
                return false
            }else{
                var curent_cat = activeId
                var imgId = jQuerOs(this).parents('#img-options-block').find('#img_id').val()
                var catId = e.params.args.data.id
                var clone_img = jQuerOs('#cat-'+curent_cat+' #img-'+imgId).clone()
                var clone_opt = parceOptions(jQuerOs(clone_img).find('input').val())
                if(clone_opt.imgCats == undefined){
                    clone_opt.imgCats = [curent_cat]
                }
                for(var i = 0; clone_opt.imgCats.length > 0; i++){
                    if(clone_opt.imgCats[i] == catId){
                        clone_opt.imgCats.splice(i, 1);
                        break;
                    }
                }
                

                jQuerOs('[id^=img-settings-'+imgId+'-]').each(function(){
                    jQuerOs(this).val(encodeURI(window.JSON.stringify(clone_opt)))
                })
                jQuerOs('#cat-'+catId+' #img-'+imgId).remove();
                makeCatSortable()
                
                jQuerOs.ajax({
                    type: 'POST',
                    // dataType: 'json',
                    url: '<?php echo JURI::current()?>?option=com_osgallery&task=updateImgCategory&removeCatId='+catId+'&imgId='+imgId+'&format=raw',
                    success:function(data){

                    }
                })
            }
        })
        jQuerOs('#imgCats').on('select2:selecting', function(e){
            if(debug){
                console.log("#imgCats", 'select2:selecting')
            }
            var imgId = jQuerOs(this).parents('#img-options-block').find('#img_id').val()
            var catId = e.params.args.data.id
            var curent_cat = activeId

            var clone_img = jQuerOs('#cat-'+curent_cat+' #img-'+imgId).clone()
            var clone_opt = parceOptions(jQuerOs(clone_img).find('input').val())
            if(clone_opt.imgCats == undefined){
                clone_opt.imgCats = [curent_cat]
            }
            
            clone_opt.imgCats.push(catId)
            
            jQuerOs('[id^=img-settings-'+imgId+'-]').each(function(){
                jQuerOs(this).val(encodeURI(window.JSON.stringify(clone_opt)))
            })
            jQuerOs(clone_img).find('input').val(encodeURI(window.JSON.stringify(clone_opt)))
            

            jQuerOs(clone_img).find('input').attr('id', 'img-settings-'+imgId+'-'+catId)

            jQuerOs(clone_img).appendTo('#cat-'+catId);
            
            jQuerOs("#os-cat-tab-images div[id^='img-']").off('click')
            makeDeleteImage()
            makeCatSortable()
            imgSettingsFunctions()
            
            jQuerOs.ajax({
                type: 'POST',
                // dataType: 'json',
                url: '<?php echo JURI::current()?>?option=com_osgallery&task=updateImgCategory&addCatId='+catId+'&imgId='+imgId+'&format=raw',
                success:function(data){

                }
            })
        })
        
        
        
    });

    

</script>
