<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  Captcha.recaptcha
 *
 * @copyright   (C) 2022 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Captcha\Google\HttpBridgePostRequestMethod;
use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Registry\Registry;
use Joomla\Http\HttpFactory;
//use Joomla\Plugin\Captcha\ReCaptcha\Extension\ReCaptcha;
use Os_lib\Plugin\Captcha\ReCaptchaOrdasoft;


return new class () implements ServiceProviderInterface {
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since   4.3.0
     */
    public function register(Container $container)
    {
        $path = JPATH_SITE . '/plugins/captcha/recaptcha_ordasoft/src/Extension/ReCaptchaOrdasoft.php';
        require_once $path;
//        var_dump($path); exit;
        $container->set(
            PluginInterface::class,
            function (Container $container) {
                $plugin = new Os_lib\Plugin\Captcha\ReCaptchaOrdasoft\ReCaptchaOrdasoft(
                    $container->get(DispatcherInterface::class),
                    (array) PluginHelper::getPlugin('captcha', 'recaptcha_ordasoft'),
                    new HttpBridgePostRequestMethod(),
                    Factory::getApplication(),
                    new Registry(PluginHelper::getPlugin('captcha', 'recaptcha_v3')->params ?? null),
                    new HttpFactory
                );
                $plugin->setApplication(Factory::getApplication());

                return $plugin;
            }
        );
    }
};
