<?php
/**
 * @package   BaForms
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Forms\Administrator\Helper\Filter;

use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\FormFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\SettingsFilter;

defined('_JEXEC') or die;

class FilterHelper
{
    public function handle(object &$data): void
    {
        $data->id = (int) $data->id;

        FormFilter::getInstance()->clean($data->form);
        SettingsFilter::getInstance()->clean($data->settings);
        foreach ($data->pages as &$page) {
            FilterFactory::make('page')->clean($page);
        }
        foreach ($data->columns as &$column) {
            FilterFactory::make('column')->clean($column);
        }
        foreach ($data->items as &$item) {
            $filter = FilterFactory::make($item->type);
            if (!$filter) {
                continue;
            }
            $filter->clean($item);
        }
    }

    public static function make(): static
    {
        return new static();
    }
}