<?php
/**
 * @package   BaForms
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Forms\Administrator\Helper\Filter\Filters;

defined('_JEXEC') or die;

use Balbooa\Component\Forms\Administrator\Helper\Filter\Abstracts\ItemFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Enum\FilterEnum;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Interface\FilterInterface;

class MapFilter extends ItemFilter implements FilterInterface
{
    protected array $optionsRules = [
        "suffix" => FilterEnum::String,
        "height" =>FilterEnum::String,
        "controls" =>FilterEnum::Boolean,
        "place" =>FilterEnum::String,
        "styleType" =>FilterEnum::String,
    ];

    protected array $markerRules = [
        "description" => FilterEnum::String,
        "infobox" => FilterEnum::Boolean,
        "icon" => FilterEnum::String
    ];


    public function clean(object &$data): void
    {
        parent::clean($data);

        $this->cleanOptionProperty($data, 'marker', $this->markerRules);
    }
}