<?php
/**
 * @package   BaForms
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Forms\Administrator\Helper\Filter\Filters;

defined('_JEXEC') or die;

use Balbooa\Component\Forms\Administrator\Helper\Filter\Abstracts\ItemFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Enum\FilterEnum;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Interface\FilterInterface;

class SubmitFilter extends ItemFilter implements FilterInterface
{
    protected array $optionsRules = [
        "animation" => FilterEnum::String,
        "ariaLabel" => FilterEnum::String,
        "popup-animation" => FilterEnum::String,
        "label" => FilterEnum::String,
        "submit-icon" => FilterEnum::String,
        "onclick" => FilterEnum::String,
        "message-type" => FilterEnum::String,
        "link" => FilterEnum::String,
        "payment" => FilterEnum::String,
        "database" => FilterEnum::Boolean,
        "honeypot" => FilterEnum::Boolean,
        "suffix" => FilterEnum::String,
        "recaptcha" => FilterEnum::String
    ];

    protected array $notificationsRules = [
        "enable" => FilterEnum::Boolean,
        "attach" => FilterEnum::Boolean,
        "attach_pdf" => FilterEnum::Boolean,
        "email" => FilterEnum::String,
        "custom-mail" => FilterEnum::String,
        "subject" => FilterEnum::String,
    ];

    protected array $limitRules = [
        "count" => FilterEnum::String,
        "user_id" => FilterEnum::String,
        "user_ip" => FilterEnum::String,
        "end_date" => FilterEnum::String,
    ];

    protected array $unitsRules = [
        "padding" => FilterEnum::String,
        "border-radius" => FilterEnum::String,
        "border-width" => FilterEnum::String,
        "font-size" => FilterEnum::String,
        "letter-spacing" => FilterEnum::String,
        "line-height" => FilterEnum::String,
        "size" => FilterEnum::String,
        "popup-width" => FilterEnum::String,
        "popup-radius" => FilterEnum::String,
    ];

    protected array $popupRules = [
        "width" => FilterEnum::Integer,
        "radius" => FilterEnum::Integer,
        "background-color" => FilterEnum::String,
        "backdrop-color" => FilterEnum::String,
        "icon-color" => FilterEnum::String,
    ];

    protected array $shadowRules = [
        'value' => FilterEnum::Integer,
        'color' => FilterEnum::String,
        'hover' => FilterEnum::String,
    ];

    protected array $backgroundRules = [
        'color' => FilterEnum::String,
        'hover' => FilterEnum::String,
    ];

    protected array $paddingRules = [
        'link' => FilterEnum::Boolean,
        'top' => FilterEnum::Integer,
        'right' => FilterEnum::Integer,
        'bottom' => FilterEnum::Integer,
        'left' => FilterEnum::Integer,
    ];

    protected array $borderRules = [
        'top' => FilterEnum::Boolean,
        'right' => FilterEnum::Boolean,
        'bottom' => FilterEnum::Boolean,
        'left' => FilterEnum::Boolean,
        'color' => FilterEnum::String,
        'hover' => FilterEnum::String,
        'radius' => FilterEnum::Integer,
        'width' => FilterEnum::Integer,
    ];

    protected array $typographyRules = [
        'font-family' => FilterEnum::String,
        'font-size' => FilterEnum::Float,
        'letter-spacing' => FilterEnum::Float,
        'line-height' => FilterEnum::Float,
        'color' => FilterEnum::String,
        'hover' => FilterEnum::String,
        'font-weight' => FilterEnum::String,
        'text-align' => FilterEnum::String,
        'font-style' => FilterEnum::String,
        'text-transform' => FilterEnum::String,
    ];

    protected array $iconRules = [
        'size' => FilterEnum::Float,
        'color' => FilterEnum::String,
        'hover' => FilterEnum::String,
        'text-align' => FilterEnum::String,
    ];

    public function clean(object &$data): void
    {
        parent::clean($data);

        $this->cleanOptionProperty($data, 'limit', $this->limitRules);
        $this->cleanOptionProperty($data, 'reply', $this->notificationsRules);
        $this->cleanOptionProperty($data, 'notifications', $this->notificationsRules);
        $this->cleanOptionProperty($data, 'units', $this->unitsRules);
        $this->cleanOptionProperty($data, 'popup', $this->popupRules);
        $this->cleanOptionProperty($data, 'shadow', $this->shadowRules);
        $this->cleanOptionProperty($data, 'background', $this->backgroundRules);
        $this->cleanOptionProperty($data, 'padding', $this->paddingRules);
        $this->cleanOptionProperty($data, 'border', $this->borderRules);
        $this->cleanOptionProperty($data, 'typography', $this->typographyRules);
        $this->cleanOptionProperty($data, 'icon', $this->iconRules);
    }
}