<?php
/**
* @package OS Gallery
* @copyright 2020 OrdaSoft
* @author 2020 Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @license GNU General Public license version 2 or later;
* @description Ordasoft Image Gallery
*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');
global $os_gallery_configuration;
// Set some global property
$document = JFactory::getDocument();

// require helper file
JLoader::register('osGalleryHelperSite', JPATH_COMPONENT . '/helpers/osGalleryHelperSite.php');
JLoader::register('osGalleryHelperAdmin', JPATH_COMPONENT_ADMINISTRATOR . '/helpers/osGalleryHelperAdmin.php');
JLoader::register('osGallerySocialButtonsHelper', JPATH_COMPONENT . '/helpers/osGallerySocialButtonsHelper.php');

$GLOBALS['gl_state'] = $gl_state = osGalleryHelperAdmin::checkActivation() ;
$os_gallery_configuration = JComponentHelper::getParams('com_osgallery');
// Perform the Request task
 
$input = JFactory::getApplication()->input;
$task = $input->getCmd('task', '');
$view = $input->getCmd('view', '');

if(!$task && $view)$task = $view;

switch ($task) {
    case "defaultTabs":
        osGalleryHelperSite::displayView();
        break;
        
    case "loadMoreButton":
	case "loadMoreScroll":
	case "loadMoreAuto":
        osGalleryHelperSite::displayViewAjax();
        break;
    
    case "searhResult":
        osGalleryHelperSite::showSearchResult();
        break;
    
    case "loadMoreButtonSearch":
	case "loadMoreScrollSearch":
	case "loadMoreAutoSearch":
        osGalleryHelperSite::showSearchResultAjax();
        break;

    case "loadMoreAutoSearch":
        osGalleryHelperSite::showSearchResultAjax();
        break;

    case "set_app_license":
        $data = $input->get('data', '', 'string');
        osGalleryHelperAdmin::setAppLicense($data);
        break ;        
    
    case "check_gallery_state":
        $state = osGalleryHelperAdmin::checkGalleryState();
        print_r($state);exit();
        break ;

    case "set_app_license_activation":
        osGalleryHelperAdmin::setOSGalleryAppLicenseActivation();
        exit();
        break ;

    default:
        echo 'error: '.$task;
        break;
}