<?php
/**
 *
 * @package  Joomla Real Estate
 * @copyright Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: https://ordasoft.com/joomla-real-estate
 * @license GNU General Public License version 2 or later
 *
 */

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');
defined("DS") OR define("DS", DIRECTORY_SEPARATOR);



$mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path'] = JPATH_SITE;
global $mosConfig_lang, $user_configuration; 
$mainframe = JFactory::getApplication(); 
$GLOBALS['mainframe'] = $mainframe;


jimport('joomla.html.pagination');
$GLOBALS['database'] = $database = JFactory::getDBO();
require_once($mosConfig_absolute_path . '/components/com_realestatemanager/compat.joomla1.5.php');
if (version_compare(JVERSION, '3.0.0', 'lt'))
    include_once($mosConfig_absolute_path . '/libraries/joomla/application/pathway.php'); 
include_once($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.main.categories.class.php');
jimport('joomla.application.pathway');
jimport('joomla.html.pagination');
jimport('joomla.filesystem.folder');


require_once $mosConfig_absolute_path .
  '/administrator/components/com_realestatemanager/language.php';
require_once($mosConfig_absolute_path .
  '/components/com_realestatemanager/captcha.php');
/** load the html drawing class */
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.class.rent.php');
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.html.php'); 
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.class.php'); 
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.class.rent_request.php');
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.class.buying_request.php');
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.class.property_request.php');
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.class.rent.php');
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.class.review.php');
require_once ($mosConfig_absolute_path .
 '/administrator/components/com_realestatemanager/realestatemanager.class.others.php');
//added 2012_06_05 that's because it doesn't work with enabled plugin System-Legacy, so if it works, let it work :)
require_once($mosConfig_absolute_path .
 '/components/com_realestatemanager/functions.php');

require_once ($mosConfig_absolute_path .
     '/administrator/components/com_realestatemanager/realestatemanager.class.impexp.php');

//added 2012_06_05 that's because it doesn't work with enabled plugin System-Legacy, so if it works, let it work :)
if (!array_key_exists('realestatemanager_configuration', $GLOBALS)) {
    require_once ($mosConfig_absolute_path .
     '/administrator/components/com_realestatemanager/realestatemanager.class.conf.php');
    $GLOBALS['realestatemanager_configuration'] = $realestatemanager_configuration;
} else
    global $realestatemanager_configuration;

if (!isset($option))
    $GLOBALS['option'] = $option = mosGetParam($_REQUEST, 'option', 'com_realestatemanager');
else
    $GLOBALS['option'] = $option;

if (isset($option) && $option == 'com_simplemembership') {
    if (!array_key_exists('user_configuration2', $GLOBALS)) {
        require_once (JPATH_SITE . '/' . 'administrator' . '/' . 'components' . '/' .
         'com_simplemembership' . '/' . 'admin.simplemembership.class.conf.php');
        $GLOBALS['user_configuration2'] = $user_configuration;
    } else {
        global $user_configuration;
    }
}
//remove_langs();exit;
// Get Current User 
if (version_compare(JVERSION, "4.0.0", "ge")) {
    $app = JFactory::getApplication();
    $my = $app->getIdentity();
} else {
    $my = JFactory::getUser();
}
$acl = new JAccess;
$GLOBALS['my'] = $my;
$GLOBALS['acl'] = $acl;
$id = intval(protectInjectionWithoutQuote('id', 0));
$catid = intval(mosGetParam($_REQUEST,'catid', 0));
$bids = protectInjectionWithoutQuote('bid', array(),"ARRAY");

$Itemid = protectInjectionWithoutQuote('Itemid', 0);
$printItem = trim(mosGetParam($_REQUEST, 'printItem', ""));
$doc = JFactory::getDocument(); 
$GLOBALS['doc'] = $doc; 
$GLOBALS['op'] = $doc; 
//$doc->setTitle(_REALESTATE_MANAGER_TITLE); 

if (!isset($GLOBALS['Itemid']))
    $GLOBALS['Itemid'] = $Itemid = intval(protectInjectionWithoutQuote('Itemid', 0));


// paginations
$intro = $realestatemanager_configuration['page']['items']; // page length

if ($intro) {
    $paginations = 1;
    $limit = intval(protectInjectionWithoutQuote('limit', $intro));
    $GLOBALS['limit'] = $limit;
    $limitstart = intval(protectInjectionWithoutQuote('limitstart', 0));
    $GLOBALS['limitstart'] = $limitstart;
    $total = 0;
    $LIMIT = 'LIMIT ' . $limitstart . ',' . $limit;
} else {
    $paginations = 0;
    $LIMIT = '';
}

$session = JFactory::getSession();
$session->set("array", $paginations);


$jinput = JFactory::getApplication()->input;
if (!isset($task))
    $GLOBALS['task'] = $task = $jinput->getCmd('task', "");
else {
    $GLOBALS['task'] = $task;
}


$view =  $jinput->getCmd('view', '');


if ((!isset($task) OR $task == '') AND isset($view) and $view != '')
    $GLOBALS['task'] = $task = $view;

// if ((!isset($task) OR $task == '') AND (protectInjectionWithoutQuote('start', '') != '')){
//     $GLOBALS['task'] = $task = protectInjectionWithoutQuote('start', '');
// }

if ( (!isset($task) OR $task == '' ) && (!isset($view) OR $view == '') ){
    $app = JFactory::getApplication();
    $menu = $app->getMenu() ;
    $item  = $menu->getActive();
    if( isset($item) ) $GLOBALS['task'] = $task = $item->query['view'];
}

$submit = protectInjectionWithoutQuote("submit", "");
if ($submit == "[ Rent Request ]")
    $task = "rent_request";

//$realestatemanager_configuration['debug']  = 1 ;
if ($realestatemanager_configuration['debug'] == '1') {
    echo "Task: " . $task . "<br />";
    print_r($_REQUEST);
    echo "<hr /><br />";
}

$bid = protectInjectionWithoutQuote('bid', array(),"ARRAY");
$rent_from = protectInjectionWithoutQuote('rent_from', "");
$rent_until = protectInjectionWithoutQuote('rent_until', "");

if($task == "ajax_rent_calcualete"  && isset($bid) 
    AND count($bid) > 0 AND isset($rent_from)  AND $rent_from != "" ){
    $bid_ajax_rent = $bid ;
    $rent_from = protectInjectionWithoutQuote("rent_from", "");
    $rent_until = protectInjectionWithoutQuote("rent_until","");
    $how_many_weeks = protectInjectionWithoutQuote("how_many_weeks","");
    $how_many_monthes = protectInjectionWithoutQuote("how_many_monthes","");
    $special_price = protectInjectionWithoutQuote("special_price","");
    $currency_spacial_price = protectInjectionWithoutQuote("currency_spacial_price","");;
    $comment_price = protectInjectionWithoutQuote("comment_price","");
} else if($task == "ajax_rent_calcualete" ){
    exit;
}

 //echo ":11111111111111111111111111111:";print_r($task);exit;

switch ($task) {

    case "checkFile":
        rem_checkFile();
    break;

    case 'getUserData':

        $jinput = JFactory::getApplication()->input;
        $userId = $jinput->getCmd('userId', false);
        //$user = JFactory::getUser($userId);
        $user = new JUser($userId);
        $userData = array();
        $userData['name'] = $user->username;
        $userData['email'] = $user->email;

        echo json_encode($userData);
        // return;

        break;

    case 'ajax_rent_calcualete':
        PHP_realestatemanager::ajax_rent_calcualete($bid_ajax_rent,$rent_from,$rent_until,$how_many_weeks,$how_many_monthes);
        break;

    case 'secret_image_review':
        PHP_realestatemanager::secretImage('review');
        break;
    case 'secret_image_rent_request':
        PHP_realestatemanager::secretImage('rent_request');
        break;
    case 'secret_image_buy_request':
        PHP_realestatemanager::secretImage('buy_request');
        break;

    case 'secret_image_add_house_request':
        PHP_realestatemanager::secretImage('add_house_request');
        break;

    case 'secret_image_property_request':
        PHP_realestatemanager::secretImage('property_request');
        break;


    case 'show_search_house':
            $menu = new JTableMenu($database);
            $menu->load($GLOBALS['Itemid']);
            $params = new JRegistry;
            $params->loadString($menu->params);
        $layout = $params->get('showsearchhouselayout', '');

        if(!isset($layout) || empty($layout)){
            $layout = $realestatemanager_configuration['default_search_layout'];
          }

        PHP_realestatemanager::showSearchHouses($option, $catid, $params, $layout);
        break;

    case'button_search_house':
        $layout = $realestatemanager_configuration['default_search_layout'];
        if(!isset($layout) || empty($layout)){
          $layout = 'default';
        }
        $params = null ;
        PHP_realestatemanager::showSearchHouses($option, $catid, $params, $layout);
        break;

    case 'show_search':
        //Select layout by default (this option set on admin panel->search settings)
        if($realestatemanager_configuration['default_search_layout'] == 'advanced'){
            $layout = $realestatemanager_configuration['default_search_layout'];
        }else{
            $layout = 'default';
        }
        $params = null ;
        PHP_realestatemanager::showSearchHouses($option, $catid, $params, $layout);
        break;

    case 'search':
        $params = null ;
        PHP_realestatemanager::searchHouses($option, $catid, $params, $languagelocale);
        break;

    case 'all_houses':
            $menu = new JTableMenu($database);
            $menu->load($GLOBALS['Itemid']);
            $params = new JRegistry;
            $params->loadString($menu->params);
        $layout = $params->get('allhouselayout', '');
        if ($layout == '')
            $layout = 'default';
        PHP_realestatemanager::ShowAllHouses($layout, $printItem);
        break;

    case 'view_house':
    case 'view':
        //При просмотре дома, запомнить id, idcat, Itemid в сессию
        if(isset($id)){
            $_SESSION['id'] = $id;
        }
        if(isset($catid)){
            $_SESSION['catid'] = $catid;
        }
        if(isset($Itemid)){
            $_SESSION['Itemid'] = $Itemid;
        }

            $menu = new JTableMenu($database);
            $menu->load($GLOBALS['Itemid']);
            $params = new JRegistry;
            $params->loadString($menu->params);
        $layout = $params->get('viewhouselayout', '');

        if ($id) {

            $query = "SELECT id FROM #__rem_houses WHERE id =" . $id;
            $database->setQuery($query);
            $id_tmp = $database->loadObjectList();
            if( !isset( $id_tmp[0] ) ){
                echo"<br /><br /><h1 style='text-align:center'>" . _REALESTATE_MANAGER_LABEL_SEARCH_NOTHING_FOUND . "</h1>";
                return;
            }

            $query = "SELECT idcat AS catid FROM #__rem_categories WHERE iditem=" . $id;
            $database->setQuery($query);
            $catid = $database->loadObjectList();

            $catid = $catid[0]->catid;

            PHP_realestatemanager::showItemREM($option, $id, $catid, $printItem, $layout);
        } else {
                $menu = new JTableMenu($database);
                $menu->load($Itemid);
                $params = new JRegistry;
                $params->loadString($menu->params);
            if (version_compare(JVERSION, "1.6.0", "lt")) {
                $id = $params->get('house');
            } else if (version_compare(JVERSION, "1.6.0", "ge") ) {
                $view_house_id = ''; 
                $view_house_id = $params->get('house');
                if ($view_house_id > 0) {
                    $id = $view_house_id;
                }
            }
            $query = "SELECT idcat AS catid FROM #__rem_categories WHERE iditem=" . $id;
            $database->setQuery($query);
            $catid = $database->loadObject();
            if(isset($catid))
            $catid = $catid->catid;
            PHP_realestatemanager::showItemREM($option, $id, $catid, $printItem, $layout);
        }
        break;

    case 'review_house':
    case 'review':
        PHP_realestatemanager::reviewHouse($option);
        break;

    case 'alone_category':
    case 'showCategory':
            $menu = new JTableMenu($database);
            $menu->load($Itemid);
            $params = new JRegistry;
            $params->loadString($menu->params);

        $layout = $params->get('categorylayout', '');

        if ($catid) {
            PHP_realestatemanager::showCategory($catid, $printItem, $option, $layout, $languagelocale);
        } else {
            if (version_compare(JVERSION, "1.6.0", "lt")) {
                $catid = $params->get('catid');
            } else if (version_compare(JVERSION, "1.6.0", "ge")) {
                $single_category_id = ''; 
                $single_category_id = $params->get('single_category');
                if ($single_category_id > 0)
                    $catid = $single_category_id;
            }

            PHP_realestatemanager::showCategory($catid, $printItem, $option, $layout, $languagelocale);
        }
        break;


    case 'rent_request':

        PHP_realestatemanager::showRentRequest($option, $bids);
        break;


    case 'save_rent_request':
        PHP_realestatemanager::saveRentRequest($option, $bids);
        break;

    case 'buying_request':
        PHP_realestatemanager::saveBuyingRequest($option, $bids);
        break;

    case 'property_request':
        PHP_realestatemanager::save_property_request($option, $bids);
        break;


    case 'mdownload':
        PHP_realestatemanager::mydownload($id);
        break;

    case 'downitsf':
        PHP_realestatemanager::downloaditself($id);
        break;


    case "ajax_rent_price":
        rentPriceREM($bid_ajax_rent,$rent_from,$rent_until,$special_price,$comment_price,$currency_spacial_price);
        break;
    case 'all_categories':
            $menu = new JTableMenu($database);
            $menu->load($GLOBALS['Itemid']);
            $params = new JRegistry;
            $params->loadString($menu->params);
        $layout = $params->get('allcategorylayout', '');
        if ($layout == '')
            $layout = "default";
        PHP_realestatemanager::listCategories($catid, $layout, $languagelocale);
        break;


    default:

            $menu = new JTableMenu($database);
            $menu->load($GLOBALS['Itemid']);
            $params = new JRegistry;
            $params->loadString($menu->params);
        $layout = $params->get('allhouselayout', '');
        if ($layout == '')
            $layout = 'default';
        PHP_realestatemanager::ShowAllHouses($layout, $printItem);
        break;
}


class PHP_realestatemanager {

    static function mylenStr($str, $lenght) {
        if (strlen($str) > $lenght) {
            $str = substr($str, 0, $lenght);
            $str = substr($str, 0, strrpos($str, " "));
        }
        return $str;
    }


    static function addTitleAndMetaTags($id_item = 0) {
        global $database, $doc, $mainframe, $Itemid, $task, $realestatemanager_configuration;

        //if not neeed set meta tags
        if($realestatemanager_configuration['show_metadata'] == 0 ) return ;

        $jinput = JFactory::getApplication()->input ;
        $task = $jinput->getCmd('task', '');
        $req_view = $jinput->getCmd('view', "");
        if ( $req_view != "" ) {
            if ( !isset($task) OR $task == '' ) $task = $req_view;
        }            

        //if we in some item menu, not in menuitem child, metatags set from that menu settings
        if( set_menu_metatags_rem($Itemid) ) return ; 

        //else metatags set from component

        $title = array();
        $description = "" ;
  
        //if _REM_ADD_META_MANUAL
        if($realestatemanager_configuration['show_metadata'] == 1 ) {


            if ( isset($task) && $task != '' ) {
                if($task == 'view' || $task == 'view_house' ){
                    $item = new mosRealEstateManager($database);
                    $item->load($id_item);                        
                } else if($task == 'alone_category' || $task == 'showCategory' ){
                    $item = new mainRealEstateCategories($database);
                    $item->load($id_item);                        
                }               

                if( isset($item) ){
                    $registry = new JRegistry($item->metadata); 
                    $metadata = $registry->toArray() ;
             
                    if(isset($metadata['meta_title']) ) $doc->setTitle( $metadata['meta_title']) ;
                    if(isset($metadata['meta_keywords']) ) $doc->setMetaData('keywords', $metadata['meta_keywords']) ;
                    if(isset($metadata['meta_description']) ) $doc->setMetaData('description', $metadata['meta_description']) ;
                    if(isset($metadata['meta_robots']) ) $doc->setMetaData('robots', $metadata['meta_robots']) ;
                }
                
            }

            return ;            
        }




        $title_tag = "";
        $metadata_description_tag = "";
        $metadata_keywords_tag = ""; 


        //if _REM_AUTOMATIC_GENERATE_META or _REM_AUTOMATIC_GENERATE_META_FOR_EMPTY
        if($realestatemanager_configuration['show_metadata'] == 2 or $realestatemanager_configuration['show_metadata'] == 3 )
        { //AUTOMATIC_GENERATE_META

            $catid = $jinput->getInt('catid', null);
            $id = $jinput->getInt('id', null);

        // comment add "task" or "view" value - to title
            // if (isset($req_view)) {
            //     $req_view = str_replace("_", " ", $req_view);
            //     $req_view = ucfirst($req_view);
            //     $title[] = $req_view;
            // } else if ($task == 'all_authors'){
            //     $view = str_replace("_", " ", $task);
        //     $view = ucfirst($view);
        //     $title[] = $view;
        // }

        $s = getWhereUsergroupsCondition('c');
            $s_cat = getWhereDatePublishStringRem('c');
            $s_h = getWhereDatePublishStringRem('h');

        if (!isset($catid)) {

            // Parameters
                $menu = new JTableMenu($database);
                $menu->load($Itemid);
                $params = new JRegistry;
                $params->loadString($menu->params);
            if (version_compare(JVERSION, "1.6.0", "lt")) {
                $catid = $params->get('catid');
            } else if (version_compare(JVERSION, "1.6.0", "ge")) {
                $single_category_id = ''; 
                $single_category_id = $params->get('single_category');
                if ($single_category_id > 0)
                    $catid = $single_category_id;
            }
        }

        //To get name of category
        if (isset($catid)) {
            $query = "SELECT  c.name, c.title, c.id AS catid, c.parent_id
                    FROM #__rem_main_categories AS c
                        WHERE ($s) AND ($s_cat) AND c.id = "
                         . intval($catid);
            $database->setQuery($query);
            $row = null;
            $row = $database->loadObject();
            if (isset($row)) {
                $cattitle = array();
                if ($row->title != '') {
                    $cattitle[] = $row->title; //$row->name
                } else {
                    $cattitle[] = $row->name;
                }
                while (isset($row) && $row->parent_id > 0) {
                    $query = "SELECT  name, title, c.id AS catid, parent_id
                        FROM #__rem_main_categories AS c
                            WHERE ($s) AND ($s_cat) AND c.id = "
                             . intval($row->parent_id);
                    $database->setQuery($query);
                    $row = $database->loadObject();
                    if (isset($row)) {
                        if ($row->title == '' && $row->name != '') {
                            $cattitle[] = $row->name; //$row->name
                        } else {
                            $cattitle[] = $row->title; //$row->name
                        }
                    }
                }
                $title = array_merge($title, array_reverse($cattitle));
            }
        }

        //To get Name of the houses
        if (isset($id)) {
                $query = "SELECT h.*, c.id AS catid
                    FROM #__rem_houses AS h
                    LEFT JOIN #__rem_categories AS hc ON h.id=hc.iditem
                    LEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat
                        WHERE ({$s}) AND ({$s_cat}) AND ({$s_h}) AND h.id="
                         . intval($id) . "
                    GROUP BY h.id";
            $database->setQuery($query);
            $row = null;
            $row = $database->loadObject();
            if (isset($row)) {
                $idtitle = array();
                $idtitle[] = $row->htitle;
                $title = array_merge($title, $idtitle);
                    $description = $row->description;
            }
        }

            if (empty($title) && $id_item != 0) {
                $query = "SELECT h.*
                    FROM #__rem_houses AS h
                        WHERE  h.id=" . $id_item;
            $database->setQuery($query);
            $row = null;
            $row = $database->loadObject();
            if (isset($row)) {
                $idtitle = array();
                $idtitle[] = $row->htitle;
                $title = array_merge($title, $idtitle);
                    $description = $row->description;
            }
        }

            if (isset($task)  && $task == 'search') $title[] = 'Search Real Estate';
        $tagtitle = "";
            $tags = "";
        for ($i = 0; $i < count($title); $i++) {
                $tagtitle = trim($tagtitle) . " | " . trim($title[$i]);
                $tags = trim($tags) . ", " . trim($title[$i]);
        }
        
            $description = $tagtitle ." | ".trim( strip_tags($description) ) ; 
            $description = trim( $description, "| " ) ; 
            $rem = "Real Estate";
        //To set Title
        $title_tag = PHP_realestatemanager::mylenStr($rem . $tagtitle, 75);
        //To set meta KeywordsTag
            $metadata_keywords_tag = PHP_realestatemanager::mylenStr($rem . $tags, 200);
            //To set meta Description
            $metadata_description_tag = PHP_realestatemanager::mylenStr($description, 300);

        }
        //if _REM_AUTOMATIC_GENERATE_META
        if($realestatemanager_configuration['show_metadata'] == 2 ) {
        $doc->setTitle($title_tag);
        $doc->setMetaData('keywords', $metadata_keywords_tag);
            $doc->setMetaData('description', $metadata_description_tag);
            $doc->setMetaData('robots', "index, follow");

            return ;
    }
        //if _REM_AUTOMATIC_GENERATE_META_FOR_EMPTY
        if($realestatemanager_configuration['show_metadata'] == 3 ) {
  
            if ( isset($task) && $task != '' ) {
                if($task == 'view' || $task == 'view_house' ){
                    $item = new mosRealEstateManager($database);
                    $item->load($id_item);                        
                } else if($task == 'alone_category' || $task == 'showCategory' ){
                    $item = new mainRealEstateCategories($database);
                    $item->load($id_item);                        
                }

                if( isset($item) ) {
                    $registry = new JRegistry($item->metadata); 
                    $metadata = $registry->toArray() ;
                }
            }

            if(isset($metadata['meta_title']) ) { 
                $doc->setTitle( $metadata['meta_title']) ;
            }else $doc->setTitle($title_tag);
            if(isset($metadata['meta_keywords']) ) {
                $doc->setMetaData('keywords', $metadata['meta_keywords']) ;
            }else $doc->setMetaData('keywords', $metadata_keywords_tag);
            if(isset($metadata['meta_description']) ) {
                $doc->setMetaData('description', $metadata['meta_description']) ;
            }else $doc->setMetaData('description', $metadata_description_tag);
            if(isset($metadata['meta_robots']) ) {
                $doc->setMetaData('robots', $metadata['meta_robots']) ;
            } else  $doc->setMetaData('robots', "index, follow");

            return ;
        }



    }

    static function output_file($file, $name, $mime_type = '') {
        /*
          This function takes a path to a file to output ($file),
          the filename that the browser will see ($name) and
          the MIME type of the file ($mime_type, optional).
          If you want to do something on download abort/finish,
          register_shutdown_function('function_name');
         */
        if (!is_readable($file))
            die('File not found or inaccessible!');
        $size = filesize($file);
        $name = rawurldecode($name);

        /* Figure out the MIME type (if not specified) */
        $known_mime_types = array(
            "pdf" => "application/pdf",
            "txt" => "text/plain",
            "html" => "text/html",
            "htm" => "text/html",
            "exe" => "application/octet-stream",
            "zip" => "application/zip",
            "doc" => "application/msword",
            "xls" => "application/vnd.ms-excel",
            "ppt" => "application/vnd.ms-powerpoint",
            "gif" => "image/gif",
            "png" => "image/png",
            "jpeg" => "image/jpg",
            "jpg" => "image/jpg",
            "php" => "text/plain"
        );

        if ($mime_type == '') {
            $file_extension = strtolower(substr(strrchr($file, "."), 1));
            if (array_key_exists($file_extension, $known_mime_types)) {
                $mime_type = $known_mime_types[$file_extension];
            } else
                $mime_type = "application/force-download";
        };

        $name = str_replace(" ", "", $name);
        ob_end_clean(); //turn off output buffering to decrease cpu usage
        // required for IE, otherwise Content-Disposition may be ignored
        if (ini_get('zlib.output_compression'))
            ini_set('zlib.output_compression', 'Off');

        header('Content-Type: application/force-download');
        header("Content-Disposition: inline; filename=".urlencode($name) );
        header("Content-Transfer-Encoding: binary");
        header('Accept-Ranges: bytes');

        /* The three lines below basically make the download non-cacheable */
        header("Cache-control: private");
        header('Pragma: private');
        header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

        // multipart-download and download resuming support
        if (isset($_SERVER['HTTP_RANGE'])) {
            list($a, $range) = explode("=", $_SERVER['HTTP_RANGE'], 2);
            list($range) = explode(",", $range, 2);
            list($range, $range_end) = explode("-", $range);
            $range = intval($range);
            if (!$range_end)
                $range_end = $size - 1; else
                $range_end = intval($range_end);
            $new_length = $range_end - $range + 1;
            header("HTTP/1.1 206 Partial Content");
            header("Content-Length: $new_length");
        } else {
            $new_length = $size;
            header("Content-Length: " . $size);
        }

        $chunksize = 1 * (1024 * 1024); //you may want to change this
        $bytes_send = 0;
        if ($file = fopen($file, 'r')) {
            if (isset($_SERVER['HTTP_RANGE']))
                fseek($file, $range);
            while (!feof($file) && (!connection_aborted()) && ($bytes_send < $new_length)) {
                $buffer = fread($file, $chunksize);
                print($buffer); // is also possible
                flush();
                $bytes_send += strlen($buffer);
            }
            fclose($file);
        } else
            die('Error - can not open file.');
        die();
    }

    static function mydownload($id) {
        global $realestatemanager_configuration;
        global $mosConfig_absolute_path;
        
        $session = JFactory::getSession();
        $pas = $session->get("ssmid", "default");
        $sid_1 = $session->getId();

        if (!($session->get("ssmid", "default")) || $pas == "" || $pas != $sid_1 || $_COOKIE['ssd'] != $sid_1 ||
                !array_key_exists("HTTP_REFERER", $_SERVER) || $_SERVER["HTTP_REFERER"] == "" ||
                strpos($_SERVER["HTTP_REFERER"], $_SERVER['SERVER_NAME']) === false) {
            echo '<H3 align="center">Link failure</H3>';
            exit;
        }

    }

    static function downloaditself($idt) {
        global $database, $my, $realestatemanager_configuration, $mosConfig_absolute_path, $os_rem_state;

        $session = JFactory::getSession();
        $pas = $session->get("ssmid", "default");
        $sid_1 = $session->getId();

        if (!($session->get("ssmid", "default")) || $pas == "" || $pas != $sid_1 ||
                $_COOKIE['ssd'] != $sid_1 || !array_key_exists("HTTP_REFERER", $_SERVER) ||
                $_SERVER["HTTP_REFERER"] == "" ||
                 strpos($_SERVER["HTTP_REFERER"], $_SERVER['SERVER_NAME']) === false) {
            echo '<H3 align="center">Link failure</H3>';
            exit;
        }
        $session->set("ssmid", "default");

        if (array_key_exists("id", $_POST))
            $id = intval($_POST['id']); else
            $id = $idt;

        $query = "SELECT * from #__rem_houses where id = " . $id;
        $database->setQuery($query);
        $house = $database->loadObjectList();

        if (strpos($_SERVER["HTTP_REFERER"], $_SERVER['SERVER_NAME']) !== false) {
            $name = explode('/', $house[0]->edok_link);
            $file_path = $mosConfig_absolute_path .
             $realestatemanager_configuration['edocs']['location'] . $name[count($name) - 1];
            set_time_limit(0);
            PHP_realestatemanager::output_file($file_path, $name[count($name) - 1]);
            exit;
        } else {
            header("Cache-control: private");
            header('Pragma: private');
            header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
            header("HTTP/1.1 301 Moved Permanently");
            header('Content-Type: application/force-download');
            header("Location: " . $house[0]->edok_link);
            exit;
        }
    }

    static function saveRentRequest($option, $bids) {
        global $mainframe, $database, $my, $acl, $realestatemanager_configuration, $mosConfig_mailfrom, $Itemid, $os_rem_state;
        $pathway = sefRelToAbs('index.php?option=' . $option . '&amp;task=rent_request&amp;Itemid=' . $Itemid);

        // var_dump($_SERVER['HTTP_REFERER']);exit;
        $rent_from = protectInjectionWithoutQuote("rent_from", "");
        $rent_until = protectInjectionWithoutQuote("rent_until","");
        $how_many_weeks = protectInjectionWithoutQuote("how_many_weeks","");
        $how_many_monthes = protectInjectionWithoutQuote("how_many_monthes","");

        $data = JFactory::getDBO();

        PHP_realestatemanager::addTitleAndMetaTags();

        //*********************   begin compare to key   ***************************
        if ( $realestatemanager_configuration['captcha_option_booking']['show']=='1' ) {
            $i = checkAccess_REM($realestatemanager_configuration['captcha_option_booking']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl);
            if ($i) {
                $googleRecaptchaEnabled = rem_check_enabled_google_captcha_recaptcha();
                if( $googleRecaptchaEnabled ){
                    $captcha = JCaptcha::getInstance('recaptcha', array('namespace' => 'captcha_keystring_rent_request'));
                    if($captcha){
                        $get_answer = protectInjectionWithoutQuote('g-recaptcha-response', "");
                        if(!$get_answer ) {
                            mosRedirect($_SERVER['HTTP_REFERER'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                            exit();
                        }

                        $answer = $captcha->checkAnswer($get_answer);
                        //$answer = $captcha->checkAnswer('captcha_keystring_rent_request');
                        if(!$answer) {
                            mosRedirect($_SERVER['HTTP_REFERER'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                            exit();
                        }
                    }
                }
                else {
                    $session = JFactory::getSession();
                    $uniqid = trim(mosGetParam($_REQUEST, 'uniqid', ""));
                    $password = $session->get('captcha_keystring_' . $uniqid, 'default');
                    if ( array_key_exists('keyguest', $_POST) && ($_POST['keyguest'] != $password) ) {
                        mosRedirect($_SERVER['HTTP_REFERER'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                        exit;
                    }
                    else if ( !array_key_exists('keyguest', $_POST) ) {
                        mosRedirect($_SERVER['HTTP_REFERER'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                        exit;
                    }
                }
            }
        }
        //**********************   end compare to key   *****************************

        $jinput = JFactory::getApplication()->input;

        $path_way = $mainframe->getPathway();
        $path_way->addItem(_REALESTATE_MANAGER_LABEL_TITLE_RENT_REQUEST, $pathway);
        // --

        if (!($realestatemanager_configuration['rentstatus']['show'])
          || !checkAccess_REM($realestatemanager_configuration['rentrequest']['registrationlevel'],
              'NORECURSE', userGID_REM($my->id), $acl)) {
            echo _REALESTATE_MANAGER_NOT_AUTHORIZED;
            return;
        }

        $help = array();

        $rent_request = new mosRealEstateManager_rent_request($database);

        $post = $jinput->getArray($_POST);
        if (!$rent_request->bind($post)) {
            echo "<script> alert('" . $rent_request->getError() . "'); window.history.go(-1); </script>\n";
            exit;
        }

        $rent_request->rent_from = date_transform_rem($post['rent_from'],'to');
        
        $rent_request->rent_from = $rent_from_shrink_to = substr($rent_request->rent_from, 0, 10);
        if( isset($post['rent_until']) && $post['rent_until'] != "" ) {
         $rent_request->rent_until = date_transform_rem($post['rent_until'],'to');
         $rent_until_shrink_to = substr($rent_request->rent_until, 0, 10);   
        }
        else $rent_until_shrink_to =  calculate_rent_until_REM ( $rent_from, $rent_until,$rent_request->how_many_weeks,$rent_request->how_many_monthes) ;
        $rent_request->rent_until = $rent_until_shrink_to;


        if ($rent_from_shrink_to == "" or $rent_until_shrink_to == "") {
            echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_BAD_DATE_ALERT .
             "'); window.history.go(-1); </script>\n";
            exit;
        }
        if ($rent_from_shrink_to > $rent_until_shrink_to) {
            echo "<script> alert('" . $rent_from_shrink_to . " is more than " . $rent_until_shrink_to .
            "'); window.history.go(-1); </script>\n";
            exit;
        }

        $rent_request->user_email = ($rent_request->user_email);
        $rent_request->rent_request = date("Y-m-d H:i:s");
        $rent_request->fk_houseid = intval($_REQUEST["houseid"]);

        $query = "SELECT * FROM #__rem_rent where fk_houseid = " . $rent_request->fk_houseid .
          " AND rent_return is NULL ";
        $data->setQuery($query);
        $rentTerm = $data->loadObjectList();


        $house = new mosRealEstateManager($database);
        $house->load( $rent_request->fk_houseid );   

        foreach ($rentTerm as $oneTerm){
            $oneTerm->rent_from = substr($oneTerm->rent_from, 0, 10);
            $oneTerm->rent_until = substr($oneTerm->rent_until, 0, 10);
            $returnMessage = checkRentDayNightREM (($oneTerm->rent_from),($oneTerm->rent_until),
             $rent_from_shrink_to, $rent_until_shrink_to,$house->rent_by);

            if(strlen($returnMessage) > 0){
              echo "<script> alert('$returnMessage'); window.history.go(-1); </script>\n";
              exit;
            }
          }

        if ($my->id != 0)
            $rent_request->fk_userid = $my->id;
        if (!$rent_request->check()) {
            echo "<script> alert('" . $rent_request->getError() . "'); window.history.go(-1); </script>\n";
            exit;
        }

        if (!$rent_request->store()) {
            echo "<script> alert('" . $rent_request->getError() . "'); window.history.go(-1); </script>\n";
            exit;
        }

//**********************************************************************

        $houseId = $jinput->get('houseid');
        $calculeted_price = calculatePriceREM($houseId,$rent_from,$rent_until,$how_many_weeks,$how_many_monthes);

        $rent_request->checkin();
        array_push($help, $rent_request);


        // Parameters
        $menu = new JTableMenu($database);
        $menu->load($Itemid);
        $params = new JRegistry;
        $params->loadString($menu->params);

        // page header
        $currentcat = new stdClass();
        $currentcat->descrip = _REALESTATE_MANAGER_LABEL_RENT_REQUEST_THANKS;
        // page image
        $currentcat->img = "./components/com_realestatemanager/images/rem_logo.png";
        $currentcat->header = '';

        // used to show table rows in alternating colours
        $tabclass = array('sectiontableentry1', 'sectiontableentry2');

        if($realestatemanager_configuration['input_link_rent']=='1'){
            $backlink = JRoute::_($_SERVER['HTTP_REFERER']);
        }
        elseif($realestatemanager_configuration['input_link_rent']=='2'){
            $backlink = JRoute::_(JURI::root().'index.php?option=com_realestatemanager&view=all_houses&Itemid='.$Itemid);
        }
        else{
            $backlink = $realestatemanager_configuration['input_link_rent'];
        }
        HTML_realestatemanager::showRentRequestThanks($params, $backlink, $currentcat, $houseId, $calculeted_price);
    }



    static function saveBuyingRequest($option, $bids) {
        global $mainframe, $database, $my, $Itemid, $acl, $os_rem_state;
        global $realestatemanager_configuration, $mosConfig_mailfrom;
// echo __FILE__.":  ".__LINE__."<br />";
         $jinput = JFactory::getApplication()->input;

        //*********************   begin compare to key   ***************************
        if ( $realestatemanager_configuration['captcha_option_sendmessage']['show']=='1' ) {
             $i = checkAccess_REM($realestatemanager_configuration['captcha_option_sendmessage']['registrationlevel'],
              'NORECURSE', userGID_REM($my->id), $acl);
             if ($i) {
                $googleRecaptchaEnabled = rem_check_enabled_google_captcha_recaptcha();
                if( $googleRecaptchaEnabled ){
                    $captcha = JCaptcha::getInstance('recaptcha', array('namespace' => 'captcha_keystring_buy_request'));

                    if($captcha){
                        $get_answer = protectInjectionWithoutQuote('g-recaptcha-response', "");
                        if(!$get_answer ) {
                            mosRedirect($_SERVER['HTTP_REFERER'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                            exit();
                        }

                        $answer = $captcha->checkAnswer($get_answer);
                        //$answer = $captcha->checkAnswer('captcha_keystring_buy_request');
                        if(!$answer ) {
                            mosRedirect($_SERVER['HTTP_REFERER'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                            exit();
                        }
                    }
                }
                else {
                    $session = JFactory::getSession();
                    $uniqid = trim(mosGetParam($_REQUEST, 'uniqid', ""));
                    $password = $session->get('captcha_keystring_' . $uniqid, 'default');
                    if (array_key_exists('keyguest', $_POST) && ($_POST['keyguest'] != $password) ) {
                        mosRedirect($_SERVER['HTTP_REFERER'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                        exit;
                    } else if ( !array_key_exists('keyguest', $_POST) ) {
                        mosRedirect($_SERVER['HTTP_REFERER'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                        exit;
                    }
                }
            }
        }
        //**********************   end compare to key   *****************************

        if (!($realestatemanager_configuration['buystatus']['show']) ||
                !checkAccess_REM($realestatemanager_configuration['buyrequest']['registrationlevel'],
                 'NORECURSE', userGID_REM($my->id), $acl)) {
            echo _REALESTATE_MANAGER_NOT_AUTHORIZED;
            return;
        }

        $buying_request = new mosRealEstateManager_buying_request($database);

        $post = $jinput->getArray($_POST);
        if (!$buying_request->bind($post)) {
            echo $buying_request->getError();
            exit;
        }

        $buying_request->customer_email = ($buying_request->customer_email);
        $buying_request->buying_request = date("Y-m-d H:i:s");
        $buying_request->fk_houseid = $bids[0];
        $houseId = $bids[0];
        if (!$buying_request->store())
            echo "error:" . $buying_request->getError();


        // Parameters
        $menu = new JTableMenu($database);
        $menu->load($Itemid);
        $params = new JRegistry;
        $params->loadString($menu->params);


        // page header
        $currentcat = new stdClass();
        $currentcat->descrip = _REALESTATE_MANAGER_LABEL_BUYING_REQUEST_THANKS;
        $currentcat->img = "./components/com_realestatemanager/images/rem_logo.png";
        $currentcat->header = '';

        //$backlink = JRoute::_($_SERVER['HTTP_REFERER']);

        if($realestatemanager_configuration['input_link_sale']=='1'){
            $backlink = JRoute::_($_SERVER['HTTP_REFERER']);
        }
        elseif($realestatemanager_configuration['input_link_sale']=='2'){
            $backlink = JRoute::_(JURI::root().'index.php?option=com_realestatemanager&view=all_houses&Itemid='.$Itemid);
        }
        else{
            $backlink = $realestatemanager_configuration['input_link_sale'];
        }
        HTML_realestatemanager::showRentRequestThanks($params, $backlink, $currentcat, $houseId);
    }


    static function save_property_request($option, $bids) {
        global $mainframe, $database, $my, $Itemid, $acl, $os_rem_state;
        global $realestatemanager_configuration, $mosConfig_mailfrom;
// echo __FILE__.":  ".__LINE__."<br />";
         $jinput = JFactory::getApplication()->input;

        //*********************   begin compare to key   ***************************
        if ( $realestatemanager_configuration['captcha_option_property_request']['show']=='1' ) {
             $i = checkAccess_REM($realestatemanager_configuration['captcha_option_property_request']['registrationlevel'],
              'NORECURSE', userGID_REM($my->id), $acl);
             if ($i) {
                $googleRecaptchaEnabled = rem_check_enabled_google_captcha_recaptcha();
                if( $googleRecaptchaEnabled ){
                    $captcha = JCaptcha::getInstance('recaptcha', array('namespace' => 'captcha_keystring_property_request'));

                    if($captcha){
                        $get_answer = protectInjectionWithoutQuote('g-recaptcha-response', "");
                        if(!$get_answer ) {
                            mosRedirect($_SERVER['HTTP_REFERER'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                            exit();
                        }

                        $answer = $captcha->checkAnswer($get_answer);
                        if(!$answer ) {
                            mosRedirect($_SERVER['HTTP_REFERER'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                            exit();
                        }
                    }
                }
                else {
                    $session = JFactory::getSession();
                    $uniqid = trim(mosGetParam($_REQUEST, 'uniqid', ""));
                    $password = $session->get('captcha_keystring_' . $uniqid, 'default');
                    if (array_key_exists('keyguest', $_POST) && ($_POST['keyguest'] != $password) ) {
                        mosRedirect($_SERVER['HTTP_REFERER'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                        exit;
                    } else if ( !array_key_exists('keyguest', $_POST) ) {
                        mosRedirect($_SERVER['HTTP_REFERER'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                        exit;
                    }
                }
            }
        }
        //**********************   end compare to key   *****************************

        if (!($realestatemanager_configuration['property_request']['show']) ||
                !checkAccess_REM($realestatemanager_configuration['property_request']['registrationlevel'],
                 'NORECURSE', userGID_REM($my->id), $acl)) {
            echo _REALESTATE_MANAGER_NOT_AUTHORIZED;
            return;
        }

        $property_request = new mosRealEstateManager_property_request($database);

        $post = $jinput->getArray($_POST);
        if (!$property_request->bind($post)) {
            echo $property_request->getError();
            exit;
        }

        $property_request->customer_email = ($property_request->customer_email);
        $property_request->property_request = date("Y-m-d H:i:s");
        $property_request->fk_houseid = $bids[0];
        if (!$property_request->store())
            echo "error:" . $property_request->getError();


        // Parameters
        $menu = new JTableMenu($database);
        $menu->load($Itemid);
        $params = new JRegistry;
        $params->loadString($menu->params);

        // page header
        $currentcat = new stdClass();
        $currentcat->descrip = _REALESTATE_MANAGER_LABEL_PROPERTY_REQUEST_THANKS;

        $currentcat->img = "./components/com_realestatemanager/images/rem_logo.png";
        $currentcat->header = '';




        $query = "SELECT * FROM #__rem_houses where id= " . $property_request->fk_houseid;
        $database->setQuery($query);
        $houseid = $database->loadObject();

        //$backlink = JRoute::_($_SERVER['HTTP_REFERER']);

        if($realestatemanager_configuration['input_link_property_request']=='1'){
            $backlink = JRoute::_($_SERVER['HTTP_REFERER']);
        }
        elseif($realestatemanager_configuration['input_link_property_request']=='2'){
            $backlink = JRoute::_(JURI::root().'index.php?option=com_realestatemanager&view=all_houses&Itemid='.$Itemid);
        }
        else{
            $backlink = $realestatemanager_configuration['input_link_property_request'];
        }

        HTML_realestatemanager::showRentRequestThanks($params, $backlink, $currentcat);
    }


    static function showRentRequest($option, $bid) {  
        global $mainframe, $database, $my, $Itemid, $acl, $realestatemanager_configuration, $os_rem_state;

        $pathway = sefRelToAbs('index.php?option=' . $option . '&amp;task=rent_request&amp;Itemid=' . $Itemid);

        
        $path_way = $mainframe->getPathway();
        $path_way->addItem(_REALESTATE_MANAGER_LABEL_TITLE_RENT_REQUEST, $pathway);
        // --

        if (!($realestatemanager_configuration['rentstatus']['show']) ||
         !checkAccess_REM($realestatemanager_configuration['rentrequest']['registrationlevel'],
          'NORECURSE', userGID_REM($my->id), $acl)) {
            echo _REALESTATE_MANAGER_NOT_AUTHORIZED;
            return;
        }

        $bids = implode(',', $bid);

        // getting all houses for this category
        $query = "SELECT * FROM #__rem_houses"
                . "\nWHERE `id` IN (" . $bids . ") ORDER BY `catid`, `ordering`";
        $database->setQuery($query);
        $houses = $database->loadObjectList();


        // Parameters
        $menu = new JTableMenu($database);
        $menu->load($Itemid);
        $params = new JRegistry;
        $params->loadString($menu->params);

        $params->def('show_rentstatus', 1);
        $params->def('show_rentrequest', 1);
        $params->def('rent_save', 1);

        $currentcat = new stdClass();
        $currentcat->descrip = _REALESTATE_MANAGER_DESC_RENT;

        // used to show table rows in alternating colours
        $tabclass = array('sectiontableentry1', 'sectiontableentry2');

        HTML_realestatemanager::showRentRequest($houses, $currentcat, $params, $tabclass,
         $catid, $sub_categories, false, $option);
    }

    /**
     * comments for registered users
     */
    static function reviewHouse() {
        global $mainframe, $database, $my, $Itemid, $acl, $realestatemanager_configuration,
         $mosConfig_absolute_path, $catid;
        global $mosConfig_mailfrom, $session, $option, $os_rem_state;

        //*********************   begin compare to key   ***************************
        if ( $realestatemanager_configuration['captcha_option']['show']=='1' ) {
            $i = checkAccess_REM($realestatemanager_configuration['captcha_option']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl);
            if ($i) {

                $googleRecaptchaEnabled = rem_check_enabled_google_captcha_recaptcha();
                if( $googleRecaptchaEnabled ){
                    $captcha = JCaptcha::getInstance('recaptcha', array('namespace' => 'captcha_keystring_review'));
                    if($captcha){
                        $get_answer = protectInjectionWithoutQuote('g-recaptcha-response', "");
                        if(!$get_answer ) {
                            mosRedirect("index.php?option=com_realestatemanager&task=view&catid=" . intval($_POST["catid"]) . "&id=" .
                                    intval($_POST["fk_houseid"]) . "&Itemid=$Itemid&title=" . $_POST['title'] . "&comment=" .
                                    $_POST['comment'] . "&rating=" . $_POST['rating'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                            exit();
                        }

                        $answer = $captcha->checkAnswer($get_answer);
                        //$answer = $captcha->checkAnswer('captcha_keystring_review');
                        if(!$answer ) {
                            mosRedirect("index.php?option=com_realestatemanager&task=view&catid=" . intval($_POST["catid"]) . "&id=" .
                                    intval($_POST["fk_houseid"]) . "&Itemid=$Itemid&title=" . $_POST['title'] . "&comment=" .
                                    $_POST['comment'] . "&rating=" . $_POST['rating'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                            exit();
                        }
                    }
                }
                else {
                    $session = JFactory::getSession();
                    $uniqid = trim(mosGetParam($_REQUEST, 'uniqid', ""));
                    $password = $session->get('captcha_keystring_' . $uniqid, 'default');
                    if (array_key_exists('keyguest', $_POST) && ($_POST['keyguest'] != $password) ) {
                        mosRedirect("index.php?option=com_realestatemanager&task=view&catid=" . intval($_POST["catid"]) . "&id=" .
                                intval($_POST["fk_houseid"]) . "&Itemid=$Itemid&title=" . $_POST['title'] . "&comment=" .
                                $_POST['comment'] . "&rating=" . $_POST['rating'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                        exit;
                    } elseif ( !array_key_exists('keyguest', $_POST) ) {
                        mosRedirect("index.php?option=com_realestatemanager&task=view&catid=" . intval($_POST["catid"]) . "&id=" .
                                intval($_POST["fk_houseid"]) . "&Itemid=$Itemid&title=" . $_POST['title'] . "&comment=" .
                                $_POST['comment'] . "&rating=" . $_POST['rating'], _REALESTATE_MANAGER_LABEL_ERROR_CAPTCHA);
                        exit;
                    }
                }

            }
        }
        //**********************   end compare to key   *****************************

        if (!($realestatemanager_configuration['reviews']['show']) ||
         !checkAccess_REM($realestatemanager_configuration['reviews']['registrationlevel'],
          'NORECURSE', userGID_REM($my->id), $acl)) {
            echo _REALESTATE_MANAGER_NOT_AUTHORIZED;
            return;
        }
        $review = new mosRealEstateManager_review($database);
        $jinput = JFactory::getApplication()->input;
        //************publish_on_review begin
        if ($realestatemanager_configuration['publish_on_review']['show']) {
            if (checkAccess_REM($realestatemanager_configuration['publish_on_review']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $review->published = 1;
            }
            else
                $review->published = 0;
        }
        else
            $review->published = 0;


        //************publish on add end

        $review->date = date("Y-m-d H:i:s");
        $review->getReviewFrom($my->id);

        $post = $jinput->getArray($_POST);
        if (!$review->bind($post)) {
            echo "<script> alert('" . $review->getError() . "'); window.history.go(-1); </script>\n";
            exit;
        }
        $review->rating = $_POST['rating'];
        if (version_compare(JVERSION, "3.0", "ge"))
            $review->rating *= 2;
        if (!$review->check()) {
            echo "<script> alert('" . $review->getError() . "'); window.history.go(-1); </script>\n";
            exit;
        }
        if (!$review->store()) {
            echo "<script> alert('" . $review->getError() . "'); window.history.go(-1); </script>\n";
            exit;
        }

        //showing the original entries
        mosRedirect("index.php?option=" . $option . "&task=view_house&catid=" . intval($_POST['catid'])
         . "&id=$review->fk_houseid&Itemid=$Itemid");
    }


    static function constructPathway($cat) {
        global $mainframe, $database, $option, $Itemid, $mosConfig_absolute_path;

        $app = JFactory::getApplication();
        $path_way = $app->getPathway();

        $query = "SELECT * FROM #__rem_main_categories WHERE section = 'com_realestatemanager' AND published = 1";
        $database->setQuery($query);
        $rows = $database->loadObjectlist('id');
        if ($cat != NULL)
            $pid = $cat->id;  //need check
        $pathway = array();
        $pathway_name = array();
        while ($pid != 0) {
            $cat = @$rows[$pid];
            $pathway[] = sefRelToAbs('index.php?option=' . $option .
             '&task=showCategory&catid=' . @$cat->id . '&Itemid=' . $Itemid);
            $pathway_name[] = @$cat->title;
            $pid = @$cat->parent_id;
        }
        $pathway = array_reverse($pathway);
        $pathway_name = array_reverse($pathway_name);

        for ($i = 0, $n = count($pathway); $i < $n; $i++) {
            $path_way->addItem($pathway_name[$i], $pathway[$i]);
        }
    }

    //get current user groups
    static function getUserGroups() {
        if (version_compare(JVERSION, "4.0.0", "ge")) {
            $app = JFactory::getApplication();
            $my = $app->getIdentity();
        } else {
        $my = JFactory::getUser();
        }        
        $acl = new JAccess;
        $usergroups = $acl->get_group_parents($my->gid, 'ARO', 'NORECURSE');
        if ($usergroups)
            $usergroups = ',' . implode(',', $usergroups); else
            $usergroups = '';
        return '-2,' . $my->gid . $usergroups;
    }

     static function showCategory($catid, $printItem, $option, $layout, $languagelocale) {

        global $mainframe, $database, $acl, $my, $langContent;
        global $mosConfig_shownoauth, $mosConfig_live_site, $mosConfig_absolute_path;
        global $cur_template, $Itemid, $realestatemanager_configuration;
        global $mosConfig_list_limit, $limit, $total, $limitstart;

        PHP_realestatemanager::addTitleAndMetaTags($catid);
        //getting the current category informations
        $database->setQuery("SELECT * FROM #__rem_main_categories WHERE id='" . intval($catid) . "'");
        $category = $database->loadObjectList();
        if (isset($category[0]))
            $category = $category[0];
        else {
            echo _REALESTATE_MANAGER_ERROR_ACCESS_PAGE;
            return;
        }

        if ($category->params == '')  $category->params = '-2';

        if (!checkAccess_REM($category->params, 'NORECURSE', userGID_REM($my->id), $acl)) {
            echo _REALESTATE_MANAGER_ERROR_ACCESS_PAGE;
            return;
        }
        //sorting

        $item_session = JFactory::getSession();
        $sort_arr = $item_session->get('rem_housesort', '');
        if (is_array($sort_arr)) {
            $tmp1 = mosGetParam($_POST, 'order_direction');
            if ($tmp1 != '') {
                $sort_arr['order_direction'] = $tmp1;
            }
            $tmp1 = mosGetParam($_POST, 'order_field');
            //$tmp1= $database->Quote($tmp1);
            if ($tmp1 != '') {
                $sort_arr['order_field'] = $tmp1;
            }
            $item_session->set('rem_housesort', $sort_arr);
        } else {
            $sort_arr = array();
            $sort_arr['order_direction'] = 'asc';
            if(isset($realestatemanager_configuration['order_by_default']) && $realestatemanager_configuration['order_by_default'] != ''){
                 $sort_arr['order_field'] = $realestatemanager_configuration['order_by_default'];
                 if($sort_arr['order_field'] == 'date') $sort_arr['order_direction'] = 'desc';
            }
            else{
                $sort_arr['order_field'] = 'date';
            }

            $item_session->set('rem_housesort', $sort_arr);
        }
        if ($sort_arr['order_field'] == "price")
            $sort_string = "CAST( " . $sort_arr['order_field'] . " AS SIGNED)" . " " . $sort_arr['order_direction'];
        else
            $sort_string = $sort_arr['order_field'] . " " . $sort_arr['order_direction'];

        if (isset($langContent)) {

            $lang = $langContent;

            $lang = " and ( h.language = '$lang' or h.language like 'all' or h.language like '' "
             . " or h.language like '*' or h.language is null) "
             . " AND ( c.language = '$lang' or c.language like 'all' or c.language like '' or "
             . " c.language like '*' or c.language is null) ";
        } else {
            $lang = "";
        }
        $s = getWhereUsergroupsCondition('c');
        $s_cat = getWhereDatePublishStringRem('c');
        $s_h = getWhereDatePublishStringRem('h');

        $query = "SELECT COUNT(DISTINCT h.id)
            \nFROM #__rem_houses AS h"
                . "\nLEFT JOIN #__rem_categories AS hc ON hc.iditem=h.id"
                . "\nLEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat"
                . "\nWHERE c.id = '$catid' AND h.published='1' $lang " .
                " AND h.approved='1' AND c.published='1' " .
                " AND ($s) AND ($s_cat) AND ($s_h)";

        $database->setQuery($query);
        $total = $database->loadResult();


        $pageNav = new JPagination($total, $limitstart, $limit); 
        // getting all houses for this category

        $query = "SELECT h.*,hc.idcat AS catid,hc.idcat AS idcat, c.title as category_title "
                . "\nFROM #__rem_houses AS h "
                . "\nLEFT JOIN #__rem_categories AS hc ON hc.iditem=h.id "
                . "\nLEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat "
                . "\nWHERE hc.idcat = '" . $catid . "' AND h.published='1' "
                . "\n AND c.published='1' $lang AND ($s) AND ($s_cat) AND ($s_h)"
                . "\nGROUP BY h.id"
                . "\nORDER BY " . $sort_string
                . "\nLIMIT $pageNav->limitstart,$pageNav->limit;";


        $database->setQuery($query);
        $houses = $database->loadObjectList();

        // For show all houses from subcategories which are included in main category use this request
        //(just comment request to not display subcategory houses)

        // $query = "SELECT id FROM #__rem_main_categories WHERE parent_id = '" . $catid . "'";
        // $database->setQuery($query);
        // $if_parent = $database->loadColumn();
        // if(!empty($if_parent)){
        //     foreach($if_parent as $parent_cat){
        //         $query = "SELECT h.*,hc.idcat AS catid,hc.idcat AS idcat, c.title as category_title "
        //                 . "\nFROM #__rem_houses AS h "
        //                 . "\nLEFT JOIN #__rem_categories AS hc ON hc.iditem=h.id "
        //                 . "\nLEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat "
        //                 . "\nWHERE hc.idcat = '" . $parent_cat . "' AND h.published='1' "
        //                 . "\n AND c.published='1'  $lang AND ($s)"
        //                 . "\nGROUP BY h.id"
        //                 . "\nORDER BY " . $sort_string
        //                 . "\nLIMIT $pageNav->limitstart,$pageNav->limit;";
        //         $database->setQuery($query);
        //         $child_houses = $database->loadObjectList();
        //         $houses = array_merge($child_houses,$houses);
        //         $query = "SELECT id FROM #__rem_main_categories WHERE parent_id = '" . $parent_cat . "'";
        //         $database->setQuery($query);
        //         $if_parent2 = $database->loadColumn();
        //         foreach($if_parent2 as $child_id){
        //             $query = "SELECT h.*,hc.idcat AS catid,hc.idcat AS idcat, c.title as category_title "
        //                     . "\nFROM #__rem_houses AS h "
        //                     . "\nLEFT JOIN #__rem_categories AS hc ON hc.iditem=h.id "
        //                     . "\nLEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat "
        //                     . "\nWHERE hc.idcat = '" . $child_id . "' AND h.published='1' "
        //                     . "\n AND c.published='1'  $lang AND ($s)"
        //                     . "\nGROUP BY h.id"
        //                     . "\nORDER BY " . $sort_string
        //                     . "\nLIMIT $pageNav->limitstart,$pageNav->limit;";
        //             $database->setQuery($query);
        //             $child_houses = $database->loadObjectList();
        //             $houses = array_merge($child_houses,$houses);
        //         }
        //     }
        // }


        $query = "SELECT h.*,c.id, c.parent_id, c.title, c.image,COUNT(hc.iditem) as houses,
        '1' as display" .
                " \n FROM  #__rem_main_categories as c " .
                " \n LEFT JOIN #__rem_categories AS hc ON hc.idcat=c.id " .
                " \n LEFT JOIN #__rem_houses AS h ON h.id=hc.iditem " .
                "  \n WHERE c.section='com_realestatemanager'  $lang "
                . " AND c.published=1 AND ({$s}) AND ({$s_cat}) AND ({$s_h})
        \n GROUP BY c.id
        \n ORDER BY c.parent_id DESC, c.ordering ";

        $database->setQuery($query);
        $cat_all = $database->loadObjectList();

        foreach ($cat_all as $k1 => $cat_item1) {
            $query = "SELECT COUNT(hc.iditem) as houses" .
                         "\n FROM  #__rem_main_categories as c " .
                         "\n LEFT JOIN #__rem_categories AS hc ON hc.idcat=c.id " .
                         "\n LEFT JOIN #__rem_houses AS h ON h.id=hc.iditem " .
                         "\n WHERE c.section='com_realestatemanager' AND c.published=1  $lang
                          \n AND ( h.published || isnull(h.published) ) AND ( h.approved || isnull(h.approved )) AND ({$s}) AND ({$s_cat}) AND ({$s_h})
                          \n AND c.id = " . $cat_all[$k1]->id . "
                          \n GROUP BY c.id";

                    $database->setQuery($query);

                    $houses_count = $database->loadObjectList();
                    if($houses_count)
                        $cat_all[$k1]->houses = $houses_count[0]->houses;
                    else
                        $cat_all[$k1]->houses = 0;
        }


        // Parameters
        $menu = new JTableMenu($database); 
        $menu->load($Itemid);
        $params = new JRegistry;
        $params->loadString($menu->params);


        
                
        $params->def('show_category', 1);
        $params->def('category_name', $category->title);
        //-----------------------------------------------------------------
        if ($layout==''){
            $layout = ($params->get('allhouselayout'));
        }

        if(protectInjectionWithoutQuote('module', '', 'STRING') == 'mod_realestatemanager_featured'){

            $layout = 'default';
        }
        PHP_realestatemanager::constructPathway($category);

        if (($realestatemanager_configuration['rentstatus']['show'])) {
            if (checkAccess_REM($realestatemanager_configuration['rentrequest']['registrationlevel'],
             'RECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_rentstatus', 1);
                $params->def('show_rentrequest', 1);
            }
        }

        if ($realestatemanager_configuration['housestatus']['show']) {
            $params->def('show_housestatus', 1);
            if (checkAccess_REM($realestatemanager_configuration['houserequest']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_houserequest', 1);
            }
        }
        if ($realestatemanager_configuration['price']['show']) {
            $params->def('show_pricestatus', 1);
            if (checkAccess_REM($realestatemanager_configuration['price']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_pricerequest', 1);
            }
        }

        if ($realestatemanager_configuration['search_button']['show']) {
            $params->def('show_search_button', 1);
            if (checkAccess_REM($realestatemanager_configuration['search_button']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_input_search_button', 1);
            }
        }
        //**************   end show search alone category     ******************************

        if ($realestatemanager_configuration['search_alone_category']['show']) {
            $params->def('search_alone_category', 1);
            if (checkAccess_REM($realestatemanager_configuration['search_alone_category']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('search_alone_category_registrationlevel', 1);
            }
        }
        //**************   end show search alone category    ******************************
        $params->def('sort_arr_order_direction', $sort_arr['order_direction']);
        $params->def('sort_arr_order_field', $sort_arr['order_field']);

        //add for show in category picture
        if ($realestatemanager_configuration['cat_pic']['show'])
            $params->def('show_cat_pic', 1);

        $params->def('show_rating', 1);
        $params->def('hits', 1);

        $currentcat = new stdClass();
        $currentcat->descrip = $category->description;


        $currentcat->header = $category->title;


        // used to show table rows in alternating colours
        $tabclass = array('sectiontableentry1', 'sectiontableentry2');

        $params->def('minifotohigh', $realestatemanager_configuration['foto']['high']);
        $params->def('minifotowidth', $realestatemanager_configuration['foto']['width']);

        foreach ($houses as $house) {
            if ($house->language != '*') {
                $query = "SELECT sef FROM #__languages WHERE lang_code = '$house->language'";
                $database->setQuery($query);
                $house->language = $database->loadResult();
            }
        }

        $params->def('singlecategory01', "{loadposition com_realestatemanager_single_category_01,xhtml}");
        $params->def('singlecategory02', "{loadposition com_realestatemanager_single_category_02,xhtml}");
        $params->def('singlecategory03', "{loadposition com_realestatemanager_single_category_03,xhtml}");
        $params->def('singlecategory04', "{loadposition com_realestatemanager_single_category_04,xhtml}");
        $params->def('singlecategory05', "{loadposition com_realestatemanager_single_category_05,xhtml}");
        $params->def('singlecategory06', "{loadposition com_realestatemanager_single_category_06,xhtml}");
        $params->def('singlecategory07', "{loadposition com_realestatemanager_single_category_07,xhtml}");
        $params->def('singlecategory08', "{loadposition com_realestatemanager_single_category_08,xhtml}");
        $params->def('singlecategory09', "{loadposition com_realestatemanager_single_category_09,xhtml}");
        $params->def('singlecategory10', "{loadposition com_realestatemanager_single_category_10,xhtml}");
        $params->def('singlecategory11', "{loadposition com_realestatemanager_single_category_11,xhtml}");
        $params->def('typeLayout', 'alone_category');

        if (empty($houses)) {
            HTML_realestatemanager::displayHouses_empty($houses, $currentcat, $params,
               $tabclass, $catid, $cat_all, $pageNav,PHP_realestatemanager::is_exist_subcategory_houses($catid), $option);
        } else {
          switch ($printItem) {
            default:
                HTML_realestatemanager::displayHouses($houses, $currentcat, $params, $tabclass, $catid, $cat_all, $pageNav,PHP_realestatemanager::is_exist_subcategory_houses($catid), $option, $layout);
                break;
          }
        }
    }

    static function showItemREM($option, $id, $catid, $printItem, $layout) {
        global $mainframe, $database, $my, $acl, $option;
        global $mosConfig_shownoauth, $mosConfig_live_site, $mosConfig_absolute_path;
        global $cur_template, $Itemid, $realestatemanager_configuration;

        PHP_realestatemanager::addTitleAndMetaTags($id);

        $database->setQuery("SELECT id FROM #__rem_houses where id=$id ");
        if (version_compare(JVERSION, "3.0.0", "lt"))
            $trueid = $database->loadResultArray();
        else
            $trueid = $database->loadColumn();
        if (!in_array(intval($id), $trueid)) {
            echo _REALESTATE_MANAGER_ERROR_ACCESS_PAGE;
            return;
        }
        //add to path category name
        //getting the current category informations
        $query = "SELECT * FROM #__rem_main_categories WHERE id='" . intval($catid) . "'";

        $database->setQuery($query);
        $category = $database->loadObjectList();

        if (isset($category[0]))
            $category = $category[0];
        else {
            echo _REALESTATE_MANAGER_ERROR_ACCESS_PAGE;
            return;
        }

        //Record the hit
        $sql = "UPDATE #__rem_houses SET hits = hits + 1 WHERE id = " . $id . "";
        $database->setQuery($sql);
        $database->execute();

        $sql2 = "UPDATE #__rem_houses SET featured_clicks = featured_clicks - 1 "
         . " WHERE featured_clicks != '' and featured_clicks > 0 and id = " . $id . "";
        $database->setQuery($sql2);
        $database->execute();

        $sql3 = "UPDATE #__rem_houses SET featured_shows = featured_shows - 1 "
         . " WHERE featured_shows != '' and featured_shows > 0 and id = " . $id . "";
        $database->setQuery($sql3);
        $database->execute();

        //load the house
        $house = new mosRealEstateManager($database);
        $house->load($id);
        $house->setOwnerName();
        $access = $house->getAccess_REM();

        // for breadcrumbs
        PHP_realestatemanager::constructPathway($category);
        $path_way = $mainframe->getPathway();
        $path_way->addItem(substr($house->htitle, 0, 32) . "");

        // Abort an user if he edit a house more then 2 hours (7200 sec)
        $user_checked_out_houses = " UPDATE #__rem_houses SET checked_out=0, checked_out_time='0000-00-00 00:00:00'
            WHERE `checked_out_time` > 0 AND ( TIME_TO_SEC('" . date('Y-m-d H:i:s') . "') - TIME_TO_SEC(`checked_out_time`) ) >= 7200;";
        $database->setQuery($user_checked_out_houses);
        $database->execute();

        if (!checkAccess_REM($access, 'RECURSE', userGID_REM($my->id), $acl)) {
            echo _REALESTATE_MANAGER_ERROR_ACCESS_PAGE;
            return;
        }
        if ($house->owneremail != $my->email) {
            if ($house->published == 0) {
                echo _REALESTATE_MANAGER_ERROR_HOUSE_NOT_PUBLISHED;
                return;
            }
            if ($house->approved == 0) {
                echo _REALESTATE_MANAGER_ERROR_HOUSE_NOT_APPROVED;
                return;
            }
        }
        // $path_way->addItem(substr($house->htitle, 0, 32) . "");
        /////////////////////////////////////////////////////////////////////////////////////
        //Select list for listing type
        $listing_type[0] = _REALESTATE_MANAGER_OPTION_SELECT;
        $listing_type[3] = _REALESTATE_MANAGER_OPTION_FOR_PROPERTY_REQUEST;
        $listing_type[1] = _REALESTATE_MANAGER_OPTION_FOR_RENT;
        $listing_type[2] = _REALESTATE_MANAGER_OPTION_FOR_SALE;

        //Select list for listing status
        $listing_status[_REALESTATE_MANAGER_OPTION_SELECT] = 0;
        $listing_status1 = explode(',', _REALESTATE_MANAGER_OPTION_LISTING_STATUS);
        $i = 1;
        foreach ($listing_status1 as $listing_status2) {
            $listing_status[$listing_status2] = $i;
            $i++;
        }

        //Select list for property type
        $property_type[_REALESTATE_MANAGER_OPTION_SELECT] = 0;
        $property_type1 = explode(',', _REALESTATE_MANAGER_OPTION_PROPERTY_TYPE);
        $i = 1;
        foreach ($property_type1 as $property_type2) {
            $property_type[$property_type2] = $i;
            $i++;
        }


        ////////////////////////////////////////////////////////////
        // Parameters
        $menu = new JTableMenu($database); 
        // Parameters
        $menu = new JTableMenu($database);
        $menu->load($Itemid);
        $params = new JRegistry;
        $params->loadString($menu->params);

        if (!isset($my->id)) { 
            $my->id = 0;
        }

        if ($realestatemanager_configuration['calendarlist']['show']) {
            $params->def('calendarlist_show', 1);
            if (checkAccess_REM($realestatemanager_configuration['calendarlist']['registrationlevel'],
               'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('calendarlist_registrationlevel', 1);
            }
        }

        if ($realestatemanager_configuration['additional_tab']['show']) {
            $params->def('additional_tab_show', 1);
            if (checkAccess_REM($realestatemanager_configuration['additional_tab']['registrationlevel'],
               'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('additional_tab_registrationlevel', 1);
            }
        }        


        if ($realestatemanager_configuration['rentstatus']['show']) {
            $params->def('show_rentstatus', 1);
            if (checkAccess_REM($realestatemanager_configuration['rentrequest']['registrationlevel'],
              'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_rentrequest', 1);
            }
        }

        if ($realestatemanager_configuration['buystatus']['show']) {
            $params->def('show_buystatus', 1);
            if (checkAccess_REM($realestatemanager_configuration['buyrequest']['registrationlevel'],
              'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_buyrequest', 1);
            }
        }

        if ($realestatemanager_configuration['property_request']['show']) {
            $params->def('show_property_request_status', 1);
            if (checkAccess_REM($realestatemanager_configuration['property_request']['registrationlevel'],
              'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_property_request', 1);
            }
        }

        if ($realestatemanager_configuration['reviews']['show']) {
            $params->def('show_reviews', 1);
            if (checkAccess_REM($realestatemanager_configuration['reviews']['registrationlevel'],
               'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_inputreviews', 1);
            }
        }

        if ($realestatemanager_configuration['edocs']['show']) {
            $params->def('show_edocstatus', 1);
            if (checkAccess_REM($realestatemanager_configuration['edocs']['registrationlevel'],
               'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_edocsrequest', 1); //+18.01
                //+18.01
            }
        }

        if ($realestatemanager_configuration['price']['show']) {
            $params->def('show_pricestatus', 1);
            if (checkAccess_REM($realestatemanager_configuration['price']['registrationlevel'],
              'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_pricerequest', 1); //+18.01
            }
        }

        if ($realestatemanager_configuration['sale_separator']) {
            $params->def('show_sale_separator', 1);
        }

        //************   begin show 'location and reviews tab'   ***************
        if (($realestatemanager_configuration['location_tab']['show'])) {
            $params->def('show_location', 1);
            if (checkAccess_REM($realestatemanager_configuration['location_tab']['registrationlevel'],
               'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_locationtab_registrationlevel', 1); //+18.01
            }
        }

        //************   begin show 'location and reviews tab'   ***************
        if (($realestatemanager_configuration['street_view']['show'])) {
            $params->def('street_view', 1);
            if (checkAccess_REM($realestatemanager_configuration['street_view']['registrationlevel'],
               'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('street_view_registrationlevel', 1); //+18.01
            }
        }

        if (($realestatemanager_configuration['reviews_tab']['show'])) {
            $params->def('show_reviews_tab', 1);
            if (checkAccess_REM($realestatemanager_configuration['reviews_tab']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_reviewstab_registrationlevel', 1); //+18.01
            }
        }
        //************   end show 'location and reviews tab'   ***************
        //************   begin show 'contacts'   ***************************
        if (($realestatemanager_configuration['contacts']['show'])) {

            $params->def('show_contacts_line', 1);

            $i = checkAccess_REM($realestatemanager_configuration['contacts']['registrationlevel'],
               'NORECURSE', userGID_REM($my->id), $acl);
            if ($i && isset($house->contacts) && trim($house->contacts)  ) {
                $params->def('show_contacts_registrationlevel', 1); 
            }
        }

        if (($realestatemanager_configuration['owner']['show'])) {
            $params->def('show_owner_line', 1);
            $i = checkAccess_REM($realestatemanager_configuration['owner']['registrationlevel'],
              'NORECURSE', userGID_REM($my->id), $acl);
            if ($i && ( $house->ownername != '' || $house->owneremail != '') ) {
                $params->def('show_owner_registrationlevel', 1);
            }
        }

        if (($realestatemanager_configuration['captcha_option']['show'])) {
            $params->def('captcha_option', 1);
            $i = checkAccess_REM($realestatemanager_configuration['captcha_option']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl);
            if ($i) {
                $params->def('captcha_option_registrationlevel', 1); 
            }
        }

        if (($realestatemanager_configuration['captcha_option_booking']['show'])) {
            $params->def('captcha_option_booking', 1);
            $i = checkAccess_REM($realestatemanager_configuration['captcha_option_booking']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl);
            if ($i) {
                $params->def('captcha_option_booking_registrationlevel', 1); 
            }
        }

        if (($realestatemanager_configuration['captcha_option_sendmessage']['show'])) {
            $params->def('captcha_option_sendmessage', 1);
            $i = checkAccess_REM($realestatemanager_configuration['captcha_option_sendmessage']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl);
            if ($i) {
                $params->def('captcha_option_sendmessage_registrationlevel', 1); 
            }
        }

        if (($realestatemanager_configuration['captcha_option_property_request']['show'])) {
            $params->def('captcha_option_property_request', 1);
            $i = checkAccess_REM($realestatemanager_configuration['captcha_option_property_request']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl);
            if ($i) {
                $params->def('captcha_option_property_request_registrationlevel', 1); 
            }
        }

        if (($realestatemanager_configuration['captcha_option_add_house']['show'])) {
            $params->def('captcha_option_add_house', 1);
            $i = checkAccess_REM($realestatemanager_configuration['captcha_option_add_house']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl);
            if ($i) {
                $params->def('captcha_option_add_house_registrationlevel', 1); 
            }
        }

        if ($realestatemanager_configuration['housestatus']['show']) {
            $params->def('show_housestatus', 1);
            if (checkAccess_REM($realestatemanager_configuration['houserequest']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_houserequest', 1);
            }
        }

        //******************************************** add diagramm **********************************
        if($realestatemanager_configuration['energy_field_show']) {
            $energy_value = $house->energy_value;
            $climate_value = $house->climate_value;
            $show_en = true;
            $show_cl = true;

            if(empty($energy_value)){
                $show_en = false;
            }

            if(empty($climate_value)){
                $show_cl = false;
            }

            require_once JPATH_SITE . '/components/com_realestatemanager/views/view_house/tmpl/_diagramm.php';

            $result = diagram($energy_value, $climate_value, $energy_value, $climate_value);
            $params->def('diagramma', $result);
        }
    //******************************************** end add diagramm ******************************

        $params->def('item_description', 1);
        $params->def('show_edoc', $realestatemanager_configuration['edocs']['show']);


        // page header
        $currentcat = new stdClass();
        $currentcat->descrip = "";
        $currentcat->header = '';


        $query = "select main_img from #__rem_photos WHERE fk_houseid='$house->id' order by img_ordering,id";
        $database->setQuery($query);
        $house_photos = $database->loadObjectList();
        // show the house

        // $query = "SELECT * ";
        $query = "SELECT f.id, f.name, LTRIM(f.categories) AS categories , f.published, f.image_link ";
        $query .= "FROM #__rem_feature as f ";
        $query .= "LEFT JOIN #__rem_feature_houses as fv ON f.id = fv.fk_featureid ";
        $query .= "WHERE f.published = 1 and fv.fk_houseid = $id ";

        // Sorting features
        // $query .= "ORDER BY f.categories";
        if( $realestatemanager_configuration['manager_feature_category'] == 1 ) {
            $query .= "ORDER BY categories, f.name";
        } else {
            $query .= "ORDER BY f.name";
        }

        $database->setQuery($query);
        $house_feature = $database->loadObjectList();

/**********************************************/
        $currencyArr = array();
        $currentCurrency='';
        $currencys = explode(';', $realestatemanager_configuration['currency']);
        foreach ($currencys as $oneCurency) {
            $oneCurrArr = explode('=', $oneCurency);
            if(!empty($oneCurrArr[0]) && !empty($oneCurrArr[1])){
               $currencyArr[$oneCurrArr[0]] = $oneCurrArr[1];
               if($house->priceunit == $oneCurrArr[0]){
                   $currentCurrency = $oneCurrArr[1];
               }
            }
        }

        // The variable $housePrice was added for view_house layout. If in admin in Houses field "Price:" leave empty, on front-end in view_house layout prices will not be; if "Price: 0", 0 will be displayed.
        $housePrice = $house->price;
        if(empty($housePrice)) $housePrice = 0;

        if($currentCurrency){
            foreach ($currencyArr as $key=>$value) {
                if(!incorrect_price($housePrice)){
                    $currencys_price[$key] = round($value / $currentCurrency * $housePrice, 2);
                }
            }
        }else{
            if($house->owner_id == $my->id){
                JFactory::getApplication()->enqueueMessage(_REALESTATE_MANAGER_CURRENCY_ERROR);
            }
        }

/**********************************************/

        $params->def('view01', "{loadposition com_realestatemanager_view_house_01,xhtml}");
        $params->def('view02', "{loadposition com_realestatemanager_view_house_02,xhtml}");
        $params->def('view03', "{loadposition com_realestatemanager_view_house_03,xhtml}");
        $params->def('viewdescription', "{loadposition com_realestatemanager_view_house_description,xhtml}");
        $params->def('view04', "{loadposition com_realestatemanager_view_house_04,xhtml}");
        $params->def('view05', "{loadposition com_realestatemanager_view_house_05,xhtml}");
        $params->def('view06', "{loadposition com_realestatemanager_view_house_06,xhtml}");
        $params->def('view07', "{loadposition com_realestatemanager_view_house_07,xhtml}");
        $params->def('view08', "{loadposition com_realestatemanager_view_house_08,xhtml}");
        $params->def('view09', "{loadposition com_realestatemanager_view_house_09,xhtml}");
        $params->def('similaires', "{loadposition com_realestatemanager_similaires,xhtml}");
        //////////////start select video/tracks
        $query = "SELECT src,type,youtube FROM #__rem_video_source AS r
                LEFT JOIN  #__rem_houses AS h ON r.fk_house_id=h.id
                WHERE r.fk_house_id =" . $house->id;
        $database->setQuery($query);
        $videos = $database->loadObjectList();
        $query = "SELECT src,kind,scrlang,label FROM #__rem_track_source AS t
                LEFT JOIN  #__rem_houses AS h ON t.fk_house_id = h.id
                WHERE t.fk_house_id = " . $house->id;
        $database->setQuery($query);
        $tracks = $database->loadObjectList();
        /////////////////////end

        //*******************add year list
        // print_r($_POST['year']);exit;
        if (isset($_POST['month']) && isset($_POST['year'])) {
          $month = $_POST['month'];
          $year = $_POST['year'];
          $calendar = PHP_realestatemanager::getCalendar($month, $year, $house->id);
        }
        else {
          $month = date("m", mktime(0, 0, 0, date('m'), 1, date('Y')));
          $year = date("Y", mktime(0, 0, 0, date('m'), 1, date('Y')));
          $calendar = PHP_realestatemanager::getCalendar($month, $year, $house->id);
        }
        // print_r($year);exit;
        $params->def('calendar', $calendar);

        if(!isset($realestatemanager_configuration['initial_year']) 
            || empty($realestatemanager_configuration['initial_year']) 
            || intval($realestatemanager_configuration['initial_year']) <= 0){
          $initial_year_val = $year;
        } else {
          $initial_year_val = intval($realestatemanager_configuration['initial_year'] );
        }

        if(!isset($realestatemanager_configuration['final_year']) 
            || empty($realestatemanager_configuration['final_year']) 
            || intval($realestatemanager_configuration['final_year'] ) <= $initial_year_val){
                $final_year_val = $initial_year_val + 1;
        }
        else{
          $final_year_val = intval($realestatemanager_configuration['final_year'] ) ;
        }

        $years = array();
        $count = 1;
        $vyear = '';
        for($i = $initial_year_val; $i <= $final_year_val; $i++){
            if($i == $year && $vyear == ''){
                // $vyear = $count;
                $vyear = $i;
            }
            // $years[] = mosHtml::makeOption($count, $i);
            $years[] = mosHtml::makeOption($i, $i);
            $count++;
        }

        $years_list = mosHTML::selectList($years, 'year', 'class="inputbox" onChange="form.submit()"',  'value', 'text', $vyear);

        $params->def('years_list', $years_list);

        // print_r($params->get('years_list'));exit;

        //*******************end add year list
        $months = array();
        $count = 1;
        $vmonth = '';
        for($i = 1; $i <= 12; $i++){
         if($i == $month){
          $vmonth = $count;
         }
         $month_name = PHP_realestatemanager::getMonth($i);
         $months[] = mosHtml::makeOption($count, $month_name);
         $count++;
        }

        $months_list = mosHTML::selectList($months, 'month', 'class="inputbox"  onChange="form.submit()"', 'value', 'text', $vmonth);

        $params->def('months_list', $months_list);

        switch ($printItem) {

            default: HTML_realestatemanager::displayHouse($house, $tabclass, $params, $currentcat, $ratinglist, $house_photos,$videos,$tracks, $id, $catid, $option, $house_feature, $currencys_price, $layout);
                break;
        }
    }

    static function getMonth($month) {

        switch ($month) {
            case 1:
                $smonth = JText::_('JANUARY');
                break;
            case 2:
                $smonth = JText::_('FEBRUARY');
                break;
            case 3:
                $smonth = JText::_('MARCH');
                break;
            case 4:
                $smonth = JText::_('APRIL');
                break;
            case 5:
                $smonth = JText::_('MAY');
                break;
            case 6:
                $smonth = JText::_('JUNE');
                break;
            case 7:
                $smonth = JText::_('JULY');
                break;
            case 8:
                $smonth = JText::_('AUGUST');
                break;
            case 9:
                $smonth = JText::_('SEPTEMBER');
                break;
            case 10:
                $smonth = JText::_('OCTOBER');
                break;
            case 11:
                $smonth = JText::_('NOVEMBER');
                break;
            case 12:
                $smonth = JText::_('DECEMBER');
                break;
        }

        return $smonth;
    }

    static function showSearchHouses($option, $catid, $params, $layout = "default") {
        global $mainframe, $database, $my, $langContent, $acl;
        global $mosConfig_shownoauth, $mosConfig_live_site, $mosConfig_absolute_path, $realestatemanager_configuration;
        global $cur_template, $Itemid, $os_rem_state;
        PHP_realestatemanager::addTitleAndMetaTags();


        $jinput = JFactory::getApplication()->input;

        //parameters
            $menu = new JTableMenu($database);
            $menu->load($Itemid);
            $params = new JRegistry;
            $params->loadString($menu->params);


        $params->def('show_category', '1');
        $pathway = sefRelToAbs('index.php?option=' . $option . '&amp;task=show_search&amp;Itemid=' . $Itemid);
        $pathway_name = _REALESTATE_MANAGER_LABEL_SEARCH;

        $currentcat = new stdClass();
        $currentcat->descrip = "";
        $currentcat->align = 'right';

        // page image
        $currentcat->img = "./components/com_realestatemanager/images/rem_logo.png";
        $currentcat->header = '';

        //used to show table rows in alternating colours
        $tabclass = array('sectiontableentry1', 'sectiontableentry2');

        //listing type
        if($realestatemanager_configuration['search_form_listing_type_field_show']==1) {
            $hlisting = $jinput->get('listing_type') ? $jinput->get('listing_type') : _REALESTATE_MANAGER_LABEL_ALL;
            $listing_type[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
            $listing_type[] = mosHtml::makeOption(3, _REALESTATE_MANAGER_OPTION_FOR_PROPERTY_REQUEST);
            $listing_type[] = mosHtml::makeOption(1, _REALESTATE_MANAGER_OPTION_FOR_RENT);
            $listing_type[] = mosHtml::makeOption(2, _REALESTATE_MANAGER_OPTION_FOR_SALE);

            $listing_type_list = mosHTML::selectList($listing_type, 'listing_type',
             'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $hlisting);

            $params->def('listing_type_list', $listing_type_list);
        }

        //listing status
        if($realestatemanager_configuration['search_form_listing_status_field_show']==1) {
            $hlistingstatus = $jinput->get('listing_status') ? $jinput->get('listing_status') : _REALESTATE_MANAGER_LABEL_ALL;
            $listing_status[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
            $listing_status1 = explode(',', _REALESTATE_MANAGER_OPTION_LISTING_STATUS);
            $i = 1;
            foreach ($listing_status1 as $listing_status2) {
                $listing_status[] = mosHtml::makeOption($i, $listing_status2);
                $i++;
            }
            $listing_status_list = mosHTML::selectList($listing_status, 'listing_status',
              'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $hlistingstatus);

            $params->def('listing_status_list', $listing_status_list);
        }

        //property type
        if($realestatemanager_configuration['search_form_property_type_field_show']==1) {
            $hproperty = $jinput->get('property_type') ? $jinput->get('property_type') : _REALESTATE_MANAGER_LABEL_ALL;
            $property_type[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
            $property_type1 = explode(',', _REALESTATE_MANAGER_OPTION_PROPERTY_TYPE);
            $i = 1;
            foreach ($property_type1 as $property_type2) {
                $property_type[] = mosHtml::makeOption($i, $property_type2);
                $i++;
            }
            $property_type_list = mosHTML::selectList($property_type, 'property_type', 'class="inputbox"
               size="1" style="width: 115px"', 'value', 'text', $hproperty);

            $params->def('property_type_list', $property_type_list);
        }

        //categories
        if (isset($langContent)) {
            $lang = $langContent;
            // $query = "SELECT lang_code FROM #__languages WHERE sef = '$lang'";
            // $database->setQuery($query);
            // $lang = $database->loadResult();
            $lang = " c.language = '$lang' or c.language like 'all' or c.language like '' "
             . " or c.language like '*' or c.language is null ";
        } else {
            $lang = "";
        }

        $categories[] = mosHTML::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
        if($realestatemanager_configuration['search_form_category_field_show'] == 1){
            $clist = com_house_categoryTreeList(0, '', true, $categories, $catid, $lang);
        }else{
            $clist = '<input type="hidden" id="catid" name="catid" value="' . _REALESTATE_MANAGER_LABEL_ALL . '">';
        }
//********************** eextra6,extra7,extra8,extra9,extra10 *********************************
        for($i=6;$i<=10;$i++){
          if($realestatemanager_configuration['extra'. $i]==1){
          $extraOption=array();
          $index = 'extra'.$i;
          $vextra = $jinput->get($index) ? $jinput->get($index) : '';
          $extraOption[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
          $name = "_REALESTATE_MANAGER_EXTRA".$i."_SELECTLIST";
          $extra = explode(',', constant($name));
          $j = 1;
          foreach($extra as $extr){
            $extraOption[] = mosHTML::makeOption($j, $extr);
            $j++;
          }
          $extra_list[$i] = mosHTML::selectList($extraOption, 'extra'.$i,
           'class="inputbox" size="1" style="width: 140px"', 'value', 'text', $vextra);
            $params->def('extrafield'.$i, $extra_list[$i]);
          }else{
            $extra_list[$i] = '<input type="hidden" name="extrafield' . $i . '" class="inputbox" size="1" value="" />';
            $params->def('extrafield'.$i, $extra_list[$i]);
          }
        }
//***************** end extra6,extra7,extra8,extra9,extra10 ******************************
//*********************************** numbers rooms list *********************************
        $numbers = explode(',', _REALESTATE_MANAGER_NUMBERS_BBROOMS);
        if($realestatemanager_configuration['search_rooms_num_field_show']==1){
            $room = $jinput->get('rooms_num') ? $jinput->get('rooms_num') : _REALESTATE_MANAGER_LABEL_ALL;
            $rooms[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
            $count = 1;
            foreach($numbers as $num){
                $rooms[] = mosHtml::makeOption($count, $num);
                $count++;
            }
            $rooms_list = mosHTML::selectList($rooms, 'rooms_num', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $room);
            $params->def('rooms_num', $rooms_list);
        }
//********************************* end numbers rooms list *********************************
//********************************* numbers bathrooms list *********************************
        if($realestatemanager_configuration['search_bathrooms_num_field_show'] == 1){
            $bathroom = $jinput->get('bathrooms_num') ? $jinput->get('bathrooms_num') : _REALESTATE_MANAGER_LABEL_ALL;
            $bathrooms[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
            $count = 1;
            foreach($numbers as $num){
                $bathrooms[] = mosHtml::makeOption($count, $num);
                $count++;
            }
            $bathrooms_list = mosHTML::selectList($bathrooms, 'bathrooms_num', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $bathroom);
            $params->def('bathrooms_num', $bathrooms_list);
        }
//******************** end numbers bathrooms list *********************************
//************************* numbers bedrooms list *********************************
        if($realestatemanager_configuration['search_bedrooms_num_field_show'] == 1){
            $bedroom = $jinput->get('bedrooms_num') ? $jinput->get('bedrooms_num') : _REALESTATE_MANAGER_LABEL_ALL;
            $bedrooms[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
            $count = 1;
            foreach($numbers as $num){
                $bedrooms[] = mosHtml::makeOption($count, $num);
                $count++;
            }
            $bedrooms_list = mosHTML::selectList($bedrooms, 'bedrooms_num', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $bedroom);
            $params->def('bedrooms_num', $bedrooms_list);
        }
//******************************** end numbers bedrooms list *********************************

//************************************* numbers garages list *********************************
        if($realestatemanager_configuration['search_form_garages_field_show'] == 1){
            $garage = $jinput->get('garages_num') ? $jinput->get('garages_num') : _REALESTATE_MANAGER_LABEL_ALL;
            $garages[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
            $count = 1;
            foreach($numbers as $num){
                $garages[] = mosHtml::makeOption($count, $num);
                $count++;
            }
            $garages_list = mosHTML::selectList($garages, 'garages_num', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $garage);
            $params->def('garages_num', $garages_list);
        }
//********************************** end numbers garages list *********************************
//********************************** numbers build years list *********************************
        if($realestatemanager_configuration['search_form_build_year_field_show'] == 1){
            $build_year = $jinput->get('year') ? $jinput->get('year') : _REALESTATE_MANAGER_LABEL_ALL;
            $build_years[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
            // $count = 1;
            for ($year = intval(date('Y')) + 1; 1900 < $year; $year--) {
                // $build_years[] = mosHtml::makeOption($count, $year);
                if ($year == intval(date('Y')) + 1) {
                    $year_plus = $year;
                } else {
                    $year_plus = $year . '+';
                }
                // $build_years[] = mosHtml::makeOption($count, $year_plus);
                $build_years[] = mosHtml::makeOption($year, $year_plus);
                // $count++;
            }
            $build_years_list = mosHTML::selectList($build_years, 'year', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $build_year);
            $params->def('year', $build_years_list);
        }
//*************************** end numbers build years list *********************************

        if($realestatemanager_configuration['show_country_region_city_as_text_field'] == 0){
//******************************************** country list *********************************
            $countrys_and_regions = mosRealEstateManagerOthers::getElementsArray('countrys_and_regions.txt');
            $regions_and_citys = mosRealEstateManagerOthers::getElementsArray('regions_and_citys.txt');

            $temp[2] = $countrys_and_regions[0];
            $temp[3] = $countrys_and_regions[1];
            $temp[4] = $regions_and_citys[0];
            $temp[5] = $regions_and_citys[1];

            //hcountry Need for region search if search "for country" set  to NONE
            $hcountry = $jinput->getRaw('hcountry') ? $jinput->getRaw('hcountry') : _REALESTATE_MANAGER_LABEL_ALL;
            if(trim($hcountry) == ''
            || trim($hcountry) == 'all'
            || trim($hcountry) == _REALESTATE_MANAGER_LABEL_ALL){
                $countryList = $countrys_and_regions[0];

                foreach ($countryList as $country) {
                    if (trim($country) != ''){
                        $hcountry = trim($country);
                        break ;
                    }
                }
            }

            if($realestatemanager_configuration['search_form_country_field_show']==1){

                $hcountry = $jinput->getRaw('hcountry') ? $jinput->getRaw('hcountry') : _REALESTATE_MANAGER_LABEL_ALL;

                if(trim($hcountry) == '' || trim($hcountry) == 'all' || trim($hcountry) == _REALESTATE_MANAGER_LABEL_ALL ){
                    $hcountry  = _REALESTATE_MANAGER_LABEL_ALL;
                }

                $countrys[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);

                $countryList = $countrys_and_regions[0];

                foreach ($countryList as $country) {
                    if (trim($country) != ''){
                  $countrys[] = mosHtml::makeOption(trim($country), trim($country));
                }
            }

                if (!in_array($hcountry, $countrys_and_regions[0])){
                    if($hcountry != _REALESTATE_MANAGER_LABEL_ALL){
                        $countrys[] = mosHtml::makeOption($hcountry, $hcountry);
                    }
                }
                $country = mosHTML::selectList($countrys, 'hcountry', 'class="inputbox" size="1" onchange=rem_changedCountry_com(this)', 'value', 'text', $hcountry);

            } elseif($realestatemanager_configuration['search_form_country_field_show']==2){

                $country = '<input type="hidden" name="hcountry" class="inputbox" size="1" style="width: 140px" value="' ._REALESTATE_MANAGER_LABEL_ALL .'" />';
            } else{
                $country = "";
            }

            $params->def('country', $country);
            //************************* end country list *********************************

            //************************* region list **************************************
            //hregion Need for city search if search "for region" set  to NONE
            $hregion = $jinput->getRaw('hregion') ? $jinput->getRaw('hregion') : _REALESTATE_MANAGER_LABEL_ALL;
            if(trim($hregion) == ''
            || trim($hregion) == 'all'
            || trim($hregion) == _REALESTATE_MANAGER_LABEL_ALL){
                $regionList = $regions_and_citys[0];

                foreach ($regionList as $region) {
                    if (trim($region) != ''){
                        $hregion = trim($region);
                        break ;
                    }
                }
            }


        if($realestatemanager_configuration['search_form_region_field_show']==1){

            $hregion = $jinput->getRaw('hregion') ? $jinput->getRaw('hregion') : _REALESTATE_MANAGER_LABEL_ALL;

            if(trim($hregion) == ''
            || trim($hregion) == 'all' || trim($hregion) == _REALESTATE_MANAGER_LABEL_ALL ){
              $hregion  = _REALESTATE_MANAGER_LABEL_ALL;
            }

                $regions[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);

                if(in_array($hcountry, $countrys_and_regions[0])){
                    $countrys_and_regions_tmp = array_flip($countrys_and_regions[0]) ;
                    $countryIndex = $countrys_and_regions_tmp[$hcountry];
                    $regionList = $countrys_and_regions[1][$countryIndex];

                    foreach ($regionList as $region) {
                        if (trim($region) != ''){
                          $regions[] = mosHtml::makeOption(trim($region), trim($region));
                        }
                    }
                }else{
                    if($hregion  != _REALESTATE_MANAGER_LABEL_ALL){
                        $regions[] = mosHtml::makeOption(trim($hregion), trim($hregion));
                    }
                }

            $region = mosHTML::selectList($regions, 'hregion', 'class="inputbox" size="1" onchange=rem_changedRegion_com(this)', 'value', 'text', $hregion);

        } elseif($realestatemanager_configuration['search_form_region_field_show']==2){

            $region = '<input type="hidden" name="hregion" class="inputbox" size="1" style="width: 140px" value="' ._REALESTATE_MANAGER_LABEL_ALL .'" />';
        } else{
            $region = "";
        }

            $params->def('region', $region);
            //*************** end region list **************************************

            //*************** city list ********************************************
            $hcity = $jinput->get('hcity') ? $jinput->get('hcity') : _REALESTATE_MANAGER_LABEL_ALL;

            if(in_array($hregion, $regions_and_citys[0])) {
                $regions_and_citys_tmp = array_flip($regions_and_citys[0]) ;
                $regionIndex = $regions_and_citys_tmp[$hregion];
                $cityList = $regions_and_citys[1][$regionIndex];

                foreach ($cityList as $city) {
                    if (trim($city) != ''){
                      $citys[] = mosHtml::makeOption(trim($city), trim($city));
                    }
                }
            }
            else {
                if($hcity  != _REALESTATE_MANAGER_LABEL_ALL) {
                    $citys[] = mosHtml::makeOption($hcity, $hcity);
                }
            }

            $citys[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
            $city = mosHTML::selectList($citys, 'hcity', 'class="inputbox" size="1" style="width: 140px"',
                 'value', 'text', $hcity);
            $params->def('city', $city);
//************************ end city list *****************************************
        }
        //price
        $db = JFactory::getDBO();
        $query = "SELECT price  FROM   #__rem_houses  as r ".
            " WHERE r.published = '1' and r.approved = '1'";
        $database->setQuery($query);
        if (version_compare(JVERSION, "3.0.0", "lt"))
            $prices = $database->loadResultArray();
        else
            $prices = $database->loadColumn();

        rsort($prices, SORT_NUMERIC);
        if(isset($prices[0])){
            $max_price = floatval($prices[0]);
        }else{
            $max_price = 0;
        }
        $price[] = mosHTML::makeOption(_REALESTATE_MANAGER_LABEL_FROM, _REALESTATE_MANAGER_LABEL_FROM);
        $price_to[] = mosHTML::makeOption(_REALESTATE_MANAGER_LABEL_TO, _REALESTATE_MANAGER_LABEL_TO);

        $stepPrice = $max_price / 50;
        //number_format - for exponents remove 4.4e5-> 4 400 00
        $stepPrice = (string) number_format($stepPrice);        
        $replaceArr = array(',',' ','.');
        $stepPrice = str_replace($replaceArr,"", $stepPrice);
        $stepCount = strlen($stepPrice);
        //round step from 457345.563 to 400000
        if ($stepCount > 2) {
            $stepFinalPrice = $stepPrice[0] . $stepPrice[1];
            for ($i = 2; $i < $stepCount; $i++) {
                $stepFinalPrice .= '0';
            }
            $stepFinalPrice = (int) $stepFinalPrice;
        }
        else
            $stepFinalPrice = (int) $stepPrice;

        if ($stepFinalPrice == 0 )  $stepFinalPrice = 1 ;

        if($max_price == 0 || $stepFinalPrice == 0){
            $price[] = mosHTML::makeOption(0, 0);
            $price_to[] = mosHTML::makeOption(0, 0);
        }
        for ($i = 0; $i < $max_price; $i = $i + $stepFinalPrice) {
            $price[] = mosHTML::makeOption($i, $i);
            $price_to[] = mosHTML::makeOption($i, $i);
        }
        $pricelist = mosHTML::selectList($price, 'pricefrom2', 'class="inputbox" size="1"', 'value', 'text');
        $params->def('pricefrom2', $pricelist);
        $pricelistto = mosHTML::selectList($price_to, 'priceto2', 'class="inputbox" size="1"', 'value', 'text');
        $params->def('priceto2', $pricelistto);

//**************   lot size **************
        $db = JFactory::getDBO();
        $query = "SELECT lot_size  FROM   #__rem_houses  as r ".
            " WHERE r.published = '1' and r.approved = '1'";
        $database->setQuery($query);
        if (version_compare(JVERSION, "3.0.0", "lt"))
            $lotsizes = $database->loadResultArray();
        else
            $lotsizes = $database->loadColumn();

        rsort($lotsizes, SORT_NUMERIC);
        $max_lot_size = $lotsizes[0];
        $lotSize[] = mosHTML::makeOption(_REALESTATE_MANAGER_LABEL_FROM, _REALESTATE_MANAGER_LABEL_FROM);
        $lotSize_to[] = mosHTML::makeOption(_REALESTATE_MANAGER_LABEL_TO, _REALESTATE_MANAGER_LABEL_TO);

        $stepLotSize = (int) $max_lot_size / 50;
        //number_format - for exponents remove 4.4e5-> 4 400 00
        $stepLotSize = (string) number_format($stepLotSize); 
        $replaceArr = array(',',' ','.');
        $stepLotSize = str_replace($replaceArr,"", $stepLotSize);
        $stepLotCount = strlen($stepLotSize);
        //round step from 457345.563 to 400000
        if ($stepLotCount > 2) {
            $stepFinalLot = $stepLotSize[0] . $stepLotSize[1];
            for ($i = 2; $i < $stepLotCount; $i++) {
                $stepFinalLot .= '0';
            }
            $stepFinalLot = (int) $stepFinalLot;
        }
        else
            $stepFinalLot = (int) $stepLotSize;

        if($max_lot_size == 0 || $stepFinalLot == 0){
            $lotSize[] = mosHTML::makeOption(0, 0);
            $lotSize_to[] = mosHTML::makeOption(0, 0);
        }

        if($stepFinalLot == 0) {
            $stepFinalLot = 1 ;
        }

        for ($i = 0; $i < $max_lot_size; $i = $i + $stepFinalLot) {
            $lotSize[] = mosHTML::makeOption($i, $i);
            $lotSize_to[] = mosHTML::makeOption($i, $i);
        }

        $lotSizelist = mosHTML::selectList($lotSize, 'lotsizefrom2', 'class="inputbox" size="1"', 'value', 'text');
        $params->def('lotsizefrom2', $lotSizelist);
        $lotSizelistto = mosHTML::selectList($lotSize_to, 'lotsizeto2', 'class="inputbox" size="1"', 'value', 'text');
        $params->def('lotsizeto2', $lotSizelistto);

//**************   end lot size **************
//**************   house size **************
        $db = JFactory::getDBO();
        $query = "SELECT house_size  FROM   #__rem_houses as r ".
            " WHERE r.published = '1' and r.approved = '1'";
        $database->setQuery($query);
        if (version_compare(JVERSION, "3.0.0", "lt"))
            $housesizes = $database->loadResultArray();
        else
            $housesizes = $database->loadColumn();

        rsort($housesizes, SORT_NUMERIC);
        $max_house_size = floatval($housesizes[0]);
        $houseSize[] = mosHTML::makeOption(_REALESTATE_MANAGER_LABEL_FROM, _REALESTATE_MANAGER_LABEL_FROM);
        $houseSize_to[] = mosHTML::makeOption(_REALESTATE_MANAGER_LABEL_TO, _REALESTATE_MANAGER_LABEL_TO);

        $stepHouseSize = $max_house_size / 50;
        //number_format - for exponents remove 4.4e5-> 4 400 00
        $stepHouseSize = (string) number_format($stepHouseSize); 
        $replaceArr = array(',',' ','.');
        $stepHouseSize = str_replace($replaceArr,"", $stepHouseSize);        
        $stepHouseCount = strlen($stepHouseSize);
        //round step from 457345.563 to 400000
        if ($stepHouseCount > 2) {
            $stepFinalHouse = $stepHouseSize[0] . $stepHouseSize[1];
            for ($i = 2; $i < $stepHouseCount; $i++) {
                $stepFinalHouse .= '0';
            }
            $stepFinalHouse = (int) $stepFinalHouse;
        }
        else
            $stepFinalHouse = (int) $stepHouseSize;

        if($max_house_size == 0 || $stepFinalHouse == 0){
            $houseSize[] = mosHTML::makeOption(0, 0);
            $houseSize_to[] = mosHTML::makeOption(0, 0);
        }

        if($stepFinalHouse == 0) {
            $stepFinalHouse = 1 ;
        }

        for ($i = 0; $i < $max_house_size; $i = $i + $stepFinalHouse) {
            $houseSize[] = mosHTML::makeOption($i, $i);
            $houseSize_to[] = mosHTML::makeOption($i, $i);
        }

        $houseSizelist = mosHTML::selectList($houseSize, 'housesizefrom2', 'class="inputbox" size="1"', 'value', 'text');
        $params->def('housesizefrom2', $houseSizelist);
        $houseSizelistto = mosHTML::selectList($houseSize_to, 'housesizeto2', 'class="inputbox" size="1"', 'value', 'text');
        $params->def('housesizeto2', $houseSizelistto);

//**************   end lot size **************
        $params->def('showsearch01', "{loadposition com_realestatemanager_show_search_01,xhtml}");
        $params->def('showsearch02', "{loadposition com_realestatemanager_show_search_02,xhtml}");
        $params->def('showsearch03', "{loadposition com_realestatemanager_show_search_03,xhtml}");
        $params->def('showsearch04', "{loadposition com_realestatemanager_show_search_04,xhtml}");
        $params->def('showsearch05', "{loadposition com_realestatemanager_show_search_05,xhtml}");

        HTML_realestatemanager::showSearchHouses($params, $currentcat, $clist, $option, $countrys_and_regions, $regions_and_citys, $layout);
    }

    static function searchHouses($option, $catid, $params, $languagelocale, $ownername = '') {

        global $mainframe, $database, $my, $acl, $limitstart, $limit, $langContent;
        global $catid, $lang;
        global $mosConfig_shownoauth, $mosConfig_live_site, $mosConfig_absolute_path;
        global $cur_template, $Itemid, $realestatemanager_configuration,$task, $layout;

        PHP_realestatemanager::addTitleAndMetaTags();

        $ownernameTMP = $ownername;

        $jinput = JFactory::getApplication()->input;

        //get current user groups
        $s = getWhereUsergroupsCondition("c");
        $s_cat = getWhereDatePublishStringRem('c');
        $s_h = getWhereDatePublishStringRem('b');
        $session = JFactory::getSession();
        if ($ownername == '') {
            $pathway = sefRelToAbs('index.php?option=' . $option . '&amp;task=show_search&amp;Itemid=' . $Itemid);
            $pathway_name = _REALESTATE_MANAGER_LABEL_SEARCH;
        }

        if (array_key_exists("searchtext", $_REQUEST)) {

            $search = protectInjectionWithoutQuote('searchtext', '');
            $search = addslashes($search);
            $session->set("poisk", $search);
        }

        $poisk_search = $session->get("poisk", "");

        $where = array();
        $Houseid = " ";
        $Description = " ";
        $Title = " ";
        $Address = " ";
        $Country = " ";
        $Region = " ";
        $City = " ";
        $Zipcode = " ";
        $Extra1 = " ";
        $Extra2 = " ";
        $Extra3 = " ";
        $Extra4 = " ";
        $Extra5 = " ";
        $Extra6 = " ";
        $Extra7 = " ";
        $Extra8 = " ";
        $Extra9 = " ";
        $Extra10 = " ";
        $Rooms = " ";
        $Bathrooms = " ";
        $Bedrooms = " ";
        $Contacts = " ";
        $Agent = " ";
        $House_size = " ";
        $Lot_size = " ";
        $Built_year = " ";
        $Rent = " ";
        $RentSQL = " ";
        $RentSQL_JOIN_1 = " ";
        $RentSQL_JOIN_2 = " ";
        $RentSQL_rent_until = " ";

        if (isset($_REQUEST['exactly']) && $_REQUEST['exactly'] == "on") {
            $exactly = $poisk_search;
        } else {
            $exactly = "%$poisk_search%";
        }

        //sorting
        $item_session = JFactory::getSession();
        $sort_arr = $item_session->get('rem_housesort', '');
        if (is_array($sort_arr)) {
            $tmp1 = protectInjectionWithoutQuote('order_direction');
            //$tmp1= $database->Quote($tmp1);
            if ($tmp1 != '')
                $sort_arr['order_direction'] = $tmp1;
            $tmp1 = protectInjectionWithoutQuote('order_field');
            if ($tmp1 != '')
                $sort_arr['order_field'] = $tmp1;
            $item_session->set('rem_housesort', $sort_arr);
        } else {
            $sort_arr = array();
            $sort_arr['order_direction'] = 'asc';
            if(isset($realestatemanager_configuration['order_by_default']) && $realestatemanager_configuration['order_by_default'] != ''){
                 $sort_arr['order_field'] = $realestatemanager_configuration['order_by_default'];
                 if($sort_arr['order_field'] == 'date') $sort_arr['order_direction'] = 'desc';
            }
            else{
                $sort_arr['order_field'] = 'date';
            }

            $item_session->set('rem_housesort', $sort_arr);
        }
        if ($sort_arr['order_field'] == "price")
            $sort_string = "CAST( " . $sort_arr['order_field'] . " AS SIGNED)" . " " . $sort_arr['order_direction'];
        else
            $sort_string = $sort_arr['order_field'] . " " . $sort_arr['order_direction'];  //end sortering

        $is_add_or = false;
        $add_or_value = "  ";

        if ($poisk_search != '') {
            if (isset($_REQUEST['Houseid']) && $_REQUEST['Houseid'] == "on") {
                $Houseid = " ";
                if ($is_add_or)
                    $Houseid = " or ";
                $is_add_or = true;
                $Houseid .= "LOWER(b.houseid) LIKE '$exactly' ";
            }
            if (isset($_REQUEST['Description']) && $_REQUEST['Description'] == "on") {
                $Description = " ";
                if ($is_add_or)
                    $Description = " or ";
                $is_add_or = true;
                $Description .=" LOWER(b.description) LIKE '$exactly' ";
            }
            if (isset($_REQUEST['Title']) && $_REQUEST['Title'] == "on") {
                $Title = " ";
                if ($is_add_or)
                    $Title = " or ";
                $is_add_or = true;
                $Title .=" LOWER(b.htitle) LIKE '$exactly' ";
            }

                if (isset($_REQUEST['Address']) && $_REQUEST['Address'] == "on") {
                $Address = " ";
                if ($is_add_or)
                    $Address = " or ";
                $is_add_or = true;
                $Address .=" LOWER(b.hlocation) LIKE '$exactly' ";
            }

            if (isset($_REQUEST['Country']) && $_REQUEST['Country'] == "on") {
                $Country = " ";
                if ($is_add_or)
                    $Country = " or ";
                $is_add_or = true;
                $Country .= "LOWER(b.hcountry) LIKE '$exactly' ";
            }
            if (isset($_REQUEST['Region']) && $_REQUEST['Region'] == "on") {
                $Region = " ";
                if ($is_add_or)
                    $Region = " or ";
                $is_add_or = true;
                $Region .= "LOWER(b.hregion) LIKE '$exactly' ";
            }
            if (isset($_REQUEST['City']) && $_REQUEST['City'] == "on") {
                $City = " ";
                if ($is_add_or)
                    $City = " or ";
                $is_add_or = true;
                $City .= "LOWER(b.hcity) LIKE '$exactly' ";
            }

                if (isset($_REQUEST['Zipcode']) && $_REQUEST['Zipcode'] == "on") {
                $Zipcode = " ";
                if ($is_add_or)
                    $Zipcode = " or ";
                $is_add_or = true;
                $Zipcode .= "LOWER(b.hzipcode) LIKE '$exactly' ";
            }
            if (isset($_REQUEST['extra1']) && $_REQUEST['extra1'] == "on") {
                $Extra1 = " ";
                if ($is_add_or)
                    $Extra1 = " or ";
                $is_add_or = true;
                $Extra1 .= "LOWER(b.extra1) LIKE '$exactly' ";
            }
            if (isset($_REQUEST['extra2']) && $_REQUEST['extra2'] == "on") {
                $Extra2 = " ";
                if ($is_add_or)
                    $Extra2 = " or ";
                $is_add_or = true;
                $Extra2 .= "LOWER(b.extra2) LIKE '$exactly' ";
            }
            if (isset($_REQUEST['extra3']) && $_REQUEST['extra3'] == "on") {
                $Extra3 = " ";
                if ($is_add_or)
                    $Extra3 = " or ";
                $is_add_or = true;
                $Extra3 .= "LOWER(b.extra3) LIKE '$exactly' ";
            }
            if (isset($_REQUEST['extra4']) && $_REQUEST['extra4'] == "on") {
                $Extra4 = " ";
                if ($is_add_or)
                    $Extra4 = " or ";
                $is_add_or = true;
                $Extra4 .= "LOWER(b.extra4) LIKE '$exactly' ";
            }
            if (isset($_REQUEST['extra5']) && $_REQUEST['extra5'] == "on") {
                $Extra5 = " ";
                if ($is_add_or)
                    $Extra5 = " or ";
                $is_add_or = true;
                $Extra5 .= "LOWER(b.extra5) LIKE '$exactly' ";
            }

            if (isset($_REQUEST['rooms']) && $_REQUEST['rooms'] == "on") {
                $Rooms = " ";
                if ($is_add_or)
                    $Rooms = " or ";
                $is_add_or = true;
                $Rooms .= "LOWER(b.Rooms) LIKE '$exactly' ";
            }

            if (isset($_REQUEST['Bathrooms']) && $_REQUEST['Bathrooms'] == "on") {
                $Bathrooms = " ";
                if ($is_add_or)
                    $Bathrooms = " or ";
                $is_add_or = true;
                $Bathrooms .= "LOWER(b.bathrooms) LIKE '$exactly' ";
            }
            if (isset($_REQUEST['Bedrooms']) && $_REQUEST['Bedrooms'] == "on") {
                $Bedrooms = " ";
                if ($is_add_or)
                    $Bedrooms = " or ";
                $is_add_or = true;
                $Bedrooms .= "LOWER(b.bedrooms) LIKE '$exactly' ";
            }

            if (isset($_REQUEST['Contacts']) && $_REQUEST['Contacts'] == "on") {
                $Contacts = " ";
                if ($is_add_or)
                    $Contacts = " or ";
                $is_add_or = true;
                $Contacts .=" LOWER(b.contacts) LIKE '$exactly' ";
            }
            if (isset($_REQUEST['Agent']) && $_REQUEST['Agent'] == "on") {
                $Agent = " ";
                if ($is_add_or)
                    $Agent = " or ";
                $is_add_or = true;
                $Agent .=" LOWER(b.agent) LIKE '$exactly' ";
            }
            if (isset($_REQUEST['house_size']) && $_REQUEST['house_size'] == "on") {
                $House_size = " ";
                if ($is_add_or)
                    $House_size = " or ";
                $is_add_or = true;
                $House_size .=" LOWER(b.house_size) LIKE '$exactly' ";
            }
            if (isset($_REQUEST['Lot_size']) && $_REQUEST['Lot_size'] == "on") {
                $Lot_size = " ";
                if ($is_add_or)
                    $Lot_size = " or ";
                $is_add_or = true;
                $Lot_size .=" LOWER(b.lot_size) LIKE '$exactly' ";
            }
            /*if (isset($_REQUEST['year']) && $_REQUEST['year'] == "on") {
                $Built_year = " ";
                if ($is_add_or)
                    $Built_year = " or ";
                $is_add_or = true;
                $Built_year .=" LOWER(b.year) LIKE '$exactly' ";
            }

            if (isset($_REQUEST['Garages']) && $_REQUEST['Garages'] == "on") {
                $Garages = " ";
                if ($is_add_or)
                    $Garages = " or ";
                $is_add_or = true;
                $Garages .=" LOWER(b.garages) LIKE '$exactly' ";
            }*/
         }

        //  by Andrew
        // first-cut bounding box (in degrees)

        if(protectInjectionWithoutQuote('h_range', '', 'INT') && protectInjectionWithoutQuote('h_lat', '', 'FLOAT')
                    && protectInjectionWithoutQuote('h_lon', '', 'FLOAT')){
                    $rad = protectInjectionWithoutQuote('h_range', '', 'INT');
              $lat = protectInjectionWithoutQuote('h_lat', '', 'FLOAT');
              $lon = protectInjectionWithoutQuote('h_lon', '', 'FLOAT');

      // $R = 289643;
        // $rad = 1000;
        // $lat = 46.0209384922 # широта
        // $lon = 51.5289156201 # долгота центра
      //old algorith
      // $maxLat = $lat + rad2deg($rad/$R);
      // $minLat = $lat - rad2deg($rad/$R);
      // //compensate for degrees longitude getting smaller with increasing latitude
      // $maxLon = $lon + rad2deg($rad/$R/cos(deg2rad($lat)));
      // $minLon = $lon - rad2deg($rad/$R/cos(deg2rad($lat)));

            $minLon = $lon-$rad/(cos(deg2rad($lat))*111.0) ;// 1 degree of latitude is approximately 111 km (69 miles)
            $maxLon = $lon+$rad/(cos(deg2rad($lat))*111.0);
            $minLat = $lat-($rad/111.0);
            $maxLat = $lat+($rad/111.0);
            $location = " or (b.hlatitude Between ".$minLat." And ".$maxLat." AND b.hlongitude Between ".$minLon." And ".$maxLon.") ";
        } else {
            $location = "" ;
        }     

        if (isset($_REQUEST['bathrooms']) ) {
            $where[] = " LOWER(b.bathrooms) >= ".(int)($_REQUEST['bathrooms'] )."";
        }
        if (isset($_REQUEST['bedrooms']) ) {
            $where[] = " LOWER(b.bedrooms) >= ".(int)($_REQUEST['bedrooms'] )."";
        }


        $catid = protectInjectionWithoutQuote('catid', '');
        $listing_type = protectInjectionWithoutQuote('listing_type', '');
        $listing_status = protectInjectionWithoutQuote('listing_status', '');
        $property_type = protectInjectionWithoutQuote('property_type', '');
        // $hcountry  = protectInjectionWithoutQuote('hcountry', '');
        // $hregion = protectInjectionWithoutQuote('hregion', '');
        // $hcity  = protectInjectionWithoutQuote('hcity', '');
        $extra6 = protectInjectionWithoutQuote('extra6', '');
        $extra7 = protectInjectionWithoutQuote('extra7', '');
        $extra8 = protectInjectionWithoutQuote('extra8', '');
        $extra9 = protectInjectionWithoutQuote('extra9', '');
        $extra10 = protectInjectionWithoutQuote('extra10', '');

        if(array_key_exists('hcountry', $_REQUEST)) {
            $hcountry  = protectInjectionWithoutQuote('hcountry', '');
        }
        elseif(array_key_exists('country', $_REQUEST)) {
            $hcountry  = protectInjectionWithoutQuote('country', '');
        }
        else {
            $hcountry = '';
        }

        if(array_key_exists('hregion', $_REQUEST)) {
            $hregion  = protectInjectionWithoutQuote('hregion', '');
        }
        elseif(array_key_exists('region', $_REQUEST)) {
            $hregion  = protectInjectionWithoutQuote('region', '');
        }
        else {
            $hregion = '';
        }

        if(array_key_exists('hcity', $_REQUEST)) {
            $hcity  = protectInjectionWithoutQuote('hcity', '');
        }
        elseif(array_key_exists('city', $_REQUEST)) {
            $hcity  = protectInjectionWithoutQuote('city', '');
        }
        else {
            $hcity = '';
        }

        if ($listing_type != _REALESTATE_MANAGER_LABEL_ALL && $listing_type != '') {
            $where[] = " LOWER(b.listing_type)='$listing_type'";
        }
        if ($listing_status != _REALESTATE_MANAGER_LABEL_ALL && $listing_status != '') {
            $where[] = " LOWER(b.listing_status)='$listing_status'";
        }
        if ($property_type != _REALESTATE_MANAGER_LABEL_ALL && $property_type != '') {
            $where[] = " LOWER(b.property_type)='$property_type'";
        }
        if ($hcountry != _REALESTATE_MANAGER_LABEL_ALL && $hcountry != '') {
            $where[] = " LOWER(b.hcountry)='$hcountry'";
        }
        if ($hregion != _REALESTATE_MANAGER_LABEL_ALL && $hregion != '') {
            $where[] = " LOWER(b.hregion)='$hregion'";
        }
        if ($hcity != _REALESTATE_MANAGER_LABEL_ALL && $hcity != '') {
            $where[] = " LOWER(b.hcity)='$hcity'";
        }
        if ($extra6 != _REALESTATE_MANAGER_LABEL_ALL && $extra6 != '') {
            $where[] = " LOWER(b.extra6)='$extra6'";
        }
        if ($extra7 != _REALESTATE_MANAGER_LABEL_ALL && $extra7 != '') {
            $where[] = " LOWER(b.extra7)='$extra7'";
        }
        if ($extra8 != _REALESTATE_MANAGER_LABEL_ALL && $extra8 != '') {
            $where[] = " LOWER(b.extra8)='$extra8'";
        }
        if ($extra9 != _REALESTATE_MANAGER_LABEL_ALL && $extra9 != '') {
            $where[] = " LOWER(b.extra9)='$extra9'";
        }
        if ($extra10 != _REALESTATE_MANAGER_LABEL_ALL && $extra10 != '') {
            $where[] = " LOWER(b.extra10)='$extra10'";
        }
        $pricefrom = intval(protectInjectionWithoutQuote('pricefrom2', ''));
        $priceto = intval(protectInjectionWithoutQuote('priceto2', ''));
        if ($pricefrom > 0)
            $where[] = " CAST( b.price AS SIGNED) >= $pricefrom ";
        if ($priceto > 0)
            $where[] = " CAST( b.price AS SIGNED) <= $priceto ";

        // Lot size
        $lotsizefrom = intval(protectInjectionWithoutQuote('lotsizefrom2', ''));
        $lotsizeto = intval(protectInjectionWithoutQuote('lotsizeto2', ''));

        if ($lotsizefrom > 0)
            $where[] = " CAST( b.lot_size AS SIGNED) >= $lotsizefrom ";
        if ($lotsizeto > 0)
            $where[] = " CAST( b.lot_size AS SIGNED) <= $lotsizeto ";
        // end lot size
        // house size
        $housesizefrom = intval(protectInjectionWithoutQuote('housesizefrom2', ''));
        $housesizeto = intval(protectInjectionWithoutQuote('housesizeto2', ''));

        if ($housesizefrom > 0)
            $where[] = " CAST( b.house_size AS SIGNED) >= $housesizefrom ";
        if ($housesizeto > 0)
            $where[] = " CAST( b.house_size AS SIGNED) <= $housesizeto ";
        // end house size
        // rooms numbers
        if($realestatemanager_configuration['search_rooms_num_field_show']==1){
            $rooms_num = intval(protectInjectionWithoutQuote('rooms_num', ''));
            if($rooms_num > 0){
                $where[] = " CAST( b.rooms AS SIGNED) >= $rooms_num ";
            }
        }
        // end rooms numbers
        // bathrooms numbers
        $bathrooms_num = intval(protectInjectionWithoutQuote('bathrooms_num', ''));
        if($bathrooms_num > 0){
            $where[] = " CAST( b.bathrooms AS SIGNED) >= $bathrooms_num ";
        }
        // end bathrooms numbers
        // bedrooms numbers
        $bedrooms_num = intval(protectInjectionWithoutQuote('bedrooms_num', ''));
        if($bedrooms_num > 0){
            $where[] = " CAST( b.bedrooms AS SIGNED) >= $bedrooms_num ";
        }
        // end bedrooms numbers
        
        // garages numbers
        $garages_num = intval(protectInjectionWithoutQuote('garages_num', ''));
        if($garages_num > 0){
            $where[] = " CAST( b.garages AS SIGNED) >= $garages_num ";
        }
        // end garages numbers
        // build years numbers
        $buildYears = intval(protectInjectionWithoutQuote('year', ''));
        if($buildYears > 0){
            $where[] = " CAST( b.year AS SIGNED) >= $buildYears ";
        }
        // end build years numbers

        if (isset($_REQUEST['ownername']) && $_REQUEST['ownername'] == "on")
            $ownername = "$exactly";

        if ($ownername != '' && $ownername != '%%'
          && !( $ownername == 'Guest' || $ownername == 'anonymous' || $ownername == _REALESTATE_MANAGER_LABEL_ANONYMOUS  )  ) {
            $query = "SELECT u.id FROM #__users AS u WHERE LOWER(u.id) LIKE '$ownername' OR LOWER(u.name) LIKE '$ownername';";
            $database->setQuery($query);
            if (version_compare(JVERSION, "3.0.0", "lt"))
                $owner_ids = $database->loadResultArray();
            else
                $owner_ids = $database->loadColumn();

            $ownername = "";
            if (count($owner_ids)) {
                foreach ($owner_ids as $owner_id) {
                    if (isset($_REQUEST['ownername']) && $_REQUEST['ownername'] == "on") {
                        //search from frontend
                        if ($is_add_or)
                            $ownername .= " or ";
                        $is_add_or = true;
                        $ownername .= "b.owner_id='$owner_id'";
                    } else {
                        //show owner houses
                        $where[] = "b.owner_id='$owner_id'";
                    }
                }
            } else if (!$is_add_or) {
                echo"<h1 style='text-align:center'>" . _REALESTATE_MANAGER_LABEL_SEARCH_NOTHING_FOUND . "</h1>";
                return;
            }
        } else if($ownername == 'Guest' || $ownername == 'anonymous' || $ownername == _REALESTATE_MANAGER_LABEL_ANONYMOUS ){
            if (isset($_REQUEST['ownername']) && $_REQUEST['ownername'] == "on") {
                //search from frontend
                if ($is_add_or)
                    $ownername .= " or ";
                $is_add_or = true;
                $ownername .= "b.owner_id=''";
            } else {
                //show owner houses
                $where[] = "b.owner_id=''";
            }
        }

        $search_date_from = protectInjectionWithoutQuote('search_date_from', '');
        $search_date_from = addslashes(date_transform_rem($search_date_from, 'to'));
        $search_date_until = protectInjectionWithoutQuote('search_date_until', '');
        $search_date_until = addslashes(date_transform_rem($search_date_until, 'to'));



        if (isset($_REQUEST['search_date_from']) && (trim($_REQUEST['search_date_from']) ) &&
               trim($_REQUEST['search_date_until']) == "") {
            $RentSQL = "((fk_rentid = 0 OR b.id NOT IN (select dd.fk_houseid " .
             " from #__rem_rent AS dd where dd.rent_until >= ' " . $search_date_from .
             "' and dd.rent_from <= '" . $search_date_from .
             "' and dd.fk_houseid=b.id and dd.rent_return is null)) AND listing_type = \"1\"   AND  rent_by = \"by_day\" )" .
              " OR ((fk_rentid = 0 OR b.id NOT IN (select dd.fk_houseid " .
             " from #__rem_rent AS dd where dd.rent_until > '" . $search_date_from .
             "' and dd.rent_from <= '" . $search_date_from .
             "' and dd.fk_houseid=b.id and dd.rent_return is null)) AND listing_type = \"1\"   AND  rent_by != \"by_day\" )";

            if ($is_add_or)
                $RentSQL .= " AND ";
            $RentSQL_JOIN_1 = "\nLEFT JOIN #__rem_rent AS d ";
            $RentSQL_JOIN_2 = "\nON d.fk_houseid=b.id ";
        }

        if (isset($_REQUEST['search_date_until']) && (trim($_REQUEST['search_date_until']) )
         && trim($_REQUEST['search_date_from']) == "") {
            $RentSQL = "( (fk_rentid = 0 ".
                " OR b.id NOT IN (select dd.fk_houseid "
                . "from #__rem_rent AS dd where dd.rent_from <= '" . $search_date_until . "' and dd.rent_until >= '"
                . $search_date_until . "' and dd.fk_houseid=b.id and dd.rent_return is null) ) AND listing_type = \"1\"   AND  rent_by = \"by_day\"  ) "
                . " OR ( (fk_rentid = 0 ".
                " OR b.id NOT IN (select dd.fk_houseid "
                . "from #__rem_rent AS dd where dd.rent_from < '" . $search_date_until . "' and dd.rent_until >= '"
                . $search_date_until . "' and dd.fk_houseid=b.id and dd.rent_return is null) ) AND listing_type = \"1\"   AND  rent_by != \"by_day\"  ) "


             ;
            if ($is_add_or)
                $RentSQL .= " AND ";
            $RentSQL_JOIN_1 = "\nLEFT JOIN #__rem_rent AS d ";
            $RentSQL_JOIN_2 = "\nON d.fk_houseid=b.id ";
        }

        if (isset($_REQUEST['search_date_until']) && (trim($_REQUEST['search_date_until']))
                && isset($_REQUEST['search_date_from']) && ( trim($_REQUEST['search_date_from']))) {
            $RentSQL = "( (fk_rentid = 0 ".
                        " OR ".
                        " b.id NOT IN (select dd.fk_houseid from #__rem_rent AS dd
                         where (  (dd.rent_until >= '" . $search_date_from . "' and dd.rent_from <= '" . $search_date_from . "') or " .
                        " (dd.rent_from <= '" . $search_date_until . "' and dd.rent_until >= '" . $search_date_until . "' ) or " .
                        " (dd.rent_from >= '" . $search_date_from . "' and dd.rent_until <= '" . $search_date_until . "') )  and dd.rent_return is null ) )". 
                        "   AND listing_type = \"1\"  AND  rent_by = \"by_day\"   )   " .
                    " OR ( (fk_rentid = 0 ".
                        " OR  ".
                        " b.id NOT IN (select dd.fk_houseid from #__rem_rent AS dd
                         where (  (dd.rent_until > '" . $search_date_from . "' and dd.rent_from < '" . $search_date_from . "') or " .
                        " (dd.rent_from < '" . $search_date_until . "' and dd.rent_until > '" . $search_date_until . "' ) or " .
                        " (dd.rent_from >= '" . $search_date_from . "' and dd.rent_until <= '" . $search_date_until . "') )  and dd.rent_return is null ) )". 
                        "   AND listing_type = \"1\"  AND  rent_by != \"by_day\"   ) " ;

            if ($is_add_or)
                $RentSQL .= " AND ";
            $RentSQL_JOIN_1 = "\nLEFT JOIN #__rem_rent AS d ";
            $RentSQL_JOIN_2 = "\nON d.fk_houseid=b.id ";
        }

        $RentSQL = $RentSQL . (($is_add_or) ? ( "( ( " . $Houseid . "  " . $Description .
            "  " . $Title . "  " . $Address .
            "  " . $Country . "  " . $Region . "  " . $City . "  " . $Zipcode . "  " . $Extra1 .
            "  " . $Extra2 . "  " . $Extra3 . "  " . $Extra4 . "  " . $Extra5 . "  " . $Rooms .
            "  " . $Bathrooms . "  " . $Bedrooms . "  " . $Contacts . "  " . $Agent .
            "  " . $House_size . " " . $Lot_size . " " . $Built_year . "  " . $ownername . "  " . $location . "  ))") : (" "));

        if (trim($RentSQL) != "")
            array_push($where, $RentSQL);
        //select category, to which user has access
        $where[] = " ($s) ";
        $where[] = " ($s_cat) ";
        $where[] = " ($s_h) ";
        $where[] = " c.published = '1' ";

        //select published and approved houses
        array_push($where, " b.published = '1' ");
        array_push($where, " b.approved = '1' ");

        if (isset($langContent)) {

            $lang = $langContent;
            // $query = "SELECT lang_code FROM #__languages WHERE sef = '$lang'";
            // $database->setQuery($query);
            // $lang = $database->loadResult();
            $where[] = " ( b.language = '$lang' or b.language like 'all' or b.language like '' "
              ." or b.language like '*' or b.language is null) ";
            $where[] = "  ( c.language = '$lang' or c.language like 'all' or c.language like '' "
              ." or c.language like '*' or c.language is null) ";
        }

        if ($catid != _REALESTATE_MANAGER_LABEL_ALL && $catid != '' && $catid != 0){
             array_push($where, "c.id=" . intval($catid) . "");
        }



        // Get all features from $_REQUEST in $f to use it in query below
        $f = " ";
        if ( isset($_REQUEST['f']) ) {
            $i = 0;
            foreach (($_REQUEST['f']) as $key => $featureid) {
                $f .= "\n AND (f" . intval($key) . ".fk_featureid = '" . intval($featureid) . "') ";
                $i++;
                if($i >=50 ) break;
            }
        }

        $query = "SELECT COUNT(DISTINCT b.id)
                    FROM #__rem_houses AS b
                    LEFT JOIN #__rem_categories AS hc ON b.id=hc.iditem
                    LEFT JOIN #__rem_main_categories AS c ON hc.idcat = c.id ";

        // Create SQL-table (LEFT JOIN) for each feature. It`s need because SQL can`t sort (order) one table (_rem_feature_houses) by a few parameters
        if ( isset($_REQUEST['f']) ) {
            $i = 0;
            foreach (($_REQUEST['f']) as $key => $featureid) {
                $query .= "\n
                    LEFT JOIN #__rem_feature_houses AS f" . intval($key) . " ON f" . intval($key) . 
                    ".fk_houseid = b.id ";
                // SQL can`t process more than 61 table at once. If features more then 50 - just ignore exceeds features
                $i++;
                if($i >=50 ) break;
            }
        }
        $query .= " $RentSQL_JOIN_1  $RentSQL_JOIN_2 ".
                    ((count($where) ? " WHERE " . implode(' AND ', $where) : "")) . $f ;
//echo $query ; exit ;
        $database->setQuery($query);
        $total = $database->loadResult();
        $pageNav = new JPagination($total, $limitstart, $limit);

        // getting all houses for this category
        $query = "SELECT distinct hc.idcat as idcat, b.* , b.id AS bid, c.title AS category_titel, c.description AS cdesc, c.ordering AS category_ordering, c.id as catid, c.id as cid
                    FROM #__rem_houses AS b
                    LEFT JOIN #__rem_categories AS hc ON b.id=hc.iditem
                    LEFT JOIN #__rem_main_categories AS c ON hc.idcat = c.id ";

        // Create SQL-table (LEFT JOIN) for each feature. It`s need because SQL can`t sort (order) one table (_rem_feature_houses) by a few parameters
        if ( isset($_REQUEST['f']) ) {
            $i = 0;
            foreach (($_REQUEST['f']) as $key => $featureid) {
                $query .= "\n LEFT JOIN #__rem_feature_houses AS f" . intval($key) . " ON f" . intval($key) . ".fk_houseid = b.id ";
                // SQL can`t process more than 61 table at once. If features more then 50 - just ignore exceeds features
                $i++;
                if($i >=50 ) break;
            }
        }

        $query .=           " $RentSQL_JOIN_1  $RentSQL_JOIN_2 ".
                    ((count($where) ? "\n WHERE " . implode(' AND ', $where) : "")) .
                     $f . "\n GROUP BY b.id ORDER BY $sort_string
                    \nLIMIT " . $pageNav->limitstart . "," . $pageNav->limit;
        $database->setQuery($query);
        $houses = $database->loadObjectList();
        



        //parameters
        if( $params == null ) {
            $menu = new JTableMenu($database);
            $menu->load($Itemid);
            $params = new JRegistry;
            $params->loadString($menu->params);
        }

        $params->def('category_name', _REALESTATE_MANAGER_LABEL_SEARCH);
        $params->def('search_request', '1');
        $params->def('hits', 1);
        $params->def('show_rating', 1);
        $params->def('sort_arr_order_direction', $sort_arr['order_direction']);
        $params->def('sort_arr_order_field', $sort_arr['order_field']);

        //-----------------------------------------------------------------
        $database->setQuery("SELECT id FROM #__menu WHERE link='index.php?option=com_realestatemanager'");
        if ($database->loadResult() != $Itemid)
            $params->def('wrongitemid', '1');

        if ($realestatemanager_configuration['rentstatus']['show']) {
            $params->def('show_rentstatus', 1);
            if (checkAccess_REM($realestatemanager_configuration['rentrequest']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_rentrequest', 1);
            }
        }
        if ($realestatemanager_configuration['housestatus']['show']) {
            $params->def('show_housestatus', 1);
            if (checkAccess_REM($realestatemanager_configuration['houserequest']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_houserequest', 1);
            }
        }
        if ($realestatemanager_configuration['buystatus']['show']) {
            $params->def('show_buystatus', 1);
            if (checkAccess_REM($realestatemanager_configuration['buyrequest']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_buyrequest', 1);
            }
        }

        if ($realestatemanager_configuration['property_request']['show']) {
            $params->def('show_property_request_status', 1);
            if (checkAccess_REM($realestatemanager_configuration['property_request']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_property_request', 1);
            }
        }

        //*****   begin add for Manager Add house: button 'Add a house'
        if ($realestatemanager_configuration['add_house']['show']) {
            $params->def('show_add_house', 1);
            if (checkAccess_REM($realestatemanager_configuration['add_house']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_input_add_house', 1);
            }
        }
        //*********   end add for Manager Add house: button 'Add a house'   **

        //*****   begin add for Manager Add house: button ' a house'
        if ($realestatemanager_configuration['search_button']['show']) {
            $params->def('show_search_button', 1);
            if (checkAccess_REM($realestatemanager_configuration['search_button']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_input_search_button', 1);
            }
        }

        if ($realestatemanager_configuration['price']['show']) {
            $params->def('show_pricestatus', 1);
            if (checkAccess_REM($realestatemanager_configuration['price']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_pricerequest', 1);
            }
        }

        if ($realestatemanager_configuration['cat_pic']['show'])
            $params->def('show_cat_pic', 1);
        $currentcat = new stdClass();
        $currentcat->descrip = "";
        $currentcat->header = '';

        //used to show table rows in alternating colours
        $tabclass = array('sectiontableentry1', 'sectiontableentry2');
        

        //*****   begin add for Manager Add house: button ' a house'
        if ($realestatemanager_configuration['search_button']['show']) {
            $params->def('show_search_button', 1);
            if (checkAccess_REM($realestatemanager_configuration['search_button']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_input_search_button', 1);
            }
        }

        // show map for layout search_result list
        if (($realestatemanager_configuration['searchlayout_map']['show'])) {
            if (checkAccess_REM($realestatemanager_configuration['searchlayout_map']['registrationlevel'],
             'RECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_searchlayout_map', 1);
            }
        }
        // show order by form for layout search_result list
        if (($realestatemanager_configuration['searchlayout_orderby']['show'])) {
            if (checkAccess_REM($realestatemanager_configuration['searchlayout_orderby']['registrationlevel'],
             'RECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_searchlayout_orderby', 1);
            }
        }



//*********************************** eextra6,extra7,extra8,extra9,extra10 *********************************
        for($i=6;$i<=10;$i++){
          if($realestatemanager_configuration['extra'. $i]==1){
          $extraOption=array();
          $index = 'extra'.$i;
          $vextra = $jinput->get($index) ? $jinput->get($index) : '';
          $extraOption[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
          $name = "_REALESTATE_MANAGER_EXTRA".$i."_SELECTLIST";
          $extra = explode(',', constant($name));
          $j = 1;
          foreach($extra as $extr){
            $extraOption[] = mosHTML::makeOption($j, $extr);
            $j++;
          }
          $extra_list[$i] = mosHTML::selectList($extraOption, 'extra'.$i,
           'class="inputbox" size="1" style="width: 140px"', 'value', 'text', $vextra);
            $params->def('extrafield'.$i, $extra_list[$i]);
          }else{
            $extra_list[$i] = '<input type="hidden" name="extrafield' . $i . '" class="inputbox" size="1" value="" />';
            $params->def('extrafield'.$i, $extra_list[$i]);
          }
        }
//***************** end extra6,extra7,extra8,extra9,extra10 ******************************
//*********************************** numbers rooms list *********************************
        $numbers = explode(',', _REALESTATE_MANAGER_NUMBERS_BBROOMS);
        if($realestatemanager_configuration['search_rooms_num_field_show']==1){
            $room = $jinput->get('rooms_num') ? $jinput->get('rooms_num') : _REALESTATE_MANAGER_LABEL_ALL;
            $rooms[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
            $count = 1;
            foreach($numbers as $num){
                $rooms[] = mosHtml::makeOption($count, $num);
                $count++;
            }
            $rooms_list = mosHTML::selectList($rooms, 'rooms_num', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $room);
            $params->def('rooms_num', $rooms_list);
        }
//******************************* end numbers rooms list *********************************
//******************************* numbers bathrooms list *********************************
        if($realestatemanager_configuration['search_bathrooms_num_field_show'] == 1){
            $bathroom = $jinput->get('bathrooms_num') ? $jinput->get('bathrooms_num') : _REALESTATE_MANAGER_LABEL_ALL;
            $bathrooms[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
            $count = 1;
            foreach($numbers as $num){
                $bathrooms[] = mosHtml::makeOption($count, $num);
                $count++;
            }
            $bathrooms_list = mosHTML::selectList($bathrooms, 'bathrooms_num', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $bathroom);
            $params->def('bathrooms_num', $bathrooms_list);
        }
//************************** end numbers bathrooms list *********************************
//******************************* numbers bedrooms list *********************************
        if($realestatemanager_configuration['search_bedrooms_num_field_show'] == 1){
            $bedroom = $jinput->get('bedrooms_num') ? $jinput->get('bedrooms_num') : _REALESTATE_MANAGER_LABEL_ALL;
            $bedrooms[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
            $count = 1;
            foreach($numbers as $num){
                $bedrooms[] = mosHtml::makeOption($count, $num);
                $count++;
            }
            $bedrooms_list = mosHTML::selectList($bedrooms, 'bedrooms_num', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $bedroom);
            $params->def('bedrooms_num', $bedrooms_list);
        }
//********************** end numbers bedrooms list *********************************

//*************************** numbers garages list *********************************
        if($realestatemanager_configuration['search_form_garages_field_show'] == 1){
            $garage = $jinput->get('garages_num') ? $jinput->get('garages_num') : _REALESTATE_MANAGER_LABEL_ALL;
            $garages[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
            $count = 1;
            foreach($numbers as $num){
                $garages[] = mosHtml::makeOption($count, $num);
                $count++;
            }
            $garages_list = mosHTML::selectList($garages, 'garages_num', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $garage);
            $params->def('garages_num', $garages_list);
        }
//*********************** end numbers garages list *********************************
//*********************** numbers build years list *********************************
        if($realestatemanager_configuration['search_form_build_year_field_show'] == 1){
            $build_year = $jinput->get('year') ? $jinput->get('year') : _REALESTATE_MANAGER_LABEL_ALL;
            $build_years[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
            // $count = 1;
            for ($year = intval(date('Y')) + 1; 1900 < $year; $year--) {
                // $build_years[] = mosHtml::makeOption($count, $year);
                if ($year == intval(date('Y')) + 1) {
                    $year_plus = $year;
                } else {
                    $year_plus = $year . '+';
                }
                // $build_years[] = mosHtml::makeOption($count, $year_plus);
                $build_years[] = mosHtml::makeOption($year, $year_plus);
                // $count++;
            }
            $build_years_list = mosHTML::selectList($build_years, 'year', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $build_year);
            $params->def('year', $build_years_list);
        }
//******************* end numbers build years list *********************************

//********** add show search form on nothing found page ****************************
        if($realestatemanager_configuration['search_form_on_nothing_found_page_show']) {
            $params->def('search_form_on_nothing_found_page_show', '1');
        }
//****************** end show search form on nothing found page ********************

//************** add show search form on nothing found page ************************
        if($realestatemanager_configuration['search_form_on_result_search_page_show']) {
            $params->def('search_form_on_result_search_page_show', '1');
        }
//************* end show search form on nothing found page *************************

        $params->def('singleuser01', "{loadposition com_realestatemanager_single_user_house_01,xhtml}");
        $params->def('singleuser02', "{loadposition com_realestatemanager_single_user_house_02,xhtml}");
        $params->def('singleuser03', "{loadposition com_realestatemanager_single_user_house_03,xhtml}");
        $params->def('singleuser04', "{loadposition com_realestatemanager_single_user_house_04,xhtml}");
        $params->def('singleuser05', "{loadposition com_realestatemanager_single_user_house_05,xhtml}");
        $params->def('notfound01', "{loadposition com_realestatemanager_nothing_found_house_01,xhtml}");
        $params->def('notfound02', "{loadposition com_realestatemanager_nothing_found_house_02,xhtml}");
        $params->def('view05', "{loadposition com_realestatemanager_view_house_05,xhtml}");
        $params->def('ownerlist03', "{loadposition com_realestatemanager_owner_list_03,xhtml}");

        if (isset($_REQUEST['searchLayout'])){
          $layout = $_REQUEST['searchLayout'];
        } else {
          $layout = '';
        }
        if (isset($_REQUEST['typeLayout'])){
          $type = $_REQUEST['typeLayout'];
        } else {
          $type = '';
        }

        if (count($houses)) {
            
            if ($task == 'search') {

                $layout = $params->get('searchresultlayout');
                $layoutsearch = $params->get('showsearchhouselayout');

                if(empty($layout)){
                    $menu = new JTableMenu($database);
                    $menu->load($GLOBALS['Itemid']);
                    $menu_params = new JRegistry;
                    $menu_params->loadString($menu->params);
                    $layout = $menu_params->get('allhouselayout', '');
                    if ($layout == '')
                        $layout = 'default';

                }
                if(empty($layoutsearch)){
                    $layoutsearch = $realestatemanager_configuration['default_search_layout'];
                }

                HTML_realestatemanager::displaySearchHouses($houses, $currentcat, $params, $tabclass, $catid, null,
                $pageNav, false, $option, $layout, $layoutsearch);
            } else {
                //task == "owner_houses"
                if ($layout == '')  $layout = 'default';

                HTML_realestatemanager::displayHouses($houses, $currentcat, $params, 
                    $tabclass, $catid, null, $pageNav, false, $option, $layout, "alone_category");
            }
        } else {

            positions_rem($params->get('notfound01'));
            if ($task == 'search') {  
              $layoutsearch = $params->get('showsearchhouselayout', 'default');

              if($params->get('search_form_on_nothing_found_page_show')){
                PHP_realestatemanager::showSearchHouses($option, $catid, $params, $layoutsearch);
              }
            }
            print_r("<h1 style='text-align:center'>" . _REALESTATE_MANAGER_LABEL_SEARCH_NOTHING_FOUND . " </h1><br><br><div class='row-fluid'><div class='span9'></div></div>");
            positions_rem($params->get('notfound02'));

            // "<div class='span3'><div class='rem_house_contacts'>
            // <div id='rem_house_titlebox'>" . _REALESTATE_MANAGER_SHOW_SEARCH . "</div> "
             // PHP_realestatemanager::showSearchHouses($option, $catid, $params, $layout);
             // print_r('</div></div></div>');
        }
    }


static function ajax_rent_calcualete($bid,$rent_from,$rent_until,$how_many_weeks,$how_many_monthes){

    global $realestatemanager_configuration;

    $database = JFactory::getDBO();


    $rent_from_tmp = date_transform_rem($rent_from,'to');
    
    $rent_from_tmp = substr($rent_from_tmp, 0, 10);
    if($rent_until != "" && $rent_until != 0 ){
      $rent_until_tmp = date_transform_rem($rent_until,'to');
      $rent_until_tmp = substr($rent_until_tmp, 0, 10);   
    }
    else $rent_until_tmp =  calculate_rent_until_REM ( $rent_from, $rent_until,$how_many_weeks,$how_many_monthes) ;
    
       // echo ":11111:".$rent_from.":11111:".$rent_until.":11111:".$how_many_weeks.":11111:".$how_many_monthes;
//echo ":11111:".$rent_until_tmp;
    if ($rent_until_tmp == "" or $rent_until_tmp == "") {
        echo _REALESTATE_MANAGER_ADMIN_BAD_DATE_ALERT ;
        exit;
    }
    if ($rent_from_tmp > $rent_until_tmp) {
        echo  $rent_from_tmp . " is more than " . $rent_until_tmp ;
        exit;
    }


    $query = "SELECT * FROM #__rem_rent where fk_houseid = " . $bid[0] .
      " AND rent_return is NULL ";
    $database->setQuery($query);
    $rentTerm = $database->loadObjectList();

    $house = new mosRealEstateManager($database);
    $house->load( $bid[0] );    

    foreach ($rentTerm as $oneTerm){
        $oneTerm->rent_from = substr($oneTerm->rent_from, 0, 10);
        $oneTerm->rent_until = substr($oneTerm->rent_until, 0, 10);
        $returnMessage = checkRentDayNightREM (($oneTerm->rent_from),($oneTerm->rent_until),
         $rent_from_tmp, $rent_until_tmp,$house->rent_by);
       // echo ":11111:".$oneTerm->rent_from.":11111:".$oneTerm->rent_until.":11111:".$rent_from_tmp.":11111:".$rent_until_tmp;

        if(strlen($returnMessage) > 0){
          echo $returnMessage;
          exit;
        }
    }


    $resulArr = calculatePriceREM ($bid[0],$rent_from,$rent_until,$how_many_weeks,$how_many_monthes);

    echo $resulArr[0].' '.$resulArr[1];
    exit;
   }

  static function guid() {
    if (function_exists('com_create_guid')){
      return trim(com_create_guid(), '{}');
    } else
    {
      mt_srand((double) microtime() * 10000); //optional for php 4.2.0 and up.
      $charid = strtoupper(md5(uniqid(rand(), true)));
      $hyphen = chr(45); // "-"
      $uuid = //chr(123)// "{"
      substr($charid, 0, 8) . $hyphen
      . substr($charid, 8, 4) . $hyphen
      . substr($charid, 12, 4) . $hyphen
      . substr($charid, 16, 4) . $hyphen
      . substr($charid, 20, 12);
      //.chr(125);// "}"
      return $uuid;
    }
  }


   static function secretImage($key="") {
        $session = JFactory::getSession();
        
        $uniqid = trim(mosGetParam($_REQUEST, 'uniqid', ""));
        $pas = $session->get('captcha_keystring_' . $uniqid, 'default');

        $new_img = new PWImageRealestate();
        $new_img->set_show_string($pas);
        $new_img->get_show_image(2.2, array(mt_rand(0, 50), mt_rand(0, 50), mt_rand(0, 50)), array(mt_rand(200, 255),
            mt_rand(200, 255), mt_rand(200, 255)));
        exit;
    }

    function checkAccess_REM($accessgroupid, $recurse, $usersgroupid, $acl) {
        $usersgroupid = explode(',', $usersgroupid);

        //parse usergroups
        $tempArr = array();
        $tempArr = explode(',', $accessgroupid);

        for ($i = 0; $i < count($tempArr); $i++) {
            if (($tempArr[$i] == $usersgroupid OR in_array($tempArr[$i], $usersgroupid)) || $tempArr[$i] == -2) {
                //allow access
                return true;
            } else {
                if ($recurse == 'RECURSE') {
                    if (is_array($usersgroupid)) {
                        for ($j = 0; $j < count($usersgroupid); $j++) {
                            if (in_array($usersgroupid[$j], $tempArr))
                                return 1;
                        }
                    } else {
                        if (in_array($usersgroupid, $tempArr))
                            return 1;
                    }
                }
            }
        } // end for
        //deny access
        return 0;
    }


    static function ShowAllHouses($layout = "default", $printItem = "") {
        global $mainframe, $database, $acl, $my, $langContent;
        global $mosConfig_shownoauth, $mosConfig_live_site, $mosConfig_absolute_path;
        global $cur_template, $Itemid, $realestatemanager_configuration,
         $mosConfig_list_limit, $limit, $total, $limitstart;

        PHP_realestatemanager::addTitleAndMetaTags();

        if (isset($langContent)) {

            $lang = $langContent;
            // $query = "SELECT lang_code FROM #__languages WHERE sef = '$lang'";
            // $database->setQuery($query);
            // $lang = $database->loadResult();

            $lang = " and ( h.language = '$lang' or h.language like 'all' or "
              ." h.language like '' or h.language like '*' or h.language is null) "
              . " AND ( c.language = '$lang' or c.language like 'all' or "
              ." c.language like '' or c.language like '*' or c.language is null) ";
        } else {
            $lang = "";
        }

        //sorting
        $item_session = JFactory::getSession();
        $sort_arr = $item_session->get('rem_housesort', '');
        if (is_array($sort_arr)) {
            $tmp1 = protectInjectionWithoutQuote('order_direction');
            if ($tmp1 != '')
                $sort_arr['order_direction'] = $tmp1;
            $tmp1 = protectInjectionWithoutQuote('order_field');
            if ($tmp1 != '')
                $sort_arr['order_field'] = $tmp1;
            $item_session->set('rem_housesort', $sort_arr);
        } else {
            $sort_arr = array();
            $sort_arr['order_direction'] = 'asc';
            if(isset($realestatemanager_configuration['order_by_default']) && $realestatemanager_configuration['order_by_default'] != ''){
                 $sort_arr['order_field'] = $realestatemanager_configuration['order_by_default'];
                 if($sort_arr['order_field'] == 'date') $sort_arr['order_direction'] = 'desc';
            }
            else{
                $sort_arr['order_field'] = 'date';
            }

            $item_session->set('rem_housesort', $sort_arr);
        }
        if ($sort_arr['order_field'] == "price")
            $sort_string = "CAST( " . $sort_arr['order_field'] . " AS SIGNED)" . " " .
             $sort_arr['order_direction'];
        else
            $sort_string = $sort_arr['order_field'] . " " . $sort_arr['order_direction'];

        //getting groups of user
        $s = getWhereUsergroupsCondition("c");
        $s_cat = getWhereDatePublishStringRem('c');
        $s_h = getWhereDatePublishStringRem('h');

        $query = "SELECT COUNT(DISTINCT h.id)
            \nFROM #__rem_houses AS h"
                . "\nLEFT JOIN #__rem_categories AS hc ON hc.iditem=h.id"
                . "\nLEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat"
                . "\nWHERE h.published='1' AND h.approved='1' AND c.published='1'  $lang
              AND ($s) AND ($s_cat) AND ($s_h) ";

        $database->setQuery($query);
        $total = $database->loadResult();

        $pageNav = new JPagination($total, $limitstart, $limit);

        // getting all items for this category
        $query = "SELECT h.*,hc.idcat AS catid,hc.idcat AS idcat, c.title as category_titel
       \nFROM #__rem_houses AS h "
                . "\nLEFT JOIN #__rem_categories AS hc ON hc.iditem=h.id "
                . "\nLEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat "
                . "\nWHERE h.published='1' AND h.approved='1'  "
                . "\nAND c.published='1' $lang AND ($s) AND ($s_cat) AND ($s_h) "
                . "\nGROUP BY h.id "
                . "\nORDER BY " . $sort_string
                . "\nLIMIT $pageNav->limitstart,$pageNav->limit;";
        $database->setQuery($query);

        $houses = $database->loadObjectList();

        $query = "SELECT h.*,c.id, c.parent_id, c.title, c.published, c.image,COUNT(hc.iditem) as houses, '1' as display" .
                " \n FROM  #__rem_main_categories as c
              \n LEFT JOIN #__rem_categories AS hc ON hc.idcat=c.id
              \n LEFT JOIN #__rem_houses AS h ON h.id=hc.iditem
              \n WHERE c.section='com_realestatemanager'
              AND c.published=1 AND ({$s})  AND ({$s_cat}) AND ({$s_h}) $lang
              \n GROUP BY c.id
              \n ORDER BY c.parent_id DESC, c.ordering ";

        $database->setQuery($query);
        $cat_all = $database->loadObjectList();

        foreach ($cat_all as $k1 => $cat_item1) {
            if (PHP_realestatemanager::is_exist_curr_and_subcategory_houses($cat_all[$k1]->id)) {
                foreach ($cat_all as $cat_item2) {
                    if ($cat_item1->id == $cat_item2->parent_id) {
                        $cat_all[$k1]->houses += $cat_item2->houses;
                    }
                }
            } else
                $cat_all[$k1]->display = 0;
        }

            $menu = new JTableMenu($database);
            $menu->load($Itemid);
            $params = new JRegistry;
            $params->loadString($menu->params);

        
         
        //$params->set('category_name', $category->title);
        $params->def('show_category', '1');


        if (($realestatemanager_configuration['rentstatus']['show'])) {
            if (checkAccess_REM($realestatemanager_configuration['rentrequest']['registrationlevel'],
             'RECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_rentstatus', 1);
                $params->def('show_rentrequest', 1);
            }
        }

        if (($realestatemanager_configuration['housestatus']['show'])) {
            if (checkAccess_REM($realestatemanager_configuration['houserequest']['registrationlevel'],
             'RECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_housestatus', 1);
                $params->def('show_houserequest', 1);
            }
        }
//     //add to path category name
//     PHP_realestatemanager::constructPathway($category);

        if ($realestatemanager_configuration['reviews']['show']) {
            $params->def('show_reviews', 1);
            if (checkAccess_REM($realestatemanager_configuration['reviews']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_inputreviews', 1);
            }
        }
        if ($realestatemanager_configuration['search_button']['show']) {
            $params->def('show_search_button', 1);
            if (checkAccess_REM($realestatemanager_configuration['search_button']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_input_search_button', 1);
            }
        }
//***************   begin show search all houses    *********************
        if ($realestatemanager_configuration['search_all_houses']['show']) {
            $params->def('search_all_houses', 1);
            if (checkAccess_REM($realestatemanager_configuration['search_all_houses']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('search_all_houses_registrationlevel', 1);
            }
        }
//**************   end show search all houses    ******************************
        $params->def('sort_arr_order_direction', $sort_arr['order_direction']);
        $params->def('sort_arr_order_field', $sort_arr['order_field']);
//************** show/hide order by field ******************************
        if ($realestatemanager_configuration['searchlayout_orderby']['show'])
        {
            $params->def('searchlayout_orderby', 1);
            if (checkAccess_REM($realestatemanager_configuration['searchlayout_orderby']['registrationlevel'], 'RECURSE', userGID_REM($my->id), $acl))
            {
              $params->def('show_searchlayout_orderby', 1);
            }
        }
//************** show/hide order by field ******************************
//************** add for show in category picture ******************************
        if ($realestatemanager_configuration['cat_pic']['show'])
            $params->def('show_cat_pic', 1);

        $params->def('search_request', 1);
        $params->def('show_rating', 1);
        $params->def('hits', 1);

        // used to show table rows in alternating colours
        $tabclass = array('sectiontableentry1', 'sectiontableentry2');

        $params->def('minifotohigh', $realestatemanager_configuration['foto']['high']);
        $params->def('minifotowidth', $realestatemanager_configuration['foto']['width']);

        // price
        if ($realestatemanager_configuration['price']['show']) {
            $params->def('show_pricestatus', 1);
            if (checkAccess_REM($realestatemanager_configuration['price']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_pricerequest', 1);
            }
        }

        $params->def('singlecategory01', "{loadposition com_realestatemanager_all_house_01,xhtml}");
        $params->def('singlecategory02', "{loadposition com_realestatemanager_all_house_02,xhtml}");
        $params->def('singlecategory03', "{loadposition com_realestatemanager_all_house_03,xhtml}");
        $params->def('singlecategory04', "{loadposition com_realestatemanager_all_house_04,xhtml}");
        $params->def('singlecategory05', "{loadposition com_realestatemanager_all_house_05,xhtml}");
        $params->def('singlecategory06', "{loadposition com_realestatemanager_all_house_06,xhtml}");
        $params->def('singlecategory07', "{loadposition com_realestatemanager_all_house_07,xhtml}");
        $params->def('singlecategory08', "{loadposition com_realestatemanager_all_house_08,xhtml}");
        $params->def('singlecategory09', "{loadposition com_realestatemanager_all_house_09,xhtml}");
        $params->def('singlecategory10', "{loadposition com_realestatemanager_all_house_10,xhtml}");
        $params->def('singlecategory11', "{loadposition com_realestatemanager_all_house_11,xhtml}");

        switch ($printItem) {

            default:
                HTML_realestatemanager::displayAllHouses($houses, $params, $tabclass, $pageNav, $layout);
                break;
        }
    }

    //this function check - is exist folders under this category
    static function is_exist_subcategory_houses($catid)
    {
        global $database, $my;

        $s = getWhereUsergroupsCondition("cc");
        $s_cat = getWhereDatePublishStringRem('cc');
        $s_h = getWhereDatePublishStringRem('a');

        $query = "SELECT *, COUNT(a.id) AS numlinks FROM #__rem_main_categories AS cc"
                . "\n  JOIN #__rem_categories AS hc ON hc.idcat = cc.id"
                . "\n  JOIN #__rem_houses AS a ON a.id = hc.iditem"
                . "\n WHERE a.published='1' AND a.approved='1' AND section='com_realestatemanager' "
                . " AND cc.parent_id='" . intval($catid) . "' AND cc.published='1' "
                ." AND ($s) AND ($s_cat) AND ($s_h) "
                . "\n GROUP BY cc.id"
                . "\n ORDER BY cc.ordering";
        $database->setQuery($query);

        $categories = $database->loadObjectList();
        if (count($categories) != 0)
            return true;

        $query = "SELECT id "
                . "FROM #__rem_main_categories AS cc "
                . " WHERE section='com_realestatemanager' AND parent_id='" .
                 intval($catid) . "' AND published='1' AND ($s) AND ($s_cat) ";
        $database->setQuery($query);
        $categories = $database->loadObjectList();

        if (count($categories) == 0)
            return false;

        foreach ($categories as $k) {
            if (PHP_realestatemanager::is_exist_subcategory_houses($k->id))
                return true;
        }
        return false;
    }

    static function is_exist_curr_and_subcategory_houses($catid) {
        global $database, $my;

        $s = getWhereUsergroupsCondition("cc");
        $s_cat = getWhereDatePublishStringRem('cc');
        $s_h = getWhereDatePublishStringRem('a');

        $query = "SELECT *, COUNT(a.id) AS numlinks FROM #__rem_main_categories AS cc"
                . "\n  JOIN #__rem_categories AS hc ON hc.idcat = cc.id"
                . "\n  JOIN #__rem_houses AS a ON a.id = hc.iditem"
                . "\n WHERE a.published='1' AND a.approved='1' AND section='com_realestatemanager' "
                . " AND cc.id='" . intval($catid) . "' AND cc.published='1' "
                . " AND ($s) AND ($s_cat) AND ($s_h) "
                . "\n GROUP BY cc.id"
                . "\n ORDER BY cc.ordering";
        $database->setQuery($query);

        $categories = $database->loadObjectList();
        if (count($categories) != 0)
            return true;

        $query = "SELECT id "
                . "FROM #__rem_main_categories AS cc "
                . " WHERE section='com_realestatemanager' AND parent_id='" .
                 intval($catid) . "' AND published='1' AND ($s) AND ($s_cat) ";
        $database->setQuery($query);
        $categories = $database->loadObjectList();

        if (count($categories) == 0)
            return false;

        foreach ($categories as $k) {
            if (PHP_realestatemanager::is_exist_curr_and_subcategory_houses($k->id))
                return true;
        }
        return false;
    }

    static function listCategories($catid, $layout, $languagelocale) {
        global $mainframe, $database, $my, $acl, $langContent;
        global $mosConfig_shownoauth, $mosConfig_live_site, $mosConfig_absolute_path;
        global $cur_template, $Itemid, $realestatemanager_configuration;

        PHP_realestatemanager::addTitleAndMetaTags();

        $s = getWhereUsergroupsCondition("c");

        $s_cat = getWhereDatePublishStringRem('c');
        $s_h = getWhereDatePublishStringRem('h');


        if (isset($langContent)) {

            $lang = $langContent;
            $lang_h = " and ( h.language = '$lang' or h.language like 'all' or "
              ." h.language like '' or h.language like '*' or h.language is null) ";
            $lang_c = " AND ( c.language = '$lang' or c.language like 'all' or "
              . " c.language like '' or c.language like '*' or c.language is null) ";
        } else {
            $lang_h = "";
            $lang_c = "";
        }


        $ordering = $realestatemanager_configuration['cat_orderind_default'];
         $query = "SELECT h.*,c.id, c.parent_id, c.title, c.image,COUNT(hc.iditem) as houses, '1' as display" .
                "\n FROM  #__rem_main_categories as c " .
                "\n LEFT JOIN #__rem_categories AS hc ON hc.idcat=c.id " .
                "\n LEFT JOIN #__rem_houses AS h ON h.id=hc.iditem AND ".
                " ( h.published || isnull(h.published) ) AND ".
                " ( h.approved || isnull(h.approved ) ) $lang_h " .
                "\n WHERE c.section='com_realestatemanager' AND c.published=1 " .
                "\n  $lang_c AND ({$s}) AND ({$s_cat}) AND ({$s_h}) ".
                "\n GROUP BY c.id ORDER BY c.parent_id DESC, c.".$ordering;


        $database->setQuery($query);
        $cat_all = $database->loadObjectList();
        foreach ($cat_all as $k1 => $cat_item1) {

            $query = "SELECT COUNT(hc.iditem) as houses" .
                         "\n FROM  #__rem_main_categories as c " .
                         "\n LEFT JOIN #__rem_categories AS hc ON hc.idcat=c.id " .
                         "\n LEFT JOIN #__rem_houses AS h ON h.id=hc.iditem " .
                 "\n WHERE c.section='com_realestatemanager' ".
                 " AND c.published=1  $lang_h  $lang_c ".
                 "\n AND ( h.published || isnull(h.published) ) AND ".
                " ( h.approved || isnull(h.approved )) ".
                " AND ({$s}) AND ({$s_cat}) AND ({$s_h}) " .
                "\n AND c.id = " . $cat_all[$k1]->id . 
                "\n GROUP BY c.id";

            $database->setQuery($query);

            $houses_count = $database->loadObjectList();
            if($houses_count)
                $cat_all[$k1]->houses = $houses_count[0]->houses;
            else
                $cat_all[$k1]->houses = 0;

            $cat_all[$k1]->display = PHP_realestatemanager::is_exist_curr_and_subcategory_houses($cat_all[$k1]->id);

        }


        // Parameters
        $menu = new JTableMenu($database);
        $menu->load($Itemid);
        $params = new JRegistry;
        $params->loadString($menu->params);


        // page header
        $currentcat = new stdClass();
        $currentcat->descrip = _REALESTATE_MANAGER_DESC;

        //*****   begin add for Manager Add house: button 'Add a house'
        if (($realestatemanager_configuration['add_house']['show'])) {
            $params->def('show_add_house', 1);
            if (checkAccess_REM($realestatemanager_configuration['add_house']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_input_add_house', 1);
            }
        }
        //*********   end add for Manager Add house: button 'Add a house'   **

        //*****   begin add for Manager Add house: button ' a house'
        if ($realestatemanager_configuration['search_button']['show']) {
            $params->def('show_search_button', 1);
            if (checkAccess_REM($realestatemanager_configuration['search_button']['registrationlevel'],
             'NORECURSE', userGID_REM($my->id), $acl)) {
                $params->def('show_input_search_button', 1);
            }
        }
        //show_button_my_houses
        if ($my->email != null) {
            $params->def('show_button_my_houses', 1);
        }


        if (checkAccess_REM($realestatemanager_configuration['ownerslist']['registrationlevel'],
         'RECURSE', userGID_REM($my->id), $acl) &&
                $realestatemanager_configuration['ownerslist']['show']) {
            $params->def('ownerslist_show', 1);
        }
        //add for show in category picture
        if ($realestatemanager_configuration['cat_pic']['show'])
            $params->def('show_cat_pic', 1);


        // used to show table rows in alternating colours
        $tabclass = array('sectiontableentry1', 'sectiontableentry2');

        $params->def('allcategories01', "{loadposition com_realestatemanager_all_categories_01,xhtml}");
        $params->def('allcategories02', "{loadposition com_realestatemanager_all_categories_02,xhtml}");
        $params->def('allcategories03', "{loadposition com_realestatemanager_all_categories_03,xhtml}");
        $params->def('allcategories04', "{loadposition com_realestatemanager_all_categories_04,xhtml}");
        $params->def('allcategories05', "{loadposition com_realestatemanager_all_categories_05,xhtml}");
        $params->def('allcategories06', "{loadposition com_realestatemanager_all_categories_06,xhtml}");
        $params->def('allcategories07', "{loadposition com_realestatemanager_all_categories_07,xhtml}");
        $params->def('allcategories08', "{loadposition com_realestatemanager_all_categories_08,xhtml}");
        $params->def('allcategories09', "{loadposition com_realestatemanager_all_categories_09,xhtml}");
        $params->def('allcategories10', "{loadposition com_realestatemanager_all_categories_10,xhtml}");


        HTML_realestatemanager::showCategories($params, $cat_all, $catid, $tabclass, $currentcat, $layout);
    }



    static function getMonthCal($month, $year, $id) {
      global $database, $realestatemanager_configuration;
      $query = "SELECT rent_from, rent_until, rent_return FROM #__rem_rent WHERE fk_houseid='$id' ORDER BY rent_from";
      $database->setQuery($query);
      $calenDate = $database->loadObjectList();
      $skip = date("w", mktime(0, 0, 0, $month, 1, $year)) - 1;
      if ($skip < 0){
        $skip = 6;
      }
      $daysInMonth = date("t", mktime(0, 0, 0, $month, 1, $year));
    /*******************************get only rent days*****************************/
      $rentDataArr = array();
      $i=0;
      foreach ($calenDate as &$value) {
        if(!($value->rent_return)){
          if(isset($calenDate[($i+1)]) && $calenDate[($i+1)]->rent_from == $calenDate[$i]->rent_until){
            $calenDate[($i+1)]->rent_from = $calenDate[$i]->rent_from;
            unset($calenDate[$i]);
            $i++;
            continue;
          }
         array_push($rentDataArr, $value);
        }$i++;
      }
      $calenDate = $rentDataArr;
      $calendar = '';
      $day = 1;
      $smonth = PHP_realestatemanager::getMonth($month);
      $calendar = '<table class="rem_tableC" style="border-collapse: separate;'.
        ' border-spacing: 2px;text-align:center"><tr class="year"><th colspan = "7">' .
        $smonth . ' ' . $year . '</th></tr><tr class="days"><th>' . JText::_('MON') .
        '</th><th>' . JText::_('TUE') . '</th><th>' . JText::_('WED') . '</th><th>' .
        JText::_('THU') . '</th><th>' . JText::_('FRI') . '</th><th>' . JText::_('SAT') .
         '</th><th>' . JText::_('SUN') . '</th></tr>';
      for ($i = 0; $i < 6; $i++) {
        $calendar .= '<tr>';
        for ($j = 0; $j < 7; $j++) {
          if (($skip > 0) or ($day > $daysInMonth)){
            $calendar .= '<td> &nbsp; </td>';
            $skip--;
          }else{
            $isAvilable = getAvilableRM($calenDate,$month,$year,$realestatemanager_configuration,$day, $id);
            $calendar .= '<td class="'.$isAvilable.'">' . $day . '</td>';
            $day++;
          }
        }
        $calendar .= '</tr>';
      }
      $calendar .= '</table>';

      return $calendar;
    }


    static function getCalendar($month, $year, $id){
      $month = (int) $month;
          $year = (int) $year;

          if ($month == 1)
          {
              $month1 = 12;
              $year1 = $year - 1;
          } else
          {
              $month1 = $month - 1;
              $year1 = $year;
          }

          if ($month == 12)
          {
              $month2 = 1;
              $month3 = 2;
              $year2 = $year3 = $year + 1;
          } else
          {
              $month2 = $month + 1;
              $month3 = $month + 2;
              $year2 =$year3 = $year;
          }
          if($month3 > 12){
            $month3 = $month3 - 12;
            $year3 = $year + 1;
          }
      $calendar = new stdClass();
      $calendar->tab1 = PHP_realestatemanager::getMonthCal($month1, $year1, $id);
      $calendar->tab2 = PHP_realestatemanager::getMonthCal($month, $year, $id);
      $calendar->tab3 = PHP_realestatemanager::getMonthCal($month2, $year2, $id);
      $calendar->tab4 = PHP_realestatemanager::getMonthCal($month3, $year3, $id);

      return $calendar;
    }


}
