<?php
/**
 *
 * @package  RealEstateManager
 * @copyright 2021 Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: http://www.ordasoft.com
 *
 */

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

global $hide_js, $Itemid, $mainframe, $mosConfig_live_site, $doc,
$realestatemanager_configuration, $database, $task;
// $doc->addStyleSheet($mosConfig_live_site .
//  '/components/com_realestatemanager/includes/realestatemanager.css');

?>

  <div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">
    <?php 
    if ( is_menu_item_rem($Itemid)
        && $params->get('show_page_heading') 
        && trim($params->get('page_heading')) != "" ) {  ?>
              <h1><?php echo $params->get('page_heading'); ?></h1>
    <?php } else if( is_menu_item_rem($Itemid, "show_search_house") ){  ?>
              <h1><?php echo _REALESTATE_MANAGER_LABEL_SEARCH;  ?></h1>                
    <?php } ?>
  </div>


<div class="componentbody<?php echo $params->get('pageclass_sfx'); ?>">
<?php
$query = "SELECT max(price+0) FROM #__rem_houses";
$database->setQuery($query);
$max_price = $database->loadResult();

// lot size slider
$query = "SELECT max(lot_size+0) FROM #__rem_houses";
$database->setQuery($query);
$max_lot_size = $database->loadResult();

// house size slider
$query = "SELECT max(house_size+0) FROM #__rem_houses";
$database->setQuery($query);
$max_house_size = $database->loadResult();

$query = "SELECT * ";
$query .= "FROM #__rem_feature as f ";
$query .= "WHERE f.published = 1 ";
$query .= "ORDER BY f.name";
$database->setQuery($query);
$house_feature = $database->loadObjectList();



$pricefrom = 0 ;
$priceto = $max_price ;
$lotsizefrom = 0;
$lotsizeto = $max_lot_size;
$housesizefrom = 0;
$housesizeto = $max_house_size;
$search_date_from = "" ;
$search_date_until = "" ;

if ($task == 'search') {
    $jinput = JFactory::getApplication()->input;
    $checkbox = array();
    $check = 'checked = "checked"';
    $checkbox['Houseid'] = $jinput->get('Houseid') == 'on' ? $check : '';
    $checkbox['Description'] = $jinput->get('Description') == 'on' ? $check : '';
    $checkbox['Title'] = $jinput->get('Title') == 'on' ? $check : '';
    $checkbox['Country'] = $jinput->get('Country') == 'on' ? $check : '';
    $checkbox['Address'] = $jinput->get('Address') == 'on' ? $check : '';
    $checkbox['Region'] = $jinput->get('Region') == 'on' ? $check : '';
    $checkbox['City'] = $jinput->get('City') == 'on' ? $check : '';
    $checkbox['Zipcode'] = $jinput->get('Zipcode') == 'on' ? $check : '';
    $checkbox['ownername'] = $jinput->get('ownername') == 'on' ? $check : '';
    $checkbox['rooms'] = $jinput->get('rooms') == 'on' ? $check : '';
    $checkbox['Bathrooms'] = $jinput->get('Bathrooms') == 'on' ? $check : '';
    $checkbox['Bedrooms'] = $jinput->get('Bedrooms') == 'on' ? $check : '';
    /*$checkbox['Garages'] = $jinput->get('Garages') == 'on' ? $check : '';
    $checkbox['year'] = $jinput->get('year') == 'on' ? $check : '';*/
    $checkbox['Contacts'] = $jinput->get('Contacts') == 'on' ? $check : '';
    $checkbox['Agent'] = $jinput->get('Agent') == 'on' ? $check : '';
    $checkbox['house_size'] = $jinput->get('house_size') == 'on' ? $check : '';
    $checkbox['lot_size'] = $jinput->get('lot_size') == 'on' ? $check : '';
    $checkbox['exactly'] = $jinput->get('exactly') == 'on' ? $check : '';

    // Get all features which checked on advanced search page
    $checkbox['f'] = $jinput->get('f');
    if ( is_array($checkbox['f']) ) {
        $checkbox['f'] = array_flip($checkbox['f'] ) ;
    } else {
        $checkbox['f'] = array();
    }

    $pricefrom = $jinput->get('pricefrom2') ? $jinput->get('pricefrom2') : ($jinput->get('pricefrom') ? $jinput->get('pricefrom'): 0) ;
    $priceto = $jinput->get('priceto2') ? $jinput->get('priceto2') : ($jinput->get('priceto') ? $jinput->get('priceto'): $max_price) ;

    $lotsizefrom = $jinput->get('lotsizefrom2') ? $jinput->get('lotsizefrom2') : ($jinput->get('lotsizefrom') ? $jinput->get('lotsizefrom'): 0) ;
    $lotsizeto = $jinput->get('lotsizeto2') ? $jinput->get('lotsizeto2') : ($jinput->get('lotsizeto') ? $jinput->get('lotsizeto'): $max_lot_size) ;

    $housesizefrom = $jinput->get('housesizefrom2') ? $jinput->get('housesizefrom2') : ($jinput->get('housesizefrom') ? $jinput->get('housesizefrom'): 0) ;
    $housesizeto = $jinput->get('housesizeto2') ? $jinput->get('housesizeto2') : ($jinput->get('housesizeto') ? $jinput->get('housesizeto'): $max_house_size) ;

    $search_date_from = $jinput->get('search_date_from') ? $jinput->get('search_date_from') : "" ;
    $search_date_until = $jinput->get('search_date_until') ? $jinput->get('search_date_until') : "" ;

}



?>
<?php positions_rem($params->get('showsearch01')); ?>
<?php positions_rem($params->get('showsearch02')); ?>

<script type="text/javascript">

    function showDate(){
        if(document.adminForm.search_date_box.checked){
            var x=document.getElementById("search_date_from");
            document.adminForm.search_date_from.type="text";
            var x=document.getElementById("search_date_until");
            document.adminForm.search_date_until.type="text";
        } else{
            var x=document.getElementById("search_date_from");
            document.adminForm.search_date_from.type="hidden";
            var x=document.getElementById("search_date_until");
            document.adminForm.search_date_until.type="hidden";}
        }
    </script>
    <script language="javascript" type="text/javascript">
        jQuerOs(document).ready(function() {
          jQuerOs( "#search_date_from, #search_date_until" ).datepicker(
          {
              minDate: "+0",
              dateFormat: "<?php echo transforDateFromPhpToJquery_rm();?>"

          });
          jQuerOs('.ui-datepicker').addClass('notranslate'); //fix error with Google ajax(instance) translate
      });
  </script>

  <?php if($realestatemanager_configuration['search_form_price_field_show']==1){ ?>
  <script type="text/javascript">
     jQuerOs(function() {
        jQuerOs(".show_search_house #rem_slider").slider({
            min: 0,
            max: <?php echo $max_price; ?>,
            values: [<?php echo $pricefrom; ?>,<?php echo $priceto; ?>],
            range: true,
            stop: function(event, ui) {
                jQuerOs(".show_search_house input#pricefrom").val(jQuerOs(".show_search_house #rem_slider").slider("values",0));
                jQuerOs(".show_search_house input#priceto").val(jQuerOs(".show_search_house #rem_slider").slider("values",1));
            },
            slide: function(event, ui){
                jQuerOs(".show_search_house input#pricefrom").val(jQuerOs(".show_search_house #rem_slider").slider("values",0));
                jQuerOs(".show_search_house input#priceto").val(jQuerOs(".show_search_house #rem_slider").slider("values",1));
            }
        });

        jQuerOs(".show_search_house input#pricefrom").change(function(){
            var value1=jQuerOs(".show_search_house input#pricefrom").val();
            var value2=jQuerOs(".show_search_house input#priceto").val();

            if(parseInt(value1) > parseInt(value2)){
                value1 = value2;
                jQuerOs(".show_search_house input#pricefrom").val(value1);
            }
            jQuerOs(".show_search_house #rem_slider").slider("values",0,value1);
        });

        jQuerOs(".show_search_house input#priceto").change(function(){
            var value1=jQuerOs(".show_search_house input#pricefrom").val();
            var value2=jQuerOs(".show_search_house input#priceto").val();

            if(parseInt(value1) > parseInt(value2)){
                value2 = value1;
                jQuerOs(".show_search_house input#priceto").val(value2);
            }
            if(value2 > <?php echo $max_price; ?>){
                jQuerOs(".show_search_house input#priceto").val(<?php echo $max_price; ?>)
            }
            jQuerOs(".show_search_house #rem_slider").slider("values",1,value2);
        });
    });
</script>
<?php } ?>

<!--****************************add slider lot size*********************************-->
<script type="text/javascript">
 jQuerOs(function() {
    jQuerOs(".show_search_house #lot_size_slider").slider({
        min: 0,
        max: <?php echo $max_lot_size; ?>,
        values: [<?php echo $lotsizefrom; ?>,<?php echo $lotsizeto; ?>],
        range: true,
        stop: function(event, ui) {
            jQuerOs(".show_search_house input#lotsizefrom").val(jQuerOs(".show_search_house #lot_size_slider").slider("values",0));
            jQuerOs(".show_search_house input#lotsizeto").val(jQuerOs(".show_search_house #lot_size_slider").slider("values",1));
        },
        slide: function(event, ui){
            jQuerOs(".show_search_house input#lotsizefrom").val(jQuerOs(".show_search_house #lot_size_slider").slider("values",0));
            jQuerOs(".show_search_house input#lotsizeto").val(jQuerOs(".show_search_house #lot_size_slider").slider("values",1));
        }
    });

    jQuerOs(".show_search_house input#lotsizefrom").change(function(){
        var value1=jQuerOs(".show_search_house input#lotsizefrom").val();
        var value2=jQuerOs(".show_search_house input#lotsizeto").val();

        if(parseInt(value1) > parseInt(value2)){
            value1 = value2;
            jQuerOs(".show_search_house input#lotsizefrom").val(value1);
        }
        jQuerOs(".show_search_house #lot_size_slider").slider("values",0,value1);
    });

    jQuerOs(".show_search_house input#lotsizeto").change(function(){
        var value1=jQuerOs(".show_search_house input#lotsizefrom").val();
        var value2=jQuerOs(".show_search_house input#lotsizeto").val();

        if(parseInt(value1) > parseInt(value2)){
            value2 = value1;
            jQuerOs(".show_search_house input#lotsizeto").val(value2);
        }
        if(value2 > <?php echo $max_lot_size; ?>){
            jQuerOs(".show_search_house input#lotsizeto").val(<?php echo $max_lot_size; ?>)
        }
        jQuerOs(".show_search_house #lot_size_slider").slider("values",1,value2);
    });
});
</script>
<!--****************************add slider lot size*********************************-->

<!--****************************add slider house size*********************************-->
<script type="text/javascript">
 jQuerOs(function() {
    jQuerOs(".show_search_house #house_size_slider").slider({
        min: 0,
        max: <?php echo $max_house_size; ?>,
        values: [<?php echo $housesizefrom; ?>,<?php echo $housesizeto; ?>],
        range: true,
        stop: function(event, ui) {
            jQuerOs(".show_search_house input#housesizefrom").val(jQuerOs(".show_search_house #house_size_slider").slider("values",0));
            jQuerOs(".show_search_house input#housesizeto").val(jQuerOs(".show_search_house #house_size_slider").slider("values",1));
        },
        slide: function(event, ui){
            jQuerOs(".show_search_house input#housesizefrom").val(jQuerOs(".show_search_house #house_size_slider").slider("values",0));
            jQuerOs(".show_search_house input#housesizeto").val(jQuerOs(".show_search_house #house_size_slider").slider("values",1));
        }
    });

    jQuerOs(".show_search_house input#sizefrom").change(function(){
        var value1=jQuerOs(".show_search_house input#housesizefrom").val();
        var value2=jQuerOs(".show_search_house input#housesizeto").val();

        if(parseInt(value1) > parseInt(value2)){
            value1 = value2;
            jQuerOs(".show_search_house input#housesizefrom").val(value1);
        }
        jQuerOs(".show_search_house #house_size_slider").slider("values",0,value1);
    });

    jQuerOs(".show_search_house input#lotsizeto").change(function(){
        var value1=jQuerOs(".show_search_house input#housesizefrom").val();
        var value2=jQuerOs(".show_search_house input#housesizeto").val();

        if(parseInt(value1) > parseInt(value2)){
            value2 = value1;
            jQuerOs(".show_search_house input#housesizeto").val(value2);
        }
        if(value2 > <?php echo $max_house_size; ?>){
            jQuerOs(".show_search_house input#housesizeto").val(<?php echo $max_house_size; ?>)
        }
        jQuerOs(".show_search_house #house_size_slider").slider("values",1,value2);
    });
});
</script>
<!--****************************add slider house size*********************************-->

<?php
$path = "index.php?option=" . $option . "&amp;task=search_houses&amp;Itemid=" . $Itemid;

$view = protectInjectionWithoutQuote('view', '');
if(protectInjectionWithoutQuote('typeLayout', '')) $view = protectInjectionWithoutQuote('typeLayout', '');

if($view == "") $view = "alone_category";
//if($layout == "") $layout = "default";

positions_rem($params->get('showsearch03')); 

?>

<form action="<?php echo sefRelToAbs($path);?>" method="get" name="rem_houses_search_advance">
    <input type="hidden" name="typeLayout" value="<?php echo $view; ?>" />
    <!--input type="hidden" name="searchLayout" value="<?php //echo $layout; ?>" /-->
    <input type="hidden" name="option" value="<?php echo $option; ?>" />
    <input type="hidden" name="Itemid" value="<?php echo $Itemid; ?>" />
    <input type="hidden" name="task" value="search" />

    <div class="show_search_house advanced">
        <div class="container_box_1">
            <div class="REL-row">

                <?php if ($realestatemanager_configuration['search_form_search_keyword_field_show']==1 || $realestatemanager_configuration['search_form_category_field_show'] == 1) {

                $searchtext = protectInjectionWithoutQuote('searchtext', '');

                ?>

                <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
                    <?php if($realestatemanager_configuration['search_form_search_keyword_field_show']==1) { ?>
                    <div class="rem_searchtext_input">
                        <input class="inputbox" type="text" name="searchtext" size="40" maxlength="40"
                        id="rem_adv_search_autocomplete" placeholder="<?php echo _REALESTATE_MANAGER_LABEL_SEARCH_KEYWORD; ?>"
                        value="<?php echo $searchtext; ?>" />
                    </div>
                    <?php }else{ ?>
                    <div>
                        <input type="hidden" name="searchtext" value="">
                    </div>
                    <?php } ?>

                <?php
                $jinput = JFactory::getApplication()->input;
                if( $realestatemanager_configuration['search_form_radiuse_range_field_show'] == 1 ) {

                    $search_range = $realestatemanager_configuration['search_form_radiuse_range'] ;
                    if ($search_range == 0 )
                      $search_range = $jinput->get('h_range') ? $jinput->get('h_range') : _REALESTATE_MANAGER_LABEL_MOD_MAP_SEARCH_RANGE;
                    else 
                      $search_range = $jinput->get('h_range') ? $jinput->get('h_range') : $search_range;

                    $h_range = array();
                    $h_range[] = mosHtml::makeOption(0, _REALESTATE_MANAGER_LABEL_MOD_MAP_SEARCH_RANGE);

                    $h_ranges = explode(',', _REALESTATE_MANAGER_OPTION_SEARCH_RADIUS_RANGE_LISTING);
                    foreach ( $h_ranges as $range ) {
                        $h_range[] = mosHtml::makeOption($range, $range);
                    }

                    $lists['search_form_radiuse_range'] = mosHTML::selectList($h_range, 'h_range',
                      'class="inputbox" size="1"', 'value', 'text', $search_range);
                    ?>

                    <div class="rem_searchtext_input">
                        <div REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8>
                        <?php echo $lists['search_form_radiuse_range']; ?>
                        </div>
                    </div>

                    <?php
                } elseif ( $realestatemanager_configuration['search_form_radiuse_range_field_show'] == 2 ) {
                    $search_range = $realestatemanager_configuration['search_form_radiuse_range'];
                    ?>
                    <div>
                        <input type="hidden" name="h_range" value="<?php echo $search_range; ?>">
                    </div>
                    <?php
                }

                    $h_lat = protectInjectionWithoutQuote('h_lat', '');
                    $h_lon = protectInjectionWithoutQuote('h_lon', '');

                ?>

                <input type="hidden" name="h_lat" value="<?php echo $h_lat; ?>">
                <input type="hidden" name="h_lon" value="<?php echo $h_lon; ?>">

                <?php if ($realestatemanager_configuration['search_form_category_field_show'] == 1) { ?>
                <div class="container_box_2 REL-row">
                    <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label"><?php echo _REALESTATE_MANAGER_LABEL_CATEGORY; ?>
                    </div>
                    <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8">
                        <?php echo $clist; ?>
                    </div>
                </div>
                <?php
                } ?>

                </div>
                <?php } ?>



<?php 
if( $realestatemanager_configuration['search_form_radiuse_range_field_show'] == 1 ) {
?>    

<script type="text/javascript">

    // Turn off Mootools because it crushed StreetView GoogleMap and gange on jQuer
    // window.addEvent('domready', function() {
    jQuerOs(document).ready(function() {

    <?php
    if($realestatemanager_configuration['google_openmap']['show'] == '1'){
      //GeoCodingBy Google

        if ( isset($realestatemanager_configuration['api_key']) && $realestatemanager_configuration['api_key'] ) {
            $api_key = "key=" . $realestatemanager_configuration['api_key'];
        } else {
          $api_key = JFactory::getApplication()->enqueueMessage("<a target='_blank' href='//developers.google.com/maps/documentation/geocoding/get-api-key'>" . _REALESTATE_MANAGER_GOOGLEMAP_API_KEY_LINK_MESSAGE . "</a>", _REALESTATE_MANAGER_AUTOCOMPLETE_GOOGLEMAP_API_KEY_ERROR);
        }
        $doc = JFactory::getDocument();
        if ( checkJavaScriptIncludedRE("maps.googleapis.com") === false ) {
            $doc->addScript("//maps.googleapis.com/maps/api/js?$api_key&libraries=places");
        }
    ?>


        var rem_adv_search_autocomplete;
        function initRemSearchAdvAutocomplete() {

            rem_adv_search_autocomplete = new google.maps.places.Autocomplete(
                /** @type {!HTMLInputElement} */(document.getElementById('rem_adv_search_autocomplete')),
                {types: ['geocode']});
            google.maps.event.addListener(rem_adv_search_autocomplete, 'place_changed', function () {
                var place = rem_adv_search_autocomplete.getPlace();
//                document.getElementById('city2').value = place.name;
//               console.log("55555555555 ",place.geometry.location.lat()+": :"+ place.geometry.location.lng() );
                document.rem_houses_search_advance.h_lat.value = place.geometry.location.lat();
                document.rem_houses_search_advance.h_lon.value = place.geometry.location.lng();
            });            
        }
        initRemSearchAdvAutocomplete();

    <?php
    } else {
      //GeoCodingBy OpenMap
        ?>
        var os_om_result_lat = Array();
        var os_om_result_long = Array();
        var os_om_result_address = Array();

        jQuerOs( "#rem_adv_search_autocomplete" ).autocomplete({

          minLength: 3,
          close: function( event, ui ) {
            address = jQuerOs( "#rem_adv_search_autocomplete" ).val() ;


//            if (os_om_result_lat.length > 0 && os_om_result_long.length > 0) {
            if (typeof( os_om_result_lat[address] ) !== "undefined"
                && typeof( os_om_result_long[address] ) !== "undefined"  ) {
//                console.log("55555555555 close 1",os_om_result_lat[address]+": :"+os_om_result_long[address]);
              document.rem_houses_search_advance.h_lat.value = os_om_result_lat[address];
              document.rem_houses_search_advance.h_lon.value = os_om_result_long[address];
            }

          },

          source: function( request, response ) {
                geo_url = 'https://nominatim.openstreetmap.org/search?format=json&limit=5&q='+encodeURI(request.term);
                //http://photon.komoot.de/api/?q=vjs&limit=5

                // use jQuerOs to call the API and get the JSON resultsos_om_result_address
                jQuerOs.getJSON(geo_url, function(data) {
                  // the full results JSON
                  //console.log(data);

                  os_om_result_lat = Array();
                  os_om_result_long = Array();
                  os_om_result_address = Array();

                  document.rem_houses_search_advance.h_lat.value = "";
                  document.rem_houses_search_advance.h_lon.value = ""

                  if(data.length > 0 ){

                    for (i = 0; i < data.length; i++) {
                      os_om_result_lat[data[i].display_name] = data[i].lat ;
                      os_om_result_long[data[i].display_name] = data[i].lon ;
                      os_om_result_address.push(data[i].display_name) ;

                    }
                    response( os_om_result_address );

                  } else {
                    console.log("Please check the accuracy of Address");
                    response( os_om_result_address );
                  }
            });
              }
        });
        // console.log('88888888888888888888888888888888');
        // console.log(os_om_result_address);

            <?php
        }
            ?>


    }); //domready close
</script>
<?php 
}//if( $realestatemanager_configuration['search_form_radiuse_range_field_show'] == 1 ) 
?>   

                <!--end REL-collumn-xs-4 REL-collumn-sm-4 REL-collumn-md-4 REL-collumn-lg-4-->

                <?php if($realestatemanager_configuration['search_form_check_in_field_show']==1 || $realestatemanager_configuration['search_form_check_out_field_show']==1) {
                 ?>

                <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
                    <div class="col_box_1">
                        <?php if($realestatemanager_configuration['search_form_check_in_field_show']==1) { ?>
                        <div class="box_from REL-row">
                            <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                <?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_FROM; ?>
                            </div>
                            <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8">
                                <input type="text" id="search_date_from" name="search_date_from"  value="<?php echo $search_date_from; ?>">
                            </div>
                        </div>
                        <?php } else { ?>
                        <div>
                            <input type="hidden" id="search_date_from" name="search_date_from"  value="<?php echo $search_date_from; ?>" >
                        </div>
                        <?php } ?>

                        <?php if ($realestatemanager_configuration['search_form_check_out_field_show']==1) { ?>
                        <div  class="box_until REL-row">
                            <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                <?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_UNTIL; ?>
                            </div>
                            <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8">
                                <input type="text" id="search_date_until" name="search_date_until"  value="<?php echo $search_date_until; ?>">
                            </div>
                        </div>
                        <?php } else{ ?>
                        <div>
                            <input type="hidden" id="search_date_until" name="search_date_until"  value="<?php echo $search_date_until; ?>" >
                        </div>
                        <?php } ?>
                    </div><!--col_box_1-->
                </div><!--end REL-collumn-xs-4 REL-collumn-sm-4 REL-collumn-md-4 REL-collumn-lg-4-->

                <?php } ?>


            </div>
        </div>

        <div class="container_box_2 container_box_3">
            <div class="REL-row">

                <?php if ($realestatemanager_configuration['search_form_price_field_show']==1) { ?>
                <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
                    <div class="col_box_1">
                        <span class="price_label"><?php echo _REALESTATE_MANAGER_LABEL_PRICE; ?></span>
                        <div id="rem_slider" class="ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all"></div>
                        <div class="REL-row">
                            <div class="pricefrom_2 REL-collumn-xs-6 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-6 container_search_slider_input">
                                <div class="REL-row">
                                    <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                        <?php echo _REALESTATE_MANAGER_LABEL_FROM; ?>
                                    </div>
                                    <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8">
                                        <input type="text" id="pricefrom" name="pricefrom2" value="<?php echo $pricefrom; ?>"/>
                                    </div>
                                </div>
                            </div>
                            <div class="priceto_2 REL-collumn-xs-6 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-6 container_search_slider_input">
                                <div class="REL-row">
                                    <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                        <?php echo _REALESTATE_MANAGER_LABEL_TO; ?>
                                    </div>
                                    <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8">
                                        <input type="text" id="priceto" name="priceto2" value="<?php echo $priceto; ?>"/>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <div style="clear: both;"></div>
                    </div><!--end div col_box_1-->
                </div><!--end div REL-collumn-xs-4 REL-collumn-sm-4 REL-collumn-md-4 REL-collumn-lg-4-->
                <?php } ?>


                <!--****************************add slider lot size*********************************-->
                <?php if($realestatemanager_configuration['search_lot_size_field_show']==1) { ?>
                <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
                    <div class="col_box_1">
                        <span class="price_label"><?php echo _REALESTATE_MANAGER_LABEL_LOT_SIZE; ?></span>
                        <div id="lot_size_slider" class="ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all"></div>

                        <div class="REL-row">

                            <div class="lotsizefrom_2 REL-collumn-xs-6 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-6 container_search_slider_input">
                                <div class="REL-row">
                                    <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                    <?php echo _REALESTATE_MANAGER_LABEL_FROM; ?>
                                    </div>
                                    <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8">
                                    <input type="text" id="lotsizefrom" name="lotsizefrom2" value="<?php echo $lotsizefrom; ?>"/>
                                   </div>
                                </div>
                            </div>

                            <div class="lotsizeto_2 REL-collumn-xs-6 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-6 container_search_slider_input">
                               <div class="REL-row">
                                    <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                        <?php echo _REALESTATE_MANAGER_LABEL_TO; ?>
                                    </div>
                                   <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8">
                                       <input type="text" id="lotsizeto" name="lotsizeto2" value="<?php echo $lotsizeto; ?>"/>
                                   </div>
                               </div>
                            </div>
                        </div>

                        <div style="clear: both;"></div>
                    </div>
                </div>
                <?php } ?>
                <!--****************************end add slider lot size*********************************-->
                <!--****************************slider house size***************************************-->
                <?php if($realestatemanager_configuration['search_house_size_field_show']==1) { ?>
                <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
                    <div class="col_box_1">
                        <span class="price_label"><?php echo _REALESTATE_MANAGER_LABEL_HOUSE_SIZE; ?></span>
                        <div id="house_size_slider" class="ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all"></div>

                        <div class="REL-row">

                            <div class="housesizefrom_2 REL-collumn-xs-6 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-6 container_search_slider_input">
                               <div class="REL-row">
                                    <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                       <?php echo _REALESTATE_MANAGER_LABEL_FROM; ?>
                                   </div>

                                   <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8">
                                       <input type="text" id="housesizefrom" name="housesizefrom2" value="<?php echo $housesizefrom; ?>"/>
                                   </div>
                               </div>

                            </div>

                            <div class="housesizeto_2 REL-collumn-xs-6 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-6 container_search_slider_input">
                               <div class="REL-row">
                                    <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                        <?php echo _REALESTATE_MANAGER_LABEL_TO; ?>
                                    </div>

                                    <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8">
                                        <input type="text" id="housesizeto" name="housesizeto2" value="<?php echo $housesizeto; ?>"/>
                                    </div>
                               </div>
                            </div>
                        </div>

                        <div style="clear: both;"></div>
                    </div><!--end div class="col_box_1"-->
                </div><!--end div class="REL-collumn-xs-4 REL-collumn-sm-4 REL-collumn-md-4 REL-collumn-lg-4"-->
                <?php } ?>
        <!--****************************end add slider house size*********************************-->
            </div><!--end div class="REL-row"-->
        </div>

        <div class="REL-row">
                        <?php if($realestatemanager_configuration['search_form_listing_type_field_show']==1) {?>
                        <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
                            <div class="REL-row">
                               <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                    <?php echo _REALESTATE_MANAGER_LABEL_LISTING_TYPE; ?>
                               </div>
                                <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8"><?php echo $params->get('listing_type_list'); ?></div>
                            </div>
                        </div>
                        <?php } else { ?>
                        <div>
                            <input type='hidden' id='listing_type' name='listing_type' value='<?php echo _REALESTATE_MANAGER_LABEL_ALL ?>'/>
                        </div>
                        <?php } ?>

                        <?php if($realestatemanager_configuration['search_form_listing_status_field_show']==1) { ?>
                        <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
                            <div class="REL-row">
                                <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                <?php echo _REALESTATE_MANAGER_LABEL_LISTING_STATUS; ?>
                                </div>

                                   <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8"> <?php echo $params->get('listing_status_list'); ?></div>

                            </div>
                        </div><!--REL-collumn-xs-4 REL-collumn-sm-4 REL-collumn-md-4 REL-collumn-lg-4-->
                        <?php } else { ?>
                        <div>
                            <input type='hidden' id='listing_status' name='listing_status' value='<?php echo _REALESTATE_MANAGER_LABEL_ALL ?>'/>
                        </div>
                        <?php } ?>

                        <?php if($realestatemanager_configuration['search_form_property_type_field_show']==1) { ?>
                        <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
                            <div class="REL-row">
                                <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                   <?php echo _REALESTATE_MANAGER_LABEL_PROPERTY_TYPE; ?>
                                </div>
                                <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8"><?php echo $params->get('property_type_list'); ?></div>
                            </div>
                        </div>
                        <?php } else { ?>
                            <div>
                                <input type='hidden' id='property_type' name='property_type' value='<?php echo _REALESTATE_MANAGER_LABEL_ALL ?>'/>
                            </div>
                        <?php } ?>

                        <!-- add rooms numbers field -->
                        <?php if($realestatemanager_configuration['search_rooms_num_field_show']==1) { ?>
                            <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
                                <div class="REL-row">
                                    <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                       <?php echo _REALESTATE_MANAGER_LABEL_ROOMS; ?>
                                    </div>
                                   <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8"> <?php echo $params->get('rooms_num'); ?></div>
                                </div>
                            </div>
                        <?php } ?>
                        <!-- end add rooms numbers field -->
                        <!-- add bathrooms numbers field -->
                        <?php if($realestatemanager_configuration['search_bathrooms_num_field_show']==1) { ?>
                        <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
                            <div class="REL-row">
                               <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                   <?php echo _REALESTATE_MANAGER_LABEL_BATHROOMS; ?>
                               </div>
                                <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8"><?php echo $params->get('bathrooms_num'); ?></div>
                            </div>
                        </div>
                        <?php } ?>
                        <!-- end add bathrooms numbers field -->
                        <!-- add bedrooms numbers field -->
                        <?php if($realestatemanager_configuration['search_bedrooms_num_field_show']==1) { ?>
                        <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
                            <div class="REL-row">
                               <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                   <?php echo _REALESTATE_MANAGER_LABEL_BEDROOMS; ?>
                               </div>
                                <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8"><?php echo $params->get('bedrooms_num'); ?></div>
                            </div>
                        </div>
                        <?php } ?>
                        <!-- end add bedrooms numbers field -->
                        
                        
                        <!-- add garages numbers field -->
                        <?php if($realestatemanager_configuration['search_form_garages_field_show']==1) { ?>
                        <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
                            <div class="REL-row">
                               <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                   <?php echo _REALESTATE_MANAGER_LABEL_GARAGES; ?>
                               </div>
                                <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8"><?php echo $params->get('garages_num'); ?></div>
                            </div>
                        </div>
                        <?php } ?>
                        
                        <!-- <?php if($realestatemanager_configuration['search_form_garages_field_show']==1) { ?>
                         <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
                        <div class="col_box_3">
                            <label>
                                <span><?php echo _REALESTATE_MANAGER_LABEL_GARAGES; ?></span>
                                <?php if ($task == 'search') { ?>
                                <input type="checkbox" name="Garages" id="Garages" <?php echo $checkbox["Garages"] ?>/>
                                <?php } else { ?>
                                <input type="checkbox" name="Garages" id="Garages" checked="checked" />
                                <?php } ?>
                            </label>
                        </div>
                        </div>
                        <?php } elseif($realestatemanager_configuration['search_form_garages_field_show']==2){ ?>
                        <div>
                            <input type="hidden" name="Garages" id="Garages" value="on" />
                        </div>
                        <?php } else{ ?>
                        <div>
                            <input type="hidden" name="Garages" id="Garages" value="" />
                        </div>
                        <?php } ?> -->
                        <!-- end add garages numbers field -->

                        <!-- add build years numbers field -->
                        <?php if($realestatemanager_configuration['search_form_build_year_field_show']==1) { ?>
                        <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
                            <div class="REL-row">
                               <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                   <?php echo _REALESTATE_MANAGER_LABEL_BUILD_YEAR; ?>
                               </div>
                                <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8"><?php echo $params->get('year'); ?></div>
                            </div>
                        </div>
                        <?php } ?>
                        
                        <!-- <?php if($realestatemanager_configuration['search_form_build_year_field_show']==1) { ?>
                        <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
                            <div class="col_box_3">
                                <label>
                                    <span><?php echo _REALESTATE_MANAGER_LABEL_BUILD_YEAR; ?></span>
                                    <?php if ($task == 'search') { ?>
                                    <input type="checkbox" name="year" id="year" <?php echo $checkbox["year"] ?>/>
                                    <?php } else { ?>
                                    <input type="checkbox" name="year" id="year" checked="checked" />
                                    <?php } ?>
                                </label>
                            </div>
                        </div>
                        <?php } elseif($realestatemanager_configuration['search_form_build_year_field_show']==2){ ?>
                        <div>
                            <input type="hidden" name="year" id="year" value="on" />
                        </div>
                        <?php } else{ ?>
                        <div>
                            <input type="hidden" name="year" id="year" value="" />
                        </div>
                        <?php } ?> -->
                        <!-- end add build years numbers field -->
          

            <!-- ******************* Country / Region / City block START: ******************* -->

                        <?php
            if($realestatemanager_configuration['show_country_region_city_as_text_field'] == 0){
                if($realestatemanager_configuration['search_form_country_field_show'] == 1) { ?>

                        <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
                            <div class="REL-row">
                               <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                                   <?php echo _REALESTATE_MANAGER_LABEL_COUNTRY; ?>
                               </div>
                                <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8">
                                <?php echo $params->get('country'); ?>
                                </div>
                            </div>
                        </div>

            <?php
            } elseif ($realestatemanager_configuration['search_form_country_field_show'] == '2') {
                echo $params->get('country');
            } ?>

                        <script type="text/javascript">
                            <?php
                            $countrys = $temp1[0];
                            $regions  = $temp1[1];
                            $regs     = $temp2[0];
                            $citys    = $temp2[1];

                            echo 'var countrysregions = [];';

                            for($c=0; $c<count($countrys); $c++){
                                $countrys[$c]='\''.$countrys[$c].'\'';
                                foreach($regions[$c] as $temp=>$region)
                                  $regions[$c][$temp]='\''.$region.'\'';
                              echo 'var temp=new Array("'._REALESTATE_MANAGER_LABEL_ALL.'",'.implode(',',$regions[$c]).");\n";
                              echo 'countrysregions['.$c."]=temp;\n";
                          }
                          echo 'var countrys=new Array('.implode(',',$countrys).');';

                          echo 'var regionscitys = [];';

                          for($c=0; $c<count($regs); $c++){
                            $regs[$c]='\''.$regs[$c].'\'';
                            foreach($citys[$c] as $temp=>$city)
                              $citys[$c][$temp]='\''.$city.'\'';
                          echo 'var temp=new Array("'._REALESTATE_MANAGER_LABEL_ALL.'",'.implode(',',$citys[$c]).");\n";
                          echo 'regionscitys['.$c."]=temp;\n";
                      }
                      echo 'var regs=new Array('.implode(',',$regs).');';
                      ?>
        // region?
                      function rem_changedCountry_com(country){
                        var id = rem_in_array_select_com(country.value,countrys);
                        var region = document.getElementsByName('hregion')[0];

                        if(typeof(region) == 'undefined'){
                          return;
                      }

                      rem_clearSelectList_com('hregion');
                      rem_clearSelectList_com('hcity');
                      rem_setAllselect_com('hcity');

                      if(country.value=='<?php echo _REALESTATE_MANAGER_LABEL_ALL;?>'){
                          rem_setAllselect_com('hregion');
                          return;
                      }

                      for(var c=0;c<countrysregions[id].length;c++){
                        rem_createOptionList_com('hregion', countrysregions[id][c],countrysregions[id][c]);
                    }
                }
      //end region
      //citys
      function rem_changedRegion_com(region){
        var id = rem_in_array_select_com(region.value,regs);
        var city = document.getElementsByName('hcity')[0];

        if(typeof(city) == 'undefined'){
          return;
      }

      rem_clearSelectList_com('hcity');

      if(region.value=='<?php echo _REALESTATE_MANAGER_LABEL_ALL;?>'){
          rem_setAllselect_com('hcity');
          return;
      }

      for(var c=0;c<regionscitys[id].length;c++){
        rem_createOptionList_com('hcity', regionscitys[id][c],regionscitys[id][c]);
    }
}
      //end city

      function rem_clearSelectList_com(elementName){
        var objSelect=document.getElementsByName(elementName)[0];
        while(objSelect.options.length > 0){objSelect.remove(0);}
        return objSelect;
    }

    function rem_in_array_select_com(what, where) {
        for(var i=0; i<where.length; i++)
          if(what == where[i])
            return i;
        return false;
    }

    function rem_createOptionList_com(elementName, newValue,newText){
        var objSelect = document.getElementsByName(elementName)[0];
        var objOption = document.createElement("option");
        objOption.text = newText
        objOption.value = newValue
        if(document.all && !window.opera){
          objSelect.add(objOption);
      }else{
          objSelect.add(objOption, null);
      };
  }

  function rem_setAllselect_com(elementName){
    rem_createOptionList_com(elementName, '<?php echo _REALESTATE_MANAGER_LABEL_ALL;?>','<?php echo _REALESTATE_MANAGER_LABEL_ALL;?>');
}
</script>

<?php
        if($realestatemanager_configuration['search_form_region_field_show'] == 1) { ?>
<div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
    <div class="REL-row">
        <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
           <?php echo _REALESTATE_MANAGER_LABEL_REGION; ?>
        </div>
       <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8">
        <?php echo $params->get('region'); ?></div>
    </div>
</div>
<?php
        } else if($realestatemanager_configuration['search_form_region_field_show'] == 2) {
            echo $params->get('region');
        } ?>

        <?php if ($realestatemanager_configuration['search_form_city_field_show'] == 1) { ?>

<div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
    <div class="REL-row">
       <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
           <?php echo _REALESTATE_MANAGER_LABEL_CITY; ?>
       </div>
        <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8">
        <?php echo $params->get('city'); ?></div>
    </div>
</div>
<?php
        } elseif ($realestatemanager_configuration['search_form_city_field_show'] == 2) {
            echo $params->get('city');
        } ?>
<!-- end city -->
<?php
}
?>
        <!-- ******************* Country / Region / City block END. ******************* -->




          <!--add extra fields-->
          <?php

        for($i = 6; $i <=10; $i++){
            if($realestatemanager_configuration['extra'.$i] == 1 && $realestatemanager_configuration['extra' . $i . '_advanced'] == 1){ ?>
            <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-6 REL-collumn-lg-4">
                <div class="REL-row">
                    <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 search-label">
                        <span><?php  echo constant( '_REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA' .$i . '_SHOW'); ?></span>
                    </div>
                    <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8">
                <?php echo $params->get('extrafield'.$i); ?></div>
                </div><!-- col_box_2 -->
            </div><!-- end REL-collumn-xs-4 REL-collumn-sm-4 REL-collumn-md-4 REL-collumn-lg-4 -->
        <?php
          }
        }
        ?>
        <!--end extra fields-->

        </div><!--REL-row-->

      <div class="REL-row search_checkbox">


                        <?php if($realestatemanager_configuration['search_form_propertyid_field_show']==1) { ?>
                        <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
                        <div class="col_box_3">
                            <label>
                                <span><?php echo _REALESTATE_MANAGER_LABEL_PROPERTYID; ?></span>
                                <?php if ($task == 'search') { ?>
                                <input type="checkbox" name="Houseid" id="Houseid" <?php echo $checkbox["Houseid"] ?>/>
                                <?php } else { ?>
                                <input type="checkbox" name="Houseid" id="Houseid" checked="checked"/>
                                <?php } ?>
                            </label>
                        </div>
                        </div>
                        <?php } elseif($realestatemanager_configuration['search_form_propertyid_field_show']==2) { ?>
                        <div>
                            <input type="hidden" name="Houseid" id="Houseid" value="on"/>
                        </div>
                        <?php } else{ ?>
                        <div>
                            <input type="hidden" name="Houseid" id="Houseid" value=""/>
                        </div>
                        <?php } ?>

                        <?php if($realestatemanager_configuration['search_form_comment_field_show']==1) { ?>
                         <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
                        <div class="col_box_3">
                            <label>
                                <span><?php echo _REALESTATE_MANAGER_LABEL_DESCRIPTION; ?></span>
                                <?php if ($task == 'search') { ?>
                                <input type="checkbox" name="Description" id="Description" <?php echo $checkbox["Description"] ?>/>
                                <?php } else { ?>
                                <input type="checkbox" name="Description" id="Description" checked = "checked"/>
                                <?php } ?>
                            </label>
                        </div>
                        </div>
                        <?php } elseif($realestatemanager_configuration['search_form_comment_field_show']==2) { ?>
                        <div>
                            <input type="hidden" name="Description" id="Description" value="on"/>
                        </div>
                        <?php } else{ ?>
                        <div>
                            <input type="hidden" name="Description" id="Description" value=""/>
                        </div>
                        <?php } ?>

                        <?php if($realestatemanager_configuration['search_form_title_field_show']==1) { ?>
                         <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
                        <div class="col_box_3">
                            <label>
                                <span><?php echo _REALESTATE_MANAGER_LABEL_TITLE; ?></span>
                                <?php if ($task == 'search') { ?>
                                <input type="checkbox" name="Title" id="Title" <?php echo $checkbox["Title"] ?>/>
                                <?php } else { ?>
                                <input type="checkbox" name="Title" id="Title" checked = "checked"/>
                                <?php } ?>
                            </label>
                        </div>
                        </div>
                        <?php } elseif($realestatemanager_configuration['search_form_title_field_show']==2) { ?>
                        <div>
                            <input type="hidden" name="Title" id="Title" value="on"/>
                        </div>
                        <?php } ?>

                        <?php if(($realestatemanager_configuration['show_country_region_city_as_text_field'] == 1) && $realestatemanager_configuration['search_form_country_field_show']==1) { ?>
                         <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
                        <div class="col_box_3">
                            <label>
                                <span><?php echo _REALESTATE_MANAGER_LABEL_COUNTRY; ?></span>
                                <?php if ($task == 'search') { ?>
                                <input type="checkbox" name="Country" id="Country" <?php echo $checkbox["Country"] ?>/>
                                <?php } else { ?>
                                <input type="checkbox" name="Country" id="Country" checked="checked" />
                                <?php } ?>
                            </label>
                        </div>
                        </div>
                        <?php } elseif($realestatemanager_configuration['search_form_country_field_show'] == 2){ ?>
                        <div>
                            <input type="hidden" name="Country" id="Country" value="on" />
                        </div>
                        <?php } ?>

                        <?php if($realestatemanager_configuration['search_form_address_field_show']==1) { ?>
                         <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
                        <div class="col_box_3">
                            <label>
                                <span><?php echo _REALESTATE_MANAGER_LABEL_ADDRESS; ?></span>
                                <?php if ($task == 'search') { ?>
                                <input type="checkbox" name="Address" id="Address" <?php echo $checkbox["Address"] ?>/>
                                <?php } else { ?>
                                <input type="checkbox" name="Address" id="Address" checked = "checked" />
                                <?php } ?>
                            </label>
                        </div>
                        </div>
                        <?php } elseif($realestatemanager_configuration['search_form_address_field_show']==2){ ?>
                        <div>
                            <input type="hidden" name="Address" id="Address" value="on" />
                        </div>
                        <?php } else{ ?>
                        <div>
                            <input type="hidden" name="Address" id="Address" value="" />
                        </div>
                        <?php } ?>

                        <?php
                        if(($realestatemanager_configuration['show_country_region_city_as_text_field'])==1) {
                            if($realestatemanager_configuration['search_form_region_field_show']==1) {?>
                             <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
                            <div class="col_box_3">
                                <label>
                                    <span><?php echo _REALESTATE_MANAGER_LABEL_REGION; ?></span>
                                    <?php if ($task == 'search') { ?>
                                    <input type="checkbox" name="Region" id="Region" <?php echo $checkbox["Region"] ?>/>
                                    <?php } else { ?>
                                    <input type="checkbox" name="Region" id="Region" checked="checked" />
                                    <?php } ?>
                                </label>
                            </div>
                            </div>
                            <?php } elseif($realestatemanager_configuration['search_form_region_field_show']==2){ ?>
                            <div>
                                <input type="hidden" name="Region" id="Region" value="on" />
                            </div>
                            <?php } else {?>
                            <div>
                                <input type="hidden" name="Region" id="Region" value="" />
                            </div>
                            <?php } ?>

                            <?php if($realestatemanager_configuration['search_form_city_field_show']==1) { ?>
                             <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
                            <div class="col_box_3">
                                <label>
                                    <span><?php echo _REALESTATE_MANAGER_LABEL_CITY; ?></span>
                                    <?php if ($task == 'search') { ?>
                                    <input type="checkbox" name="City" id="City" <?php echo $checkbox["City"] ?>/>
                                    <?php } else { ?>
                                    <input type="checkbox" name="City" id="City" checked="checked" />
                                    <?php } ?>
                                </label>
                            </div>
                            </div>
                            <?php } elseif($realestatemanager_configuration['search_form_city_field_show']==2){ ?>
                            <div>
                                <input type="hidden" name="City" id="City" value="on" />
                            </div>
                            <?php } else{ ?>
                            <div>
                                <input type="hidden" name="City" id="City" value="" />
                            </div>
                            <?php
                        }
        }//close if show_country_region_city_as_text_field
        ?>

        <?php if($realestatemanager_configuration['search_form_zipcode_field_show']==1) { ?>
         <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
        <div class="col_box_3">
            <label>
                <span><?php echo _REALESTATE_MANAGER_LABEL_ZIPCODE; ?></span>
                <?php if ($task == 'search') { ?>
                <input type="checkbox" name="Zipcode" id="Zipcode" <?php echo $checkbox["Zipcode"] ?>/>
                <?php } else { ?>
                <input type="checkbox" name="Zipcode" id="Zipcode" checked="checked" />
                <?php } ?>
            </label>
        </div>
        </div>
        <?php } elseif($realestatemanager_configuration['search_form_zipcode_field_show']==2){ ?>
        <div>
            <input type="hidden" name="Zipcode" id="Zipcode" value="on" />
        </div>
        <?php } else { ?>
        <div>
            <input type="hidden" name="Zipcode" id="Zipcode" value="" />
        </div>
        <?php } ?>

        <?php if($realestatemanager_configuration['search_form_owner_field_show']==1) { ?>
         <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
        <div class="col_box_3">
            <label>
                <span><?php echo _REALESTATE_MANAGER_SHOW_SEARCH_OWNER; ?></span>
                <?php if ($task == 'search') { ?>
                <input type="checkbox" name="ownername" id="ownername" <?php echo $checkbox["ownername"] ?>/>
                <?php } else { ?>
                <input type="checkbox" name="ownername" id="ownername" checked="checked" />
                <?php } ?>
            </label>
        </div>
        </div>
        <?php } elseif($realestatemanager_configuration['search_form_owner_field_show']==2) { ?>
        <div>
            <input type="hidden" name="ownername" id="ownername" value="on" />
        </div>
        <?php } else { ?>
        <div>
            <input type="hidden" name="ownername" id="ownername" value="" />
        </div>
        <?php } ?>

        <?php if($realestatemanager_configuration['search_form_contacts_field_show']==1) { ?>
         <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
        <div class="col_box_3">
            <label>
                <span><?php echo _REALESTATE_MANAGER_LABEL_CONTACTS; ?></span>
                <?php if ($task == 'search') { ?>
                <input type="checkbox" name="Contacts" id="Contacts" <?php echo $checkbox["Contacts"] ?>/>
                <?php } else { ?>
                <input type="checkbox" name="Contacts" id="Contacts" checked="checked" />
                <?php } ?>
            </label>
        </div>
        </div>
        <?php } elseif($realestatemanager_configuration['search_form_contacts_field_show']==2){ ?>
        <div>
            <input type="hidden" name="Contacts" id="Contacts" value="on" />
        </div>
        <?php } else{ ?>
        <div>
            <input type="hidden" name="Contacts" id="Contacts" value="" />
        </div>
        <?php } ?>

        <?php if($realestatemanager_configuration['search_form_agent_field_show']==1) { ?>
         <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
        <div class="col_box_3">
            <label>
                <span><?php echo _REALESTATE_MANAGER_LABEL_AGENT; ?></span>
                <?php if ($task == 'search') { ?>
                <input type="checkbox" name="Agent" id="Agent" <?php echo $checkbox["Agent"] ?>/>
                <?php } else { ?>
                <input type="checkbox" name="Agent" id="Agent" checked="checked" />
                <?php } ?>
            </label>
        </div>
        </div>
        <?php } elseif($realestatemanager_configuration['search_form_agent_field_show']==2){ ?>
        <div>
            <input type="hidden" name="Agent" id="Agent" value="on" />
        </div>
        <?php } else{ ?>
        <div>
            <input type="hidden" name="Agent" id="Agent" value="" />
        </div>
        <?php } ?>


        <?php
        for ($i = 1; $i <= 5; $i++) {
            if ($realestatemanager_configuration['extra' . $i] == '1' && $realestatemanager_configuration['extra' . $i . '_advanced'] == '1') { ?>
             <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
            <div class="col_box_3">
                <label>
                  <span><?php echo constant('_REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA' .$i . '_SHOW'); ?></span>
                    <input type="checkbox" name="extra<?php echo $i ?>" id="extra<?php echo $i ?>" checked="checked"/>
                </label>
            </div>
            </div>
        <?php
        } elseif($realestatemanager_configuration['extra' . $i . '_advanced'] == '2') { ?>
                <input type="hidden" name="extra<?php echo $i ?>" id="extra<?php echo $i ?>" value="on"/>
        <?php
            }
        }
        ?>

        <?php if($realestatemanager_configuration['search_form_exactly_to_all_field_show']==1) { ?>
         <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
        <div class="col_box_3">
            <label>
                <span><?php echo _REALESTATE_MANAGER_SHOW_SEARCH_EXACTLY; ?></span>
                <?php if ($task == 'search') { ?>
                <input type="checkbox" name="exactly" id="exactly" <?php echo $checkbox["exactly"] ?>/>
                <?php } else { ?>
                <input type="checkbox" name="exactly" id="exactly"/>
                <?php } ?>
            </label>
        </div>
        </div>
        <?php } elseif($realestatemanager_configuration['search_form_exactly_to_all_field_show']==2){ ?>
        <div>
            <input type="hidden" name="exactly" id="exactly" value="on" />
        </div>
        <?php } else{ ?>
        <div>
            <input type="hidden" name="exactly" id="exactly" value="" />
        </div>
        <?php } ?>



</div>

    <div class="REL-row search_checkbox">
        <?php
        // if($realestatemanager_configuration['manager_feature_category'] == 1) { ?>
        <div class="rem_house_amenities">

            <div class="row_add_house">
                <?php
                if (isset($house_feature) && count($house_feature)) {

                    for ($i = 0; $i < count($house_feature); $i++) {
                        if( $realestatemanager_configuration['search_form_features'][$house_feature[$i]->id] == 1) { ?>
                            <div class="rem_house_amenities"><h4>
                                <?php echo _REALESTATE_MANAGER_LABEL_AMENITIES; ?>
                            </h4></div>
                            <?php break;
                        }
                    }

                    for ($i = 0; $i < count($house_feature); $i++) {
                        /*Code below needs to add name of the features on the page
                        if ($i != 0) {
                            if ($house_feature[$i]->categories !== $house_feature[$i - 1]->categories)
                                echo "<div class='house_categories'>" .
                                 constant('_REALESTATE_MANAGER_FEATURE_CATEGORY_'.trim($house_feature[$i]->categories) ) . "</div>";
                        } else
                            echo "<div class='house_categories'>" .
                                constant('_REALESTATE_MANAGER_FEATURE_CATEGORY_'.trim($house_feature[$i]->categories) ) . "</div>";*/
                        ?>
                        <?php if($realestatemanager_configuration['search_form_features'][$house_feature[$i]->id]==1) { ?>
                         <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3">
                        <div class="col_box_3">
                            <label>
                                <span><?php echo constant( '_REALESTATE_MANAGER_FEATURE'.trim($house_feature[$i]->id) ); ?></span>
                                <?php if ($task == 'search') { ?>
                                    <input type="checkbox" name="f[]" id="<?php echo $house_feature[$i]->id; ?>" value="<?php echo $house_feature[$i]->id; ?>"
                                    <?php
                                    // mark features checked which was checked before pressing the button "Search"
                                    echo ( isset($checkbox['f'][ $house_feature[$i]->id ]) ? $check : '' ); ?>/>
                                    <?php if ($house_feature[$i]->image_link != '') {
                                    ?>
                                        <img alt="photo" src="<?php
                                        echo "{$mosConfig_live_site}components/com_realestatemanager/featured_ico/" .
                                        $house_feature[$i]->image_link; ?>" />
                                    <?php
                                    } ?>

                                <?php } else { ?>
                                    <input type="checkbox" name="f[]" id="<?php echo $house_feature[$i]->id; ?>" value="<?php echo $house_feature[$i]->id; ?>" />
                                <?php } ?>
                            </label>
                        </div>
                        </div>
                        <?php } elseif($realestatemanager_configuration['search_form_features'][$house_feature[$i]->id]==2){ ?>
                        <div>
                            <input type="hidden" name="f[]" id="<?php echo $house_feature[$i]->id; ?>" value="<?php echo $house_feature[$i]->id; ?>" />
                        </div>
                        <?php } else { ?>

                        <?php } ?>
                        <?php if ($house_feature[$i]->image_link != '') {
                        ?>
                        <img alt="photo" src="<?php
                          echo "{$mosConfig_live_site}components/com_realestatemanager/featured_ico/" .
                           $house_feature[$i]->image_link; ?>" />
                    <?php } ?>
                    <?php }
                } ?>
            </div>
        </div>
    <?php // }
      ?>
    </div>

    <div class="col_box_button">
        <div id="rem_house_titlebox">
        <input class="button" type="submit" name="submit"
        value="<?php echo _REALESTATE_MANAGER_LABEL_SEARCH_BUTTON; ?>" onclick = "// form_submit_rem_map_adv_search()" />
        </div>
        <?php
        // PHP_realestatemanager::showSearchHouses($option, $catid, $option, $layout);
        ?>
    </div>
</div>

<div style="clear: both;"></div>
</form>
<?php positions_rem($params->get('showsearch04')); ?>
</div> <!--class="componentbody -->