
/*!
  * Sa11y, the accessibility quality assurance assistant.
  * @version 3.1.3
  * @author Adam Chaboryk
  * @license GPL-2.0-or-later
  * @copyright © 2020 - 2024 Toronto Metropolitan University.
  * @contact adam.chaboryk@torontomu.ca
  * GitHub: git+https://github.com/ryersondmp/sa11y.git | Website: https://sa11y.netlify.app
  * For all acknowledgements, please visit: https://sa11y.netlify.app/acknowledgements/
  * The above copyright notice shall be included in all copies or substantial portions of the Software.
**/
/*! WARNING: This is a machine-generated translation and may contain errors or inaccuracies. */
var lt = {
  // Lithuanian
  strings: {
    LANG_CODE: 'lt',
    MAIN_TOGGLE_LABEL: 'Patikrinkite prieinamumą',
    CONTAINER_LABEL: 'Prieinamumo tikrintuvas',
    ERROR: 'Klaida',
    ERRORS: 'Klaidos',
    WARNING: 'Įspėjimas',
    WARNINGS: 'Įspėjimai',
    GOOD: 'Geras',
    ON: 'įjungta',
    OFF: 'Išjungta',
    ALERT_TEXT: 'Įspėjimas',
    ALERT_CLOSE: 'Uždaryti',
    OUTLINE: 'Puslapio metmenys',
    PAGE_ISSUES: 'Puslapio problemos',
    SETTINGS: 'Nustatymai',
    CONTRAST: 'Kontrastas',
    FORM_LABELS: 'Formos etiketės',
    LINKS_ADVANCED: 'Nuorodos (išplėstinis)',
    DARK_MODE: 'Tamsusis režimas',
    SHORTCUT_SCREEN_READER: 'Pereiti prie klausimo. Spartusis klavišo klavišas: Alt S',
    SHORTCUT_TOOLTIP: 'Pereiti prie klausimo',
    NEW_TAB: 'Atidaromas naujas skirtukas',
    PANEL_HEADING: 'Prieinamumo patikrinimas',
    PANEL_STATUS_NONE: 'Klaidų nerasta.',
    PANEL_ICON_WARNINGS: 'rasta įspėjimų.',
    PANEL_ICON_TOTAL: 'iš viso rasta problemų.',
    NOT_VISIBLE_ALERT: 'Elementas, kurį bandote peržiūrėti, nėra matomas; jis gali būti paslėptas arba būti akordeono ar skirtuko komponento viduje. Čia pateikiama peržiūra:',
    ERROR_MISSING_ROOT_TARGET: 'Buvo patikrintas viso puslapio prieinamumas, nes tikslinė sritis <code>%(root)</code> neegzistuoja.',
    HEADING_NOT_VISIBLE_ALERT: 'Antraštė nėra matoma; ji gali būti paslėpta arba akordeono ar skirtuko komponento viduje.',
    SKIP_TO_PAGE_ISSUES: 'Pereiti prie puslapio klausimų',
    CONSOLE_ERROR_MESSAGE: 'Atsiprašome, bet šiame puslapyje yra problema su prieinamumo tikrintuvu. Ar galite apie tai <a href="%(link)">pranešti per šią formą</a> arba <a href="%(link)">GitHub</a>?',

    // Dismiss
    PANEL_DISMISS_BUTTON: 'Rodyti %(dismissCount) atmestų įspėjimų',
    DISMISS: 'Atmesti',
    DISMISSED: 'Atmesti įspėjimai',
    DISMISS_REMINDER: 'Atkreipkite dėmesį, kad įspėjimai atmetami tik <strong>laikinai</strong>. Išvalius naršyklės istoriją ir slapukus, bus atkurti visi anksčiau atmesti įspėjimai visuose puslapiuose.',

    // Export
    DATE: 'Data',
    PAGE_TITLE: 'Puslapio pavadinimas',
    RESULTS: 'Rezultatai',
    EXPORT_RESULTS: 'Eksportuoti rezultatus',
    GENERATED: 'Rezultatai sugeneruoti su %(tool).',
    PREVIEW: 'Peržiūra',
    ELEMENT: 'Elementas',
    PATH: 'Kelias',

    // Colour filters
    COLOUR_FILTER: 'Spalvų filtras',
    PROTANOPIA: 'Protanopia',
    DEUTERANOPIA: 'Deuteranopija',
    TRITANOPIA: 'Tritanopia',
    MONOCHROMACY: 'Vienspalviai',
    COLOUR_FILTER_MESSAGE: 'Patikrinkite, ar nėra elementų, kuriuos sunku pastebėti arba atskirti nuo kitų spalvų.',
    RED_EYE: 'Raudonas aklasis.',
    GREEN_EYE: 'Žaliosios žaliosios aklės.',
    BLUE_EYE: 'Mėlyna aklina.',
    MONO_EYE: 'Raudonas, mėlynas ir žalias aklasis.',
    COLOUR_FILTER_HIGH_CONTRAST_MESSAGE: 'Spalviniai filtrai neveikia didelio kontrasto režimu.',

    // Alternative text stop words
    SUSPICIOUS_ALT_STOPWORDS: [
      'vaizdas',
      'grafinis',
      'paveikslėlis',
      'nuotrauka',
      'photo',
      'image',
      'graphic',
    ],
    PLACEHOLDER_ALT_STOPWORDS: [
      'alt',
      'vaizdas',
      'nuotrauka',
      'dekoratyvinis',
      'nuotrauka',
      'vietoj',
      'vietoj paveikslėlio',
      'tarpinė',
      'photo',
      'image',
      'graphic',
    ],
    PARTIAL_ALT_STOPWORDS: [
      'spustelėkite',
      'spauskite čia',
      'spausdami čia',
      'spauskite čia, kad sužinotumėte daugiau',
      'spustelėkite čia, kad sužinotumėte daugiau',
      'patikrinkite',
      'išsamiai aprašyta čia',
      'atsisiųsti',
      'atsisiųsti čia',
      'sužinoti',
      'sužinokite daugiau',
      'sužinoti daugiau',
      'forma',
      'čia',
      'informacija',
      'nuoroda',
      'mokytis',
      'išmokti',
      'daugiau',
      'puslapis',
      'popierius',
      'skaityti daugiau',
      'skaityti',
      'perskaitykite tai',
      'šis',
      'šiame puslapyje',
      'ši svetainė',
      'šioje svetainėje',
      'peržiūrėti',
      'peržiūrėti mūsų',
      'svetainė',
    ],
    WARNING_ALT_STOPWORDS: [
      'spauskite čia',
    ],
    NEW_WINDOW_PHRASES: [
      'išorinis',
      'naujas skirtukas',
      'naujas langas',
      'iššokantis',
      'iššokti',
    ],
    FILE_TYPE_PHRASES: ['dokumentas', 'skaičiuoklė', 'skaičiuoklė', 'suspausta rinkmena', 'archyvuota rinkmena', 'darbalapis', 'powerpoint', 'prezentacija', 'įdiegti', 'vaizdo įrašas', 'garsas', 'pdf'],
    LANG_READABILITY: 'Įskaitomumas',
    LANG_AVG_SENTENCE: 'Vidutinis žodžių skaičius sakinyje:',
    LANG_COMPLEX_WORDS: 'Sudėtiniai žodžiai:',
    LANG_TOTAL_WORDS: 'Žodžiai:',
    LANG_VERY_DIFFICULT: 'Labai sunku',
    LANG_DIFFICULT: 'Sudėtinga',
    LANG_FAIRLY_DIFFICULT: 'Gana sudėtinga',
    LANG_GOOD: 'Geras',
    READABILITY_NO_P_OR_LI_MESSAGE: 'Nepavyksta apskaičiuoti skaitomumo balo. Nerastas nei paragrafas <code>&lt;p&gt;</code>, nei sąrašo turinys <code>&lt;li&gt;</code>.',
    READABILITY_NOT_ENOUGH_CONTENT_MESSAGE: 'Nepakankamai turinio, kad būtų galima apskaičiuoti skaitomumo balą.',
    HEADING_NON_CONSECUTIVE_LEVEL: 'Naudojamas ne nuoseklus antraštės lygis. Antraštės niekada neturėtų praleisti lygių arba pereiti iš <strong>Pavadinimo %(prevLevel)</strong> į <strong {r}>Pavadinimą %(level)</strong>.',
    HEADING_EMPTY: 'Rasta tuščia antraštė! Norėdami ištaisyti, ištrinkite šią eilutę arba pakeiskite jos formatą iš <strong {r}>Heading %(level)</strong> į <strong>Normal</strong> arba <strong>Paragraph</strong>.',
    HEADING_LONG: 'Antraštė ilga! Antraštės turėtų būti naudojamos turiniui tvarkyti ir struktūrai perteikti. Jos turėtų būti trumpos, informatyvios ir unikalios. Prašome, kad antraštės būtų trumpesnės nei 160 ženklų (ne ilgesnės nei sakinys). <hr> Ženklų skaičius: <strong {r}>%(headingLength)</strong>',
    HEADING_FIRST: 'Pirmoji puslapio antraštė paprastai turėtų būti 1 arba 2 antraštė. 1 antraštė turėtų būti pagrindinio turinio skyriaus pradžia ir yra pagrindinė antraštė, apibūdinanti bendrą puslapio tikslą. Sužinokite daugiau apie <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/">Galvutės struktūrą.</a>',
    HEADING_MISSING_ONE: 'Trūksta 1 antraštės. 1 antraštė turėtų būti pagrindinės turinio srities pradžia ir yra pagrindinė antraštė, apibūdinanti bendrą puslapio tikslą. Sužinokite daugiau apie <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/">Pavadinimų struktūrą.</a>',
    HEADING_EMPTY_WITH_IMAGE: 'Antraštėje nėra teksto, bet yra paveikslėlis. Jei tai nėra antraštė, pakeiskite jos formatą iš <strong {r}>Heading %(level)</strong> į <strong>Normal</strong> arba <strong>Paragraph</strong>. Kitu atveju pridėkite paveikslėlio alt tekstą, jei jis nėra dekoratyvinis.',
    PANEL_HEADING_MISSING_ONE: 'Trūksta 1 antraštės!',
    PANEL_NO_HEADINGS: 'Antraščių nerasta.',
    LINK_EMPTY: 'Pašalinkite tuščias nuorodas be jokio teksto.',
    LINK_EMPTY_LINK_NO_LABEL: 'Nuorodoje nėra įskaitomo teksto, kuris būtų matomas ekrano skaitytuvams ir kitoms pagalbinėms technologijoms. Ištaisyti: </li><li>Pridėkite glaustą tekstą, kuriame būtų aprašyta, kur nuoroda veda.</li><li>Jeigu tai yra <a href="https://a11y-101.com/development/icons-and-links">paveiksliuko arba SVG nuoroda,</a> greičiausiai trūksta aprašomosios etiketės.</li><li>Jeigu manote, kad ši nuoroda yra klaida dėl kopijavimo ir įkėlimo klaidos, apsvarstykite galimybę ją ištrinti.</li></ul>.',
    LINK_LABEL: '<strong>Etiketė su nuoroda:</strong> %(sanitizedText)',
    LINK_STOPWORD: 'Nuorodos tekstas gali būti nepakankamai aprašomas be konteksto: <strong {r}>%(error)</strong><hr><hr><strong>Tipas!</strong> Nuorodos tekstas visada turi būti aiškus, unikalus ir prasmingas. Venkite įprastų žodžių, tokių kaip &quot;spustelėkite čia&quot; arba &quot;sužinokite daugiau&quot;;',
    LINK_BEST_PRACTICES: 'Apsvarstykite galimybę pakeisti nuorodos tekstą: <strong {r}>%(error)</strong><hr><ul><li>&quot;Spauskite čia&quot; dėmesys sutelkiamas į pelės mechaniką, nors daugelis žmonių nenaudoja pelės arba galbūt šią svetainę peržiūri mobiliuoju įrenginiu. Apsvarstykite galimybę naudoti kitą veiksmažodį, susijusį su užduotimi.</li><li>Venkite naudoti HTML simbolius kaip raginimą atlikti veiksmus, nebent jie būtų paslėpti pagalbinėms technologijoms.</li></ul>',
    LINK_URL: 'Ilgesni, mažiau suprantami URL adresai, naudojami kaip nuorodos tekstas, gali būti sunkiai suprantami naudojantis pagalbinėmis technologijomis. Daugeliu atvejų vietoj URL adreso geriau naudoti žmogui suprantamą tekstą. Trumpi URL adresai (pavyzdžiui, svetainės pagrindinis puslapis) yra tinkami.<hr><strong>Tipas!</strong> Nuorodos tekstas visada turi būti aiškus, unikalus ir prasmingas, kad jį būtų galima suprasti iš konteksto.',
    LINK_DOI: 'Interneto puslapiuose arba tik internete esančiuose ištekliuose <a href="https://apastyle.apa.org/style-grammar-guidelines/paper-format/accessibility/urls#:~:text=descriptive%20links">APA stiliaus vadove</a> rekomenduojama naudoti aprašomąsias nuorodas, aplink kūrinio pavadinimą nurodant jo URL arba DOI. Ilgesni, mažiau suprantami URL adresai, naudojami kaip nuorodos tekstas, gali būti sunkiai suprantami naudojantis pagalbinėmis technologijomis.',
    NEW_TAB_WARNING: 'Nuoroda atsidaro naujame skirtuke arba lange be įspėjimo. Tai gali trikdyti, ypač žmones, kuriems sunku suvokti vaizdinį turinį. Antra, ne visada yra gera praktika kontroliuoti kieno nors patirtį ar priimti sprendimus už jį. Nuorodos tekste nurodykite, kad nuoroda atidaroma naujame lange<hr><strong>Tipas!</strong> Išmokite geriausios praktikos: <a href="https://www.nngroup.com/articles/new-browser-windows-and-tabs/">atidaryti nuorodas naujuose naršyklės languose ir skirtukuose.</a>',
    FILE_TYPE_WARNING: 'Nuoroda nukreipia į PDF arba atsisiunčiamą failą (pvz., MP3, Zip, "Word" dokumentą) be įspėjimo. Nuorodos tekste nurodykite failo tipą. Jei tai didelis failas, apsvarstykite galimybę nurodyti failo dydį.<hr><strong>Pavyzdys:</strong> Vykdomoji ataskaita (PDF, 3 MB)',
    LINK_IDENTICAL_NAME: 'Nuoroda turi tokį patį tekstą kaip ir kita nuoroda, nors nukreipia į kitą puslapį. Kelios nuorodos su tuo pačiu tekstu gali klaidinti ekrano skaitytuvus naudojančius žmones.<hr>Pagalvokite, ar nevertėtų šios nuorodos aprašyti labiau, kad ją būtų lengviau atskirti nuo kitų nuorodų: <strong {r}>%(sanitizedText)</strong>',
    MISSING_ALT_LINK_BUT_HAS_TEXT_MESSAGE: 'Paveikslas naudojamas kaip nuoroda su aplinkiniu tekstu, nors atributas alt turėtų būti pažymėtas kaip dekoratyvinis arba nulinis.',
    MISSING_ALT_LINK_MESSAGE: 'Paveiksliukas naudojamas kaip nuoroda, bet nėra teksto alt! Užtikrinkite, kad alt tekste būtų aprašyta, kur nukreipia nuoroda.',
    MISSING_ALT_MESSAGE: 'Trūksta alt teksto! Jei paveikslėlis perteikia istoriją, nuotaiką ar svarbią informaciją, būtinai jį aprašykite.',
    LINK_ALT_HAS_FILE_EXTENSION: 'Rastas failo plėtinys alt tekste. Užtikrinkite, kad alt tekstas apibūdintų nuorodos paskirties vietą, o ne pažodinį paveikslėlio aprašymą. Pašalinti: <strong {r}>%(error)</strong>.<hr><strong>Alt tekstas:</strong> %(altText)',
    LINK_IMAGE_PLACEHOLDER_ALT_MESSAGE: 'Rastas ne aprašomasis arba pakaitinis alt tekstas susietame paveikslėlyje. Užtikrinkite, kad alt tekstas apibūdintų nuorodos paskirties vietą, o ne pažodinį paveikslėlio aprašymą. Pakeiskite šį alt tekstą: <strong {r}>%(altText)</strong>',
    LINK_IMAGE_SUS_ALT_MESSAGE: 'Pagalbinėse technologijose jau nurodoma, kad tai yra paveikslėlis, todėl &quot;<strong {r}>%(error)</strong>&quot; gali būti nereikalingas. Užtikrinkite, kad alt tekstas apibūdintų nuorodos paskirties vietą, o ne pažodinį paveikslėlio aprašymą. <hr> <strong>Alt tekstas:</strong> %(altText)',
    ALT_HAS_FILE_EXTENSION: 'Rastas failo plėtinys alt tekste. Jei vaizdas perteikia istoriją, nuotaiką ar svarbią informaciją, būtinai aprašykite vaizdą. Pašalinti: <strong {r}>%(error)</strong>.<hr><strong>Alt tekstas:</strong> %(altText)',
    ALT_PLACEHOLDER_MESSAGE: 'Rastas neaprašytas arba pakaitinis alt tekstas. Pakeiskite šį alt tekstą į prasmingesnį: <strong {r}>%(altText)</strong>',
    ALT_HAS_SUS_WORD: 'Pagalbinėse technologijose jau nurodoma, kad tai yra paveikslėlis, todėl &quot;<strong {r}>%(error)</strong>&quot; gali būti nereikalingas. <hr> <strong>Alt tekstas:</strong> %(altText)',
    LINK_HIDDEN_FOCUSABLE: 'Nuoroda turi <code>aria-hidden=&quot;true&quot;</code>, bet vis dar gali būti fokusuojama naudojant klaviatūrą. Jei ketinate paslėpti nereikalingą arba pasikartojantį nuorodą, taip pat pridėkite <code>tabindex=&quot;-1&quot;</code>.',
    LINK_IMAGE_NO_ALT_TEXT: 'Nuorodoje esantis paveikslėlis pažymėtas kaip dekoratyvinis, o nuorodos teksto nėra. Prie paveikslėlio pridėkite alt tekstą, kuriame būtų aprašyta nuorodos paskirtis.',
    LINK_IMAGE_HAS_TEXT: 'Paveikslas pažymėtas kaip dekoratyvinis, nors nuorodoje aplinkinis tekstas naudojamas kaip aprašomoji etiketė.',
    LINK_IMAGE_LONG_ALT: 'Susieto paveikslėlio Alt teksto aprašymas yra <strong>per ilgas</strong>. Susietų paveikslėlių alt tekstas turėtų apibūdinti, kur nukreipia nuoroda, o ne pažodinis paveikslėlio aprašymas. <strong>Svarstykite galimybę kaip alt tekstą naudoti puslapio, į kurį nukreipia nuoroda, pavadinimą.</strong> <hr> <strong> <strong>Alt tekstas (<span {r}>%(altLength)</span> ženklai):</strong> %(altText)',
    LINK_IMAGE_ALT_WARNING: 'Paveikslėlio nuorodoje yra teksto alt. <strong>Ar alt tekste aprašoma, kur nukreipia nuoroda?</strong> Apsvarstykite galimybę kaip alt tekstą naudoti puslapio, į kurį nukreipia nuoroda, pavadinimą. <hr> <strong>Alt tekstas:</strong> %(altText)',
    LINK_IMAGE_ALT_AND_TEXT_WARNING: 'Paveikslėlio nuorodoje yra <strong>ir alt tekstas, ir aplink esantis nuorodos tekstas.</strong> Jei šis paveikslėlis yra dekoratyvinis ir naudojamas kaip funkcinė nuoroda į kitą puslapį, apsvarstykite galimybę pažymėti paveikslėlį kaip dekoratyvinį arba nulinį - aplink esančio nuorodos teksto turėtų pakakti. <hr> <strong>Alt tekstas:</strong> %(altText) <hr> <strong>Etiketė su nuoroda:</strong> %(sanitizedText)',
    IMAGE_FIGURE_DECORATIVE: 'Vaizdas pažymėtas kaip <strong>dekoratyvinis</strong>, todėl pagalbinės technologijos jį ignoruos. <hr> Nors buvo pateikta <strong>antrašė</strong>, daugeliu atvejų paveikslėlis taip pat turėtų turėti alt tekstą. <ul><li>Alt tekste turėtų būti glaustai aprašyta, kas yra paveikslėlyje.</li><li>Paprastai antraštėje turėtų būti pateiktas kontekstas, kad paveikslėlis būtų susietas su aplinkiniu turiniu, arba atkreiptas dėmesys į tam tikrą informaciją.</li></ul>Sužinokite daugiau: <a href="https://thoughtbot.com/blog/alt-vs-figcaption#the-figcaption-element">alt versus figcaption.</a>',
    IMAGE_FIGURE_DUPLICATE_ALT: 'Nenaudokite tų pačių žodžių ir alt, ir antraštės tekstui. Ekrano skaitytuvai informaciją skelbs du kartus.<ul><li>Alt tekste turėtų būti glaustai aprašyta, kas yra paveikslėlyje.</li><li>Tapatybėje paprastai turėtų būti pateiktas kontekstas, kad paveikslėlis būtų susietas su aplinkiniu turiniu arba atkreiptas dėmesys į tam tikrą informaciją.</li></ul> Sužinokite daugiau: <a href="https://thoughtbot.com/blog/alt-vs-figcaption#the-figcaption-element">alt versus figcaption.</a> <hr> <strong>Alt tekstas:</strong> %(altText)',
    IMAGE_DECORATIVE: 'Vaizdas pažymėtas kaip <strong>dekoratyvinis</strong>, todėl pagalbinės technologijos jį ignoruos. Jei vaizdas perteikia istoriją, nuotaiką ar svarbią informaciją - būtinai pridėkite alt tekstą.',
    IMAGE_ALT_TOO_LONG: 'Alt teksto aprašymas yra <strong>per ilgas</strong>. Alt tekstas turėtų būti glaustas, bet prasmingas, kaip <em>tweet</em> (apie 100 simbolių). Jei tai sudėtingas paveikslėlis arba grafikas, apsvarstykite galimybę ilgą paveikslėlio aprašymą pateikti žemiau esančiame tekste arba akordeono komponente. <hr> <strong>Alt tekstas (<span {r}>%(altLength)</span> ženklų):</strong> %(altText)',
    IMAGE_PASS: '<strong>Alt tekstas:</strong> %(altText)',
    LABELS_MISSING_IMAGE_INPUT_MESSAGE: 'Nėra paveikslėlio mygtuko alt teksto. Pridėkite alt tekstą ir pateikite prieinamą pavadinimą. Pavyzdžiui: <em>Ieškoti</em> arba <em>Pateikti</em>.',
    LABELS_INPUT_RESET_MESSAGE: 'Atstatymo mygtukai turėtų būti <strong>nenaudojami, nebent jų specialiai reikia, nes juos lengva įjungti per klaidą. <hr> <strong>Tipas!</strong> Sužinokite, kodėl <a href="https://www.nngroup.com/articles/reset-and-cancel-buttons/">Mygtukai "Reset" ir "Cancel" kelia patogumo problemų.</a>',
    LABELS_ARIA_LABEL_INPUT_MESSAGE: 'Įvestis turi prieinamą pavadinimą, tačiau užtikrinkite, kad būtų matoma ir etiketė. <hr> <strong>Įvesties žymė:</strong> %(sanitizedText)',
    LABELS_NO_FOR_ATTRIBUTE_MESSAGE: 'Su šia įvestimi nėra susieta jokia etiketė. Pridėkite <code>for</code> atributą prie etiketės, atitinkančios šios įvesties <code>id</code>. <hr> Šios įvesties ID yra: <strong>id=&#34;%(id)&#34;</strong>.',
    LABELS_MISSING_LABEL_MESSAGE: 'Su šia įvestimi nėra susieta jokia etiketė. Pridėkite <code>id</code> prie šios įvesties ir pridėkite atitinkamą <code>for</code> atributą prie etiketės.',
    EMBED_VIDEO: 'Užtikrinkite, kad <strong>visuose vaizdo įrašuose būtų uždaros antraštės.</strong> Visų garso ir vaizdo įrašų titrų pateikimas yra privalomas A lygio reikalavimas. Titrai padeda kurtiesiems ir neprigirdintiesiems.',
    EMBED_AUDIO: 'Užtikrinkite, kad pateiktumėte <strong>visų podkastų transkripciją.</strong> Garso turinio transkripcijų pateikimas yra privalomas A lygio reikalavimas. Transkripcijos padeda kurtiesiems ir neprigirdintiesiems, tačiau jos gali būti naudingos visiems. Apsvarstykite galimybę transkripciją pateikti žemiau arba akordeono skydelyje.',
    EMBED_DATA_VIZ: 'Tokie duomenų vizualizavimo valdikliai dažnai kelia problemų žmonėms, kurie naudojasi klaviatūra arba ekrano skaitytuvu, ir gali kelti didelių sunkumų silpnaregiams arba spalvinio aklumo žmonėms. Rekomenduojama tą pačią informaciją pateikti alternatyviu (teksto arba lentelės) formatu po valdikliu. <hr> Sužinokite daugiau apie <a href="https://www.w3.org/WAI/tutorials/images/complex">sudėtingus vaizdus.</a>',
    EMBED_MISSING_TITLE: 'Įterptajam turiniui reikalingas prieinamas pavadinimas, apibūdinantis jo turinį. Elemente <code>iframe</code> nurodykite unikalų <code>title</code> arba <code>aria-label</code> atributą. Sužinokite daugiau apie <a href="https://web.dev/learn/accessibility/more-html#iframes">iRėmus.</a>.',
    EMBED_GENERAL_WARNING: 'Nepavyksta patikrinti įterpto turinio. Įsitikinkite, kad paveikslėliuose yra "alt" tekstas, vaizdo įrašuose - antraštės, tekstas pakankamai kontrastingas, o interaktyvūs komponentai yra <a href="https://webaim.org/techniques/keyboard/">prieinami klaviatūra.</a>',
    EMBED_UNFOCUSABLE: '<code>&lt;iframe&gt;</code> su elementais, į kuriuos negalima sutelkti dėmesio, neturėtų turėti <code>tabindex="-1"</code>. Įterptasis turinys nebus pasiekiamas naudojant klaviatūrą.',
    QA_BAD_LINK: 'Rasta bloga nuoroda. Atrodo, kad nuoroda nukreipia į kūrimo aplinką. <hr> Ši nuoroda nukreipia į: <br> <strong {r}>%(el)</strong>',
    QA_BAD_ITALICS: 'Paryškinimo ir kursyvo žymės turi semantinę reikšmę ir neturėtų būti naudojamos <strong>ne</strong> ištisoms pastraipoms paryškinti. Paryškintas tekstas turėtų būti naudojamas stipriai <strong>pabrėžti</strong> žodį ar frazę. Kursyvu reikėtų paryškinti tikruosius vardus (t. y. knygų ir straipsnių pavadinimus), svetimžodžius, kabutes. Ilgos citatos turėtų būti formatuojamos kaip blokinė citata.',
    QA_PDF: 'Nepavyksta patikrinti PDF failų prieinamumo. PDF yra laikomi žiniatinklio turiniu, todėl jie taip pat turi būti prieinami. PDF dažnai kyla problemų žmonėms, kurie naudojasi ekrano skaitytuvais (trūksta struktūrinių žymų arba formos laukų etikečių), ir silpnaregiams (padidinus tekstą, jis neatsinaujina). <ul><li>Jei tai yra forma, apsvarstykite galimybę kaip alternatyvą naudoti prieinamą HTML formą.</li><li>Jei tai yra dokumentas, apsvarstykite galimybę jį konvertuoti į tinklalapį.</li></ul>Kitu atveju patikrinkite <a href="https://helpx.adobe.com/acrobat/using/create-verify-pdf-accessibility.html">PDF prieinamumą programoje "Acrobat DC".</a>',
    QA_DOCUMENT: 'Nepavyksta patikrinti dokumento prieinamumo. Susieti dokumentai laikomi žiniatinklio turiniu ir taip pat turi būti prieinami. Prašome peržiūrėti šį dokumentą rankiniu būdu. <ul><li>Padarykite savo <a href="https://support.google.com/docs/answer/6199477?hl=lt">"Google Workspace" dokumentą arba pristatymą prieinamesnį.</a></li><li>Padarykite savo <a href="https://support.microsoft.com/lt/office/create-accessible-office-documents-868ecfcd-4f00-4224-b881-a65537a7c155">"Office" dokumentus prieinamesnius.</a></li></li></ul>',
    QA_PAGE_LANGUAGE: 'Puslapio kalba nedeklaruota! Prašome <a href="https://www.w3.org/International/questions/qa-html-language-declarations">deklaruoti kalbą HTML žymėje.</a>',
    QA_PAGE_TITLE: 'Trūksta puslapio pavadinimo! Pateikite <a href="https://developer.mozilla.org/lt/docs/Web/HTML/Element/title">puslapio pavadinimą.</a>',
    QA_BLOCKQUOTE_MESSAGE: 'Ar tai antraštė? <strong {r}>%(sanitizedText)</strong> <hr> Blokinės kabutės turėtų būti naudojamos tik citatoms. Jei tai turi būti antraštė, pakeiskite šią blokinę kabutę į semantinę antraštę (pvz., 2 arba 3 antraštę).',
    QA_FAKE_HEADING: 'Ar tai antraštė? <strong {r}>%(boldtext)</strong> <hr> Paryškinto ar didelio teksto eilutė gali atrodyti kaip antraštė, tačiau ekrano skaitytuvu besinaudojantis žmogus negali pasakyti, kad ji yra svarbi, arba pereiti prie jos turinio. Paryškintas ar didelis tekstas niekada neturėtų pakeisti semantinių antraščių (nuo 2 iki 6 antraštės).',
    QA_SHOULD_BE_LIST: 'Ar bandote sudaryti sąrašą? Rastas galimas sąrašo elementas: <strong {r}>%(firstPrefix)</strong> <hr> Įsitikinkite, kad naudojate semantinius sąrašus, vietoj jų naudodami kulkų arba skaičių formatavimo mygtukus. Naudojant semantinį sąrašą pagalbinės technologijos gali perteikti tokią informaciją, kaip bendras elementų skaičius ir kiekvieno elemento santykinė padėtis sąraše. Sužinokite daugiau apie <a href="https://www.w3.org/WAI/tutorials/page-structure/content/#lists">semantinius sąrašus.</a>.',
    QA_UPPERCASE_WARNING: 'Rastos visos didžiosios raidės. Kai kurie ekrano skaitytuvai tekstą visomis didžiosiomis raidėmis gali interpretuoti kaip akronimą ir skaityti kiekvieną raidę atskirai. Be to, kai kurie žmonės mano, kad visos didžiosios raidės yra sunkiau įskaitomos, ir tai gali sudaryti šauksmo įspūdį.',
    QA_DUPLICATE_ID: 'Rastas <strong>dvigubas ID</strong>. Yra žinoma, kad pasikartojančio ID klaidos sukelia problemų pagalbinėms technologijoms, kai jos bando sąveikauti su turiniu. <hr> Prašome pašalinti arba pakeisti šį ID: <strong {r}>%(id)</strong>',
    QA_TEXT_UNDERLINE_WARNING: 'Pabrauktą tekstą galima supainioti su nuorodomis. Apsvarstykite galimybę naudoti kitą stilių, pavyzdžiui, <code>&lt;strong&gt;</code><strong>strong svarba</strong><code>&lt;/strong&gt;</code> arba <code>&lt;em&gt;</code><em>pabrėžimas</em><code>&lt;/em&gt;</code>.',
    QA_SUBSCRIPT_WARNING: 'Subskripcijos ir superskripcijos formatavimo parinktys turėtų būti naudojamos tik teksto padėčiai pakeisti dėl tipografinių susitarimų ar standartų. Jos neturėtų būti <strong>nenaudojamos</strong> tik pateikimo ar išvaizdos tikslais. Formatuojant ištisus sakinius kyla skaitomumo problemų. Tinkami naudojimo atvejai būtų eksponentų, eilės numerių, pavyzdžiui, 4<sup>th</sup> vietoj fourth, ir cheminių formulių (pvz., H<sub>2</sub>O) rodymas.',
    TABLES_MISSING_HEADINGS: 'Trūksta lentelių antraščių! Prieinamoms lentelėms reikia HTML žymėjimo, kuris nurodo antraštės langelius ir duomenų langelius, apibrėžiančius jų ryšį. Ši informacija suteikia kontekstą žmonėms, kurie naudojasi pagalbinėmis technologijomis. Lentelės turėtų būti naudojamos tik lentelėms su duomenimis. <hr> Sužinokite daugiau apie <a href="https://www.w3.org/WAI/tutorials/tables/">prieinamas lenteles.</a>',
    TABLES_SEMANTIC_HEADING: 'Semantinės antraštės, pavyzdžiui, Heading 2 arba Heading 3, turėtų būti naudojamos tik turinio skyriams; <strong>ne</strong> HTML lentelėse. Vietoj to lentelių antraštes nurodykite naudodami elementą <code>&lt;th&gt;</code>. <hr> Sužinokite daugiau apie <a href="https://www.w3.org/WAI/tutorials/tables/">prieinamas lenteles.</a>',
    TABLES_EMPTY_HEADING: 'Rasta tuščia lentelės antraštė! Lentelės antraštės <strong>niekada</strong> neturėtų būti tuščios. Svarbu nurodyti eilučių ir (arba) stulpelių antraštes, kad būtų išreikštas jų ryšys. Ši informacija suteikia kontekstą žmonėms, kurie naudojasi pagalbinėmis technologijomis. Atminkite, kad lentelės turėtų būti naudojamos tik lentelėms su lentelių duomenimis. <hr> Sužinokite daugiau apie <a href="https://www.w3.org/WAI/tutorials/tables/">prieinamas lenteles.</a>',
    CONTRAST_ERROR: 'Šis tekstas nepakankamai kontrastuoja su fonu. Įprasto teksto kontrasto santykis turėtų būti bent 4,5:1, o didelio teksto - 3:1. <hr> Kontrasto santykis <strong {r}>%(cratio)</strong> šiam tekstui yra <strong: <strong {r}>%(sanitizedText)</strong>',
    CONTRAST_WARNING: 'Šio teksto kontrastas nežinomas ir turi būti peržiūrėtas rankiniu būdu. Užtikrinkite, kad tekstas ir fonas būtų ryškios kontrastingos spalvos. Įprasto teksto kontrasto santykis turėtų būti bent 4,5:1, o didelio teksto - 3:1. <hr> <strong>Prašome peržiūrėti:</strong> %(sanitizedText)',
    CONTRAST_INPUT_ERROR: 'Šios įvesties tekstas nepakankamai kontrastuoja su fonu. Įprasto teksto kontrasto santykis turėtų būti bent 4,5:1, o didelio teksto - 3:1. <hr> Kontrasto santykis: <strong {r}>%(cratio)</strong>',
  },
};

export { lt as default };
