<?php
defined('_JEXEC') or die('Restricted access');
/**
 * @package VehicleManager LocationMap
 * @author Andrey Kvasnevskiy - OrdaSoft (akbet@mail.ru); Sergey Brovko - OrdaSoft (brovinho@mail.ru)
 * @copyright by OrdaSoft
 * Homepage: http://www.ordasoft.com
 * @description Location map for VehicleManager
*/


if (!defined('DS')) define('DS', DIRECTORY_SEPARATOR);

$url = JURI::base();
$mosConfig_live_site = $GLOBALS['mosConfig_live_site'] = substr_replace($url, '', -1, 1);
$mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path'] = JPATH_SITE;

if (!array_key_exists('vehiclemanager_configuration', $GLOBALS) ||
      array_key_exists('vehiclemanager_configuration', $GLOBALS)
      && !count($GLOBALS['vehiclemanager_configuration']))
{
  require_once ($mosConfig_absolute_path .
   "/administrator/components/com_vehiclemanager/admin.vehiclemanager.class.conf.php");
  $GLOBALS['vehiclemanager_configuration'] = $vehiclemanager_configuration;
} else global $vehiclemanager_configuration;

$pr = rand();

$doc = JFactory::getDocument();
$database = JFactory::getDBO();

// if($params->get('GeoCodingBy') == '0'){
//   //GeoCodingBy Google

//   $api_key = "";
//   if (isset($vehiclemanager_configuration['api_key']) && $vehiclemanager_configuration['api_key']) {
//     $api_key = "key=" . $vehiclemanager_configuration['api_key'];
//   } else {
//     JFactory::getApplication()->enqueueMessage("<a target='_blank' href='//developers.google.com/maps/documentation/geocoding/get-api-key'>" . _VEHICLE_MANAGER_GOOGLEMAP_API_KEY_LINK_MESSAGE . "</a>", _VEHICLE_MANAGER_GOOGLEMAP_API_KEY_ERROR);
//   }

//   $doc->addScript("//maps.googleapis.com/maps/api/js?$api_key&libraries=places");
// } 

if ($params->get('GeoCodingBy') == '0') {
    if ( isset($vehiclemanager_configuration['api_key']) && $vehiclemanager_configuration['api_key'] ) {
        $api_key = "key=" . $vehiclemanager_configuration['api_key'];
    } else {
      $api_key = JFactory::getApplication()->enqueueMessage("<a target='_blank' href='//developers.google.com/maps/documentation/geocoding/get-api-key'>" . _VEHICLE_MANAGER_GOOGLEMAP_API_KEY_LINK_MESSAGE . "</a>", _VEHICLE_MANAGER_GOOGLEMAP_API_KEY_ERROR);
    }
    if ( checkJavaScriptIncludedVEH("maps.googleapis.com") == false && checkJavaScriptIncludedVEH("apis.com/maps/api/js") == false ) {
        // $doc->addScript("//maps.googleapis.com/maps/api/js?$api_key&libraries=places");
        //$doc->addScript("//maps.googleapis.com/maps/api/js?$api_key&libraries=places");

?>
                <!-- prettier-ignore -->
    <script>(g=>{var h,a,k,p="The Google Maps JavaScript API",c="google",l="importLibrary",q="__ib__",m=document,b=window;b=b[c]||(b[c]={});var d=b.maps||(b.maps={}),r=new Set,e=new URLSearchParams,u=()=>h||(h=new Promise(async(f,n)=>{await (a=m.createElement("script"));e.set("libraries",[...r]+"");for(k in g)e.set(k.replace(/[A-Z]/g,t=>"_"+t[0].toLowerCase()),g[k]);e.set("callback",c+".maps."+q);a.src=`https://maps.${c}apis.com/maps/api/js?`+e;d[q]=f;a.onerror=()=>h=n(Error(p+" could not load."));a.nonce=m.querySelector("script[nonce]")?.nonce||"";m.head.append(a)}));d[l]?console.warn(p+" only loads once. Ignoring:",g):d[l]=(f,...n)=>r.add(f)&&u().then(()=>d[l](f,...n))})
        ({key: "<?php echo $vehiclemanager_configuration['api_key']; ?>", v: "weekly"});</script>
 <?php
    }
}else {
  //GeoCodingBy OpenMap
}


//Common parameters
//Individual parameters
$count_vehicles = intval($params->def('vehicles', 0));
$cat_id = $params->get('cat_id');
$vehicle_id = $params->get('vehicle_id');
$new_target = $params->def('new_target', 1);
// $default_address = $params->get('address');
// $default_range = $params->get('range');
if($params->get('layout') == '_:With-Search'){
$cat_id = $vehicle_id = NULL;
}
if($params->def('new_target', 1)){
  $new_target = '_blank';
}else{
  $new_target = '_self';
}
$ItemId_tmp_from_params = $params->get('ItemId');
$moduleclass_sfx = $params->get('moduleclass_sfx');

$f_path = JPATH_BASE . '/components/com_vehiclemanager/functions.php';
if (!file_exists($f_path)){
  echo "To display this module You have to install VehicleManager first<br />"; exit;
} else {
  require_once ($f_path);
}

$database->SetQuery("SELECT id  FROM #__menu WHERE menutype like '%menu%' AND link LIKE " .
  " '%option=com_vehiclemanager%' AND params LIKE '%back_button%' ");
$Itemid_from_db = $database->loadResult();
if ($ItemId_tmp_from_params!=''){
    $Itemid = $ItemId_tmp_from_params;
} else{
    $Itemid = $Itemid_from_db;
}

// $s = vmLittleThings::getWhereUsergroupsCondition ("c");
$s = vmLittleThings::getWhereUsergroupsCondition ();

$query = "SELECT language FROM #__modules WHERE id = '$module->id'";
$database->setQuery($query);
$langmodule = $database->loadResult();

$sql_published = " AND v.published=1";
$sql_approved = " AND v.approved=1";

if ($cat_id != null && $vehicle_id != null)
  echo ('<font color="#CC0000">You input IDs of categories and vehicles together! Correct this mistake.</font>');
else
{
  if($vehicle_id != null) $sql_where = " AND v.id IN(".$vehicle_id.")";
  if($cat_id != null) $sql_where = " AND c.id IN(".$cat_id.")";
  if($cat_id == null && $vehicle_id == null) $sql_where = "";

$langContent = vmLittleThings::language_load_VM();

if (isset($langContent)){
    $lang = $langContent;
    // $query = "SELECT lang_code FROM #__languages WHERE sef = '$lang'";
    // $database->setQuery($query);
    // $lang = $database->loadResult();
    $lang = " and (v.language like 'all' or v.language like '' or v.language like '*' or v.language is null or v.language like '$lang')
             AND (c.language like 'all' or c.language like '' or c.language like '*' or c.language is null or c.language like '$lang') ";
}else{
    $lang = "";
}

if($langmodule != "" && $langmodule != "*"){
    $selectstring = "SELECT
 v.vtitle,v.id,v.vehicleid,v.vlatitude,v.vlongitude,vc.idcat,v.vtype,v.image_link,v.price,v.priceunit,map_zoom
              \nFROM #__vehiclemanager_vehicles AS v
              \nLEFT JOIN #__vehiclemanager_categories AS vc ON vc.iditem=v.id
              \nLEFT JOIN #__vehiclemanager_main_categories AS c ON c.id=vc.idcat
              \nWHERE ($s) $lang AND v.language = '".$langmodule."' AND v.vlatitude IS NOT NULL ".$sql_where.$sql_published.$sql_approved . " GROUP BY v.id " .
             "\nLIMIT ".$count_vehicles;
  } else {
    $selectstring = "SELECT
    v.vtitle,v.id,v.vehicleid,v.vlatitude,v.vlongitude,vc.idcat,v.vtype,v.image_link,v.price,v.priceunit,map_zoom
              \nFROM #__vehiclemanager_vehicles AS v
              \nLEFT JOIN #__vehiclemanager_categories AS vc ON vc.iditem=v.id
              \nLEFT JOIN #__vehiclemanager_main_categories AS c ON c.id=vc.idcat
              \nWHERE ($s) $lang AND v.vlatitude IS NOT NULL".$sql_where.$sql_published.$sql_approved . " GROUP BY v.id " .
             "\nLIMIT ".$count_vehicles;
  }
  $database->setQuery($selectstring);
  $rows= $database->loadObjectList();
} ?>

<div class="os_jv" >


<div class="vehiclemanager_<?php if($moduleclass_sfx!='') echo $moduleclass_sfx; ?>">
<noscript>Javascript is required to use Vehicle Manager <a href="https://ordasoft.com/vehicle-manager-joomla-car-rental-dealer-software-for-rent-and-sell-cars" title="car rental dealer software">car rental dealer software</a>, <a href="https://ordasoft.com/car-dealer-website-development.html" title="car dealer website development" >car dealer website development</a></noscript>

<script language="javascript" type="text/javascript">

    function vmFireEvent(el,event) {

        if ("createEvent" in document) {
            el.click();
            var evt = document.createEvent("HTMLEvents");
            evt.initEvent(event, true, true);// event type,bubbling,cancelable
            return el.dispatchEvent(evt);
        }
        else{
          // dispatch for IE
          var evt = document.createEventObject();
          return el.fireEvent("on"+event,evt);
       }
    }

    function vmOpenItem() {
        var tmpLinks=document.getElementsByTagName('a');

        for(var i=0;i<tmpLinks.length;i++){
          if(tmpLinks[i].name=='vm_link_item'){
            setTimeout(function(){vmFireEvent(tmpLinks[i],'click')},50);
            return ;
          }
        }
    }
  </script>
  </div>
    <?php
    $map_uniq_id = $pr;
    ?>

<style>#vm_map_canvas<?php echo $pr; ?> img{max-width:none;}</style>

  <?php if ($params->get('is_percentage') == 'pixels') { ?>
  <div class="vm_mod_map_canvas" id="vm_map_canvas<?php echo $pr; ?>"
    style="width: <?php echo $params->get('map_width');
    ?>px; height: <?php echo $params->get('map_height'); ?>px; float: rigth;" >
  </div>

  <?php } elseif ($params->get('is_percentage') == 'percentage') {?>
  <div class="vm_mod_map_canvas" id="vm_map_canvas<?php echo $pr; ?>"
    style="width: 100%; height: <?php echo $params->get('map_height'); ?>px; float: rigth;" >
  </div>
  <?php } ?>

<?php
    if ( $params->get('GeoCodingBy') == 1 ){
    //for open map add div for Popup
?>
    <div id="os_ol_popup<?php echo $map_uniq_id; ?>" class="os_ol_popup">
      <a href="#" id="os_ol_popup-closer<?php echo $map_uniq_id; ?>" class="os_ol_popup-closer"></a>
      <div id="os_ol_popup-content<?php echo $map_uniq_id; ?>"></div>
    </div>
<?php
//        HTML_realestatemanager::add_open_map($rows,$map_uniq_id);
        require getLayoutPath::getLayoutPathCom('com_vehiclemanager', 'map', 'open_map');
    } else {
//        HTML_realestatemanager::add_google_map($rows,$map_uniq_id);
        require getLayoutPath::getLayoutPathCom('com_vehiclemanager', 'map', 'google_map');
    }
?>
</div> <!-- class="os_jv" -->
