<?php
defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2025 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/
require_once(JPATH_SITE . "/components/com_os_cck/functions.php");
//JHTML::_('behavior.modal', 'a.modal-button');
$doc = JFactory::getDocument();
$doc->addScript(JURI::root().'/components/com_os_cck/assets/js/functions.js');
$doc->addStyleSheet(JURI::root().'/components/com_os_cck/assets/css/admin_style.css');
 
class JFormFieldPaypalplugin extends JFormField{
  protected function getInput(){
    $db = JFactory::getDBO();
    $query = "SELECT name,enabled,element FROM #__extensions WHERE folder='payment' AND (element='paypal' OR element='paypal2')";
    $db->setQuery($query);
    $plugins = $db->loadObjectList();
    
    $os_cck_configuration = JComponentHelper::getParams('com_os_cck');
    
    $plugins_opt = array();
    $plugins_opt[] = JHTML::_('select.option','0',cck_lang_text('COM_OS_CCK_PARAMS_OPTION_NOT_SELECTED_PAYPAL'));
    if(!empty($plugins)){
        foreach($plugins as $plugin){
            
            if($plugin->enabled != 0){
                $plugins_opt[] = JHTML::_('select.option',$plugin->element,$plugin->name);
            }
        }
    }
    $plugins_list = JHTML::_('select.genericlist',$plugins_opt, $this->name,
                                    'size="1" class="inputbox" ', 'value', 'text', $os_cck_configuration->get('use_paypal', 0));

    return $plugins_list;
  }
}