<?php
/**
*
* @package  seftranslate
* @copyright 2011 Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
* Homepage: http://www.ordasoft.com
* @version: 6.0 commerce
*
**/


// Don't allow direct linking
if( !defined( '_VALID_MOS' ) && !defined( '_JEXEC' ) ) die( 'Direct Access to '.basename(__FILE__).' is not allowed.' );
if(!defined('DS'))  define('DS', DIRECTORY_SEPARATOR);

require_once(JPATH_SITE.'/components/com_seftranslate/GTranslate.php');
require(JPATH_SITE.'/components/com_seftranslate/languages.conf.php');
require_once(JPATH_SITE.'/components/com_seftranslate/sefurl.class.php');
require_once(JPATH_SITE.'/components/com_seftranslate/seffile.class.php');
require_once(JPATH_SITE.'/components/com_seftranslate/sefurlconnect.class.php');
require_once(JPATH_SITE.'/components/com_seftranslate/sefentity.class.php' );
require_once(JPATH_SITE.'/components/com_seftranslate/dom_parse_traslate.php');
require_once(JPATH_SITE.'/components/com_seftranslate/helper.php' );
$GLOBALS['os_sef_state'] = $os_sef_state = sefTranslateLanguagesHelper::checkSefTranslateActivation() ;
$GLOBALS['task'] = $task = JFactory::getApplication()->input->getCmd('task', "");

require_once(JPATH_SITE.'/administrator/components/com_seftranslate/seftranslate.html.php');
require_once(JPATH_SITE.'/administrator/components/com_seftranslate/toolbar.seftranslate.php');

if( !class_exists('JComponentHelper') && !isset($mainframe))
{
 require_once( JPATH_BASE .DS.'includes'.DS.'defines.php' );
 require_once( JPATH_BASE .DS.'includes'.DS.'framework.php' );
 $GLOBALS['mainframe'] = $mainframe = JFactory::getApplication('administrator');
}

use Joomla\Utilities\ArrayHelper;

$GLOBALS['seftranslate_configuration'] = $seftranslate_configuration;

$GLOBALS['my'] =JFactory::getUser();;
$GLOBALS['acl'] = new JAccess;
$GLOBALS['database'] = JFactory::getDBO();
$GLOBALS['seftranslate_error'] = $seftranslate_error = false;

$cid = JFactory::getApplication()->input->get('id',array(),"ARRAY") ;
$GLOBALS['option'] = $option = JFactory::getApplication()->input->getCmd('option',"com_seftranslate") ; 
$GLOBALS['mosConfig_live_site'] = $mosConfig_live_site = JURI::root(true);
$document = JFactory::getDocument();
if (version_compare(JVERSION, "3.0.0", "ge")) {
  $document->addCustomTag('<link rel="stylesheet" href="'.
    $mosConfig_live_site.'/administrator/components/com_seftranslate/includes/seftranslate_j3.css" type="text/css" />');
}
$document->addCustomTag('<link rel="stylesheet" href="'.
  $mosConfig_live_site.'/administrator/components/com_seftranslate/includes/seftranslate.css" type="text/css" />');


//load language
$lang_def_en=0;
$lang = JFactory::getLanguage();
foreach ($lang->getLocale() as $locale) {
  $mosConfig_lang = $locale;
// *** Get language files
if (file_exists(JPATH_SITE . "/components/com_seftranslate/language/{$mosConfig_lang}.php")) {
  include_once(JPATH_SITE . "/components/com_seftranslate/language/{$mosConfig_lang}.php" );
  $GLOBALS['mosConfig_lang'] = $mosConfig_lang;
  $lang_def_en=1;
       break;
  }

}

if($lang_def_en!=1){
  include_once(JPATH_SITE . "/components/com_seftranslate/language/english.php" );
}


//print_r($task);exit;

// echo ":111111111111111:";
// print_r($rows);
// exit;


  switch ($task) {
    case 'add_lang':
      add_lang();
    break;

    case 'clear_cache':
      clear_cache();
      setting();
    break;

    case 'clear_map':
      clear_map();
      setting();
         break;

    case 'apply':
      apply();
      setting();
       break;

    case 'config':
    setting();
       break;

    case 'edit_page':
    edit_page($cid,$option);
       break;

    case 'edit_url':
    edit_url($cid,$option);
       break;

    case 'edit_phrase':
    edit_phrase($cid,$option);
       break;

    case 'urls':
    urls_manage($option);
       break;

    case 'phrases':
    phrases_manage($option);
       break;

    case 'save_page':
    save_page($cid,$option);
       break;

    case 'save_url':
    save_url($cid,$option);
       break;

    case 'save_phrase':
    save_phrase($cid,$option);
       break;

    case 'cancel_save_page':
    cancel_save_page($cid,$option);
       break;

    case 'cancel_save_url':
    cancel_save_url($cid,$option);
       break;

    case 'cancel_save_phrase':
    cancel_save_phrase($cid,$option);
       break;

    case "publish" :
    publishPage($cid, 1, $option);
       break;

    case "unpublish" :
    publishPage($cid, 0, $option);
       break;

    case "use_as_base_page" :
    use_as_base_page($cid, 1, $option);
       break;

    case "un_use_as_base_page" :
    use_as_base_page($cid, 0, $option);
       break;

    case "manual_translate" :
    manual_translate($cid, 1, $option);
       break;

    case "manual_translate_url" :
    manual_translate_url($cid, 1, $option);
       break;

    case "manual_translate_phrase" :
    manual_translate_phrase($cid, 1, $option);
       break;

    case "auto_translate" :
    manual_translate($cid, 0, $option);
       break;

    case "auto_translate_url" :
    manual_translate_url($cid, 0, $option);
       break;

    case "auto_translate_phrase" :
    manual_translate_phrase($cid, 0, $option);
       break;

    case "delete_page" :
    delete_page($cid, $option);
       break;

    case "delete_url" :
    delete_url($cid, $option);
       break;

    case "delete_phrase" :
    delete_phrase($cid, $option);
       break;


    case 'about':
    about();
       break;

    case 'help':
    help();
       break;

    case "check_package_state":
        $state = sefTranslateLanguagesHelper::checkSefTranslateState();
        print_r($state);exit();
        break ;

    case "update_package":
        sefTranslateLanguagesHelper::updateSefTranslate();
        break ;

    case "set_package_license":
        $data = sefTranslateLanguagesHelper::protectInjectionWithoutQuote('data', '', 'string');
        sefTranslateLanguagesHelper::setSefTranslateLicense($data);

    default:
      pages_manage($option);
      break;
  }

function publishPage($cid, $publish, $option) {

  global $database, $my, $seftranslate_configuration,$os_sef_state;

  if(!isset($os_sef_state->data) ){
      echo '<script>alert("'. _SEF_TRANSLATE_DEBUG_YOUR_LICENSE_NEED_ACTIVE .'"); history.back(); </script>';
      return ;
  }

  if( !JSession::checkToken()  ){
    echo "<script> alert('". _SEF_TRANSLATE_TOKEN_INVALIDE ."'); window.history.go(-1); </script>\n";
    exit ();
  }

  if (!is_array($cid) || count($cid) < 1) {
    echo "<script> alert('"._SEF_TRANSLATE_SELECT_AN_ITEM."'); window.history.go(-1);</script>\n";
    exit;
  }

  $cid = implode(',', $cid);

  if($seftranslate_configuration['cache_save_location'] == "db"){
    $database->setQuery("UPDATE #__seftranslate_urls SET published='$publish'".
          "\nWHERE id IN ($cid) AND (checked_out=0 OR (checked_out='$my->id'))");
  } else {
    $database->setQuery("UPDATE #__seftranslate_files SET published='$publish'".
          "\nWHERE id IN ($cid) AND (checked_out=0 OR (checked_out='$my->id'))");
  }
  $database->execute();

  $app = JFactory::getApplication();
  $app->redirect("index.php?option=$option");


}

function use_as_base_page($cid, $use_as_base_url, $option) {

  global $database, $my, $seftranslate_configuration,$os_sef_state;

  if(!isset($os_sef_state->data) ){
      echo '<script>alert("'. _SEF_TRANSLATE_DEBUG_YOUR_LICENSE_NEED_ACTIVE .'"); history.back(); </script>';
      return ;
  }  

  if( !JSession::checkToken()  ){
    echo "<script> alert('". _SEF_TRANSLATE_TOKEN_INVALIDE ."'); window.history.go(-1); </script>\n";
    exit ();
  }  

  if (!is_array($cid) || count($cid) < 1) {
    echo "<script> alert('"._SEF_TRANSLATE_SELECT_AN_ITEM."'); window.history.go(-1);</script>\n";
    exit;
  }

  $cid = implode(',', $cid);

  if($seftranslate_configuration['cache_save_location'] == "db"){
    $database->setQuery("UPDATE #__seftranslate_urls SET use_as_base_url='$use_as_base_url'".
            "\nWHERE id IN ($cid) AND (checked_out=0 OR (checked_out='$my->id'))");
  } else {
    $database->setQuery("UPDATE #__seftranslate_files SET use_as_base_url='$use_as_base_url'".
            "\nWHERE id IN ($cid) AND (checked_out=0 OR (checked_out='$my->id'))");
  }
  $database->execute();

  $app = JFactory::getApplication();
  $app->redirect("index.php?option=$option");

}

function manual_translate($cid, $manual_translate, $option) {
  global $database, $my, $seftranslate_configuration,$os_sef_state;

  if(!isset($os_sef_state->data) ){
      echo '<script>alert("'. _SEF_TRANSLATE_DEBUG_YOUR_LICENSE_NEED_ACTIVE .'"); history.back(); </script>';
      return ;
  }  

  if( !JSession::checkToken()  ){
    echo "<script> alert('". _SEF_TRANSLATE_TOKEN_INVALIDE ."'); window.history.go(-1); </script>\n";
    exit ();
  }

  if (!is_array($cid) || count($cid) < 1) {
    echo "<script> alert('"._SEF_TRANSLATE_SELECT_AN_ITEM."'); window.history.go(-1);</script>\n";
    exit;
  }

  $cid = implode(',', $cid);

  if($seftranslate_configuration['cache_save_location'] == "db"){
    $database->setQuery("UPDATE #__seftranslate_urls SET manual_translated='$manual_translate'".
            "\nWHERE id IN ($cid) AND (checked_out=0 OR (checked_out='$my->id'))");
  } else {
    $database->setQuery("UPDATE #__seftranslate_files SET manual_translated='$manual_translate'".
            "\nWHERE id IN ($cid) AND (checked_out=0 OR (checked_out='$my->id'))");
  }
  $database->execute();

  $app = JFactory::getApplication();
  $app->redirect("index.php?option=$option");

}

function manual_translate_url($cid, $manual_translate, $option) {
  global $database, $my, $seftranslate_configuration,$os_sef_state;

  if(!isset($os_sef_state->data) ){
      echo '<script>alert("'. _SEF_TRANSLATE_DEBUG_YOUR_LICENSE_NEED_ACTIVE .'"); history.back(); </script>';
      return ;
  }    

  if( !JSession::checkToken()  ){
    echo "<script> alert('". _SEF_TRANSLATE_TOKEN_INVALIDE ."'); window.history.go(-1); </script>\n";
    exit ();
  }  

  if (!is_array($cid) || count($cid) < 1) {
    echo "<script> alert('"._SEF_TRANSLATE_SELECT_AN_ITEM ."'); window.history.go(-1);</script>\n";
    exit;
  }

  $cid = implode(',', $cid);

  $database->setQuery("UPDATE #__seftranslate_url_connect SET manual_translated='$manual_translate'".
            "\nWHERE id IN ($cid) AND (checked_out=0 OR (checked_out='$my->id'))");
  $database->execute();

  $app = JFactory::getApplication();
  $app->redirect("index.php?option=$option&task=urls");

}


function manual_translate_phrase($cid, $manual_translate, $option) {
  global $database, $my, $seftranslate_configuration,$os_sef_state;

  if(!isset($os_sef_state->data) ){
      echo '<script>alert("'. _SEF_TRANSLATE_DEBUG_YOUR_LICENSE_NEED_ACTIVE .'"); history.back(); </script>';
      return ;
  }    

  if( !JSession::checkToken()  ){
    echo "<script> alert('". _SEF_TRANSLATE_TOKEN_INVALIDE ."'); window.history.go(-1); </script>\n";
    exit ();
  }  

  if (!is_array($cid) || count($cid) < 1) {
    echo "<script> alert('"._SEF_TRANSLATE_SELECT_AN_ITEM ."'); window.history.go(-1);</script>\n";
    exit;
  }

  $cid = implode(',', $cid);

  $database->setQuery("UPDATE #__seftranslate_entity SET manual_translated='$manual_translate'".
            "\nWHERE id IN ($cid) AND (checked_out=0 OR (checked_out='$my->id'))");
  $database->execute();

  $app = JFactory::getApplication();
  $app->redirect("index.php?option=$option&task=phrases");

}

function delete_page($cid, $option) {
  global $database, $my, $seftranslate_configuration;

  if( !JSession::checkToken()  ){
    echo "<script> alert('". _SEF_TRANSLATE_TOKEN_INVALIDE ."'); window.history.go(-1); </script>\n";
    exit ();
  }  

  if (!is_array($cid) || count($cid) < 1) {
    echo "<script> alert('" . _SEF_TRANSLATE_SELECT_AN_ITEM ."'); window.history.go(-1);</script>\n";
    exit;
  }

  $cid = implode(',', $cid);

  if($seftranslate_configuration['cache_save_location'] == "db"){
    $database->setQuery("delete from #__seftranslate_urls ".
            "\nWHERE id IN ($cid) AND (checked_out=0 OR (checked_out='$my->id')) ".
            " and manual_translated = '0' and  use_as_base_url = '0' ");
  } else {
    $database->setQuery("delete from #__seftranslate_files ".
            "\nWHERE id IN ($cid) AND (checked_out=0 OR (checked_out='$my->id')) ".
            " and manual_translated = '0' and  use_as_base_url = '0' ");
  }
  $database->execute();

  $app = JFactory::getApplication();
  $app->redirect("index.php?option=$option");

}


function delete_url($cid, $option) {
  global $database, $my, $seftranslate_configuration;

  if( !JSession::checkToken()  ){
    echo "<script> alert('". _SEF_TRANSLATE_TOKEN_INVALIDE ."'); window.history.go(-1); </script>\n";
    exit ();
  }  

  if (!is_array($cid) || count($cid) < 1) {
    echo "<script> alert('" . _SEF_TRANSLATE_SELECT_AN_ITEM ."'); window.history.go(-1);</script>\n";
    exit;
  }

  $cid = implode(',', $cid);

  $database->setQuery("delete from #__seftranslate_url_connect ".
            "\nWHERE id IN ($cid) AND (checked_out=0 OR (checked_out='$my->id')) ".
            " and manual_translated = '0' ");
  $database->execute();

  $app = JFactory::getApplication();
  $app->redirect("index.php?option=$option&task=urls");

}

function delete_phrase($cid, $option) {
  global $database, $my, $seftranslate_configuration;

  if( !JSession::checkToken()  ){
    echo "<script> alert('". _SEF_TRANSLATE_TOKEN_INVALIDE ."'); window.history.go(-1); </script>\n";
    exit ();
  }  

  if (!is_array($cid) || count($cid) < 1) {
    echo "<script> alert('" . _SEF_TRANSLATE_SELECT_AN_ITEM ."'); window.history.go(-1);</script>\n";
    exit;
  }

  $cid = implode(',', $cid);

  $database->setQuery("delete from #__seftranslate_entity ".
            "\nWHERE id IN ($cid) AND (checked_out=0 OR (checked_out='$my->id')) ".
            " and manual_translated = '0' ");
  $database->execute();

  $app = JFactory::getApplication();
  $app->redirect("index.php?option=$option&task=phrase");

}


function edit_page( $cid, $option){
  global $database, $my, $seftranslate_configuration,$os_sef_state;


  if(!isset($os_sef_state->data) ){
      echo '<script>alert("'. _SEF_TRANSLATE_DEBUG_YOUR_LICENSE_NEED_ACTIVE .'"); history.back(); </script>';
      return ;
  }  

  if (!is_array($cid) || count($cid) < 1) {
    echo "<script> alert('"._SEF_TRANSLATE_SELECT_AN_ITEM."'); window.history.go(-1);</script>\n";
    exit;
  }

  if($seftranslate_configuration['cache_save_location'] == "db"){
    $item = new mosSefurl($database);
    $item->load(intval($cid[0]));
  } else {
    $item = new mosSeffile($database);
    $item->load(intval($cid[0]));

    if( is_file( JPATH_SITE."/components/com_seftranslate/cache/".$item->file_name) )
    {
      $fp = fopen(JPATH_SITE."/components/com_seftranslate/cache/".$item->file_name , "r");
      // echo "filesize-".filesize(getcwd ()."/cache/". $fileName);
//       print_r(":111111111111:");
// print_r(JPATH_SITE."/components/com_seftranslate/cache/".$item->file_name);
// exit;
      if(filesize(JPATH_SITE."/components/com_seftranslate/cache/".$item->file_name)!=0)
      {
        $item->page_text = fread($fp, filesize(JPATH_SITE."/components/com_seftranslate/cache/". $item->file_name) );
      }else $item->page_text = "" ;
      fclose($fp);
    }
    //remove all old cache rows and files
    $cache_time=isset($seftranslate_configuration['cache_time'])?$seftranslate_configuration['cache_time']:5*24*60;
    $date_before_remove = date('Y-m-d H:i:s', (time() - $cache_time*60) );

    $query = "select id FROM #__seftranslate_files WHERE date < '".$date_before_remove.
      "' and manual_translated = '0' and use_as_base_url = '0' ;";
    $database->setQuery($query);
    $result = $database->loadObjectList();
    $item_tmp = new mosSeffile($database);
    foreach ($result as $row) {
      $item_tmp->load( $row->id );
      $filename = JPATH_SITE."/components/com_seftranslate/cache/".$item_tmp->file_name ;
      unlink($filename);
      $item_tmp->delete();
    }
  }


    $lang_list=parse_ini_file(JPATH_SITE."/components/com_seftranslate/languages.ini");
    $keys = array_keys( $lang_list );
    // iterate through styles
    $langs=Array();
    foreach( $keys as $key )
    {
      if($key!="UNKNOWN")
      {
        $t=new t_langs();
        $t->key=$lang_list[$key];
        $t->title=ucfirst(strtolower($key));
        $langs[$t->key]=$t;
      }
    }

    //Manual edit or auto created
    $manual_translated[] = JHTML::_('select.option', '0', _SEF_TRANSLATE_LABEL_AUTO_GENERATED, 'value', 'text');
    $manual_translated[] = JHTML::_('select.option', '1', _SEF_TRANSLATE_LABEL_MANUAL_CHANGED, 'value', 'text');
    $manual_translated_list =  JHTML::_('select.genericlist',  $manual_translated, 'manual_translated', 'class="inputbox" size="1" ', 'value', 'text', $item->manual_translated, 'manual_translated');

    $use_as_base_url[] = JHTML::_('select.option', '0', _SEF_TRANSLATE_LABEL_NOT_USE_AS_BASE_URL, 'value', 'text');
    $use_as_base_url[] = JHTML::_('select.option', '1', _SEF_TRANSLATE_LABEL_USE_AS_BASE_URL, 'value', 'text');
    $use_as_base_url_list =  JHTML::_('select.genericlist',  $use_as_base_url, 'use_as_base_url', 'class="inputbox" size="1" ', 'value', 'text', $item->use_as_base_url, 'use_as_base_url');

    $item->checkout($my->id);

  HTML_seftranslate :: edit_page($option, $item,$langs,$manual_translated_list,$use_as_base_url_list);
}

function edit_url( $cid, $option){
  global $database, $my, $seftranslate_configuration,$os_sef_state;

  if(!isset($os_sef_state->data) ){
      echo '<script>alert("'. _SEF_TRANSLATE_DEBUG_YOUR_LICENSE_NEED_ACTIVE .'"); history.back(); </script>';
      return ;
  }  

  if (!is_array($cid) || count($cid) < 1) {
    echo "<script> alert('"._SEF_TRANSLATE_SELECT_AN_ITEM."'); window.history.go(-1);</script>\n";
    exit;
  }

    $item = new mosSefurlconnect($database);
    $item->load(intval($cid[0]));


    $lang_list=parse_ini_file(JPATH_SITE."/components/com_seftranslate/languages.ini");
    $keys = array_keys( $lang_list );
    // iterate through styles
    $langs=Array();
    foreach( $keys as $key )
    {
      if($key!="UNKNOWN")
      {
        $t=new t_langs();
        $t->key=$lang_list[$key];
        $t->title=ucfirst(strtolower($key));
        $langs[$t->key]=$t;
      }
    }

    //Manual edit or auto created
    $manual_translated[] = JHTML::_('select.option', '0', _SEF_TRANSLATE_LABEL_AUTO_GENERATED, 'value', 'text');
    $manual_translated[] = JHTML::_('select.option', '1', _SEF_TRANSLATE_LABEL_MANUAL_CHANGED, 'value', 'text');
    $manual_translated_list =  JHTML::_('select.genericlist',  $manual_translated, 'manual_translated', 'class="inputbox" size="1" ', 'value', 'text', $item->manual_translated, 'manual_translated');

    $item->checkout($my->id);

  HTML_seftranslate :: edit_url($option, $item,$langs,$manual_translated_list);
}


function edit_phrase( $cid, $option){
  global $database, $my, $seftranslate_configuration,$os_sef_state;

  if(!isset($os_sef_state->data) ){
      echo '<script>alert("'. _SEF_TRANSLATE_DEBUG_YOUR_LICENSE_NEED_ACTIVE .'"); history.back(); </script>';
      return ;
  }  

  if (!is_array($cid) || count($cid) < 1) {
    echo "<script> alert('"._SEF_TRANSLATE_SELECT_AN_ITEM."'); window.history.go(-1);</script>\n";
    exit;
  }

    $item = new mosSefentity($database);
    $item->load(intval($cid[0]));


    $lang_list=parse_ini_file(JPATH_SITE."/components/com_seftranslate/languages.ini");
    $keys = array_keys( $lang_list );
    // iterate through styles
    $langs=Array();
    foreach( $keys as $key )
    {
      if($key!="UNKNOWN")
      {
        $t=new t_langs();
        $t->key=$lang_list[$key];
        $t->title=ucfirst(strtolower($key));
        $langs[$t->key]=$t;
      }
    }


    //Manual edit or auto created
    $manual_translated[] = JHTML::_('select.option', '0', _SEF_TRANSLATE_LABEL_AUTO_GENERATED, 'value', 'text');
    $manual_translated[] = JHTML::_('select.option', '1', _SEF_TRANSLATE_LABEL_MANUAL_CHANGED, 'value', 'text');
    $manual_translated_list =  JHTML::_('select.genericlist',  $manual_translated, 'manual_translated', 'class="inputbox" size="1" ', 'value', 'text', $item->manual_translated, 'manual_translated');

    $item->checkout($my->id);

  HTML_seftranslate :: edit_phrase($option, $item,$langs,$manual_translated_list);
}



function save_page( $cid, $option){
  global $database, $my, $seftranslate_configuration;

//print_r($cid); exit;
  if( !JSession::checkToken()  ){
    echo "<script> alert('". _SEF_TRANSLATE_TOKEN_INVALIDE ."'); window.history.go(-1); </script>\n";
    exit ();
  }  

  if($seftranslate_configuration['cache_save_location'] == "db"){
    $item = new mosSefurl($database);
  } else {
    $item = new mosSeffile($database);
  }

  $post = JFactory::getApplication()->input->post->getArray(array(), null, 'raw'); 
  $item->load($post['id']);
  if (!$item->bind($post)) {
      echo "<script> alert('" . $item->getError() . "'); window.history.go(-1); </script>\n";
      exit();
  }
  if($seftranslate_configuration['cache_save_location'] == "db"){
    $item->page_text = htmlspecialchars_decode($item->page_text);
  } else {

    if( is_file( JPATH_SITE."/components/com_seftranslate/cache/".$item->file_name) )
    {

      $fp = fopen(JPATH_SITE."/components/com_seftranslate/cache/".$item->file_name , "w");
      fwrite($fp, htmlspecialchars_decode($post['page_text']) );
      fclose($fp);
      $item->file_name = md5($item->url.$item->cookies.$item->posts).".csh";
    }
  }
//   echo ":1111111111:";
//   print_r($item->page_text);
//   exit;
  $hash_dest = md5($item->url.$item->cookies.$item->posts);
  $item->hash_dest = $hash_dest;

  if (!$item->check()) {
      echo "<script> alert('" . $item->getError() . "'); window.history.go(-1); </script>\n";
      exit();
  }
  if (!$item->store()) {
      echo "<script> alert('" . $item->getError() . "'); window.history.go(-1); </script>\n";
      exit();
  }
  $item->checkin();

  $app = JFactory::getApplication();
  $app->redirect("index.php?option=com_seftranslate");


}

function save_url( $cid, $option){
  global $database, $my, $seftranslate_configuration;

//print_r($cid); exit;

  if( !JSession::checkToken()  ){
    echo "<script> alert('". _SEF_TRANSLATE_TOKEN_INVALIDE ."'); window.history.go(-1); </script>\n";
    exit ();
  }  

  $item = new mosSefurlconnect($database);

  $post = JFactory::getApplication()->input->post->getArray(array(), null, 'raw'); 
  $item->load($post['id']);
  if (!$item->bind($post)) {
      echo "<script> alert('" . $item->getError() . "'); window.history.go(-1); </script>\n";
      exit();
  }


  $hash_dest = md5($item->url_dest);
  $item->hash_dest = $hash_dest;

  if (!$item->check()) {
      echo "<script> alert('" . $item->getError() . "'); window.history.go(-1); </script>\n";
      exit();
  }
  if (!$item->store()) {
      echo "<script> alert('" . $item->getError() . "'); window.history.go(-1); </script>\n";
      exit();
  }
  $item->checkin();

  $app = JFactory::getApplication();
  $app->redirect("index.php?option=com_seftranslate&task=urls");


}


function save_phrase( $cid, $option){
  global $database, $my, $seftranslate_configuration;

//print_r($cid); exit;

  if( !JSession::checkToken()  ){
    echo "<script> alert('". _SEF_TRANSLATE_TOKEN_INVALIDE ."'); window.history.go(-1); </script>\n";
    exit ();
  }  

  $item = new mosSefentity($database);

  $post = JFactory::getApplication()->input->post->getArray(array(), null, 'raw'); 
  $item->load($post['id']);
  if (!$item->bind($post)) {
      echo "<script> alert('" . $item->getError() . "'); window.history.go(-1); </script>\n";
      exit();
  }


  if (!$item->check()) {
      echo "<script> alert('" . $item->getError() . "'); window.history.go(-1); </script>\n";
      exit();
  }
  if (!$item->store()) {
      echo "<script> alert('" . $item->getError() . "'); window.history.go(-1); </script>\n";
      exit();
  }
  $item->checkin();

  $app = JFactory::getApplication();
  $app->redirect("index.php?option=com_seftranslate&task=phrases");


}


function cancel_save_page( $cid, $option){
  global $database, $my,$seftranslate_configuration;

  if($seftranslate_configuration['cache_save_location'] == "db"){
    $item = new mosSefurl($database);
  } else {
    $item = new mosSeffile($database);
  }

//exit ;
  $id = JFactory::getApplication()->input->getInt('id',0) ;
  if (!$item->load($id)) {

      echo "<script> alert('" . $item->getError() . "'); window.history.go(-1); </script>\n";
      exit();
  }

  $item->checkin();

  $app = JFactory::getApplication();
  $app->redirect("index.php?option=com_seftranslate");
}

function cancel_save_url( $cid, $option){
  global $database, $my;

  $item = new mosSefurlconnect($database);

  $id = JFactory::getApplication()->input->getInt('id',0) ;
  if (!$item->load($id)) {
      echo "<script> alert('" . $item->getError() . "'); window.history.go(-1); </script>\n";
      exit();
  }

  $item->checkin();

  $app = JFactory::getApplication();
  $app->redirect("index.php?option=com_seftranslate&task=urls");
}

function cancel_save_phrase( $cid, $option){
  global $database, $my;

  $item = new mosSefentity($database);

  $id = JFactory::getApplication()->input->getInt('id',0) ;
  if (!$item->load($id)) {
      echo "<script> alert('" . $item->getError() . "'); window.history.go(-1); </script>\n";
      exit();
  }

  $item->checkin();

  $app = JFactory::getApplication();
  $app->redirect("index.php?option=com_seftranslate&task=phrases");
}



function pages_manage($option){
    global  $mosConfig_list_limit,$seftranslate_configuration,$database;

    $mainframe = JFactory::getApplication();

    if(empty($mosConfig_list_limit)) $mosConfig_list_limit = 100 ; 

    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);

    $manual_transl = $mainframe->getUserStateFromRequest("manual_transl{$option}", 'manual_transl', '-1');
    $base_url = $mainframe->getUserStateFromRequest("base_url{$option}", 'base_url', '-1');
    $sef_lang_filtr = $mainframe->getUserStateFromRequest("sef_lang_filtr{$option}", 'sef_lang_filtr', '-1');

    $search = $mainframe->getUserStateFromRequest("search_page{$option}", 'search_page', '');

    //$search = $database->getEscaped(trim(strtolower($search)));

    $where = array();

    if ($sef_lang_filtr != '-1') {
        array_push($where, "s.lang='$sef_lang_filtr'");
    }
    if ($manual_transl != '-1') {
        array_push($where, "s.manual_translated ='$manual_transl'");
    }
    if ($base_url != '-1') {
        array_push($where, "s.use_as_base_url ='$base_url'");
    }
    if ($search) {
        array_push($where, "(LOWER(s.url) LIKE '%$search%' )" );
    }


    if($seftranslate_configuration['cache_save_location'] == "db"){
      $database->setQuery("SELECT count(*) FROM #__seftranslate_urls s " .
            (count($where) ? "\nWHERE " . implode(' AND ', $where) : "")  );
    } else {
      $database->setQuery("SELECT count(*) FROM #__seftranslate_files s " .
            (count($where) ? "\nWHERE " . implode(' AND ', $where) : "")  );
    }
    $total = $database->loadResult();

    jimport('joomla.html.pagination');
   // require_once (JPATH_SITE . '/includes/pageNavigation.php');
   // $pageNav = new mosPageNav($total, $limitstart, $limit);
    $pageNav = new JPagination( $total, $limitstart, $limit );



    if($seftranslate_configuration['cache_save_location'] == "db"){
      $selectstring = "SELECT s.*, u.name AS editor FROM #__seftranslate_urls s" .
            "\n LEFT JOIN #__users AS u ON u.id = s.checked_out " .
            (count($where) ? "\nWHERE " . implode(' AND ', $where) : "").
            "\n ORDER BY url " .
            "\n LIMIT $pageNav->limitstart,$pageNav->limit;";
    } else {
      $selectstring = "SELECT s.*, u.name AS editor FROM #__seftranslate_files s" .
            "\n LEFT JOIN #__users AS u ON u.id = s.checked_out " .
            (count($where) ? "\nWHERE " . implode(' AND ', $where) : "").
            "\n ORDER BY url " .
            "\n LIMIT $pageNav->limitstart,$pageNav->limit;";

    }
    $database->setQuery($selectstring);
    $rows = $database->loadObjectList();


    $lang_list=parse_ini_file(JPATH_SITE."/components/com_seftranslate/languages.ini");
    $keys = array_keys( $lang_list );
    // iterate through styles
    $langs=Array();
    $t=new t_langs();
    $t->key='0';
    $t->title=_SEF_TRANSLATE_PLEASE_CHOOSE_LANGUAGE;
    $langs[$t->key]=$t;
    $t=new t_langs();
    $t->key='-1';
    $t->title=_SEF_TRANSLATE_SELECT_LANGUAGE; 
    $langs[$t->key]=$t;

    foreach( $keys as $key )
    {
      if($key!="UNKNOWN")
      {
        $t=new t_langs();
        $t->key=$lang_list[$key];
        $t->title=ucfirst(strtolower($key));
        $langs[$t->key]=$t;
      }
    }

    $sef_lang_filtr =  JHTML::_('select.genericlist',  $langs,
      'sef_lang_filtr', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'key', 'title',
       $sef_lang_filtr, 'sef_lang_filtr');

    //Manual edit or auto created
    $manual_translated[] = JHTML::_('select.option', '-1', "Manually or auto translated", 'value', 'text');
    $manual_translated[] = JHTML::_('select.option', '0', _SEF_TRANSLATE_LABEL_AUTO_GENERATED, 'value', 'text');
    $manual_translated[] = JHTML::_('select.option', '1', _SEF_TRANSLATE_LABEL_MANUAL_CHANGED, 'value', 'text');
    $manual_translated_list =  JHTML::_('select.genericlist',  $manual_translated, 'manual_transl',
      'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text',
      $manual_transl, 'manual_transl');

    $use_as_base_url[] = JHTML::_('select.option', '-1', "Base or not base pages", 'value', 'text');
    $use_as_base_url[] = JHTML::_('select.option', '0', _SEF_TRANSLATE_LABEL_NOT_USE_AS_BASE_URL, 'value', 'text');
    $use_as_base_url[] = JHTML::_('select.option', '1', _SEF_TRANSLATE_LABEL_USE_AS_BASE_URL, 'value', 'text');
    $use_as_base_url_list =  JHTML::_('select.genericlist',  $use_as_base_url, 'base_url',
      'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text',
      $base_url, 'base_url');



    HTML_seftranslate :: showPages($option, $rows, $langs, $sef_lang_filtr, $manual_translated_list,$use_as_base_url_list,  $search, $pageNav);

}

function urls_manage($option){
    global  $mosConfig_list_limit,$seftranslate_configuration,$database;

    $mainframe = JFactory::getApplication();
    
    if(empty($mosConfig_list_limit)) $mosConfig_list_limit = 100 ; 
    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);

    $manual_transl = $mainframe->getUserStateFromRequest("manual_transl{$option}", 'manual_transl', '-1');
    $sef_lang_filtr = $mainframe->getUserStateFromRequest("sef_lang_filtr{$option}", 'sef_lang_filtr', '-1');

    $search = $mainframe->getUserStateFromRequest("search{$option}", 'search', '');

    //$search = $database->getEscaped(trim(strtolower($search)));

    $where = array();
    $where_or = array();

    if ($sef_lang_filtr != '-1') {
        array_push($where, "s.lang='$sef_lang_filtr'");
    }
    if ($manual_transl != '-1') {
        array_push($where, "s.manual_translated ='$manual_transl'");
    }
    if ($search) {
        array_push($where_or, "(LOWER(s.url_dest) LIKE '%$search%' )" );
    }
    if ($search) {
        array_push($where_or, "(LOWER(s.url_origin) LIKE '%$search%' )" );
    }

    if(count($where_or) > 0 ){
        $where_str = ' ( ' . implode(' or ', $where_or) . ' ) ';
        array_push($where, $where_str );
    }

    $where_str = ((count($where)  ) ? "\nWHERE " . implode(' AND ', $where) : "") ;

    $database->setQuery("SELECT count(*) FROM #__seftranslate_url_connect s " . $where_str  ) ;
    $total = $database->loadResult();

    jimport('joomla.html.pagination');
    $pageNav = new JPagination( $total, $limitstart, $limit );


    $selectstring = "SELECT s.*, u.name AS editor FROM #__seftranslate_url_connect s" .
            "\n LEFT JOIN #__users AS u ON u.id = s.checked_out " .
            $where_str .
            "\n ORDER BY url_dest " .
            "\n LIMIT $pageNav->limitstart,$pageNav->limit;";
    $database->setQuery($selectstring);
    $rows = $database->loadObjectList();

    $lang_list=parse_ini_file(JPATH_SITE."/components/com_seftranslate/languages.ini");
    $keys = array_keys( $lang_list );
    // iterate through styles
    $langs=Array();
    $t=new t_langs();
    $t->key='0';
    $t->title= _SEF_TRANSLATE_PLEASE_CHOOSE_LANGUAGE ;
    $langs[$t->key]=$t;
    $t=new t_langs();
    $t->key='-1';
    $t->title=_SEF_TRANSLATE_SELECT_LANGUAGE;
    $langs[$t->key]=$t;

    foreach( $keys as $key )
    {
      if($key!="UNKNOWN")
      {
        $t=new t_langs();
        $t->key=$lang_list[$key];
        $t->title=ucfirst(strtolower($key));
        $langs[$t->key]=$t;
      }
    }

    $sef_lang_filtr =  JHTML::_('select.genericlist',  $langs,
      'sef_lang_filtr', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'key', 'title',
       $sef_lang_filtr, 'sef_lang_filtr');

    //Manual edit or auto created
    $manual_translated[] = JHTML::_('select.option', '-1', "Manually or auto translated", 'value', 'text');
    $manual_translated[] = JHTML::_('select.option', '0', _SEF_TRANSLATE_LABEL_AUTO_GENERATED, 'value', 'text');
    $manual_translated[] = JHTML::_('select.option', '1', _SEF_TRANSLATE_LABEL_MANUAL_CHANGED, 'value', 'text');
    $manual_translated_list =  JHTML::_('select.genericlist',  $manual_translated, 'manual_transl',
      'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text',
      $manual_transl, 'manual_transl');


    HTML_seftranslate :: showUrls($option, $rows, $langs, $sef_lang_filtr, $manual_translated_list, $search, $pageNav);

}

function phrases_manage($option){
    global  $mosConfig_list_limit,$seftranslate_configuration,$database;
    $mainframe = JFactory::getApplication();
    
    if(empty($mosConfig_list_limit)) $mosConfig_list_limit = 100 ; 
    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);

    $manual_transl = $mainframe->getUserStateFromRequest("manual_transl{$option}", 'manual_transl', '-1');

    $sef_lang_filtr_from = $mainframe->getUserStateFromRequest("sef_lang_filtr_from{$option}", 'sef_lang_filtr_from', '-1');
    $sef_lang_filtr_to = $mainframe->getUserStateFromRequest("sef_lang_filtr_to{$option}", 'sef_lang_filtr_to', '-1');

    $search = $mainframe->getUserStateFromRequest("search{$option}", 'search', '');

    $where = array();
    $where_or = array();

    if ($manual_transl != '-1') {
        array_push($where, "s.manual_translated ='$manual_transl'");
    }

    if ($sef_lang_filtr_from != '-1') {
        array_push($where, "s.lang_from='$sef_lang_filtr_from'");
    }

    if ($sef_lang_filtr_to != '-1') {
        array_push($where, "s.lang_to='$sef_lang_filtr_to'");
    }

    if ($search) {
        array_push($where_or, "(LOWER(s.entity_text) LIKE '%$search%' )" );
    }

    if(count($where_or) > 0 ){
        $where_str = ' ( ' . implode(' or ', $where_or) . ' ) ';
        array_push($where, $where_str );
    }

    $where_str = ((count($where)  ) ? "\nWHERE " . implode(' AND ', $where) : "") ;

    $database->setQuery("SELECT count(*) FROM #__seftranslate_entity s " . $where_str  ) ;
    $total = $database->loadResult();

    jimport('joomla.html.pagination');
    $pageNav = new JPagination( $total, $limitstart, $limit );


    $selectstring = "SELECT s.*, u.name AS editor FROM #__seftranslate_entity s" .
            "\n LEFT JOIN #__users AS u ON u.id = s.checked_out " .
            $where_str .
            "\n ORDER BY entity_text " .
            "\n LIMIT $pageNav->limitstart,$pageNav->limit;";
    $database->setQuery($selectstring);
    $rows = $database->loadObjectList();

    $lang_list=parse_ini_file(JPATH_SITE."/components/com_seftranslate/languages.ini");
    $keys = array_keys( $lang_list );
    // iterate through styles
    $langs=Array();
    $t=new t_langs();
    $t->key='0';
    $t->title= _SEF_TRANSLATE_PLEASE_CHOOSE_LANGUAGE ;
    $langs[$t->key]=$t;
    $t=new t_langs();
    $t->key='-1';
    $t->title=_SEF_TRANSLATE_SELECT_LANGUAGE;
    $langs[$t->key]=$t;

    foreach( $keys as $key )
    {
      if($key!="UNKNOWN")
      {
        $t=new t_langs();
        $t->key=$lang_list[$key];
        $t->title=ucfirst(strtolower($key));
        $langs[$t->key]=$t;
      }
    }

    $sef_lang_filtr_from =  JHTML::_('select.genericlist',  $langs,
      'sef_lang_filtr_from', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'key', 'title',
       $sef_lang_filtr_from, 'sef_lang_filtr_from');

    $sef_lang_filtr_to =  JHTML::_('select.genericlist',  $langs,
      'sef_lang_filtr_to', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'key', 'title',
       $sef_lang_filtr_to, 'sef_lang_filtr_to');

    //Manual edit or auto created
    $manual_translated[] = JHTML::_('select.option', '-1', "Manually or auto translated", 'value', 'text');
    $manual_translated[] = JHTML::_('select.option', '0', _SEF_TRANSLATE_LABEL_AUTO_GENERATED, 'value', 'text');
    $manual_translated[] = JHTML::_('select.option', '1', _SEF_TRANSLATE_LABEL_MANUAL_CHANGED, 'value', 'text');
    $manual_translated_list =  JHTML::_('select.genericlist',  $manual_translated, 'manual_transl',
      'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text',
      $manual_transl, 'manual_transl');


    HTML_seftranslate :: showPhrases($option, $rows, $langs, $sef_lang_filtr_from, $sef_lang_filtr_to, $manual_translated_list, $search, $pageNav);

}



function writecache($seftranslate_configuration,$mlang,$lang_list,$beforecontent)
{
  global $mainframe, $seftranslate_configuration,$seftranslate_error;


  $translator =  $seftranslate_configuration['translator'] ;

  switch($translator){
    case 'bing' :
      if ( empty($seftranslate_configuration['azure_subscription_key']) ) {
        JFactory::getApplication()->enqueueMessage( "Please set AZURE subscription key" );  
      }
      return ;
    break;
    
    case 'gtranslate' :
      if (empty($seftranslate_configuration['api_google_translate_key'])) {
        JFactory::getApplication()->enqueueMessage( "Please set google translate key" );  
      }
      return ;
    break;

    default :
      echo "some error in translator choose, please connect to developers";
      break;
  }


  $seftranslate_error = false;
  $ismainhost=$site_sub_url=substr($_SERVER['SCRIPT_NAME'],0,strpos($_SERVER['SCRIPT_NAME'] , 'index.php' ));

  $is_sef_transl_https = ( (isset($_SERVER['HTTP_X_HTTPS']) && $_SERVER['HTTP_X_HTTPS'] == 1 )
    || (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on' )
    || (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == 443 ) )?(true):(false) ;

  $site_url="http://".$_SERVER['HTTP_HOST'].$site_sub_url;
  $site_sub_url = $site_url=( ( $is_sef_transl_https )?("https://"):('http://') ).$_SERVER['HTTP_HOST'].$site_sub_url;

  $ismainhost=substr($ismainhost,0,strlen($ismainhost)-14);// administrator/=14
  $site_sub_url=substr($site_sub_url,0,strlen($site_sub_url)-14);
  $site_url=substr($site_url,0,strlen($site_url)-14);



  $def_lang=isset($seftranslate_configuration['site_language'])?$seftranslate_configuration['site_language']:'en';

  $lang_from = $def_lang ;
  $lang_to = $mlang ;

  $sepa=". _S_E_P_A_R. ";


  $ch = curl_init();
  if($seftranslate_configuration['site_map']=="joomap")
  {

    $lnk_comp="/index.php?option=com_joomap&tmpl=component";
  }
  else if($seftranslate_configuration['site_map']=="xmap")
  {

    //$lnk_comp="/index.php?option=com_xmap&sitemap=1&no_html=1";
    $lnk_comp="/index.php?option=com_xmap&view=html&id=1&tmpl=component";

  }
  else if($seftranslate_configuration['site_map']=="jmsitemap")
  {

    $lnk_comp="/index.php?option=com_jmsitemap&view=sitemap";
    curl_setopt($ch, CURLOPT_URL,CURLOPT_URL,JURI::root().$lnk_comp);
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
    if($is_sef_transl_https) curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_COOKIESESSION, TRUE);
    if (ini_get('open_basedir') == '' && ini_get('safe_mode') == 'Off')
      curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    $s=curl_exec($ch);
    curl_close($ch);
    $content="";
    $content.="<span class=\"notranslate\"><div>";
    //echo $s;

    $pos1 = stripos($s, "<div class=\"componentheading\">");
    $pos2 = strripos($s, "</ul>");
    $main_tree=substr($s,$pos1,$pos2-$pos1+5);

    $translate_tree="";
    $original=$main_tree;
    $temp_body=$main_tree;

    //foreach($map_langs as $mlang)
    {
      if($seftranslate_configuration['site_language']!=$mlang)
      {
        $arr_for_translate = array();
        $regex="[<span>.*?</span>]";
        $regex2="[>([^><].*?)<]";
        $regex3='[title="([^"]*)"]';
        preg_match($regex,$temp_body,$matches,PREG_OFFSET_CAPTURE);

        do{
          if(!isset($matches[0][0]))
          {
              $replace="";
              $temp_body=substr_replace($temp_body,$replace,0,0);
          }
          else
          {
            preg_match($regex2,$matches[0][0],$matches2,PREG_OFFSET_CAPTURE);
            $text=$matches2[1][0];
            $start_text=$matches2[1][1]+$matches[0][1];

            if(trim($text)!="")
            {
              //check translated text in database
              $ret_value = get_text_translated($text,$lang_from,$lang_to);
              if($ret_value === false )
                $arr_for_translate[]= $text;

              $replace="";
              $replace = str_repeat("X",strlen($matches[1][0])+2);
              $temp_body=substr_replace($temp_body,$replace,$matches[0][1],strlen($matches[0][0]));

            }
            else
            {
              $replace="";
              $replace = str_repeat("X",strlen($matches[1][0])+2);
              $temp_body=substr_replace($temp_body,$replace,$matches[0][1],strlen($matches[0][0]));
            }
          }
          //print_r()
          preg_match($regex,$temp_body,$matches,PREG_OFFSET_CAPTURE);

        }while(count($matches)!=0);

        // set size for translate block,  top limit;
        $high_size = 2100;
        $size_for_translat = 0 ;
        $arr_for_translate_part = array();
        //exit;
        echo "<!--";
        try
        {
          foreach($arr_for_translate as $text_for_translate){
            if( ($size_for_translat + strlen($text_for_translate) ) < $high_size )  {
              $size_for_translat = $size_for_translat + strlen($text_for_translate);
              $arr_for_translate_part[] = $text_for_translate ;
            } else {
              //translate text array
              array_text_translate($arr_for_translate_part,$lang_from,$lang_to) ;
              echo " ";
              $size_for_translat = strlen($text_for_translate);
              $arr_for_translate_part = array();
              $arr_for_translate_part[]= $text_for_translate ;
            }
          }
          if(count($arr_for_translate_part) > 0 ) array_text_translate($arr_for_translate_part,$lang_from,$lang_to) ;
          echo "-->";
        }
        //catch exception
        catch(Exception $e)
        {
            if($seftranslate_configuration['debug'] ) {
              echo 'Please try translate this page late. Now happned error at translate time: ' .$e->getMessage();
              print_r($e);
              exit;
            } else {
              echo 'Sanity check. Now happned error at translate time: ' .$e->getMessage(); exit;
            }
        }



        $temp_body=$main_tree;
        $regex="[<span>.*?</span>]";
        $regex2="[>([^><].*?)<]";
        $regex3='[title="([^"]*)"]';
        preg_match($regex,$temp_body,$matches,PREG_OFFSET_CAPTURE);

        do{
          if(!isset($matches[0][0]))
          {

            $replace="";

            $temp_body=substr_replace($temp_body,$replace,0,0);
          }
          else
          {
            preg_match($regex2,$matches[0][0],$matches2,PREG_OFFSET_CAPTURE);

            $text=$matches2[1][0];
            $start_text=$matches2[1][1]+$matches[0][1];


            if(trim($text)!="")
            {
              $replace="";

              try
              {
                $trslt=text_translate($text,$lang_from,$lang_to);
              }
              //catch exception
              catch(Exception $e)
              {
                  if($seftranslate_configuration['debug'] ) {
                    echo 'Please try translate this page late. Now happned error at translate time: ' .$e->getMessage();
                    print_r($e);
                    exit;
                  } else {
                    echo 'Sanity check. Now happned error at translate time: ' .$e->getMessage(); exit;
                  }
              }

              for($ii=1;$ii<=strlen($matches[0][0])-strlen($text)+strlen($trslt);$ii++)
              {
                $replace.="X";
              }

              $temp_body=substr_replace($temp_body,$replace,$matches[0][1],strlen($matches[0][0]));
              //$main_tree=substr_replace($main_tree,$trslt_title,$start_text_title,strlen($text_title));
              $main_tree=substr_replace($main_tree,$trslt,$start_text,strlen($text));

            }
            else
            {
              $replace="";
              for($ii=1;$ii<=strlen($matches[0][0]);$ii++)
              {
                $replace.="X";
              }
              $temp_body=substr_replace($temp_body,$replace,$matches[0][1],strlen($matches[0][0]));
            }
          }
          //print_r()
          preg_match($regex,$temp_body,$matches,PREG_OFFSET_CAPTURE);

        }while(count($matches)!=0);
        $main_tree=str_ireplace($site_sub_url,$site_sub_url.$mlang."/",$main_tree);
        $translate_tree.=$main_tree;
        $main_tree=$original;
        $temp_body=$main_tree;
      }
    }




    if($beforecontent=="")
    {
      $s=$main_tree.$translate_tree;
      $content.=$s;
    }
    else
    {
      $content=substr($beforecontent,0,strlen($beforecontent)-13).$translate_tree;
    }
    $content.="</div></span>";
    {
      $fp = fopen(JPATH_SITE."/components/com_seftranslate/map.cch"  , "w", 0); #open for writing
      fwrite($fp, $content); #write all of $data to our opened file
      fclose($fp); #close the file
    }
    return $content;
    //"
  }else
  {

    $database = JFactory::getDBO();
    $sql="Select * from #__menu WHERE menutype='mainmenu' and published=1";
    $database->setQuery($sql);
    $menus=$database->loadObjectList();
    $li_menu="";
    $content="";
    $content.="<span class=\"notranslate\"><div>";


    if($def_lang!="en")
    {
      try
      {
        $trslt=text_translate(_SEF_TRANSLATE_MAIN_MENU,$lang_from,$lang_to);
      }
      //catch exception
      catch(Exception $e)
      {
          if($seftranslate_configuration['debug'] ) {
            echo _SEF_TRANSLATE_PLEASE_TRY_TRANSLATE_THIS_PAGE_LATE.': ' .$e->getMessage();
            print_r($e);
            exit;
          } else {
            echo 'Sanity check. Now happned error at translate time: ' .$e->getMessage(); exit;
          }
      }
      $content.="<h2>".$trslt."</h2>";
    }
    else
    {
      $content.="<h2> "._SEF_TRANSLATE_MAIN_MENU." </h2>";
    }
    $content.="<ul>";
    $s_translate=Array();
    foreach($menus as $menu)
    {
      $li_menu.="<li><a href=\"".$menu->link."\" title=\"".$menu->alias."\">".$menu->alias."</a></li>";
      $s_translate[]=$menu->alias;
    }
    $content.=$li_menu;
    $content.="</ul>";

//    $titls=implode($sepa,$s_translate);
    if($beforecontent!="")
    {
      $content="";
    }
    //foreach($map_langs as $mlang)
    {
      try
      {
        $translate=array_text_translate($s_translate,$lang_from,$lang_to);
        //$translate=explode($sepa,text_translate($titls,$lang_from,$lang_to));
        $content.="<h2>".text_translate("Main menu",$lang_from,$lang_to)."</h2><ul>";
      }
      //catch exception
      catch(Exception $e)
      {
          if($seftranslate_configuration['debug'] ) {
            echo _SEF_TRANSLATE_PLEASE_TRY_TRANSLATE_THIS_PAGE_LATE.': ' .$e->getMessage();
            print_r($e);
            exit;
          } else {
            echo 'Sanity check. Now happned error at translate time: ' .$e->getMessage(); exit;
          }
      }

      $li_menu="";
      $i=0;
      foreach($menus as $menu)
      {
        $let=explode("http:",$menu->link);
        $li_menu.="<li><a href=\"".((count($let)<=1)?$mlang."/":"" ).$menu->link."\" title=\"".$translate[$i]."\">".$translate[$i]."</a></li>";
        $i++;
      }
      $content.=$li_menu;

      $content.="</ul>";
    }

    $content=str_ireplace("<a ",'<a onClick="go_link()"',$content);

    if($beforecontent!="")
    {
      $content=substr($beforecontent,0,strlen($beforecontent)-13).$content;
    }
    $content.="</div></span>";
    {
      $fp = fopen(JPATH_SITE."/components/com_seftranslate/map.cch"  , "w", 0); #open for writing
      fwrite($fp, $content); #write all of $data to our opened file
      fclose($fp); #close the file
    }
    return $content;
  }

  curl_setopt($ch, CURLOPT_URL,JURI::root().$lnk_comp);
  curl_setopt($ch, CURLOPT_HEADER, 0);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
  if($is_sef_transl_https) curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
  curl_setopt($ch, CURLOPT_COOKIESESSION, TRUE);
  if (ini_get('open_basedir') == '' && ini_get('safe_mode') == 'Off')
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
  curl_setopt($ch, CURLOPT_POSTFIELDS, "tmpl=component");
  curl_setopt($ch, CURLOPT_POST, true);
  $s=curl_exec($ch);
  curl_close($ch);
//    echo JURI::root().$lnk_comp;
//    echo $s;
  if(trim($s) == "" ) {
    echo "<strong style='color:red'>"._SEF_TRANSLATE_PLEASE_PLEASE_CONFIGURE_YOURS_MAP_COMPONENT."</strong>";
    return;
  }


  $pos1 = stripos($s, "<h2");
  $pos2 = strripos($s, "</ul>");
  $main_tree=substr($s,$pos1,$pos2-$pos1+5);

  $translate_tree="";
  $original=$main_tree;
  $temp_body=$main_tree;

  //foreach($map_langs as $mlang)
  {
    if($seftranslate_configuration['site_language']!=$mlang)
    {
      $arr_for_translate = array();
      $regex="[<a.*?>.*?</a>]";
      $regex2="[>([^><].*?)<]";
      $regex3='[title="([^"]*)"]';
      preg_match($regex,$temp_body,$matches,PREG_OFFSET_CAPTURE);

      do{
        if(!isset($matches[0][0]))
        {
            $replace="";
            $temp_body=substr_replace($temp_body,$replace,0,0);
        }
        else
        {
          preg_match($regex2,$matches[0][0],$matches2,PREG_OFFSET_CAPTURE);
          preg_match($regex3,$matches[0][0],$matches3,PREG_OFFSET_CAPTURE);
          $text=$matches2[1][0];
          $start_text=$matches2[1][1]+$matches[0][1];
          $text_title=$matches3[1][0];

          $start_text_title=$matches3[1][1]+$matches[0][1];

          if(trim($text)!="")
          {
            //check translated text in database
            $ret_value = get_text_translated($matches[1][0],$lang_from,$lang_to);
            if($ret_value === false )
              $arr_for_translate[]= $matches[1][0] ;

            $replace="";
            $replace = str_repeat("X",strlen($matches[1][0])+2);
            $temp_body=substr_replace($temp_body,$replace,$matches[0][1],strlen($matches[0][0]));
          }
          else
          {
            $replace="";
            $replace = str_repeat("X",strlen($matches[1][0])+2);
            $temp_body=substr_replace($temp_body,$replace,$matches[0][1],strlen($matches[0][0]));
          }
        }
        //print_r()
        preg_match($regex,$temp_body,$matches,PREG_OFFSET_CAPTURE);

      }while(count($matches)!=0);


      // set size for translate block,  top limit;
      $high_size = 2100;
      $size_for_translat = 0 ;
      $arr_for_translate_part = array();
      //exit;
      echo "<!--";
      try
      {
        foreach($arr_for_translate as $text_for_translate){
          if( ($size_for_translat + strlen($text_for_translate) ) < $high_size )  {
            $size_for_translat = $size_for_translat + strlen($text_for_translate);
            $arr_for_translate_part[] = $text_for_translate ;
          } else {
            //translate text array
            array_text_translate($arr_for_translate_part,$lang_from,$lang_to) ;
            echo " ";
            $size_for_translat = strlen($text_for_translate);
            $arr_for_translate_part = array();
            $arr_for_translate_part[]= $text_for_translate ;
          }
        }
        if(count($arr_for_translate_part) > 0 ) array_text_translate($arr_for_translate_part,$lang_from,$lang_to) ;
        echo "-->";
      }
      //catch exception
      catch(Exception $e)
      {
          if($seftranslate_configuration['debug'] ) {
            echo _SEF_TRANSLATE_PLEASE_TRY_TRANSLATE_THIS_PAGE_LATE.': ' .$e->getMessage();
            print_r($e);
            exit;
          } else {
            echo 'Sanity check. Now happned error at translate time: ' .$e->getMessage(); exit;
          }
      }


      $temp_body=$main_tree;
      $regex="[<a.*?>.*?</a>]";
      $regex2="[>([^><].*?)<]";
      $regex3='[title="([^"]*)"]';
      preg_match($regex,$temp_body,$matches,PREG_OFFSET_CAPTURE);

      do{
        if(!isset($matches[0][0]))
        {
            $replace="";
            $temp_body=substr_replace($temp_body,$replace,0,0);
        }
        else
        {
          preg_match($regex2,$matches[0][0],$matches2,PREG_OFFSET_CAPTURE);
          preg_match($regex3,$matches[0][0],$matches3,PREG_OFFSET_CAPTURE);
          $text=$matches2[1][0];
          $start_text=$matches2[1][1]+$matches[0][1];
          $text_title=$matches3[1][0];

          $start_text_title=$matches3[1][1]+$matches[0][1];

          if(trim($text)!="")
          {
            $replace="";

            try
            {
              $trslt=text_translate($text,$lang_from,$lang_to);
              //$trslt_title=text_translate($text_title,$lang_from,$lang_to);
            }
            //catch exception
            catch(Exception $e)
            {
                if($seftranslate_configuration['debug'] ) {
                  echo _SEF_TRANSLATE_PLEASE_TRY_TRANSLATE_THIS_PAGE_LATE.': ' .$e->getMessage();
                  print_r($e);
                  exit;
                } else {
                  echo 'Sanity check. Now happned error at translate time: ' .$e->getMessage(); exit;
                }
            }

            for($ii=1;$ii<=strlen($matches[0][0])-strlen($text)+strlen($trslt);$ii++)
            {
              $replace.="X";
            }

            $temp_body=substr_replace($temp_body,$replace,$matches[0][1],strlen($matches[0][0]));
            //$main_tree=substr_replace($main_tree,$trslt_title,$start_text_title,strlen($text_title));
            $main_tree=substr_replace($main_tree,$trslt,$start_text,strlen($text));

          }
          else
          {
            $replace="";
            for($ii=1;$ii<=strlen($matches[0][0]);$ii++)
            {
              $replace.="X";
            }
            $temp_body=substr_replace($temp_body,$replace,$matches[0][1],strlen($matches[0][0]));
          }
        }
        //print_r()
        preg_match($regex,$temp_body,$matches,PREG_OFFSET_CAPTURE);

      }while(count($matches)!=0);

      //if($ismainhost=="/")
      {

      $body=$main_tree;
      $temp_link=$main_tree;
      $regex="!href=\"(.*?)\"!si";
      preg_match($regex,$temp_link,$matches,PREG_OFFSET_CAPTURE);
      do{
        //echo $temp_link;
        //echo  $matches[0][1] ." _ ".strlen($matches[0][0]);
        $replace="";
        if((strpos($matches[1][0],"http:")===false)AND(strpos($matches[1][0],"javascript:")===false))
        {
          for($ii=1;$ii<=strlen($matches[0][0])+strlen($mlang."/");$ii++)
          {
            $replace.="X";
          }
          $temp_link=substr_replace($temp_link,$replace,$matches[0][1],strlen($matches[0][0]));
          $body=substr_replace($body,$ismainhost.$mlang."/",$matches[1][1],strlen($ismainhost));
        }
        else
        {
          for($ii=1;$ii<=strlen($matches[0][0]);$ii++)
          {
            $replace.="X";
          }
          $temp_link=substr_replace($temp_link,$replace,$matches[0][1],strlen($matches[0][0]));
        }
        preg_match($regex,$temp_link,$matches,PREG_OFFSET_CAPTURE);


      }while(count($matches)!=0);
      $main_tree=$body;
      }
      $main_tree=str_ireplace($site_url,$site_url.$mlang."/",$main_tree);
    //  $main_tree=str_ireplace($site_sub_url,$site_sub_url.$mlang."/",$main_tree);
      $translate_tree.=$main_tree;
      $main_tree=$original;
      $temp_body=$main_tree;
    }
  }


  if($beforecontent=="")
  {
    $s=substr($s,0,$pos2+5).$translate_tree.substr($s,$pos2+5,strlen($s));
    $content="";
    $content.="<span class=\"notranslate\"><div>".$s;
    $content.="</div></span>";
  }
  else
  {
    $pos2 = strripos($beforecontent, "</ul>");
    $s=substr($beforecontent,0,$pos2+5).$translate_tree.substr($s,$pos2+5,strlen($s));
    $content="";
    $content.="<span class=\"notranslate\"><div>".$s;
    $content.="</div></span>";

  }

  //if($seftranslate_configuration['cache_map'])
  if(!$seftranslate_error)
  {
    $fp = fopen(JPATH_SITE."/components/com_seftranslate/map.cch"  , "w", 0); #open for writing
    fwrite($fp, $content); #write all of $data to our opened file
    fclose($fp); #close the file
  }
  return $content;
}


function add_lang()
{
  global $mainframe,$os_sef_state;

  if(!isset($os_sef_state->data) ){
      echo '<script>alert("'. _SEF_TRANSLATE_DEBUG_YOUR_LICENSE_NEED_ACTIVE .'"); history.back(); </script>';
      return ;
  }  

  $contents="";
  $seftranslate_configuration=Array();
  {
    require_once(JPATH_SITE."/components/com_seftranslate/languages.conf.php");
  }
  $lang_list=parse_ini_file(JPATH_SITE."/components/com_seftranslate/languages.ini");
  if((is_file(JPATH_SITE."/components/com_seftranslate/map.cch"))and($contents==""))
  {
    $fp = fopen(JPATH_SITE."/components/com_seftranslate/map.cch", "r");
    $contents = fread($fp, filesize(JPATH_SITE."/components/com_seftranslate/map.cch"));
    fclose($fp);

  }
  if(isset($_REQUEST['map_lang_add']))
  {
    $contents=writecache($seftranslate_configuration,$_REQUEST['map_lang_add'],$lang_list,$contents);

  }

  $keys = array_keys( $lang_list );
  $langs=Array();
  foreach( $keys as $key )
  {
    if($key!="UNKNOWN")
    {
      $t=new t_langs();
      $t->key=$lang_list[$key];
      $t->title=ucfirst(strtolower($key));
      $langs[]=$t;
    }
  }


?>
<form action="index.php?option=com_seftranslate&act=integration" method="post" name="adminForm"  id="adminForm"  >
  <script>
    function viewsitemap()
    {
      if( document.getElementById("shdiv").value=="+")
      {
        document.getElementById("shdiv").value="-";
        document.getElementById("contexsitemap").style.display = 'block';
      }
      else
      {
        document.getElementById("shdiv").value="+";
        document.getElementById("contexsitemap").style.display = 'none';

      }
    }
  </script>
  <table width="100%">
  <tr>
    <td valign="top">SiteMap:</td>
    <td><input type="button" id="shdiv" value="-" onclick="viewsitemap()"><div id="contexsitemap" style="display:none"><?php echo $contents; ?></div></td>
  <tr>
  <tr>
    <td>Add language:</td>
    <td><?php echo JHTML::_('select.genericlist',  $langs, 'map_lang_add', 'class="inputbox" ', 'key', 'title', 'uk', 'map_lang_add'); ?></td>
  <tr>
  </table>
<?php

?>

  <input name="task" id="task" value="apply" type="hidden">
  <input name="option" id="option" value="com_seftranslate" type="hidden">
  </form>
<?php

}

function clear_cache()
{
  global $database,$my,$os_sef_state;

  if(!isset($os_sef_state->data) ){
      echo '<script>alert("'. _SEF_TRANSLATE_DEBUG_YOUR_LICENSE_NEED_ACTIVE .'"); history.back(); </script>';
      return ;
  }  

  //delete cache from database
  $database->setQuery("delete from #__seftranslate_urls ".
            "\nWHERE (checked_out=0 OR (checked_out='$my->id')) ".
            " and manual_translated = '0' and  use_as_base_url = '0' ");
  $database->execute();

  //delete cache from files
  $query = "select id FROM #__seftranslate_files".
            "\nWHERE (checked_out=0 OR (checked_out='$my->id')) ".
            " and manual_translated = '0' and  use_as_base_url = '0' ";
  $database->setQuery($query);
  $result = $database->loadObjectList();
  $item_tmp = new mosSeffile($database);
  
  foreach ($result as $row) {
    $item_tmp->load( $row->id );
    $filename = JPATH_SITE."/components/com_seftranslate/cache/".$item_tmp->file_name ;
    //if (file_exists($filename) )  
    unlink($filename);
    $item_tmp->delete();
  }

  //delete cache for urls
  $query = "delete FROM #__seftranslate_url_connect".
            "\nWHERE (checked_out=0 OR (checked_out='$my->id')) ".
            " and manual_translated = '0'  ";
  $database->setQuery($query);
  $result = $database->execute();  

  JFactory::getApplication()->enqueueMessage( _SEF_TRANSLATE_CACHE_IS_CLEARED );  

}

function clear_map()
{
  if( !JSession::checkToken()  ){
    echo "<script> alert('". _SEF_TRANSLATE_TOKEN_INVALIDE ."'); window.history.go(-1); </script>\n";
    exit ();
  }

  if(is_file(JPATH_SITE."/components/com_seftranslate/map.cch"))
  {
    unlink(JPATH_SITE."/components/com_seftranslate/map.cch");
  }

  JFactory::getApplication()->enqueueMessage( _SEF_TRANSLATE_CACHE_IS_CLEARED );

}

function apply()
{
  global $os_sef_state,$seftranslate_configuration;

  if(!isset($os_sef_state->data) ){
      echo '<script>alert("'. _SEF_TRANSLATE_DEBUG_YOUR_LICENSE_NEED_ACTIVE .'"); history.back(); </script>';
      return ;
  }  


  if( !JSession::checkToken()  ){
    echo "<script> alert('". _SEF_TRANSLATE_TOKEN_INVALIDE ."'); window.history.go(-1); </script>\n";
    exit ();
  }

  $seftranslate_configuration['release']['version']=ArrayHelper::getValue($_REQUEST,'release_version',"");
  $seftranslate_configuration['site_language']=ArrayHelper::getValue($_REQUEST,'site_language',"en");
  $seftranslate_configuration['cache_time']=ArrayHelper::getValue($_REQUEST,'cache_time',"900");
  $seftranslate_configuration['cashing']=ArrayHelper::getValue($_REQUEST,'cashing',"1");
  $seftranslate_configuration['userip']=ArrayHelper::getValue($_REQUEST,'userip',"1");
  $seftranslate_configuration['map_lang']=implode("|",ArrayHelper::getValue($_REQUEST,'map_lang',"en") );
  $seftranslate_configuration['not_translate']=ArrayHelper::getValue($_REQUEST,'not_translate',"");
  $seftranslate_configuration['not_cache']=ArrayHelper::getValue($_REQUEST,'not_cache',"");
  $seftranslate_configuration['not_page']=ArrayHelper::getValue($_REQUEST,'not_page',"");
  $seftranslate_configuration['api_google_translate_key']=ArrayHelper::getValue($_REQUEST,'api_google_translate_key',"");
  $seftranslate_configuration['api_bing_client_secret']=ArrayHelper::getValue($_REQUEST,'api_bing_client_secret',"");
  $seftranslate_configuration['api_bing_client_id']=ArrayHelper::getValue($_REQUEST,'api_bing_client_id',"");
  $seftranslate_configuration['azure_subscription_key']=ArrayHelper::getValue($_REQUEST,'azure_subscription_key',"");
  $seftranslate_configuration['azure_region']=ArrayHelper::getValue($_REQUEST,'azure_region',"");
  $seftranslate_configuration['yandex_security_api_key']=ArrayHelper::getValue($_REQUEST,'yandex_security_api_key',"");
  $seftranslate_configuration['use_notag']=ArrayHelper::getValue($_REQUEST,'use_notag',"0");
  $seftranslate_configuration['detect_source_lang']=ArrayHelper::getValue($_REQUEST,'detect_source_lang',"0");
  $seftranslate_configuration['debug']=ArrayHelper::getValue($_REQUEST,'debug',"0");
  $seftranslate_configuration['site_map']=ArrayHelper::getValue($_REQUEST,'site_map',"0");
  $seftranslate_configuration['cache_map']=ArrayHelper::getValue($_REQUEST,'cache_map',"0");

  // $seftranslate_configuration['clear_get']=ArrayHelper::getValue($_REQUEST,'clear_get',"");
  $seftranslate_configuration['clear_post']=ArrayHelper::getValue($_REQUEST,'clear_post',"");
  $seftranslate_configuration['clear_cookie']=ArrayHelper::getValue($_REQUEST,'clear_cookie',"");

  // $seftranslate_configuration['all_get']=ArrayHelper::getValue($_REQUEST,'all_get',"0");
  $seftranslate_configuration['all_post']=ArrayHelper::getValue($_REQUEST,'all_post',"0");
  $seftranslate_configuration['all_cookie']=ArrayHelper::getValue($_REQUEST,'all_cookie',"0");
  $seftranslate_configuration['update']=ArrayHelper::getValue($_REQUEST,'update',"1");
  $seftranslate_configuration['cache_save_location']=ArrayHelper::getValue($_REQUEST,'cache_save_location',"db");
  $seftranslate_configuration['translate_algorithm']=ArrayHelper::getValue($_REQUEST,'translate_algorithm',"1");
  $seftranslate_configuration['translator']=ArrayHelper::getValue($_REQUEST,'translator',"bing");
  $seftranslate_configuration['compatible_with_joomla_multi_lang']=ArrayHelper::getValue($_REQUEST,'compatible_with_joomla_multi_lang',"0");
  $seftranslate_configuration['compatible_with_falang_multi_lang']=ArrayHelper::getValue($_REQUEST,'compatible_with_falang_multi_lang',"0");
  $seftranslate_configuration['translate_iframes']=ArrayHelper::getValue($_REQUEST,'translate_iframes',"0");
  $seftranslate_configuration['translate_urls']=ArrayHelper::getValue($_REQUEST,'translate_urls',"0");
  $seftranslate_configuration['last_language']=ArrayHelper::getValue($_REQUEST,'last_language',"0");


  //ArrayHelper::getValue($_REQUEST,'cashing',"1");
  setSefParams($seftranslate_configuration);

  JFactory::getApplication()->enqueueMessage( _SEF_TRANSLATE_SETTINGS_IS_SAVED );  

  // $app = JFactory::getApplication();
  // $app->redirect("index.php?option=com_seftranslate&task=config");

}

function setSefParams($seftranslate_configuration)
{


    $set = "<?php\n";
    $set .= "// Do not edit this file. Generated by admin script.\n";
    $set .= "// Translate Configuration file\n";
    $set .= "// General Informations \n";
    $set .= "\$seftranslate_configuration['release']['version']='" . $seftranslate_configuration['release']['version'] ."';\n";
    $set .= "\$seftranslate_configuration['site_language']='" . $seftranslate_configuration['site_language'] ."';\n";
    $set .= "\$seftranslate_configuration['cache_time']='" . $seftranslate_configuration['cache_time'] ."';\n";
    $set .= "\$seftranslate_configuration['cashing']='" . $seftranslate_configuration['cashing'] ."';\n";
    $set .= "\$seftranslate_configuration['userip']='" . $seftranslate_configuration['userip'] ."';\n";
    $set .= "\$seftranslate_configuration['map_lang']='" . $seftranslate_configuration['map_lang'] ."';\n";
    $set .= "\$seftranslate_configuration['not_translate']='" . trim($seftranslate_configuration['not_translate']) ."';\n";
    $set .= "\$seftranslate_configuration['not_cache']='" . trim($seftranslate_configuration['not_cache']) ."';\n";
    $set .= "\$seftranslate_configuration['not_page']='" . trim($seftranslate_configuration['not_page']) ."';\n";
    $set .= "\$seftranslate_configuration['api_google_translate_key']='" . $seftranslate_configuration['api_google_translate_key'] ."';\n";
    $set .= "\$seftranslate_configuration['api_bing_client_secret']='" . $seftranslate_configuration['api_bing_client_secret'] ."';\n";
    $set .= "\$seftranslate_configuration['api_bing_client_id']='" . $seftranslate_configuration['api_bing_client_id'] ."';\n";
    $set .= "\$seftranslate_configuration['azure_subscription_key']='" . $seftranslate_configuration['azure_subscription_key'] ."';\n";
    $set .= "\$seftranslate_configuration['azure_region']='" . $seftranslate_configuration['azure_region'] ."';\n";
    $set .= "\$seftranslate_configuration['yandex_security_api_key']='" . $seftranslate_configuration['yandex_security_api_key'] ."';\n";    
    $set .= "\$seftranslate_configuration['use_notag']='" . $seftranslate_configuration['use_notag'] ."';\n";
    $set .= "\$seftranslate_configuration['detect_source_lang']='" . $seftranslate_configuration['detect_source_lang'] ."';\n";
    $set .= "\$seftranslate_configuration['debug']='" . $seftranslate_configuration['debug'] ."';\n";
    $set .= "\$seftranslate_configuration['site_map']='" . $seftranslate_configuration['site_map'] ."';\n";
    $set .= "\$seftranslate_configuration['cache_map']='" . $seftranslate_configuration['cache_map']."';\n";
//    $set .= "\$seftranslate_configuration['all_get']='" . $seftranslate_configuration['all_get']."';\n";
//    $set .= "\$seftranslate_configuration['clear_get']='" . $seftranslate_configuration['clear_get']."';\n";
    $set .= "\$seftranslate_configuration['all_post']='" . $seftranslate_configuration['all_post']."';\n";
    $set .= "\$seftranslate_configuration['clear_post']='" . trim($seftranslate_configuration['clear_post'])."';\n";
    $set .= "\$seftranslate_configuration['all_cookie']='" . $seftranslate_configuration['all_cookie']."';\n";
    $set .= "\$seftranslate_configuration['clear_cookie']='" . trim($seftranslate_configuration['clear_cookie'])."';\n";
    $set .= "\$seftranslate_configuration['update']='" . trim($seftranslate_configuration['update'])."';\n";
    $set .= "\$seftranslate_configuration['cache_save_location']='" . trim($seftranslate_configuration['cache_save_location'])."';\n";
    $set .= "\$seftranslate_configuration['translate_algorithm']='" . trim($seftranslate_configuration['translate_algorithm'])."';\n";
    $set .= "\$seftranslate_configuration['translator']='" . trim($seftranslate_configuration['translator'])."';\n";
    $set .= "\$seftranslate_configuration['compatible_with_joomla_multi_lang']='" . $seftranslate_configuration['compatible_with_joomla_multi_lang']."';\n";
    $set .= "\$seftranslate_configuration['compatible_with_falang_multi_lang']='" . $seftranslate_configuration['compatible_with_falang_multi_lang']."';\n";
    $set .= "\$seftranslate_configuration['translate_iframes']='" . $seftranslate_configuration['translate_iframes']."';\n";
    $set .= "\$seftranslate_configuration['translate_urls']='" . $seftranslate_configuration['translate_urls']."';\n";
    $set .= "\$seftranslate_configuration['last_language']='" . $seftranslate_configuration['last_language']."';\n";
    $set .= "?>";


    $fd = fopen(JPATH_SITE."/components/com_seftranslate/languages.conf.php", "w" );
    fwrite( $fd, $set );
    fclose( $fd );
}

function setting()
{
  global $seftranslate_configuration;

?>
  <form action="index.php?option=com_seftranslate&act=integration" method="post" name="adminForm"  id="adminForm" >
  <?php
  if (version_compare(JVERSION, '4.0.0', 'ge')) {

    //Create Pane, tab
    echo JHtml::_('bootstrap.startTabSet', 'settingsPane', array('active' => 'panel_1_id'));
    echo JHtml::_('bootstrap.addTab', 'settingsPane', 'panel_1_id', JText::_('General'));
    settingGeneral($seftranslate_configuration);
    echo JHtml::_('bootstrap.endTab');

    echo JHtml::_('bootstrap.addTab', 'settingsPane', 'panel_2_id', JText::_('Cache') );
    settingsCache($seftranslate_configuration);
    echo JHtml::_('bootstrap.endTab');

    echo JHtml::_('bootstrap.addTab', 'settingsPane', 'panel_3_id', JText::_('Map') );
    settingsMap($seftranslate_configuration);
    echo JHtml::_('bootstrap.endTab');
    echo JHtml::_('bootstrap.endTabSet');


  } elseif (version_compare(JVERSION, '3.0.0', 'ge')) {
    jimport( 'joomla.html.html.tabs' );
    //Get JPaneTabs instance


    //Create Pane
    $options = Array();
    echo JHtml::_('tabs.start', 'tab_group_id', $options);
    //Create 1st Tab
    echo JHtml::_('tabs.panel', JText::_('General'), 'panel_1_id');
    settingGeneral($seftranslate_configuration);
    //Create 2nd Tab
    echo JHtml::_('tabs.panel', JText::_('Cache'), 'panel_2_id');
    settingsCache($seftranslate_configuration);
    //Create 3rd Tab
    echo JHtml::_('tabs.panel', JText::_('Map'), 'panel_3_id');
    settingsMap($seftranslate_configuration);


    //End Pane
    echo JHtml::_('tabs.end');
  } else {
    jimport('joomla.html.pane');
    //Get JPaneTabs instance
    $myTabs =  JPane::getInstance('tabs', array('startOffset'=>0));
    $output = '';
    //Create Pane
    echo $myTabs->startPane( 'pane' );
    //Create 1st Tab
    echo $myTabs->startPanel( 'General', 'tab1' );
    settingGeneral($seftranslate_configuration);
    echo $myTabs->endPanel();
    //Create 2nd Tab
    echo $myTabs->startPanel( 'Cache', 'tab2' );
    settingsCache($seftranslate_configuration);
    echo $myTabs->endPanel();
    //Create 3rd Tab
    echo $myTabs->startPanel('Sitemap', 'tab3' );
    settingsMap($seftranslate_configuration);
    echo $myTabs->endPanel();

    //End Pane
    echo $myTabs->endPane();

  }

?>

  <input name="task" id="task" value="apply" type="hidden">
  <input name="option" id="option" value="com_seftranslate" type="hidden">
  <?php echo \JHtml::_('form.token'); ?>

  </form>
<?php
}

function settingGeneral($seftranslate_configuration)
{
 global $seftranslate_configuration;

    $lang_list=parse_ini_file(JPATH_SITE."/components/com_seftranslate/languages.ini");
    $keys = array_keys( $lang_list );
    // iterate through styles
    $langs=Array();
    foreach( $keys as $key )
    {
      if($key!="UNKNOWN")
      {
        $t=new t_langs();
        $t->key=$lang_list[$key];
        $t->title=ucfirst(strtolower($key));
        $langs[]=$t;
      }
    }

  ?>
  <table>
    <tr>
      <td><?php echo _SEF_TRANSLATE_WEBSITE_MAIN_LANGUAGE; ?></td>
      <td>
        <?php  echo '<input type="hidden" value="'.$seftranslate_configuration['release']['version'].'" name="release_version" />';      ?>
        <?php
        echo JHTML::_('select.genericlist',  $langs, 'site_language', '', 'key', 'title', $seftranslate_configuration['site_language'], 'site_language' );
        ?>
      </td>
      <td>
    <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Select main language of your website" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td><?php echo _SEF_TRANSLATE_TRANSLATION_ALGORITHM; ?></td>
      <td>
      <?php
    $algorithm[] = JHTML::_('select.option', '1', "1", 'value', 'text');
    $algorithm[] = JHTML::_('select.option', '2', '2', 'value', 'text');
    $algorithm[] = JHTML::_('select.option', '3', '3', 'value', 'text');
    $algorithm_list =  JHTML::_('select.genericlist',  $algorithm, 'translate_algorithm', 'class="inputbox" size="1" ', 'value', 'text', $seftranslate_configuration['translate_algorithm'], 'translate_algorithm');
    echo $algorithm_list;
    ?>
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'._SEF_TRANSLATE_YOU_SHOULD_CHECK_WHAT_ALGORITHM.'" alt="info">';?>
      </td>
    <tr>

    <tr>
      <td><?php echo _SEF_TRANSLATE_NO_TRANSLATE_PHRASES; ?>:</td>
      <td>
        <textarea  name="not_translate" cols="51" rows="10" ><?php echo $seftranslate_configuration['not_translate']; ?></textarea>
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'._SEF_TRANSLATE_SET_BY_COMA_WORD.'" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td><?php echo _SEF_TRANSLATE_NOT_CACHE_PAGES; ?></td>
      <td>
        <textarea  name="not_cache" cols="51" rows="10" ><?php echo $seftranslate_configuration['not_cache']; ?> </textarea>
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" '.
    ' title="'._SEF_TRANSLATE_WRITE_URLS_OF_PAGES.'" alt="info">';?>
      </td>
    </tr>    
    <tr>
      <td><?php echo _SEF_TRANSLATE_UNTRANSLATABLE_PAGES; ?></td>
      <td>
        <textarea  name="not_page" cols="51" rows="10" ><?php echo $seftranslate_configuration['not_page']; ?> </textarea>
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'._SEF_TRANSLATE_WRITE_URLS_OF_PAGES.'" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td><?php echo _SEF_TRANSLATE_PLACE_TO_SAVE_CACHE; ?></td>
      <td>
      <?php
    $cache_save[] = JHTML::_('select.option', 'db', "Database", 'value', 'text');
    $cache_save[] = JHTML::_('select.option', 'files', 'Files', 'value', 'text');
    $cache_save_list =  JHTML::_('select.genericlist',  $cache_save, 'cache_save_location', 'class="inputbox" size="1" ', 'value', 'text', $seftranslate_configuration['cache_save_location'], 'cache_save_location');
    echo $cache_save_list;
    ?>
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'._SEF_TRANSLATE_CHOOSE_PLACE_TO_SAVE_CACHE.'" alt="info">';?>
      </td>
    <tr>
    <tr>
      <td><?php echo _SEF_TRANSLATE_CHOOSE_BING_OR; ?></td>
      <td>
      <?php
    $translator[] = JHTML::_('select.option', 'bing', "Bing", 'value', 'text');
    $translator[] = JHTML::_('select.option', 'gtranslate', 'Google', 'value', 'text');
    $translator[] = JHTML::_('select.option', 'yandex', 'Yandex', 'value', 'text');
    $translator_list =  JHTML::_('select.genericlist',  $translator, 'translator', 'class="inputbox" size="1" ', 'value', 'text', $seftranslate_configuration['translator'], 'translator');
    echo $translator_list;
    ?>
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'._SEF_TRANSLATE_CHOOSE_BING_OR_GOOGLE.'" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td><?php echo _SEF_TRANSLATE_GOOGLE_API_KEY; ?></td>
      <td>
        <input type="text"  name="api_google_translate_key" size="60" value="<?php echo $seftranslate_configuration['api_google_translate_key']; ?>" />
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'._SEF_TRANSLATE_SET_KEY_FOR_GOOGLE_TRANSLATE.'" alt="info">';?>
      </td>
    </tr>
    <!--tr>
      <td>Bing API Client Secret</td>
      <td>
        <input type="text"  name="api_bing_client_secret" size="60" value="<?php echo $seftranslate_configuration['api_bing_client_secret']; ?>" />
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Insert Client Secret for Bing Translator" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td>Bing API Client ID</td>
      <td>
        <input type="text"  name="api_bing_client_id" size="60" value="<?php echo $seftranslate_configuration['api_bing_client_id']; ?>" />
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Set client ID for Bing Translator" alt="info">';?>
      </td>
    </tr-->
    <tr>
      <td><?php echo _SEF_TRANSLATE_AZURE_SUBSCRIPTION_KEY; ?></td>
      <td>
        <input type="text"  name="azure_subscription_key" size="60" value="<?php echo $seftranslate_configuration['azure_subscription_key']; ?>" />
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'._SEF_TRANSLATE_SET_SUBSCRIPTION_KEY_FOR_AZURE.'" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td><?php echo _SEF_TRANSLATE_AZURE_REGION; ?></td>
      <td>
        <input type="text"  name="azure_region" size="20" value="<?php echo $seftranslate_configuration['azure_region']; ?>" />
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'._SEF_TRANSLATE_SET_REGION_FOR_AZURE.'" alt="info">';?>
      </td>
    </tr>

    <tr>
      <td><?php echo _SEF_TRANSLATE_YANDEX_SECURITY_API_KEY; ?></td>
      <td>
        <input type="text"  name="yandex_security_api_key" size="20" value="<?php echo $seftranslate_configuration['yandex_security_api_key']; ?>" />
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'._SEF_TRANSLATE_YANDEX_SECURITY_API_KEY_INFO.'" alt="info">';?>
      </td>
    </tr>

    <tr>
      <td><?php echo _SEF_TRANSLATE_REMEMBER_LANGUAGE; ?></td>
      <td>
        <fieldset id="jform_last_language" class="radio btn-group">
        <input type="radio" name="last_language" id="jform_last_language_01" value="0"
        <?php echo ($seftranslate_configuration['last_language'] == 0) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_last_language_01" style="clear:none"><?php echo _SEF_TRANSLATE_NO; ?></label>
        <input type="radio" name="last_language" id="jform_last_language_02" value="1"
        <?php echo ($seftranslate_configuration['last_language'] == 1) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_last_language_02" style="clear:none"><?php echo _SEF_TRANSLATE_YES; ?></label>
        </fieldset>
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'._SEF_TRANSLATE_WHETHER_YOU_NEED_REMEMBER_LANGUAGE.'" alt="info">';?>
      </td>
    </tr>
    
    <tr>
      <td><?php echo _SEF_TRANSLATE_JOOMLA_MULTI_LANGUAGE; ?>:</td>
      <td>
        <fieldset id="jform_compatible_with_joomla_multi_lang" class="radio btn-group">
        <input type="radio" name="compatible_with_joomla_multi_lang" id="jform_compatible_with_joomla_multi_lang_01" value="0"
        <?php echo ($seftranslate_configuration['compatible_with_joomla_multi_lang'] == 0) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_compatible_with_joomla_multi_lang_01" style="clear:none"><?php echo _SEF_TRANSLATE_NO; ?></label>
        <input type="radio" name="compatible_with_joomla_multi_lang" id="jform_compatible_with_joomla_multi_lang_02" value="1"
        <?php echo ($seftranslate_configuration['compatible_with_joomla_multi_lang'] == 1) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_compatible_with_joomla_multi_lang_02" style="clear:none"><?php echo _SEF_TRANSLATE_YES; ?></label>
        </fieldset>
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'._SEF_TRANSLATE_SUPPORT_JOOMLA_NATIVE_MULTI_LANGUAGES.'" alt="info">';?>
      </td>
    </tr>

    <tr>
      <td><?php echo _SEF_TRANSLATE_FALANG_MULTI_LANGUAGES; ?>:</td>
      <td>
        <fieldset id="jform_compatible_with_falang_multi_lang" class="radio btn-group">
        <input type="radio" name="compatible_with_falang_multi_lang" id="jform_compatible_with_falang_multi_lang_01" value="0"
        <?php echo ($seftranslate_configuration['compatible_with_falang_multi_lang'] == 0) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_compatible_with_falang_multi_lang_01" style="clear:none"><?php echo _SEF_TRANSLATE_NO; ?></label>
        <input type="radio" name="compatible_with_falang_multi_lang" id="jform_compatible_with_falang_multi_lang_02" value="1"
        <?php echo ($seftranslate_configuration['compatible_with_falang_multi_lang'] == 1) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_compatible_with_falang_multi_lang_02" style="clear:none"><?php echo _SEF_TRANSLATE_YES; ?></label>
        </fieldset>
      </td>        
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'._SEF_TRANSLATE_SUPPORT_JOOMLA_FALANG_MULTI_LANGUAGES.'" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td><?php echo _SEF_TRANSLATE_TRANSLATE_IFRAMES; ?>:</td>
      <td>
        <fieldset id="jform_translate_iframes" class="radio btn-group">
        <input type="radio" name="translate_iframes" id="jform_translate_iframes_01" value="0"
        <?php echo ($seftranslate_configuration['translate_iframes'] == 0) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_translate_iframes_01" style="clear:none"><?php echo _SEF_TRANSLATE_NO; ?></label>
        <input type="radio" name="translate_iframes" id="jform_translate_iframes_02" value="1"
        <?php echo ($seftranslate_configuration['translate_iframes'] == 1) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_translate_iframes_02" style="clear:none"><?php echo _SEF_TRANSLATE_YES; ?></label>
        </fieldset>
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'. _SEF_TRANSLATE_TRANSLATE_IFRAMES .'" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td><?php echo _SEF_TRANSLATE_TRANSLATE_URLS; ?>:</td>
      <td>
        <fieldset id="jform_translate_urls" class="radio btn-group">
        <input type="radio" name="translate_urls" id="jform_translate_urls_01" value="0"
        <?php echo ($seftranslate_configuration['translate_urls'] == 0) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_translate_urls_01" style="clear:none"><?php echo _SEF_TRANSLATE_NO; ?></label>
        <input type="radio" name="translate_urls" id="jform_translate_urls_02" value="1"
        <?php echo ($seftranslate_configuration['translate_urls'] == 1) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_translate_urls_02" style="clear:none"><?php echo _SEF_TRANSLATE_YES; ?></label>
        </fieldset>
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Translate Urls" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td><?php echo _SEF_TRANSLATE_USER_IP; ?></td>
      <td>
    <fieldset id="jform_userip" class="radio btn-group">
    <input type="radio" name="userip" id="jform_userip_01" value="0"
    <?php echo ($seftranslate_configuration['userip'] == 0) ? " checked=\"checked\"" : " "; ?> />
    <label for="jform_userip_01" style="clear:none"><?php echo _SEF_TRANSLATE_NO; ?></label>
    <input type="radio" name="userip" id="jform_userip_02" value="1"
    <?php echo ($seftranslate_configuration['userip'] == 1) ? " checked=\"checked\"" : " "; ?> />
    <label for="jform_userip_02" style="clear:none"><?php echo _SEF_TRANSLATE_YES; ?></label>
    </fieldset>

      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'._SEF_TRANSLATE_USER_IP_SUPPLY.'" alt="info">';?>
      </td>
    </tr>
    <!--tr>
      <td>No translate tags:</td>
      <td>
        <input type="radio" name="use_notag" id="log" value="0"
        <?php echo ($seftranslate_configuration['use_notag'] == 0) ? " checked=\"checked\"" : " "; ?> />
        <label for="log">No</label>
        <input type="radio" name="use_notag" id="log" value="1"
        <?php echo ($seftranslate_configuration['use_notag'] == 1) ? " checked=\"checked\"" : " "; ?> />
        <label for="log">Yes</label>
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Support google not translate tags" alt="info">';?>
      </td>
    </tr-->
    <tr>
      <td><?php echo _SEF_TRANSLATE_DETECT_SOURCE_LANG; ?></td>
      <td>
  <fieldset id="jform_detect_source_lang" class="radio btn-group">
        <input type="radio" name="detect_source_lang" id="jform_detect_source_lang_01" value="0"
        <?php echo ($seftranslate_configuration['detect_source_lang'] == 0) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_detect_source_lang_01" style="clear:none"><?php echo _SEF_TRANSLATE_NO; ?></label>
        <input type="radio" name="detect_source_lang" id="jform_detect_source_lang_02" value="1"
        <?php echo ($seftranslate_configuration['detect_source_lang'] == 1) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_detect_source_lang_02" style="clear:none"><?php echo _SEF_TRANSLATE_YES; ?></label>
  </fieldset>
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'._SEF_TRANSLATE_DETECT_SOURCE_LANG_INFO.'" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td><?php echo _SEF_TRANSLATE_DEBUG; ?></td>
      <td>
  <fieldset id="jform_debug" class="radio btn-group">
        <input type="radio" name="debug" id="jform_debug_01" value="0"
        <?php echo ($seftranslate_configuration['debug'] == 0) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_debug_01" style="clear:none"><?php echo _SEF_TRANSLATE_NO; ?></label>
        <input type="radio" name="debug" id="jform_debug_02" value="1"
        <?php echo ($seftranslate_configuration['debug'] == 1) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_debug_02" style="clear:none"><?php echo _SEF_TRANSLATE_YES; ?></label>
  </fieldset>
      </td>
      <td>
  <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="'._SEF_TRANSLATE_DEBUG_INFO.'" alt="info">';?>
      </td>
    </tr>
  </table>


  <?php

}

function settingsCache($seftranslate_configuration)
{
  global $seftranslate_configuration;
  ?>
  <table>
    <tr>
      <td width="37%">Enable Caching</td>
      <td align="right">
        <select name="cashing">
          <option value="1" <?php echo ($seftranslate_configuration['cashing'])?'selected="selected"':""; ?>>Yes</option>
          <option value="0" <?php echo ($seftranslate_configuration['cashing'])? "" : 'selected="selected"' ; ?>>No</option>
        </select>
      </td>
      <td>
        <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Select Yes to use caching for translated page. This will help you to speed up your website" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td>Cache Time</td>
      <td align="right">
         <input name="cache_time" type="text" size="10" value="<?php echo $seftranslate_configuration['cache_time']; ?>" label="Cache Time" description="The time before the module is recached" />
      </td>
      <td>
        <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Set time (in minutes) after which cache will be refreshed" alt="info">';?>
      </td>
    </tr>

    <tr>
      <td colspan="2">Exclude from Unique Cache:
      </td>
      <td>
        <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Warning! Only for experienced users" alt="info">';?>
      </td>
    </tr>
    <!--<tr>
      <td>GET:</td>
      <td>
        <input name="all_get" type="checkbox"  <?php if($seftranslate_configuration['all_get']=="on") echo "checked"; ?> >All
         <input name="clear_get" type="text" value="<?php echo $seftranslate_configuration['clear_get']; ?>" label="Clear GET" description="Set by coma field GET when not been use for creat cash." />
      </td>
      <td>
        <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Set by coma field GET." alt="info">';?>
      </td>
    <tr>-->
    <tr>
      <td>POST</td>
      <td valign="middle">
        <span class="checkbox_wrapper"><input name="all_post" type="checkbox" <?php if($seftranslate_configuration['all_post']=="on") echo "checked"; ?>>All&nbsp; </span>
         <textarea name="clear_post"  cols="51" > <?php echo $seftranslate_configuration['clear_post']; ?></textarea>
      </td>
      <td>
        <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Set by coma fields POST, what will exclude from Unique Cache" alt="info">';?>
      </td>
    </tr>
      <tr>
      <td>COOKIE</td>
      <td valign="middle">
        <span class="checkbox_wrapper"><input name="all_cookie" type="checkbox" <?php if($seftranslate_configuration['all_cookie']=="on") echo "checked"; ?> >All&nbsp; </span>
         <textarea name="clear_cookie"   cols="51" > <?php echo $seftranslate_configuration['clear_cookie']; ?> </textarea>
      </td>
      <td>
        <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Set by coma fields COOKIE, what will exclude from Unique Cache" alt="info">';?>
      </td>
    </tr>



    <tr>
      <td>Clear Cache</td>
      <td>
        <button href="javascript:void(0);" onClick="adminForm.task.value='clear_cache'" class="btn btn-small" >
        <i class="icon-trash"></i>
        Clear...
        </button>
      </td>
      <td>
        <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Clear translated pages from cache. Manually translated pages and base pages will not be clear" alt="info">';?>
      </td>
    </tr>

  </table>
<?php
}

function settingsMap($seftranslate_configuration)
{
  global $seftranslate_configuration,$mainframe;
  //print_r(explode("|",$seftranslate_configuration['map_lang']));exit;
  $lang_list=parse_ini_file(JPATH_SITE."/components/com_seftranslate/languages.ini");
  $keys = array_keys( $lang_list );
    // iterate through styles
    $langs=Array();
    foreach( $keys as $key )
    {
      if($key!="UNKNOWN")
      {
        $t=new t_langs();
        $t->key=$lang_list[$key];
        $t->title=ucfirst(strtolower($key));
        $langs[]=$t;
      }
    }
  ?>
  <table>

    <tr>

      <td width="22%">Sitemap Component</td>
      <td width="20%">
        <select name="site_map">
          <option value="0" >Not used</option>
          <option value="xmap" <?php echo ($seftranslate_configuration['site_map']=="xmap")?'selected="selected"':""; ?>>XMap</option>
          <option value="joomap" <?php echo ($seftranslate_configuration['site_map']=="joomap")?  'selected="selected"':"" ; ?>>JooMap</option>
          <option value="jmsitemap" <?php echo ($seftranslate_configuration['site_map']=="jmsitemap")?  'selected="selected"':"" ; ?>>JM Sitemap</option>
        </select>
      </td>
      <td>
        <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Select component that is used to generate a sitemap" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td>Sitemap Languages</td>

      <td>
        <?php
        echo JHTML::_('select.genericlist',  $langs, 'map_lang[]', 'class="inputbox" multiple size="8"', 'key', 'title', explode("|",$seftranslate_configuration['map_lang']), 'map_lang');
        ?>
      </td>
      <td>
        <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Add languages on which your site will be translated" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td>
        XML Sitemap URL
      </td>
      <td>
        <a href='<?php echo JURI::root(); ?>index.php?option=com_seftranslate&view=xml&tmpl=component'><?php echo JURI::root(); ?>index.php?option=com_seftranslate&view=xml&tmpl=component</a>
      </td>

      <td>
        <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="It is link on XML Sitemap for registration on Search Engines like Google or Yahoo" alt="info">';?>
      </td>

    </tr>
    <tr>
      <td>
        HTML Sitemap URL
      </td>
      <td>
        <a href='<?php echo JURI::root( ); ?>index.php?option=com_seftranslate'><?php echo JURI::root(); ?>index.php?option=com_seftranslate</a>
      </td>

      <td>
        <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="It is link for HTML Sitemap for displaying to users" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td>Use Cache for Sitemap</td>
      <td>
        <fieldset id="jform_sitemap" class="radio btn-group">
        <input type="radio" name="cache_map" id="jform_sitemap_01" value="0"
        <?php echo ($seftranslate_configuration['cache_map'] == 0) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_sitemap_01" style="clear:none">No</label>
        <input type="radio" name="cache_map" id="jform_sitemap_02" value="1"
        <?php echo ($seftranslate_configuration['cache_map'] == 1) ? " checked=\"checked\"" : " "; ?> />
        <label for="jform_sitemap_02" style="clear:none">Yes</label>
          </fieldset>
      </td>
      <td>
        <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Select use cache for Sitemap or not" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td>Add Language to Sitemap</td>
      <td>
        <button href="javascript:void(0);" onClick="adminForm.task.value='add_lang'" class="btn btn-small" >
        <i class="icon-save-new"></i>
        Add
        </button>

      </td>
      <td>
        <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="If you have very long Sitemap or while creating translation of Sitemap you have error - you can Add languages on you cached Sitemap here" alt="info">';?>
      </td>
    </tr>
    <tr>
      <td>Clear Sitemap Cache</td>
      <td>

        <?php
        if(is_file(JPATH_SITE."/components/com_seftranslate/map.cch"))
        {
        ?>
        <input type="submit" value="Clear..." id="log" onClick="adminForm.task.value='clear_map'">
        <?php }else{ ?>
          Cache is clear.
        <?php } ?>
      </td>
      <td>
        <?php echo '<img src="'.JURI::base().'components/com_seftranslate/images/info.png" title="Clear you cache for Sitemap" alt="info">';?>
      </td>
    </tr>
  </table>
  <?php

}

function about()
{
  echo "<div>";
  if(is_file(JPATH_SITE."/administrator/components/com_seftranslate/doc/about.html"))
  {
    $fp = fopen(JPATH_SITE."/administrator/components/com_seftranslate/doc/about.html", "r");
    $contents = fread($fp, filesize(JPATH_SITE."/administrator/components/com_seftranslate/doc/about.html"));
    fclose($fp);
    echo $contents;

  }
  else
  {
    echo "Sorry! File not found.";
  }
  echo "</div>";

}
function help()
{
  echo "<div>";
  if(is_file(JPATH_SITE."/administrator/components/com_seftranslate/doc/help.html"))
  {
    $fp = fopen(JPATH_SITE."/administrator/components/com_seftranslate/doc/help.html", "r");
    $contents = fread($fp, filesize(JPATH_SITE."/administrator/components/com_seftranslate/doc/help.html"));
    fclose($fp);
    echo $contents;

  }
  else
  {
    echo "Sorry! File not found.";
  }
  echo "</div>";


}



class t_langs
{
  var $key;
  var $title;
}

?>
