<?php
defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

class AdminViewCategory{

  static function show(&$rows, $userid, &$pageNav, &$lists, $type, $entity_list, $lang_list){
    global $user, $app, $templateDir, $doc, $cck_entity_configuration;
    $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . JText::_('COM_OS_CCK_CATEGORIES_MANAGER') . "</div>";
    $app = JFactory::getApplication();
    $app->JComponentTitle = $html;
    $section = "com_os_cck";
    $onclick = "Joomla.isChecked(this.checked);";
    
    ?>
    <script>
        function listItemTask(id, task, frmName){
            var form = document.adminForm;
            cb = eval( id );
            if (cb) {
                cb.checked = true;
                form.task.value = task;
                form.submit();
            }
            return false;
        }
    </script>
    <form action="index.php?option=com_os_cck&task=show_categories" method="post" name="adminForm" id="adminForm">
        <div class="adminlist  instances_list filters wrapper_filters">
            
            <div>
                <?php echo $entity_list; ?>
            </div>
            <div>
                <?php echo $lang_list; ?>
            </div>
            
        </div>
        <div class="wrapper_filters_right">
            <div class="btn-group pull-right hidden-phone">
                <label for="limit" class="element-invisible"><?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
                <?php echo  $pageNav->getLimitBox(); ?>
            </div>
        </div>
      <table width="100%" class="adminlist">
        <tr>
            <th width="3%" style="text-align: center;">
                <input type="checkbox" name="toggle" value="" onClick="Joomla.checkAll(this);"/>
            </th>
            <th style="text-align: center;" width="5%">
                ID
            </th>
            <th align="center" class="title" width="8%">
                <?php echo JText::_('COM_OS_CCK_HEADER_CATEGORY'); ?>
            </th>
            <th align="center" width="5%">
                <?php echo JText::_('COM_OS_CCK_HEADER_NUMBER'); ?>
            </th>

            <th align="center" width="10%">
                <?php echo JText::_('COM_OS_CCK_HEADER_PUBLISHED'); ?>
            </th>
            <?php
            if ($section <> 'content') {
                ?>
                <th align="center" colspan="2">
                    <?php echo JText::_('COM_OS_CCK_HEADER_REORDER'); ?>
                </th>
            <?php
            }

            ?>
            <th align="center" width="10%">
                <?php echo JText::_('COM_OS_CCK_HEADER_ENTITY'); ?>
            </th>
            <?php if(JLanguageMultilang::isEnabled()){ ?>
            <th align="center" class="title" width="5%"
                nowrap="nowrap"><?php echo JText::_('COM_OS_CCK_LABEL_INSTANCE_LANGUAGE');?></th>
            <?php } ?>
            <th align="center" width="10%">
                <?php echo JText::_('COM_OS_CCK_HEADER_ACCESS'); ?>
            </th>
            <?php
            if ($section == 'content') {
                ?>
                <th width="12%" align="center">
                    Section
                </th>
            <?php
            }
            ?>
            <th align="center" width="12%">
                <?php echo JText::_('COM_OS_CCK_HEADER_CHECKED_OUT'); ?>
            </th>
                        <?php if (version_compare(JVERSION, "3.0.0", "ge")) {
        ?>
            
    <?php } ?>
        </tr>
        <?php
        $k = 0;
        $i = 0;
        $n = count($rows);
        
        foreach ($rows as $row) {
            if(isset($row->fk_eid)){
                $entity_name = getEntityName($row->fk_eid);
              }else{
                $entity_name = '';
              }
            $img = $row->published ? 'tick.png' : 'publish_x.png';
            $task = $row->published ? 'unpublish_categories' : 'publish_categories';
            $alt = $row->published ? 'Published' : 'Unpublished';

            $rentable = ($row->rent_request == "1") ? "<span style='text-shadow: 0 -1px 0 rgba(0,0,0,0.25);color:#fff;background:#42A8C6;border-radius:11px;padding:0 5px 2px 5px;'>[" .
                JText::_("COM_OS_CCK_ALLOW_RENT_REQUEST") . "]</span>" : "";
            $buyable = ($row->buy_request == "1") ? "<span style='text-shadow: 0 -1px 0 rgba(0,0,0,0.25);color:#fff;background:#343434;border-radius:11px;padding:0 5px 2px 5px;'>[" .
                JText::_("COM_OS_CCK_ALLOW_BUY_REQUEST") . "]</span>" : "";
            if (!$row->access) {
                $color_access = 'style="color: green;"';
                $task_access = 'accessregistered_category';
            } else if ($row->access == 1) {
                $color_access = 'style="color: red;"';
                $task_access = 'accessspecial_category';
            } else {
                $color_access = 'style="color: black;"';
                $task_access = 'accesspublic_category';
            }
            $img = "components/com_os_cck/images/{$img}";
            ?>
            <tr class="<?php echo "row$k"; ?>">
                <td width="3%" align="center">
                    <?php echo JHTML::_('grid.id',$i, $row->cid, ($row->checked_out_contact_category
                                                              && $row->checked_out_contact_category != $user->id), 'cid'); ?>
                </td>
                <td align="center">
                    <?php echo $row->cid; ?>
                </td>
                <td width="35%">
                    <?php
                    if ($row->checked_out_contact_category && ($row->checked_out_contact_category != $user->id)) {

                        ?>
                        <?php echo $row->name . ' ( ' . $row->title . ' )' ?>
                        &nbsp;[ <i>Checked Out</i> ]
                        <?php
                        echo "&nbsp;" . $rentable . "&nbsp;" . $buyable;
                    } else {

                        ?>
                        <a href="#edit_ctegory"
                           onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','edit_category')">
                            <?php echo $row->name . ' ( ' . $row->title . ' )'; ?>
                        </a>
                        <?php
                        echo "&nbsp;" . $rentable . "&nbsp;" . $buyable;
                    }

                    ?>
                </td>
                <td align="center">
                    <?php echo $row->nentity; ?>
                </td>

                <td align="center">
                    <?php if(JFactory::getUser()->authorise('publish_categories', 'com_os_cck')
                            || JFactory::getUser()->authorise('unpublish_categories', 'com_os_cck')): ?>
                    <a href="javascript: void(0);"
                       onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','<?php echo $task; ?>')">
                    <?php endif; ?>
                        <img src="<?php echo $img; ?>" width="12" height="12" border="0"
                             alt="<?php echo $alt; ?>"/>
                    <?php if(JFactory::getUser()->authorise('publish_categories', 'com_os_cck')
                        || JFactory::getUser()->authorise('unpublish_categories', 'com_os_cck')): ?>
                    </a>
                    <?php endif; ?>
                </td>
                <!-- old td  >
                <?php echo $i. $pageNav->orderUpIcon($i);?>
                </td>
                <td>
                <?php echo $i. "::".$n.$pageNav->orderDownIcon($i, $n);?>
                </td-->
                <td align="center">
                    <?php
                    echo catOrderUpIcon($row->ordering - 1, $i);?>
                </td>
                <td align="center">
                    <?php
                    echo catOrderDownIcon($row->ordering - 1, $row->all_fields_in_list, $i);?>
                </td>

                <td align="center">
                    <?php echo $entity_name; ?>
                </td>
                <?php if(JLanguageMultilang::isEnabled()){ ?>
                <td align="center">
                    <?php echo $row->lang; ?>
                </td>
                <?php } ?>
                <td align="center">
                    <?php echo $row->groups; ?>
                </td>
                <td width="35%">
                    <?php echo $row->checked_out_contact_category ? $row->editor : ""; ?>
                </td>
                <td></td>
                <?php
                $k = 1 - $k;

                ?>
            </tr>
            <?php
            $k = 1 - $k;
            $i++;
        }
        ?>
        <tr>
            <td colspan="11"><?php echo $pageNav->getListFooter(); ?></td>
        </tr>
      </table>
      <input type="hidden" name="option" value="com_os_cck"/>
      <input type="hidden" name="section" value="categories"/>
      <input type="hidden" name="task" value="show_categories"/>
      <input type="hidden" name="chosen" value=""/>
      <input type="hidden" name="act" value=""/>
      <input type="hidden" name="boxchecked" value="0"/>
      <input type="hidden" name="type" value="<?php echo $type; ?>"/>
    </form>
  <?php
  }

  static function showModal(&$rows, $userid, &$pageNav, &$lists, $type){
    global $user, $app, $templateDir, $doc, $moduleId;
    $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . JText::_('COM_OS_CCK_CATEGORIES_MANAGER') . "</div>";
    $app = JFactory::getApplication();
    $app->JComponentTitle = $html;
    $section = "com_os_cck";
    $onclick = "Joomla.isChecked(this.checked);";
    
    ?>
    <form action="index.php" method="post" name="manageCategoryModal" id="manageCategoryModal">
    <h4 class="modal-title" id="attached-layout-modal-Label"><?php echo JText::_("COM_OS_CCK_ATTACHED_CATEGORY_MODAL_TITLE")?></h4>
      <table class="manageCategoryModalTable">
        <tr>
            <th align="center" width="5%">
                ID
            </th>
            <th align="center" class="title">
                <?php echo JText::_('COM_OS_CCK_HEADER_CATEGORY'); ?>
            </th>
            <th align="center" width="5%">
                <?php echo JText::_('COM_OS_CCK_HEADER_NUMBER'); ?>
            </th>
            <th align="center" width="10%">
                <?php echo JText::_('COM_OS_CCK_HEADER_ACCESS'); ?>
            </th>
            <?php
            if ($section == 'content') {
                ?>
                <th width="12%" align="center">
                    Section
                </th>
            <?php
            }
            ?>
            <th align="center" width="10%">
                <?php echo JText::_('COM_OS_CCK_HEADER_ENTITY'); ?>
            </th>
            
        </tr>
        <?php
        $k = 0;
        $i = 0;
        $n = count($rows);
        foreach ($rows as $row){ ?>
            <tr onclick="if(window.parent)window.parent.selectCategory(<?php echo $row->cid?>,'<?php echo $moduleId?>')" class="modalRow<?php echo $i % 2; ?>">
                <td align="center">
                    <?php echo $row->cid; ?>
                </td>
                <td width="35%">
                  <?php
                    echo $row->name . ' ( ' . $row->title . ' )';
                  ?>
                </td>
                <td align="center">
                    <?php echo $row->nentity; ?>
                </td>
                <td align="center">
                    <?php echo $row->groups; ?>
                </td>
                <td align="center">
                    <?php echo ($row->entity_name) ? $row->entity_name : '*'; ?>
                </td>
                <?php
                $k = 1 - $k;
                ?>
            </tr>
            <?php
            $k = 1 - $k;
            $i++;
        }
        ?>
<!--        <tr>-->
<!--            <td colspan="11">--><?php //echo $pageNav->getListFooter(); ?><!--</td>-->
<!--        </tr>-->
      </table>
      <input type="hidden" name="option" value="com_os_cck"/>
      <input type="hidden" name="section" value="categories"/>
      <input type="hidden" name="task" value="show_categories"/>
      <input type="hidden" name="chosen" value=""/>
      <input type="hidden" name="act" value=""/>
      <input type="hidden" name="boxchecked" value="0"/>
      <input type="hidden" name="type" value="<?php echo $type; ?>"/>
    </form>
  <?php
  }

  static function showCategoryModalPlg(&$rows, $userid, &$pageNav, &$lists, $type, $lid){
    global $user, $app, $templateDir, $doc, $moduleId;
    $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . JText::_('COM_OS_CCK_CATEGORIES_MANAGER') . "</div>";
    $app = JFactory::getApplication();
    $app->JComponentTitle = $html;
    $section = "com_os_cck";
    $onclick = "Joomla.isChecked(this.checked);";
    ?>
    <form action="index.php" method="post" name="manageCategoryModal" id="manageCategoryModal">
    <h4 class="modal-title" id="attached-layout-modal-Label"><?php echo JText::_("COM_OS_CCK_ATTACHED_LAYOUT_MODAL_TITLE")?></h4>
      <table class="manageCategoryModalTable">
        <tr>
            <th align="center" class="title">
                <?php echo JText::_('COM_OS_CCK_HEADER_CATEGORY'); ?>
            </th>
            <th align="center" width="5%">
                <?php echo JText::_('COM_OS_CCK_HEADER_NUMBER'); ?>
            </th>
            <th align="center" width="10%">
                <?php echo JText::_('COM_OS_CCK_HEADER_ACCESS'); ?>
            </th>
            <?php
            if ($section == 'content') {
                ?>
                <th width="12%" align="center">
                    Section
                </th>
            <?php
            }
            ?>
            <th align="center" width="12%">
                ID
            </th>
        </tr>
        <?php
        $k = 0;
        $i = 0;
        $n = count($rows);
        foreach ($rows as $row){ ?>
          <tr class="modalRow<?php echo $i % 2; ?>"
            onclick="window.location.href = 'index.php?option=com_os_cck&task=select_data_for_editor_button&tmpl=component&lid='+<?php echo $lid?>+'&cat_id='+<?php echo $row->cid?>">
            <td width="35%">
              <?php
                echo $row->name . ' ( ' . $row->title . ' )';
              ?>
            </td>
            <td align="center">
                <?php echo $row->nentity; ?>
            </td>
            <td align="center">
                <?php echo $row->groups; ?>
            </td>
            <td align="center">
                <?php echo $row->cid; ?>
            </td>
            <?php
            $k = 1 - $k;
            ?>
          </tr>
          <?php
          $k = 1 - $k;
          $i++;
        }
        ?>
        <tr>
            <td colspan="11"><?php echo $pageNav->getListFooter(); ?></td>
        </tr>
      </table>
      <input type="hidden" name="option" value="com_os_cck"/>
      <input type="hidden" name="section" value="categories"/>
      <input type="hidden" name="task" value="show_categories"/>
      <input type="hidden" name="chosen" value=""/>
      <input type="hidden" name="act" value=""/>
      <input type="hidden" name="boxchecked" value="0"/>
      <input type="hidden" name="type" value="<?php echo $type; ?>"/>
    </form>
  <?php
  }

  /**
   * Writes the edit form for new and existing categories
   *
   * @param  $ The category object
   * @param string $
   * @param array $
   */
  static function edit(&$row, $section, &$lists, $redirect)
  {

      global $user, $app, $option, $cck_entity_configuration;
      $doc = JFactory::getDocument();
      $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . JText::_('COM_OS_CCK_CATEGORIES_MANAGER') . "</div>";
      $app = JFactory::getApplication();
      $app->JComponentTitle = $html;
      //swich_task('edit_instance');lay_type_select();
      if ($row->image == "") {
          $row->image = 'blank.png';
      }

      $robots_option[]  = JHTML::_('select.option','0','Use Global');
      $robots_option[]  = JHTML::_('select.option','1','Index, Follow');
      $robots_option[]  = JHTML::_('select.option','2','No index, follow');
      $robots_option[]  = JHTML::_('select.option','3','Index, No follow');
      $robots_option[]  = JHTML::_('select.option','4','No index, no follow');
      mosMakeHtmlSafe($row, ENT_QUOTES, 'description');
      
      ?>
      <script language="javascript" type="text/javascript">
          function findPosY(obj) {
            var curtop = 0;
            if (obj.offsetParent) {
              while (1) {
                curtop+=obj.offsetTop;
                if (!obj.offsetParent) {
                    break;
                }
                obj=obj.offsetParent;
              }
            } else if (obj.y) {
                curtop+=obj.y;
            }
            return curtop-20;
          }
          function lay_type_select() {
            document.forms["adminForm"].submit();;
            return;
          }
          
          function swich_task(task){
            
            if(task == 'edit_category'){
              document.getElementById('category_task').value = 'edit_category';
            }
            
          }
          Joomla.submitbutton = function (pressbutton, section) {
              var form = document.adminForm;

              if (pressbutton == 'cancel_category') {
                  window.location.href = "<?php echo JURI::base(); ?>index.php?option=com_os_cck&task=show_categories"
                  return;
              }
              if(pressbutton == 'save_category'){
              }
              if(form.name.value == ""){
                window.scrollTo(0,findPosY(form.name)-100);
                form.name.placeholder = '<?php echo JText::_('COM_OS_CCK_ADMIN_INFOTEXT_JS_EDIT_TITLE');?>';
                form.name.style.borderColor = "#FF0000";
                return;
              }else if (form.title.value == "") {
                  window.scrollTo(0,findPosY(form.title)-100);
                  form.title.placeholder = '<?php echo JText::_('');?>';
                  form.title.style.borderColor = "#FF0000";
                  return;
              } else {
                  <?php getEditorContents('editor1', 'description') ;?>
                  Joomla.submitform(pressbutton);
              }
          }
          
          function showHideAssocCategory(){
                var val = jQuerOs('#language').val();
                if(val == '*'){
                    jQuerOs('.assoc_category').hide();
                }else{
                    jQuerOs('.assoc_category').each(function (index, value){
                        if(jQuerOs(value).hasClass(val)){
                            jQuerOs(value).hide();
                        }else{
                            jQuerOs(value).show();
                        }

                    })

                }
            }
            window.addEventListener('load', function() {
                showHideAssocCategory();
                
                jQuerOs('#language').on('change', showHideAssocCategory)
            })
      </script>

        <form action="index.php" method="post" name="adminForm" id="adminForm">
            <table width="100%">
                <tr>
                    <td valign="top">


                        <div class="adminform wrapper_add_category">
                            <div>
                                <div>
                                    <?php echo JText::_('COM_OS_CCK_CATEGORIES_HEADER_TITLE'); ?>:
                                </div>
                                <div>
                                    <input class="text_area" type="text" name="title" value="<?php echo $row->title; ?>"
                                            size="50" maxlength="250" title="A short name to appear in menus"/>
                                </div>
                            </div>
                            <div>
                                <div>
                                    <?php echo JText::_('COM_OS_CCK_CATEGORIES_HEADER_NAME'); ?>:
                                </div>
                                <div>
                                    <input class="text_area" type="text" name="name" value="<?php echo $row->name; ?>"
                                            size="50" maxlength="250" title="A short name to appear in menus"/>
                                </div>
                            </div>
                            <div>
                                <div>
                                    <?php echo JText::_('COM_OS_CCK_CATEGORIES_PARENTITEM'); ?>:
                                </div>
                                <div>
                                    <?php echo $lists['parent']; ?>
                                </div>
                            </div>
                            <div>
                                <div>
                                    <?php echo JText::_('COM_OS_CCK_CATEGORIES_ENTITY'); ?>:
                                </div>
                                <div>
                                    <?php echo $lists['entity']; ?>
                                </div>
                            </div>
                            <div>
                                <div>
                                    <?php  echo JText::_('COM_OS_CCK_CATEGORIES_HEADER_IMAGE');?>:
                                </div>
                                <div>
                                    <?php
                                            
                                    if(substr_count($lists['image'], '<option') == 1){
                                        echo $lists['image'] . '<span style="font-size: 12px; position: absolute;">'.
                                            JText::_('COM_OS_CCK_CATEGORY_LOAD_IMAGE').'<span>';
                                    }else{
                                        echo $lists['image'];
                                    }
                                    ?>
                                    <script language="javascript" type="text/javascript">
                                        window.getOsSelectedValue = function ( frmName, srcListName ) {
                                //		console.warn('window.getSelectedValue() is deprecated without a replacement!');

                                                var srcList = document[ frmName ][ srcListName ],
                                                    i = srcList.selectedIndex;

                                                if ( i !== null && i > -1 ) {
                                                        return srcList.options[ i ].value;
                                                } else {
                                                        return null;
                                                }
                                        };
                                        var selVal = document.getElementById('image');
                                        if (selVal.options[selVal.selectedIndex].value != ''){
                                            jsimg='../images/os-cck/' + getOsSelectedValue( 'adminForm', 'image' );
                                        }
                                        else{
                                            jsimg='components/com_os_cck/images/blank.png';
                                        }
                                        document.write('<img src=' + jsimg + ' name="imagelib_image" width="80" height="80" '+
                                                        'border="2" alt="<?php echo JText::_('COM_OS_CCK_CATEGORIES_IMAGEPREVIEW');?>" />');
                                    </script>
                                </div>
                            </div>
                            <?php if(JLanguageMultilang::isEnabled()){ ?>
                            <div>
                                <div>
                                    <?php echo JText::_('COM_OS_CCK_LABEL_CATEGORY_LANGUAGE'); ?>:
                                </div>
                                <div>
                                    <?php echo $lists['lang_list']; ?>
                                </div>
                            </div>
                            <?php foreach($lists['categories_lang_list'] as $key => $list){ ?>
                            <div class="<?php echo $key; ?> assoc_category">
                                <div>
                                    <?php echo JText::_('COM_OS_CCK_LABEL_ASSOCIATED_CATEGORY') . ' ' . $key; ?>:
                                </div>
                                <div>
                                    <?php  echo JHTML::_('select.genericlist',$list, 'category_assoc_'.$key, 'size="1" class="inputbox"', 'value', 'text', (isset($lists['assoc_list'][$key])) ? $lists['assoc_list'][$key] : '');?>
                                </div>
                            </div>
                            <?php } 
                            
                            }else{ ?>
                                <input type="hidden" name="language" value="*">
                            <?php }?>
                                
                                
                            <?php if ($row->fk_eid == 0 || (isset($cck_entity_configuration[$row->fk_eid])) && $cck_entity_configuration[$row->fk_eid]['check_access_categories'] == '1'){ ?>
                            <div>
                                <div>
                                    <?php echo JText::_('COM_OS_CCK_HEADER_ACCESS'); ?>:
                                </div>
                                <div>
                                    <?php echo $lists['category']['registrationlevel']; ?>
                                </div>
                            </div>
                            <?php } ?>
                            <div>
                                <div>
                                    <?php echo JText::_('COM_OS_CCK_HEADER_PUBLISHED'); ?>:
                                </div>
                                <div>
                                    <?php echo $lists['published']; ?>
                                </div>
                            </div>
                            <div>
                                <div>
                                    <?php echo JText::_('COM_OS_CCK_CATEGORIES_HEADER_META_TITLE'); ?>:
                                </div>
                                <div>
                                    <input class="text_area" type="text" name="meta_title" value="<?php echo $row->meta_title; ?>"
                                            size="50" maxlength="250"/>
                                </div>
                            </div>
                            <div>
                                <div>
                                    <?php echo JText::_('COM_OS_CCK_CATEGORIES_HEADER_META_DESCRIPTION'); ?>:
                                </div>
                                <div>
                                    <textarea class="text_area" name="meta_description"><?php echo $row->meta_description; ?></textarea>
                                </div>
                            </div>
                            <div>
                                <div>
                                    <?php echo JText::_('COM_OS_CCK_CATEGORIES_HEADER_META_KEYWORDS'); ?>:
                                </div>
                                <div>
                                    <textarea class="text_area" name="meta_keywords"><?php echo $row->meta_keywords; ?></textarea>
                                </div>
                            </div>
                            <div>
                                <div>
                                    <?php echo JText::_('COM_OS_CCK_CATEGORIES_HEADER_META_ROBOTS'); ?>:
                                </div>
                                <div>
                                    <?php echo JHTML::_('select.genericlist', $robots_option, 'meta_robots', '','value', 'text',$row->meta_robots)?>
                                </div>
                            </div>
                            <div>
                                <div>
                                    <?php echo JText::_('COM_OS_CCK_CATEGORIES_DETAILS'); ?>:
                                </div>
                                <div>
                                    <?php
                                    // parameters : areaname, content, hidden field, width, height, rows, cols
                                    editorArea('editor1', $row->description, 'description', '500', '200', '50', '5');
                                    ?>
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>
            </table>

            <input type="hidden" name="option" value="com_os_cck"/>
            <input type="hidden" name="section" value="categories"/>
            <input type="hidden" name="task" value=""/>
            <input type="hidden" name="cid" value="<?php echo $row->cid; ?>"/>
            <!--input type="hidden" name="sectionid" value="com_os_cck" /-->
            <input type="hidden" name="redirect" value="<?php echo $redirect; ?>"/>
            <input id="category_task" type="hidden" name="task" value="save_category"/>
        </form>
  <?php
  }

}
