<?php

defined('_JEXEC') or die;

/**
* @package OS CCK
* @copyright 2017 OrdaSoft.
* @author Buchastiy Sergey (buchastiy1989@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit
*/


class CalendarUrlConstruct{

	protected $title;
	protected $event_start;
	protected $event_end;
	protected $description;
	protected $location;
	protected $app;

	public function __construct($title = false, 
															$event_start = false, 
															$event_end = false, 
															$description = false, 
															$location = false){
		$this->title = $title;
		$this->event_start = $event_start;
		$this->event_end = $event_end;
		$this->description = $description;
		$this->location = $location;
		$this->app = JFactory::getApplication();
	}

	/**
 	*  Function to return Url to add to Google Calendar
 	*/

	public function get($type,$calendar){

		//check whether define required properties 
            
		if($this->isEmptyField($this->title)){
			//$this->app->enqueueMessage(JText::_('COM_OS_CCK_ERROR_EMPTY_TITLE_FIELD'), 'error');
			return false;
		}elseif($this->isEmptyField($this->event_start)){
			$this->app->enqueueMessage(JText::_('COM_OS_CCK_ERROR_EMPTY_EVENT_START'), 'error');
			return false;
		}
		
		//safety check and extract property
		//$title, $event_start, $event_end, $description, $location
		extract($this->safetyField($this));	

		//truncate text field
		$ready_title = $this->truncateField($title, 50);
		$ready_description = $this->truncateField($description,100);
                
		//create date string
		if(!$this->createDateString($event_start, $event_end)){
			return false;
		}else{
			$ready_date_string = $this->createDateString($event_start, $event_end);
		}
	
		//location		
		$ready_location = $location;

		$getUrlName = "create".$type.$calendar;
		$url = $this->$getUrlName($ready_title, $ready_date_string, $ready_description, $ready_location);
		
		return $url;
	}

	protected function createUrlGoogle($title, $date_string, $description = '', $location = ''){
		
			$url = 'http://www.google.com/calendar/event?action=TEMPLATE';
			$url.= '&text=' . urlencode($title);
			$url.= '&dates=' . $date_string;
			$url.= '&location=' . urlencode($location);
			$url.= '&trp=true';
			$url.= '&details=' . urlencode($description);

			return $url;
	}

	protected function createUrlMicrosoft($title, $date_string, $description = '', $location = ''){
		$date_string = explode('/', $date_string);
		$event_start = $date_string[0];
		$event_end = $date_string[1];

		$url = "http://calendar.live.com/calendar/calendar.aspx?rru=addevent";
		$url.= "&dtstart=" . $event_start;
		$url.= "&dtend=" . $event_end;
		$url.= "&summary=" . urlencode($title);
		$url.= "&location=" . urlencode($location);
		$url.= "&description=" . urlencode($description);
		return $url;
	}

	protected function createUrlYahoo($title, $date_string, $description = '', $location = ''){
		$date_string = explode('/', $date_string);
		$event_start = $date_string[0];
		$event_end = $date_string[1];

		$url = "http://calendar.yahoo.com/?v=60";
		$url.= "&VIEW=d";
		$url.= "&in_loc=" . urlencode($location);
		$url.= "&TITLE=" . urlencode($title);
		$url.= "&ST=" . $event_start;
		$url.= "&ET=" . $event_end;
		$url.= "&DESC=" . urlencode($description);
		// $url.= "&URL=" . urlencode($website);

		return $url;
	}

	protected function createUrlICS($title, $date_string, $description = '', $location = ''){
		$date_string = explode('/', $date_string);
		$event_start = $date_string[0];
		$event_end = $date_string[1];

		$url = "index.php?option=com_os_cck&task=getISC";
		$url.= "&title=".urlencode($title);
		$url.= "&location=" . urlencode($location);
		$url.= "&event_start=" . $event_start;
		$url.= "&event_end=" . $event_end;
		$url.= "&description=" . urlencode($description);
		// $url.= "&URL=" . urlencode($website);

		return $url;
	}


	protected function createFileICS($title, $date_string, $description = '', $location = ''){
			
			$date_string = explode('/', $date_string);
			$event_start = $date_string[0];
			$event_end = $date_string[1];

			$v = new vCalendar();

			$v->setConfig( 'filename', 'cck_calendar.ics' );
			$v->prodid = 'os_cck';
			$tz = 'UTC';
			$v->setProperty( 'method', 'PUBLISH' );
			$v->setProperty( 'X-WR-CALDESC', '' );
			$v->setProperty( 'X-WR-TIMEZONE', $tz);

			$vevent = $v->newComponent('vevent');
			$vevent->setProperty('summary', $title);
			$vevent->setProperty('description', $description);
			$vevent->setProperty('dtstart', $event_start);
			$vevent->setProperty('dtend', $event_end);
			$vevent->setProperty('location', $location);

			$v->returnCalendar();
			
	}



	protected function isEmptyField($field){
            
		if($field === false || trim($field) == '' || empty($field)){
			return true;
		}
		return false;
	}

	protected function safetyField($object){
		$properties = array();
		foreach ($object as $name => $value) {
			if(!is_string($value)) continue;
			$properties[$name] = htmlspecialchars(trim($value));
		}
		return $properties;
	}

	protected function truncateField($field, $chars = 100){
		if (strlen($field) > $chars) return mb_substr($field, 0, $chars) . '...';
    return $field;
	}

	protected function createDateString($event_start,$event_end = false){
		//check correct start date
		if(date_parse($event_start)['error_count'] > 0){
			$this->app->enqueueMessage(JText::_('COM_OS_CCK_LAYOUT_EVENT_DATE_START_NOT_CORRECT'), 'error');
			return false;
		}

		if($this->isEmptyField(date_parse($event_start)['hour']) || $this->isEmptyField(date_parse($event_start)['hour'])){
			$time_mask = '';
			$t_symbol = '';
		}else{
			$time_mask = 'His';
			$t_symbol = 'T';
		}

		//check correct end date if isset event_end
		if($event_end){
			if(date_parse($event_end)['error_count'] > 0){
				$this->app->enqueueMessage(JText::_('COM_OS_CCK_LAYOUT_EVENT_DATE_END_NOT_CORRECT'), 'error');
				return false;
			}
		}else{
			//if not isset event_end return both value as event_start
			$event_start = date("Ymd",strtotime($event_start)).$t_symbol.date("$time_mask",strtotime($event_start));
			return $event_start.'/'.$event_start;
		}

		//return both event_start and event_end value
		$event_start = date("Ymd",strtotime($event_start)).$t_symbol.date("$time_mask",strtotime($event_start));
		$event_end = date("Ymd",strtotime($event_end)).$t_symbol.date("$time_mask",strtotime($event_end));
		return $event_start.'/'.$event_end;
		
	}

}