<?php
defined('_JEXEC') or die('Restricted access');
/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/


class AdminViewReview{
  static function showReviews($option, & $rows_item, & $clist,
                                & $publist, & $search, & $pageNav, & $sort_arr, $show_fields,$entity_list){
    global $doc, $user, $app, $session, $db, $entityFieldLists;
    $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . JText::_('COM_OS_CCK_COM_TITLE_REVIEWS') . "</div>";
    $app = JFactory::getApplication();
    $app->JComponentTitle = $html;
    $onclick = (version_compare(JVERSION, "1.6.0", "lt")) ? "checkAll(" . count($rows_item) . ");" : "Joomla.checkAll(this);";
    ?>
    <form action="index.php?option=com_os_cck&task=manage_review" method="post" name="adminForm" id="adminForm">
      <div class="adminlist filters wrapper_filters">

          <div>
            <div class="search_block">
              <input type="text" placeholder="<?php echo JText::_('COM_OS_CCK_SHOW_SEARCH'); ?>" name="search" value="<?php echo $search; ?>" class="inputbox"
                   onChange="document.adminForm.submit();"/>
              <button type="submit" class="cck_search_button" title="" data-original-title="Search"><span class="icon-search"></span></button>
              </div>
          </div>
          <div>
            <?php echo $publist; ?>
          </div>
          <div>
            <?php echo $clist; ?>
          </div>
          <div>
            <?php echo $entity_list; ?>
          </div>
          <?php if (version_compare(JVERSION, "3.0.0", "ge")) { ?>
            
          <?php } ?>

      </div>
      <div class="wrapper_filters_right">
        <div class="btn-group pull-right hidden-phone">
          <label for="limit" class="element-invisible"><?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
          <?php echo $pageNav->getLimitBox(); ?>
        </div>
      </div>
      <div class="admin-request-title">
      
            <div class="admin-order-title-checkbox">
                <input type="checkbox" name="toggle" value="" onClick="<?php echo $onclick; ?>" />
            </div>
            
            <div class="admin-order-title-id">
                <?php echo HTML_os_cck::sort_head(JText::_('COM_OS_CCK_LABEL_INSTANCE_ID'), 'inst_id', $sort_arr,protectInjectionWithoutQuote('task'));?>
                
            </div>
            <?php
            foreach($show_fields as $value){
              foreach($value as $field){
                ?>

                <div class="admin-order-title-email">
                    <?php echo HTML_os_cck::sort_head($field->field_name, $field->db_field_name, $sort_arr,protectInjectionWithoutQuote('task'));?>
                </div>
                <?php
                
              }
            }
            ?>
            <div class="admin-order-title-date">
              <?php echo HTML_os_cck::sort_head(JText::_('COM_OS_CCK_LABEL_ENTITY'), 'inst_entity', $sort_arr,protectInjectionWithoutQuote('task'));?>
                
            </div>
            
            <div class="admin-order-title-email">
              <?php echo HTML_os_cck::sort_head(JText::_('COM_OS_CCK_REVIEW_DATE'), 'created', $sort_arr,protectInjectionWithoutQuote('task'));?>
            </div>
            <div class="admin-order-title-date">
                <?php echo JText::_('COM_OS_CCK_LABEL_PUBLIC'); ?>
                
            </div>
            <div class="admin-order-title-date">
              <?php echo JText::_('COM_OS_CCK_LABEL_APPROVED'); ?>
            </div>
            <div class="admin-order-title-date">
              <?php echo JText::_('COM_OS_CCK_LABEL_CONTROL'); ?>
            </div>
            
      </div>
      <?php 
      // var_dump($rows_item);
      for($i = 0; $i < count($rows_item); $i++) { 
          $row = $rows_item[$i];
          // $order_instancies = $order_entity_array[$rows_item[$i]->id];
          ?>
         
      <div class="admin-one-order <?php echo $rows_item[$i]->notreaded?'admin-order-not-readed':''?>">
          <div class="admin-order-standart-fields admin-request-standart-fields">
              <div class="admin-order-standart-fields-checkbox">
                <?php if ($row->checked_out && $row->checked_out != $user->id) { ?>
                  &nbsp;
                <?php
                } else {
                  echo JHTML::_('grid.id',$i, $rows_item[$i]->eiid, ($rows_item[$i]->checked_out && $rows_item[$i]->checked_out != $user->id), 'eiid');
                }
                ?>
                  
              </div>
              <div class="admin-order-standart-fields-id">
                  <a href="#edit_review"
                     onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','edit_review')">
                      <?php echo $row->eiid; ?></a>
              </div>
              <?php 
                foreach($show_fields as $key => $value){
                  foreach($value as $field){
                    $html = '';
                    if($rows_item[$i]->fk_eid != $key){
                      echo'<div class="admin-order-standart-fields-email"></div>';
                      continue;
                    }
                    if($field->field_type == 'categoryfield'){
                      echo "<div class='admin-order-standart-fields-email'>$rows_item[$i]->category</div>";
                      continue;
                    }
                    ?>
                    <div class="admin-order-standart-fields-email">
                      <?php
                      $entityInstance = new os_cckEntityInstance($db);
                      $entityInstance->load($rows_item[$i]->eiid);
                      $value = $entityInstance->getFieldValue($field);
                      ?>
                      <div>
                          <span class="col_box" style="display:block;
                          <?php echo ($field->field_type=='imagefield'
                                      && isset($field->options['width'])
                                      && isset($field->options['height']))? 'width:'.$field->options['width'].'px; height:'.$field->options['height'].'px;':'';?>">
                              <?php
                                  ob_start();
                                    require getSiteShowFiledViewPath('com_os_cck', $field->field_type);
                                    $html .= ob_get_contents();
                                  ob_end_clean();
                                  echo $html;
                              ?>
                          </span>
                      </div>
                  </div>
                    <?php
                  }
                }
              ?>
              <div class="admin-order-standart-fields-date">
                  <?php echo $rows_item[$i]->entity;?>
              </div>
              <div class="admin-order-standart-fields-email">
                  <?php echo $rows_item[$i]->created;?>
              </div>
              <?php
              $task = $row->published ? 'unpublish_reviews' : 'publish_reviews';
              $alt = $row->published ? 'Unpublish' : 'Publish';
              $img = $row->published ? 'tick.png' : 'publish_x.png';
              $task1 = $row->approved ? 'unapprove_reviews' : 'approve_reviews';
              $alt1 = $row->approved ? 'Unapproved' : 'Approved';
              $img1 = $row->approved ? 'tick.png' : 'publish_x.png';
              $img = "components/com_os_cck/images/{$img}";
              $img1 = "components/com_os_cck/images/{$img1}";
              ?>
              <div class="admin-order-standart-fields-email">
                  <?php if (JFactory::getUser()->authorise('publish_reviews', 'com_os_cck')){ ?>
                      <a href="javascript: void(0);"
                        onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','<?php echo $task; ?>')">
                  <?php } ?>
                          <img src="<?php echo $img; ?>" width="12" height="12" border="0"
                              alt="<?php echo $alt; ?>"/>
                  <?php if (JFactory::getUser()->authorise('publish_reviews', 'com_os_cck')){ ?>
                      </a>
                  <?php } ?>
              </div>
              <div class="admin-order-standart-fields-email">
                  <?php if (JFactory::getUser()->authorise('publish_reviews', 'com_os_cck')){ ?>
                  <a href="javascript: void(0);"
                    onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','<?php echo $task1; ?>')">
                  <?php } ?>
                      <img src="<?php echo $img1; ?>" width="12" height="12" border="0"
                          alt="<?php echo $alt1; ?>"/>
                  <?php if (JFactory::getUser()->authorise('publish_reviews', 'com_os_cck')){ ?>
                  </a>
                  <?php } ?>
              </div>
              <div class="admin-order-standart-fields-email">
                  <?php
                  if ($row->checked_out) {
                    echo $row->editor;
                  }else{
                    echo '&nbsp;';
                  }
                    ?>  
              </div>
              
              
          </div>
          <div class="admin-order-products">
              <?php
              $parentInstance = new os_cckEntityInstance($db);
              $parentInstance->load($rows_item[$i]->fid_parent);
              
              // foreach ($parentInstance as $cart_item => $inst){
                  echo '<div class="admin-order-single-product">';
                  // $orderInstance = new os_cckEntityInstance($db);
                  // $orderInstance->load($inst);
                  $show_in_orders_fields = array();
                  if(isset($entityFieldLists[$parentInstance->fk_eid])){
                    $fields = $entityFieldLists[$parentInstance->fk_eid];
                  }else{
                    $fields = array();
                  }
                  foreach($fields as $field){
                      $params = new JRegistry;
                      $params->loadString($field->params);
                      if($params->get('show_in_reviews', '') == 'yes'){
                          $show_in_orders_fields[] = $field;
                      }
                  }
                  
                  ?>
                  <div>
                      <div>Title</div>
                      <div><?php echo $parentInstance->title; ?></div>
                  </div>
                  
                  <?php
//                        var_dump($show_in_orders_fields);
                  foreach ($show_in_orders_fields as $field){
                      $value = $parentInstance->getFieldValue($field);
                      if(isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data') && $value[0]->data == ''){
                          continue;
                      }elseif($field->field_type == 'datetime_popup' && isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data') && $value[0]->data == '0000-00-00 00:00:00'){
                          continue;
                      }
                      $print_value = '';
                      if($field->field_type == 'text_select_list'){
                          $value = (isset($value[0]->data))?$value[0]->data : '';
                          $value = json_decode($value);
                          $params = new JRegistry;
                          $params->loadString($field->params);
                          $allowed_values = $params->get("allowed_value");
                          $allowed_values = explode('\sprt', $allowed_values);
                          $tmp_val = array();

                          if(is_array($value)){

                              foreach($value as $val){

                                  if(isset($allowed_values[$val])){
                                      $tmp_val[] = JText::_($allowed_values[$val]);
                                  }
                              }
                          }

                          $print_value = implode(', ', $tmp_val);
                          
//                                $temp_val = json_decode($value[0]->data);
//                                if(is_array($temp_val)){
//                                    $temp_val = implode(', ', $temp_val);
//                                    $print_value = $temp_val;
//                                }
//                                var_dump(json_decode($value[0]->data));
                      }elseif(stripos($field->field_type, 'pricefield') !== false){
                          
                          continue;
                      }elseif(isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data')){
                          $print_value = $value[0]->data;
                      }
                      echo '<div><div>'.$field->field_name.'</div><div>'.$print_value.'</div></div>';
//                            var_dump($value);
                  }
                  
                  
                  echo '</div>';
//                        var_dump($fields);
              
              ?>
          </div>
          
      </div>
      <?php } ?>
      <div><?php echo $pageNav->getListFooter(); ?></div>
      
      <input type="hidden" name="option" value="<?php echo $option; ?>"/>
      <input type="hidden" name="task" value="manage_review"/>
      <input type="hidden" name="boxchecked" value="0"/>
    </form>
    <?php
  }

  static function editReview($option, $entityInstance, $layout, $layout_params){
    global $session, $os_cck_configuration, $app, $doc;
    $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . JText::_('COM_OS_CCK_SHOW') . "</div>";
    $app = JFactory::getApplication();
    $app->JComponentTitle = $html;
    require getLayoutPathCCK::getAdminLayoutViewPath('com_os_cck','edit_review');
  }

  static function showParentInstance($option, $entityInstance, $layout, $layout_params){
    global $session, $os_cck_configuration, $app, $doc;
    $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . JText::_('COM_OS_CCK_SHOW') . "</div>";
    $app = JFactory::getApplication();
    $app->JComponentTitle = $html;
    require getLayoutPathCCK::getAdminLayoutViewPath('com_os_cck','parent_instance');
  }

}
