<?php

defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2020 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit
*/

class os_cckViewTable
{
   private $form_name;
   private $form_id;
   private $form_class;
   public $limitbox = '';
   public $paginator = '';
   private $first_row_collumn = array();
   private $style_first_row_collumn = array();
   private $class_first_row_collumn = array();
   private $second_row_collumn = array();
   private $style_second_row_collumn = array();
   private $class_second_row_collumn = array();
   private $filters = array();
   private $first_row_data = array();
   private $first_row_data_class = array();
   private $second_row_data = array();
   private $second_row_data_class = array();
   private $buttons = array();
   private $form_action = '';
   private $form_task = '';
   private $hiddenInputs = array();
   public $title_class = '';
   public $first_row_custom_class = '';

   /**
    * Constructor.
    *
    * @param string $form_name "name" attribute for this form.
    * @param string $collumn_style string intended to be inserted into the "style" attribute.For example: width:3%;colour:red;margin:5px etc.
    * @param string $collumn_class one or more classes, separated by a space, that will be applied to this form.
    */
   function __construct($form_name = 'adminForm', $form_id = 'adminForm', $form_class = '', $form_action = 'index.php', $form_task = '')
   {
        $this->form_name = $form_name;
        $this->form_id = $form_id;
        $this->form_class = $form_class;
        $this->form_action = $form_action;
        $this->form_task = $form_task;
   }

   /**
    * A method for creating columns in the first row. Each column must be added using this method.
    * @param string $collumn_name the title of this column.
    * @param string $collumn_style string intended to be inserted into the "style" attribute.For example: width:3%;colour:red;margin:5px etc.
    * @param string $collumn_class one or more classes, separated by a space, that will be applied to this column.
    */
   public function create_first_row_collumn($collumn_name, $collumn_style='', $collumn_class=''){
      $this->first_row_collumn[] = $collumn_name;
      $this->style_first_row_collumn[] = $collumn_style;
      $this->class_first_row_collumn[] = $collumn_class;

   }


   /**
    *  A method for creating columns in the second row. Each column must be added using this method.
    * @param string $collumn_name the title of this column.
    * @param string $collumn_style string intended to be inserted into the "style" attribute.For example: width:3%;colour:red;margin:5px etc.
    * @param string $collumn_class one or more classes, separated by a space, that will be applied to this column.
    */
   public function create_second_row_collumn($collumn_name, $collumn_style='', $collumn_class=''){
        if(!in_array($collumn_name, $this->second_row_collumn)){
            $this->second_row_collumn[] = $collumn_name;
            
            $this->style_second_row_collumn[] = $collumn_style;
            $this->class_second_row_collumn[] = $collumn_class;
        }
        // var_dump($this->second_row_collumn);
   }

    /**
    *  A method for adding filters to a form. Each new filter should be added using this method.
    * @param string $filter_html html code for filter.
    */
   public function create_filters($filter_html){
      $this->filters[] = $filter_html;
   }

    /**
    *  A method for adding hidden inputs.
    * @param string $name input name.
    * @param string $value input value.
    */
    public function create_hiddens_input($name, $value){
        $this->hiddenInputs[] = '<input type="hidden" name="'.$name.'" value="'.$value.'"/>';
    }

   /**
    * A method which is used to add data for the first row.
    * @param array $first_row_data array with the data of the first row starting from the first column.
    * @param string $first_row_data_class class that will be applied to the first and second row wrapper.
    */
   public function create_first_row_data($first_row_data, $first_row_data_class='' ){
    $this->first_row_data[] = $first_row_data;
    $this->first_row_data_class[] = $first_row_data_class;
    
   }

   /**
    * A method which is used to add data for the second row.
    * @param array $second_row_data array with the data of the second row starting from the first column.
    * @param string $second_row_data_class class that will be applied to the second row wrapper.
   */
   public function create_second_row_data($second_row_data, $second_row_data_class='' ){
    $this->second_row_data[] = $second_row_data;
    $this->second_row_data_class[] = $second_row_data_class;
    
   }

   /**
    * A method for adding data control buttons.
    * @param string $button_name text to be displayed on the button.
    * @param string $button_task task that will be applied to the data when the button is pressed.
    * @param string $button_image link to the image that will be displayed on the button.
    * @param string $button_icon font-awesom class for icon. If this parameter is entered, the previous $button_image parameter will be ignored.
    * @param string $custom_class custom class that will be added to the button.
    * @param string $checked_instance parameter that specifies whether the selected instances should be checked.
   */
   public function create_button($button_name, $button_task, $button_image = '', $button_icon = '', $custom_class = '', $checked_instance='true', $send = 'true'){
    $button_html = '<div class="cck_header_button btn btn-light '.$custom_class.'" task="'.$button_task.'" checked_instance="'.$checked_instance.'" send="'.$send.'">';
    if($button_icon != ''){
        $button_html .= '<span class="cck_admin_table_button_image fa '.$button_icon.'"></span>';
    }elseif($button_image != ''){
        $button_html .= '<span class="cck_admin_table_button_image"><img src="'.$button_image.'"></img></span>';
    }
    $button_html .= $button_name.'</div>';
    // $button_html = '<div class="cck_header_button btn btn-light" task="'.$button_task.'"><span class="cck_admin_table_button_image"><img src="'.$button_image.'"></img></span>'.$button_name.'</div>';
    $this->buttons[] = $button_html;
   }

    /**
    * A method that generates a table from previously entered data.
    * @return string html
   */
   public function viewTable(){
    // var_dump($this->second_row_collumn);
    // var_dump($this->second_row_data);
      $viewTableHtml = '';
      
      ob_start();
      ?>
      
      <form action="<?php echo $this->form_action; ?>" method="post" name="<?php echo $this->form_name; ?>"  class="<?php echo $this->form_class; ?>"  id="<?php echo $this->form_id; ?>" >
            <div class="os_ckk_admin_header">
                <?php
                foreach($this->buttons as $button){
                    echo $button;
                }
                ?>
            </div>
            <div class="list_13 filters wrapper_filters">
                <?php
                  foreach($this->filters as $filter){
                     echo $filter;
                  }
                ?>
            </div>
            <div class="wrapper_filters_right">
                <?php echo $this->limitbox; ?>
            </div>

            <div class="admin-order-title <?php echo $this->title_class; ?>">
                <?php
                  foreach($this->first_row_collumn as $i => $collumn_arr){
                    //  if(isset($collumn_arr['width']) && $collumn_arr['width'] && $collumn_arr['width'] != '' && $collumn_arr['width'] != 0){
                    //     $width_str = 'style="width:'.$collumn_arr['width'].'%;"';
                    //  }else{
                    //     $width_str = '';
                    //  }
                     echo '<div class="'.$this->class_first_row_collumn[$i].'" style="' . $this->style_first_row_collumn[$i] . '">'.$collumn_arr.'</div>';
                  }
                ?>
            </div>

            <?php 

            foreach($this->first_row_data as $row_i => $single_row){
                ?>
                <div class="admin-one-order <?php echo $this->first_row_data_class[$row_i]; ?>">
                    <div class="admin-order-standart-fields <?php echo $this->first_row_custom_class; ?>">
                        <?php
                        foreach($single_row as $i => $data){
                            // if(isset($this->first_row_collumn[$i]['width']) && $this->first_row_collumn[$i]['width'] && $this->first_row_collumn[$i]['width'] != '' && $this->first_row_collumn[$i]['width'] != 0){
                            //     $style_first_row_str = 'style="width:'.$this->first_row_collumn[$i]['width'].'%;"';
                            // }else{
                            //     $style_first_row_str = '';
                            // }
                            
                            ?>
                            <div class="<?php echo $this->class_first_row_collumn[$i] ?>" style="<?php echo $this->style_first_row_collumn[$i] ?>">
                                <?php echo $data; ?>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                    <?php
                    if(isset($this->second_row_data[$row_i])){
                        if(isset($this->second_row_collumn[$row_i]['width']) && $this->second_row_collumn[$row_i]['width'] && $this->second_row_collumn[$row_i]['width'] != '' && $this->second_row_collumn[$row_i]['width'] != 0){
                            $second_row_width_str = 'style="width:'.$this->second_row_collumn[$row_i]['width'].'%;"';
                         }else{
                            $second_row_width_str = '';
                         }
                        // var_dump($this->second_row_collumn[$row_i]);
                        // echo '1111111111111';
                        ?>
                        <div class="admin-order-products">
                        <?php
                        foreach($this->second_row_data[$row_i] as $sec_row){
                            
                            ?>
                                <div class="admin-order-single-product <?php echo $this->second_row_data_class[$row_i]; ?>">  
                                <?php
                                foreach($sec_row as $sec_row_i => $sec_row_single){
                                    
                                ?>
                                
                                <div>
                                    <div class="<?php echo $this->class_second_row_collumn[$sec_row_i];?>" style="<?php echo $this->style_second_row_collumn[$sec_row_i];?>"><?php echo $this->second_row_collumn[$sec_row_i]; ?></div>
                                    <div class="<?php echo $this->class_second_row_collumn[$sec_row_i];?>" style="<?php echo $this->style_second_row_collumn[$sec_row_i];?>"><?php echo $sec_row_single; ?></div>
                                </div>
                                
                                <?php
                                }
                                ?>
                                </div>
                                <?php
                        }
                        ?>
                        </div>
                        <?php

                    }
                    ?>
                </div>
                <?php
            }
            
            
            
                    ?>
                <!-- </div>
            </div> -->
            


            <?php echo $this->paginator; ?>
            <input type="hidden" name="option" value="com_os_cck" />
            <!-- <input type="hidden" id="task" name="task" value="orders" /> -->
            <input type="hidden" id="task" name="task" value="<?php echo $this->form_task; ?>" />
            <input type="hidden" name="sectionid" value="com_os_cck" />
            <input type="hidden" value="0" name="boxchecked" />

            <?php
            foreach($this->hiddenInputs as $temp_input){
                echo $temp_input;
            }
            ?>
        </form>
        <script>
            document.addEventListener('DOMContentLoaded', function(){
                jQuerOs('.cck_header_button[send=true]').on('click', function(){
                    var form_name = jQuerOs(this).parents('form').attr('name')
                    var checked_instance = jQuerOs(this).attr('checked_instance')
                    
                    // console.log('77777777777', checked_instance)
                    var form = document.forms[form_name]; 

                    var items = jQuerOs(form).find('.admin-one-order input[type=checkbox]')
                    if(checked_instance == 'true'){
                        var checked = false

                        jQuerOs(form).find('.admin-one-order input[type=checkbox]').each(function(){
                            if(jQuerOs(this).is(':checked')){
                                checked = true
                            }
                            
                        })
                    }else{
                        var checked = true
                    }
                    cckSendForm(checked, jQuerOs(this).attr('task'), form_name)
                    // if(checked){
                    //     jQuerOs(form).find('[name=task]').val(jQuerOs(this).attr('task'))
                    //     form.submit()
                    // }else{
                    //     alert('Select an item to this action')
                    // }
                    
                    
                    
                })
            })

            function cckSendForm(id, task, formName){
                if(!formName) formName='adminForm'
                var form = document.forms[formName]; 
                if(id){
                    // console.log('222222222222', id)
                    
                    if(jQuerOs('#'+id).length > 0){
                        if(!jQuerOs('#'+id).is(':checked')){
                            jQuerOs('#'+id).prop('checked', true);
                        }
                        // console.log('333333333333', (jQuerOs('#'+id).is(':checked')))
                    }
                    jQuerOs(form).find('[name=task]').val(task)
                    form.submit()
                }else{
                    alert('Select an item to this action')
                }
            }
        </script><?php

        $viewTableHtml = ob_get_contents();
        ob_clean();
        return $viewTableHtml;


   }
  

  
  

}


