<?php
 /**
   * The template for Search.
   *
   *
   * @package   ospersonality WordPress Theme
   * @copyright Copyright (C) 2016, OrdaSoft
   * @license  http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author    AUTHOR <www.ordasoft.com>
   * ospersonality is distributed under the terms of the GNU GPL
   */
$sidebar_left = false;
if (is_active_sidebar( 'sidebar_left' ) ) {
    $sidebar_left = true;
}

ospersonality_header_home()
?>

<div id="main" class="site-main">
    <div id="search" class="site-content">

        <h2 class="page-title"><?php printf( __( 'Search Results for: %s', 'ospersonality' ), '<span>' . get_search_query() . '</span>' ); ?></h2>

        <div class="row">
            <?php if (is_active_sidebar( 'sidebar_left' ) ) : ?>
            <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                <article id="sidebar-left" class="sidebar">
                <?php  dynamic_sidebar('sidebar_left'); ?>
                </article>
            </div>
            <?php endif; ?>

            <?php if($sidebar_left) :
                echo ('<div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">');
                echo ('<div class="search-content">');
            else :
                echo ('<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">');
                echo ('<div class="search-content container">');
            endif; ?>

            <?php $position = 0; ?>
            <?php if ( have_posts() ) : ?>
                <?php while ( have_posts() ) : the_post();

                  if ( $position % 1==0 ) {
                    $image_id = get_post_thumbnail_id();
                    $image_url = wp_get_attachment_image_src($image_id,800,800);
                    $image_url = $image_url[0];
                    $position++;
                    if ($position != 0 and $position % 1==0) { ?>
                    <section class="loop-item <?php if ($position != 0 and $position%2==0) :
                                                                echo 'two-post';
                                                                elseif($position != 0 and $position%3==0) :
                                                                echo 'tree-post';
                                                                else :
                                                                echo 'one-post';
                                                                endif;?>" style="background: url(<?php echo "$image_url"; ?>)">
                    <?php } ?>

                          <?php get_template_part( 'template-parts/content', get_post_format() ); ?>

                      </section>
                    <?php } ?>

                <?php endwhile; ?>
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <?php  the_posts_pagination(); ?>
                </div>
            </div>

             <?php  else :

                  get_template_part( 'template-parts/content', 'none' );

               endif; ?>

    </div>
</div><!-- #main -->
<?php get_footer(); ?>

