 <?php /**
   * The template for Content.
   *
   *
   * @package   ospersonality WordPress Theme
   * @copyright Copyright (C) 2016, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * ospersonality is distributed under the terms of the GNU GPL
   */
 ?>
<div  <?php post_class(); ?> id="post-<?php the_ID(); ?>">

        <article class="content">

            <?php if ( is_single() ) : ?>
            <header class="entry-header">
                    <h1 class="entry-title"><?php the_title(); ?></h1>
            </header><!-- .entry-header -->
            <?php endif; // is_single() ?>

            <div class="entry-content">
                <a href="<?php the_permalink(); ?>" rel="bookmark">
                    <?php if ( !is_single() && has_post_thumbnail() && ! post_password_required() ) : ?>
                    <div class="entry-thumbnail">
                        <?php the_post_thumbnail(array(250,250)); ?>
                    </div>
                    <?php else : ?>
                    <div class="entry-thumbnail">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/no-image.jpg" alt="no thumbnail"/>
                    </div>
                    <?php endif; ?>
                </a>

                <?php if ( is_single() ) : // Only display Excerpts for Search ?>
                <p><?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'ospersonality' ) ); ?></p>
                <?php wp_link_pages(array(
                    'before' => '<span style="clear:both; display:block">Pages',
                    'after'  => '</span>',
                    'next_or_number'=>'number',
                    'previouspagelink' => 'previous',
                    'nextpagelink'=> 'Next'
                )); ?>
                <?php else : ?>
                <div class="entry-summary">
                    <h2 class="entry-title">
                        <a href="<?php the_permalink(); ?>" rel="bookmark">
                            <?php the_title(); ?>
                        </a>
                    </h2>
                    <p><?php //ospersonality_excerpt('45'); ?></p>
                    <a class="more-button" href="<?php the_permalink(); ?>" rel="bookmark">
                        <?php if (get_theme_mod( 'ospersonality_more_button' )) :
                                echo esc_attr(get_theme_mod( 'ospersonality_more_button' ));
                            else :
                                _e('Enroll Now', 'ospersonality');
                            endif; ?></a>
                </div><!-- .entry-summary -->
                <?php endif; ?>
                </div><!-- .entry-content -->

                <?php if ( is_single() ) : ?>
                <footer class="entry-meta">
                <?php
                    ospersonality_entry_meta();
                    ospersonality_entry_date();

                 if ( is_single() && comments_open() ) : ?>
                    <div class="comments-link">
                    <i class="fa fa-commenting-o"></i>
                        <?php comments_popup_link( '<span class="leave-reply">' . __( 'Leave a comment', 'ospersonality' ) . '</span>', __( 'One comment so far', 'ospersonality' ), __( 'View all % comments', 'ospersonality' ) ); ?>
                    </div><!-- .comments-link -->
                <?php endif; // comments_open() ?>

            <?php if ( is_single() && get_the_author_meta( 'description' ) && is_multi_author() ) : ?>
                <?php get_template_part( 'author-bio' ); ?>
            <?php endif; ?>
        </footer><!-- .entry-meta -->
        <?php  endif; ?>

    </article>
</div><!-- #post -->
