<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 *
 * @package WordPress
 * @subpackage bpm128
 * @since 1.0
 * @version 1.0
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">

	<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) : ?>
		<h2 class="comments-title">
			<?php
				$comments_number = get_comments_number();
				if ( '1' === $comments_number ) {
					/* translators: %s: post title */
					printf( _x( 'One Reply to &ldquo;%s&rdquo;', 'comments title', 'bpm128' ), get_the_title() );
				} else {
					printf(
						/* translators: 1: number of comments, 2: post title */
						_nx(
							'%1$s Reply to &ldquo;%2$s&rdquo;',
							'%1$s Replies to &ldquo;%2$s&rdquo;',
							$comments_number,
							'comments title',
							'bpm128'
						),
						number_format_i18n( $comments_number ),
						get_the_title()
					);
				}
			?>
		</h2>

		<ol class="comment-list">
			<?php
				wp_list_comments( array(
					'avatar_size' => 100,
					'style'       => 'ol',
					'short_ping'  => true,
					'reply_text'  => bpm128_get_svg( array( 'icon' => 'mail-reply' ) ) . __( 'Reply', 'bpm128' ),
				) );
			?>
		</ol>

		<?php the_comments_pagination( array(
			'prev_text' => bpm128_get_svg( array( 'icon' => 'arrow-left' ) ) . '<span class="screen-reader-text">' . __( 'Previous', 'bpm128' ) . '</span>',
			'next_text' => '<span class="screen-reader-text">' . __( 'Next', 'bpm128' ) . '</span>' . bpm128_get_svg( array( 'icon' => 'arrow-right' ) ),
		) );

	endif; // Check for have_comments().

	// If comments are closed and there are comments, let's leave a little note, shall we?
	if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>

		<p class="no-comments"><?php _e( 'Comments are closed.', 'bpm128' ); ?></p>
	<?php
	endif;

	 $commenter = wp_get_current_commenter();
                $req = get_option( 'require_name_email' );
                $aria_req = ( $req ? " aria-required='true'" : '' );
                $fields =  array(
                    'author' => '<p class="comment-form-author">' . ( $req ? '<span class="required"></span>' : '' ) .
                    '<input id="author" name="author" type="text" placeholder="Name*" value="' . esc_attr( $commenter['comment_author'] ) . '" size="50"' . $aria_req . ' /></p>',
                    'email'  => '<p class="comment-form-email">' . ( $req ? '<span class="required"></span>' : '' ) .
                    '<input id="email" name="email" type="text" placeholder="Email*" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="50"' . $aria_req . ' /></p>'
                );

                $comments_args = array(
                    'fields' =>  $fields,
                    'comment_field' =>  '<p class="comment-form-comment"><textarea id="comment" name="comment"  placeholder="Comment" cols="49" rows="8" aria-required="true"></textarea></p>',
                    'label_submit' => __('Comment', 'ospersonality')

                );

                comment_form($comments_args); ?>

</div><!-- #comments -->
