<?php
/**
 * Displays content for front page
 *
 * @package WordPress
 * @subpackage bpm128
 * @since 1.0
 * @version 1.0
 */

?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'bpm128-panel ' ); ?> >

	<?php if ( has_post_thumbnail() ) :
		$thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'bpm128-featured-image' );

		$post_thumbnail_id = get_post_thumbnail_id( $post->ID );

		$thumbnail_attributes = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'bpm128-featured-image' );


		$ratio = $thumbnail_attributes[2] / $thumbnail_attributes[1] * 100;
		?>

	<div class="panel-content with-bg" style="background-image: url(<?php echo esc_url( $thumbnail[0] ); ?>);">
	<?php else: ?>
	<div class="panel-content">
	<?php endif; ?>
	
		<div class="wrap">
			<header class="entry-header">
				<?php the_title( '<h2 class="entry-title">', '</h2>' ); ?>

				<?php bpm128_edit_link( get_the_ID() ); ?>

			</header><!-- .entry-header -->

			<div class="entry-content">
				<?php
					/* translators: %s: Name of current post */
					the_content( sprintf(
						__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'bpm128' ),
						get_the_title()
					) );
				?>
			</div><!-- .entry-content -->

		</div><!-- .wrap -->

		

	</div><!-- .panel-content -->



</article><!-- #post-## -->
