jQuerOs(document).ready(function () {

    function addClassToParent(event) {
        const menuItem = event.target.closest('.deeper');
        if (menuItem && event.type === 'focusin') {
            menuItem.classList.add('focus');
        }
    }

    function removeClassFromParent(event) {
        const menuItem = event.target.closest('.deeper');
        if (menuItem && event.type === 'focusout' && !menuItem.contains(event.relatedTarget)) {
            menuItem.classList.remove('focus');
        }
    }

    const handleSubMenu = (subMenu) => {
        subMenu.addEventListener('focusin', addClassToParent);
        subMenu.addEventListener('focusout', removeClassFromParent);

        const deeperItems = subMenu.querySelectorAll('.deeper');
        deeperItems.forEach(deeperItem => {
            const nestedSubMenu = deeperItem.querySelector('.mod-menu__sub');
            if (nestedSubMenu) {
                handleSubMenu(nestedSubMenu);
            }

            deeperItem.addEventListener('focusin', addClassToParent);
            deeperItem.addEventListener('focusout', removeClassFromParent);
        });
    };

    const menuItems = document.querySelectorAll('.mod-menu .deeper');

    menuItems.forEach(item => {
        const subMenu = item.querySelector('.mod-menu__sub');
        if (subMenu) {
            handleSubMenu(subMenu);
        }

        item.addEventListener('focusin', addClassToParent);
        item.addEventListener('focusout', removeClassFromParent);
    });

    //if (jQuerOs("[rel=tooltip]").length) {jQuerOs("[rel=tooltip]").tooltip();}
    // jQuerOs('button').addClass('btn');
    // ____________________________________________________________________________________________ resize display

    // var myWidth = 0;
    // myWidth = window.innerWidth;
    // jQuerOs('body').prepend('<div id="size" style="background:#000;padding:5px;position:fixed;z-index:999;color:#fff;">Width = '+myWidth+'</div>');
    // jQuerOs(window).resize(function(){
    //     var myWidth = 0;
    //     myWidth = window.innerWidth;
    //     jQuerOs('#size').remove();
    //     jQuerOs('body').prepend('<div id="size" style="background:#000;padding:5px;position:fixed;z-index:999;color:#fff;">Width = '+myWidth+'</div>');
    // });

    // ____________________________________________________________________________________________ responsive menu

    jQuerOs('.main_menu .navbar-toggle').on('click', function () {
        if (jQuerOs('.main_menu .collapse').hasClass('menu_active')) {
            jQuerOs(".main_menu .collapse").addClass("menu_in_active");
            jQuerOs(".main_menu .collapse").removeClass("menu_active");
        } else {
            jQuerOs(".main_menu .collapse").removeClass("menu_in_active");
            jQuerOs(".main_menu .collapse").addClass("menu_active");
        }
    });

    jQuerOs('.footer_menu .navbar-toggle').on('click', function () {
        if (jQuerOs('.footer_menu .collapse').hasClass('menu_active')) {
            jQuerOs(".footer_menu .collapse").addClass("menu_in_active");
            jQuerOs(".footer_menu .collapse").removeClass("menu_active");
        } else {
            jQuerOs(".footer_menu .collapse").removeClass("menu_in_active");
            jQuerOs(".footer_menu .collapse").addClass("menu_active");
        }
    });





    var mainMenu = jQuerOs('.main_menu ul.nav');
    mainMenu.find('li.parent > a,li.parent > .mod-menu__heading ').append('<span class="arrow"></span>');
    mainMenu.find(' > li').last().addClass('lastChild');
    // ____________________________________________________________________________________________

});