(function () {
    
    var osGallery = function (container, params) {
        if (!(this instanceof osGallery)) return new osGallery(container, params);

        var defaults = {
            minImgEnable : 1,
            spaceBetween: 2.5,
            minImgSize: 200,
            numColumns: 3,
            showImgTitle: '',
            showImgDescription: '',
            limEnd: 5,
            galId: 1,
            galIdRandom: 1,
            imgCountCat: '',
            load_more_background: '',
            os_fancybox_background: '',
            showLoadMore: '',
            juri: '',
            itemId: '',
            layout: 'default',
            albumSublayout: 'defaultTabs',
            modId: 0,
            searchText: '',
            fancSettings:{
                wrapCSS: 'os-os_fancybox-window',
                animationEffect: false,
                animationDuration: '500',
                transitionEffect: false,
                transitionDuration: '800',
                loop: false,
                arrows: true,
                clickContent: 'zoom',
                wheel : false,
                slideShow : {
                    autoStart : false,
                    speed     : 4000
                },
                clickSlide : 'close',
                thumbs : {
                    autoStart : true,
                    axis : 'y'
                },
                buttons : [
                'slideShow',
                'fullScreen',
                'thumbs',
                'share',
                'download',
                'zoom',
                'arrowLeft',
                'arrowRight',
                'close'
                ],
                share : {
                    tpl : ''
                },
                infobar : true,
                baseClass : 'thumb_right'
            }
        };

        for (var param in defaults) {
          if (!params[param] && params[param] != 0){
            params[param] = defaults[param];
          }
        }
        // gallery settings
        var osg = this;
        // Params
        osg.params = params || defaults;
        
        osg.getImgBlockWidth = function (numColumns){
            if(typeof(numColumns) == 'undefined')numColumns = osg.params.numColumns;
            var checkSpaceBetween = osg.params.spaceBetween;
            spaceBetween = osg.params.spaceBetween*2;
            mainBlockW = jQuerOs(container).width();
            
            
            imgBlockW = ( (((mainBlockW-(spaceBetween*numColumns))/numColumns) )*100)/mainBlockW  ;
            if(osg.params.minImgEnable){
                if(((imgBlockW*mainBlockW)/100) < osg.params.minImgSize){
                    numColumns--;
                    osg.getImgBlockWidth(numColumns);
                }
            }
            var sizeAwesome = ((imgBlockW*mainBlockW)/100)/11+"px";
            jQuerOs(container +" .andrea-effect .andrea-zoom-in").css({'width': sizeAwesome, 'height': sizeAwesome });
            var fontSizetext = ((imgBlockW*mainBlockW)/100)/15+"px";
            jQuerOs(container +" .img-block").css({'font-size': fontSizetext, 'line-height': fontSizetext });

            return imgBlockW;

        }
        
        osg.imageWidthCalculation = function(catId, numColumns){
            if(typeof(numColumns) == 'undefined'){
                numColumns = osg.params.numColumns;
            }
            
            var mainBlockW = jQuerOs(container).width();
            var imgBlockK = 1 / numColumns;
            //var result = [];
            var images = jQuerOs.makeArray(jQuerOs("#cat-"+ catId +"-"+osg.params.galIdRandom+" .img-block a img"));
            var images_a = jQuerOs("#cat-"+ catId +"-"+osg.params.galIdRandom+" .img-block a").find("img:first");
            images = jQuerOs.makeArray(images_a)
            
            var min = jQuerOs(images[0]).prop('naturalHeight') * imgBlockK;
            //var countImg = mainBlockW/min;
            //var counter = images.length;
            spaceBetween = osg.params.spaceBetween*2;

            var copyImages = images.slice();
            var arr_1 = [];
            var arr_2 = [];
            var arr_3 = [];
            var widthRows = 0;
            var k_height = 0 ;
            while(copyImages.length > 0){
                arr_1 = copyImages.splice(0, numColumns);
                //суммирование длин картинок в массиве arr_1
                for(var i = 0; i < arr_1.length; i++){
                    widthRows += (jQuerOs(arr_1[i]).prop('naturalWidth'));
                }
                var k = (mainBlockW - ((numColumns) * spaceBetween) - (numColumns) ) / (widthRows );
                if (k_height == 0 ) k_height = k ;

                //set k for last images
                if(k_height > 0 && arr_1.length < numColumns && k > k_height){
                    k = k_height;
                }

                for(var i = 0; i < arr_1.length; i++){
                    arr_2.push((jQuerOs(arr_1[i]).prop('naturalWidth')) * k);
                    arr_3.push((jQuerOs(arr_1[i]).prop('naturalHeight')) * k_height);
                }
                widthRows = 0;
                //clear array
                arr_1 = [];
            }

            var imag = jQuerOs("#cat-"+ catId +"-"+osg.params.galIdRandom+" .img-block a img");
            imag = jQuerOs("#cat-"+ catId +"-"+osg.params.galIdRandom+" .img-block a");
            var j = 0;
            
            jQuerOs.each(imag, function(){
                var img = jQuerOs(this).find("img");
                
                var w_ = arr_2[j];
                var h_ = arr_3[j];

                img.css('width', w_ + "px");
                jQuerOs(this).css('width', w_ + "px");
//                jQuerOs(this).parent().find(".os-gallery-caption-top").css('width', w_ + "px");
//                jQuerOs(this).parent().find(".os-gallery-caption-bottom").css('width', w_ + "px");
                jQuerOs(this).find(".os-gallery-caption-top").css('width', w_ + "px");
                jQuerOs(this).find(".os-gallery-caption-bottom").css('width', w_ + "px");
                img.css('height', h_ + "px");
                jQuerOs(this).css('height', h_ + "px");

                j++;
            });

            var imgBlockWpx = (mainBlockW - (spaceBetween*numColumns))/numColumns;
            if(osg.params.minImgEnable){
                if(((imgBlockWpx*mainBlockW)/100) < osg.params.minImgSize){
                    numColumns--;
                    osg.sortImg(catId, numColumns);
                }
            }
        }

        
        //initialize function
        osg.init = function(limEnd){ 
            inProgressAjax = false;
            
            if(limEnd != 0) jQuerOs(container+" .osgalery-cat-tabs#"+osg.params.galIdRandom+" a.active").attr('data-end', limEnd);

            imgBlockW = osg.getImgBlockWidth();
            
            jQuerOs(container+" .osgalery-cat-tabs#"+osg.params.galIdRandom).css("padding", osg.params.spaceBetween + "px");
            jQuerOs("#button-"+osg.params.galIdRandom).css("padding", osg.params.spaceBetween + "px");
            
            if(osg.params.layout == 'default' || osg.params.layout == 'search'){
                jQuerOs(container+" .img-block").css("width",imgBlockW+"%");
            }
            jQuerOs(container+" .os-cat-tab-images div[id^='cat-']").each(function(index, el) {

                catId = jQuerOs(this).data("cat-id");
                if(catId){

                    var os_fancy_box = jQuerOs(this).find(".os_fancybox-"+catId ).os_fancybox({



                       beforeShow: function(){

                            // resize html block to image width
                            if (this.os_image_id){
                                var id = this.os_image_id;
                            }
                            else {
                                var id = this.opts.$orig.attr('id');
                            }
                            id = id.split('-')[1];//get scalar id
                            var naturalWidth = jQuerOs('.htmlWidthAsImage#data-html-'+id+' .imgInHtml img').prop('naturalWidth');
                            if(naturalWidth){  
                                jQuerOs('.htmlWidthAsImage#data-html-'+id).css({'padding' : 0, 'width' : naturalWidth});
                                jQuerOs('.htmlWidthAsImage#data-html-'+id+' .contentInHtml').css({'padding' : 15});
                            }
                            jQuerOs('.os_fancybox-bg').css('backgroundColor', osg.params.os_fancybox_background);

                            if (this.os_image_id){
                                var id = this.os_image_id;
                            }    
                            else {
                                var id = this.opts.$orig.attr('id');
                            }

                            var href = window.location.href;

                            if(!from_history){


                                if (href.indexOf('&os_image_id') > -1) {

                                    history.pushState (null, null, href.substring(0, href.indexOf('&os_image_id') )+ "&" + id);
                                }
                                else if (href.indexOf('?os_image_id') > -1) {

                                    history.pushState (href, null, href.substring(0, href.indexOf('?os_image_id')) + "?" + id);}
                                else if (href.indexOf('?') > -1 && href.indexOf('&') > -1 && href.indexOf('&os_image_id') == -1){

                                    history.pushState(null, null, href + '&' + id);}
                                else if ( href.indexOf('&') == -1 && href.indexOf('?os_image_id') == -1 && href.indexOf('?') == -1){

                                    history.pushState(null, null, href + '?' + id);}
                                else if (href.indexOf('?') > -1 && href.indexOf('os_image_id') == -1 ){

                                    history.pushState(null, null, href + '&' + id);
                                }

                            }
//                                        
//                                       



                        },
                        beforeClose: function(){

                            var href = window.location.href;

                            if (href.indexOf('&os_image_id') > -1){
                                history.pushState (href, null, href.substring(0, href.indexOf('&os_image_id')));
                            }else{
                                history.pushState (href, null, href.substring(0, href.indexOf('?os_image_id')));
                            } 
                            //return value scroll for load more function
                            
                            jQuerOs('.os-cat-tab-images .active').removeClass('active');
                        },
                        beforeLoad: function() {
                            //not use because call many times for one image



                        },
                        afterShow: function() {

                            
                        },
                        afterLoad: function(){
                            //not use because call many times for one image
                        },        


                        wrapCSS    : osg.params.fancSettings.wrapCSS,

                        animationEffect : osg.params.fancSettings.animationEffect,
                        animationDuration : osg.params.fancSettings.animationDuration,
                        transitionEffect : osg.params.fancSettings.transitionEffect,
                        transitionDuration : osg.params.fancSettings.transitionDuration,
                        loop: osg.params.fancSettings.loop,
                        arrows: osg.params.fancSettings.arrows,
                        clickContent : function( current, event ) {
                            return current.type === 'image' ? osg.params.fancSettings.clickContent : false;
                        },
                        wheel : osg.params.fancSettings.wheel,
                        slideShow : {
                            autoStart : osg.params.fancSettings.slideShow.autoStart,
                            speed     : osg.params.fancSettings.slideShow.speed
                        },

                        clickSlide : osg.params.fancSettings.clickSlide,
                        thumbs : {
                            autoStart : osg.params.fancSettings.thumbs.autoStart,
                            axis      : osg.params.fancSettings.thumbs.axis
                        },
                        buttons : [
                            osg.params.fancSettings.buttons.slideShow,
                            osg.params.fancSettings.buttons.fullScreen,
                            osg.params.fancSettings.buttons.thumbs,
                            osg.params.fancSettings.buttons.share,
                            osg.params.fancSettings.buttons.download,
                            osg.params.fancSettings.buttons.zoom,
                            osg.params.fancSettings.buttons.arrowLeft,
                            osg.params.fancSettings.buttons.arrowRight,
                            osg.params.fancSettings.buttons.close,
                        ],
                        share : {
                            tpl : osg.params.fancSettings.share.tpl
                        },
                        infobar: osg.params.fancSettings.infobar, //counter on/off
                        baseClass : osg.params.fancSettings.baseClass, //add appropriate class to set thumbnails position {thumb_bottom},{thumb_right}
                        loadmore : false,

                    });
                }
            });
            
            jQuerOs(container+" .os-cat-tab-images div:first-child").show();
            jQuerOs(container+" .osgalery-cat-tabs#"+osg.params.galIdRandom+" li:first-child a").addClass("active");

            
            var curCatId = jQuerOs(container+" .osgalery-cat-tabs#"+osg.params.galIdRandom+" a.active").attr('data-cat-id');    
            


            if(curCatId == undefined){
                curCatId = 1
            }
            var curEnd = jQuerOs(container+" .osgalery-cat-tabs#"+osg.params.galIdRandom+" a.active").attr('data-end');
            if(curEnd === undefined){
                curEnd = osg.params.limEnd;
            }

            jQuerOs("#load-more-"+osg.params.galIdRandom).attr('data-cat-id', curCatId);
            jQuerOs("#load-more-"+osg.params.galIdRandom).attr('data-end', curEnd);

            if(osg.params.imgCountCat != ''){
                var img_count_cat = JSON.parse(osg.params.imgCountCat);
            }else{
                var img_count_cat = '';
            }

            if(img_count_cat != '' && jQuerOs('#cat-' + curCatId +'-'+osg.params.galIdRandom).children().length >= img_count_cat[curCatId]){
                jQuerOs("#load-more-"+osg.params.galIdRandom+"[data-cat-id="+curCatId+"]").hide();
            }else if(img_count_cat != '' && !Array.isArray(img_count_cat) && jQuerOs('#cat-1-'+osg.params.galIdRandom).children().length >= img_count_cat){
                jQuerOs("#load-more-"+osg.params.galIdRandom).hide();
            }
            
            jQuerOs(container+" .osgalery-cat-tabs#"+osg.params.galIdRandom+" a").click(function(e) {

                e.preventDefault();
                jQuerOs('li a').removeClass("active");
                jQuerOs(container+" .os-cat-tab-images>div").hide();
                jQuerOs(this).addClass("active");
                curCatId = jQuerOs(container+" .osgalery-cat-tabs#"+osg.params.galIdRandom+" a.active").attr('data-cat-id');
                var href = window.location.href;
                if (!from_history && href.indexOf('os_image_id') == -1){
                    if (href.indexOf('?cat-') > -1) {

                        history.pushState (null, null, href.substring(0, href.indexOf('?cat-') ) + '?cat-' + curCatId);
                    }else if (href.indexOf('&cat-') > -1) {

                        history.pushState (null, null, href.substring(0, href.indexOf('&cat-') ) + '?cat-' + curCatId);
                    }else if (href.indexOf('?') > -1){

                        history.pushState(null, null, href + '&cat-' + curCatId);
                    }else {

                        history.pushState(null, null, href + '?cat-' + curCatId);
                    }
                }

                jQuerOs("#cat-"+curCatId+"-"+osg.params.galIdRandom).show();
                jQuerOs("#load-more-"+osg.params.galIdRandom).attr('data-cat-id', curCatId);
                curEnd = jQuerOs(container+" .osgalery-cat-tabs#"+osg.params.galIdRandom+" a.active").attr('data-end');
                if(img_count_cat != '' && jQuerOs('#cat-' + curCatId +'-'+osg.params.galIdRandom).children().length >= Number(img_count_cat[curCatId])){

                    jQuerOs("#load-more-"+osg.params.galIdRandom+"[data-cat-id="+curCatId+"]").hide();
                }else{

                    jQuerOs("#load-more-"+osg.params.galIdRandom+"[data-cat-id="+curCatId+"]").show();
                }
                if(curEnd != -1){
                    jQuerOs("#load-more-"+osg.params.galIdRandom).removeAttr("disabled");
                    jQuerOs("#load-more-"+osg.params.galIdRandom).css("background", osg.params.load_more_background);
                }
                jQuerOs("#load-more-"+osg.params.galIdRandom).attr('data-end', curEnd);
                jQuerOs(jQuerOs(this).attr("href")).fadeTo(500, 1);

                if(osg.params.layout == 'masonry'){
                    osg.reloadIsotope();
                }else if(osg.params.layout == 'fitRows'){
                    osg.fitRowsIsotope(curCatId);
                }

            });
            jQuerOs('.img-block').on('click', function(){
                //e.preventDefault();
                jQuerOs('li a').removeClass("active");
                jQuerOs(this).parent().addClass('active');
                curCatId = jQuerOs(this).parent().attr('data-cat-id');
                var href = window.location.href;
                //???????
                if (!from_history && href.indexOf('os_image_id') == -1){
                    if (href.indexOf('?cat-') > -1) {

                        history.pushState (null, null, href.substring(0, href.indexOf('?cat-') ) + '?cat-' + curCatId);
                    }else if (href.indexOf('&cat-') > -1) {

                        history.pushState (null, null, href.substring(0, href.indexOf('&cat-') ) + '?cat-' + curCatId);
                    }else if (href.indexOf('?') > -1){

                        history.pushState(null, null, href + '&cat-' + curCatId);
                    }else {

                        history.pushState(null, null, href + '?cat-' + curCatId);
                    }
                }
                //????????
                jQuerOs("#load-more-"+osg.params.galIdRandom).attr('data-cat-id', curCatId);
                curEnd = jQuerOs('a#cat-'+curCatId+osg.params.galIdRandom).attr('data-end');

                jQuerOs("#load-more-"+osg.params.galIdRandom).attr('data-end', curEnd);


            });
            
            
            osg.resizeGallery = function (){
                imgBlockW = osg.getImgBlockWidth();
                jQuerOs(container+" .img-block").css("width",imgBlockW+"%");
            }

            jQuerOs(window).resize(function(event) {
                osg.resizeGallery();
            });
            
            
        }
        osg.init();
        setTimeout(osg.resizeGallery, 200);

        

    }
    window.osGallery = osGallery;
})();