    <?php
    defined( '_JEXEC' ) or die( 'Restricted access' );
    /**
     * @version 6.6
     * @package OS CCK select currency
     * @copyright 2019 OrdaSoft
     * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
     * @description Select currency for OS CCK Component
    */
    if(!defined('DS')){
        define('DS', DIRECTORY_SEPARATOR  );
    }
    
    require_once ( JPATH_BASE .DS.'components'.DS.'com_os_cck'.DS.'os_cck.php' );
    require_once ( JPATH_BASE .DS.'components'.DS.'com_os_cck'.DS.'functions.php' );
    
    $os_cck_configuration = JComponentHelper::getParams('com_os_cck');
    $paypal_currency = cck_getCurrency($os_cck_configuration);
    $currencyOpt = array();
    foreach ($paypal_currency as $carrencyArr) {
      $currencyOpt[] = JHTML::_('select.option', $carrencyArr['sign'], $carrencyArr['signAlias'], "value", "text");
    }
    //$currency = (isset($entityInstance->instance_currency) && !empty($entityInstance->instance_currency))?$entityInstance->instance_currency : '';
    $session = JFactory::getSession();
    
    $currency = $session->get('currency', '');
    if($currency == ''){
        $session->set('currency', $paypal_currency[0]['sign']);
    }
    
    $currencySelect = JHTML::_('select.genericlist', $currencyOpt, "instance_currency", 'class="cck-currency" style="width: auto !important;" onchange="javascript:change_currency();"', 'value', 'text', $currency);
    
    echo '<div class="module_select_currency">';
    echo $currencySelect;
    echo '</div>';
 
    
    /** ensure this file is being included by a parent file */

    ?>


<script type="text/javascript">
    function change_currency(){
        var currency = jQuerOs('#instance_currency').val();
        jQuerOs.ajax({
            dataType: "json",
            type: 'POST',
            url: 'index.php?option=com_os_cck&format=raw',
            data: {
                task: "changeCurrency",
                currency: currency,
            },
            success: function(data){
                var href = window.location.href;
                if (href.indexOf('?index.php') > -1) {
                    if (href.indexOf('&currency') > -1) {
                        var new_href = href.substring(0, href.indexOf('&currency') )+ "&currency=" + currency;

                        document.location.href = new_href;
                    }
                }else{
                    if (href.indexOf('&currency') > -1) {
                        var new_href = href.substring(0, href.indexOf('&currency') )+ "&currency=" + currency;

                        document.location.href = new_href;
                    }else if(href.indexOf('?currency') > -1){
                        var new_href = href.substring(0, href.indexOf('?currency') )+ "?currency=" + currency;

                        document.location.href = new_href;
                    }
                }
//                console.log('111111111111111', new_href)
//                location.reload();
            }

        });
    }
    
    window.addEventListener('load', function() {
        var href = window.location.href;
        var currency = jQuerOs('#instance_currency').val();
        if(href.indexOf('&currency=') == -1 && href.indexOf('?currency=') == -1){
            if (href.indexOf('?index.php') > -1) {
                history.pushState(null, null, href + '&currency=' + currency);
            }else{
                if (href.indexOf('?') > -1) {
                    history.pushState(null, null, href + '&currency=' + currency);
                }else{
                    history.pushState(null, null, href + '?currency=' + currency);
                }
            }
        }
    });
</script>
