<?php
/**
 * 
 * @package simpleMembership
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); 
 * Homepage: http://www.ordasoft.com
 * @version: 1.0 PRO
 * PayPal subsciption documentation
 * https://www.paypalobjects.com/webstatic/en_US/developer/docs/pdf/archive/PP_subscriptions.pdf
 *
 */
defined ('_JEXEC') or die ("Go away.");
defined( 'DS' ) or define( 'DS', DIRECTORY_SEPARATOR);

jimport( 'joomla.plugin.plugin' );

require_once(dirname(__FILE__).DS.'paypal'.DS.'helper.php');

class  plgPaymentPaypal extends JPlugin
{
        public $responseStatus = array (
                                'Completed' 		=> 'C',
                                'Pending' 			=> 'P',
                                'Failed' 			=> 'E',
                                'Denied' 			=> 'D',
                                'Refunded'			=> 'RF',
                                'Canceled_Reversal' => 'CRV',
                                'Reversed'			=> 'RV'
                        );
        function __construct($subject, $config)
        {
                parent::__construct($subject, $config);
                //Set the language in the class
                //$config = JFactory::getConfig();

                //Define Payment Status codes in Paypal  And Respective Alias in Framework
                $this->responseStatus= array (
                                'Completed' => 'C',
                                'Pending'   => 'P',
                                'Failed'    => 'E',
                                'Denied'    => 'D',
                                'Refunded'  => 'RF',
                                'Canceled_Reversal' => 'CRV',
                                'Reversed'  => 'RV'
                        );
        }
        function validateIPN($owner_paypal = null) {
        $params = $this->params;
        $paypal_real_or_test  =  $params->get('paypal_real_or_test');
        if($owner_paypal){
            $receiver_email  =  $owner_paypal;
        }else{
            $receiver_email  =  $params->get('paypal_email');
        }
        $currency_code  =  array('AUD','CAD','CZK','DKK','EUR','HKD','HUF','JPY','NOK','NZD',
                                    'PLN','SGD','SEK','CHF','USD','RUB','ILS','MXN','PHP','GBP','THB');
        return plgPaymentPaypalHelper::validateIPN($paypal_real_or_test,$receiver_email,$currency_code,$params);
        }

        /* Internal use functions */
        function buildLayoutPath($layout) {
            global $user_configuration;
                jimport('joomla.filesystem.file');
                $app = JFactory::getApplication();
                $core_file  = dirname(__FILE__).DS.$this->_name.DS.'tmpl'.DS.$layout.'.php';
                $override = JPATH_BASE.DS.'templates'.DS.$app->getTemplate().DS.'html'.DS.'plugins'.DS.$this->_type.DS.$this->_name.DS.$layout.'.php';
                if(JFile::exists($override))
                {
                        return $override;
                }
                else
                {
                return  $core_file;
        }
        }

        //Builds the layout to be shown, along with hidden fields.
        function buildLayout($vars, $layout = 'default' )
        {   global $user_configuration;
                // Load the layout & push variables
                ob_start();
                $layout = $this->buildLayoutPath($layout);
                include($layout);
                $html = ob_get_contents(); 
                ob_end_clean();
                return $html;
        }

        // Used to Build List of Payment Gateway in the respective Components
        function onTP_GetInfo($config)
        {

                if(!in_array($this->_name,$config))
                return;
                $obj = new stdClass;
                $obj->name =$this->params->get( 'plugin_name' );
                $obj->id = $this->_name;
                return $obj;
        }

        //Constructs the Payment form in case of On Site Payment gateways like Auth.net & constructs the Submit button in case of offsite ones like Paypal
        function getHTMLPayPal($varss, $data = null, $req = null) {
            global $mosConfig_absolute_path, $user_configuration;
            $database = JFactory::getDbo();
            ///get params
            $components = $_REQUEST['option'];
            $params = $this->params;
            $vars['paypal_email'] =  $params->get('paypal_email','');
            $vars['main_receiver'] = (isset($varss['owner_paypal_email']))? $varss['owner_paypal_email'] : '';
            $vars['comission_receiver'] = $params->get('paypal_email');
            $vars['item_number']  = '';
            $vars['return_url'] =  JUri::base().'index.php?option='.$components.'&view=paypal&operation=success&';
            $vars['cancel_url'] =  JUri::base().'index.php?option='.$components.'&view=paypal&operation=cancel&';
            $vars['notify_url'] =  JUri::base().'index.php?option='.$components.'&view=paypal&operation=notify&';
            $vars['image_url'] =  $params->get('image_url');
            $vars['item_name'] =  $varss['vtitle'];
            $vars['price'] =  $varss['price'];
            $vars['currency_code'] =  $varss['currency_code'];
            $vars['paypal_api_user'] = $params->get('paypal_api_user');
            $vars['paypal_api_pass'] = $params->get('paypal_api_pass');
            $vars['paypal_api_sign'] = $params->get('paypal_api_sign');
            $vars['paypal_api_id'] = $params->get('paypal_api_id');
            $vars['paypal_payment_type'] = $params->get('paypal_payment_type');
            $paypal_real_or_test = $vars['paypal_real_or_test'] =  $params->get('paypal_real_or_test');
            if(($components == 'com_os_cck' || $components == 'com_simplemembership') && $vars['paypal_payment_type'] == 1){
                JError::raiseNotice( 100, 'Simplemembership does not support commision payment. If you have some ideas please contact ordasoft support.');
                $vars['paypal_payment_type'] = 0;
            }////this block must be deleted if simplemembership will be support commision payment///
            if($components == 'com_simplemembership') {
                $orderid = $_REQUEST['userId']['OrderID'];
                $vars['item_number'] =  $orderid;
                $vars['return_url']   .=  'orderid='.$orderid;
                $vars['cancel_url']   .=  'orderid='.$orderid;
                $vars['notify_url']   .=  'orderid='.$orderid;
                $vars['expire_range'] =  $varss['expire_range'];
                $vars['expire_units'] =  $varss['expire_units'];
                
            }else if($components == 'com_os_cck') {
                $orderid = $_REQUEST['OrderID'];
                $vars['item_number'] =  $orderid;
                if($_REQUEST['userId'] == '') {
                    $userId = 0;
                } else {$userId = $_REQUEST['userId'];}
                $userID = '&userId='.$userId;
                $vars['return_url']   .=  'instId='.$varss['instId'].'&orderId='.$orderid.$userID;
                $vars['cancel_url']   .=  'instId='.$varss['instId'].'&orderId='.$orderid.$userID;
                $vars['notify_url']   .=  'instId='.$varss['instId'].'&orderId='.$orderid.$userID;
            }elseif($components == 'com_vehiclemanager') {
                if(isset($_REQUEST['id'])) {
                    $vehicleId = $_REQUEST['id'];
                    $vehicle_bayer = $_REQUEST['name_bayer'];
                    $orderId = $_REQUEST['orderID'];
                    if($_REQUEST['userId'] == '') {
                        $userId = 0;
                    } else {$userId = $_REQUEST['userId'];}
                    $vars['item_number'] = $_REQUEST['orderID'];
                }
                $currency = '';
                if($vars['currency_code']){
                    $currency = '&currency_code='.$vars['currency_code'];
                }
                $vars['return_url']   .= 'vehicle='.$vehicleId.'&userId='.$userId.'&orderId='.$orderId.$currency;
                $vars['cancel_url']   .= 'vehicle='.$vehicleId.'&userId='.$userId.'&orderId='.$orderId.$currency;
                $vars['notify_url']   .= 'vehicle='.$vehicleId.'&userId='.$userId.'&orderId='.$orderId.$currency;
                if($vars['paypal_payment_type']){//adaptive payment
                    $veh_comission_default = '';
                    $veh_comission = '';
                    $veh_comission_array = explode("|_|",$params->get('veh_comission_form'));
                    unset($veh_comission_array[count($veh_comission_array)-1]);
                    for($i=0;isset($veh_comission_array[$i]);$i+=3){
                        if($vars['price'] >= $veh_comission_array[$i] 
                            && $vars['price'] <= $veh_comission_array[$i+1]){
                            $veh_comission = $veh_comission_array[$i+2];
                            break;
                        }
                    }
                    if(empty($veh_comission)){
                        $veh_comission = $veh_comission_array[2];
                    }
                    if($params->get('veh_is_percentage')){
                        $vars['comission'] = $vars['price']*($veh_comission/100);
                    }else{
                        $vars['comission'] = $veh_comission;
                    }
                    $vars['price'] = $vars['price']-$vars['comission'];
                }
                
            }elseif($components == 'com_realestatemanager') {
                if(isset($_REQUEST['id'])) {
                    $houseId = $_REQUEST['id'];
                    $orderId = $_REQUEST['orderID'];
                    $vehicle_bayer = $_REQUEST['name_bayer'];
                    if($_REQUEST['userId'] == '') {
                        $userId = 0;
                    } else {$userId = $_REQUEST['userId'];}
                    $vars['item_number'] = $_REQUEST['orderID'];
                }
                $currency = '';
                if($vars['currency_code']){
                    $currency = '&currency_code='.$vars['currency_code'];
                }
                $vars['return_url'] .=  'houseId='.$houseId.'&userId='.$userId.'&orderId='.$orderId.$currency;
                $vars['cancel_url'] .= 'houseId='.$houseId.'&userId='.$userId.'&orderId='.$orderId.$currency;
                $vars['notify_url'] .= 'houseId='.$houseId.'&userId='.$userId.'&orderId='.$orderId.$currency;
                if($vars['paypal_payment_type']){//adaptive payment
                    $rem_comission_default = '';
                    $rem_comission = '';
                    $rem_comission_array = explode("|_|",$params->get('rem_comission_form'));
                    unset($rem_comission_array[count($rem_comission_array)-1]);
                    for($i=0;isset($rem_comission_array[$i]);$i+=3){
                        if($vars['price'] >= $rem_comission_array[$i] 
                            && $vars['price'] <= $rem_comission_array[$i+1]){
                            $rem_comission = $rem_comission_array[$i+2];
                            break;
                        }
                    }
                    if(empty($rem_comission)){
                        $rem_comission = $rem_comission_array[2];
                    }
                    if($params->get('rem_is_percentage')){
                        $vars['comission'] = $vars['price']*($rem_comission/100);
                    }else{
                        $vars['comission'] = $rem_comission;
                    }
                    $vars['price'] = $vars['price']-$vars['comission'];
                }
            }

            if($vars['paypal_payment_type']){//adaptive payment
                $payKey = plgPaymentPaypalHelper::getPayKey($vars);
                if($components == 'com_realestatemanager'){
                    $query = "UPDATE #__rem_orders SET paypal_paykay = '".$payKey."' WHERE id = $orderId";
                }
                if($components == 'com_vehiclemanager'){
                    $query = "UPDATE #__vehiclemanager_orders SET paypal_paykay = '".$payKey."' WHERE id = $orderId";
                }
                $database->setQuery($query);
                $database->query();
                if($paypal_real_or_test == 0) {
                    $vars['paypal_path'] = 'https://www.sandbox.paypal.com/cgi-bin/webscr?cmd=_ap-payment&paykey='.$payKey;
                } else {
                    $vars['paypal_path'] = 'https://www.paypal.com/cgi-bin/webscr?cmd=_ap-payment&paykey='.$payKey;
                }
                $html = $this->buildLayout($vars);
                return $html;
            }else{
                if($paypal_real_or_test == 0) {
                    $vars['paypal_path'] = 'www.sandbox.paypal.com';
                } else {
                        $vars['paypal_path'] = 'www.paypal.com';
                }
                $html = $this->buildLayout($vars);
                return $html;
            }
        }     



// 	function onTP_Processpayment($data) 
// 	{		
// 		$params 		= $this->params;
// 		$secure_post 	= $params->get('secure_post');
// 		$sandbox 		= $params->get('sandbox');
// 		$paypal_url 	= plgPaymentPaypalHelper::buildPaypalUrl($secure_post , $sandbox);
// 
// 		$verify 		= plgPaymentPaypalHelper::validateIPN($data);
// 
// 		if (!$verify) { return false; }
// 		$payment_status = $this->translateResponse( $data['payment_status'] );
// 		$result = array(
// 						'order_id'=>$data['custom'],
// 						'transaction_id'=>$data['txn_id'],
// 						'buyer_email'=>$data['payer_email'],
// 						'status'=>$payment_status,
// 						'subscribe_id'=>$data['subscr_id'],
// 						'txn_type'=>$data['txn_type'],
// 						'total_paid_amt'=>$data['mc_gross'],
// 						'raw_data'=>$data,
// 						'error'=>$error,
// 						);
// 		return $result;
// 	}

// 	function translateResponse($payment_status){
// 			if(array_key_exists($payment_status,$this->responseStatus)){
// 				return $this->responseStatus[$payment_status];
// 			}
// 	}
// 	function onTP_Storelog($data)
// 	{
// 			$log = plgPaymentPaypalHelper::Storelog($this->_name,$data);
// 
// 	}
}
