<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_weblinks
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\Weblinks\Site\Controller;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\BaseController;

/**
 * Weblinks Component Controller
 *
 * @since  1.5
 */
class DisplayController extends BaseController
{
    /**
     * Method to display a view.
     *
     * @param   boolean  $cacheable  If true, the view output will be cached
     * @param   array    $urlparams  An array of safe url parameters and their variable types,
     *                               for valid values see {@link JFilterInput::clean()}.
     *
     * @return  BaseController  This object to support chaining.
     *
     * @since   1.5
     */
    public function display($cacheable = false, $urlparams = false)
    {
        // Huh? Why not just put that in the constructor?
        $cacheable = true;
        /**
         * Set the default view name and format from the Request.
         * Note we are using w_id to avoid collisions with the router and the return page.
         * Frontend is a bit messier than the backend.
         */
        $id    = $this->input->getInt('w_id');
        $vName = $this->input->get('view', 'categories');
        $this->input->set('view', $vName);
        if ($this->app->getIdentity()->id || ($this->input->getMethod() == 'POST' && $vName == 'categories')) {
            $cacheable = false;
        }

        $safeurlparams = [
            'id'               => 'INT',
            'limit'            => 'UINT',
            'limitstart'       => 'UINT',
            'filter_order'     => 'CMD',
            'filter_order_Dir' => 'CMD',
            'lang'             => 'CMD',
        ];
        // Check for edit form.
        if ($vName == 'form' && !$this->checkEditId('com_weblinks.edit.weblink', $id)) {
            // Somehow the person just went to the form - we don't allow that.
            throw new \Exception(Text::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $id), 403);
        }

        return parent::display($cacheable, $safeurlparams);
    }
}
