<?php
/**
* @package OS Gallery
* @copyright 2020 OrdaSoft
* @author 2020 Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @license This component is released under License from included LICENSE.txt file
* @description Ordasoft Image Gallery
*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');
global $gl_state;


if(count($images)){
$galId_random = $galId."_". rand();
self::addMetaTags();

?>
    <div class="os-gallery-all-in-one-main-<?php echo $galId_random?>">

        <div id="os_progres_img-<?php echo $galId_random?>" class="img-block1"></div>   

        <div class="os-cat-tab-images" style="display:none">
            <?php
            foreach($images as $catId => $catImages){
                $currentCatParams = new JRegistry;
                $currentCatParams = $currentCatParams->loadString(rawurldecode($catParamsArray[$catId]->params));
                if($galleryLayout != 'allInOne')continue;
                if($currentCatParams->get("categoryUnpublish",false))continue;
                if($currentCatParams->get("categoryAlias",'')){
                    $catName = $currentCatParams->get("categoryAlias",'');
                }else if(isset($catImages[0])){
                    $catName = $catImages[0]->cat_name;
                }else{
                    $catName = 'no name';
                }
                $catTitlePosition = $currentCatParams->get("catTitlePosition",'onImage');
                $catDescription = $currentCatParams->get("categoryDescription",'');
                $catTitleHeight = $currentCatParams->get("catTitleHeight",'');
                $catTextStile = "style='min-height:".$catTitleHeight."px; max-height:".$catTitleHeight."px; height:".$catTitleHeight."px; overflow: hidden;'";
                
                ?>
                <li style="display:none;">
                    <a href="#cat-<?php echo $catId?>" id="cat-<?php echo $catId?><?php echo $galId_random?>" class="tab-click-loadMore" title="<?php echo $catDescription; ?>" data-cat-id="<?php echo $catId?>" data-end="<?php echo $numberImages?>"><?php echo $catName?></a>
                </li>
                <?php
                if(!isset($gl_state->data) ) return ;

                ?>

                <!-- Simple category mode-->
                <div id="cat-<?php echo $catId?>-<?php echo $galId_random?>" data-cat-id="<?php echo $catId?>" class="all-in-one-block cat-<?php echo $galId_random;?>">
                    <?php
                    if($catImages){
                        foreach($catImages as $i => $image){
                            $currentImgParams = new JRegistry;
                            $currentImgParams = $currentImgParams->loadString(rawurldecode($imgParamsArray[$image->id]->params));
                            $imgAlt = ($currentImgParams->get("imgAlt",''))? $currentImgParams->get("imgAlt",'') : $image->file_name;
                            if($currentImgParams->get("imgTitle",'')){
                            $imgTitle = $currentImgParams->get("imgTitle",'') . '</br>';}
                            else {$imgTitle = $currentImgParams->get("imgTitle",'');}
                            if ($currentImgParams->get("imgShortDescription",'')){
                            $imgShortDesc = $currentImgParams->get("imgShortDescription",'') . '</br>';}
                            else {$imgShortDesc = $currentImgParams->get("imgShortDescription",'');}
                            if ($imgVideoLink = $currentImgParams->get("videoLink", '')){
                                $imgVideoLink = $currentImgParams->get("videoLink", '');
                            } else {
                            $imgHtml = $currentImgParams->get("imgHtml", '');
                            $imgHtmlShow = $currentImgParams->get("imgHtmlShow", 'yes');
                            $htmlWidthAsImage = ($imgHtmlShow == 'yes' && $currentImgParams->get("htmlWidthAsImg", "yes") == "yes");
                            $htmlPosition = ($imgHtmlShow == 'yes') ? $currentImgParams->get("htmlPosition", "bottom") : 'bottom';
                            }
                            
                            if($params->get("watermark_enable",false)){
                                $imgLink = JURI::root().'images/com_osgallery/gal-'.$image->galId.'/original/watermark/'.$image->file_name;
                            }else{
                                $imgLink = JURI::root().'images/com_osgallery/gal-'.$image->galId.'/original/'.$image->file_name;
                            }
                            $imgOpen = '';
                            if($currentImgParams->get("imgLink",'')){
                                $imgLink = $currentImgParams->get("imgLink",'');
                                $imgLink = str_replace('http//', 'http://', $imgLink);
                                $imgLink = str_replace('https//', 'https://', $imgLink);
                                $imgOpen = $currentImgParams->get("imgLinkOpen",'_blank');
                            }
                            if($i){
                                $styleImg = 'style="margin:'.$imageMargin.'px; display:none;"';
                            }else{
                                $styleImg = 'style="margin:'.$imageMargin.'px;"';
                            }
                            ?>
                            <div class="img-block text-<?php echo $imgTextPosition; ?> <?php echo $imageHover ?>-effect <?php echo $numberImagesEffect; ?> animated" <?php echo $styleImg ?>>

                                <a 
                                    <?php 
                                    $is_tmp_chk = $currentImgParams->get('imgLink','');
                                    $imgVideoLink = trim($imgVideoLink);
                                    if(empty( $is_tmp_chk )){?>
                                        class="os_fancybox-<?php echo $catId.'" ';?>"
                                        data-index="<?php echo $image->ordering; ?>"
                                        data-os_fancybox="os_fancybox-<?php echo $catId?>"
                                    <?php }; ?>     
                                    id="os_image_id-<?php echo $image->id; ?>"
                                    rel="group"
                                    target="<?php echo $imgOpen?>"
                                    <?php if(isset($imgHtml->html) && !empty($imgHtml->html) && empty( $is_tmp_chk )) { ?>
                                       data-options='{"src": "#data-html-<?php echo $image->id; ?>", "smallBtn" : false}'
                                    <?php }elseif(!empty( $imgVideoLink )){ ?>
                                        href="<?php echo $imgVideoLink; ?>"
                                    <?php }else{ ?>
                                       href="<?php echo $imgLink; ?>"
                                    <?php }; ?>
                                    data-caption="<?php echo $showImgTitle ? $imgTitle : ''?><?php echo $showImgDescription ? $imgShortDesc : ''?>" 
                                    >

                                    <?php if(!$i){?>
                                    <!-- titles for gallery -->
                                        <?php if($catTitlePosition != 'bottom' && $catTitlePosition != 'none'){ ?>
                                            <div class="os-gallery-caption<?php echo ($catTitlePosition == 'onImage')?' ':'-';?><?php echo $catTitlePosition; ?>"
                                                 <?php echo ($catTitlePosition == 'onImage')?'':$catTextStile;?>>
                                                <?php
                                                    if($catName) {
                                                        echo "<h3 class='os-gallery-img-title'>".strip_tags($catName)."</h3>";
                                                    }
                                                    if($catDescription) {
                                                        echo "<p class='os-gallery-img-desc'>".strip_tags($catDescription)."</p>";
                                                    }
                                                ?>
                                            </div>
                                        <?php } ?>
                                    <?php }
                                    
                                    if($imgMask != 'none'){ ?>
                            
                                        <div class="bg" style="<?php echo $background_color; ?>; position: absolute; width: 100%; height: 100%;"></div>
                                        <img src="<?php echo JURI::root()?>images/com_osgallery/gal-<?php echo $image->galId?>/thumbnail/<?php echo $image->file_name?>" alt="<?php echo $imgAlt?>" style="opacity: <?php echo $background_opacity; ?>; position: absolute;">
                                    <?php } ?>

                                    <img src="<?php echo JURI::root()?>images/com_osgallery/gal-<?php echo $image->galId?>/thumbnail/<?php echo $image->file_name?>" alt="<?php echo $imgAlt?>" class="<?php echo $imgMaskClass; ?>">

                                    <span class='andrea-zoom-in'></span>
                                    <?php if(!$i){?>
                                        <?php if($catTitlePosition == 'bottom'){ ?>
                                            <div class="os-gallery-caption-<?php echo $catTitlePosition; ?>"
                                                 <?php echo ($catTitlePosition == 'onImage')?'':$catTextStile;?>>
                                                <?php
                                                    if($catName) {
                                                        echo "<h3 class='os-gallery-img-title'>".strip_tags($catName)."</h3>";
                                                    }
                                                    if($catDescription) {
                                                        echo "<p class='os-gallery-img-desc'>".strip_tags($catDescription)."</p>";
                                                    }
                                                    
                                                ?>
                                            </div>
                                        <?php } ?>
                                    <?php }?>
                                </a>

                                <?php if(isset($imgHtml->html) && !empty($imgHtml->html)) { ?>
                                    <?php 
                                        // class for block width as image
                                        $htmlWidthAsImageClass = ($htmlWidthAsImage) ? 'htmlWidthAsImage' : ''; 
                                        // class for position html
                                        $htmlPositionClass = ($htmlPosition) ? 'position_'.$htmlPosition : '';
                                    ?>   

                                    <div style="display: none;" class="data-html-wrap <?php echo $htmlWidthAsImageClass; ?> <?php echo $htmlPositionClass; ?>" id="data-html-<?php echo $image->id; ?>">
                                        <?php if($imgHtmlShow == 'yes'):?>
                                            <div class="imgInHtml">    
                                                <img src="<?php echo $imgLink; ?>">
                                            </div>
                                        <?php endif; ?>
                                        <div class="contentInHtml">
                                           <?php echo $imgHtml->html ; ?>
                                        </div>
                                    </div>
                                <?php } ?>


                            </div>
                        <?php
                        }
                    }?>
                </div>
                <!-- END simple mod-->
            <?php
            } ?>
        </div>
        <div class="osGallery-button-box" id="button-<?php echo $galId_random?>">
            <div id="os_lm_progres_img-<?php echo $galId_random; ?>" class="img-block1-load-more"></div>
            <button id="load-more-<?php echo $galId_random; ?>"  class="load-more-button" style="display:none; background:<?php echo $load_more_background; ?>"> 
                    <?php echo $loadMoreButtonText; ?>                
            </button>
        </div>

        <script>
            jQuerOs(window).on('load',function($) {
                from_history = false;
                jQuerOs('#os_progres_img-<?php echo $galId_random?>' ).attr('class', "");
                
                var gallery = new osGallery(".os-gallery-all-in-one-main-<?php echo $galId_random?>",{
                    minImgEnable : <?php echo $minImgEnable?>,
                    spaceBetween: <?php echo $imageMargin?>,
                    minImgSize: <?php echo $minImgSize?>,
                    numColumns: <?php echo $numColumns?>,
                    showImgTitle: '<?php echo $params->get('showImgTitle'); ?>',
                    showImgDescription: '<?php echo $params->get('showImgTitle'); ?>',
                    limEnd: '<?php echo $numberImages?>',
                    galId: '<?php echo $galId; ?>',
                    galIdRandom: '<?php echo $galId_random; ?>',
                    imgCountCat: '',
                    load_more_background: '<?php echo $load_more_background; ?>',
                    os_fancybox_background: '<?php echo $os_fancybox_background; ?>',
                    showLoadMore: '<?php echo $showLoadMore; ?>',
                    juri: '<?php echo JURI::root(); ?>',
                    itemId: '<?php echo $itemId ?>',
                    layout: 'allInOne',
                    fancSettings:{
                        wrapCSS: 'os-os_fancybox-window',
                        animationEffect : "<?php echo $open_close_effect?>",
                        animationDuration : "<?php echo $open_close_speed?>",
                        transitionEffect : "<?php echo $prev_next_effect?>",
                        transitionDuration : "<?php echo $prev_next_speed?>",
                        loop: <?php echo $loop?>,
                        arrows: <?php echo $os_fancybox_arrows?>,
                        clickContent: "<?php echo $next_click?>",
                        wheel: <?php echo $mouse_wheel?>,
                        slideShow : {
                            autoStart : <?php echo $os_fancybox_autoplay?>,
                            speed     : <?php echo $autoplay_speed?>
                        },
                        clickSlide : <?php echo $click_close?>,
                        thumbs : {
                            autoStart : <?php echo $thumbnail_autostart?>,
                            axis : '<?php echo $os_fancybox_thumbnail_axis?>'
                        },
                        buttons : {
                            'slideShow': '<?php echo $start_slideshow_button?>',
                            'fullScreen': '<?php echo $full_screen_button?>',
                            'thumbs': '<?php echo $thumbnails_button?>',
                            'share': '<?php echo $share_button?>',
                            'download': '<?php echo $download_button?>',
                            'zoom': '<?php echo $zoom_button?>', 
                            'arrowLeft': '<?php echo $left_arrow?>', 
                            'arrowRight': '<?php echo $right_arrow?>', 
                            'close': '<?php echo $close_button?>'
                        },
                        share : {
                            tpl : '<?php echo $share_tpl?>'
                        },
                        infobar : <?php echo $infobar?>,
                        baseClass : '<?php echo $os_fancybox_thumbnail_position?>'
                    }
                });

                // add social sharing script
                var href = window.location.href;
                var img_el_id = '';
                var pos1 = href.indexOf('os_image_id'); 
                var pos2 = href.lastIndexOf('#'); 
                var os_show_load_more = "<?php echo $showLoadMore; ?>";
                if (pos1 > -1 && pos2 > - 1) {
                    img_el_id = href.substring(pos1, pos2); 
                }else if(pos1 > -1 && pos2 == -1){
                    img_el_id = href.substring(pos1);
                }
                                        
                if(img_el_id && img_el_id.indexOf('os_image_id') > -1)  {
                     if(document.getElementById(img_el_id) !== null){
                         jQuerOs('#' + img_el_id).trigger('click');
                     }
                }
                
                window.onpopstate = function(event) {
                  //alert("location: " + document.location + ", state: " + JSON.stringify(event.state));
                  from_history = true;
                  
                  var href = window.location.href;
                  
                    var img_el_id = '';
                    var pos1 = href.indexOf('os_image_id'); 
                    var pos2 = href.lastIndexOf('-'); 
                    os_fancy_box_getInst = jQuerOs.os_fancybox.getInstance(); 
                    if (!os_fancy_box_getInst && (pos1 > -1)){
                        if (pos1 > -1 && href.indexOf('#os_fancybox') > - 1) {
                            pos2 = href.lastIndexOf('#os_fancybox')
                            img_el_id = href.substring(pos1, pos2); 
                        }else if(pos1 > -1 && href.indexOf('#os_fancybox') == -1){
                            img_el_id = href.substring(pos1);
                        }
                        
                        jQuerOs('#' + img_el_id).trigger('click');
                    }
                    else if (pos1 > -1) {
                        img_el_id = href.substring(pos1);
                        var ordering_id = jQuerOs('#' + img_el_id).attr('data-index');
                        
                        os_fancy_box_getInst.jumpTo(ordering_id);
                    }else if(pos1 == -1 && href.indexOf('os_fancybox') == -1 && os_fancy_box_getInst){
                        os_fancy_box_getInst.close();
                    }
                    var cat_id = '';
                    if(href.indexOf('cat-') > -1 && href.indexOf('os_image_id') == -1){
                        cat_id = href.substring(href.indexOf('cat-'));
                        jQuerOs('#' + cat_id + '<?php echo $galId_random?>').trigger('click');
                    }
                     from_history = false;
                };
                // end sharing script
                
                jQuerOs('.img-block').on('click', function(){
                    jQuerOs(this).parent().addClass('active');
                })
            });
        </script>
    </div>
<?php
}