<?php
/**
* @package OS Gallery
* @copyright 2020 OrdaSoft
* @author 2020 Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @license This component is released under License from included LICENSE.txt file
* @description Ordasoft Image Gallery
*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');
if(count($images)){  
    foreach($images as $catId => $catImages){
        $currentCatParams = new JRegistry;
        $currentCatParams = $currentCatParams->loadString(rawurldecode($catParamsArray[$catId]->params));
        if($currentCatParams->get("categoryUnpublish",false))continue;
        if($currentCatParams->get("categoryAlias",'')){
            $catName = $currentCatParams->get("categoryAlias",'');
        }else if(isset($catImages[0])){
            $catName = $catImages[0]->cat_name;
        }else{
            $catName = 'no name';
        }

        $styleImg = 'style="margin:'.$imageMargin.'px;"';
        $styleCat = 'style="padding:'.$imageMargin.'px;display:none!important;"';

        if($catImages){
            foreach($catImages as $image){
                $currentImgParams = new JRegistry;
                $currentImgParams = $currentImgParams->loadString(rawurldecode($imgParamsArray[$image->id]->params));
                $imgAlt = ($currentImgParams->get("imgAlt",''))? $currentImgParams->get("imgAlt",'') : $image->file_name;
                if($currentImgParams->get("imgTitle",'')){
                $imgTitle = $currentImgParams->get("imgTitle",'') . '</br>';}
                else {$imgTitle = $currentImgParams->get("imgTitle",'');}
                if ($currentImgParams->get("imgShortDescription",'')){
                $imgShortDesc = $currentImgParams->get("imgShortDescription",'') . '</br>';}
                else {$imgShortDesc = $currentImgParams->get("imgShortDescription",'');}
                if ($imgVideoLink = $currentImgParams->get("videoLink", '')){
                    $imgVideoLink = $currentImgParams->get("videoLink", '');
                } else {
                    $imgHtml = $currentImgParams->get("imgHtml", '');
                    $imgHtmlShow = $currentImgParams->get("imgHtmlShow", 'yes');
                    $htmlWidthAsImage = ($imgHtmlShow == 'yes' && $currentImgParams->get("htmlWidthAsImg", "yes") == "yes");
                    $htmlPosition = ($imgHtmlShow == 'yes') ? $currentImgParams->get("htmlPosition", "bottom") : 'bottom';
                }

                if($params->get("watermark_enable",false)){
                    $imgLink = JURI::root().'images/com_osgallery/gal-'.$image->galId.'/original/watermark/'.$image->file_name;
                }else{
                    $imgLink = JURI::root().'images/com_osgallery/gal-'.$image->galId.'/original/'.$image->file_name;
                }
                $imgOpen = '';
                if($currentImgParams->get("imgLink",'')){
                    $imgLink = $currentImgParams->get("imgLink");
                    $imgOpen = $currentImgParams->get("imgLinkOpen",'_blank');
                }

                ?>
                <div class="grid-item img-block text-<?php echo $imgTextPosition; ?> load-more-hidden <?php echo $imageHover ?>-effect <?php echo $numberImagesAtOnceEffect; ?> animated" <?php echo $styleImg ?>>

                    <a 
                        <?php 
                        $is_tmp_chk = $currentImgParams->get('imgLink','');
                        $imgVideoLink = trim($imgVideoLink);

                        if(empty($is_tmp_chk)){?>
                        class="os_fancybox-<?php echo $catId?>"
                        data-index="<?php echo $image->ordering; ?>"
                        data-os_fancybox="os_fancybox-<?php echo $catId?>"
                        <?php } ?>
                        id="os_image_id-<?php echo $image->id ?>"
                        rel="group"
                        target="<?php echo $imgOpen?>"
                        <?php if(isset($imgHtml->html) && !empty($imgHtml->html) && empty($is_tmp_chk)) { ?>
                           data-options='{"src": "#data-html-<?php echo $image->id; ?>", "smallBtn" : false}'
                        <?php }elseif(!empty($imgVideoLink)){ ?>
                            href="<?php echo $imgVideoLink?>"
                        <?php }else{ ?>
                           href="<?php echo $imgLink?>"
                        <?php } ?>
                        data-caption="<?php echo $showImgTitle ? $imgTitle : ''?><?php echo $showImgDescription ? $imgShortDesc : ''?>"
                    >
                        <?php if($imgTextPosition != 'bottom' && $imgTextPosition != 'none'){ ?>
                            <div class="os-gallery-caption<?php echo ($imgTextPosition == 'onImage')?' ':'-';?><?php echo $imgTextPosition; ?>">
                                <?php
                                    if($imgTitle) {
                                        echo "<h3 class='os-gallery-img-title'>".strip_tags(substr($imgTitle, 0, $imgMaxlengthTitle))."</h3>";
                                    }
                                    if($imgShortDesc) {
                                        echo "<p class='os-gallery-img-desc'>".strip_tags(substr($imgShortDesc, 0, $imgMaxlengthDesc))."</p>";
                                    }
                                ?>
                            </div>
                        <?php } 
                        if($imgMask != 'none'){ ?>
                                <div class="bg" style="<?php echo $background_color; ?>; position: absolute; width: 100%; height: 100%;"></div>
                                <img src="<?php echo JURI::root()?>images/com_osgallery/gal-<?php echo $image->galId?>/thumbnail_masonry/<?php echo $masonryLayout ?>/<?php echo $image->file_name?>" alt="<?php echo $imgAlt?>" style="opacity: <?php echo $background_opacity; ?>; position: absolute;">
                                
                            <?php } ?>
                                <img src="<?php echo JURI::root()?>images/com_osgallery/gal-<?php echo $image->galId?>/thumbnail_masonry/<?php echo $masonryLayout ?>/<?php echo $image->file_name?>" alt="<?php echo $imgAlt?>" class="<?php echo $imgMaskClass; ?>">

                        <!--<img src="<?php echo JURI::root()?>images/com_osgallery/gal-<?php echo $image->galId?>/thumbnail_masonry/<?php echo $masonryLayout ?>/<?php echo $image->file_name?>">-->

                        <!--<span class='andrea-zoom-in'></span>-->
                        
                        <?php if($imgTextPosition == 'bottom'){ ?>
                            <div class="os-gallery-caption-<?php echo $imgTextPosition; ?>">
                                <?php
                                    if($imgTitle) {
                                        echo "<h3 class='os-gallery-img-title'>".strip_tags(substr($imgTitle, 0, $imgMaxlengthTitle))."</h3>";
                                    }
                                    if($imgShortDesc) {
                                        echo "<p class='os-gallery-img-desc'>".strip_tags(substr($imgShortDesc, 0, $imgMaxlengthDesc))."</p>";
                                    }
                                ?>
                            </div>
                        <?php } ?>
                    </a>

                    <?php if(isset($imgHtml->html) && !empty($imgHtml->html)) { ?>

                        <?php 
                            // class for block width as image
                            $htmlWidthAsImageClass = ($htmlWidthAsImage) ? 'htmlWidthAsImage' : ''; 
                            // class for position html
                            $htmlPositionClass = ($htmlPosition) ? 'position_'.$htmlPosition : '';
                        ?>   

                        <div style="display: none;" class="data-html-wrap <?php echo $htmlWidthAsImageClass; ?> <?php echo $htmlPositionClass; ?>" id="data-html-<?php echo $image->id; ?>">
                            <?php if($imgHtmlShow == 'yes'):?>
                                <div class="imgInHtml">    
                                    <img src="<?php echo $imgLink; ?>">
                                </div>
                            <?php endif; ?>
                            <div class="contentInHtml">
                               <?php echo $imgHtml->html ; ?>
                            </div>
                        </div>
                    <?php } ?>

                </div>
                <?php
            }
        } 
    } 
}