<?php
defined( '_JEXEC' ) or die( 'Restricted access' );
/**
 * @version 6.6
 * @package OS CCK select currency
 * @copyright 2025 OrdaSoft.
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @description Select currency for OS CCK Component
*/
if(!defined('DS')){
    define('DS', DIRECTORY_SEPARATOR  );
}

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Helper\ModuleHelper;

require_once ( JPATH_BASE .DS.'components'.DS.'com_os_cck'.DS.'os_cck.php' );
require_once ( JPATH_BASE .DS.'components'.DS.'com_os_cck'.DS.'functions.php' );


class os_cck_select_currency {

     
    
    public static function getList(&$params)
    {

            require_once ( JPATH_BASE .DS.'components'.DS.'com_os_cck'.DS.'os_cck.php' );
            require_once ( JPATH_BASE .DS.'components'.DS.'com_os_cck'.DS.'functions.php' );
            $os_cck_configuration = ComponentHelper::getParams('com_os_cck');
            $paypal_currency = cck_getCurrency($os_cck_configuration);
            $currencyOpt = array();

            foreach ($paypal_currency as $carrencyArr) {
              $currencyOpt[] = \JHTML::_('select.option', trim($carrencyArr['sign']), $carrencyArr['signAlias'], "value", "text");
            }
            //$currency = (isset($entityInstance->instance_currency) && !empty($entityInstance->instance_currency))?$entityInstance->instance_currency : '';
            $session = \JFactory::getSession();

            $currency = cck_getCurrentCurrency();
            if($currency == ''){
                $session->set('currency', $paypal_currency[0]['sign']);
            }

            $currencySelect = \JHTML::_('select.genericlist', $currencyOpt, "instance_currency", 'class="cck-currency" style="width: auto !important;" onchange="javascript:change_currency();"', 'value', 'text', $currency);

            return $currencySelect;
    }
}






$cache = $params->get('owncache', '0') ;


if($cache > -1){
    // Run with caching. cache save to administrator/cache/mod_os_cck_select_currency
//     $cache = JFactory::getCache('mod_os_cck_select_currency');

     //cache depend from currency - from url.
     $cur = cck_getCurrentCurrency();  
     $layout = $params->get('layout', 'default') ;
     $cacheid = md5($module->id . $cur);
     $params_arr = new stdClass;
     $params_arr->layout = $layout;
     $params_arr->cur = $cur ;

     
     $cacheparams               = new \stdClass;
    $cacheparams->cachemode    = 'id';
    $cacheparams->class        = 'os_cck_select_currency';
    $cacheparams->method       = 'getList';
    $cacheparams->methodparams = $params_arr;
    $cacheparams->modeparams   = $cacheid;
    
    $currencySelect       = ModuleHelper::moduleCache($module, $params, $cacheparams);
    require ModuleHelper::getLayoutPath('mod_os_cck_select_currency', $params->get('layout', 'default'));
}else{

    $currency = cck_getCurrentCurrency() ;

    require ModuleHelper::getLayoutPath('mod_os_cck_select_currency', $params->get('layout', 'default'));
}



//    
