<?php

/**
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @package Xmap RealEstateManager
* @copyright (C) 2012 OrdaSoft - Andrey Kvasnevskiy
* @license GNU/GPL
* @description RealEstateManager XMap plugin for RealEstateManager Component
*/

defined('_JEXEC') or die ('Direct Access to this location is not allowed.');

$f_path = JPATH_SITE.'/components/com_realestatemanager/functions.php';
if (!file_exists($f_path)){
    echo "You need to install RealEstateManager first<br />"; exit;
} 
else require_once($f_path);

class xmap_com_realestatemanager {
    var $orderby = 'title';

     
    function isOfType(&$xmap, &$menu){
        if (strpos($menu->link, 'option=com_realestatemanager')){
            $menu->name="RealEstateManager";
            $menu->option="com_realestatemanager"; 
            return true;
        }
        return false;
    }


    static function &getTree($xmap, &$menu, $params){

        global $mosConfig_absolute_path;
        $list = array();
        $menu->name="RealEstateManager";
        $menu->option="com_realestatemanager";
        $menu->uid="com_realestatemanager";

        $link_query = parse_url($menu->link);
        parse_str(html_entity_decode($link_query['query']), $link_vars);
        if (version_compare(JVERSION, "1.6.0", "lt")){
            $view = JArrayHelper::getValue($link_vars,'task','all_categories');
        } else{
            $view = JArrayHelper::getValue($link_vars,'view','all_categories');
        }


        switch ($view){
            case 'all_categories':
                
                $catid = JArrayHelper::getValue($link_vars,'catid',0);
                xmap_com_realestatemanager::getCategoryTree($xmap, $menu, $params, $catid );
                break;

            case 'alone_category':
                if ($params['show_RealEstate'] == 'true')
                if (version_compare(JVERSION, "1.6.0", "lt")){
                    if (strpos($menu->params, 'catid=')!==false){
                        $catid = substr($menu->params, strpos($menu->params,'=',0)+1,
                                strpos($menu->params,'back',0)-strpos($menu->params,'=',0)-2);
                        }
                    
                } else{
                    $catid = ($menu->params->get('single_category'));
                    }
                xmap_com_realestatemanager::singleCategoryHandler($xmap, $menu, $catid, $params);
                break;

            case 'all_houses':
                if ($params['show_RealEstate'] == 'true')
                xmap_com_realestatemanager::getAllHouses($xmap, $menu, $params );
                break;


            case 'my_houses':
            case 'show_my_houses':
                if ($params['show_RealEstate'] == 'true')
                xmap_com_realestatemanager::myHousesHandler($xmap, $menu, $params);
                break;

            case 'owner_houses':
            case 'view_user_houses':
                if ($params['show_RealEstate'] == 'true')
                if (version_compare(JVERSION, "1.6.0", "lt")){
                    if (strpos($menu->params, 'username=')!==false){
                        $username = substr($menu->params, strpos($menu->params,'=',0)+1,
                                strpos($menu->params,'back',0)-strpos($menu->params,'=',0)-2);
                    }
                } else{
                    $username = ($menu->params->get('username'));
                }
                xmap_com_realestatemanager::singleUserHousesHandler($xmap, $menu, $username);
                break;

            case 'owners_list':
                xmap_com_realestatemanager::ownersListHandler($xmap, $menu, $params);
                break;
            
            default:
                break;
        }
        return $list;
    }


    static function getRealEstateManager(&$xmap, &$menu, $subcatid, $params){

        $Itemid = $menu->id;
        if($params['orderby'] != 'title')
        {
          $orderby =$params['orderby'];
        }
        else
        {
          $orderby='htitle';
        }
        
        $xmap->changeLevel(1);

        $database = JFactory::getDBO();
        $s = getWhereUsergroupsCondition("c");

        $q = "SELECT h.id, h.htitle, hc.idcat
           \n FROM #__rem_houses AS h
           \n LEFT JOIN #__rem_categories AS hc ON hc.iditem=h.id
           \n LEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat
           \n WHERE (".$s.") AND h.published = '1' AND h.approved = '1' AND c.id='".$subcatid . "'ORDER BY " . $orderby ."";
        $database->setQuery($q);
        $houses = $database->loadObjectList();

        foreach($houses as $house){
            $node = new stdclass;
            $node->id = $house->id;
            $node->uid = $house->id;
            $node->name = $house->htitle;
            $node->parent=1;
            $node->browsNav=1;//open new window
            $node->ordering=2;
            $node->priority=$menu->priority;
            $node->chansefreq=$menu->changefreq;
            $node->changefreq=$menu->changefreq;
            $node->modified= date("Y-m-d h:i:s");
            $node->type='component';
            $node->menutype='mainmenu';
            $node->link ='index.php?option=com_realestatemanager&amp;task=view&amp;catid='
                    .$house->idcat.'&amp;id='.$house->id.'&amp;Itemid='.$Itemid;
            $xmap->printNode($node);
        }
        $xmap->changeLevel(-1);
    }


    static function getCategoryTree(&$xmap, &$menu, $params){
//         xmap_com_realestatemanager::header();

        global $my,$mosConfig_absolute_path;

        $database = JFactory::getDBO();
        $s = getWhereUsergroupsCondition("c");
        $q = "SELECT c.id, c.title, c.name as category, c.parent_id 
           \n FROM #__rem_main_categories AS c
           \n WHERE (".$s.") AND c.published = '1' AND c.section='com_realestatemanager'
           \n ORDER BY parent_id, ordering";
        $database->setQuery($q);
        $cats = $database->loadObjectList();
        
        
        xmap_com_realestatemanager::getSubCategory( $xmap, $menu, $cats, $params);
        
    }


    static function getSubCategory( &$xmap, &$menu, $cats, $params, $parentid = 0){
        $link_query = parse_url($menu->link);
        parse_str( html_entity_decode($link_query['query']), $link_vars);
        $Itemid = $menu->id;

        $xmap->changeLevel(1);
        foreach($cats as $subcat){
            if($subcat->parent_id == $parentid){
                $node = new stdclass;
                $node->id = $menu->id;
                $node->uid=$menu->uid.'a'.$subcat->id;
                $node->name = $subcat->title;
                $node->parent=1;
                $node->browsNav=1;
                $node->ordering=2;
                $node->priority=$menu->priority;
                $node->chansefreq=$menu->changefreq;
                $node->changefreq=$menu->changefreq;
                $node->modified= date("Y-m-d h:i:s");
                $node->type='component';
                $node->link = 'index.php?option=com_realestatemanager&amp;task=showCategory&amp;'
                        . 'catid='.$subcat->id.'&amp;Itemid='.$Itemid;
                $xmap->printNode($node);
                xmap_com_realestatemanager::getSubCategory($xmap, $menu, $cats, $params, $subcat->id);
                if ($params['show_RealEstate'] == 'true'){
                xmap_com_realestatemanager::getRealEstateManager($xmap, $menu, $subcat->id, $params);
                }
            }
        }
        $xmap->changeLevel(-1);
    }


    static function singleCategoryHandler(&$xmap, &$menu, &$catid, $params){
        // The [Single Category] menu type handler
//         xmap_com_realestatemanager::header();
        $Itemid = $menu->id;
        if($params['orderby'] != 'title')
        {
          $orderby =$params['orderby'];
        }
        else
        {
          $orderby='htitle';
        }
        $database = JFactory::getDBO();
        $s = getWhereUsergroupsCondition("c");
        $query = "SELECT h.*,hc.idcat AS catid, c.title as category_titel
               \n FROM #__rem_houses AS h
               \n LEFT JOIN #__rem_categories AS hc ON hc.iditem=h.id
               \n LEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat
               \n WHERE hc.idcat = '".$catid."' AND h.published='1' AND h.approved='1'
               \n AND c.published='1' AND (".$s.")
               \n GROUP BY h.id ORDER BY " . $orderby . "";
        $database->setQuery($query);
        $items = $database->loadObjectList();
        
        //var_dump($items);

        $xmap->changeLevel(1);
        
        foreach ($items as $house)
            xmap_com_realestatemanager::printNode($xmap, $menu, $Itemid, $house->id,
                    $house->htitle, $catid, $house->id, true);


    }

    static function getAllHouses(&$xmap, &$menu, $params){
        // The [Single Category] menu type handler
//         xmap_com_realestatemanager::header();
        $Itemid = $menu->id;
        if($params['orderby'] != 'title')
        {
          $orderby =$params['orderby'];
        }
        else
        {
          $orderby='htitle';
        }
        $database = JFactory::getDBO();
        $s = getWhereUsergroupsCondition("c");
        $query = "SELECT h.*,hc.idcat AS catid, c.title as category_titel
               \n FROM #__rem_houses AS h
               \n LEFT JOIN #__rem_categories AS hc ON hc.iditem=h.id
               \n LEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat
               \n WHERE  h.published='1' AND h.approved='1'
               \n AND c.published='1' AND (".$s.")
               \n GROUP BY h.id ORDER BY " . $orderby . "";
        $database->setQuery($query);
        $items = $database->loadObjectList();

        $xmap->changeLevel(1);
        
        foreach ($items as $house)
            xmap_com_realestatemanager::printNode($xmap, $menu, $Itemid, $house->id,
                    $house->htitle, $house->catid, $house->id, true);

        $xmap->changeLevel(-1);
    }    

   static function myHousesHandler(&$xmap, &$menu, $params){
        // The [my houses] menu type handler
//         xmap_com_realestatemanager::header();
        $Itemid = $menu->id;
        $items = array();
        if($params['orderby'] != 'title')
        {
          $orderby = $params['orderby'];
        }
        else
        {
          $orderby='htitle';
        }
        
        $my = JFActory::getUser();
        if (!isset($my->name)) return;

        $database = JFActory::getDBO();
        $s = getWhereUsergroupsCondition("c");
        $q = "SELECT h.htitle as title, h.id as id, c.id AS catid 
              FROM `#__rem_houses` AS h
              LEFT JOIN `#__users` AS u ON u.id=h.owner_id
              LEFT JOIN `#__rem_categories` AS hc ON hc.iditem=h.id
              LEFT JOIN `#__rem_main_categories` AS c ON hc.idcat=c.id
              WHERE h.published = 1 AND h.approved = 1 AND h.owner_id = '".$my->id."'
              GROUP BY id ORDER BY " . $orderby . "";
        $database->setQuery($q);
        $items = $database->loadObjectList();
        //var_dump($items);

        $xmap->changeLevel(1);

        if (isset($items[0])) foreach ($items as $house)
            xmap_com_realestatemanager::printNode($xmap, $menu, $Itemid, $house->id,
                    $house->title, $house->catid, $house->id, true);
        $xmap->changeLevel(-1);
    }

    static function singleHousesHandler(&$xmap, &$menu, &$id){
        // The [Single User Houses] menu type handler
//         xmap_com_realestatemanager::header();
        $Itemid = $menu->id;
        $database = JFactory::getDBO();
        $q = "SELECT h.*, c.id AS catid 
              FROM `#__rem_houses` AS h
              LEFT JOIN #__rem_categories AS hc ON hc.iditem=h.id 
              LEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat 
              LEFT JOIN `#__users` AS u ON u.id=h.owner_id
              WHERE h.approved = 1 AND c.published = 1 AND h.published = 1 AND
              h.id='".$id."'
              GROUP BY h.htitle";
        $database->setQuery($q);
        $items = $database->loadObjectList();
        $xmap->changeLevel(1);
        foreach ($items as $house)
            xmap_com_realestatemanager::printNode($xmap, $menu, $Itemid, $house->id,
                    $house->htitle, $house->catid, $house->id, true);
        $xmap->changeLevel(-1);
    }
    
    static function singleUserHousesHandler(&$xmap, &$menu, &$id){
        // The [Single User Houses] menu type handler
//         xmap_com_realestatemanager::header();
        $Itemid = $menu->id;
        $database = JFactory::getDBO();
        $q = "SELECT h.*, c.id AS catid 
              FROM `#__rem_houses` AS h
              LEFT JOIN #__rem_categories AS hc ON hc.iditem=h.id 
              LEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat 
              LEFT JOIN `#__users` AS u ON u.id=h.owner_id
              WHERE h.approved = 1 AND c.published = 1 AND h.published = 1 AND
              u.id='".$id."'
              GROUP BY h.htitle";
        $database->setQuery($q);
        $items = $database->loadObjectList();
        $xmap->changeLevel(1);
        foreach ($items as $house)
            xmap_com_realestatemanager::printNode($xmap, $menu, $Itemid, $house->id,
                    $house->htitle, $house->catid, $house->id, true);
        $xmap->changeLevel(-1);
    }


    static function ownersListHandler (&$xmap, &$menu, $params){
        // The [owners list] menu type handler
//         xmap_com_realestatemanager::header();
        $Itemid = $menu->id;
        if($params['orderby'] != 'title')
        {
          $orderby =$params['orderby'];
        }
        else
        {
          $orderby='htitle';
        }
        $database = JFactory::getDBO();
        $s = getWhereUsergroupsCondition("c");
        $items = "SELECT u.name, u.email, u.id, COUNT(h.owner_id)
               \n FROM #__rem_houses AS h
               \n LEFT JOIN #__rem_categories AS hc ON hc.iditem=h.id
               \n LEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat
               \n LEFT JOIN #__users AS u ON h.owner_id=u.id
               \n WHERE h.published=1 AND h.approved=1 AND h.owneremail!='' AND (".$s.")
               \n GROUP BY u.name
               \n ORDER BY u.name";
        $database->setQuery($items);
        $owners = $database->loadObjectList();
        $xmap->changeLevel(1);
        
        foreach($owners as $owner){

            if($owner->name == '') $owner->name = "anonymous" ;
            xmap_com_realestatemanager::printNode($xmap, $menu, $Itemid, $owner->id,
                    $owner->name, 0, 0, false, $owner->name);
            if ($params['show_RealEstate'] == 'true'){
            $q = "SELECT h.*, c.id AS catid FROM `#__rem_houses` AS h
                  LEFT JOIN #__rem_categories AS hc ON hc.iditem=h.id
                  LEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat
                  WHERE h.approved = 1 AND h.published = 1 AND (".$s.") AND h.owner_id='".$owner->id."'
                  GROUP BY h.id ORDER BY " . $orderby . "";
            $database->setQuery($q);
            $houses = $database->loadObjectList();

            $xmap->changeLevel(1);

            foreach ($houses as $house)
                xmap_com_realestatemanager::printNode($xmap, $menu, $Itemid, $house->id,
                        $house->htitle, $house->catid, $house->id, true);
            $xmap->changeLevel(-1);
            }
        }
        $xmap->changeLevel(-1);
    }




  static function printNode(&$xmap, &$menu, $Itemid, $node_uid, $node_name, $catid = 0,
          $houseid = 0, $is_house = false, $name = false){
        $node = new stdclass;
        $node->id = $Itemid; 
        $node->uid = $node_uid; 
        $node->name = $node_name;
        $node->parent = 1; 
        $node->browsNav = 1; 
        $node->ordering = 2; 
        $node->priority=$menu->priority;
        $node->chansefreq=$menu->changefreq;
        $node->changefreq=$menu->changefreq;
        $node->modified= date("Y-m-d h:i:s");
        $node->type = 'component'; 
        $node->menutype = 'mainmenu'; 
        if ($is_house) $node->link = 'index.php?option=com_realestatemanager&amp;task=view&amp;id='
                .$houseid.'&amp;catid='.$catid.'&amp;Itemid='.$Itemid;
            elseif ($catid > 0) $node->link = 'index.php?option=com_realestatemanager&amp;'
                    . 'task=showcategory&amp;catid='.$catid.'&amp;Itemid='.$Itemid;
                elseif (isset($name) AND $name != '') $node->link = 'index.php?option='
                        . 'com_realestatemanager&amp;task=view_user_houses&amp;name='
                        .$name.'&amp;Itemid='.$Itemid;
        $xmap->printNode($node);
    }
}
