<?php
defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

$fName = $field->db_field_name;

$fld_published = (isset($fields_from_params[$fName.'_published']) && $fields_from_params[$fName.'_published'] == 1) ? 'checked="true"' : '';
$fld_published = (!isset($fields_from_params[$fName.'_published'])) ? 'checked="true"' : $fld_published;

$label_tag_selected = (isset($fields_from_params['label_tag_'.$fName])) ? $fields_from_params['label_tag_'.$fName] : "div";
$calendar_selected = (isset($fields_from_params[$fName.'_calendars_list'])) ? $fields_from_params[$fName.'_calendars_list'] : array('google','ical','outlook','yahoo');
$event_title = (isset($fields_from_params[$fName.'_event_title'])) ? $fields_from_params[$fName.'_event_title'] : '-1';
$event_date_start = (isset($fields_from_params[$fName.'_event_date_start'])) ? $fields_from_params[$fName.'_event_date_start'] : '-1';
$event_date_end = (isset($fields_from_params[$fName.'_event_date_end'])) ? $fields_from_params[$fName.'_event_date_end'] : '-1';
$event_description = (isset($fields_from_params[$fName.'_event_description'])) ? $fields_from_params[$fName.'_event_description'] : '-1';
$event_location = (isset($fields_from_params[$fName.'_event_location'])) ? $fields_from_params[$fName.'_event_location'] : array('-1');
$event_items_location = (isset($fields_from_params[$fName.'_event_items_location'])) ? $fields_from_params[$fName.'_event_items_location'] : array('address');

$tags = array();
$tags[]  = JHTML::_('select.option','span','span');
$tags[]  = JHTML::_('select.option','div','div');
$tags[]  = JHTML::_('select.option','h1','h1');
$tags[]  = JHTML::_('select.option','h2','h2');
$tags[]  = JHTML::_('select.option','h3','h3');
$tags[]  = JHTML::_('select.option','h4','h4');
$tags[]  = JHTML::_('select.option','h5','h5');
$tags[]  = JHTML::_('select.option','label','label');

$field_php_show = (isset($fields_from_params[$fName.'_php_show'])) ? $fields_from_params[$fName.'_php_show'] : '';

$gtree = get_group_children_tree_cck($layout->type);
$access_selected = (isset($fields_from_params['access_'.$fName])) ? $fields_from_params['access_'.$fName] : '1';

$toCalendar = array();
    $toCalendar[]  = JHTML::_('select.option','google','Google Calendar');
    $toCalendar[]  = JHTML::_('select.option','ical','ICal Calendar');
    $toCalendar[]  = JHTML::_('select.option','outlook','Outlook Calendar');
    $toCalendar[]  = JHTML::_('select.option','yahoo','Yahoo Calendar');
    
$locationItemsOptions = array();

    $locationItemsOptions[] = JHTML::_('select.option','address','Address');
    $locationItemsOptions[] = JHTML::_('select.option','country','Country');
    $locationItemsOptions[] = JHTML::_('select.option','region','Region');
    $locationItemsOptions[] = JHTML::_('select.option','city','City');
    $locationItemsOptions[] = JHTML::_('select.option','zipcode','ZipCode');
    
    
$titleField = $entity->getEventTitleFieldList();
$dateField = $entity->getDatePopupFieldList();
$descriptionField = $entity->getTextAreaFieldList();
$locationField = $entity->getLocationFieldList();

//title list
$titleOptions = createSettingsOptions($titleField, true);
//date list
$dateOptions = createSettingsOptions($dateField, true);
//description list
$descriptionOptions = createSettingsOptions($descriptionField, true);
//location list
$locationOptions = createSettingsOptions($locationField, true);

?>
<div id="options-field-<?php echo $fName?>">
    <div>
        <input type="hidden" data-field-name="<?php echo $fName?>" name="fi_<?php echo $fName?>_published" 
        <?php echo $fld_published?> value="0">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SHOW_FIELD_PUBLISHED")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_<?php echo $fName?>_published" 
        <?php echo $fld_published?> value="1">
    </div>
    
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_LABEL_SHELL")?></label>
        <?php echo JHTML::_('select.genericlist',$label_tags, 'fi_label_tag_'. $fName,
                            'size="1" class="inputbox" ', 'value', 'text', $label_tag_selected);?>
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LAYOUT_CALENDAR_IMPORT_SETTING_LIST")?>
            <i title="<?php echo JText::_("COM_OS_CCK_CALENDAR_IMPORT_FIELD_TOOLTIP")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i>
        </label>
        <?php echo JHTML::_('select.genericlist', $toCalendar, 'fi_' . $fName.'_calendars_list[]', 'multiple="true"','value', 'text',$calendar_selected)?>
    </div>

    <!-- title list -->
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LAYOUT_TITLE_LIST")?>
            <i title="<?php echo JText::_("COM_OS_CCK_CALENDAR_IMPORT_TITLE_FIELD_TOOLTIP")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i>
        </label>
        <?php echo JHTML::_('select.genericlist', $titleOptions,  'fi_'. $fName .'_event_title', '','value', 'text',$event_title)?>
    </div>

    <!-- date start list -->
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LAYOUT_DATE_START_LIST")?>
            <i title="<?php echo JText::_("COM_OS_CCK_CALENDAR_IMPORT_START_DATE_FIELD_TOOLTIP")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i>
        </label>
        <?php echo JHTML::_('select.genericlist', $dateOptions,  'fi_'. $fName .'_event_date_start', '','value', 'text',$event_date_start)?>
    </div>

    <!-- date end list -->
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LAYOUT_DATE_END_LIST")?>
            <i title="<?php echo JText::_("COM_OS_CCK_CALENDAR_IMPORT_START_END_FIELD_TOOLTIP")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i>
        </label>
        <?php echo JHTML::_('select.genericlist', $dateOptions,  'fi_'. $fName .'_event_date_end', '','value', 'text',$event_date_end)?>
    </div>

    <!-- description list -->
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LAYOUT_DESCRIPTION_LIST")?>
            <i title="<?php echo JText::_("COM_OS_CCK_CALENDAR_IMPORT_DESCRIPTION_FIELD_TOOLTIP")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i>
        </label>
        <?php echo JHTML::_('select.genericlist', $descriptionOptions,  'fi_'. $fName .'_event_description', '','value', 'text',$event_description)?>
    </div>

    <!-- location list -->
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LAYOUT_LOCATION_LIST")?>
            <i title="<?php echo JText::_("COM_OS_CCK_CALENDAR_IMPORT_LOCATION_FIELD_TOOLTIP")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i>
        </label>
        <?php echo JHTML::_('select.genericlist', $locationOptions,  'fi_'. $fName .'_event_location', '','value', 'text',$event_location)?>
    </div>

    <!-- location items list -->
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LAYOUT_LOCATION_LIST_CHILD")?>
            <i title="<?php echo JText::_("COM_OS_CCK_CALENDAR_IMPORT_LOCATION_CHILD_FIELD_TOOLTIP")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i>
        </label>
        <?php echo JHTML::_('select.genericlist', $locationItemsOptions,  'fi_'. $fName .'_event_items_location[]', 'multiple="true"','value', 'text',$event_items_location)?>
    </div>
    <div class="php_show">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_PHP_SHOW")?> <i title="<?php echo JText::_("COM_OS_CCK_LABEL_PHP_SHOW_DESC")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i></label>
        <input id="add-field-mask-php-show" class="new-mask" type="button" aria-invalid="false" value="+field">
        <span class="editor-button">Editor</span>
        <textarea class="php-show-editor" rows="5" cols="30" name="fi_<?php echo $fName?>_php_show"><?php echo $field_php_show?></textarea>
    </div>
    <?php if(isset($cck_entity_configuration[$layout->fk_eid]['check_access_fields']) && $cck_entity_configuration[$layout->fk_eid]['check_access_fields'] == '1'){ 
        $attr = array (
            'list.attr' => ' multiple="true" ',
            'id' => 'fi_access_'.$fName,
            'list.select' => $access_selected,
            'group.items' => null,
            'option.key.toHtml' => false,
            'option.text.toHtml' => false
        );
        ?>
    <div>
        <label class="access-label"><?php echo JText::_("COM_OS_CCK_LABEL_FIELD_ACCESS")?></label>
        <?php //echo JHTML::_('select.genericlist', $gtree, 'fi_access_'.$fName.'[]', 'multiple="true"','value', 'text',$access_selected);
        echo JHTML::_('select.groupedlist',$gtree,'fi_access_'.$fName.'[]', $attr);?>
    </div>
    <?php } ?>
</div>
