<?php
defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2025 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/
//$fName = $field->db_field_name;
$fName = $child_entity->data_field_name;

$description_show = (isset($lParams['description_'.$fName]))? 'checked="true"' : '';
$field_prefix = (isset($lParams[$fName.'_prefix']))? $lParams[$fName.'_prefix'] : '';
$field_suffix = (isset($lParams[$fName.'_suffix']))? $lParams[$fName.'_suffix'] : '';
$fld_alias = (isset($lParams[$fName.'_alias']))? $lParams[$fName.'_alias'] : $child_entity->entity_alias;
$field_tooltip = (isset($lParams[$fName.'_tooltip']))? $lParams[$fName.'_tooltip'] : '';
$access_selected = (isset($lParams['access_'.$fName]))? $lParams['access_'.$fName] : '1';
$order_by_selected = (isset($lParams['order_by_'.$fName]))? $lParams['order_by_'.$fName] : '';

$field_php_show = (isset($lParams[$fName.'_php_show'])) ? $lParams[$fName.'_php_show'] : '';
$field_sql_show = (isset($lParams[$fName.'_sql_show'])) ? $lParams[$fName.'_sql_show'] : '';
$fld_require = (isset($lParams[$fName.'_required']))? 'checked="true"' : '';

//publish checked default
$fld_published = (isset($lParams[$fName.'_published']) 
                    && $lParams[$fName.'_published'] == 'on') ? 'checked="true"' : '';
$fld_published = (!isset($lParams[$fName.'_published'])) ? 'checked="true"' : $fld_published;
//show name checked default
$fld_name_show = (isset($lParams['showName_'.$fName]) 
                    && $lParams['showName_'.$fName] == 'on') ? 'checked="true"' : '';
$fld_name_show = (!isset($lParams['showName_'.$fName])) ? 'checked="true"' : $fld_name_show;
$fld_default_value = (isset($lParams[$fName . '_default_value'])) ? $lParams[$fName . '_default_value'] : "";

$icon_alias_prefix = (isset($lParams[$fName.'_add_icon_alias_prefix'])) ? $lParams[$fName.'_add_icon_alias_prefix'] : '';
$icon_alias_suffix = (isset($lParams[$fName.'_add_icon_alias_suffix'])) ? $lParams[$fName.'_add_icon_alias_suffix'] : '';
$icon_prefix_prefix = (isset($lParams[$fName.'_add_icon_prefix_prefix'])) ? $lParams[$fName.'_add_icon_prefix_prefix'] : '';
$icon_prefix_suffix = (isset($lParams[$fName.'_add_icon_prefix_suffix'])) ? $lParams[$fName.'_add_icon_prefix_suffix'] : '';
$icon_suffix_prefix = (isset($lParams[$fName.'_add_icon_suffix_prefix'])) ? $lParams[$fName.'_add_icon_suffix_prefix'] : '';
$icon_suffix_suffix = (isset($lParams[$fName.'_add_icon_suffix_suffix'])) ? $lParams[$fName.'_add_icon_suffix_suffix'] : '';

$autocomplite = (isset($lParams['autocomplite_'.$fName]) 
                    && $lParams['autocomplite_'.$fName] == 'on') ? 'checked="true"' : '';
$autocomplite = (!isset($lParams['autocomplite_'.$fName])) ? '' : $autocomplite; 
$field_placeholder = (isset($lParams[$fName.'_placeholder'])) ? $lParams[$fName.'_placeholder'] : '';

$rand = rand();
//var_dump($entities_type);
if(property_exists($child_entity, 'childEntityId')){
    $child_eid = $child_entity->childEntityId;
}elseif(isset($entityId)){
    $child_eid = $entityId;
}else{
    $child_eid = 0;
}

if(property_exists($child_entity, 'childEntityFields')){
    $childEntityFields = $child_entity->childEntityFields;
}else{
    $childEntityFields = $input->get('childEntityFields', '');
    if(is_array($childEntityFields)){
        foreach($childEntityFields as $key => $val){
            if($val == '') unset($childEntityFields[$key]);
        }
        $childEntityFields = implode(',', $childEntityFields);
    }
}
//var_dump($child_entity);
$sortingOptions = getSortingOptionsForChildFields($childEntityFields, $child_eid);
//var_dump($sortingOptions);

?>
<div id="options-field-<?php echo $fName?>">
    <div>
        <input type="hidden" data-field-name="<?php echo $fName?>" name="fi_<?php echo $fName?>_published"
        <?php echo $fld_published?> value="0">
        <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_SHOW_FIELD_PUBLISHED")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_<?php echo $fName?>_published" <?php echo $fld_published?>>
    </div>

    <div>
        <input type="hidden" data-field-name="<?php echo $fName?>" name="fi_showName_<?php echo $fName?>" 
        <?php echo $fld_name_show?> value="0">
        <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_SHOW_FIELD_NAME")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_showName_<?php echo $fName?>" <?php echo $fld_name_show?>>
    </div>
    <div class="label_alias_wrap">
        <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_ALIAS")?></label>
        <div class="fa <?php echo $icon_alias_prefix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_alias_prefix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo cck_lang_text("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_alias_prefix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_alias_prefix" value="<?php echo $icon_alias_prefix; ?>">
        <input type="text" size="4" style="float: right;" name="fi_<?php echo $fName?>_alias"  value="<?php echo $fld_alias?>" >
        <div class="fa <?php echo $icon_alias_suffix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_alias_suffix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo cck_lang_text("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_alias_suffix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_alias_suffix" value="<?php echo $icon_alias_suffix; ?>">
    </div>
    <div>
        <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_SHOW_DESCRIPTION")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_description_<?php echo $fName?>" <?php echo $description_show?>>
    </div>
    <div>
        <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_TOOLTIP")?></label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_tooltip"  value="<?php echo $field_tooltip?>" >
    </div>
    <div class="prefix_wrap">
        <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_PREFIX")?></label>
        <div class="fa <?php echo $icon_prefix_prefix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_prefix_prefix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo cck_lang_text("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_prefix_prefix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_prefix_prefix" value="<?php echo $icon_prefix_prefix; ?>">
        <input type="text" size="4" name="fi_<?php echo $fName?>_prefix"  value="<?php echo $field_prefix?>" >
        <div class="fa <?php echo $icon_prefix_suffix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_prefix_suffix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo cck_lang_text("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_prefix_suffix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_prefix_suffix" value="<?php echo $icon_prefix_suffix; ?>">
    </div>
    <div class="suffix_wrap">
        <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_SUFFIX")?></label>
        <div class="fa <?php echo $icon_suffix_prefix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_suffix_prefix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo cck_lang_text("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_suffix_prefix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_suffix_prefix" value="<?php echo $icon_suffix_prefix; ?>">
        <input type="text" size="4" name="fi_<?php echo $fName?>_suffix"  value="<?php echo $field_suffix?>" >
        <div class="fa <?php echo $icon_suffix_suffix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_suffix_suffix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo cck_lang_text("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_suffix_suffix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_suffix_suffix" value="<?php echo $icon_suffix_suffix; ?>">
    </div>

    
    <div>
        <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_ORDER_BY")?></label>
        <?php echo JHTML::_('select.genericlist', $sortingOptions, 'fi_order_by_'.$fName, 'size="1" class="inputbox"','value', 'text',$order_by_selected);?>
    </div>
    
    <div>
        <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_USE_AUTOCOMPLETE")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" id="fi_autocomplite_<?php echo $fName?>" name="fi_autocomplite_<?php echo $fName?>" <?php echo $autocomplite?>>
    </div>
    <div id="fi_<?php echo $fName?>_placeholder" >
        <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_SHOW_PLACEHOLDER")?></label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_placeholder"  value="<?php echo $field_placeholder?>" >
    </div>
    <div>
        <input type="button" id="change_<?php echo $fName?>" field="<?php echo $fName?>" value="Edit field">
    </div>
    <div class="php_show">
        <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_SQL_SHOW")?> <i title="<?php echo cck_lang_text("COM_OS_CCK_LABEL_SQL_SHOW_DESC")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i></label>
        <input id="add-field-mask-sql-show" class="new-mask" type="button" aria-invalid="false" value="View select">
        <span class="editor-button">Editor</span>
        <textarea class="sql-show-editor" rows="5" cols="30" name="fi_<?php echo $fName?>_sql_show"><?php echo $field_sql_show?></textarea>
    </div>
    <div class="php_show">
        <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_PHP_SHOW")?> <i title="<?php echo cck_lang_text("COM_OS_CCK_LABEL_PHP_SHOW_DESC")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i></label>
        <input id="add-field-mask-php-show" class="new-mask" type="button" aria-invalid="false" value="+field">
        <span class="editor-button">Editor</span>
        <textarea class="php-show-editor" rows="5" cols="30" name="fi_<?php echo $fName?>_php_show"><?php echo $field_php_show?></textarea>
    </div>
    <?php 
    
    
    if(isset($cck_entity_configuration[$child_eid]['check_access_fields']) && $cck_entity_configuration[$child_eid]['check_access_fields'] == '1'){ 
        $attr = array (
            'list.attr' => ' multiple="true" ',
            'id' => 'fi_access_'.$fName,
            'list.select' => $access_selected,
            'group.items' => null,
            'option.key.toHtml' => false,
            'option.text.toHtml' => false
        );
        ?>
    <div>
        <label class="access-label"><?php echo cck_lang_text("COM_OS_CCK_LABEL_FIELD_ACCESS")?></label>
        <?php //echo JHTML::_('select.genericlist', $gtree, 'fi_access_'.$fName.'[]', 'multiple="true"','value', 'text',$access_selected);
        echo JHTML::_('select.groupedlist',$gtree,'fi_access_'.$fName.'[]', $attr);?>
    </div>
    <?php } ?>
</div>
<script>
    function show_hide_placeholder_<?php echo $rand; ?>(){
        var autocomplite_use = jQuerOs('#fi_autocomplite_<?php echo $fName?>').prop("checked");
        //console.log('111111111111111', autocomplite_use)
        if(autocomplite_use){
            jQuerOs('#fi_<?php echo $fName?>_placeholder').show();
        }else{
            jQuerOs('#fi_<?php echo $fName?>_placeholder').hide();
        }
    }
    window.addEventListener('load', function() {
        
        jQuerOs('#fi_autocomplite_<?php echo $fName?>').on('change', function(){
            show_hide_placeholder_<?php echo $rand; ?>();
        });
        
        show_hide_placeholder_<?php echo $rand; ?>();
    });
    
    jQuerOs('#change_<?php echo $fName?>').on('click', function(){
        edit_child_enteties(this);
    })
</script>