/* ========================================================================
 * Bootstrap: os_ts_modal.js v3.3.5
 * http://getbootstrap.com/javascript/#modals
 * ========================================================================
 * Copyright 2011-2015 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // MODAL CLASS DEFINITION
  // ======================

  var OS_TS_Modal = function (element, options) {
    this.options             = options
    this.$body               = $(document.body)
    this.$element            = $(element)
    this.$dialog             = this.$element.find('.os_ts_modal-dialog')
    this.$backdrop           = null
    this.isShown             = null
    this.originalBodyPad     = null
    this.scrollbarWidth      = 0
    this.ignoreBackdropClick = false

    if (this.options.remote) {
      this.$element
        .find('.os_ts_modal-content')
        .load(this.options.remote, $.proxy(function () {
          this.$element.trigger('loaded.bs.os_ts_modal')
        }, this))
    }
  }

  OS_TS_Modal.VERSION  = '3.3.5'

  OS_TS_Modal.TRANSITION_DURATION = 300
  OS_TS_Modal.BACKDROP_TRANSITION_DURATION = 150

  OS_TS_Modal.DEFAULTS = {
    backdrop: true,
    keyboard: true,
    show: true
  }

  OS_TS_Modal.prototype.toggle = function (_relatedTarget) {
    return this.isShown ? this.hide() : this.show(_relatedTarget)
  }

  OS_TS_Modal.prototype.show = function (_relatedTarget) {
    var that = this
    var e    = $.Event('show.bs.os_ts_modal', { relatedTarget: _relatedTarget })

    this.$element.trigger(e)

    if (this.isShown || e.isDefaultPrevented()) return

    this.isShown = true

    this.checkScrollbar()
    this.setScrollbar()
    this.$body.addClass('os_ts_modal-open')

    this.escape()
    this.resize()

    this.$element.on('click.dismiss.bs.os_ts_modal', '[data-dismiss="os_ts_modal"]', $.proxy(this.hide, this))

    this.$dialog.on('mousedown.dismiss.bs.os_ts_modal', function () {
      that.$element.one('mouseup.dismiss.bs.os_ts_modal', function (e) {
        if ($(e.target).is(that.$element)) that.ignoreBackdropClick = true
      })
    })

    this.backdrop(function () {
      var transition = $.support.transition && that.$element.hasClass('fade')

      if (!that.$element.parent().length) {
        that.$element.appendTo(that.$body) // don't move modals dom position
      }

      that.$element
        .show()
        .scrollTop(0)

      that.adjustDialog()

      if (transition) {
        that.$element[0].offsetWidth // force reflow
      }

      that.$element.addClass('in')

      that.enforceFocus()

      var e = $.Event('shown.bs.os_ts_modal', { relatedTarget: _relatedTarget })

      transition ?
        that.$dialog // wait for os_ts_modal to slide in
          .one('bsTransitionEnd', function () {
            that.$element.trigger('focus').trigger(e)
          })
          .emulateTransitionEnd(OS_TS_Modal.TRANSITION_DURATION) :
        that.$element.trigger('focus').trigger(e)
    })
  }

  OS_TS_Modal.prototype.hide = function (e) {
    if (e) e.preventDefault()

    e = $.Event('hide.bs.os_ts_modal')

    this.$element.trigger(e)

    if (!this.isShown || e.isDefaultPrevented()) return

    this.isShown = false

    this.escape()
    this.resize()

    $(document).off('focusin.bs.os_ts_modal')

    this.$element
      .removeClass('in')
      .off('click.dismiss.bs.os_ts_modal')
      .off('mouseup.dismiss.bs.os_ts_modal')

    this.$dialog.off('mousedown.dismiss.bs.os_ts_modal')

    $.support.transition && this.$element.hasClass('fade') ?
      this.$element
        .one('bsTransitionEnd', $.proxy(this.hideModal, this))
        .emulateTransitionEnd(OS_TS_Modal.TRANSITION_DURATION) :
      this.hideModal()
  }

  OS_TS_Modal.prototype.enforceFocus = function () {
    $(document)
      .off('focusin.bs.os_ts_modal') // guard against infinite focus loop
      .on('focusin.bs.os_ts_modal', $.proxy(function (e) {
        if (this.$element[0] !== e.target && !this.$element.has(e.target).length) {
          this.$element.trigger('focus')
        }
      }, this))
  }

  OS_TS_Modal.prototype.escape = function () {
    if (this.isShown && this.options.keyboard) {
      this.$element.on('keydown.dismiss.bs.os_ts_modal', $.proxy(function (e) {
        e.which == 27 && this.hide()
      }, this))
    } else if (!this.isShown) {
      this.$element.off('keydown.dismiss.bs.os_ts_modal')
    }
  }

  OS_TS_Modal.prototype.resize = function () {
    if (this.isShown) {
      $(window).on('resize.bs.os_ts_modal', $.proxy(this.handleUpdate, this))
    } else {
      $(window).off('resize.bs.os_ts_modal')
    }
  }

  OS_TS_Modal.prototype.hideModal = function () {
    var that = this
    this.$element.hide()
    this.backdrop(function () {
      that.$body.removeClass('os_ts_modal-open')
      that.resetAdjustments()
      that.resetScrollbar()
      that.$element.trigger('hidden.bs.os_ts_modal')
    })
  }

  OS_TS_Modal.prototype.removeBackdrop = function () {
    this.$backdrop && this.$backdrop.remove()
    this.$backdrop = null
  }

  OS_TS_Modal.prototype.backdrop = function (callback) {
    var that = this
    var animate = this.$element.hasClass('fade') ? 'fade' : ''

    if (this.isShown && this.options.backdrop) {
      var doAnimate = $.support.transition && animate

      this.$backdrop = $(document.createElement('div'))
        .addClass('os_ts_modal-backdrop ' + animate)
        .appendTo(this.$element.parent())

      this.$element.on('click.dismiss.bs.os_ts_modal', $.proxy(function (e) {
        if (this.ignoreBackdropClick) {
          this.ignoreBackdropClick = false
          return
        }
        if (e.target !== e.currentTarget) return
        this.options.backdrop == 'static'
          ? this.$element[0].focus()
          : this.hide()
      }, this))

      if (doAnimate) this.$backdrop[0].offsetWidth // force reflow

      this.$backdrop.addClass('in')

      if (!callback) return

      doAnimate ?
        this.$backdrop
          .one('bsTransitionEnd', callback)
          .emulateTransitionEnd(OS_TS_Modal.BACKDROP_TRANSITION_DURATION) :
        callback()

    } else if (!this.isShown && this.$backdrop) {
      this.$backdrop.removeClass('in')

      var callbackRemove = function () {
        that.removeBackdrop()
        callback && callback()
      }
      $.support.transition && this.$element.hasClass('fade') ?
        this.$backdrop
          .one('bsTransitionEnd', callbackRemove)
          .emulateTransitionEnd(OS_TS_Modal.BACKDROP_TRANSITION_DURATION) :
        callbackRemove()

    } else if (callback) {
      callback()
    }
  }

  // these following methods are used to handle overflowing modals

  OS_TS_Modal.prototype.handleUpdate = function () {
    this.adjustDialog()
  }

  OS_TS_Modal.prototype.adjustDialog = function () {
    var modalIsOverflowing = this.$element[0].scrollHeight > document.documentElement.clientHeight

    this.$element.css({
      paddingLeft:  !this.bodyIsOverflowing && modalIsOverflowing ? this.scrollbarWidth : '',
      paddingRight: this.bodyIsOverflowing && !modalIsOverflowing ? this.scrollbarWidth : ''
    })
  }

  OS_TS_Modal.prototype.resetAdjustments = function () {
    this.$element.css({
      paddingLeft: '',
      paddingRight: ''
    })
  }

  OS_TS_Modal.prototype.checkScrollbar = function () {
    var fullWindowWidth = window.innerWidth
    if (!fullWindowWidth) { // workaround for missing window.innerWidth in IE8
      var documentElementRect = document.documentElement.getBoundingClientRect()
      fullWindowWidth = documentElementRect.right - Math.abs(documentElementRect.left)
    }
    this.bodyIsOverflowing = document.body.clientWidth < fullWindowWidth
    this.scrollbarWidth = this.measureScrollbar()
  }

  OS_TS_Modal.prototype.setScrollbar = function () {
    var bodyPad = parseInt((this.$body.css('padding-right') || 0), 10)
    this.originalBodyPad = document.body.style.paddingRight || ''
    if (this.bodyIsOverflowing) this.$body.css('padding-right', bodyPad + this.scrollbarWidth)
  }

  OS_TS_Modal.prototype.resetScrollbar = function () {
    this.$body.css('padding-right', this.originalBodyPad)
  }

  OS_TS_Modal.prototype.measureScrollbar = function () { // thx walsh
    var scrollDiv = document.createElement('div')
    scrollDiv.className = 'os_ts_modal-scrollbar-measure'
    this.$body.append(scrollDiv)
    var scrollbarWidth = scrollDiv.offsetWidth - scrollDiv.clientWidth
    this.$body[0].removeChild(scrollDiv)
    return scrollbarWidth
  }


  // MODAL PLUGIN DEFINITION
  // =======================

  function Plugin(option, _relatedTarget) {
    return this.each(function () {
      var $this   = $(this)
      var data    = $this.data('bs.os_ts_modal')
      var options = $.extend({}, OS_TS_Modal.DEFAULTS, $this.data(), typeof option == 'object' && option)

      if (!data) $this.data('bs.os_ts_modal', (data = new OS_TS_Modal(this, options)))
      if (typeof option == 'string') data[option](_relatedTarget)
      else if (options.show) data.show(_relatedTarget)
    })
  }

  var old = $.fn.os_ts_modal

  $.fn.os_ts_modal             = Plugin
  $.fn.os_ts_modal.Constructor = OS_TS_Modal


  // MODAL NO CONFLICT
  // =================

  $.fn.os_ts_modal.noConflict = function () {
    $.fn.os_ts_modal = old
    return this
  }


  // MODAL DATA-API
  // ==============

  $(document).on('click.bs.os_ts_modal.data-api', '[data-toggle="os_ts_modal"]', function (e) {
    var $this   = $(this)
    var href    = $this.attr('href')
    var $target = $($this.attr('data-target') || (href && href.replace(/.*(?=#[^\s]+$)/, ''))) // strip for ie7
    var option  = $target.data('bs.os_ts_modal') ? 'toggle' : $.extend({ remote: !/#/.test(href) && href }, $target.data(), $this.data())

    if ($this.is('a')) e.preventDefault()

    $target.one('show.bs.os_ts_modal', function (showEvent) {
      if (showEvent.isDefaultPrevented()) return // only register focus restorer if os_ts_modal will actually get shown
      $target.one('hidden.bs.os_ts_modal', function () {
        $this.is(':visible') && $this.trigger('focus')
      })
    })
    Plugin.call($target, option, this)
  })

}(jQuerOs);