<?php
defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

class HTML_os_cck{

  static function sort_head($title, $fieldname, $sort_arr,$task=''){
    $img_str = "";
    if($task)
        $task = "&amp;task=$task";
    $direction=$sort_arr['sorting_direction'];
    if ($sort_arr['sorting_direction'] == 'ASC') {
      $img_path = 'components/com_os_cck/images/arrow_up.png';
      $img_str = "<img src=\"$img_path\" width=\"12\" height=\"12\" border=\"0\" alt='Sorted up' />";
    } else {
      $img_path = 'components/com_os_cck/images/arrow_down.png';
      $img_str = "<img src=\"$img_path\" width=\"12\" height=\"12\" border=\"0\" alt='Sorted up' />";
    }
    $str = "<a href='" . JURI::root() . "/administrator/index.php?option=com_os_cck$task&amp;sort=$fieldname&amp;sorting_direction=$direction"."'>".
    $img_str .
    $title .
    "</a>";
    return $str;
  }

  //------------------------------------------------------------------
  static function about($avaibleUpdate){
    global $app;
    $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . JText::_('COM_OS_CCK_ADMIN_ABOUT') . "</div>";
    $app->JComponentTitle = $html;
    ?>
    <div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
    <form action="index.php" method="post" name="adminForm" id="adminForm">
    <?php if($avaibleUpdate){?>
      <span class="cck-new-version">Avaible new version.</span>
    <?php }?>
      <?php
      $options = Array('active'    => 'panel_1_id');
      echo JHtml::_('bootstrap.startTabSet', 'aboutPane', $options);
      echo JHtml::_('bootstrap.addTab', 'aboutPane', 'panel_1_id', JText::_('COM_OS_CCK_ADMIN_ABOUT_ABOUT'));
      
      ?>
      <table class="adminform">
        <tr>
          <td>
            <img src="./components/com_os_cck/images/os_cck_logo2.png" alt="OS_CCK logo"/>
          </td>
        </tr>
        <tr>
          <td>
            <h3><?PHP echo JText::_('COM_OS_CCK__HTML_ABOUT'); ?></h3>
            <?PHP echo JText::_('COM_OS_CCK_HTML_ABOUT_INTRO'); ?>
          </td>
        </tr>
      </table>
      <?php
      //******************************   tab--2 about   **************************************
      echo JHtml::_('bootstrap.endTab');
      echo JHtml::_('bootstrap.addTab', 'aboutPane', 'panel_2_id', JText::_('COM_OS_CCK_ADMIN_ABOUT_RELEASENOTE'));
      
      include_once("./components/com_os_cck/doc/releasenote.php");
      //******************************   tab--3 about--changelog.txt   ***********************
      echo JHtml::_('bootstrap.endTab');
      echo JHtml::_('bootstrap.addTab', 'aboutPane', 'panel_3_id', JText::_('COM_OS_CCK_ADMIN_ABOUT_CHANGELOG'));
      
      include_once("./components/com_os_cck/doc/changelog.html");
      echo JHtml::_('bootstrap.endTab');
      echo JHtml::_('bootstrap.endTabSet');
      ?>
    </form>
    <?php
  }
}

