<?php
defined('_JEXEC') or die('Restricted access');
/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/


class AdminViewOrders{

    static function orders($orders, $search, &$pageNav, $entity_list, $order_entity_array, $order_prices){
        global $user, $app, $doc, $db, $entityFieldLists;



        $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />".JText::_('COM_OS_CCK_SHOW_ORDERS')."</div>";
        $app->JComponentTitle = $html;
        $countOrders = count($orders);
        $app = JFactory::getApplication();
        $input = $app->input;
        $option = $input->get('option', '', 'STRING');
        $order = $input->get('order', 'ASC', '');
        $order_sring = ($order == 'ASC') ? '&order=DESC' : '&order=ASC';
 
        $optionStatus[] = JHTML::_('select.option','Pending', "Pending");
        $optionStatus[] = JHTML::_('select.option','Completed', 'Completed');
        $optionStatus[] = JHTML::_('select.option','Chargeback', 'Chargeback');
        $optionStatus[] = JHTML::_('select.option','Cancel', 'Cancel');
        $optionStatus[] = JHTML::_('select.option','Refund', 'Refund');
        ?>
        <script>
            function listItemTask(id, task, frmName){
                var form = document.adminForm;
                cb = eval( id );
                if (cb) {
                    cb.checked = true;
                    form.task.value = task;
                    form.submit();
                }
                return false;
            }

        </script>
        <form action="index.php" method="post" name="adminForm"  class="cck-orders-main"  id="adminForm" >
            <div class="list_13 filters wrapper_filters">
                <div class="search_block">
                    <input type="text" placeholder="<?php echo JText::_('COM_OS_CCK_SHOW_SEARCH'); ?>" name="search" value="<?php echo $search; ?>" class="inputbox" onChange="document.adminForm.submit();"/>
                    <button type="submit" class="cck_search_button" title="" data-original-title="Search"><span class="icon-search"></span></button>
                </div>

                <div>
                    <?php echo $entity_list; ?>
                </div>
                    
            </div>
            <div class="wrapper_filters_right">
                <div class="btn-group pull-right hidden-phone">
                    <label for="limit" class="element-invisible"><?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
                    <?php echo $pageNav->getLimitBox(); ?>
                </div>
            </div>

            <div class="admin-order-title">
                <div class="admin-order-title-checkbox">
                    <input type="checkbox" name="toggle" value="" onClick="Joomla.checkAll(this);" />
                </div>
                <div class="admin-order-title-id">
                    <a href="index.php?option=com_os_cck&task=orders&orderby=id<?php echo $order_sring; ?>">
                        <?php
                        echo JText::_("COM_OS_CCK_ORDERS_ID");?>
                    </a>
                </div>
                <div class="admin-order-title-email">
                    <a href="index.php?option=com_os_cck&task=orders&orderby=email<?php echo $order_sring; ?>">
                        <?php
                        echo JText::_("COM_OS_CCKORDERS_EMAIL");?>
                    </a>
                </div>
                <div class="admin-order-title-date">
                    <a href="index.php?option=com_os_cck&task=orders&orderby=order_date<?php echo $order_sring; ?>">
                        <?php
                        echo JText::_("COM_OS_CCK_ORDERS_DATE");?>
                    </a>
                </div>
                <div class="admin-order-title-status">
                    <a href="index.php?option=com_os_cck&task=orders&orderby=status<?php echo $order_sring; ?>">
                        <?php
                        echo JText::_("COM_OS_CCK_ORDERS_STATUS");?>
                    </a>
                </div>
                <div class="admin-order-title-price">
                    <?php echo JText::_("COM_OS_CCK_ORDERS_PRICE");?>
                </div>
                <div class="admin-order-title-paid">
                    <?php echo JText::_("COM_OS_CCK_ORDERS_PAID");?>
                </div>
                <div class="admin-order-title-downloads">
                    <?php echo JText::_("COM_OS_CCK_ORDERS_DOWNLOADS");?>
                </div>
                <div class="admin-order-title-details">
                    <?php echo JText::_("COM_OS_CCK_ORDERS_DETAILS");?>
                </div>
                <div class="admin-order-title-request">
                    <?php echo JText::_("COM_OS_CCK_ORDERS_REQUEST");?>
                </div>
            </div>

            <?php for($i = 0; $i < $countOrders; $i++) { 
                if($orders[$i]->instance_type == "Rent"){
                    $task = "edit_rent_request_instance";
                }else{
                    $task = "edit_buy_request_instance";
                }
                $order_instancies = $order_entity_array[$orders[$i]->id];
                ?>
            <div class="admin-one-order <?php echo $orders[$i]->notreaded?'admin-order-not-readed':''?>">
                <div class="admin-order-standart-fields">
                    <div class="admin-order-standart-fields-checkbox">
                        <?php echo JHTML::_('grid.id', $i,$orders[$i]->id, false, 'cb');?>
                    </div>
                    <div class="admin-order-standart-fields-id">
                        <?php echo $orders[$i]->id;?>
                    </div>
                    <div class="admin-order-standart-fields-email">
                        <?php echo $orders[$i]->user_email;?>
                    </div>
                    <div class="admin-order-standart-fields-date">
                        <?php echo $orders[$i]->order_date;?>
                    </div>
                    <div class="admin-order-standart-fields-status">
                        <?php
                        $status = $orders[$i]->status;

                            if($status == 'Completed' || $status == 'Success'){
                                $status = 'Completed';
                            }
                            $attr = 'class="inputbox input-medium" size="1"
                             onchange="return listItemTask(\'cb'.$i.'\',\'changeOrderStatus\')"';
                             
                            echo JHTML::_('select.genericlist',$optionStatus, 'order_status['.
                              $orders[$i]->id.']', $attr, 'value', 'text', $status);

                 
                     // if(($orders[$i]->order_price == $orders[$i]->paid_price) && ($status == 'Completed' || $status == 'Success') && ($orders[$i]->instance_type == 'Rent') && (!isset($orders[$i]->accept_rent)))
                     //   {
                     //        AdminRent_request::accept_rent_requests($option, array($orders[$i]->fk_request_id));
                     //        // $orders[$i]->accept_rent = 1;
                     //   } 

                            ?>
                    </div>
                    <div class="admin-order-standart-fields-price">
                        <?php echo $orders[$i]->order_price." ".$orders[$i]->order_currency;?>
                    </div>
                    <div class="admin-order-standart-fields-paid">
                        <?php echo $orders[$i]->paid_price." ".$orders[$i]->paid_currency?>
                    </div>
                    <div class="admin-order-standart-fields-downloads">
                        <?php echo $orders[$i]->number_of_downloads;?>
                    </div>
                    <div class="admin-order-standart-fields-details">
                        <a href="<?php echo 'index.php?option=com_os_cck'.
                                                '&task=orders&order_details=order_details&order_id='.$orders[$i]->id ?>">
                            <?php echo JText::_("COM_OS_CCK_ORDERS_DETAILS"); ?></a>
                    </div>
                    <div class="admin-order-standart-fields-request">
                        <a href="<?php echo 'index.php?option=com_os_cck'.
                                                '&task='.$task.'&eiid=' . $orders[$i]->fk_request_id;?>">
                            <?php echo JText::_("COM_OS_CCK_ORDERS_REQUEST"); ?></a>
                    </div>
                </div>
                <div class="admin-order-products">
                    <?php
                    $requestIstance = new os_cckEntityInstance($db);
                    $requestIstance->load($orders[$i]->fk_request_id);
                    
                    foreach ($order_instancies as $cart_item => $inst){
                        echo '<div class="admin-order-single-product">';
                        $orderInstance = new os_cckEntityInstance($db);
                        $orderInstance->load($inst);
                        $show_in_orders_fields = array();
                        
                        $fields = $entityFieldLists[$orderInstance->fk_eid];
                        foreach($fields as $field){
                            $params = new JRegistry;
                            $params->loadString($field->params);
                            if($params->get('show_in_orders', '') == 'yes'){
                                $show_in_orders_fields[] = $field;
                            }
                        }
                        
                        $calculated_price = 0;
                        $quantity = 1;
                        $not_calc_price = '';
                        $coupon = false;
//                        var_dump($order_prices);
                        foreach ($order_prices[$orders[$i]->id] as $key => $single_field){
//                            var_dump($single_field);
                            if($single_field->price_ordering == -1){
                                $field = new os_cckEntityField($db);
                                $field->load($single_field->fk_fid);

                                unset($order_prices[$orders[$i]->id][$key]);
                            }
                        }
                        
                        
                        foreach ($order_prices[$orders[$i]->id] as $single_field){
                            if($single_field->сart_item == $cart_item){
                                $field = new os_cckEntityField($db);
                                $field->load($single_field->fk_fid); 

                                if($single_field->price_type == 'base_price'){
                                      if($single_field->quantity == 0) $single_field->quantity =1;
                                      if($single_field->quantity>1) {$quantity = $single_field->quantity;}
                                      $calculated_price = $calculated_price + ($single_field->price_value * $single_field->quantity);
                                }elseif($single_field->price_type == 'val+' && $single_field->price_value != '0.00'){
                                      $calculated_price = $calculated_price + ($single_field->price_value * $quantity);
                                  }else if($single_field->price_type == 'val-' && $single_field->price_value != '0.00'){
                                      $calculated_price = $calculated_price - ($single_field->price_value * $quantity);
                                  }else if($single_field->price_type == 'percent+' && $single_field->price_value != '0.00'){
                                      $calculated_price = $calculated_price + (round($calculated_price/100 * $single_field->price_value, 2));
                                  }else if($single_field->price_type == 'percent-' && $single_field->price_value != '0.00'){
                                      $calculated_price = $calculated_price - (round($calculated_price/100 * $single_field->price_value, 2));
                                  }
                            }

                            //var_dump($single_field);
                        }
                        
                        $calculated_price = calculatedCurrency($orderInstance, $calculated_price)[0];
                        ?>
                        <div>
                            <div>Title</div>
                            <div><?php echo $orderInstance->title; ?></div>
                        </div>
                        <div>
                            <div>Price</div>
                            <div><?php echo $calculated_price ?></div>
                        </div>
                        <?php
//                        var_dump($show_in_orders_fields);
                        foreach ($show_in_orders_fields as $field){
                            $value = $orderInstance->getFieldValue($field);
                            if(isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data') && $value[0]->data == ''){
                                continue;
                            }elseif($field->field_type == 'datetime_popup' && isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data') && $value[0]->data == '0000-00-00 00:00:00'){
                                continue;
                            }
                            $print_value = '';
                            if($field->field_type == 'text_select_list'){
                                $value = (isset($value[0]->data))?$value[0]->data : '';
                                $value = json_decode($value);
                                $params = new JRegistry;
                                $params->loadString($field->params);
                                $allowed_values = $params->get("allowed_value");
                                $allowed_values = explode('\sprt', $allowed_values);
                                $tmp_val = array();

                                if(is_array($value)){

                                    foreach($value as $val){

                                        if(isset($allowed_values[$val])){
                                            $tmp_val[] = JText::_($allowed_values[$val]);
                                        }
                                    }
                                }

                                $print_value = implode(', ', $tmp_val);
                                
//                                $temp_val = json_decode($value[0]->data);
//                                if(is_array($temp_val)){
//                                    $temp_val = implode(', ', $temp_val);
//                                    $print_value = $temp_val;
//                                }
//                                var_dump(json_decode($value[0]->data));
                            }elseif(stripos($field->field_type, 'pricefield') !== false){
                                
                                continue;
                            }elseif(isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data')){
                                $print_value = $value[0]->data;
                            }
                            echo '<div><div>'.$field->field_name.'</div><div>'.$print_value.'</div></div>';
//                            var_dump($value);
                        }
                        
                        foreach ($show_in_orders_fields as $field){
                            $value = $requestIstance->getFieldValue($field);
                            if(isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data') && $value[0]->data == ''){
                                continue;
                            }elseif($field->field_type == 'datetime_popup' && isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data') && $value[0]->data == '0000-00-00 00:00:00'){
                                continue;
                            }
                            $print_value = '';
                            if($field->field_type == 'text_select_list'){
                                $value = (isset($value[0]->data))?$value[0]->data : '';
                                $value = json_decode($value);
                                $params = new JRegistry;
                                $params->loadString($field->params);
                                $allowed_values = $params->get("allowed_value");
                                $allowed_values = explode('\sprt', $allowed_values);
                                $tmp_val = array();

                                if(is_array($value)){

                                    foreach($value as $val){

                                        if(isset($allowed_values[$val])){
                                            $tmp_val[] = JText::_($allowed_values[$val]);
                                        }
                                    }
                                }

                                $print_value = implode(', ', $tmp_val);
                                
//                                $temp_val = json_decode($value[0]->data);
//                                if(is_array($temp_val)){
//                                    $temp_val = implode(', ', $temp_val);
//                                    $print_value = $temp_val;
//                                }
//                                var_dump(json_decode($value[0]->data));
                            }elseif(stripos($field->field_type, 'pricefield') !== false){
                                foreach($order_prices[$orders[$i]->id] as $single_field){
                                    if($single_field->fk_fid == $field->fid){
                                        $print_value = $single_field->price_value;
                                    }
                                }
                                
                            }elseif(isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data')){
                                $print_value = $value[0]->data;
                            }
                            echo '<div><div>'.$field->field_name.'</div><div>'.$print_value.'</div></div>';
//                            var_dump($value);
                        }
                        echo '</div>';
//                        var_dump($fields);
                    }
                    ?>
                </div>
            </div>
            <?php } ?>


            <?php echo $pageNav->getListFooter(); ?>
            <input type="hidden" name="option" value="com_os_cck" />
            <input type="hidden" name="task" value="orders" />
            <input type="hidden" name="sectionid" value="com_os_cck" />
            <input type="hidden" value="0" name="boxchecked" />
        </form><?php
    }

    static function orders_details($orders, $search, &$pageNav){
        global $user, $app, $doc, $app;
        $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />".JText::_('COM_OS_CCK_SHOW_ORDERS')."</div>";
        $app->JComponentTitle = $html;
        $countOrders = count($orders);
        $orderId = protectInjectionWithoutQuote('order_id');
        $optionStatus[] = JHTML::_('select.option','Pending', "Pending");
        $optionStatus[] = JHTML::_('select.option','Completed', 'Completed');
        ?>
        <form action="index.php" method="post" name="adminForm"  class="cck-orders-details-main"  id="adminForm" >
            <table cellpadding="4" cellspacing="0" border="0" width="100%" class="list_13">
                <tr>
                    <td><?php echo JText::_("COM_OS_CCK_SHOW_SEARCH"); ?></td>
                    <td><input type="text" name="search" value="<?php echo $search; ?>"
                               class="inputbox" onChange="document.adminForm.submit();" /></td>
                    <td>
                        <div class="btn-group pull-right hidden-phone">
                            <label for="limit" class="element-invisible"><?php
                             echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>

                          <?php echo $pageNav->getLimitBox(); ?>
                        </div>
                    </td>
                </tr>
            </table>
            <table cellpadding="4" cellspacing="0" width="100%" class="table adminlist_05">
                <tr>
                    <th align = "center" nowrap="nowrap" class="title" colspan="">
                        <a href="<?php echo 'index.php?option=com_os_cck&task=orders'.
                                    '&orderby=user&order_details=order_details&order_id='.$orderId?>"><?php echo "User";?></a>
                    </th>
                    <th align = "center" nowrap="nowrap" class="title" colspan=""><?php echo "Username";?></th>
                    <th align = "center" nowrap="nowrap" class="title" colspan="">
                        <a href="<?php echo 'index.php?option=com_os_cck&task=orders'.
                                    '&orderby=email&order_details=order_details&order_id='.$orderId ?>">
                            <?php
                            echo JText::_("COM_OS_CCKORDERS_EMAIL");?></a>
                    </th>
                    <th align = "center" nowrap="nowrap" class="title" colspan="">
                        <a href="<?php echo 'index.php?option=com_os_cck&task=orders'.
                                    '&orderby=order_date&order_details=order_details&order_id='.
                                    $orderId ?>"><?php echo JText::_("COM_OS_CCK_ORDERS_DATE");?></a>
                    </th>
                    <th align = "center" nowrap="nowrap" class="title" colspan="">
                        <a href="<?php echo 'index.php?option=com_os_cck&task=orders'.
                         '&orderby=status&order_details=order_details&order_id='.$orderId ?>"><?php
                          echo JText::_("COM_OS_CCK_ORDERS_STATUS");?></a>
                    </th>
                    <th align = "center" nowrap="nowrap" class="title" colspan=""><?php echo JText::_("COM_OS_CCK_ORDERS_TITLE");?></th>
                    <th align = "center" nowrap="nowrap" class="title" colspan=""><?php echo JText::_("COM_OS_CCK_ORDERS_PRICE");?></th>
                    <th align = "center" nowrap="nowrap" class="title" colspan=""><?php echo JText::_("COM_OS_CCK_ORDERS_PAID");?></th>
                    <th align = "center" nowrap="nowrap" class="title" colspan=""><?php echo JText::_("COM_OS_CCK_ORDERS_DETAILS");?></th>
                    <th align = "center" nowrap="nowrap" class="title" colspan=""><?php echo JText::_("COM_OS_CCK_LABEL_INPUT_COMMENT");?></th>
                </tr>
                <?php
                for($i = 0; $i < $countOrders; $i++) {
                    if($orders[$i]->instance_type == "Rent"){
                        $task = "edit_rent_request_instance";
                    }else{
                        $task = "edit_buy_request_instance";
                    }
                    
                    $payment_details = unserialize($orders[$i]->payment_details);
                    $details_text='';
                    if($orders[$i]->txn_type)
                        $details_text = JText::_("COM_OS_CCK_ORDERS_DET_ACCEPT").$orders[$i]->txn_type;
                    if(!empty($payment_details)){
                        if(isset($payment_details['view']))
                            $details_text .= '<br>'.JText::_("COM_OS_CCK_ORDERS_DET_SYSTEM").$payment_details['view'];
                        if(isset($payment_details['payer_email']))
                            $details_text .= '<br>'.JText::_("COM_OS_CCK_ORDERS_DET_EMAIL").'<br>'.$payment_details['payer_email'];
                        if(isset($payment_details['pending_reason']))
                            $details_text .= '<br>'.JText::_("COM_OS_CCK_ORDERS_DET_REASON").'<br>'.$payment_details['pending_reason'];
                    }
                    ?>
                    <tr>
                        <td>
                            <?php if(!isset($orders[$i]->user_name) && $orders[$i]->user_name == '') {
                                echo JText::_("COM_OS_CCK_LABEL_ANONYMOUS");
                            } else {
                                echo $orders[$i]->user_name;
                            }?>
                        </td>
                        <td><?php if(!isset($orders[$i]->username) && $orders[$i]->username == '' ) {
                                echo JText::_("COM_OS_CCK_LABEL_ANONYMOUS");
                            } else {
                                echo $orders[$i]->username;
                            }?>
                        </td>
                        <td><?php echo $orders[$i]->user_email;?></td>
                        <td><?php echo $orders[$i]->order_date;?></td>
                        <td>
                            <?php
                            echo $orders[$i]->status;
                            ?>
                        </td>
                        <td>
                            <a href="<?php echo 'index.php?option=com_os_cck'.
                                                '&task='.$task.'&eiid=' . $orders[$i]->fk_request_id;?>">
                            <?php echo $orders[$i]->instance_title;?></a>
                            <!-- <a href="index.php?option=com_os_cck&task=show_rent_request_instances&search=<?php echo $orders[$i]->fk_request_id?>">
                                <?php echo $orders[$i]->instance_title;?>
                            </a> -->
                        </td>
                        <td><?php echo $orders[$i]->i_price." ".$orders[$i]->i_unit;?></td>
                        <td><?php echo $orders[$i]->order_price." ".$orders[$i]->order_currency;?></td>
                        <td><?php echo $details_text?></td>
                        <td><?php echo $orders[$i]->comment?></td>
                    </tr>
                <?php } ?>
            </table>
            <?php echo $pageNav->getListFooter(); ?>
            <input type="hidden" name="option" value="com_os_cck" />
            <input type="hidden" name="task" value="orders" />
            <input type="hidden" name="order_id" value="<?php echo $orderId;?>" />
            <input type="hidden" name="order_details" value="order_details" />
            <input type="hidden" name="sectionid" value="com_os_cck" />
            <input type="hidden" value="0" name="boxchecked" />
        </form><?php
    }
    
    static function changeOrderStatus($orderId, $status){
        global $app;
        
        $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />".JText::_('COM_OS_CCK_SHOW_ORDERS')."</div>";
        $app->JComponentTitle = $html;
        ?>
        <h2><?php echo JText::_("COM_OS_CCK_LABEL_INPUT_ORDER_DETAILS"); ?>:</h2>
        <br>
        <form action="index.php" method="post" name="adminForm"  class="cck-orders-main"  id="adminForm" >
            <h3><?php echo JText::_("COM_OS_CCK_LABEL_INPUT_COMMENT"); ?></h3>
            <textarea class="order_comment" type="text" name="comment" rows="5" style="width: 350px;"></textarea>
            <input type="hidden" name="option" value="com_os_cck" />
            <input type="hidden" name="task" value="updateOrderStatus" />
            <input type="hidden" name="orderId" value="<?php echo $orderId;?>" />
            <input type="hidden" name="status" value="<?php echo $status;?>" />
            <br>
            <input type="submit" value="Change status"/>
        </form>

    <?php }
}